/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.Hex;
import com.android.org.conscrypt.PinEntryException;
import com.android.org.conscrypt.PinFailureLogger;
import com.android.org.conscrypt.TrustedCertificateStore;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PinListEntry {
    private final String cn;
    private final boolean enforcing;
    private final Set<String> pinnedFingerprints = new HashSet<String>();
    private final TrustedCertificateStore certStore;

    public String getCommonName() {
        return this.cn;
    }

    public boolean getEnforcing() {
        return this.enforcing;
    }

    public PinListEntry(String entry, TrustedCertificateStore store) throws PinEntryException {
        if (entry == null) {
            throw new NullPointerException("entry == null");
        }
        this.certStore = store;
        String[] values = entry.split("[=,|]");
        if (values.length < 3) {
            throw new PinEntryException("Received malformed pin entry");
        }
        this.cn = values[0];
        this.enforcing = PinListEntry.enforcementValueFromString(values[1]);
        this.addPins(Arrays.copyOfRange(values, 2, values.length));
    }

    private static boolean enforcementValueFromString(String val) throws PinEntryException {
        if (val.equals("true")) {
            return true;
        }
        if (val.equals("false")) {
            return false;
        }
        throw new PinEntryException("Enforcement status is not a valid value");
    }

    public boolean isChainValid(List<X509Certificate> chain) {
        boolean containsUserCert = this.chainContainsUserCert(chain);
        if (!containsUserCert) {
            for (X509Certificate cert : chain) {
                String fingerprint = PinListEntry.getFingerprint(cert);
                if (!this.pinnedFingerprints.contains(fingerprint)) continue;
                return true;
            }
        }
        this.logPinFailure(chain, containsUserCert);
        return !this.enforcing || containsUserCert;
    }

    private static String getFingerprint(X509Certificate cert) {
        try {
            MessageDigest dgst = MessageDigest.getInstance("SHA512");
            byte[] encoded = cert.getPublicKey().getEncoded();
            byte[] fingerprint = dgst.digest(encoded);
            return Hex.bytesToHexString(fingerprint);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void addPins(String[] pins) {
        for (String pin : pins) {
            PinListEntry.validatePin(pin);
        }
        Collections.addAll(this.pinnedFingerprints, pins);
    }

    private static void validatePin(String pin) {
        if (pin.length() != 128) {
            throw new IllegalArgumentException("Pin is not a valid length");
        }
        try {
            new BigInteger(pin, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Pin is not a valid hex string", e);
        }
    }

    private boolean chainContainsUserCert(List<X509Certificate> chain) {
        if (this.certStore == null) {
            return false;
        }
        for (X509Certificate cert : chain) {
            if (!this.certStore.isUserAddedCertificate(cert)) continue;
            return true;
        }
        return false;
    }

    private void logPinFailure(List<X509Certificate> chain, boolean containsUserCert) {
        PinFailureLogger.log(this.cn, containsUserCert, this.enforcing, chain);
    }
}

