/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AbstractSessionContext;
import com.android.org.conscrypt.AddressUtils;
import com.android.org.conscrypt.ClientSessionContext;
import com.android.org.conscrypt.DuckTypedPSKKeyManager;
import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLExtendedSessionImpl;
import com.android.org.conscrypt.OpenSSLKey;
import com.android.org.conscrypt.OpenSSLSessionImpl;
import com.android.org.conscrypt.OpenSSLX509Certificate;
import com.android.org.conscrypt.PSKKeyManager;
import com.android.org.conscrypt.ServerSessionContext;
import com.android.org.conscrypt.ct.CTLogStoreImpl;
import com.android.org.conscrypt.ct.CTVerifier;
import com.android.org.conscrypt.util.EmptyArray;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class SSLParametersImpl
implements Cloneable {
    private static volatile X509KeyManager defaultX509KeyManager;
    private static volatile X509TrustManager defaultX509TrustManager;
    private static volatile SecureRandom defaultSecureRandom;
    private static volatile SSLParametersImpl defaultParameters;
    private static volatile CTVerifier defaultCTVerifier;
    private final ClientSessionContext clientSessionContext;
    private final ServerSessionContext serverSessionContext;
    private final X509KeyManager x509KeyManager;
    private final PSKKeyManager pskKeyManager;
    private final X509TrustManager x509TrustManager;
    private SecureRandom secureRandom;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;
    private boolean client_mode = true;
    private boolean need_client_auth = false;
    private boolean want_client_auth = false;
    private boolean enable_session_creation = true;
    private String endpointIdentificationAlgorithm;
    private boolean useCipherSuitesOrder;
    private boolean ctVerificationEnabled;
    private CTVerifier ctVerifier;
    private byte[] sctExtension;
    private byte[] ocspResponse;
    byte[] npnProtocols;
    byte[] alpnProtocols;
    boolean useSessionTickets;
    private Boolean useSni;
    boolean channelIdEnabled;
    private static final String KEY_TYPE_RSA = "RSA";
    private static final String KEY_TYPE_DH_RSA = "DH_RSA";
    private static final String KEY_TYPE_EC = "EC";
    private static final String KEY_TYPE_EC_EC = "EC_EC";
    private static final String KEY_TYPE_EC_RSA = "EC_RSA";

    protected SSLParametersImpl(KeyManager[] kms, TrustManager[] tms, SecureRandom sr, ClientSessionContext clientSessionContext, ServerSessionContext serverSessionContext, String[] protocols) throws KeyManagementException {
        this.serverSessionContext = serverSessionContext;
        this.clientSessionContext = clientSessionContext;
        if (kms == null) {
            this.x509KeyManager = SSLParametersImpl.getDefaultX509KeyManager();
            this.pskKeyManager = null;
        } else {
            this.x509KeyManager = SSLParametersImpl.findFirstX509KeyManager(kms);
            this.pskKeyManager = SSLParametersImpl.findFirstPSKKeyManager(kms);
        }
        this.x509TrustManager = tms == null ? SSLParametersImpl.getDefaultX509TrustManager() : SSLParametersImpl.findFirstX509TrustManager(tms);
        this.secureRandom = sr;
        this.enabledProtocols = (String[])NativeCrypto.checkEnabledProtocols(protocols == null ? NativeCrypto.DEFAULT_PROTOCOLS : protocols).clone();
        boolean x509CipherSuitesNeeded = this.x509KeyManager != null || this.x509TrustManager != null;
        boolean pskCipherSuitesNeeded = this.pskKeyManager != null;
        this.enabledCipherSuites = SSLParametersImpl.getDefaultCipherSuites(x509CipherSuitesNeeded, pskCipherSuitesNeeded);
    }

    protected static SSLParametersImpl getDefault() throws KeyManagementException {
        SSLParametersImpl result = defaultParameters;
        if (result == null) {
            defaultParameters = result = new SSLParametersImpl(null, null, null, new ClientSessionContext(), new ServerSessionContext(), null);
        }
        return (SSLParametersImpl)result.clone();
    }

    public AbstractSessionContext getSessionContext() {
        return this.client_mode ? this.clientSessionContext : this.serverSessionContext;
    }

    protected ServerSessionContext getServerSessionContext() {
        return this.serverSessionContext;
    }

    protected ClientSessionContext getClientSessionContext() {
        return this.clientSessionContext;
    }

    protected X509KeyManager getX509KeyManager() {
        return this.x509KeyManager;
    }

    protected PSKKeyManager getPSKKeyManager() {
        return this.pskKeyManager;
    }

    protected X509TrustManager getX509TrustManager() {
        return this.x509TrustManager;
    }

    protected SecureRandom getSecureRandom() {
        if (this.secureRandom != null) {
            return this.secureRandom;
        }
        SecureRandom result = defaultSecureRandom;
        if (result == null) {
            defaultSecureRandom = result = new SecureRandom();
        }
        this.secureRandom = result;
        return this.secureRandom;
    }

    protected SecureRandom getSecureRandomMember() {
        return this.secureRandom;
    }

    protected CTVerifier getCTVerifier() {
        if (this.ctVerifier != null) {
            return this.ctVerifier;
        }
        CTVerifier result = defaultCTVerifier;
        if (result == null) {
            defaultCTVerifier = result = new CTVerifier(new CTLogStoreImpl());
        }
        this.ctVerifier = result;
        return this.ctVerifier;
    }

    protected String[] getEnabledCipherSuites() {
        return (String[])this.enabledCipherSuites.clone();
    }

    protected void setEnabledCipherSuites(String[] cipherSuites) {
        this.enabledCipherSuites = (String[])NativeCrypto.checkEnabledCipherSuites(cipherSuites).clone();
    }

    protected String[] getEnabledProtocols() {
        return (String[])this.enabledProtocols.clone();
    }

    protected void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = (String[])NativeCrypto.checkEnabledProtocols(protocols).clone();
    }

    protected void setUseClientMode(boolean mode) {
        this.client_mode = mode;
    }

    protected boolean getUseClientMode() {
        return this.client_mode;
    }

    protected void setNeedClientAuth(boolean need) {
        this.need_client_auth = need;
        this.want_client_auth = false;
    }

    protected boolean getNeedClientAuth() {
        return this.need_client_auth;
    }

    protected void setWantClientAuth(boolean want) {
        this.want_client_auth = want;
        this.need_client_auth = false;
    }

    protected boolean getWantClientAuth() {
        return this.want_client_auth;
    }

    protected void setEnableSessionCreation(boolean flag) {
        this.enable_session_creation = flag;
    }

    protected boolean getEnableSessionCreation() {
        return this.enable_session_creation;
    }

    protected void setUseSni(boolean flag) {
        this.useSni = flag;
    }

    protected boolean getUseSni() {
        return this.useSni != null ? this.useSni.booleanValue() : this.isSniEnabledByDefault();
    }

    public void setCTVerifier(CTVerifier verifier) {
        this.ctVerifier = verifier;
    }

    public void setCTVerificationEnabled(boolean enabled) {
        this.ctVerificationEnabled = enabled;
    }

    public void setSCTExtension(byte[] extension) {
        this.sctExtension = extension;
    }

    public void setOCSPResponse(byte[] response) {
        this.ocspResponse = response;
    }

    static byte[][] encodeIssuerX509Principals(X509Certificate[] certificates) throws CertificateEncodingException {
        byte[][] principalBytes = new byte[certificates.length][];
        for (int i = 0; i < certificates.length; ++i) {
            principalBytes[i] = certificates[i].getIssuerX500Principal().getEncoded();
        }
        return principalBytes;
    }

    private static OpenSSLX509Certificate[] createCertChain(long[] certificateRefs) throws IOException {
        if (certificateRefs == null) {
            return null;
        }
        OpenSSLX509Certificate[] certificates = new OpenSSLX509Certificate[certificateRefs.length];
        for (int i = 0; i < certificateRefs.length; ++i) {
            certificates[i] = new OpenSSLX509Certificate(certificateRefs[i]);
        }
        return certificates;
    }

    OpenSSLSessionImpl getSessionToReuse(long sslNativePointer, String hostname, int port) throws SSLException {
        SSLSession cachedSession;
        OpenSSLSessionImpl sessionToReuse = null;
        if (this.client_mode && (cachedSession = this.getCachedClientSession(this.clientSessionContext, hostname, port)) != null) {
            if (cachedSession instanceof OpenSSLSessionImpl) {
                sessionToReuse = (OpenSSLSessionImpl)cachedSession;
            } else if (cachedSession instanceof OpenSSLExtendedSessionImpl) {
                sessionToReuse = ((OpenSSLExtendedSessionImpl)cachedSession).getDelegate();
            }
            if (sessionToReuse != null) {
                NativeCrypto.SSL_set_session(sslNativePointer, sessionToReuse.sslSessionNativePointer);
            }
        }
        return sessionToReuse;
    }

    void setTlsChannelId(long sslNativePointer, OpenSSLKey channelIdPrivateKey) throws SSLHandshakeException, SSLException {
        if (this.channelIdEnabled) {
            if (this.client_mode) {
                if (channelIdPrivateKey == null) {
                    throw new SSLHandshakeException("Invalid TLS channel ID key specified");
                }
                NativeCrypto.SSL_set1_tls_channel_id(sslNativePointer, channelIdPrivateKey.getNativeRef());
            } else {
                NativeCrypto.SSL_enable_tls_channel_id(sslNativePointer);
            }
        }
    }

    void setCertificate(long sslNativePointer, String alias) throws CertificateEncodingException, SSLException {
        OpenSSLKey key;
        if (alias == null) {
            return;
        }
        X509KeyManager keyManager = this.getX509KeyManager();
        if (keyManager == null) {
            return;
        }
        PrivateKey privateKey = keyManager.getPrivateKey(alias);
        if (privateKey == null) {
            return;
        }
        X509Certificate[] certificates = keyManager.getCertificateChain(alias);
        if (certificates == null) {
            return;
        }
        PublicKey publicKey = certificates.length > 0 ? certificates[0].getPublicKey() : null;
        OpenSSLX509Certificate[] openSslCerts = new OpenSSLX509Certificate[certificates.length];
        long[] x509refs = new long[certificates.length];
        for (int i = 0; i < certificates.length; ++i) {
            OpenSSLX509Certificate openSslCert;
            openSslCerts[i] = openSslCert = OpenSSLX509Certificate.fromCertificate(certificates[i]);
            x509refs[i] = openSslCert.getContext();
        }
        NativeCrypto.SSL_use_certificate(sslNativePointer, x509refs);
        try {
            key = OpenSSLKey.fromPrivateKeyForTLSStackOnly(privateKey, publicKey);
            NativeCrypto.SSL_use_PrivateKey(sslNativePointer, key.getNativeRef());
        }
        catch (InvalidKeyException e) {
            throw new SSLException(e);
        }
        if (!key.isWrapped()) {
            NativeCrypto.SSL_check_private_key(sslNativePointer);
        }
    }

    void setSSLParameters(long sslCtxNativePointer, long sslNativePointer, AliasChooser chooser, PSKCallbacks pskCallbacks, String sniHostname) throws SSLException, IOException {
        PSKKeyManager pskKeyManager;
        if (this.npnProtocols != null) {
            NativeCrypto.SSL_CTX_enable_npn(sslCtxNativePointer);
        }
        if (this.client_mode && this.alpnProtocols != null) {
            NativeCrypto.SSL_set_alpn_protos(sslNativePointer, this.alpnProtocols);
        }
        NativeCrypto.setEnabledProtocols(sslNativePointer, this.enabledProtocols);
        NativeCrypto.setEnabledCipherSuites(sslNativePointer, this.enabledCipherSuites);
        if (!this.client_mode) {
            HashSet<String> keyTypes = new HashSet<String>();
            for (long sslCipherNativePointer : NativeCrypto.SSL_get_ciphers(sslNativePointer)) {
                String keyType = SSLParametersImpl.getServerX509KeyType(sslCipherNativePointer);
                if (keyType == null) continue;
                keyTypes.add(keyType);
            }
            X509KeyManager keyManager = this.getX509KeyManager();
            if (keyManager != null) {
                for (String keyType : keyTypes) {
                    try {
                        this.setCertificate(sslNativePointer, chooser.chooseServerAlias(this.x509KeyManager, keyType));
                    }
                    catch (CertificateEncodingException e) {
                        throw new IOException(e);
                    }
                }
            }
            if (this.sctExtension != null) {
                NativeCrypto.SSL_CTX_set_signed_cert_timestamp_list(sslCtxNativePointer, this.sctExtension);
            }
            if (this.ocspResponse != null) {
                NativeCrypto.SSL_CTX_set_ocsp_response(sslCtxNativePointer, this.ocspResponse);
            }
            NativeCrypto.SSL_set_options(sslNativePointer, 0x400000L);
        }
        if ((pskKeyManager = this.getPSKKeyManager()) != null) {
            boolean pskEnabled = false;
            for (String enabledCipherSuite : this.enabledCipherSuites) {
                if (enabledCipherSuite == null || !enabledCipherSuite.contains("PSK")) continue;
                pskEnabled = true;
                break;
            }
            if (pskEnabled) {
                if (this.client_mode) {
                    NativeCrypto.set_SSL_psk_client_callback_enabled(sslNativePointer, true);
                } else {
                    NativeCrypto.set_SSL_psk_server_callback_enabled(sslNativePointer, true);
                    String identityHint = pskCallbacks.chooseServerPSKIdentityHint(pskKeyManager);
                    NativeCrypto.SSL_use_psk_identity_hint(sslNativePointer, identityHint);
                }
            }
        }
        if (this.useSessionTickets) {
            NativeCrypto.SSL_clear_options(sslNativePointer, 16384L);
        }
        if (this.getUseSni() && AddressUtils.isValidSniHostname(sniHostname)) {
            NativeCrypto.SSL_set_tlsext_host_name(sslNativePointer, sniHostname);
        }
        NativeCrypto.SSL_set_mode(sslNativePointer, 256L);
        boolean enableSessionCreation = this.getEnableSessionCreation();
        if (!enableSessionCreation) {
            NativeCrypto.SSL_set_session_creation_enabled(sslNativePointer, enableSessionCreation);
        }
    }

    private boolean isSniEnabledByDefault() {
        String enableSNI = System.getProperty("jsse.enableSNIExtension", "true");
        if ("true".equalsIgnoreCase(enableSNI)) {
            return true;
        }
        if ("false".equalsIgnoreCase(enableSNI)) {
            return false;
        }
        throw new RuntimeException("Can only set \"jsse.enableSNIExtension\" to \"true\" or \"false\"");
    }

    void setCertificateValidation(long sslNativePointer) throws IOException {
        if (!this.client_mode) {
            X509TrustManager trustManager;
            X509Certificate[] issuers;
            boolean certRequested;
            if (this.getNeedClientAuth()) {
                NativeCrypto.SSL_set_verify(sslNativePointer, 3);
                certRequested = true;
            } else if (this.getWantClientAuth()) {
                NativeCrypto.SSL_set_verify(sslNativePointer, 1);
                certRequested = true;
            } else {
                NativeCrypto.SSL_set_verify(sslNativePointer, 0);
                certRequested = false;
            }
            if (certRequested && (issuers = (trustManager = this.getX509TrustManager()).getAcceptedIssuers()) != null && issuers.length != 0) {
                byte[][] issuersBytes;
                try {
                    issuersBytes = SSLParametersImpl.encodeIssuerX509Principals(issuers);
                }
                catch (CertificateEncodingException e) {
                    throw new IOException("Problem encoding principals", e);
                }
                NativeCrypto.SSL_set_client_CA_list(sslNativePointer, issuersBytes);
            }
        }
    }

    OpenSSLSessionImpl setupSession(long sslSessionNativePointer, long sslNativePointer, OpenSSLSessionImpl sessionToReuse, String hostname, int port, boolean handshakeCompleted) throws IOException {
        OpenSSLSessionImpl sslSession = null;
        if (sessionToReuse != null && NativeCrypto.SSL_session_reused(sslNativePointer)) {
            sslSession = sessionToReuse;
            sslSession.lastAccessedTime = System.currentTimeMillis();
            NativeCrypto.SSL_SESSION_free(sslSessionNativePointer);
        } else {
            if (!this.getEnableSessionCreation()) {
                throw new IllegalStateException("SSL Session may not be created");
            }
            X509Certificate[] localCertificates = SSLParametersImpl.createCertChain(NativeCrypto.SSL_get_certificate(sslNativePointer));
            X509Certificate[] peerCertificates = SSLParametersImpl.createCertChain(NativeCrypto.SSL_get_peer_cert_chain(sslNativePointer));
            sslSession = new OpenSSLSessionImpl(sslSessionNativePointer, localCertificates, peerCertificates, hostname, port, this.getSessionContext());
            if (handshakeCompleted) {
                this.getSessionContext().putSession(sslSession);
            }
        }
        return sslSession;
    }

    void chooseClientCertificate(byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals, long sslNativePointer, AliasChooser chooser) throws SSLException, CertificateEncodingException {
        X500Principal[] issuers;
        Set<String> keyTypesSet = SSLParametersImpl.getSupportedClientKeyTypes(keyTypeBytes);
        String[] keyTypes = keyTypesSet.toArray(new String[keyTypesSet.size()]);
        if (asn1DerEncodedPrincipals == null) {
            issuers = null;
        } else {
            issuers = new X500Principal[asn1DerEncodedPrincipals.length];
            for (int i = 0; i < asn1DerEncodedPrincipals.length; ++i) {
                issuers[i] = new X500Principal(asn1DerEncodedPrincipals[i]);
            }
        }
        X509KeyManager keyManager = this.getX509KeyManager();
        String alias = keyManager != null ? chooser.chooseClientAlias(keyManager, issuers, keyTypes) : null;
        this.setCertificate(sslNativePointer, alias);
    }

    int clientPSKKeyRequested(String identityHint, byte[] identityBytesOut, byte[] key, PSKCallbacks pskCallbacks) {
        byte[] identityBytes;
        PSKKeyManager pskKeyManager = this.getPSKKeyManager();
        if (pskKeyManager == null) {
            return 0;
        }
        String identity = pskCallbacks.chooseClientPSKIdentity(pskKeyManager, identityHint);
        if (identity == null) {
            identity = "";
            identityBytes = EmptyArray.BYTE;
        } else if (identity.isEmpty()) {
            identityBytes = EmptyArray.BYTE;
        } else {
            try {
                identityBytes = identity.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 encoding not supported", e);
            }
        }
        if (identityBytes.length + 1 > identityBytesOut.length) {
            return 0;
        }
        if (identityBytes.length > 0) {
            System.arraycopy((byte[])identityBytes, (int)0, (byte[])identityBytesOut, (int)0, (int)identityBytes.length);
        }
        identityBytesOut[identityBytes.length] = 0;
        SecretKey secretKey = pskCallbacks.getPSKKey(pskKeyManager, identityHint, identity);
        byte[] secretKeyBytes = secretKey.getEncoded();
        if (secretKeyBytes == null) {
            return 0;
        }
        if (secretKeyBytes.length > key.length) {
            return 0;
        }
        System.arraycopy((byte[])secretKeyBytes, (int)0, (byte[])key, (int)0, (int)secretKeyBytes.length);
        return secretKeyBytes.length;
    }

    int serverPSKKeyRequested(String identityHint, String identity, byte[] key, PSKCallbacks pskCallbacks) {
        PSKKeyManager pskKeyManager = this.getPSKKeyManager();
        if (pskKeyManager == null) {
            return 0;
        }
        SecretKey secretKey = pskCallbacks.getPSKKey(pskKeyManager, identityHint, identity);
        byte[] secretKeyBytes = secretKey.getEncoded();
        if (secretKeyBytes == null) {
            return 0;
        }
        if (secretKeyBytes.length > key.length) {
            return 0;
        }
        System.arraycopy((byte[])secretKeyBytes, (int)0, (byte[])key, (int)0, (int)secretKeyBytes.length);
        return secretKeyBytes.length;
    }

    SSLSession getCachedClientSession(ClientSessionContext sessionContext, String hostName, int port) {
        if (hostName == null) {
            return null;
        }
        SSLSession session = sessionContext.getSession(hostName, port);
        if (session == null) {
            return null;
        }
        String protocol = session.getProtocol();
        boolean protocolFound = false;
        for (String enabledProtocol : this.enabledProtocols) {
            if (!protocol.equals(enabledProtocol)) continue;
            protocolFound = true;
            break;
        }
        if (!protocolFound) {
            return null;
        }
        String cipherSuite = session.getCipherSuite();
        boolean cipherSuiteFound = false;
        for (String enabledCipherSuite : this.enabledCipherSuites) {
            if (!cipherSuite.equals(enabledCipherSuite)) continue;
            cipherSuiteFound = true;
            break;
        }
        if (!cipherSuiteFound) {
            return null;
        }
        return session;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static X509KeyManager getDefaultX509KeyManager() throws KeyManagementException {
        X509KeyManager result = defaultX509KeyManager;
        if (result == null) {
            defaultX509KeyManager = result = SSLParametersImpl.createDefaultX509KeyManager();
        }
        return result;
    }

    private static X509KeyManager createDefaultX509KeyManager() throws KeyManagementException {
        try {
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(null, null);
            Object[] kms = kmf.getKeyManagers();
            X509KeyManager result = SSLParametersImpl.findFirstX509KeyManager((KeyManager[])kms);
            if (result == null) {
                throw new KeyManagementException("No X509KeyManager among default KeyManagers: " + Arrays.toString(kms));
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagementException(e);
        }
        catch (KeyStoreException e) {
            throw new KeyManagementException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new KeyManagementException(e);
        }
    }

    private static X509KeyManager findFirstX509KeyManager(KeyManager[] kms) {
        for (KeyManager km : kms) {
            if (!(km instanceof X509KeyManager)) continue;
            return (X509KeyManager)km;
        }
        return null;
    }

    private static PSKKeyManager findFirstPSKKeyManager(KeyManager[] kms) {
        for (KeyManager km : kms) {
            if (km instanceof PSKKeyManager) {
                return (PSKKeyManager)km;
            }
            if (km == null) continue;
            try {
                return DuckTypedPSKKeyManager.getInstance(km);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static X509TrustManager getDefaultX509TrustManager() throws KeyManagementException {
        X509TrustManager result = defaultX509TrustManager;
        if (result == null) {
            defaultX509TrustManager = result = SSLParametersImpl.createDefaultX509TrustManager();
        }
        return result;
    }

    private static X509TrustManager createDefaultX509TrustManager() throws KeyManagementException {
        try {
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init((KeyStore)null);
            Object[] tms = tmf.getTrustManagers();
            X509TrustManager trustManager = SSLParametersImpl.findFirstX509TrustManager((TrustManager[])tms);
            if (trustManager == null) {
                throw new KeyManagementException("No X509TrustManager in among default TrustManagers: " + Arrays.toString(tms));
            }
            return trustManager;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagementException(e);
        }
        catch (KeyStoreException e) {
            throw new KeyManagementException(e);
        }
    }

    private static X509TrustManager findFirstX509TrustManager(TrustManager[] tms) {
        for (TrustManager tm : tms) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
    }

    public boolean getUseCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }

    public void setUseCipherSuitesOrder(boolean useCipherSuitesOrder) {
        this.useCipherSuitesOrder = useCipherSuitesOrder;
    }

    private static String getServerX509KeyType(long sslCipherNative) throws SSLException {
        String kx_name = NativeCrypto.SSL_CIPHER_get_kx_name(sslCipherNative);
        if (kx_name.equals(KEY_TYPE_RSA) || kx_name.equals("DHE_RSA") || kx_name.equals("ECDHE_RSA")) {
            return KEY_TYPE_RSA;
        }
        if (kx_name.equals("ECDHE_ECDSA")) {
            return KEY_TYPE_EC;
        }
        if (kx_name.equals("ECDH_RSA")) {
            return KEY_TYPE_EC_RSA;
        }
        if (kx_name.equals("ECDH_ECDSA")) {
            return KEY_TYPE_EC_EC;
        }
        if (kx_name.equals(KEY_TYPE_DH_RSA)) {
            return KEY_TYPE_DH_RSA;
        }
        return null;
    }

    public static String getClientKeyType(byte clientCertificateType) {
        switch (clientCertificateType) {
            case 1: {
                return KEY_TYPE_RSA;
            }
            case 3: {
                return KEY_TYPE_DH_RSA;
            }
            case 64: {
                return KEY_TYPE_EC;
            }
            case 65: {
                return KEY_TYPE_EC_RSA;
            }
            case 66: {
                return KEY_TYPE_EC_EC;
            }
        }
        return null;
    }

    public static Set<String> getSupportedClientKeyTypes(byte[] clientCertificateTypes) {
        HashSet<String> result = new HashSet<String>(clientCertificateTypes.length);
        for (byte keyTypeCode : clientCertificateTypes) {
            String keyType = SSLParametersImpl.getClientKeyType(keyTypeCode);
            if (keyType == null) continue;
            result.add(keyType);
        }
        return result;
    }

    private static String[] getDefaultCipherSuites(boolean x509CipherSuitesNeeded, boolean pskCipherSuitesNeeded) {
        if (x509CipherSuitesNeeded) {
            if (pskCipherSuitesNeeded) {
                return SSLParametersImpl.concat(NativeCrypto.DEFAULT_PSK_CIPHER_SUITES, NativeCrypto.DEFAULT_X509_CIPHER_SUITES, {"TLS_EMPTY_RENEGOTIATION_INFO_SCSV"});
            }
            return SSLParametersImpl.concat(NativeCrypto.DEFAULT_X509_CIPHER_SUITES, {"TLS_EMPTY_RENEGOTIATION_INFO_SCSV"});
        }
        if (pskCipherSuitesNeeded) {
            return SSLParametersImpl.concat(NativeCrypto.DEFAULT_PSK_CIPHER_SUITES, {"TLS_EMPTY_RENEGOTIATION_INFO_SCSV"});
        }
        return new String[]{"TLS_EMPTY_RENEGOTIATION_INFO_SCSV"};
    }

    private static String[] concat(String[] ... arrays) {
        int resultLength = 0;
        for (String[] array2 : arrays) {
            resultLength += array2.length;
        }
        String[] result = new String[resultLength];
        int resultOffset = 0;
        for (String[] array3 : arrays) {
            System.arraycopy(array3, 0, result, resultOffset, array3.length);
            resultOffset += array3.length;
        }
        return result;
    }

    public boolean isCTVerificationEnabled(String hostname) {
        if (hostname == null) {
            return false;
        }
        if (this.ctVerificationEnabled) {
            return true;
        }
        String property = Security.getProperty("conscrypt.ct.enable");
        if (property == null || !Boolean.valueOf(property.toLowerCase()).booleanValue()) {
            return false;
        }
        List<String> parts = Arrays.asList(hostname.split("\\."));
        Collections.reverse(parts);
        boolean enable = false;
        String propertyName = "conscrypt.ct.enforce";
        for (String part : parts) {
            property = Security.getProperty(propertyName + ".*");
            if (property != null) {
                enable = Boolean.valueOf(property.toLowerCase());
            }
            propertyName = propertyName + "." + part;
        }
        property = Security.getProperty(propertyName);
        if (property != null) {
            enable = Boolean.valueOf(property.toLowerCase());
        }
        return enable;
    }

    public static interface PSKCallbacks {
        public String chooseServerPSKIdentityHint(PSKKeyManager var1);

        public String chooseClientPSKIdentity(PSKKeyManager var1, String var2);

        public SecretKey getPSKKey(PSKKeyManager var1, String var2, String var3);
    }

    public static interface AliasChooser {
        public String chooseClientAlias(X509KeyManager var1, X500Principal[] var2, String[] var3);

        public String chooseServerAlias(X509KeyManager var1, String var2);
    }
}

