/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.INetworkManagementEventObserver;
import android.net.InterfaceConfiguration;
import android.os.Binder;
import android.os.CommonTimeConfig;
import android.os.Handler;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.util.Log;
import com.android.server.net.BaseNetworkObserver;
import java.io.FileDescriptor;
import java.io.PrintWriter;

class CommonTimeManagementService
extends Binder {
    private static final String TAG = CommonTimeManagementService.class.getSimpleName();
    private static final int NATIVE_SERVICE_RECONNECT_TIMEOUT = 5000;
    private static final String AUTO_DISABLE_PROP = "ro.common_time.auto_disable";
    private static final String ALLOW_WIFI_PROP = "ro.common_time.allow_wifi";
    private static final String SERVER_PRIO_PROP = "ro.common_time.server_prio";
    private static final String NO_INTERFACE_TIMEOUT_PROP = "ro.common_time.no_iface_timeout";
    private static final boolean AUTO_DISABLE = 0 != SystemProperties.getInt("ro.common_time.auto_disable", 1);
    private static final boolean ALLOW_WIFI = 0 != SystemProperties.getInt("ro.common_time.allow_wifi", 0);
    private static final byte BASE_SERVER_PRIO;
    private static final int NO_INTERFACE_TIMEOUT;
    private static final InterfaceScoreRule[] IFACE_SCORE_RULES;
    private final Context mContext;
    private INetworkManagementService mNetMgr;
    private CommonTimeConfig mCTConfig;
    private String mCurIface;
    private Handler mReconnectHandler = new Handler();
    private Handler mNoInterfaceHandler = new Handler();
    private Object mLock = new Object();
    private boolean mDetectedAtStartup = false;
    private byte mEffectivePrio = BASE_SERVER_PRIO;
    private INetworkManagementEventObserver mIfaceObserver = new BaseNetworkObserver(){

        @Override
        public void interfaceStatusChanged(String iface, boolean up) {
            CommonTimeManagementService.this.reevaluateServiceState();
        }

        @Override
        public void interfaceLinkStateChanged(String iface, boolean up) {
            CommonTimeManagementService.this.reevaluateServiceState();
        }

        @Override
        public void interfaceAdded(String iface) {
            CommonTimeManagementService.this.reevaluateServiceState();
        }

        @Override
        public void interfaceRemoved(String iface) {
            CommonTimeManagementService.this.reevaluateServiceState();
        }
    };
    private BroadcastReceiver mConnectivityMangerObserver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            CommonTimeManagementService.this.reevaluateServiceState();
        }
    };
    private CommonTimeConfig.OnServerDiedListener mCTServerDiedListener = new CommonTimeConfig.OnServerDiedListener(){

        @Override
        public void onServerDied() {
            CommonTimeManagementService.this.scheduleTimeConfigReconnect();
        }
    };
    private Runnable mReconnectRunnable = new Runnable(){

        @Override
        public void run() {
            CommonTimeManagementService.this.connectToTimeConfig();
        }
    };
    private Runnable mNoInterfaceRunnable = new Runnable(){

        @Override
        public void run() {
            CommonTimeManagementService.this.handleNoInterfaceTimeout();
        }
    };

    public CommonTimeManagementService(Context context) {
        this.mContext = context;
    }

    void systemRunning() {
        if (ServiceManager.checkService("common_time.config") == null) {
            Log.i(TAG, "No common time service detected on this platform.  Common time services will be unavailable.");
            return;
        }
        this.mDetectedAtStartup = true;
        IBinder b = ServiceManager.getService("network_management");
        this.mNetMgr = INetworkManagementService.Stub.asInterface(b);
        try {
            this.mNetMgr.registerObserver(this.mIfaceObserver);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver(this.mConnectivityMangerObserver, filter);
        this.connectToTimeConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println(String.format("Permission Denial: can't dump CommonTimeManagement service from from pid=%d, uid=%d", Binder.getCallingPid(), Binder.getCallingUid()));
            return;
        }
        if (!this.mDetectedAtStartup) {
            pw.println("Native Common Time service was not detected at startup.  Service is unavailable");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Current Common Time Management Service Config:");
            pw.println(String.format("  Native service     : %s", null == this.mCTConfig ? "reconnecting" : "alive"));
            pw.println(String.format("  Bound interface    : %s", null == this.mCurIface ? "unbound" : this.mCurIface));
            pw.println(String.format("  Allow WiFi         : %s", ALLOW_WIFI ? "yes" : "no"));
            pw.println(String.format("  Allow Auto Disable : %s", AUTO_DISABLE ? "yes" : "no"));
            pw.println(String.format("  Server Priority    : %d", this.mEffectivePrio));
            pw.println(String.format("  No iface timeout   : %d", NO_INTERFACE_TIMEOUT));
        }
    }

    private void cleanupTimeConfig() {
        this.mReconnectHandler.removeCallbacks(this.mReconnectRunnable);
        this.mNoInterfaceHandler.removeCallbacks(this.mNoInterfaceRunnable);
        if (null != this.mCTConfig) {
            this.mCTConfig.release();
            this.mCTConfig = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToTimeConfig() {
        this.cleanupTimeConfig();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mCTConfig = new CommonTimeConfig();
                this.mCTConfig.setServerDiedListener(this.mCTServerDiedListener);
                this.mCurIface = this.mCTConfig.getInterfaceBinding();
                this.mCTConfig.setAutoDisable(AUTO_DISABLE);
                this.mCTConfig.setMasterElectionPriority(this.mEffectivePrio);
            }
            if (NO_INTERFACE_TIMEOUT >= 0) {
                this.mNoInterfaceHandler.postDelayed(this.mNoInterfaceRunnable, NO_INTERFACE_TIMEOUT);
            }
            this.reevaluateServiceState();
        }
        catch (RemoteException e) {
            this.scheduleTimeConfigReconnect();
        }
    }

    private void scheduleTimeConfigReconnect() {
        this.cleanupTimeConfig();
        Log.w(TAG, String.format("Native service died, will reconnect in %d mSec", 5000));
        this.mReconnectHandler.postDelayed(this.mReconnectRunnable, 5000L);
    }

    private void handleNoInterfaceTimeout() {
        if (null != this.mCTConfig) {
            Log.i(TAG, "Timeout waiting for interface to come up.  Forcing networkless master mode.");
            if (-7 == this.mCTConfig.forceNetworklessMasterMode()) {
                this.scheduleTimeConfigReconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reevaluateServiceState() {
        String bindIface = null;
        int bestScore = -1;
        try {
            String[] ifaceList = this.mNetMgr.listInterfaces();
            if (null != ifaceList) {
                for (String iface : ifaceList) {
                    InterfaceConfiguration config;
                    int thisScore = -1;
                    for (InterfaceScoreRule r : IFACE_SCORE_RULES) {
                        if (!iface.contains(r.mPrefix)) continue;
                        thisScore = r.mScore;
                        break;
                    }
                    if (thisScore <= bestScore || null == (config = this.mNetMgr.getInterfaceConfig(iface)) || !config.isActive()) continue;
                    bindIface = iface;
                    bestScore = thisScore;
                }
            }
        }
        catch (RemoteException e) {
            bindIface = null;
        }
        boolean doRebind = true;
        Object object = this.mLock;
        synchronized (object) {
            if (null != bindIface && null == this.mCurIface) {
                Log.e(TAG, String.format("Binding common time service to %s.", bindIface));
                this.mCurIface = bindIface;
            } else if (null == bindIface && null != this.mCurIface) {
                Log.e(TAG, "Unbinding common time service.");
                this.mCurIface = null;
            } else if (null != bindIface && null != this.mCurIface && !bindIface.equals(this.mCurIface)) {
                Log.e(TAG, String.format("Switching common time service binding from %s to %s.", this.mCurIface, bindIface));
                this.mCurIface = bindIface;
            } else {
                doRebind = false;
            }
        }
        if (doRebind && null != this.mCTConfig) {
            int res;
            byte by;
            byte by2 = by = bestScore > 0 ? (byte)(bestScore * BASE_SERVER_PRIO) : BASE_SERVER_PRIO;
            if (by != this.mEffectivePrio) {
                this.mEffectivePrio = by;
                this.mCTConfig.setMasterElectionPriority(this.mEffectivePrio);
            }
            if ((res = this.mCTConfig.setNetworkBinding(this.mCurIface)) != 0) {
                this.scheduleTimeConfigReconnect();
            } else if (NO_INTERFACE_TIMEOUT >= 0) {
                this.mNoInterfaceHandler.removeCallbacks(this.mNoInterfaceRunnable);
                if (null == this.mCurIface) {
                    this.mNoInterfaceHandler.postDelayed(this.mNoInterfaceRunnable, NO_INTERFACE_TIMEOUT);
                }
            }
        }
    }

    static {
        int tmp = SystemProperties.getInt(SERVER_PRIO_PROP, 1);
        NO_INTERFACE_TIMEOUT = SystemProperties.getInt(NO_INTERFACE_TIMEOUT_PROP, 60000);
        BASE_SERVER_PRIO = tmp < 1 ? (byte)1 : (tmp > 30 ? (byte)30 : (byte)tmp);
        IFACE_SCORE_RULES = ALLOW_WIFI ? new InterfaceScoreRule[]{new InterfaceScoreRule("wlan", 1), new InterfaceScoreRule("eth", 2)} : new InterfaceScoreRule[]{new InterfaceScoreRule("eth", 2)};
    }

    private static class InterfaceScoreRule {
        public final String mPrefix;
        public final byte mScore;

        public InterfaceScoreRule(String prefix, byte score) {
            this.mPrefix = prefix;
            this.mScore = score;
        }
    }
}

