/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.hardware.IConsumerIrService;
import android.os.PowerManager;
import android.util.Slog;

public class ConsumerIrService
extends IConsumerIrService.Stub {
    private static final String TAG = "ConsumerIrService";
    private static final int MAX_XMIT_TIME = 2000000;
    private final Context mContext;
    private final PowerManager.WakeLock mWakeLock;
    private final long mNativeHal;
    private final Object mHalLock = new Object();

    private static native long halOpen();

    private static native int halTransmit(long var0, int var2, int[] var3);

    private static native int[] halGetCarrierFrequencies(long var0);

    ConsumerIrService(Context context) {
        this.mContext = context;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, TAG);
        this.mWakeLock.setReferenceCounted(true);
        this.mNativeHal = ConsumerIrService.halOpen();
        if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.consumerir")) {
            if (this.mNativeHal == 0L) {
                throw new RuntimeException("FEATURE_CONSUMER_IR present, but no IR HAL loaded!");
            }
        } else if (this.mNativeHal != 0L) {
            throw new RuntimeException("IR HAL present, but FEATURE_CONSUMER_IR is not set!");
        }
    }

    @Override
    public boolean hasIrEmitter() {
        return this.mNativeHal != 0L;
    }

    private void throwIfNoIrEmitter() {
        if (this.mNativeHal == 0L) {
            throw new UnsupportedOperationException("IR emitter not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmit(String packageName, int carrierFrequency, int[] pattern) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.TRANSMIT_IR") != 0) {
            throw new SecurityException("Requires TRANSMIT_IR permission");
        }
        long totalXmitTime = 0L;
        for (int slice : pattern) {
            if (slice <= 0) {
                throw new IllegalArgumentException("Non-positive IR slice");
            }
            totalXmitTime += (long)slice;
        }
        if (totalXmitTime > 2000000L) {
            throw new IllegalArgumentException("IR pattern too long");
        }
        this.throwIfNoIrEmitter();
        Object object = this.mHalLock;
        synchronized (object) {
            int err = ConsumerIrService.halTransmit(this.mNativeHal, carrierFrequency, pattern);
            if (err < 0) {
                Slog.e(TAG, "Error transmitting: " + err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getCarrierFrequencies() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.TRANSMIT_IR") != 0) {
            throw new SecurityException("Requires TRANSMIT_IR permission");
        }
        this.throwIfNoIrEmitter();
        Object object = this.mHalLock;
        synchronized (object) {
            return ConsumerIrService.halGetCarrierFrequencies(this.mNativeHal);
        }
    }
}

