/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.TriggerEvent;
import android.hardware.TriggerEventListener;
import android.hardware.display.DisplayManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationRequest;
import android.net.INetworkPolicyManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IDeviceIdleController;
import android.os.IMaintenanceActivityListener;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.KeyValueListParser;
import android.util.MutableLong;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.TimeUtils;
import android.util.Xml;
import android.view.Display;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.AtomicFile;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.AlarmManagerService;
import com.android.server.AnyMotionDetector;
import com.android.server.ConnectivityService;
import com.android.server.EventLogTags;
import com.android.server.SystemConfig;
import com.android.server.SystemService;
import com.android.server.am.BatteryStatsService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class DeviceIdleController
extends SystemService
implements AnyMotionDetector.DeviceIdleCallback {
    private static final String TAG = "DeviceIdleController";
    private static final boolean DEBUG = false;
    private static final boolean COMPRESS_TIME = false;
    private static final int EVENT_BUFFER_SIZE = 100;
    private AlarmManager mAlarmManager;
    private IBatteryStats mBatteryStats;
    private PowerManagerInternal mLocalPowerManager;
    private PowerManager mPowerManager;
    private ConnectivityService mConnectivityService;
    private AlarmManagerService.LocalService mLocalAlarmManager;
    private INetworkPolicyManager mNetworkPolicyManager;
    private DisplayManager mDisplayManager;
    private SensorManager mSensorManager;
    private Sensor mMotionSensor;
    private LocationManager mLocationManager;
    private LocationRequest mLocationRequest;
    private Intent mIdleIntent;
    private Intent mLightIdleIntent;
    private Display mCurDisplay;
    private AnyMotionDetector mAnyMotionDetector;
    private boolean mLightEnabled;
    private boolean mDeepEnabled;
    private boolean mForceIdle;
    private boolean mNetworkConnected;
    private boolean mScreenOn;
    private boolean mCharging;
    private boolean mNotMoving;
    private boolean mLocating;
    private boolean mLocated;
    private boolean mHasGps;
    private boolean mHasNetworkLocation;
    private Location mLastGenericLocation;
    private Location mLastGpsLocation;
    private static final int STATE_ACTIVE = 0;
    private static final int STATE_INACTIVE = 1;
    private static final int STATE_IDLE_PENDING = 2;
    private static final int STATE_SENSING = 3;
    private static final int STATE_LOCATING = 4;
    private static final int STATE_IDLE = 5;
    private static final int STATE_IDLE_MAINTENANCE = 6;
    private static final int LIGHT_STATE_ACTIVE = 0;
    private static final int LIGHT_STATE_INACTIVE = 1;
    private static final int LIGHT_STATE_PRE_IDLE = 3;
    private static final int LIGHT_STATE_IDLE = 4;
    private static final int LIGHT_STATE_WAITING_FOR_NETWORK = 5;
    private static final int LIGHT_STATE_IDLE_MAINTENANCE = 6;
    private static final int LIGHT_STATE_OVERRIDE = 7;
    private int mState;
    private int mLightState;
    private long mInactiveTimeout;
    private long mNextAlarmTime;
    private long mNextIdlePendingDelay;
    private long mNextIdleDelay;
    private long mNextLightIdleDelay;
    private long mNextLightAlarmTime;
    private long mNextSensingTimeoutAlarmTime;
    private long mCurIdleBudget;
    private long mMaintenanceStartTime;
    private int mActiveIdleOpCount;
    private PowerManager.WakeLock mActiveIdleWakeLock;
    private boolean mJobsActive;
    private boolean mAlarmsActive;
    private boolean mReportedMaintenanceActivity;
    public final AtomicFile mConfigFile;
    private final RemoteCallbackList<IMaintenanceActivityListener> mMaintenanceActivityListeners = new RemoteCallbackList();
    private final ArrayMap<String, Integer> mPowerSaveWhitelistAppsExceptIdle = new ArrayMap();
    private final ArrayMap<String, Integer> mPowerSaveWhitelistApps = new ArrayMap();
    private final ArrayMap<String, Integer> mPowerSaveWhitelistUserApps = new ArrayMap();
    private final SparseBooleanArray mPowerSaveWhitelistSystemAppIdsExceptIdle = new SparseBooleanArray();
    private final SparseBooleanArray mPowerSaveWhitelistSystemAppIds = new SparseBooleanArray();
    private final SparseBooleanArray mPowerSaveWhitelistExceptIdleAppIds = new SparseBooleanArray();
    private int[] mPowerSaveWhitelistExceptIdleAppIdArray = new int[0];
    private final SparseBooleanArray mPowerSaveWhitelistAllAppIds = new SparseBooleanArray();
    private int[] mPowerSaveWhitelistAllAppIdArray = new int[0];
    private final SparseBooleanArray mPowerSaveWhitelistUserAppIds = new SparseBooleanArray();
    private int[] mPowerSaveWhitelistUserAppIdArray = new int[0];
    private final SparseArray<Pair<MutableLong, String>> mTempWhitelistAppIdEndTimes = new SparseArray();
    Runnable mNetworkPolicyTempWhitelistCallback;
    private int[] mTempWhitelistAppIdArray = new int[0];
    private static final int EVENT_NULL = 0;
    private static final int EVENT_NORMAL = 1;
    private static final int EVENT_LIGHT_IDLE = 2;
    private static final int EVENT_LIGHT_MAINTENANCE = 3;
    private static final int EVENT_DEEP_IDLE = 4;
    private static final int EVENT_DEEP_MAINTENANCE = 5;
    private final int[] mEventCmds = new int[100];
    private final long[] mEventTimes = new long[100];
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "android.net.conn.CONNECTIVITY_CHANGE": {
                    DeviceIdleController.this.updateConnectivityState(intent);
                    break;
                }
                case "android.intent.action.BATTERY_CHANGED": {
                    DeviceIdleController deviceIdleController = DeviceIdleController.this;
                    synchronized (deviceIdleController) {
                        int plugged = intent.getIntExtra("plugged", 0);
                        DeviceIdleController.this.updateChargingLocked(plugged != 0);
                        break;
                    }
                }
                case "android.intent.action.PACKAGE_REMOVED": {
                    String ssp;
                    Uri data;
                    if (intent.getBooleanExtra("android.intent.extra.REPLACING", false) || (data = intent.getData()) == null || (ssp = data.getSchemeSpecificPart()) == null) break;
                    DeviceIdleController.this.removePowerSaveWhitelistAppInternal(ssp);
                }
            }
        }
    };
    private final AlarmManager.OnAlarmListener mLightAlarmListener = new AlarmManager.OnAlarmListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.stepLightIdleStateLocked("s:alarm");
            }
        }
    };
    private final AlarmManager.OnAlarmListener mSensingTimeoutAlarmListener = new AlarmManager.OnAlarmListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            if (DeviceIdleController.this.mState == 3) {
                DeviceIdleController deviceIdleController = DeviceIdleController.this;
                synchronized (deviceIdleController) {
                    DeviceIdleController.this.becomeInactiveIfAppropriateLocked();
                }
            }
        }
    };
    private final AlarmManager.OnAlarmListener mDeepAlarmListener = new AlarmManager.OnAlarmListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.stepIdleStateLocked("s:alarm");
            }
        }
    };
    private final BroadcastReceiver mIdleStartedDoneReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.os.action.DEVICE_IDLE_MODE_CHANGED".equals(intent.getAction())) {
                DeviceIdleController.this.mHandler.sendEmptyMessageDelayed(8, ((DeviceIdleController)DeviceIdleController.this).mConstants.MIN_DEEP_MAINTENANCE_TIME);
            } else {
                DeviceIdleController.this.mHandler.sendEmptyMessageDelayed(8, ((DeviceIdleController)DeviceIdleController.this).mConstants.MIN_LIGHT_MAINTENANCE_TIME);
            }
        }
    };
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        @Override
        public void onDisplayAdded(int displayId) {
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayChanged(int displayId) {
            if (displayId == 0) {
                DeviceIdleController deviceIdleController = DeviceIdleController.this;
                synchronized (deviceIdleController) {
                    DeviceIdleController.this.updateDisplayLocked();
                }
            }
        }
    };
    private final MotionListener mMotionListener = new MotionListener();
    private final LocationListener mGenericLocationListener = new LocationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocationChanged(Location location) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.receivedGenericLocationLocked(location);
            }
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onProviderDisabled(String provider) {
        }
    };
    private final LocationListener mGpsLocationListener = new LocationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocationChanged(Location location) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.receivedGpsLocationLocked(location);
            }
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onProviderDisabled(String provider) {
        }
    };
    private Constants mConstants;
    static final int MSG_WRITE_CONFIG = 1;
    static final int MSG_REPORT_IDLE_ON = 2;
    static final int MSG_REPORT_IDLE_ON_LIGHT = 3;
    static final int MSG_REPORT_IDLE_OFF = 4;
    static final int MSG_REPORT_ACTIVE = 5;
    static final int MSG_TEMP_APP_WHITELIST_TIMEOUT = 6;
    static final int MSG_REPORT_MAINTENANCE_ACTIVITY = 7;
    static final int MSG_FINISH_IDLE_OP = 8;
    final MyHandler mHandler;
    BinderService mBinderService;

    private static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "ACTIVE";
            }
            case 1: {
                return "INACTIVE";
            }
            case 2: {
                return "IDLE_PENDING";
            }
            case 3: {
                return "SENSING";
            }
            case 4: {
                return "LOCATING";
            }
            case 5: {
                return "IDLE";
            }
            case 6: {
                return "IDLE_MAINTENANCE";
            }
        }
        return Integer.toString(state);
    }

    private static String lightStateToString(int state) {
        switch (state) {
            case 0: {
                return "ACTIVE";
            }
            case 1: {
                return "INACTIVE";
            }
            case 3: {
                return "PRE_IDLE";
            }
            case 4: {
                return "IDLE";
            }
            case 5: {
                return "WAITING_FOR_NETWORK";
            }
            case 6: {
                return "IDLE_MAINTENANCE";
            }
            case 7: {
                return "OVERRIDE";
            }
        }
        return Integer.toString(state);
    }

    private void addEvent(int cmd) {
        if (this.mEventCmds[0] != cmd) {
            System.arraycopy((int[])this.mEventCmds, (int)0, (int[])this.mEventCmds, (int)1, (int)99);
            System.arraycopy((long[])this.mEventTimes, (int)0, (long[])this.mEventTimes, (int)1, (int)99);
            this.mEventCmds[0] = cmd;
            this.mEventTimes[0] = SystemClock.elapsedRealtime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAnyMotionResult(int result) {
        DeviceIdleController deviceIdleController;
        if (result != -1) {
            deviceIdleController = this;
            synchronized (deviceIdleController) {
                this.cancelSensingTimeoutAlarmLocked();
            }
        }
        if (result == 1) {
            deviceIdleController = this;
            synchronized (deviceIdleController) {
                this.handleMotionDetectedLocked(this.mConstants.INACTIVE_TIMEOUT, "sense_motion");
            }
        }
        if (result == 0) {
            if (this.mState == 3) {
                deviceIdleController = this;
                synchronized (deviceIdleController) {
                    this.mNotMoving = true;
                    this.stepIdleStateLocked("s:stationary");
                }
            }
            if (this.mState == 4) {
                deviceIdleController = this;
                synchronized (deviceIdleController) {
                    this.mNotMoving = true;
                    if (this.mLocated) {
                        this.stepIdleStateLocked("s:stationary");
                    }
                }
            }
        }
    }

    public DeviceIdleController(Context context) {
        super(context);
        this.mConfigFile = new AtomicFile(new File(DeviceIdleController.getSystemDir(), "deviceidle.xml"));
        this.mHandler = new MyHandler(BackgroundThread.getHandler().getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getPowerSaveWhitelistUserAppIds() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistUserAppIdArray;
        }
    }

    private static File getSystemDir() {
        return new File(Environment.getDataDirectory(), "system");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        PackageManager pm = this.getContext().getPackageManager();
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mLightEnabled = this.mDeepEnabled = this.getContext().getResources().getBoolean(17956883);
            SystemConfig sysConfig = SystemConfig.getInstance();
            ArraySet<String> allowPowerExceptIdle = sysConfig.getAllowInPowerSaveExceptIdle();
            for (int i = 0; i < allowPowerExceptIdle.size(); ++i) {
                String pkg = allowPowerExceptIdle.valueAt(i);
                try {
                    ApplicationInfo ai = pm.getApplicationInfo(pkg, 0x100000);
                    int appid = UserHandle.getAppId(ai.uid);
                    this.mPowerSaveWhitelistAppsExceptIdle.put(ai.packageName, appid);
                    this.mPowerSaveWhitelistSystemAppIdsExceptIdle.put(appid, true);
                    continue;
                }
                catch (PackageManager.NameNotFoundException ai) {
                    // empty catch block
                }
            }
            ArraySet<String> allowPower = sysConfig.getAllowInPowerSave();
            for (int i = 0; i < allowPower.size(); ++i) {
                String pkg = allowPower.valueAt(i);
                try {
                    ApplicationInfo ai = pm.getApplicationInfo(pkg, 0x100000);
                    int appid = UserHandle.getAppId(ai.uid);
                    this.mPowerSaveWhitelistAppsExceptIdle.put(ai.packageName, appid);
                    this.mPowerSaveWhitelistSystemAppIdsExceptIdle.put(appid, true);
                    this.mPowerSaveWhitelistApps.put(ai.packageName, appid);
                    this.mPowerSaveWhitelistSystemAppIds.put(appid, true);
                    continue;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            this.mConstants = new Constants(this.mHandler, this.getContext().getContentResolver());
            this.readConfigFileLocked();
            this.updateWhitelistAppIdsLocked();
            this.mNetworkConnected = true;
            this.mScreenOn = true;
            this.mCharging = true;
            this.mState = 0;
            this.mLightState = 0;
            this.mInactiveTimeout = this.mConstants.INACTIVE_TIMEOUT;
        }
        this.mBinderService = new BinderService();
        this.publishBinderService("deviceidle", this.mBinderService);
        this.publishLocalService(LocalService.class, new LocalService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            DeviceIdleController deviceIdleController = this;
            synchronized (deviceIdleController) {
                this.mAlarmManager = (AlarmManager)this.getContext().getSystemService("alarm");
                this.mBatteryStats = BatteryStatsService.getService();
                this.mLocalPowerManager = this.getLocalService(PowerManagerInternal.class);
                this.mPowerManager = this.getContext().getSystemService(PowerManager.class);
                this.mActiveIdleWakeLock = this.mPowerManager.newWakeLock(1, "deviceidle_maint");
                this.mActiveIdleWakeLock.setReferenceCounted(false);
                this.mConnectivityService = (ConnectivityService)ServiceManager.getService("connectivity");
                this.mLocalAlarmManager = this.getLocalService(AlarmManagerService.LocalService.class);
                this.mNetworkPolicyManager = INetworkPolicyManager.Stub.asInterface(ServiceManager.getService("netpolicy"));
                this.mDisplayManager = (DisplayManager)this.getContext().getSystemService("display");
                this.mSensorManager = (SensorManager)this.getContext().getSystemService("sensor");
                int sigMotionSensorId = this.getContext().getResources().getInteger(17694733);
                if (sigMotionSensorId > 0) {
                    this.mMotionSensor = this.mSensorManager.getDefaultSensor(sigMotionSensorId, true);
                }
                if (this.mMotionSensor == null && this.getContext().getResources().getBoolean(17956884)) {
                    this.mMotionSensor = this.mSensorManager.getDefaultSensor(26, true);
                }
                if (this.mMotionSensor == null) {
                    this.mMotionSensor = this.mSensorManager.getDefaultSensor(17, true);
                }
                if (this.getContext().getResources().getBoolean(17956885)) {
                    this.mLocationManager = (LocationManager)this.getContext().getSystemService("location");
                    this.mLocationRequest = new LocationRequest().setQuality(100).setInterval(0L).setFastestInterval(0L).setNumUpdates(1);
                }
                float angleThreshold = (float)this.getContext().getResources().getInteger(17694732) / 100.0f;
                this.mAnyMotionDetector = new AnyMotionDetector((PowerManager)this.getContext().getSystemService("power"), this.mHandler, this.mSensorManager, this, angleThreshold);
                this.mIdleIntent = new Intent("android.os.action.DEVICE_IDLE_MODE_CHANGED");
                this.mIdleIntent.addFlags(0x50000000);
                this.mLightIdleIntent = new Intent("android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED");
                this.mLightIdleIntent.addFlags(0x50000000);
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.intent.action.BATTERY_CHANGED");
                this.getContext().registerReceiver(this.mReceiver, filter);
                filter = new IntentFilter();
                filter.addAction("android.intent.action.PACKAGE_REMOVED");
                filter.addDataScheme("package");
                this.getContext().registerReceiver(this.mReceiver, filter);
                filter = new IntentFilter();
                filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                this.getContext().registerReceiver(this.mReceiver, filter);
                this.mLocalPowerManager.setDeviceIdleWhitelist(this.mPowerSaveWhitelistAllAppIdArray);
                this.mLocalAlarmManager.setDeviceIdleUserWhitelist(this.mPowerSaveWhitelistUserAppIdArray);
                this.mDisplayManager.registerDisplayListener(this.mDisplayListener, null);
                this.updateDisplayLocked();
            }
            this.updateConnectivityState(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPowerSaveWhitelistAppInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            try {
                ApplicationInfo ai = this.getContext().getPackageManager().getApplicationInfo(name, 8192);
                if (this.mPowerSaveWhitelistUserApps.put(name, UserHandle.getAppId(ai.uid)) == null) {
                    this.reportPowerSaveWhitelistChangedLocked();
                    this.updateWhitelistAppIdsLocked();
                    this.writeConfigFileLocked();
                }
                return true;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePowerSaveWhitelistAppInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            if (this.mPowerSaveWhitelistUserApps.remove(name) != null) {
                this.reportPowerSaveWhitelistChangedLocked();
                this.updateWhitelistAppIdsLocked();
                this.writeConfigFileLocked();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPowerSaveWhitelistAppInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistUserApps.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSystemPowerWhitelistExceptIdleInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int size = this.mPowerSaveWhitelistAppsExceptIdle.size();
            String[] apps = new String[size];
            for (int i = 0; i < size; ++i) {
                apps[i] = this.mPowerSaveWhitelistAppsExceptIdle.keyAt(i);
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSystemPowerWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int size = this.mPowerSaveWhitelistApps.size();
            String[] apps = new String[size];
            for (int i = 0; i < size; ++i) {
                apps[i] = this.mPowerSaveWhitelistApps.keyAt(i);
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUserPowerWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int size = this.mPowerSaveWhitelistUserApps.size();
            String[] apps = new String[size];
            for (int i = 0; i < this.mPowerSaveWhitelistUserApps.size(); ++i) {
                apps[i] = this.mPowerSaveWhitelistUserApps.keyAt(i);
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFullPowerWhitelistExceptIdleInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int i;
            int size = this.mPowerSaveWhitelistAppsExceptIdle.size() + this.mPowerSaveWhitelistUserApps.size();
            String[] apps = new String[size];
            int cur = 0;
            for (i = 0; i < this.mPowerSaveWhitelistAppsExceptIdle.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistAppsExceptIdle.keyAt(i);
                ++cur;
            }
            for (i = 0; i < this.mPowerSaveWhitelistUserApps.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistUserApps.keyAt(i);
                ++cur;
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFullPowerWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int i;
            int size = this.mPowerSaveWhitelistApps.size() + this.mPowerSaveWhitelistUserApps.size();
            String[] apps = new String[size];
            int cur = 0;
            for (i = 0; i < this.mPowerSaveWhitelistApps.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistApps.keyAt(i);
                ++cur;
            }
            for (i = 0; i < this.mPowerSaveWhitelistUserApps.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistUserApps.keyAt(i);
                ++cur;
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPowerSaveWhitelistExceptIdleAppInternal(String packageName) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistAppsExceptIdle.containsKey(packageName) || this.mPowerSaveWhitelistUserApps.containsKey(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPowerSaveWhitelistAppInternal(String packageName) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistApps.containsKey(packageName) || this.mPowerSaveWhitelistUserApps.containsKey(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppIdWhitelistExceptIdleInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistExceptIdleAppIdArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppIdWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistAllAppIdArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppIdUserWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistUserAppIdArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppIdTempWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mTempWhitelistAppIdArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPowerSaveTempWhitelistAppChecked(String packageName, long duration, int userId, String reason) throws RemoteException {
        this.getContext().enforceCallingPermission("android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", "No permission to change device idle whitelist");
        int callingUid = Binder.getCallingUid();
        userId = ActivityManagerNative.getDefault().handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, false, "addPowerSaveTempWhitelistApp", null);
        long token = Binder.clearCallingIdentity();
        try {
            this.addPowerSaveTempWhitelistAppInternal(callingUid, packageName, duration, userId, true, reason);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void addPowerSaveTempWhitelistAppInternal(int callingUid, String packageName, long duration, int userId, boolean sync, String reason) {
        try {
            int uid = this.getContext().getPackageManager().getPackageUidAsUser(packageName, userId);
            int appId = UserHandle.getAppId(uid);
            this.addPowerSaveTempWhitelistAppDirectInternal(callingUid, appId, duration, sync, reason);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPowerSaveTempWhitelistAppDirectInternal(int callingUid, int appId, long duration, boolean sync, String reason) {
        long timeNow = SystemClock.elapsedRealtime();
        Runnable networkPolicyTempWhitelistCallback = null;
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            boolean newEntry;
            int callingAppId = UserHandle.getAppId(callingUid);
            if (callingAppId >= 10000 && !this.mPowerSaveWhitelistSystemAppIds.get(callingAppId)) {
                throw new SecurityException("Calling app " + UserHandle.formatUid(callingUid) + " is not on whitelist");
            }
            duration = Math.min(duration, this.mConstants.MAX_TEMP_APP_WHITELIST_DURATION);
            Pair<MutableLong, String> entry = this.mTempWhitelistAppIdEndTimes.get(appId);
            boolean bl = newEntry = entry == null;
            if (newEntry) {
                entry = new Pair<MutableLong, String>(new MutableLong(0L), reason);
                this.mTempWhitelistAppIdEndTimes.put(appId, entry);
            }
            ((MutableLong)entry.first).value = timeNow + duration;
            if (newEntry) {
                try {
                    this.mBatteryStats.noteEvent(32785, reason, appId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.postTempActiveTimeoutMessage(appId, duration);
                this.updateTempWhitelistAppIdsLocked();
                if (this.mNetworkPolicyTempWhitelistCallback != null) {
                    if (!sync) {
                        this.mHandler.post(this.mNetworkPolicyTempWhitelistCallback);
                    } else {
                        networkPolicyTempWhitelistCallback = this.mNetworkPolicyTempWhitelistCallback;
                    }
                }
                this.reportTempWhitelistChangedLocked();
            }
        }
        if (networkPolicyTempWhitelistCallback != null) {
            networkPolicyTempWhitelistCallback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkPolicyTempWhitelistCallbackInternal(Runnable callback) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mNetworkPolicyTempWhitelistCallback = callback;
        }
    }

    private void postTempActiveTimeoutMessage(int uid, long delay) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(6, uid, 0), delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTempAppWhitelistTimeout(int uid) {
        long timeNow = SystemClock.elapsedRealtime();
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            Pair<MutableLong, String> entry = this.mTempWhitelistAppIdEndTimes.get(uid);
            if (entry == null) {
                return;
            }
            if (timeNow >= ((MutableLong)entry.first).value) {
                this.mTempWhitelistAppIdEndTimes.delete(uid);
                this.updateTempWhitelistAppIdsLocked();
                if (this.mNetworkPolicyTempWhitelistCallback != null) {
                    this.mHandler.post(this.mNetworkPolicyTempWhitelistCallback);
                }
                this.reportTempWhitelistChangedLocked();
                try {
                    this.mBatteryStats.noteEvent(16401, (String)entry.second, uid);
                }
                catch (RemoteException remoteException) {}
            } else {
                this.postTempActiveTimeoutMessage(uid, ((MutableLong)entry.first).value - timeNow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitIdleInternal(String reason) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.becomeActiveLocked(reason, Binder.getCallingUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConnectivityState(Intent connIntent) {
        ConnectivityService cm;
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            cm = this.mConnectivityService;
        }
        if (cm == null) {
            return;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        DeviceIdleController deviceIdleController2 = this;
        synchronized (deviceIdleController2) {
            boolean conn;
            if (ni == null) {
                conn = false;
            } else if (connIntent == null) {
                conn = ni.isConnected();
            } else {
                int networkType = connIntent.getIntExtra("networkType", -1);
                if (ni.getType() != networkType) {
                    return;
                }
                boolean bl = conn = !connIntent.getBooleanExtra("noConnectivity", false);
            }
            if (conn != this.mNetworkConnected) {
                this.mNetworkConnected = conn;
                if (conn && this.mLightState == 5) {
                    this.stepLightIdleStateLocked("network");
                }
            }
        }
    }

    void updateDisplayLocked() {
        boolean screenOn;
        this.mCurDisplay = this.mDisplayManager.getDisplay(0);
        boolean bl = screenOn = this.mCurDisplay.getState() == 2;
        if (!screenOn && this.mScreenOn) {
            this.mScreenOn = false;
            if (!this.mForceIdle) {
                this.becomeInactiveIfAppropriateLocked();
            }
        } else if (screenOn) {
            this.mScreenOn = true;
            if (!this.mForceIdle) {
                this.becomeActiveLocked("screen", Process.myUid());
            }
        }
    }

    void updateChargingLocked(boolean charging) {
        if (!charging && this.mCharging) {
            this.mCharging = false;
            if (!this.mForceIdle) {
                this.becomeInactiveIfAppropriateLocked();
            }
        } else if (charging) {
            this.mCharging = charging;
            if (!this.mForceIdle) {
                this.becomeActiveLocked("charging", Process.myUid());
            }
        }
    }

    void scheduleReportActiveLocked(String activeReason, int activeUid) {
        Message msg = this.mHandler.obtainMessage(5, activeUid, 0, activeReason);
        this.mHandler.sendMessage(msg);
    }

    void becomeActiveLocked(String activeReason, int activeUid) {
        if (this.mState != 0 || this.mLightState != 0) {
            EventLogTags.writeDeviceIdle(0, activeReason);
            EventLogTags.writeDeviceIdleLight(0, activeReason);
            this.scheduleReportActiveLocked(activeReason, activeUid);
            this.mState = 0;
            this.mLightState = 0;
            this.mInactiveTimeout = this.mConstants.INACTIVE_TIMEOUT;
            this.mCurIdleBudget = 0L;
            this.mMaintenanceStartTime = 0L;
            this.resetIdleManagementLocked();
            this.resetLightIdleManagementLocked();
            this.addEvent(1);
        }
    }

    void becomeInactiveIfAppropriateLocked() {
        if (!this.mScreenOn && !this.mCharging || this.mForceIdle) {
            if (this.mState == 0 && this.mDeepEnabled) {
                this.mState = 1;
                this.resetIdleManagementLocked();
                this.scheduleAlarmLocked(this.mInactiveTimeout, false);
                EventLogTags.writeDeviceIdle(this.mState, "no activity");
            }
            if (this.mLightState == 0 && this.mLightEnabled) {
                this.mLightState = 1;
                this.resetLightIdleManagementLocked();
                this.scheduleLightAlarmLocked(this.mConstants.LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT);
                EventLogTags.writeDeviceIdleLight(this.mLightState, "no activity");
            }
        }
    }

    void resetIdleManagementLocked() {
        this.mNextIdlePendingDelay = 0L;
        this.mNextIdleDelay = 0L;
        this.mNextLightIdleDelay = 0L;
        this.cancelAlarmLocked();
        this.cancelSensingTimeoutAlarmLocked();
        this.cancelLocatingLocked();
        this.stopMonitoringMotionLocked();
        this.mAnyMotionDetector.stop();
    }

    void resetLightIdleManagementLocked() {
        this.cancelLightAlarmLocked();
    }

    void exitForceIdleLocked() {
        if (this.mForceIdle) {
            this.mForceIdle = false;
            if (this.mScreenOn || this.mCharging) {
                this.becomeActiveLocked("exit-force", Process.myUid());
            }
        }
    }

    void stepLightIdleStateLocked(String reason) {
        if (this.mLightState == 7) {
            return;
        }
        EventLogTags.writeDeviceIdleLightStep();
        switch (this.mLightState) {
            case 1: {
                this.mCurIdleBudget = this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET;
                this.mNextLightIdleDelay = this.mConstants.LIGHT_IDLE_TIMEOUT;
                this.mMaintenanceStartTime = 0L;
                if (!this.isOpsInactiveLocked()) {
                    this.mLightState = 3;
                    EventLogTags.writeDeviceIdleLight(this.mLightState, reason);
                    this.scheduleLightAlarmLocked(this.mConstants.LIGHT_PRE_IDLE_TIMEOUT);
                    break;
                }
            }
            case 3: 
            case 6: {
                if (this.mMaintenanceStartTime != 0L) {
                    long duration = SystemClock.elapsedRealtime() - this.mMaintenanceStartTime;
                    this.mCurIdleBudget = duration < this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET ? (this.mCurIdleBudget += this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET - duration) : (this.mCurIdleBudget -= duration - this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET);
                }
                this.mMaintenanceStartTime = 0L;
                this.scheduleLightAlarmLocked(this.mNextLightIdleDelay);
                this.mNextLightIdleDelay = Math.min(this.mConstants.LIGHT_MAX_IDLE_TIMEOUT, (long)((float)this.mNextLightIdleDelay * this.mConstants.LIGHT_IDLE_FACTOR));
                if (this.mNextLightIdleDelay < this.mConstants.LIGHT_IDLE_TIMEOUT) {
                    this.mNextLightIdleDelay = this.mConstants.LIGHT_IDLE_TIMEOUT;
                }
                this.mLightState = 4;
                EventLogTags.writeDeviceIdleLight(this.mLightState, reason);
                this.addEvent(2);
                this.mHandler.sendEmptyMessage(3);
                break;
            }
            case 4: 
            case 5: {
                if (this.mNetworkConnected || this.mLightState == 5) {
                    this.mActiveIdleOpCount = 1;
                    this.mActiveIdleWakeLock.acquire();
                    this.mMaintenanceStartTime = SystemClock.elapsedRealtime();
                    if (this.mCurIdleBudget < this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET) {
                        this.mCurIdleBudget = this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET;
                    } else if (this.mCurIdleBudget > this.mConstants.LIGHT_IDLE_MAINTENANCE_MAX_BUDGET) {
                        this.mCurIdleBudget = this.mConstants.LIGHT_IDLE_MAINTENANCE_MAX_BUDGET;
                    }
                    this.scheduleLightAlarmLocked(this.mCurIdleBudget);
                    this.mLightState = 6;
                    EventLogTags.writeDeviceIdleLight(this.mLightState, reason);
                    this.addEvent(3);
                    this.mHandler.sendEmptyMessage(4);
                    break;
                }
                this.scheduleLightAlarmLocked(this.mNextLightIdleDelay);
                this.mLightState = 5;
                EventLogTags.writeDeviceIdleLight(this.mLightState, reason);
            }
        }
    }

    void stepIdleStateLocked(String reason) {
        EventLogTags.writeDeviceIdleStep();
        long now = SystemClock.elapsedRealtime();
        if (now + this.mConstants.MIN_TIME_TO_ALARM > this.mAlarmManager.getNextWakeFromIdleTime()) {
            if (this.mState != 0) {
                this.becomeActiveLocked("alarm", Process.myUid());
                this.becomeInactiveIfAppropriateLocked();
            }
            return;
        }
        switch (this.mState) {
            case 1: {
                this.startMonitoringMotionLocked();
                this.scheduleAlarmLocked(this.mConstants.IDLE_AFTER_INACTIVE_TIMEOUT, false);
                this.mNextIdlePendingDelay = this.mConstants.IDLE_PENDING_TIMEOUT;
                this.mNextIdleDelay = this.mConstants.IDLE_TIMEOUT;
                this.mState = 2;
                EventLogTags.writeDeviceIdle(this.mState, reason);
                break;
            }
            case 2: {
                this.mState = 3;
                EventLogTags.writeDeviceIdle(this.mState, reason);
                this.scheduleSensingTimeoutAlarmLocked(this.mConstants.SENSING_TIMEOUT);
                this.cancelLocatingLocked();
                this.mNotMoving = false;
                this.mLocated = false;
                this.mLastGenericLocation = null;
                this.mLastGpsLocation = null;
                this.mAnyMotionDetector.checkForAnyMotion();
                break;
            }
            case 3: {
                this.cancelSensingTimeoutAlarmLocked();
                this.mState = 4;
                EventLogTags.writeDeviceIdle(this.mState, reason);
                this.scheduleAlarmLocked(this.mConstants.LOCATING_TIMEOUT, false);
                if (this.mLocationManager != null && this.mLocationManager.getProvider("network") != null) {
                    this.mLocationManager.requestLocationUpdates(this.mLocationRequest, this.mGenericLocationListener, this.mHandler.getLooper());
                    this.mLocating = true;
                } else {
                    this.mHasNetworkLocation = false;
                }
                if (this.mLocationManager != null && this.mLocationManager.getProvider("gps") != null) {
                    this.mHasGps = true;
                    this.mLocationManager.requestLocationUpdates("gps", 1000L, 5.0f, this.mGpsLocationListener, this.mHandler.getLooper());
                    this.mLocating = true;
                } else {
                    this.mHasGps = false;
                }
                if (this.mLocating) break;
            }
            case 4: {
                this.cancelAlarmLocked();
                this.cancelLocatingLocked();
                this.mAnyMotionDetector.stop();
            }
            case 6: {
                this.scheduleAlarmLocked(this.mNextIdleDelay, true);
                this.mNextIdleDelay = (long)((float)this.mNextIdleDelay * this.mConstants.IDLE_FACTOR);
                this.mNextIdleDelay = Math.min(this.mNextIdleDelay, this.mConstants.MAX_IDLE_TIMEOUT);
                if (this.mNextIdleDelay < this.mConstants.IDLE_TIMEOUT) {
                    this.mNextIdleDelay = this.mConstants.IDLE_TIMEOUT;
                }
                this.mState = 5;
                if (this.mLightState != 7) {
                    this.mLightState = 7;
                    this.cancelLightAlarmLocked();
                }
                EventLogTags.writeDeviceIdle(this.mState, reason);
                this.addEvent(4);
                this.mHandler.sendEmptyMessage(2);
                break;
            }
            case 5: {
                this.mActiveIdleOpCount = 1;
                this.mActiveIdleWakeLock.acquire();
                this.scheduleAlarmLocked(this.mNextIdlePendingDelay, false);
                this.mMaintenanceStartTime = SystemClock.elapsedRealtime();
                this.mNextIdlePendingDelay = Math.min(this.mConstants.MAX_IDLE_PENDING_TIMEOUT, (long)((float)this.mNextIdlePendingDelay * this.mConstants.IDLE_PENDING_FACTOR));
                if (this.mNextIdlePendingDelay < this.mConstants.IDLE_PENDING_TIMEOUT) {
                    this.mNextIdlePendingDelay = this.mConstants.IDLE_PENDING_TIMEOUT;
                }
                this.mState = 6;
                EventLogTags.writeDeviceIdle(this.mState, reason);
                this.addEvent(5);
                this.mHandler.sendEmptyMessage(4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incActiveIdleOps() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            ++this.mActiveIdleOpCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decActiveIdleOps() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            --this.mActiveIdleOpCount;
            if (this.mActiveIdleOpCount <= 0) {
                this.exitMaintenanceEarlyIfNeededLocked();
                this.mActiveIdleWakeLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJobsActive(boolean active) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mJobsActive = active;
            this.reportMaintenanceActivityIfNeededLocked();
            if (!active) {
                this.exitMaintenanceEarlyIfNeededLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAlarmsActive(boolean active) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mAlarmsActive = active;
            if (!active) {
                this.exitMaintenanceEarlyIfNeededLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerMaintenanceActivityListener(IMaintenanceActivityListener listener) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mMaintenanceActivityListeners.register(listener);
            return this.mReportedMaintenanceActivity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterMaintenanceActivityListener(IMaintenanceActivityListener listener) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mMaintenanceActivityListeners.unregister(listener);
        }
    }

    void reportMaintenanceActivityIfNeededLocked() {
        boolean active = this.mJobsActive;
        if (active == this.mReportedMaintenanceActivity) {
            return;
        }
        this.mReportedMaintenanceActivity = active;
        Message msg = this.mHandler.obtainMessage(7, this.mReportedMaintenanceActivity ? 1 : 0, 0);
        this.mHandler.sendMessage(msg);
    }

    boolean isOpsInactiveLocked() {
        return this.mActiveIdleOpCount <= 0 && !this.mJobsActive && !this.mAlarmsActive;
    }

    void exitMaintenanceEarlyIfNeededLocked() {
        if ((this.mState == 6 || this.mLightState == 6 || this.mLightState == 3) && this.isOpsInactiveLocked()) {
            long now = SystemClock.elapsedRealtime();
            if (this.mState == 6) {
                this.stepIdleStateLocked("s:early");
            } else if (this.mLightState == 3) {
                this.stepLightIdleStateLocked("s:predone");
            } else {
                this.stepLightIdleStateLocked("s:early");
            }
        }
    }

    void motionLocked() {
        this.handleMotionDetectedLocked(this.mConstants.MOTION_INACTIVE_TIMEOUT, "motion");
    }

    void handleMotionDetectedLocked(long timeout, String type) {
        boolean becomeInactive = false;
        if (this.mState != 0) {
            this.scheduleReportActiveLocked(type, Process.myUid());
            this.mState = 0;
            this.mInactiveTimeout = timeout;
            this.mCurIdleBudget = 0L;
            this.mMaintenanceStartTime = 0L;
            EventLogTags.writeDeviceIdle(this.mState, type);
            this.addEvent(1);
            becomeInactive = true;
        }
        if (this.mLightState == 7) {
            this.mLightState = 0;
            EventLogTags.writeDeviceIdleLight(this.mLightState, type);
            becomeInactive = true;
        }
        if (becomeInactive) {
            this.becomeInactiveIfAppropriateLocked();
        }
    }

    void receivedGenericLocationLocked(Location location) {
        if (this.mState != 4) {
            this.cancelLocatingLocked();
            return;
        }
        this.mLastGenericLocation = new Location(location);
        if (location.getAccuracy() > this.mConstants.LOCATION_ACCURACY && this.mHasGps) {
            return;
        }
        this.mLocated = true;
        if (this.mNotMoving) {
            this.stepIdleStateLocked("s:location");
        }
    }

    void receivedGpsLocationLocked(Location location) {
        if (this.mState != 4) {
            this.cancelLocatingLocked();
            return;
        }
        this.mLastGpsLocation = new Location(location);
        if (location.getAccuracy() > this.mConstants.LOCATION_ACCURACY) {
            return;
        }
        this.mLocated = true;
        if (this.mNotMoving) {
            this.stepIdleStateLocked("s:gps");
        }
    }

    void startMonitoringMotionLocked() {
        if (this.mMotionSensor != null && !this.mMotionListener.active) {
            this.mMotionListener.registerLocked();
        }
    }

    void stopMonitoringMotionLocked() {
        if (this.mMotionSensor != null && this.mMotionListener.active) {
            this.mMotionListener.unregisterLocked();
        }
    }

    void cancelAlarmLocked() {
        if (this.mNextAlarmTime != 0L) {
            this.mNextAlarmTime = 0L;
            this.mAlarmManager.cancel(this.mDeepAlarmListener);
        }
    }

    void cancelLightAlarmLocked() {
        if (this.mNextLightAlarmTime != 0L) {
            this.mNextLightAlarmTime = 0L;
            this.mAlarmManager.cancel(this.mLightAlarmListener);
        }
    }

    void cancelLocatingLocked() {
        if (this.mLocating) {
            this.mLocationManager.removeUpdates(this.mGenericLocationListener);
            this.mLocationManager.removeUpdates(this.mGpsLocationListener);
            this.mLocating = false;
        }
    }

    void cancelSensingTimeoutAlarmLocked() {
        if (this.mNextSensingTimeoutAlarmTime != 0L) {
            this.mNextSensingTimeoutAlarmTime = 0L;
            this.mAlarmManager.cancel(this.mSensingTimeoutAlarmListener);
        }
    }

    void scheduleAlarmLocked(long delay, boolean idleUntil) {
        if (this.mMotionSensor == null) {
            return;
        }
        this.mNextAlarmTime = SystemClock.elapsedRealtime() + delay;
        if (idleUntil) {
            this.mAlarmManager.setIdleUntil(2, this.mNextAlarmTime, "DeviceIdleController.deep", this.mDeepAlarmListener, this.mHandler);
        } else {
            this.mAlarmManager.set(2, this.mNextAlarmTime, "DeviceIdleController.deep", this.mDeepAlarmListener, this.mHandler);
        }
    }

    void scheduleLightAlarmLocked(long delay) {
        this.mNextLightAlarmTime = SystemClock.elapsedRealtime() + delay;
        this.mAlarmManager.set(2, this.mNextLightAlarmTime, "DeviceIdleController.light", this.mLightAlarmListener, this.mHandler);
    }

    void scheduleSensingTimeoutAlarmLocked(long delay) {
        this.mNextSensingTimeoutAlarmTime = SystemClock.elapsedRealtime() + delay;
        this.mAlarmManager.set(2, this.mNextSensingTimeoutAlarmTime, "DeviceIdleController.sensing", this.mSensingTimeoutAlarmListener, this.mHandler);
    }

    private static int[] buildAppIdArray(ArrayMap<String, Integer> systemApps, ArrayMap<String, Integer> userApps, SparseBooleanArray outAppIds) {
        int i;
        outAppIds.clear();
        if (systemApps != null) {
            for (i = 0; i < systemApps.size(); ++i) {
                outAppIds.put(systemApps.valueAt(i), true);
            }
        }
        if (userApps != null) {
            for (i = 0; i < userApps.size(); ++i) {
                outAppIds.put(userApps.valueAt(i), true);
            }
        }
        int size = outAppIds.size();
        int[] appids = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            appids[i2] = outAppIds.keyAt(i2);
        }
        return appids;
    }

    private void updateWhitelistAppIdsLocked() {
        this.mPowerSaveWhitelistExceptIdleAppIdArray = DeviceIdleController.buildAppIdArray(this.mPowerSaveWhitelistAppsExceptIdle, this.mPowerSaveWhitelistUserApps, this.mPowerSaveWhitelistExceptIdleAppIds);
        this.mPowerSaveWhitelistAllAppIdArray = DeviceIdleController.buildAppIdArray(this.mPowerSaveWhitelistApps, this.mPowerSaveWhitelistUserApps, this.mPowerSaveWhitelistAllAppIds);
        this.mPowerSaveWhitelistUserAppIdArray = DeviceIdleController.buildAppIdArray(null, this.mPowerSaveWhitelistUserApps, this.mPowerSaveWhitelistUserAppIds);
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.setDeviceIdleWhitelist(this.mPowerSaveWhitelistAllAppIdArray);
        }
        if (this.mLocalAlarmManager != null) {
            this.mLocalAlarmManager.setDeviceIdleUserWhitelist(this.mPowerSaveWhitelistUserAppIdArray);
        }
    }

    private void updateTempWhitelistAppIdsLocked() {
        int size = this.mTempWhitelistAppIdEndTimes.size();
        if (this.mTempWhitelistAppIdArray.length != size) {
            this.mTempWhitelistAppIdArray = new int[size];
        }
        for (int i = 0; i < size; ++i) {
            this.mTempWhitelistAppIdArray[i] = this.mTempWhitelistAppIdEndTimes.keyAt(i);
        }
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.setDeviceIdleTempWhitelist(this.mTempWhitelistAppIdArray);
        }
    }

    private void reportPowerSaveWhitelistChangedLocked() {
        Intent intent = new Intent("android.os.action.POWER_SAVE_WHITELIST_CHANGED");
        intent.addFlags(0x40000000);
        this.getContext().sendBroadcastAsUser(intent, UserHandle.SYSTEM);
    }

    private void reportTempWhitelistChangedLocked() {
        Intent intent = new Intent("android.os.action.POWER_SAVE_TEMP_WHITELIST_CHANGED");
        intent.addFlags(0x40000000);
        this.getContext().sendBroadcastAsUser(intent, UserHandle.SYSTEM);
    }

    void readConfigFileLocked() {
        FileInputStream stream;
        this.mPowerSaveWhitelistUserApps.clear();
        try {
            stream = this.mConfigFile.openRead();
        }
        catch (FileNotFoundException e) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            this.readConfigFileLocked(parser);
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void readConfigFileLocked(XmlPullParser parser) {
        PackageManager pm = this.getContext().getPackageManager();
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new IllegalStateException("no start tag found");
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("wl")) {
                    String name = parser.getAttributeValue(null, "n");
                    if (name == null) continue;
                    try {
                        ApplicationInfo ai = pm.getApplicationInfo(name, 8192);
                        this.mPowerSaveWhitelistUserApps.put(ai.packageName, UserHandle.getAppId(ai.uid));
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {}
                    continue;
                }
                Slog.w(TAG, "Unknown element under <config>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
    }

    void writeConfigFileLocked() {
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWriteConfigFile() {
        Object object;
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        try {
            object = this;
            synchronized (object) {
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(memStream, StandardCharsets.UTF_8.name());
                this.writeConfigFileLocked(out);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = this.mConfigFile;
        synchronized (object) {
            FileOutputStream stream = null;
            try {
                stream = this.mConfigFile.startWrite();
                memStream.writeTo(stream);
                stream.flush();
                FileUtils.sync(stream);
                stream.close();
                this.mConfigFile.finishWrite(stream);
            }
            catch (IOException e) {
                Slog.w(TAG, "Error writing config file", e);
                this.mConfigFile.failWrite(stream);
            }
        }
    }

    void writeConfigFileLocked(XmlSerializer out) throws IOException {
        out.startDocument(null, true);
        out.startTag(null, "config");
        for (int i = 0; i < this.mPowerSaveWhitelistUserApps.size(); ++i) {
            String name = this.mPowerSaveWhitelistUserApps.keyAt(i);
            out.startTag(null, "wl");
            out.attribute(null, "n", name);
            out.endTag(null, "wl");
        }
        out.endTag(null, "config");
        out.endDocument();
    }

    static void dumpHelp(PrintWriter pw) {
        pw.println("Device idle controller (deviceidle) commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("  step [light|deep]");
        pw.println("    Immediately step to next state, without waiting for alarm.");
        pw.println("  force-idle [light|deep]");
        pw.println("    Force directly into idle mode, regardless of other device state.");
        pw.println("  force-inactive");
        pw.println("    Force to be inactive, ready to freely step idle states.");
        pw.println("  unforce");
        pw.println("    Resume normal functioning after force-idle or force-inactive.");
        pw.println("  get [light|deep|force|screen|charging|network]");
        pw.println("    Retrieve the current given state.");
        pw.println("  disable [light|deep|all]");
        pw.println("    Completely disable device idle mode.");
        pw.println("  enable [light|deep|all]");
        pw.println("    Re-enable device idle mode after it had previously been disabled.");
        pw.println("  enabled [light|deep|all]");
        pw.println("    Print 1 if device idle mode is currently enabled, else 0.");
        pw.println("  whitelist");
        pw.println("    Print currently whitelisted apps.");
        pw.println("  whitelist [package ...]");
        pw.println("    Add (prefix with +) or remove (prefix with -) packages.");
        pw.println("  tempwhitelist");
        pw.println("    Print packages that are temporarily whitelisted.");
        pw.println("  tempwhitelist [-u] [package ..]");
        pw.println("    Temporarily place packages in whitelist for 10 seconds.");
    }

    /*
     * Exception decompiling
     */
    int onShellCommand(Shell shell, String cmd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 75[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.getContext().checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump DeviceIdleController from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        if (args != null) {
            int userId = 0;
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("-h".equals(arg)) {
                    DeviceIdleController.dumpHelp(pw);
                    return;
                }
                if ("-u".equals(arg)) {
                    if (++i >= args.length) continue;
                    arg = args[i];
                    userId = Integer.parseInt(arg);
                    continue;
                }
                if ("-a".equals(arg)) continue;
                if (arg.length() > 0 && arg.charAt(0) == '-') {
                    pw.println("Unknown option: " + arg);
                    return;
                }
                Shell shell = new Shell();
                shell.userId = userId;
                String[] newArgs = new String[args.length - i];
                System.arraycopy(args, i, newArgs, 0, args.length - i);
                shell.exec(this.mBinderService, null, fd, null, newArgs, new ResultReceiver(null));
                return;
            }
        }
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int size;
            this.mConstants.dump(pw);
            if (this.mEventCmds[0] != 0) {
                pw.println("  Idling history:");
                long now = SystemClock.elapsedRealtime();
                for (int i = 99; i >= 0; --i) {
                    String label;
                    int cmd = this.mEventCmds[i];
                    if (cmd == 0) continue;
                    switch (this.mEventCmds[i]) {
                        case 1: {
                            label = "     normal";
                            break;
                        }
                        case 2: {
                            label = " light-idle";
                            break;
                        }
                        case 3: {
                            label = "light-maint";
                            break;
                        }
                        case 4: {
                            label = "  deep-idle";
                            break;
                        }
                        case 5: {
                            label = " deep-maint";
                            break;
                        }
                        default: {
                            label = "         ??";
                        }
                    }
                    pw.print("    ");
                    pw.print(label);
                    pw.print(": ");
                    TimeUtils.formatDuration(this.mEventTimes[i], now, pw);
                    pw.println();
                }
            }
            if ((size = this.mPowerSaveWhitelistAppsExceptIdle.size()) > 0) {
                pw.println("  Whitelist (except idle) system apps:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.println(this.mPowerSaveWhitelistAppsExceptIdle.keyAt(i));
                }
            }
            if ((size = this.mPowerSaveWhitelistApps.size()) > 0) {
                pw.println("  Whitelist system apps:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.println(this.mPowerSaveWhitelistApps.keyAt(i));
                }
            }
            if ((size = this.mPowerSaveWhitelistUserApps.size()) > 0) {
                pw.println("  Whitelist user apps:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.println(this.mPowerSaveWhitelistUserApps.keyAt(i));
                }
            }
            if ((size = this.mPowerSaveWhitelistExceptIdleAppIds.size()) > 0) {
                pw.println("  Whitelist (except idle) all app ids:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.print(this.mPowerSaveWhitelistExceptIdleAppIds.keyAt(i));
                    pw.println();
                }
            }
            if ((size = this.mPowerSaveWhitelistUserAppIds.size()) > 0) {
                pw.println("  Whitelist user app ids:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.print(this.mPowerSaveWhitelistUserAppIds.keyAt(i));
                    pw.println();
                }
            }
            if ((size = this.mPowerSaveWhitelistAllAppIds.size()) > 0) {
                pw.println("  Whitelist all app ids:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.print(this.mPowerSaveWhitelistAllAppIds.keyAt(i));
                    pw.println();
                }
            }
            this.dumpTempWhitelistSchedule(pw, true);
            int n = size = this.mTempWhitelistAppIdArray != null ? this.mTempWhitelistAppIdArray.length : 0;
            if (size > 0) {
                pw.println("  Temp whitelist app ids:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.print(this.mTempWhitelistAppIdArray[i]);
                    pw.println();
                }
            }
            pw.print("  mLightEnabled=");
            pw.print(this.mLightEnabled);
            pw.print("  mDeepEnabled=");
            pw.println(this.mDeepEnabled);
            pw.print("  mForceIdle=");
            pw.println(this.mForceIdle);
            pw.print("  mMotionSensor=");
            pw.println(this.mMotionSensor);
            pw.print("  mCurDisplay=");
            pw.println(this.mCurDisplay);
            pw.print("  mScreenOn=");
            pw.println(this.mScreenOn);
            pw.print("  mNetworkConnected=");
            pw.println(this.mNetworkConnected);
            pw.print("  mCharging=");
            pw.println(this.mCharging);
            pw.print("  mMotionActive=");
            pw.println(this.mMotionListener.active);
            pw.print("  mNotMoving=");
            pw.println(this.mNotMoving);
            pw.print("  mLocating=");
            pw.print(this.mLocating);
            pw.print(" mHasGps=");
            pw.print(this.mHasGps);
            pw.print(" mHasNetwork=");
            pw.print(this.mHasNetworkLocation);
            pw.print(" mLocated=");
            pw.println(this.mLocated);
            if (this.mLastGenericLocation != null) {
                pw.print("  mLastGenericLocation=");
                pw.println(this.mLastGenericLocation);
            }
            if (this.mLastGpsLocation != null) {
                pw.print("  mLastGpsLocation=");
                pw.println(this.mLastGpsLocation);
            }
            pw.print("  mState=");
            pw.print(DeviceIdleController.stateToString(this.mState));
            pw.print(" mLightState=");
            pw.println(DeviceIdleController.lightStateToString(this.mLightState));
            pw.print("  mInactiveTimeout=");
            TimeUtils.formatDuration(this.mInactiveTimeout, pw);
            pw.println();
            if (this.mActiveIdleOpCount != 0) {
                pw.print("  mActiveIdleOpCount=");
                pw.println(this.mActiveIdleOpCount);
            }
            if (this.mNextAlarmTime != 0L) {
                pw.print("  mNextAlarmTime=");
                TimeUtils.formatDuration(this.mNextAlarmTime, SystemClock.elapsedRealtime(), pw);
                pw.println();
            }
            if (this.mNextIdlePendingDelay != 0L) {
                pw.print("  mNextIdlePendingDelay=");
                TimeUtils.formatDuration(this.mNextIdlePendingDelay, pw);
                pw.println();
            }
            if (this.mNextIdleDelay != 0L) {
                pw.print("  mNextIdleDelay=");
                TimeUtils.formatDuration(this.mNextIdleDelay, pw);
                pw.println();
            }
            if (this.mNextLightIdleDelay != 0L) {
                pw.print("  mNextIdleDelay=");
                TimeUtils.formatDuration(this.mNextLightIdleDelay, pw);
                pw.println();
            }
            if (this.mNextLightAlarmTime != 0L) {
                pw.print("  mNextLightAlarmTime=");
                TimeUtils.formatDuration(this.mNextLightAlarmTime, SystemClock.elapsedRealtime(), pw);
                pw.println();
            }
            if (this.mCurIdleBudget != 0L) {
                pw.print("  mCurIdleBudget=");
                TimeUtils.formatDuration(this.mCurIdleBudget, pw);
                pw.println();
            }
            if (this.mMaintenanceStartTime != 0L) {
                pw.print("  mMaintenanceStartTime=");
                TimeUtils.formatDuration(this.mMaintenanceStartTime, SystemClock.elapsedRealtime(), pw);
                pw.println();
            }
            if (this.mJobsActive) {
                pw.print("  mJobsActive=");
                pw.println(this.mJobsActive);
            }
            if (this.mAlarmsActive) {
                pw.print("  mAlarmsActive=");
                pw.println(this.mAlarmsActive);
            }
        }
    }

    void dumpTempWhitelistSchedule(PrintWriter pw, boolean printTitle) {
        int size = this.mTempWhitelistAppIdEndTimes.size();
        if (size > 0) {
            String prefix = "";
            if (printTitle) {
                pw.println("  Temp whitelist schedule:");
                prefix = "    ";
            }
            long timeNow = SystemClock.elapsedRealtime();
            for (int i = 0; i < size; ++i) {
                pw.print(prefix);
                pw.print("UID=");
                pw.print(this.mTempWhitelistAppIdEndTimes.keyAt(i));
                pw.print(": ");
                Pair<MutableLong, String> entry = this.mTempWhitelistAppIdEndTimes.valueAt(i);
                TimeUtils.formatDuration(((MutableLong)entry.first).value, timeNow, pw);
                pw.print(" - ");
                pw.println((String)entry.second);
            }
        }
    }

    class Shell
    extends ShellCommand {
        int userId = 0;

        Shell() {
        }

        @Override
        public int onCommand(String cmd) {
            return DeviceIdleController.this.onShellCommand(this, cmd);
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            DeviceIdleController.dumpHelp(pw);
        }
    }

    public final class LocalService {
        public void addPowerSaveTempWhitelistAppDirect(int appId, long duration, boolean sync, String reason) {
            DeviceIdleController.this.addPowerSaveTempWhitelistAppDirectInternal(0, appId, duration, sync, reason);
        }

        public long getNotificationWhitelistDuration() {
            return ((DeviceIdleController)DeviceIdleController.this).mConstants.NOTIFICATION_WHITELIST_DURATION;
        }

        public void setNetworkPolicyTempWhitelistCallback(Runnable callback) {
            DeviceIdleController.this.setNetworkPolicyTempWhitelistCallbackInternal(callback);
        }

        public void setJobsActive(boolean active) {
            DeviceIdleController.this.setJobsActive(active);
        }

        public void setAlarmsActive(boolean active) {
            DeviceIdleController.this.setAlarmsActive(active);
        }

        public int[] getPowerSaveWhitelistUserAppIds() {
            return DeviceIdleController.this.getPowerSaveWhitelistUserAppIds();
        }
    }

    private final class BinderService
    extends IDeviceIdleController.Stub {
        private BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPowerSaveWhitelistApp(String name) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                DeviceIdleController.this.addPowerSaveWhitelistAppInternal(name);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePowerSaveWhitelistApp(String name) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                DeviceIdleController.this.removePowerSaveWhitelistAppInternal(name);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public String[] getSystemPowerWhitelistExceptIdle() {
            return DeviceIdleController.this.getSystemPowerWhitelistExceptIdleInternal();
        }

        @Override
        public String[] getSystemPowerWhitelist() {
            return DeviceIdleController.this.getSystemPowerWhitelistInternal();
        }

        @Override
        public String[] getUserPowerWhitelist() {
            return DeviceIdleController.this.getUserPowerWhitelistInternal();
        }

        @Override
        public String[] getFullPowerWhitelistExceptIdle() {
            return DeviceIdleController.this.getFullPowerWhitelistExceptIdleInternal();
        }

        @Override
        public String[] getFullPowerWhitelist() {
            return DeviceIdleController.this.getFullPowerWhitelistInternal();
        }

        @Override
        public int[] getAppIdWhitelistExceptIdle() {
            return DeviceIdleController.this.getAppIdWhitelistExceptIdleInternal();
        }

        @Override
        public int[] getAppIdWhitelist() {
            return DeviceIdleController.this.getAppIdWhitelistInternal();
        }

        @Override
        public int[] getAppIdUserWhitelist() {
            return DeviceIdleController.this.getAppIdUserWhitelistInternal();
        }

        @Override
        public int[] getAppIdTempWhitelist() {
            return DeviceIdleController.this.getAppIdTempWhitelistInternal();
        }

        @Override
        public boolean isPowerSaveWhitelistExceptIdleApp(String name) {
            return DeviceIdleController.this.isPowerSaveWhitelistExceptIdleAppInternal(name);
        }

        @Override
        public boolean isPowerSaveWhitelistApp(String name) {
            return DeviceIdleController.this.isPowerSaveWhitelistAppInternal(name);
        }

        @Override
        public void addPowerSaveTempWhitelistApp(String packageName, long duration, int userId, String reason) throws RemoteException {
            DeviceIdleController.this.addPowerSaveTempWhitelistAppChecked(packageName, duration, userId, reason);
        }

        @Override
        public long addPowerSaveTempWhitelistAppForMms(String packageName, int userId, String reason) throws RemoteException {
            long duration = ((DeviceIdleController)DeviceIdleController.this).mConstants.MMS_TEMP_APP_WHITELIST_DURATION;
            DeviceIdleController.this.addPowerSaveTempWhitelistAppChecked(packageName, duration, userId, reason);
            return duration;
        }

        @Override
        public long addPowerSaveTempWhitelistAppForSms(String packageName, int userId, String reason) throws RemoteException {
            long duration = ((DeviceIdleController)DeviceIdleController.this).mConstants.SMS_TEMP_APP_WHITELIST_DURATION;
            DeviceIdleController.this.addPowerSaveTempWhitelistAppChecked(packageName, duration, userId, reason);
            return duration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exitIdle(String reason) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                DeviceIdleController.this.exitIdleInternal(reason);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public boolean registerMaintenanceActivityListener(IMaintenanceActivityListener listener) {
            return DeviceIdleController.this.registerMaintenanceActivityListener(listener);
        }

        @Override
        public void unregisterMaintenanceActivityListener(IMaintenanceActivityListener listener) {
            DeviceIdleController.this.unregisterMaintenanceActivityListener(listener);
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            DeviceIdleController.this.dump(fd, pw, args);
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ResultReceiver resultReceiver) {
            new Shell().exec(this, in, out, err, args, resultReceiver);
        }
    }

    final class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DeviceIdleController.this.handleWriteConfigFile();
                    break;
                }
                case 2: 
                case 3: {
                    boolean lightChanged;
                    boolean deepChanged;
                    EventLogTags.writeDeviceIdleOnStart();
                    if (msg.what == 2) {
                        deepChanged = DeviceIdleController.this.mLocalPowerManager.setDeviceIdleMode(true);
                        lightChanged = DeviceIdleController.this.mLocalPowerManager.setLightDeviceIdleMode(false);
                    } else {
                        deepChanged = DeviceIdleController.this.mLocalPowerManager.setDeviceIdleMode(false);
                        lightChanged = DeviceIdleController.this.mLocalPowerManager.setLightDeviceIdleMode(true);
                    }
                    try {
                        DeviceIdleController.this.mNetworkPolicyManager.setDeviceIdleMode(true);
                        DeviceIdleController.this.mBatteryStats.noteDeviceIdleMode(msg.what == 2 ? 2 : 1, null, Process.myUid());
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (deepChanged) {
                        DeviceIdleController.this.getContext().sendBroadcastAsUser(DeviceIdleController.this.mIdleIntent, UserHandle.ALL);
                    }
                    if (lightChanged) {
                        DeviceIdleController.this.getContext().sendBroadcastAsUser(DeviceIdleController.this.mLightIdleIntent, UserHandle.ALL);
                    }
                    EventLogTags.writeDeviceIdleOnComplete();
                    break;
                }
                case 4: {
                    EventLogTags.writeDeviceIdleOffStart("unknown");
                    boolean deepChanged = DeviceIdleController.this.mLocalPowerManager.setDeviceIdleMode(false);
                    boolean lightChanged = DeviceIdleController.this.mLocalPowerManager.setLightDeviceIdleMode(false);
                    try {
                        DeviceIdleController.this.mNetworkPolicyManager.setDeviceIdleMode(false);
                        DeviceIdleController.this.mBatteryStats.noteDeviceIdleMode(0, null, Process.myUid());
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (deepChanged) {
                        DeviceIdleController.this.incActiveIdleOps();
                        DeviceIdleController.this.getContext().sendOrderedBroadcastAsUser(DeviceIdleController.this.mIdleIntent, UserHandle.ALL, null, DeviceIdleController.this.mIdleStartedDoneReceiver, null, 0, null, null);
                    }
                    if (lightChanged) {
                        DeviceIdleController.this.incActiveIdleOps();
                        DeviceIdleController.this.getContext().sendOrderedBroadcastAsUser(DeviceIdleController.this.mLightIdleIntent, UserHandle.ALL, null, DeviceIdleController.this.mIdleStartedDoneReceiver, null, 0, null, null);
                    }
                    DeviceIdleController.this.decActiveIdleOps();
                    EventLogTags.writeDeviceIdleOffComplete();
                    break;
                }
                case 5: {
                    String activeReason = (String)msg.obj;
                    int activeUid = msg.arg1;
                    EventLogTags.writeDeviceIdleOffStart(activeReason != null ? activeReason : "unknown");
                    boolean deepChanged = DeviceIdleController.this.mLocalPowerManager.setDeviceIdleMode(false);
                    boolean lightChanged = DeviceIdleController.this.mLocalPowerManager.setLightDeviceIdleMode(false);
                    try {
                        DeviceIdleController.this.mNetworkPolicyManager.setDeviceIdleMode(false);
                        DeviceIdleController.this.mBatteryStats.noteDeviceIdleMode(0, activeReason, activeUid);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (deepChanged) {
                        DeviceIdleController.this.getContext().sendBroadcastAsUser(DeviceIdleController.this.mIdleIntent, UserHandle.ALL);
                    }
                    if (lightChanged) {
                        DeviceIdleController.this.getContext().sendBroadcastAsUser(DeviceIdleController.this.mLightIdleIntent, UserHandle.ALL);
                    }
                    EventLogTags.writeDeviceIdleOffComplete();
                    break;
                }
                case 6: {
                    int uid = msg.arg1;
                    DeviceIdleController.this.checkTempAppWhitelistTimeout(uid);
                    break;
                }
                case 7: {
                    boolean active = msg.arg1 == 1;
                    int size = DeviceIdleController.this.mMaintenanceActivityListeners.beginBroadcast();
                    try {
                        for (int i = 0; i < size; ++i) {
                            try {
                                ((IMaintenanceActivityListener)DeviceIdleController.this.mMaintenanceActivityListeners.getBroadcastItem(i)).onMaintenanceActivityChanged(active);
                                continue;
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                    finally {
                        DeviceIdleController.this.mMaintenanceActivityListeners.finishBroadcast();
                    }
                }
                case 8: {
                    DeviceIdleController.this.decActiveIdleOps();
                }
            }
        }
    }

    private final class Constants
    extends ContentObserver {
        private static final String KEY_LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT = "light_after_inactive_to";
        private static final String KEY_LIGHT_PRE_IDLE_TIMEOUT = "light_pre_idle_to";
        private static final String KEY_LIGHT_IDLE_TIMEOUT = "light_idle_to";
        private static final String KEY_LIGHT_IDLE_FACTOR = "light_idle_factor";
        private static final String KEY_LIGHT_MAX_IDLE_TIMEOUT = "light_max_idle_to";
        private static final String KEY_LIGHT_IDLE_MAINTENANCE_MIN_BUDGET = "light_idle_maintenance_min_budget";
        private static final String KEY_LIGHT_IDLE_MAINTENANCE_MAX_BUDGET = "light_idle_maintenance_max_budget";
        private static final String KEY_MIN_LIGHT_MAINTENANCE_TIME = "min_light_maintenance_time";
        private static final String KEY_MIN_DEEP_MAINTENANCE_TIME = "min_deep_maintenance_time";
        private static final String KEY_INACTIVE_TIMEOUT = "inactive_to";
        private static final String KEY_SENSING_TIMEOUT = "sensing_to";
        private static final String KEY_LOCATING_TIMEOUT = "locating_to";
        private static final String KEY_LOCATION_ACCURACY = "location_accuracy";
        private static final String KEY_MOTION_INACTIVE_TIMEOUT = "motion_inactive_to";
        private static final String KEY_IDLE_AFTER_INACTIVE_TIMEOUT = "idle_after_inactive_to";
        private static final String KEY_IDLE_PENDING_TIMEOUT = "idle_pending_to";
        private static final String KEY_MAX_IDLE_PENDING_TIMEOUT = "max_idle_pending_to";
        private static final String KEY_IDLE_PENDING_FACTOR = "idle_pending_factor";
        private static final String KEY_IDLE_TIMEOUT = "idle_to";
        private static final String KEY_MAX_IDLE_TIMEOUT = "max_idle_to";
        private static final String KEY_IDLE_FACTOR = "idle_factor";
        private static final String KEY_MIN_TIME_TO_ALARM = "min_time_to_alarm";
        private static final String KEY_MAX_TEMP_APP_WHITELIST_DURATION = "max_temp_app_whitelist_duration";
        private static final String KEY_MMS_TEMP_APP_WHITELIST_DURATION = "mms_temp_app_whitelist_duration";
        private static final String KEY_SMS_TEMP_APP_WHITELIST_DURATION = "sms_temp_app_whitelist_duration";
        private static final String KEY_NOTIFICATION_WHITELIST_DURATION = "notification_whitelist_duration";
        public long LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT;
        public long LIGHT_PRE_IDLE_TIMEOUT;
        public long LIGHT_IDLE_TIMEOUT;
        public float LIGHT_IDLE_FACTOR;
        public long LIGHT_MAX_IDLE_TIMEOUT;
        public long LIGHT_IDLE_MAINTENANCE_MIN_BUDGET;
        public long LIGHT_IDLE_MAINTENANCE_MAX_BUDGET;
        public long MIN_LIGHT_MAINTENANCE_TIME;
        public long MIN_DEEP_MAINTENANCE_TIME;
        public long INACTIVE_TIMEOUT;
        public long SENSING_TIMEOUT;
        public long LOCATING_TIMEOUT;
        public float LOCATION_ACCURACY;
        public long MOTION_INACTIVE_TIMEOUT;
        public long IDLE_AFTER_INACTIVE_TIMEOUT;
        public long IDLE_PENDING_TIMEOUT;
        public long MAX_IDLE_PENDING_TIMEOUT;
        public float IDLE_PENDING_FACTOR;
        public long IDLE_TIMEOUT;
        public long MAX_IDLE_TIMEOUT;
        public float IDLE_FACTOR;
        public long MIN_TIME_TO_ALARM;
        public long MAX_TEMP_APP_WHITELIST_DURATION;
        public long MMS_TEMP_APP_WHITELIST_DURATION;
        public long SMS_TEMP_APP_WHITELIST_DURATION;
        public long NOTIFICATION_WHITELIST_DURATION;
        private final ContentResolver mResolver;
        private final boolean mHasWatch;
        private final KeyValueListParser mParser;

        public Constants(Handler handler, ContentResolver resolver) {
            super(handler);
            this.mParser = new KeyValueListParser(',');
            this.mResolver = resolver;
            this.mHasWatch = DeviceIdleController.this.getContext().getPackageManager().hasSystemFeature("android.hardware.type.watch");
            this.mResolver.registerContentObserver(Settings.Global.getUriFor(this.mHasWatch ? "device_idle_constants_watch" : "device_idle_constants"), false, this);
            this.updateConstants();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConstants() {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                try {
                    this.mParser.setString(Settings.Global.getString(this.mResolver, this.mHasWatch ? "device_idle_constants_watch" : "device_idle_constants"));
                }
                catch (IllegalArgumentException e) {
                    Slog.e(DeviceIdleController.TAG, "Bad device idle settings", e);
                }
                this.LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT = this.mParser.getLong(KEY_LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT, 300000L);
                this.LIGHT_PRE_IDLE_TIMEOUT = this.mParser.getLong(KEY_LIGHT_PRE_IDLE_TIMEOUT, 600000L);
                this.LIGHT_IDLE_TIMEOUT = this.mParser.getLong(KEY_LIGHT_IDLE_TIMEOUT, 300000L);
                this.LIGHT_IDLE_FACTOR = this.mParser.getFloat(KEY_LIGHT_IDLE_FACTOR, 2.0f);
                this.LIGHT_MAX_IDLE_TIMEOUT = this.mParser.getLong(KEY_LIGHT_MAX_IDLE_TIMEOUT, 900000L);
                this.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET = this.mParser.getLong(KEY_LIGHT_IDLE_MAINTENANCE_MIN_BUDGET, 60000L);
                this.LIGHT_IDLE_MAINTENANCE_MAX_BUDGET = this.mParser.getLong(KEY_LIGHT_IDLE_MAINTENANCE_MAX_BUDGET, 300000L);
                this.MIN_LIGHT_MAINTENANCE_TIME = this.mParser.getLong(KEY_MIN_LIGHT_MAINTENANCE_TIME, 5000L);
                this.MIN_DEEP_MAINTENANCE_TIME = this.mParser.getLong(KEY_MIN_DEEP_MAINTENANCE_TIME, 30000L);
                long inactiveTimeoutDefault = (long)((this.mHasWatch ? 15 : 30) * 60) * 1000L;
                this.INACTIVE_TIMEOUT = this.mParser.getLong(KEY_INACTIVE_TIMEOUT, inactiveTimeoutDefault);
                this.SENSING_TIMEOUT = this.mParser.getLong(KEY_SENSING_TIMEOUT, 240000L);
                this.LOCATING_TIMEOUT = this.mParser.getLong(KEY_LOCATING_TIMEOUT, 30000L);
                this.LOCATION_ACCURACY = this.mParser.getFloat(KEY_LOCATION_ACCURACY, 20.0f);
                this.MOTION_INACTIVE_TIMEOUT = this.mParser.getLong(KEY_MOTION_INACTIVE_TIMEOUT, 600000L);
                long idleAfterInactiveTimeout = (long)((this.mHasWatch ? 15 : 30) * 60) * 1000L;
                this.IDLE_AFTER_INACTIVE_TIMEOUT = this.mParser.getLong(KEY_IDLE_AFTER_INACTIVE_TIMEOUT, idleAfterInactiveTimeout);
                this.IDLE_PENDING_TIMEOUT = this.mParser.getLong(KEY_IDLE_PENDING_TIMEOUT, 300000L);
                this.MAX_IDLE_PENDING_TIMEOUT = this.mParser.getLong(KEY_MAX_IDLE_PENDING_TIMEOUT, 600000L);
                this.IDLE_PENDING_FACTOR = this.mParser.getFloat(KEY_IDLE_PENDING_FACTOR, 2.0f);
                this.IDLE_TIMEOUT = this.mParser.getLong(KEY_IDLE_TIMEOUT, 3600000L);
                this.MAX_IDLE_TIMEOUT = this.mParser.getLong(KEY_MAX_IDLE_TIMEOUT, 21600000L);
                this.IDLE_FACTOR = this.mParser.getFloat(KEY_IDLE_FACTOR, 2.0f);
                this.MIN_TIME_TO_ALARM = this.mParser.getLong(KEY_MIN_TIME_TO_ALARM, 3600000L);
                this.MAX_TEMP_APP_WHITELIST_DURATION = this.mParser.getLong(KEY_MAX_TEMP_APP_WHITELIST_DURATION, 300000L);
                this.MMS_TEMP_APP_WHITELIST_DURATION = this.mParser.getLong(KEY_MMS_TEMP_APP_WHITELIST_DURATION, 60000L);
                this.SMS_TEMP_APP_WHITELIST_DURATION = this.mParser.getLong(KEY_SMS_TEMP_APP_WHITELIST_DURATION, 20000L);
                this.NOTIFICATION_WHITELIST_DURATION = this.mParser.getLong(KEY_NOTIFICATION_WHITELIST_DURATION, 30000L);
            }
        }

        void dump(PrintWriter pw) {
            pw.println("  Settings:");
            pw.print("    ");
            pw.print(KEY_LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_PRE_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_PRE_IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_IDLE_FACTOR);
            pw.print("=");
            pw.print(this.LIGHT_IDLE_FACTOR);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_MAX_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_MAX_IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_IDLE_MAINTENANCE_MIN_BUDGET);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_IDLE_MAINTENANCE_MAX_BUDGET);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_IDLE_MAINTENANCE_MAX_BUDGET, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MIN_LIGHT_MAINTENANCE_TIME);
            pw.print("=");
            TimeUtils.formatDuration(this.MIN_LIGHT_MAINTENANCE_TIME, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MIN_DEEP_MAINTENANCE_TIME);
            pw.print("=");
            TimeUtils.formatDuration(this.MIN_DEEP_MAINTENANCE_TIME, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_INACTIVE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.INACTIVE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_SENSING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.SENSING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LOCATING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LOCATING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LOCATION_ACCURACY);
            pw.print("=");
            pw.print(this.LOCATION_ACCURACY);
            pw.print("m");
            pw.println();
            pw.print("    ");
            pw.print(KEY_MOTION_INACTIVE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.MOTION_INACTIVE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_AFTER_INACTIVE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.IDLE_AFTER_INACTIVE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_PENDING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.IDLE_PENDING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MAX_IDLE_PENDING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.MAX_IDLE_PENDING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_PENDING_FACTOR);
            pw.print("=");
            pw.println(this.IDLE_PENDING_FACTOR);
            pw.print("    ");
            pw.print(KEY_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MAX_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.MAX_IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_FACTOR);
            pw.print("=");
            pw.println(this.IDLE_FACTOR);
            pw.print("    ");
            pw.print(KEY_MIN_TIME_TO_ALARM);
            pw.print("=");
            TimeUtils.formatDuration(this.MIN_TIME_TO_ALARM, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MAX_TEMP_APP_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.MAX_TEMP_APP_WHITELIST_DURATION, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MMS_TEMP_APP_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.MMS_TEMP_APP_WHITELIST_DURATION, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_SMS_TEMP_APP_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.SMS_TEMP_APP_WHITELIST_DURATION, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_NOTIFICATION_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.NOTIFICATION_WHITELIST_DURATION, pw);
            pw.println();
        }
    }

    private final class MotionListener
    extends TriggerEventListener
    implements SensorEventListener {
        boolean active = false;

        private MotionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTrigger(TriggerEvent event) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                this.active = false;
                DeviceIdleController.this.motionLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSensorChanged(SensorEvent event) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.mSensorManager.unregisterListener(this, DeviceIdleController.this.mMotionSensor);
                this.active = false;
                DeviceIdleController.this.motionLocked();
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        public boolean registerLocked() {
            boolean success = DeviceIdleController.this.mMotionSensor.getReportingMode() == 2 ? DeviceIdleController.this.mSensorManager.requestTriggerSensor(DeviceIdleController.this.mMotionListener, DeviceIdleController.this.mMotionSensor) : DeviceIdleController.this.mSensorManager.registerListener(DeviceIdleController.this.mMotionListener, DeviceIdleController.this.mMotionSensor, 3);
            if (success) {
                this.active = true;
            } else {
                Slog.e(DeviceIdleController.TAG, "Unable to register for " + DeviceIdleController.this.mMotionSensor);
            }
            return success;
        }

        public void unregisterLocked() {
            if (DeviceIdleController.this.mMotionSensor.getReportingMode() == 2) {
                DeviceIdleController.this.mSensorManager.cancelTriggerSensor(DeviceIdleController.this.mMotionListener, DeviceIdleController.this.mMotionSensor);
            } else {
                DeviceIdleController.this.mSensorManager.unregisterListener(DeviceIdleController.this.mMotionListener);
            }
            this.active = false;
        }
    }
}

