/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.INetd;
import android.net.INetworkManagementEventObserver;
import android.net.InterfaceConfiguration;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.Network;
import android.net.NetworkStats;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.UidRange;
import android.net.wifi.WifiConfiguration;
import android.os.Binder;
import android.os.Handler;
import android.os.INetworkActivityListener;
import android.os.INetworkManagementService;
import android.os.PowerManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Log;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.internal.net.NetworkStatsFactory;
import com.android.internal.util.HexDump;
import com.android.internal.util.Preconditions;
import com.android.server.FgThread;
import com.android.server.INativeDaemonConnectorCallbacks;
import com.android.server.NativeDaemonConnector;
import com.android.server.NativeDaemonConnectorException;
import com.android.server.NativeDaemonEvent;
import com.android.server.Watchdog;
import com.android.server.net.LockdownVpnTracker;
import com.google.android.collect.Maps;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;

public class NetworkManagementService
extends INetworkManagementService.Stub
implements Watchdog.Monitor {
    private static final String TAG = "NetworkManagement";
    private static final boolean DBG = Log.isLoggable("NetworkManagement", 3);
    private static final String NETD_TAG = "NetdConnector";
    private static final String NETD_SERVICE_NAME = "netd";
    private static final int MAX_UID_RANGES_PER_COMMAND = 10;
    public static final String LIMIT_GLOBAL_ALERT = "globalAlert";
    public static final String PERMISSION_NETWORK = "NETWORK";
    public static final String PERMISSION_SYSTEM = "SYSTEM";
    public static final int DNS_RESOLVER_DEFAULT_SAMPLE_VALIDITY_SECONDS = 1800;
    public static final int DNS_RESOLVER_DEFAULT_SUCCESS_THRESHOLD_PERCENT = 25;
    public static final int DNS_RESOLVER_DEFAULT_MIN_SAMPLES = 8;
    public static final int DNS_RESOLVER_DEFAULT_MAX_SAMPLES = 64;
    static final String SOFT_AP_COMMAND = "softap";
    static final String SOFT_AP_COMMAND_SUCCESS = "Ok";
    static final int DAEMON_MSG_MOBILE_CONN_REAL_TIME_INFO = 1;
    private final Context mContext;
    private final NativeDaemonConnector mConnector;
    private final Handler mFgHandler;
    private final Handler mDaemonHandler;
    private INetd mNetdService;
    private IBatteryStats mBatteryStats;
    private final Thread mThread;
    private CountDownLatch mConnectedSignal = new CountDownLatch(1);
    private final RemoteCallbackList<INetworkManagementEventObserver> mObservers = new RemoteCallbackList();
    private final NetworkStatsFactory mStatsFactory = new NetworkStatsFactory();
    private Object mQuotaLock = new Object();
    @GuardedBy(value="mQuotaLock")
    private HashMap<String, Long> mActiveQuotas = Maps.newHashMap();
    @GuardedBy(value="mQuotaLock")
    private HashMap<String, Long> mActiveAlerts = Maps.newHashMap();
    @GuardedBy(value="mQuotaLock")
    private SparseBooleanArray mUidRejectOnMetered = new SparseBooleanArray();
    @GuardedBy(value="mQuotaLock")
    private SparseBooleanArray mUidAllowOnMetered = new SparseBooleanArray();
    @GuardedBy(value="mQuotaLock")
    private SparseIntArray mUidCleartextPolicy = new SparseIntArray();
    @GuardedBy(value="mQuotaLock")
    private SparseIntArray mUidFirewallRules = new SparseIntArray();
    @GuardedBy(value="mQuotaLock")
    private SparseIntArray mUidFirewallStandbyRules = new SparseIntArray();
    @GuardedBy(value="mQuotaLock")
    private SparseIntArray mUidFirewallDozableRules = new SparseIntArray();
    @GuardedBy(value="mQuotaLock")
    private SparseIntArray mUidFirewallPowerSaveRules = new SparseIntArray();
    @GuardedBy(value="mQuotaLock")
    final SparseBooleanArray mFirewallChainStates = new SparseBooleanArray();
    @GuardedBy(value="mQuotaLock")
    private boolean mDataSaverMode;
    private Object mIdleTimerLock = new Object();
    private HashMap<String, IdleTimerParams> mActiveIdleTimers = Maps.newHashMap();
    private volatile boolean mBandwidthControlEnabled;
    private volatile boolean mFirewallEnabled;
    private volatile boolean mStrictEnabled;
    private boolean mMobileActivityFromRadio = false;
    private int mLastPowerStateFromRadio = 1;
    private int mLastPowerStateFromWifi = 1;
    private final RemoteCallbackList<INetworkActivityListener> mNetworkActivityListeners = new RemoteCallbackList();
    private boolean mNetworkActive;

    private NetworkManagementService(Context context, String socket) {
        this.mContext = context;
        this.mFgHandler = new Handler(FgThread.get().getLooper());
        PowerManager.WakeLock wl = null;
        this.mConnector = new NativeDaemonConnector(new NetdCallbackReceiver(), socket, 10, NETD_TAG, 160, wl, FgThread.get().getLooper());
        this.mThread = new Thread((Runnable)this.mConnector, NETD_TAG);
        this.mDaemonHandler = new Handler(FgThread.get().getLooper());
        Watchdog.getInstance().addMonitor(this);
    }

    static NetworkManagementService create(Context context, String socket) throws InterruptedException {
        NetworkManagementService service = new NetworkManagementService(context, socket);
        CountDownLatch connectedSignal = service.mConnectedSignal;
        if (DBG) {
            Slog.d(TAG, "Creating NetworkManagementService");
        }
        service.mThread.start();
        if (DBG) {
            Slog.d(TAG, "Awaiting socket connection");
        }
        connectedSignal.await();
        if (DBG) {
            Slog.d(TAG, "Connected");
        }
        service.connectNativeNetdService();
        return service;
    }

    public static NetworkManagementService create(Context context) throws InterruptedException {
        return NetworkManagementService.create(context, NETD_SERVICE_NAME);
    }

    public void systemReady() {
        if (DBG) {
            long start = System.currentTimeMillis();
            this.prepareNativeDaemon();
            long delta = System.currentTimeMillis() - start;
            Slog.d(TAG, "Prepared in " + delta + "ms");
            return;
        }
        this.prepareNativeDaemon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBatteryStats getBatteryStats() {
        NetworkManagementService networkManagementService = this;
        synchronized (networkManagementService) {
            if (this.mBatteryStats != null) {
                return this.mBatteryStats;
            }
            this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
            return this.mBatteryStats;
        }
    }

    @Override
    public void registerObserver(INetworkManagementEventObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mObservers.register(observer);
    }

    @Override
    public void unregisterObserver(INetworkManagementEventObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mObservers.unregister(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInterfaceStatusChanged(String iface, boolean up) {
        int length = this.mObservers.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    this.mObservers.getBroadcastItem(i).interfaceStatusChanged(iface, up);
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mObservers.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInterfaceLinkStateChanged(String iface, boolean up) {
        int length = this.mObservers.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    this.mObservers.getBroadcastItem(i).interfaceLinkStateChanged(iface, up);
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mObservers.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInterfaceAdded(String iface) {
        int length = this.mObservers.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    this.mObservers.getBroadcastItem(i).interfaceAdded(iface);
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mObservers.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInterfaceRemoved(String iface) {
        this.mActiveAlerts.remove(iface);
        this.mActiveQuotas.remove(iface);
        int length = this.mObservers.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    this.mObservers.getBroadcastItem(i).interfaceRemoved(iface);
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mObservers.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLimitReached(String limitName, String iface) {
        int length = this.mObservers.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    this.mObservers.getBroadcastItem(i).limitReached(limitName, iface);
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mObservers.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInterfaceClassActivity(int type, int powerState, long tsNanos, int uid, boolean fromRadio) {
        boolean isActive;
        boolean isMobile = ConnectivityManager.isNetworkTypeMobile(type);
        if (isMobile) {
            if (!fromRadio) {
                if (this.mMobileActivityFromRadio) {
                    powerState = this.mLastPowerStateFromRadio;
                }
            } else {
                this.mMobileActivityFromRadio = true;
            }
            if (this.mLastPowerStateFromRadio != powerState) {
                this.mLastPowerStateFromRadio = powerState;
                try {
                    this.getBatteryStats().noteMobileRadioPowerState(powerState, tsNanos, uid);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        if (ConnectivityManager.isNetworkTypeWifi(type) && this.mLastPowerStateFromWifi != powerState) {
            this.mLastPowerStateFromWifi = powerState;
            try {
                this.getBatteryStats().noteWifiRadioPowerState(powerState, tsNanos);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        boolean bl = isActive = powerState == 2 || powerState == 3;
        if (!isMobile || fromRadio || !this.mMobileActivityFromRadio) {
            int length = this.mObservers.beginBroadcast();
            try {
                for (int i = 0; i < length; ++i) {
                    try {
                        this.mObservers.getBroadcastItem(i).interfaceClassDataActivityChanged(Integer.toString(type), isActive, tsNanos);
                        continue;
                    }
                    catch (RemoteException | RuntimeException exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.mObservers.finishBroadcast();
            }
        }
        boolean report = false;
        Object object = this.mIdleTimerLock;
        synchronized (object) {
            if (this.mActiveIdleTimers.isEmpty()) {
                isActive = true;
            }
            if (this.mNetworkActive != isActive) {
                this.mNetworkActive = isActive;
                report = isActive;
            }
        }
        if (report) {
            this.reportNetworkActive();
        }
    }

    private void syncFirewallChainLocked(int chain, SparseIntArray uidFirewallRules, String name) {
        int size = uidFirewallRules.size();
        if (size > 0) {
            Object rules = uidFirewallRules.clone();
            uidFirewallRules.clear();
            if (DBG) {
                Slog.d(TAG, "Pushing " + size + " active firewall " + name + "UID rules");
            }
            for (int i = 0; i < ((SparseIntArray)rules).size(); ++i) {
                this.setFirewallUidRuleLocked(chain, ((SparseIntArray)rules).keyAt(i), ((SparseIntArray)rules).valueAt(i));
            }
        }
    }

    private void connectNativeNetdService() {
        boolean nativeServiceAvailable = false;
        try {
            this.mNetdService = INetd.Stub.asInterface(ServiceManager.getService(NETD_SERVICE_NAME));
            nativeServiceAvailable = this.mNetdService.isAlive();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (!nativeServiceAvailable) {
            Slog.wtf(TAG, "Can't connect to NativeNetdService netd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNativeDaemon() {
        this.mBandwidthControlEnabled = false;
        boolean hasKernelSupport = new File("/proc/net/xt_qtaguid/ctrl").exists();
        if (hasKernelSupport) {
            Slog.d(TAG, "enabling bandwidth control");
            try {
                this.mConnector.execute("bandwidth", "enable");
                this.mBandwidthControlEnabled = true;
            }
            catch (NativeDaemonConnectorException e) {
                Log.wtf(TAG, "problem enabling bandwidth controls", e);
            }
        } else {
            Slog.i(TAG, "not enabling bandwidth control");
        }
        SystemProperties.set("net.qtaguid_enabled", this.mBandwidthControlEnabled ? "1" : "0");
        if (this.mBandwidthControlEnabled) {
            try {
                this.getBatteryStats().noteNetworkStatsEnabled();
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        try {
            this.mConnector.execute("strict", "enable");
            this.mStrictEnabled = true;
        }
        catch (NativeDaemonConnectorException e) {
            Log.wtf(TAG, "Failed strict enable", e);
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            this.setDataSaverModeEnabled(this.mDataSaverMode);
            int size = this.mActiveQuotas.size();
            if (size > 0) {
                if (DBG) {
                    Slog.d(TAG, "Pushing " + size + " active quota rules");
                }
                HashMap<String, Long> activeQuotas = this.mActiveQuotas;
                this.mActiveQuotas = Maps.newHashMap();
                for (Map.Entry<String, Long> entry : activeQuotas.entrySet()) {
                    this.setInterfaceQuota(entry.getKey(), entry.getValue());
                }
            }
            if ((size = this.mActiveAlerts.size()) > 0) {
                if (DBG) {
                    Slog.d(TAG, "Pushing " + size + " active alert rules");
                }
                HashMap<String, Long> activeAlerts = this.mActiveAlerts;
                this.mActiveAlerts = Maps.newHashMap();
                for (Map.Entry<String, Long> entry : activeAlerts.entrySet()) {
                    this.setInterfaceAlert(entry.getKey(), entry.getValue());
                }
            }
            if ((size = this.mUidRejectOnMetered.size()) > 0) {
                if (DBG) {
                    Slog.d(TAG, "Pushing " + size + " UIDs to metered whitelist rules");
                }
                SparseBooleanArray uidRejectOnQuota = this.mUidRejectOnMetered;
                this.mUidRejectOnMetered = new SparseBooleanArray();
                for (int i = 0; i < uidRejectOnQuota.size(); ++i) {
                    this.setUidMeteredNetworkBlacklist(uidRejectOnQuota.keyAt(i), uidRejectOnQuota.valueAt(i));
                }
            }
            if ((size = this.mUidAllowOnMetered.size()) > 0) {
                if (DBG) {
                    Slog.d(TAG, "Pushing " + size + " UIDs to metered blacklist rules");
                }
                SparseBooleanArray uidAcceptOnQuota = this.mUidAllowOnMetered;
                this.mUidAllowOnMetered = new SparseBooleanArray();
                for (int i = 0; i < uidAcceptOnQuota.size(); ++i) {
                    this.setUidMeteredNetworkWhitelist(uidAcceptOnQuota.keyAt(i), uidAcceptOnQuota.valueAt(i));
                }
            }
            if ((size = this.mUidCleartextPolicy.size()) > 0) {
                if (DBG) {
                    Slog.d(TAG, "Pushing " + size + " active UID cleartext policies");
                }
                SparseIntArray local = this.mUidCleartextPolicy;
                this.mUidCleartextPolicy = new SparseIntArray();
                for (int i = 0; i < local.size(); ++i) {
                    this.setUidCleartextNetworkPolicy(local.keyAt(i), local.valueAt(i));
                }
            }
            this.setFirewallEnabled(this.mFirewallEnabled || LockdownVpnTracker.isEnabled());
            this.syncFirewallChainLocked(0, this.mUidFirewallRules, "");
            this.syncFirewallChainLocked(2, this.mUidFirewallStandbyRules, "standby ");
            this.syncFirewallChainLocked(1, this.mUidFirewallDozableRules, "dozable ");
            this.syncFirewallChainLocked(3, this.mUidFirewallPowerSaveRules, "powersave ");
            if (this.mFirewallChainStates.get(2)) {
                this.setFirewallChainEnabled(2, true);
            }
            if (this.mFirewallChainStates.get(1)) {
                this.setFirewallChainEnabled(1, true);
            }
            if (this.mFirewallChainStates.get(3)) {
                this.setFirewallChainEnabled(3, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAddressUpdated(String iface, LinkAddress address) {
        int length = this.mObservers.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    this.mObservers.getBroadcastItem(i).addressUpdated(iface, address);
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mObservers.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAddressRemoved(String iface, LinkAddress address) {
        int length = this.mObservers.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    this.mObservers.getBroadcastItem(i).addressRemoved(iface, address);
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mObservers.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInterfaceDnsServerInfo(String iface, long lifetime, String[] addresses) {
        int length = this.mObservers.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    this.mObservers.getBroadcastItem(i).interfaceDnsServerInfo(iface, lifetime, addresses);
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mObservers.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRouteChange(String action, RouteInfo route) {
        int length = this.mObservers.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    if (action.equals("updated")) {
                        this.mObservers.getBroadcastItem(i).routeUpdated(route);
                        continue;
                    }
                    this.mObservers.getBroadcastItem(i).routeRemoved(route);
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mObservers.finishBroadcast();
        }
    }

    @Override
    public String[] listInterfaces() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return NativeDaemonEvent.filterMessageList(this.mConnector.executeForList("interface", "list"), 110);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public InterfaceConfiguration getInterfaceConfig(String iface) {
        InterfaceConfiguration cfg;
        NativeDaemonEvent event;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            event = this.mConnector.execute("interface", "getcfg", iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        event.checkCode(213);
        StringTokenizer st = new StringTokenizer(event.getMessage());
        try {
            cfg = new InterfaceConfiguration();
            cfg.setHardwareAddress(st.nextToken(" "));
            InetAddress addr = null;
            int prefixLength = 0;
            try {
                addr = NetworkUtils.numericToInetAddress(st.nextToken());
            }
            catch (IllegalArgumentException iae) {
                Slog.e(TAG, "Failed to parse ipaddr", iae);
            }
            try {
                prefixLength = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                Slog.e(TAG, "Failed to parse prefixLength", nfe);
            }
            cfg.setLinkAddress(new LinkAddress(addr, prefixLength));
            while (st.hasMoreTokens()) {
                cfg.setFlag(st.nextToken());
            }
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalStateException("Invalid response from daemon: " + event);
        }
        return cfg;
    }

    @Override
    public void setInterfaceConfig(String iface, InterfaceConfiguration cfg) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        LinkAddress linkAddr = cfg.getLinkAddress();
        if (linkAddr == null || linkAddr.getAddress() == null) {
            throw new IllegalStateException("Null LinkAddress given");
        }
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("interface", "setcfg", iface, linkAddr.getAddress().getHostAddress(), linkAddr.getPrefixLength());
        for (String flag : cfg.getFlags()) {
            cmd.appendArg(flag);
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setInterfaceDown(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        InterfaceConfiguration ifcg = this.getInterfaceConfig(iface);
        ifcg.setInterfaceDown();
        this.setInterfaceConfig(iface, ifcg);
    }

    @Override
    public void setInterfaceUp(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        InterfaceConfiguration ifcg = this.getInterfaceConfig(iface);
        ifcg.setInterfaceUp();
        this.setInterfaceConfig(iface, ifcg);
    }

    @Override
    public void setInterfaceIpv6PrivacyExtensions(String iface, boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "ipv6privacyextensions", iface, enable ? "enable" : "disable");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void clearInterfaceAddresses(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "clearaddrs", iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void enableIpv6(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "ipv6", iface, "enable");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void disableIpv6(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "ipv6", iface, "disable");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setInterfaceIpv6NdOffload(String iface, boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("interface", "ipv6ndoffload", iface, enable ? "enable" : "disable");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void addRoute(int netId, RouteInfo route) {
        this.modifyRoute("add", "" + netId, route);
    }

    @Override
    public void removeRoute(int netId, RouteInfo route) {
        this.modifyRoute("remove", "" + netId, route);
    }

    private void modifyRoute(String action, String netId, RouteInfo route) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("network", "route", action, netId);
        cmd.appendArg(route.getInterface());
        cmd.appendArg(route.getDestination().toString());
        switch (route.getType()) {
            case 1: {
                if (!route.hasGateway()) break;
                cmd.appendArg(route.getGateway().getHostAddress());
                break;
            }
            case 7: {
                cmd.appendArg("unreachable");
                break;
            }
            case 9: {
                cmd.appendArg("throw");
            }
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> readRouteList(String filename) {
        FileInputStream fstream = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            String s;
            fstream = new FileInputStream(filename);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((s = br.readLine()) != null && s.length() != 0) {
                list.add(s);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fstream != null) {
                try {
                    fstream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    @Override
    public void setMtu(String iface, int mtu) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            NativeDaemonEvent event = this.mConnector.execute("interface", "setmtu", iface, mtu);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void shutdown() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SHUTDOWN", TAG);
        Slog.i(TAG, "Shutting down");
    }

    @Override
    public boolean getIpForwardingEnabled() throws IllegalStateException {
        NativeDaemonEvent event;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            event = this.mConnector.execute("ipfwd", "status");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        event.checkCode(211);
        return event.getMessage().endsWith("enabled");
    }

    @Override
    public void setIpForwardingEnabled(boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("ipfwd", enable ? "enable" : "disable", "tethering");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void startTethering(String[] dhcpRange) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("tether", "start");
        for (String d : dhcpRange) {
            cmd.appendArg(d);
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void stopTethering() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("tether", "stop");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public boolean isTetheringStarted() {
        NativeDaemonEvent event;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            event = this.mConnector.execute("tether", "status");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        event.checkCode(210);
        return event.getMessage().endsWith("started");
    }

    @Override
    public void tetherInterface(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("tether", "interface", "add", iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>();
        routes.add(new RouteInfo(this.getInterfaceConfig(iface).getLinkAddress(), null, iface));
        this.addInterfaceToLocalNetwork(iface, routes);
    }

    @Override
    public void untetherInterface(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("tether", "interface", "remove", iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        this.removeInterfaceFromLocalNetwork(iface);
    }

    @Override
    public String[] listTetheredInterfaces() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return NativeDaemonEvent.filterMessageList(this.mConnector.executeForList("tether", "interface", "list"), 111);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setDnsForwarders(Network network, String[] dns) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        int netId = network != null ? network.netId : 0;
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("tether", "dns", "set", netId);
        for (String s : dns) {
            cmd.appendArg(NetworkUtils.numericToInetAddress(s).getHostAddress());
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public String[] getDnsForwarders() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return NativeDaemonEvent.filterMessageList(this.mConnector.executeForList("tether", "dns", "list"), 112);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    private List<InterfaceAddress> excludeLinkLocal(List<InterfaceAddress> addresses) {
        ArrayList<InterfaceAddress> filtered = new ArrayList<InterfaceAddress>(addresses.size());
        for (InterfaceAddress ia : addresses) {
            if (ia.getAddress().isLinkLocalAddress()) continue;
            filtered.add(ia);
        }
        return filtered;
    }

    private void modifyInterfaceForward(boolean add, String fromIface, String toIface) {
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("ipfwd", add ? "add" : "remove", fromIface, toIface);
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void startInterfaceForwarding(String fromIface, String toIface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.modifyInterfaceForward(true, fromIface, toIface);
    }

    @Override
    public void stopInterfaceForwarding(String fromIface, String toIface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.modifyInterfaceForward(false, fromIface, toIface);
    }

    private void modifyNat(String action, String internalInterface, String externalInterface) throws SocketException {
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("nat", action, internalInterface, externalInterface);
        NetworkInterface internalNetworkInterface = NetworkInterface.getByName(internalInterface);
        if (internalNetworkInterface == null) {
            cmd.appendArg("0");
        } else {
            List<InterfaceAddress> interfaceAddresses = this.excludeLinkLocal(internalNetworkInterface.getInterfaceAddresses());
            cmd.appendArg(interfaceAddresses.size());
            for (InterfaceAddress ia : interfaceAddresses) {
                InetAddress addr = NetworkUtils.getNetworkPart(ia.getAddress(), ia.getNetworkPrefixLength());
                cmd.appendArg(addr.getHostAddress() + "/" + ia.getNetworkPrefixLength());
            }
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void enableNat(String internalInterface, String externalInterface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.modifyNat("enable", internalInterface, externalInterface);
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void disableNat(String internalInterface, String externalInterface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.modifyNat("disable", internalInterface, externalInterface);
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String[] listTtys() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return NativeDaemonEvent.filterMessageList(this.mConnector.executeForList("list_ttys", new Object[0]), 113);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void attachPppd(String tty, String localAddr, String remoteAddr, String dns1Addr, String dns2Addr) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("pppd", "attach", tty, NetworkUtils.numericToInetAddress(localAddr).getHostAddress(), NetworkUtils.numericToInetAddress(remoteAddr).getHostAddress(), NetworkUtils.numericToInetAddress(dns1Addr).getHostAddress(), NetworkUtils.numericToInetAddress(dns2Addr).getHostAddress());
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void detachPppd(String tty) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("pppd", "detach", tty);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    private void executeOrLogWithMessage(String command, Object[] args, int expectedResponseCode, String expectedResponseMessage, String logMsg) throws NativeDaemonConnectorException {
        NativeDaemonEvent event = this.mConnector.execute(command, args);
        if (event.getCode() != expectedResponseCode || !event.getMessage().equals(expectedResponseMessage)) {
            Log.e(TAG, logMsg + ": event = " + event);
        }
    }

    @Override
    public void startAccessPoint(WifiConfiguration wifiConfig, String wlanIface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        String logMsg = "startAccessPoint Error setting up softap";
        try {
            Object[] args = wifiConfig == null ? new Object[]{"set", wlanIface} : new Object[]{"set", wlanIface, wifiConfig.SSID, "broadcast", Integer.toString(wifiConfig.apChannel), NetworkManagementService.getSecurityType(wifiConfig), new NativeDaemonConnector.SensitiveArg(wifiConfig.preSharedKey)};
            this.executeOrLogWithMessage(SOFT_AP_COMMAND, args, 214, SOFT_AP_COMMAND_SUCCESS, logMsg);
            logMsg = "startAccessPoint Error starting softap";
            args = new Object[]{"startap"};
            this.executeOrLogWithMessage(SOFT_AP_COMMAND, args, 214, SOFT_AP_COMMAND_SUCCESS, logMsg);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    private static String getSecurityType(WifiConfiguration wifiConfig) {
        switch (wifiConfig.getAuthType()) {
            case 1: {
                return "wpa-psk";
            }
            case 4: {
                return "wpa2-psk";
            }
        }
        return "open";
    }

    @Override
    public void wifiFirmwareReload(String wlanIface, String mode) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object[] args = new Object[]{"fwreload", wlanIface, mode};
        String logMsg = "wifiFirmwareReload Error reloading " + wlanIface + " fw in " + mode + " mode";
        try {
            this.executeOrLogWithMessage(SOFT_AP_COMMAND, args, 214, SOFT_AP_COMMAND_SUCCESS, logMsg);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        this.mConnector.waitForCallbacks();
    }

    @Override
    public void stopAccessPoint(String wlanIface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object[] args = new Object[]{"stopap"};
        String logMsg = "stopAccessPoint Error stopping softap";
        try {
            this.executeOrLogWithMessage(SOFT_AP_COMMAND, args, 214, SOFT_AP_COMMAND_SUCCESS, logMsg);
            this.wifiFirmwareReload(wlanIface, "STA");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setAccessPoint(WifiConfiguration wifiConfig, String wlanIface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        String logMsg = "startAccessPoint Error setting up softap";
        try {
            Object[] args = wifiConfig == null ? new Object[]{"set", wlanIface} : new Object[]{"set", wlanIface, wifiConfig.SSID, "broadcast", "6", NetworkManagementService.getSecurityType(wifiConfig), new NativeDaemonConnector.SensitiveArg(wifiConfig.preSharedKey)};
            this.executeOrLogWithMessage(SOFT_AP_COMMAND, args, 214, SOFT_AP_COMMAND_SUCCESS, logMsg);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIdleTimer(String iface, int timeout, final int type) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (DBG) {
            Slog.d(TAG, "Adding idletimer");
        }
        Object object = this.mIdleTimerLock;
        synchronized (object) {
            IdleTimerParams params = this.mActiveIdleTimers.get(iface);
            if (params != null) {
                ++params.networkCount;
                return;
            }
            try {
                this.mConnector.execute("idletimer", "add", iface, Integer.toString(timeout), Integer.toString(type));
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
            this.mActiveIdleTimers.put(iface, new IdleTimerParams(timeout, type));
            if (ConnectivityManager.isNetworkTypeMobile(type)) {
                this.mNetworkActive = false;
            }
            this.mDaemonHandler.post(new Runnable(){

                @Override
                public void run() {
                    NetworkManagementService.this.notifyInterfaceClassActivity(type, 3, SystemClock.elapsedRealtimeNanos(), -1, false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdleTimer(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (DBG) {
            Slog.d(TAG, "Removing idletimer");
        }
        Object object = this.mIdleTimerLock;
        synchronized (object) {
            final IdleTimerParams params = this.mActiveIdleTimers.get(iface);
            if (params == null || --params.networkCount > 0) {
                return;
            }
            try {
                this.mConnector.execute("idletimer", "remove", iface, Integer.toString(params.timeout), Integer.toString(params.type));
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
            this.mActiveIdleTimers.remove(iface);
            this.mDaemonHandler.post(new Runnable(){

                @Override
                public void run() {
                    NetworkManagementService.this.notifyInterfaceClassActivity(params.type, 1, SystemClock.elapsedRealtimeNanos(), -1, false);
                }
            });
        }
    }

    @Override
    public NetworkStats getNetworkStatsSummaryDev() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsSummaryDev();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NetworkStats getNetworkStatsSummaryXt() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsSummaryXt();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NetworkStats getNetworkStatsDetail() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsDetail(-1, null, -1, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterfaceQuota(String iface, long quotaBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (this.mActiveQuotas.containsKey(iface)) {
                throw new IllegalStateException("iface " + iface + " already has quota");
            }
            try {
                this.mConnector.execute("bandwidth", "setiquota", iface, quotaBytes);
                this.mActiveQuotas.put(iface, quotaBytes);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterfaceQuota(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (!this.mActiveQuotas.containsKey(iface)) {
                return;
            }
            this.mActiveQuotas.remove(iface);
            this.mActiveAlerts.remove(iface);
            try {
                this.mConnector.execute("bandwidth", "removeiquota", iface);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterfaceAlert(String iface, long alertBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        if (!this.mActiveQuotas.containsKey(iface)) {
            throw new IllegalStateException("setting alert requires existing quota on iface");
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (this.mActiveAlerts.containsKey(iface)) {
                throw new IllegalStateException("iface " + iface + " already has alert");
            }
            try {
                this.mConnector.execute("bandwidth", "setinterfacealert", iface, alertBytes);
                this.mActiveAlerts.put(iface, alertBytes);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterfaceAlert(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (!this.mActiveAlerts.containsKey(iface)) {
                return;
            }
            try {
                this.mConnector.execute("bandwidth", "removeinterfacealert", iface);
                this.mActiveAlerts.remove(iface);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    @Override
    public void setGlobalAlert(long alertBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        try {
            this.mConnector.execute("bandwidth", "setglobalalert", alertBytes);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUidOnMeteredNetworkList(SparseBooleanArray quotaList, int uid, boolean blacklist, boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        String chain = blacklist ? "naughtyapps" : "niceapps";
        String suffix = enable ? "add" : "remove";
        Object object = this.mQuotaLock;
        synchronized (object) {
            boolean oldEnable = quotaList.get(uid, false);
            if (oldEnable == enable) {
                return;
            }
            try {
                this.mConnector.execute("bandwidth", suffix + chain, uid);
                if (enable) {
                    quotaList.put(uid, true);
                } else {
                    quotaList.delete(uid);
                }
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    @Override
    public void setUidMeteredNetworkBlacklist(int uid, boolean enable) {
        this.setUidOnMeteredNetworkList(this.mUidRejectOnMetered, uid, true, enable);
    }

    @Override
    public void setUidMeteredNetworkWhitelist(int uid, boolean enable) {
        this.setUidOnMeteredNetworkList(this.mUidAllowOnMetered, uid, false, enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDataSaverModeEnabled(boolean enable) {
        if (DBG) {
            Log.d(TAG, "setDataSaverMode: " + enable);
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (this.mDataSaverMode == enable) {
                Log.w(TAG, "setDataSaverMode(): already " + this.mDataSaverMode);
                return true;
            }
            try {
                boolean changed = this.mNetdService.bandwidthEnableDataSaver(enable);
                if (changed) {
                    this.mDataSaverMode = enable;
                } else {
                    Log.w(TAG, "setDataSaverMode(" + enable + "): netd command silently failed");
                }
                return changed;
            }
            catch (RemoteException e) {
                Log.w(TAG, "setDataSaverMode(" + enable + "): netd command failed", e);
                return false;
            }
        }
    }

    @Override
    public void setAllowOnlyVpnForUids(boolean add, UidRange[] uidRanges) throws ServiceSpecificException {
        try {
            this.mNetdService.networkRejectNonSecureVpn(add, uidRanges);
        }
        catch (ServiceSpecificException e) {
            Log.w(TAG, "setAllowOnlyVpnForUids(" + add + ", " + Arrays.toString(uidRanges) + "): netd command failed", e);
            throw e;
        }
        catch (RemoteException e) {
            Log.w(TAG, "setAllowOnlyVpnForUids(" + add + ", " + Arrays.toString(uidRanges) + "): netd command failed", e);
            throw e.rethrowAsRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUidCleartextNetworkPolicy(int uid, int policy) {
        if (Binder.getCallingUid() != uid) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            String policyString;
            int oldPolicy = this.mUidCleartextPolicy.get(uid, 0);
            if (oldPolicy == policy) {
                return;
            }
            if (!this.mStrictEnabled) {
                this.mUidCleartextPolicy.put(uid, policy);
                return;
            }
            switch (policy) {
                case 0: {
                    policyString = "accept";
                    break;
                }
                case 1: {
                    policyString = "log";
                    break;
                }
                case 2: {
                    policyString = "reject";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown policy " + policy);
                }
            }
            try {
                this.mConnector.execute("strict", "set_uid_cleartext_policy", uid, policyString);
                this.mUidCleartextPolicy.put(uid, policy);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    @Override
    public boolean isBandwidthControlEnabled() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        return this.mBandwidthControlEnabled;
    }

    @Override
    public NetworkStats getNetworkStatsUidDetail(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsDetail(uid, null, -1, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NetworkStats getNetworkStatsTethering() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 1);
        try {
            NativeDaemonEvent[] events;
            for (NativeDaemonEvent event : events = this.mConnector.executeForList("bandwidth", "gettetherstats")) {
                if (event.getCode() != 114) continue;
                StringTokenizer tok = new StringTokenizer(event.getMessage());
                try {
                    String ifaceIn = tok.nextToken();
                    String ifaceOut = tok.nextToken();
                    NetworkStats.Entry entry = new NetworkStats.Entry();
                    entry.iface = ifaceOut;
                    entry.uid = -5;
                    entry.set = 0;
                    entry.tag = 0;
                    entry.rxBytes = Long.parseLong(tok.nextToken());
                    entry.rxPackets = Long.parseLong(tok.nextToken());
                    entry.txBytes = Long.parseLong(tok.nextToken());
                    entry.txPackets = Long.parseLong(tok.nextToken());
                    stats.combineValues(entry);
                }
                catch (NoSuchElementException e) {
                    throw new IllegalStateException("problem parsing tethering stats: " + event);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("problem parsing tethering stats: " + event);
                }
            }
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        return stats;
    }

    @Override
    public void setDnsConfigurationForNetwork(int netId, String[] servers, String domains) {
        int successThreshold;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        ContentResolver resolver = this.mContext.getContentResolver();
        int sampleValidity = Settings.Global.getInt(resolver, "dns_resolver_sample_validity_seconds", 1800);
        if (sampleValidity < 0 || sampleValidity > 65535) {
            Slog.w(TAG, "Invalid sampleValidity=" + sampleValidity + ", using default=" + 1800);
            sampleValidity = 1800;
        }
        if ((successThreshold = Settings.Global.getInt(resolver, "dns_resolver_success_threshold_percent", 25)) < 0 || successThreshold > 100) {
            Slog.w(TAG, "Invalid successThreshold=" + successThreshold + ", using default=" + 25);
            successThreshold = 25;
        }
        int minSamples = Settings.Global.getInt(resolver, "dns_resolver_min_samples", 8);
        int maxSamples = Settings.Global.getInt(resolver, "dns_resolver_max_samples", 64);
        if (minSamples < 0 || minSamples > maxSamples || maxSamples > 64) {
            Slog.w(TAG, "Invalid sample count (min, max)=(" + minSamples + ", " + maxSamples + "), using default=(" + 8 + ", " + 64 + ")");
            minSamples = 8;
            maxSamples = 64;
        }
        String[] domainStrs = domains == null ? new String[]{} : domains.split(" ");
        int[] params = new int[]{sampleValidity, successThreshold, minSamples, maxSamples};
        try {
            this.mNetdService.setResolverConfiguration(netId, servers, domainStrs, params);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDnsServersForNetwork(int netId, String[] servers, String domains) {
        NativeDaemonConnector.Command cmd;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (servers.length > 0) {
            cmd = new NativeDaemonConnector.Command("resolver", "setnetdns", netId, domains == null ? "" : domains);
            for (String s : servers) {
                InetAddress a = NetworkUtils.numericToInetAddress(s);
                if (a.isAnyLocalAddress()) continue;
                cmd.appendArg(a.getHostAddress());
            }
        } else {
            cmd = new NativeDaemonConnector.Command("resolver", "clearnetdns", netId);
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void addVpnUidRanges(int netId, UidRange[] ranges) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object[] argv = new Object[13];
        argv[0] = "users";
        argv[1] = "add";
        argv[2] = netId;
        int argc = 3;
        for (int i = 0; i < ranges.length; ++i) {
            argv[argc++] = ranges[i].toString();
            if (i != ranges.length - 1 && argc != argv.length) continue;
            try {
                this.mConnector.execute("network", Arrays.copyOf(argv, argc));
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
            argc = 3;
        }
    }

    @Override
    public void removeVpnUidRanges(int netId, UidRange[] ranges) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object[] argv = new Object[13];
        argv[0] = "users";
        argv[1] = "remove";
        argv[2] = netId;
        int argc = 3;
        for (int i = 0; i < ranges.length; ++i) {
            argv[argc++] = ranges[i].toString();
            if (i != ranges.length - 1 && argc != argv.length) continue;
            try {
                this.mConnector.execute("network", Arrays.copyOf(argv, argc));
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
            argc = 3;
        }
    }

    @Override
    public void setFirewallEnabled(boolean enabled) {
        NetworkManagementService.enforceSystemUid();
        try {
            this.mConnector.execute("firewall", "enable", enabled ? "whitelist" : "blacklist");
            this.mFirewallEnabled = enabled;
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public boolean isFirewallEnabled() {
        NetworkManagementService.enforceSystemUid();
        return this.mFirewallEnabled;
    }

    @Override
    public void setFirewallInterfaceRule(String iface, boolean allow) {
        NetworkManagementService.enforceSystemUid();
        Preconditions.checkState(this.mFirewallEnabled);
        String rule = allow ? "allow" : "deny";
        try {
            this.mConnector.execute("firewall", "set_interface_rule", iface, rule);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setFirewallEgressSourceRule(String addr, boolean allow) {
        NetworkManagementService.enforceSystemUid();
        Preconditions.checkState(this.mFirewallEnabled);
        String rule = allow ? "allow" : "deny";
        try {
            this.mConnector.execute("firewall", "set_egress_source_rule", addr, rule);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setFirewallEgressDestRule(String addr, int port, boolean allow) {
        NetworkManagementService.enforceSystemUid();
        Preconditions.checkState(this.mFirewallEnabled);
        String rule = allow ? "allow" : "deny";
        try {
            this.mConnector.execute("firewall", "set_egress_dest_rule", addr, port, rule);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    private void closeSocketsForFirewallChainLocked(int chain, String chainName) {
        int i;
        int[] exemptUids;
        UidRange[] ranges;
        SparseIntArray rules = this.getUidFirewallRules(chain);
        int numUids = 0;
        if (this.getFirewallType(chain) == 0) {
            ranges = new UidRange[]{new UidRange(10000, Integer.MAX_VALUE)};
            exemptUids = new int[rules.size()];
            for (i = 0; i < exemptUids.length; ++i) {
                if (rules.valueAt(i) != 1) continue;
                exemptUids[numUids] = rules.keyAt(i);
                ++numUids;
            }
            if (numUids != exemptUids.length) {
                exemptUids = Arrays.copyOf(exemptUids, numUids);
            }
        } else {
            ranges = new UidRange[rules.size()];
            for (i = 0; i < ranges.length; ++i) {
                if (rules.valueAt(i) != 2) continue;
                int uid = rules.keyAt(i);
                ranges[numUids] = new UidRange(uid, uid);
                ++numUids;
            }
            if (numUids != ranges.length) {
                ranges = Arrays.copyOf(ranges, numUids);
            }
            exemptUids = new int[]{};
        }
        try {
            this.mNetdService.socketDestroy(ranges, exemptUids);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Slog.e(TAG, "Error closing sockets after enabling chain " + chainName + ": " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFirewallChainEnabled(int chain, boolean enable) {
        NetworkManagementService.enforceSystemUid();
        Object object = this.mQuotaLock;
        synchronized (object) {
            String chainName;
            if (this.mFirewallChainStates.get(chain) == enable) {
                return;
            }
            this.mFirewallChainStates.put(chain, enable);
            String operation = enable ? "enable_chain" : "disable_chain";
            switch (chain) {
                case 2: {
                    chainName = "standby";
                    break;
                }
                case 1: {
                    chainName = "dozable";
                    break;
                }
                case 3: {
                    chainName = "powersave";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad child chain: " + chain);
                }
            }
            try {
                this.mConnector.execute("firewall", operation, chainName);
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
            if (enable) {
                if (DBG) {
                    Slog.d(TAG, "Closing sockets after enabling chain " + chainName);
                }
                this.closeSocketsForFirewallChainLocked(chain, chainName);
            }
        }
    }

    private int getFirewallType(int chain) {
        switch (chain) {
            case 2: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 3: {
                return 0;
            }
        }
        return this.isFirewallEnabled() ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFirewallUidRules(int chain, int[] uids, int[] rules) {
        NetworkManagementService.enforceSystemUid();
        Object object = this.mQuotaLock;
        synchronized (object) {
            int uid;
            int index;
            SparseIntArray uidFirewallRules = this.getUidFirewallRules(chain);
            SparseIntArray newRules = new SparseIntArray();
            for (int index2 = uids.length - 1; index2 >= 0; --index2) {
                int uid2 = uids[index2];
                int rule = rules[index2];
                this.updateFirewallUidRuleLocked(chain, uid2, rule);
                newRules.put(uid2, rule);
            }
            SparseIntArray rulesToRemove = new SparseIntArray();
            for (index = uidFirewallRules.size() - 1; index >= 0; --index) {
                uid = uidFirewallRules.keyAt(index);
                if (newRules.indexOfKey(uid) >= 0) continue;
                rulesToRemove.put(uid, 0);
            }
            for (index = rulesToRemove.size() - 1; index >= 0; --index) {
                uid = rulesToRemove.keyAt(index);
                this.updateFirewallUidRuleLocked(chain, uid, 0);
            }
            try {
                switch (chain) {
                    case 1: {
                        this.mNetdService.firewallReplaceUidChain("fw_dozable", true, uids);
                        break;
                    }
                    case 2: {
                        this.mNetdService.firewallReplaceUidChain("fw_standby", false, uids);
                        break;
                    }
                    case 3: {
                        this.mNetdService.firewallReplaceUidChain("fw_powersave", true, uids);
                        break;
                    }
                    default: {
                        Slog.d(TAG, "setFirewallUidRules() called on invalid chain: " + chain);
                        break;
                    }
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Error flushing firewall chain " + chain, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFirewallUidRule(int chain, int uid, int rule) {
        NetworkManagementService.enforceSystemUid();
        Object object = this.mQuotaLock;
        synchronized (object) {
            this.setFirewallUidRuleLocked(chain, uid, rule);
        }
    }

    private void setFirewallUidRuleLocked(int chain, int uid, int rule) {
        if (this.updateFirewallUidRuleLocked(chain, uid, rule)) {
            try {
                this.mConnector.execute("firewall", "set_uid_rule", this.getFirewallChainName(chain), uid, this.getFirewallRuleName(chain, rule));
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
        }
    }

    private boolean updateFirewallUidRuleLocked(int chain, int uid, int rule) {
        SparseIntArray uidFirewallRules = this.getUidFirewallRules(chain);
        int oldUidFirewallRule = uidFirewallRules.get(uid, 0);
        if (DBG) {
            Slog.d(TAG, "oldRule = " + oldUidFirewallRule + ", newRule=" + rule + " for uid=" + uid + " on chain " + chain);
        }
        if (oldUidFirewallRule == rule) {
            if (DBG) {
                Slog.d(TAG, "!!!!! Skipping change");
            }
            return false;
        }
        String ruleName = this.getFirewallRuleName(chain, rule);
        String oldRuleName = this.getFirewallRuleName(chain, oldUidFirewallRule);
        if (rule == 0) {
            uidFirewallRules.delete(uid);
        } else {
            uidFirewallRules.put(uid, rule);
        }
        return !ruleName.equals(oldRuleName);
    }

    private String getFirewallRuleName(int chain, int rule) {
        String ruleName = this.getFirewallType(chain) == 0 ? (rule == 1 ? "allow" : "deny") : (rule == 2 ? "deny" : "allow");
        return ruleName;
    }

    private SparseIntArray getUidFirewallRules(int chain) {
        switch (chain) {
            case 2: {
                return this.mUidFirewallStandbyRules;
            }
            case 1: {
                return this.mUidFirewallDozableRules;
            }
            case 3: {
                return this.mUidFirewallPowerSaveRules;
            }
            case 0: {
                return this.mUidFirewallRules;
            }
        }
        throw new IllegalArgumentException("Unknown chain:" + chain);
    }

    public String getFirewallChainName(int chain) {
        switch (chain) {
            case 2: {
                return "standby";
            }
            case 1: {
                return "dozable";
            }
            case 3: {
                return "powersave";
            }
            case 0: {
                return "none";
            }
        }
        throw new IllegalArgumentException("Unknown chain:" + chain);
    }

    private static void enforceSystemUid() {
        int uid = Binder.getCallingUid();
        if (uid != 1000) {
            throw new SecurityException("Only available to AID_SYSTEM");
        }
    }

    @Override
    public void startClatd(String interfaceName) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("clatd", "start", interfaceName);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void stopClatd(String interfaceName) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("clatd", "stop", interfaceName);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public boolean isClatdStarted(String interfaceName) {
        NativeDaemonEvent event;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            event = this.mConnector.execute("clatd", "status", interfaceName);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
        event.checkCode(223);
        return event.getMessage().endsWith("started");
    }

    @Override
    public void registerNetworkActivityListener(INetworkActivityListener listener) {
        this.mNetworkActivityListeners.register(listener);
    }

    @Override
    public void unregisterNetworkActivityListener(INetworkActivityListener listener) {
        this.mNetworkActivityListeners.unregister(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNetworkActive() {
        RemoteCallbackList<INetworkActivityListener> remoteCallbackList = this.mNetworkActivityListeners;
        synchronized (remoteCallbackList) {
            return this.mNetworkActive || this.mActiveIdleTimers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportNetworkActive() {
        int length = this.mNetworkActivityListeners.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    this.mNetworkActivityListeners.getBroadcastItem(i).onNetworkActive();
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mNetworkActivityListeners.finishBroadcast();
        }
    }

    @Override
    public void monitor() {
        if (this.mConnector != null) {
            this.mConnector.monitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        pw.println("NetworkManagementService NativeDaemonConnector Log:");
        this.mConnector.dump(fd, pw, args);
        pw.println();
        pw.print("Bandwidth control enabled: ");
        pw.println(this.mBandwidthControlEnabled);
        pw.print("mMobileActivityFromRadio=");
        pw.print(this.mMobileActivityFromRadio);
        pw.print(" mLastPowerStateFromRadio=");
        pw.println(this.mLastPowerStateFromRadio);
        pw.print("mNetworkActive=");
        pw.println(this.mNetworkActive);
        Object object = this.mQuotaLock;
        synchronized (object) {
            pw.print("Active quota ifaces: ");
            pw.println(this.mActiveQuotas.toString());
            pw.print("Active alert ifaces: ");
            pw.println(this.mActiveAlerts.toString());
            pw.print("Data saver mode: ");
            pw.println(this.mDataSaverMode);
            this.dumpUidRuleOnQuotaLocked(pw, "blacklist", this.mUidRejectOnMetered);
            this.dumpUidRuleOnQuotaLocked(pw, "whitelist", this.mUidAllowOnMetered);
        }
        object = this.mUidFirewallRules;
        synchronized (object) {
            this.dumpUidFirewallRule(pw, "", this.mUidFirewallRules);
        }
        pw.print("UID firewall standby chain enabled: ");
        pw.println(this.mFirewallChainStates.get(2));
        object = this.mUidFirewallStandbyRules;
        synchronized (object) {
            this.dumpUidFirewallRule(pw, "standby", this.mUidFirewallStandbyRules);
        }
        pw.print("UID firewall dozable chain enabled: ");
        pw.println(this.mFirewallChainStates.get(1));
        object = this.mUidFirewallDozableRules;
        synchronized (object) {
            this.dumpUidFirewallRule(pw, "dozable", this.mUidFirewallDozableRules);
        }
        pw.println("UID firewall powersave chain enabled: " + this.mFirewallChainStates.get(3));
        object = this.mUidFirewallPowerSaveRules;
        synchronized (object) {
            this.dumpUidFirewallRule(pw, "powersave", this.mUidFirewallPowerSaveRules);
        }
        object = this.mIdleTimerLock;
        synchronized (object) {
            pw.println("Idle timers:");
            for (Map.Entry<String, IdleTimerParams> ent : this.mActiveIdleTimers.entrySet()) {
                pw.print("  ");
                pw.print(ent.getKey());
                pw.println(":");
                IdleTimerParams params = ent.getValue();
                pw.print("    timeout=");
                pw.print(params.timeout);
                pw.print(" type=");
                pw.print(params.type);
                pw.print(" networkCount=");
                pw.println(params.networkCount);
            }
        }
        pw.print("Firewall enabled: ");
        pw.println(this.mFirewallEnabled);
        pw.print("Netd service status: ");
        if (this.mNetdService == null) {
            pw.println("disconnected");
        } else {
            try {
                boolean alive = this.mNetdService.isAlive();
                pw.println(alive ? "alive" : "dead");
            }
            catch (RemoteException e) {
                pw.println("unreachable");
            }
        }
    }

    private void dumpUidRuleOnQuotaLocked(PrintWriter pw, String name, SparseBooleanArray list) {
        pw.print("UID bandwith control ");
        pw.print(name);
        pw.print(" rule: [");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            pw.print(list.keyAt(i));
            if (i >= size - 1) continue;
            pw.print(",");
        }
        pw.println("]");
    }

    private void dumpUidFirewallRule(PrintWriter pw, String name, SparseIntArray rules) {
        pw.print("UID firewall ");
        pw.print(name);
        pw.print(" rule: [");
        int size = rules.size();
        for (int i = 0; i < size; ++i) {
            pw.print(rules.keyAt(i));
            pw.print(":");
            pw.print(rules.valueAt(i));
            if (i >= size - 1) continue;
            pw.print(",");
        }
        pw.println("]");
    }

    @Override
    public void createPhysicalNetwork(int netId, String permission2) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            if (permission2 != null) {
                this.mConnector.execute("network", "create", netId, permission2);
            } else {
                this.mConnector.execute("network", "create", netId);
            }
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void createVirtualNetwork(int netId, boolean hasDNS, boolean secure) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("network", "create", netId, "vpn", hasDNS ? "1" : "0", secure ? "1" : "0");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void removeNetwork(int netId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("network", "destroy", netId);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void addInterfaceToNetwork(String iface, int netId) {
        this.modifyInterfaceInNetwork("add", "" + netId, iface);
    }

    @Override
    public void removeInterfaceFromNetwork(String iface, int netId) {
        this.modifyInterfaceInNetwork("remove", "" + netId, iface);
    }

    private void modifyInterfaceInNetwork(String action, String netId, String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("network", "interface", action, netId, iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void addLegacyRouteForNetId(int netId, RouteInfo routeInfo, int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("network", "route", "legacy", uid, "add", netId);
        LinkAddress la = routeInfo.getDestinationLinkAddress();
        cmd.appendArg(routeInfo.getInterface());
        cmd.appendArg(la.getAddress().getHostAddress() + "/" + la.getPrefixLength());
        if (routeInfo.hasGateway()) {
            cmd.appendArg(routeInfo.getGateway().getHostAddress());
        }
        try {
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setDefaultNetId(int netId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("network", "default", "set", netId);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void clearDefaultNetId() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("network", "default", "clear");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setNetworkPermission(int netId, String permission2) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            if (permission2 != null) {
                this.mConnector.execute("network", "permission", "network", "set", permission2, netId);
            } else {
                this.mConnector.execute("network", "permission", "network", "clear", netId);
            }
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setPermission(String permission2, int[] uids) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object[] argv = new Object[14];
        argv[0] = "permission";
        argv[1] = "user";
        argv[2] = "set";
        argv[3] = permission2;
        int argc = 4;
        for (int i = 0; i < uids.length; ++i) {
            argv[argc++] = uids[i];
            if (i != uids.length - 1 && argc != argv.length) continue;
            try {
                this.mConnector.execute("network", Arrays.copyOf(argv, argc));
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
            argc = 4;
        }
    }

    @Override
    public void clearPermission(int[] uids) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object[] argv = new Object[13];
        argv[0] = "permission";
        argv[1] = "user";
        argv[2] = "clear";
        int argc = 3;
        for (int i = 0; i < uids.length; ++i) {
            argv[argc++] = uids[i];
            if (i != uids.length - 1 && argc != argv.length) continue;
            try {
                this.mConnector.execute("network", Arrays.copyOf(argv, argc));
            }
            catch (NativeDaemonConnectorException e) {
                throw e.rethrowAsParcelableException();
            }
            argc = 3;
        }
    }

    @Override
    public void allowProtect(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("network", "protect", "allow", uid);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void denyProtect(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mConnector.execute("network", "protect", "deny", uid);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void addInterfaceToLocalNetwork(String iface, List<RouteInfo> routes) {
        this.modifyInterfaceInNetwork("add", "local", iface);
        for (RouteInfo route : routes) {
            if (route.isDefaultRoute()) continue;
            this.modifyRoute("add", "local", route);
        }
    }

    @Override
    public void removeInterfaceFromLocalNetwork(String iface) {
        this.modifyInterfaceInNetwork("remove", "local", iface);
    }

    static /* synthetic */ void access$500(NetworkManagementService x0, String x1) {
        x0.notifyInterfaceAdded(x1);
    }

    static /* synthetic */ void access$600(NetworkManagementService x0, String x1) {
        x0.notifyInterfaceRemoved(x1);
    }

    static /* synthetic */ void access$700(NetworkManagementService x0, String x1, boolean x2) {
        x0.notifyInterfaceStatusChanged(x1, x2);
    }

    static /* synthetic */ void access$800(NetworkManagementService x0, String x1, boolean x2) {
        x0.notifyInterfaceLinkStateChanged(x1, x2);
    }

    static /* synthetic */ void access$900(NetworkManagementService x0, String x1, String x2) {
        x0.notifyLimitReached(x1, x2);
    }

    static /* synthetic */ void access$1100(NetworkManagementService x0, String x1, LinkAddress x2) {
        x0.notifyAddressUpdated(x1, x2);
    }

    static /* synthetic */ void access$1200(NetworkManagementService x0, String x1, LinkAddress x2) {
        x0.notifyAddressRemoved(x1, x2);
    }

    static /* synthetic */ void access$1300(NetworkManagementService x0, String x1, long x2, String[] x3) {
        x0.notifyInterfaceDnsServerInfo(x1, x2, x3);
    }

    static /* synthetic */ void access$1400(NetworkManagementService x0, String x1, RouteInfo x2) {
        x0.notifyRouteChange(x1, x2);
    }

    private class NetdCallbackReceiver
    implements INativeDaemonConnectorCallbacks {
        private NetdCallbackReceiver() {
        }

        @Override
        public void onDaemonConnected() {
            Slog.i(NetworkManagementService.TAG, "onDaemonConnected()");
            if (NetworkManagementService.this.mConnectedSignal != null) {
                NetworkManagementService.this.mConnectedSignal.countDown();
                NetworkManagementService.this.mConnectedSignal = null;
            } else {
                NetworkManagementService.this.mFgHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NetworkManagementService.this.connectNativeNetdService();
                        NetworkManagementService.this.prepareNativeDaemon();
                    }
                });
            }
        }

        @Override
        public boolean onCheckHoldWakeLock(int code) {
            return code == 613;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean onEvent(int code, String raw, String[] cooked) {
            errorMessage = String.format("Invalid event from daemon (%s)", new Object[]{raw});
            switch (code) {
                case 600: {
                    if (cooked.length < 4 || !cooked[1].equals("Iface")) {
                        throw new IllegalStateException(errorMessage);
                    }
                    if (cooked[2].equals("added")) {
                        NetworkManagementService.access$500(NetworkManagementService.this, cooked[3]);
                        return true;
                    }
                    if (cooked[2].equals("removed")) {
                        NetworkManagementService.access$600(NetworkManagementService.this, cooked[3]);
                        return true;
                    }
                    if (cooked[2].equals("changed") && cooked.length == 5) {
                        NetworkManagementService.access$700(NetworkManagementService.this, cooked[3], cooked[4].equals("up"));
                        return true;
                    }
                    if (cooked[2].equals("linkstate") && cooked.length == 5) {
                        NetworkManagementService.access$800(NetworkManagementService.this, cooked[3], cooked[4].equals("up"));
                        return true;
                    }
                    throw new IllegalStateException(errorMessage);
                }
                case 601: {
                    if (cooked.length < 5 || !cooked[1].equals("limit")) {
                        throw new IllegalStateException(errorMessage);
                    }
                    if (cooked[2].equals("alert")) {
                        NetworkManagementService.access$900(NetworkManagementService.this, cooked[3], cooked[4]);
                        return true;
                    }
                    throw new IllegalStateException(errorMessage);
                }
                case 613: {
                    if (cooked.length < 4 || !cooked[1].equals("IfaceClass")) {
                        throw new IllegalStateException(errorMessage);
                    }
                    timestampNanos = 0L;
                    processUid = -1;
                    if (cooked.length < 5) ** GOTO lbl40
                    try {
                        timestampNanos = Long.parseLong(cooked[4]);
                        if (cooked.length == 6) {
                            processUid = Integer.parseInt(cooked[5]);
                        }
                        ** GOTO lbl41
                    }
                    catch (NumberFormatException var8_7) {}
                    ** GOTO lbl41
lbl40:
                    // 1 sources

                    timestampNanos = SystemClock.elapsedRealtimeNanos();
lbl41:
                    // 4 sources

                    isActive = cooked[2].equals("active");
                    NetworkManagementService.access$1000(NetworkManagementService.this, Integer.parseInt(cooked[3]), isActive != false ? 3 : 1, timestampNanos, processUid, false);
                    return true;
                }
                case 614: {
                    if (cooked.length < 7 || !cooked[1].equals("Address")) {
                        throw new IllegalStateException(errorMessage);
                    }
                    iface = cooked[4];
                    try {
                        flags = Integer.parseInt(cooked[5]);
                        scope = Integer.parseInt(cooked[6]);
                        address = new LinkAddress(cooked[3], flags, scope);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalStateException(errorMessage, e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException(errorMessage, e);
                    }
                    if (cooked[2].equals("updated")) {
                        NetworkManagementService.access$1100(NetworkManagementService.this, iface, address);
                    } else {
                        NetworkManagementService.access$1200(NetworkManagementService.this, iface, address);
                    }
                    return true;
                }
                case 615: {
                    if (cooked.length == 6 && cooked[1].equals("DnsInfo") && cooked[2].equals("servers")) {
                        try {
                            lifetime = Long.parseLong(cooked[4]);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalStateException(errorMessage);
                        }
                        servers = cooked[5].split(",");
                        NetworkManagementService.access$1300(NetworkManagementService.this, cooked[3], lifetime, servers);
                    }
                    return true;
                }
                case 616: {
                    if (!cooked[1].equals("Route") || cooked.length < 6) {
                        throw new IllegalStateException(errorMessage);
                    }
                    via = null;
                    dev = null;
                    valid = true;
                    i = 4;
                    while (i + 1 < cooked.length && valid) {
                        if (cooked[i].equals("dev")) {
                            if (dev == null) {
                                dev = cooked[i + 1];
                            } else {
                                valid = false;
                            }
                        } else if (cooked[i].equals("via")) {
                            if (via == null) {
                                via = cooked[i + 1];
                            } else {
                                valid = false;
                            }
                        } else {
                            valid = false;
                        }
                        i += 2;
                    }
                    if (valid) {
                        try {
                            gateway = null;
                            if (via != null) {
                                gateway = InetAddress.parseNumericAddress(via);
                            }
                            route = new RouteInfo(new IpPrefix(cooked[3]), gateway, dev);
                            NetworkManagementService.access$1400(NetworkManagementService.this, cooked[2], route);
                            return true;
                        }
                        catch (IllegalArgumentException gateway) {
                            // empty catch block
                        }
                    }
                    throw new IllegalStateException(errorMessage);
                }
                case 617: {
                    uid = Integer.parseInt(cooked[1]);
                    firstPacket = HexDump.hexStringToByteArray(cooked[2]);
                    try {
                        ActivityManagerNative.getDefault().notifyCleartextNetwork(uid, firstPacket);
                    }
                    catch (RemoteException var18_27) {}
                    break;
                }
            }
            return false;
        }
    }

    private static class IdleTimerParams {
        public final int timeout;
        public final int type;
        public int networkCount;

        IdleTimerParams(int timeout, int type) {
            this.timeout = timeout;
            this.type = type;
            this.networkCount = 1;
        }
    }

    class NetdResponseCode {
        public static final int InterfaceListResult = 110;
        public static final int TetherInterfaceListResult = 111;
        public static final int TetherDnsFwdTgtListResult = 112;
        public static final int TtyListResult = 113;
        public static final int TetheringStatsListResult = 114;
        public static final int TetherStatusResult = 210;
        public static final int IpFwdStatusResult = 211;
        public static final int InterfaceGetCfgResult = 213;
        public static final int SoftapStatusResult = 214;
        public static final int InterfaceRxCounterResult = 216;
        public static final int InterfaceTxCounterResult = 217;
        public static final int QuotaCounterResult = 220;
        public static final int TetheringStatsResult = 221;
        public static final int DnsProxyQueryResult = 222;
        public static final int ClatdStatusResult = 223;
        public static final int InterfaceChange = 600;
        public static final int BandwidthControl = 601;
        public static final int InterfaceClassActivity = 613;
        public static final int InterfaceAddressChange = 614;
        public static final int InterfaceDnsServerInfo = 615;
        public static final int RouteChange = 616;
        public static final int StrictCleartext = 617;

        NetdResponseCode() {
        }
    }
}

