/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.os.Handler;
import android.os.IBinder;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class ServiceWatcher
implements ServiceConnection {
    private static final boolean D = false;
    public static final String EXTRA_SERVICE_VERSION = "serviceVersion";
    public static final String EXTRA_SERVICE_IS_MULTIUSER = "serviceIsMultiuser";
    private final String mTag;
    private final Context mContext;
    private final PackageManager mPm;
    private final List<HashSet<Signature>> mSignatureSets;
    private final String mAction;
    private final String mServicePackageName;
    private final Runnable mNewServiceWork;
    private final Handler mHandler;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private int mCurrentUserId = 0;
    @GuardedBy(value="mLock")
    private IBinder mBoundService;
    @GuardedBy(value="mLock")
    private ComponentName mBoundComponent;
    @GuardedBy(value="mLock")
    private String mBoundPackageName;
    @GuardedBy(value="mLock")
    private int mBoundVersion = Integer.MIN_VALUE;
    @GuardedBy(value="mLock")
    private int mBoundUserId = -10000;
    private final PackageMonitor mPackageMonitor = new PackageMonitor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageUpdateFinished(String packageName, int uid) {
            Object object = ServiceWatcher.this.mLock;
            synchronized (object) {
                boolean forceRebind = Objects.equals(packageName, ServiceWatcher.this.mBoundPackageName);
                ServiceWatcher.this.bindBestPackageLocked(null, forceRebind);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageAdded(String packageName, int uid) {
            Object object = ServiceWatcher.this.mLock;
            synchronized (object) {
                boolean forceRebind = Objects.equals(packageName, ServiceWatcher.this.mBoundPackageName);
                ServiceWatcher.this.bindBestPackageLocked(null, forceRebind);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageRemoved(String packageName, int uid) {
            Object object = ServiceWatcher.this.mLock;
            synchronized (object) {
                boolean forceRebind = Objects.equals(packageName, ServiceWatcher.this.mBoundPackageName);
                ServiceWatcher.this.bindBestPackageLocked(null, forceRebind);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onPackageChanged(String packageName, int uid, String[] components) {
            Object object = ServiceWatcher.this.mLock;
            synchronized (object) {
                boolean forceRebind = Objects.equals(packageName, ServiceWatcher.this.mBoundPackageName);
                ServiceWatcher.this.bindBestPackageLocked(null, forceRebind);
            }
            return super.onPackageChanged(packageName, uid, components);
        }
    };

    public static ArrayList<HashSet<Signature>> getSignatureSets(Context context, List<String> initialPackageNames) {
        PackageManager pm = context.getPackageManager();
        ArrayList<HashSet<Signature>> sigSets = new ArrayList<HashSet<Signature>>();
        int size = initialPackageNames.size();
        for (int i = 0; i < size; ++i) {
            String pkg = initialPackageNames.get(i);
            try {
                HashSet<Signature> set = new HashSet<Signature>();
                Signature[] sigs = pm.getPackageInfo((String)pkg, (int)0x100040).signatures;
                set.addAll(Arrays.asList(sigs));
                sigSets.add(set);
                continue;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w("ServiceWatcher", pkg + " not found");
            }
        }
        return sigSets;
    }

    public ServiceWatcher(Context context, String logTag, String action, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId, Runnable newServiceWork, Handler handler) {
        this.mContext = context;
        this.mTag = logTag;
        this.mAction = action;
        this.mPm = this.mContext.getPackageManager();
        this.mNewServiceWork = newServiceWork;
        this.mHandler = handler;
        Resources resources = context.getResources();
        boolean enableOverlay = resources.getBoolean(overlaySwitchResId);
        ArrayList<String> initialPackageNames = new ArrayList<String>();
        if (enableOverlay) {
            String[] pkgs = resources.getStringArray(initialPackageNamesResId);
            if (pkgs != null) {
                initialPackageNames.addAll(Arrays.asList(pkgs));
            }
            this.mServicePackageName = null;
        } else {
            String servicePackageName = resources.getString(defaultServicePackageNameResId);
            if (servicePackageName != null) {
                initialPackageNames.add(servicePackageName);
            }
            this.mServicePackageName = servicePackageName;
        }
        this.mSignatureSets = ServiceWatcher.getSignatureSets(context, initialPackageNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.mLock;
        synchronized (object) {
            this.bindBestPackageLocked(this.mServicePackageName, false);
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.USER_UNLOCKED");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                if ("android.intent.action.USER_SWITCHED".equals(action)) {
                    ServiceWatcher.this.switchUser(userId);
                } else if ("android.intent.action.USER_UNLOCKED".equals(action)) {
                    ServiceWatcher.this.unlockUser(userId);
                }
            }
        }, UserHandle.ALL, intentFilter, null, this.mHandler);
        if (this.mServicePackageName == null) {
            this.mPackageMonitor.register(this.mContext, null, UserHandle.ALL, true);
        }
        return true;
    }

    private boolean bindBestPackageLocked(String justCheckThisPackage, boolean forceRebind) {
        boolean alreadyBound;
        Intent intent = new Intent(this.mAction);
        if (justCheckThisPackage != null) {
            intent.setPackage(justCheckThisPackage);
        }
        List<ResolveInfo> rInfos = this.mPm.queryIntentServicesAsUser(intent, 0x10000080, this.mCurrentUserId);
        int bestVersion = Integer.MIN_VALUE;
        ComponentName bestComponent = null;
        boolean bestIsMultiuser = false;
        if (rInfos != null) {
            for (ResolveInfo rInfo : rInfos) {
                ComponentName component;
                block9: {
                    component = rInfo.serviceInfo.getComponentName();
                    String packageName = component.getPackageName();
                    try {
                        PackageInfo pInfo = this.mPm.getPackageInfo(packageName, 0x10000040);
                        if (!this.isSignatureMatch(pInfo.signatures)) {
                            Log.w(this.mTag, packageName + " resolves service " + this.mAction + ", but has wrong signature, ignoring");
                        }
                        break block9;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Log.wtf(this.mTag, e);
                    }
                    continue;
                }
                int version = Integer.MIN_VALUE;
                boolean isMultiuser = false;
                if (rInfo.serviceInfo.metaData != null) {
                    version = rInfo.serviceInfo.metaData.getInt(EXTRA_SERVICE_VERSION, Integer.MIN_VALUE);
                    isMultiuser = rInfo.serviceInfo.metaData.getBoolean(EXTRA_SERVICE_IS_MULTIUSER);
                }
                if (version <= bestVersion) continue;
                bestVersion = version;
                bestComponent = component;
                bestIsMultiuser = isMultiuser;
            }
        }
        if (bestComponent == null) {
            Slog.w(this.mTag, "Odd, no component found for service " + this.mAction);
            this.unbindLocked();
            return false;
        }
        int userId = bestIsMultiuser ? 0 : this.mCurrentUserId;
        boolean bl = alreadyBound = Objects.equals(bestComponent, this.mBoundComponent) && bestVersion == this.mBoundVersion && userId == this.mBoundUserId;
        if (forceRebind || !alreadyBound) {
            this.unbindLocked();
            this.bindToPackageLocked(bestComponent, bestVersion, userId);
        }
        return true;
    }

    private void unbindLocked() {
        ComponentName component = this.mBoundComponent;
        this.mBoundComponent = null;
        this.mBoundPackageName = null;
        this.mBoundVersion = Integer.MIN_VALUE;
        this.mBoundUserId = -10000;
        if (component != null) {
            this.mContext.unbindService(this);
        }
    }

    private void bindToPackageLocked(ComponentName component, int version, int userId) {
        Intent intent = new Intent(this.mAction);
        intent.setComponent(component);
        this.mBoundComponent = component;
        this.mBoundPackageName = component.getPackageName();
        this.mBoundVersion = version;
        this.mBoundUserId = userId;
        this.mContext.bindServiceAsUser(intent, this, 0x40000005, new UserHandle(userId));
    }

    public static boolean isSignatureMatch(Signature[] signatures, List<HashSet<Signature>> sigSets) {
        if (signatures == null) {
            return false;
        }
        HashSet<Signature> inputSet = new HashSet<Signature>();
        for (Signature s : signatures) {
            inputSet.add(s);
        }
        for (HashSet hashSet : sigSets) {
            if (!hashSet.equals(inputSet)) continue;
            return true;
        }
        return false;
    }

    private boolean isSignatureMatch(Signature[] signatures) {
        return ServiceWatcher.isSignatureMatch(signatures, this.mSignatureSets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName component, IBinder binder) {
        Object object = this.mLock;
        synchronized (object) {
            if (component.equals(this.mBoundComponent)) {
                this.mBoundService = binder;
                if (this.mHandler != null && this.mNewServiceWork != null) {
                    this.mHandler.post(this.mNewServiceWork);
                }
            } else {
                Log.w(this.mTag, "unexpected onServiceConnected: " + component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDisconnected(ComponentName component) {
        Object object = this.mLock;
        synchronized (object) {
            if (component.equals(this.mBoundComponent)) {
                this.mBoundService = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBestPackageName() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBoundPackageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBestVersion() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBoundVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinder getBinder() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBoundService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentUserId = userId;
            this.bindBestPackageLocked(this.mServicePackageName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (userId == this.mCurrentUserId) {
                this.bindBestPackageLocked(this.mServicePackageName, false);
            }
        }
    }
}

