/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.Context;
import android.gesture.Gesture;
import android.gesture.GestureLibraries;
import android.gesture.GestureLibrary;
import android.gesture.GesturePoint;
import android.gesture.GestureStroke;
import android.gesture.Prediction;
import android.util.Slog;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import java.util.ArrayList;

class AccessibilityGestureDetector
extends GestureDetector.SimpleOnGestureListener {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityGestureDetector";
    private final Listener mListener;
    private final GestureDetector mGestureDetector;
    private final GestureLibrary mGestureLibrary;
    private boolean mFirstTapDetected;
    private boolean mDoubleTapDetected;
    private boolean mRecognizingGesture;
    private boolean mGestureStarted;
    private boolean mSecondFingerDoubleTap;
    private long mSecondPointerDownTime;
    private int mPolicyFlags;
    private float mPreviousGestureX;
    private float mPreviousGestureY;
    private float mBaseX;
    private float mBaseY;
    private long mBaseTime;
    private final float mGestureDetectionThreshold;
    private final ArrayList<GesturePoint> mStrokeBuffer = new ArrayList(100);
    private static final int TOUCH_TOLERANCE = 3;
    private static final float MIN_PREDICTION_SCORE = 2.0f;
    private static final int GESTURE_CONFIRM_MM = 10;
    private static final long CANCEL_ON_PAUSE_THRESHOLD_NOT_STARTED_MS = 200L;
    private static final long CANCEL_ON_PAUSE_THRESHOLD_STARTED_MS = 500L;

    AccessibilityGestureDetector(Context context, Listener listener) {
        this.mListener = listener;
        this.mGestureDetector = new GestureDetector(context, this);
        this.mGestureDetector.setOnDoubleTapListener(this);
        this.mGestureLibrary = GestureLibraries.fromRawResource(context, 0x1100002);
        this.mGestureLibrary.setOrientationStyle(8);
        this.mGestureLibrary.setSequenceType(2);
        this.mGestureLibrary.load();
        this.mGestureDetectionThreshold = TypedValue.applyDimension(5, 1.0f, context.getResources().getDisplayMetrics()) * 10.0f;
    }

    public boolean onMotionEvent(MotionEvent event, int policyFlags) {
        float x = event.getX();
        float y = event.getY();
        long time = event.getEventTime();
        this.mPolicyFlags = policyFlags;
        switch (event.getActionMasked()) {
            case 0: {
                this.mDoubleTapDetected = false;
                this.mSecondFingerDoubleTap = false;
                this.mRecognizingGesture = true;
                this.mGestureStarted = false;
                this.mPreviousGestureX = x;
                this.mPreviousGestureY = y;
                this.mStrokeBuffer.clear();
                this.mStrokeBuffer.add(new GesturePoint(x, y, time));
                this.mBaseX = x;
                this.mBaseY = y;
                this.mBaseTime = time;
                break;
            }
            case 2: {
                if (!this.mRecognizingGesture) break;
                float deltaX = this.mBaseX - x;
                float deltaY = this.mBaseY - y;
                double moveDelta = Math.hypot(deltaX, deltaY);
                if (moveDelta > (double)this.mGestureDetectionThreshold) {
                    this.mBaseX = x;
                    this.mBaseY = y;
                    this.mBaseTime = time;
                    this.mFirstTapDetected = false;
                    this.mDoubleTapDetected = false;
                    if (!this.mGestureStarted) {
                        this.mGestureStarted = true;
                        return this.mListener.onGestureStarted();
                    }
                } else if (!this.mFirstTapDetected) {
                    long threshold;
                    long timeDelta = time - this.mBaseTime;
                    long l = threshold = this.mGestureStarted ? 500L : 200L;
                    if (timeDelta > threshold) {
                        this.cancelGesture();
                        return this.mListener.onGestureCancelled(event, policyFlags);
                    }
                }
                float dX = Math.abs(x - this.mPreviousGestureX);
                float dY = Math.abs(y - this.mPreviousGestureY);
                if (!(dX >= 3.0f) && !(dY >= 3.0f)) break;
                this.mPreviousGestureX = x;
                this.mPreviousGestureY = y;
                this.mStrokeBuffer.add(new GesturePoint(x, y, time));
                break;
            }
            case 1: {
                if (this.mDoubleTapDetected) {
                    return this.finishDoubleTap(event, policyFlags);
                }
                if (!this.mGestureStarted) break;
                this.mStrokeBuffer.add(new GesturePoint(x, y, time));
                return this.recognizeGesture(event, policyFlags);
            }
            case 5: {
                this.cancelGesture();
                if (event.getPointerCount() == 2) {
                    this.mSecondFingerDoubleTap = true;
                    this.mSecondPointerDownTime = time;
                    break;
                }
                this.mSecondFingerDoubleTap = false;
                break;
            }
            case 6: {
                if (!this.mSecondFingerDoubleTap || !this.mDoubleTapDetected) break;
                return this.finishDoubleTap(event, policyFlags);
            }
            case 3: {
                this.clear();
            }
        }
        if (this.mSecondFingerDoubleTap) {
            MotionEvent newEvent = this.mapSecondPointerToFirstPointer(event);
            if (newEvent == null) {
                return false;
            }
            boolean handled = this.mGestureDetector.onTouchEvent(newEvent);
            newEvent.recycle();
            return handled;
        }
        if (!this.mRecognizingGesture) {
            return false;
        }
        return this.mGestureDetector.onTouchEvent(event);
    }

    public void clear() {
        this.mFirstTapDetected = false;
        this.mDoubleTapDetected = false;
        this.mSecondFingerDoubleTap = false;
        this.mGestureStarted = false;
        this.cancelGesture();
    }

    public boolean firstTapDetected() {
        return this.mFirstTapDetected;
    }

    @Override
    public void onLongPress(MotionEvent e) {
        this.maybeSendLongPress(e, this.mPolicyFlags);
    }

    @Override
    public boolean onSingleTapUp(MotionEvent event) {
        this.mFirstTapDetected = true;
        return false;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event) {
        this.clear();
        return false;
    }

    @Override
    public boolean onDoubleTap(MotionEvent event) {
        this.mDoubleTapDetected = true;
        return false;
    }

    private void maybeSendLongPress(MotionEvent event, int policyFlags) {
        if (!this.mDoubleTapDetected) {
            return;
        }
        this.clear();
        this.mListener.onDoubleTapAndHold(event, policyFlags);
    }

    private boolean finishDoubleTap(MotionEvent event, int policyFlags) {
        this.clear();
        return this.mListener.onDoubleTap(event, policyFlags);
    }

    private void cancelGesture() {
        this.mRecognizingGesture = false;
        this.mGestureStarted = false;
        this.mStrokeBuffer.clear();
    }

    private boolean recognizeGesture(MotionEvent event, int policyFlags) {
        Gesture gesture = new Gesture();
        gesture.addStroke(new GestureStroke(this.mStrokeBuffer));
        ArrayList<Prediction> predictions = this.mGestureLibrary.recognize(gesture);
        if (!predictions.isEmpty()) {
            Prediction bestPrediction = predictions.get(0);
            if (bestPrediction.score >= 2.0) {
                try {
                    int gestureId = Integer.parseInt(bestPrediction.name);
                    return this.mListener.onGestureCompleted(gestureId);
                }
                catch (NumberFormatException nfe) {
                    Slog.w(LOG_TAG, "Non numeric gesture id:" + bestPrediction.name);
                }
            }
        }
        return this.mListener.onGestureCancelled(event, policyFlags);
    }

    private MotionEvent mapSecondPointerToFirstPointer(MotionEvent event) {
        if (event.getPointerCount() != 2 || event.getActionMasked() != 5 && event.getActionMasked() != 6 && event.getActionMasked() != 2) {
            return null;
        }
        int action = event.getActionMasked();
        if (action == 5) {
            action = 0;
        } else if (action == 6) {
            action = 1;
        }
        return MotionEvent.obtain(this.mSecondPointerDownTime, event.getEventTime(), action, event.getX(1), event.getY(1), event.getPressure(1), event.getSize(1), event.getMetaState(), event.getXPrecision(), event.getYPrecision(), event.getDeviceId(), event.getEdgeFlags());
    }

    public static interface Listener {
        public void onDoubleTapAndHold(MotionEvent var1, int var2);

        public boolean onDoubleTap(MotionEvent var1, int var2);

        public boolean onGestureStarted();

        public boolean onGestureCompleted(int var1);

        public boolean onGestureCancelled(MotionEvent var1, int var2);
    }
}

