/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Pools;
import android.view.InputEventConsistencyVerifier;
import android.view.KeyEvent;
import com.android.server.accessibility.AccessibilityManagerService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class KeyEventDispatcher {
    private static final String LOG_TAG = "KeyEventDispatcher";
    private static final boolean DEBUG = false;
    private static final long ON_KEY_EVENT_TIMEOUT_MILLIS = 500L;
    private static final int MSG_ON_KEY_EVENT_TIMEOUT = 1;
    private static final int MAX_POOL_SIZE = 10;
    private final Pools.Pool<PendingKeyEvent> mPendingEventPool = new Pools.SimplePool<PendingKeyEvent>(10);
    private final Object mLock;
    private final Map<AccessibilityManagerService.Service, ArrayList<PendingKeyEvent>> mPendingEventsMap = new ArrayMap<AccessibilityManagerService.Service, ArrayList<PendingKeyEvent>>();
    private final InputEventConsistencyVerifier mSentEventsVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0, KeyEventDispatcher.class.getSimpleName()) : null;
    private final Handler mHandlerToSendKeyEventsToInputFilter;
    private final int mMessageTypeForSendKeyEvent;
    private final Handler mKeyEventTimeoutHandler;
    private final PowerManager mPowerManager;

    public KeyEventDispatcher(Handler handlerToSendKeyEventsToInputFilter, int messageTypeForSendKeyEvent, Object lock, PowerManager powerManager) {
        this.mHandlerToSendKeyEventsToInputFilter = handlerToSendKeyEventsToInputFilter;
        this.mMessageTypeForSendKeyEvent = messageTypeForSendKeyEvent;
        this.mKeyEventTimeoutHandler = new Handler(this.mHandlerToSendKeyEventsToInputFilter.getLooper(), new Callback());
        this.mLock = lock;
        this.mPowerManager = powerManager;
    }

    public boolean notifyKeyEventLocked(KeyEvent event, int policyFlags, List<AccessibilityManagerService.Service> boundServices) {
        PendingKeyEvent pendingKeyEvent = null;
        KeyEvent localClone = KeyEvent.obtain(event);
        for (int i = 0; i < boundServices.size(); ++i) {
            ArrayList<PendingKeyEvent> pendingEventList;
            int filterKeyEventBit;
            AccessibilityManagerService.Service service = boundServices.get(i);
            if (!service.mRequestFilterKeyEvents || (filterKeyEventBit = service.mAccessibilityServiceInfo.getCapabilities() & 8) == 0) continue;
            try {
                service.mServiceInterface.onKeyEvent(localClone, localClone.getSequenceNumber());
            }
            catch (RemoteException re) {
                continue;
            }
            if (pendingKeyEvent == null) {
                pendingKeyEvent = this.obtainPendingEventLocked(localClone, policyFlags);
            }
            if ((pendingEventList = this.mPendingEventsMap.get(service)) == null) {
                pendingEventList = new ArrayList();
                this.mPendingEventsMap.put(service, pendingEventList);
            }
            pendingEventList.add(pendingKeyEvent);
            ++pendingKeyEvent.referenceCount;
        }
        if (pendingKeyEvent == null) {
            localClone.recycle();
            return false;
        }
        Message message = this.mKeyEventTimeoutHandler.obtainMessage(1, pendingKeyEvent);
        this.mKeyEventTimeoutHandler.sendMessageDelayed(message, 500L);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnKeyEventResult(AccessibilityManagerService.Service service, boolean handled, int sequence) {
        Object object = this.mLock;
        synchronized (object) {
            PendingKeyEvent pendingEvent = KeyEventDispatcher.removeEventFromListLocked((List<PendingKeyEvent>)this.mPendingEventsMap.get(service), sequence);
            if (pendingEvent != null) {
                if (handled && !pendingEvent.handled) {
                    pendingEvent.handled = handled;
                    long identity = Binder.clearCallingIdentity();
                    try {
                        this.mPowerManager.userActivity(pendingEvent.event.getEventTime(), 3, 0);
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
                this.removeReferenceToPendingEventLocked(pendingEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(AccessibilityManagerService.Service service) {
        Object object = this.mLock;
        synchronized (object) {
            List pendingEvents = this.mPendingEventsMap.get(service);
            if (pendingEvents != null) {
                for (int i = 0; i < pendingEvents.size(); ++i) {
                    PendingKeyEvent pendingEvent = (PendingKeyEvent)pendingEvents.get(i);
                    this.removeReferenceToPendingEventLocked(pendingEvent);
                }
                this.mPendingEventsMap.remove(service);
            }
        }
    }

    private PendingKeyEvent obtainPendingEventLocked(KeyEvent event, int policyFlags) {
        PendingKeyEvent pendingEvent = this.mPendingEventPool.acquire();
        if (pendingEvent == null) {
            pendingEvent = new PendingKeyEvent();
        }
        pendingEvent.event = event;
        pendingEvent.policyFlags = policyFlags;
        pendingEvent.referenceCount = 0;
        pendingEvent.handled = false;
        return pendingEvent;
    }

    private static PendingKeyEvent removeEventFromListLocked(List<PendingKeyEvent> listOfEvents, int sequence) {
        for (int i = 0; i < listOfEvents.size(); ++i) {
            PendingKeyEvent pendingKeyEvent = listOfEvents.get(i);
            if (pendingKeyEvent.event.getSequenceNumber() != sequence) continue;
            listOfEvents.remove(pendingKeyEvent);
            return pendingKeyEvent;
        }
        return null;
    }

    private boolean removeReferenceToPendingEventLocked(PendingKeyEvent pendingEvent) {
        if (--pendingEvent.referenceCount > 0) {
            return false;
        }
        this.mKeyEventTimeoutHandler.removeMessages(1, pendingEvent);
        if (!pendingEvent.handled) {
            if (this.mSentEventsVerifier != null) {
                this.mSentEventsVerifier.onKeyEvent(pendingEvent.event, 0);
            }
            int policyFlags = pendingEvent.policyFlags | 0x40000000;
            this.mHandlerToSendKeyEventsToInputFilter.obtainMessage(this.mMessageTypeForSendKeyEvent, policyFlags, 0, pendingEvent.event).sendToTarget();
        } else {
            pendingEvent.event.recycle();
        }
        this.mPendingEventPool.release(pendingEvent);
        return true;
    }

    private class Callback
    implements Handler.Callback {
        private Callback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleMessage(Message message) {
            if (message.what != 1) {
                throw new IllegalArgumentException("Unknown message: " + message.what);
            }
            PendingKeyEvent pendingKeyEvent = (PendingKeyEvent)message.obj;
            Object object = KeyEventDispatcher.this.mLock;
            synchronized (object) {
                ArrayList listForService;
                Iterator iterator = KeyEventDispatcher.this.mPendingEventsMap.values().iterator();
                while (!(!iterator.hasNext() || (listForService = (ArrayList)iterator.next()).remove(pendingKeyEvent) && KeyEventDispatcher.this.removeReferenceToPendingEventLocked(pendingKeyEvent))) {
                }
            }
            return true;
        }
    }

    private static final class PendingKeyEvent {
        KeyEvent event;
        int policyFlags;
        int referenceCount;
        boolean handled;

        private PendingKeyEvent() {
        }
    }
}

