/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IApplicationThread;
import android.app.IServiceConnection;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.TransactionTooLargeException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import com.android.internal.app.procstats.ServiceState;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.FastPrintWriter;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.AppBindRecord;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.IntentBindRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ServiceRecord;
import com.android.server.am.TaskRecord;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ActiveServices {
    private static final String TAG = "ActivityManager";
    private static final String TAG_MU = "ActivityManager_MU";
    private static final String TAG_SERVICE = "ActivityManager";
    private static final String TAG_SERVICE_EXECUTING = "ActivityManager";
    private static final boolean DEBUG_DELAYED_SERVICE = false;
    private static final boolean DEBUG_DELAYED_STARTS = false;
    private static final boolean LOG_SERVICE_START_STOP = false;
    static final int SERVICE_TIMEOUT = 20000;
    static final int SERVICE_BACKGROUND_TIMEOUT = 200000;
    static final int SERVICE_RESTART_DURATION = 1000;
    static final int SERVICE_RESET_RUN_DURATION = 60000;
    static final int SERVICE_RESTART_DURATION_FACTOR = 4;
    static final int SERVICE_MIN_RESTART_TIME_BETWEEN = 10000;
    static final int MAX_SERVICE_INACTIVITY = 1800000;
    static final int BG_START_TIMEOUT = 15000;
    final ActivityManagerService mAm;
    final int mMaxStartingBackground;
    final SparseArray<ServiceMap> mServiceMap = new SparseArray();
    final ArrayMap<IBinder, ArrayList<ConnectionRecord>> mServiceConnections = new ArrayMap();
    final ArrayList<ServiceRecord> mPendingServices = new ArrayList();
    final ArrayList<ServiceRecord> mRestartingServices = new ArrayList();
    final ArrayList<ServiceRecord> mDestroyingServices = new ArrayList();
    private ArrayList<ServiceRecord> mTmpCollectionResults = null;
    static final int LAST_ANR_LIFETIME_DURATION_MSECS = 0x6DDD00;
    String mLastAnrDump;
    final Runnable mLastAnrDumpClearer = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ActivityManagerService activityManagerService = ActiveServices.this.mAm;
            synchronized (activityManagerService) {
                ActiveServices.this.mLastAnrDump = null;
            }
        }
    };

    public ActiveServices(ActivityManagerService service) {
        this.mAm = service;
        int maxBg = 0;
        try {
            maxBg = Integer.parseInt(SystemProperties.get("ro.config.max_starting_bg", "0"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.mMaxStartingBackground = maxBg > 0 ? maxBg : (ActivityManager.isLowRamDeviceStatic() ? 1 : 8);
    }

    ServiceRecord getServiceByName(ComponentName name, int callingUser) {
        return this.getServiceMap((int)callingUser).mServicesByName.get(name);
    }

    boolean hasBackgroundServices(int callingUser) {
        ServiceMap smap = this.mServiceMap.get(callingUser);
        return smap != null ? smap.mStartingBackground.size() >= this.mMaxStartingBackground : false;
    }

    private ServiceMap getServiceMap(int callingUser) {
        ServiceMap smap = this.mServiceMap.get(callingUser);
        if (smap == null) {
            smap = new ServiceMap(this.mAm.mHandler.getLooper(), callingUser);
            this.mServiceMap.put(callingUser, smap);
        }
        return smap;
    }

    ArrayMap<ComponentName, ServiceRecord> getServices(int callingUser) {
        return this.getServiceMap((int)callingUser).mServicesByName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName startServiceLocked(IApplicationThread caller, Intent service, String resolvedType, int callingPid, int callingUid, String callingPackage, int userId) throws TransactionTooLargeException {
        boolean callerFg;
        if (caller != null) {
            ProcessRecord callerApp = this.mAm.getRecordForAppLocked(caller);
            if (callerApp == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when starting service " + service);
            }
            callerFg = callerApp.setSchedGroup != 0;
        } else {
            callerFg = true;
        }
        ServiceLookupResult res = this.retrieveServiceLocked(service, resolvedType, callingPackage, callingPid, callingUid, userId, true, callerFg, false);
        if (res == null) {
            return null;
        }
        if (res.record == null) {
            return new ComponentName("!", res.permission != null ? res.permission : "private to package");
        }
        ServiceRecord r = res.record;
        if (!this.mAm.mUserController.exists(r.userId)) {
            Slog.w("ActivityManager", "Trying to start service with non-existent user! " + r.userId);
            return null;
        }
        if (!r.startRequested) {
            long token = Binder.clearCallingIdentity();
            try {
                int allowed = this.mAm.checkAllowBackgroundLocked(r.appInfo.uid, r.packageName, callingPid, true);
                if (allowed != 0) {
                    Slog.w("ActivityManager", "Background start not allowed: service " + service + " to " + r.name.flattenToShortString() + " from pid=" + callingPid + " uid=" + callingUid + " pkg=" + callingPackage);
                    ComponentName componentName = null;
                    return componentName;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
        ActivityManagerService.NeededUriGrants neededGrants = this.mAm.checkGrantUriPermissionFromIntentLocked(callingUid, r.packageName, service, service.getFlags(), null, r.userId);
        if (Build.PERMISSIONS_REVIEW_REQUIRED && !this.requestStartTargetPermissionsReviewIfNeededLocked(r, callingPackage, callingUid, service, callerFg, userId)) {
            return null;
        }
        if (this.unscheduleServiceRestartLocked(r, callingUid, false)) {
            // empty if block
        }
        r.lastActivity = SystemClock.uptimeMillis();
        r.startRequested = true;
        r.delayedStop = false;
        r.pendingStarts.add(new ServiceRecord.StartItem(r, false, r.makeNextStartId(), service, neededGrants));
        ServiceMap smap = this.getServiceMap(r.userId);
        boolean addToStarting = false;
        if (!callerFg && r.app == null && this.mAm.mUserController.hasStartedUserState(r.userId)) {
            ProcessRecord proc = this.mAm.getProcessRecordLocked(r.processName, r.appInfo.uid, false);
            if (proc == null || proc.curProcState > 11) {
                if (r.delayed) {
                    return r.name;
                }
                if (smap.mStartingBackground.size() >= this.mMaxStartingBackground) {
                    Slog.i("ActivityManager", "Delaying start of: " + r);
                    smap.mDelayedStartList.add(r);
                    r.delayed = true;
                    return r.name;
                }
                addToStarting = true;
            } else if (proc.curProcState >= 10) {
                addToStarting = true;
            }
        }
        return this.startServiceInnerLocked(smap, service, r, callerFg, addToStarting);
    }

    private boolean requestStartTargetPermissionsReviewIfNeededLocked(ServiceRecord r, String callingPackage, int callingUid, Intent service, boolean callerFg, final int userId) {
        if (this.mAm.getPackageManagerInternalLocked().isPermissionsReviewRequired(r.packageName, r.userId)) {
            if (!callerFg) {
                Slog.w("ActivityManager", "u" + r.userId + " Starting a service in package" + r.packageName + " requires a permissions review");
                return false;
            }
            IIntentSender target = this.mAm.getIntentSenderLocked(4, callingPackage, callingUid, userId, null, null, 0, new Intent[]{service}, new String[]{service.resolveType(this.mAm.mContext.getContentResolver())}, 0x54000000, null);
            final Intent intent = new Intent("android.intent.action.REVIEW_PERMISSIONS");
            intent.addFlags(0x10800000);
            intent.putExtra("android.intent.extra.PACKAGE_NAME", r.packageName);
            intent.putExtra("android.intent.extra.INTENT", new IntentSender(target));
            this.mAm.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ActiveServices.this.mAm.mContext.startActivityAsUser(intent, new UserHandle(userId));
                }
            });
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName startServiceInnerLocked(ServiceMap smap, Intent service, ServiceRecord r, boolean callerFg, boolean addToStarting) throws TransactionTooLargeException {
        ServiceState stracker = r.getTracker();
        if (stracker != null) {
            stracker.setStarted(true, this.mAm.mProcessStats.getMemFactorLocked(), r.lastActivity);
        }
        r.callStart = false;
        BatteryStatsImpl batteryStatsImpl = r.stats.getBatteryStats();
        synchronized (batteryStatsImpl) {
            r.stats.startRunningLocked();
        }
        String error = this.bringUpServiceLocked(r, service.getFlags(), callerFg, false, false);
        if (error != null) {
            return new ComponentName("!!", error);
        }
        if (r.startRequested && addToStarting) {
            boolean first = smap.mStartingBackground.size() == 0;
            smap.mStartingBackground.add(r);
            r.startingBgTimeout = SystemClock.uptimeMillis() + 15000L;
            if (first) {
                smap.rescheduleDelayedStarts();
            }
        } else if (callerFg) {
            smap.ensureNotStartingBackground(r);
        }
        return r.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServiceLocked(ServiceRecord service) {
        if (service.delayed) {
            service.delayedStop = true;
            return;
        }
        BatteryStatsImpl batteryStatsImpl = service.stats.getBatteryStats();
        synchronized (batteryStatsImpl) {
            service.stats.stopRunningLocked();
        }
        service.startRequested = false;
        if (service.tracker != null) {
            service.tracker.setStarted(false, this.mAm.mProcessStats.getMemFactorLocked(), SystemClock.uptimeMillis());
        }
        service.callStart = false;
        this.bringDownServiceIfNeededLocked(service, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int stopServiceLocked(IApplicationThread caller, Intent service, String resolvedType, int userId) {
        ProcessRecord callerApp = this.mAm.getRecordForAppLocked(caller);
        if (caller != null && callerApp == null) {
            throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when stopping service " + service);
        }
        ServiceLookupResult r = this.retrieveServiceLocked(service, resolvedType, null, Binder.getCallingPid(), Binder.getCallingUid(), userId, false, false, false);
        if (r != null) {
            if (r.record != null) {
                long origId = Binder.clearCallingIdentity();
                try {
                    this.stopServiceLocked(r.record);
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
                return 1;
            }
            return -1;
        }
        return 0;
    }

    void stopInBackgroundLocked(int uid) {
        ServiceMap services = this.mServiceMap.get(UserHandle.getUserId(uid));
        ArrayList<ServiceRecord> stopping = null;
        if (services != null) {
            ServiceRecord service;
            int i;
            for (i = services.mServicesByName.size() - 1; i >= 0; --i) {
                service = services.mServicesByName.valueAt(i);
                if (service.appInfo.uid != uid || !service.startRequested || this.mAm.mAppOpsService.noteOperation(63, uid, service.packageName) == 0 || stopping != null) continue;
                stopping = new ArrayList<ServiceRecord>();
                stopping.add(service);
            }
            if (stopping != null) {
                for (i = stopping.size() - 1; i >= 0; --i) {
                    service = (ServiceRecord)stopping.get(i);
                    service.delayed = false;
                    services.ensureNotStartingBackground(service);
                    this.stopServiceLocked(service);
                }
            }
        }
    }

    IBinder peekServiceLocked(Intent service, String resolvedType, String callingPackage) {
        ServiceLookupResult r = this.retrieveServiceLocked(service, resolvedType, callingPackage, Binder.getCallingPid(), Binder.getCallingUid(), UserHandle.getCallingUserId(), false, false, false);
        IBinder ret = null;
        if (r != null) {
            if (r.record == null) {
                throw new SecurityException("Permission Denial: Accessing service from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + r.permission);
            }
            IntentBindRecord ib = r.record.bindings.get(r.record.intent);
            if (ib != null) {
                ret = ib.binder;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean stopServiceTokenLocked(ComponentName className, IBinder token, int startId) {
        ServiceRecord r = this.findServiceLocked(className, token, UserHandle.getCallingUserId());
        if (r != null) {
            Object si;
            if (startId >= 0) {
                si = r.findDeliveredStart(startId, false);
                if (si != null) {
                    while (r.deliveredStarts.size() > 0) {
                        ServiceRecord.StartItem cur = r.deliveredStarts.remove(0);
                        cur.removeUriPermissionsLocked();
                        if (cur != si) continue;
                        break;
                    }
                }
                if (r.getLastStartId() != startId) {
                    return false;
                }
                if (r.deliveredStarts.size() > 0) {
                    Slog.w("ActivityManager", "stopServiceToken startId " + startId + " is last, but have " + r.deliveredStarts.size() + " remaining args");
                }
            }
            si = r.stats.getBatteryStats();
            synchronized (si) {
                r.stats.stopRunningLocked();
            }
            r.startRequested = false;
            if (r.tracker != null) {
                r.tracker.setStarted(false, this.mAm.mProcessStats.getMemFactorLocked(), SystemClock.uptimeMillis());
            }
            r.callStart = false;
            long origId = Binder.clearCallingIdentity();
            this.bringDownServiceIfNeededLocked(r, false, false);
            Binder.restoreCallingIdentity(origId);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceForegroundLocked(ComponentName className, IBinder token, int id2, Notification notification, int flags) {
        int userId = UserHandle.getCallingUserId();
        long origId = Binder.clearCallingIdentity();
        try {
            ServiceRecord r = this.findServiceLocked(className, token, userId);
            if (r != null) {
                if (id2 != 0) {
                    if (notification == null) {
                        throw new IllegalArgumentException("null notification");
                    }
                    if (r.foregroundId != id2) {
                        r.cancelNotification();
                        r.foregroundId = id2;
                    }
                    notification.flags |= 0x40;
                    r.foregroundNoti = notification;
                    r.isForeground = true;
                    r.postNotification();
                    if (r.app != null) {
                        this.updateServiceForegroundLocked(r.app, true);
                    }
                    this.getServiceMap(r.userId).ensureNotStartingBackground(r);
                    this.mAm.notifyPackageUse(r.serviceInfo.packageName, 2);
                } else {
                    if (r.isForeground) {
                        r.isForeground = false;
                        if (r.app != null) {
                            this.mAm.updateLruProcessLocked(r.app, false, null);
                            this.updateServiceForegroundLocked(r.app, true);
                        }
                    }
                    if ((flags & 1) != 0) {
                        r.cancelNotification();
                        r.foregroundId = 0;
                        r.foregroundNoti = null;
                    } else if (r.appInfo.targetSdkVersion >= 21) {
                        r.stripForegroundServiceFlagFromNotification();
                        if ((flags & 2) != 0) {
                            r.foregroundId = 0;
                            r.foregroundNoti = null;
                        }
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    private void updateServiceForegroundLocked(ProcessRecord proc, boolean oomAdj) {
        boolean anyForeground = false;
        for (int i = proc.services.size() - 1; i >= 0; --i) {
            ServiceRecord sr = proc.services.valueAt(i);
            if (!sr.isForeground) continue;
            anyForeground = true;
            break;
        }
        this.mAm.updateProcessForegroundLocked(proc, anyForeground, oomAdj);
    }

    private void updateWhitelistManagerLocked(ProcessRecord proc) {
        proc.whitelistManager = false;
        for (int i = proc.services.size() - 1; i >= 0; --i) {
            ServiceRecord sr = proc.services.valueAt(i);
            if (!sr.whitelistManager) continue;
            proc.whitelistManager = true;
            break;
        }
    }

    public void updateServiceConnectionActivitiesLocked(ProcessRecord clientProc) {
        ArraySet<ProcessRecord> updatedProcesses = null;
        for (int i = 0; i < clientProc.connections.size(); ++i) {
            ConnectionRecord conn = clientProc.connections.valueAt(i);
            ProcessRecord proc = conn.binding.service.app;
            if (proc == null || proc == clientProc) continue;
            if (updatedProcesses == null) {
                updatedProcesses = new ArraySet<ProcessRecord>();
            } else if (updatedProcesses.contains(proc)) continue;
            updatedProcesses.add(proc);
            this.updateServiceClientActivitiesLocked(proc, null, false);
        }
    }

    private boolean updateServiceClientActivitiesLocked(ProcessRecord proc, ConnectionRecord modCr, boolean updateLru) {
        if (modCr != null && modCr.binding.client != null && modCr.binding.client.activities.size() <= 0) {
            return false;
        }
        boolean anyClientActivities = false;
        for (int i = proc.services.size() - 1; i >= 0 && !anyClientActivities; --i) {
            ServiceRecord sr = proc.services.valueAt(i);
            block1: for (int conni = sr.connections.size() - 1; conni >= 0 && !anyClientActivities; --conni) {
                ArrayList<ConnectionRecord> clist = sr.connections.valueAt(conni);
                for (int cri = clist.size() - 1; cri >= 0; --cri) {
                    ConnectionRecord cr = clist.get(cri);
                    if (cr.binding.client == null || cr.binding.client == proc || cr.binding.client.activities.size() <= 0) continue;
                    anyClientActivities = true;
                    continue block1;
                }
            }
        }
        if (anyClientActivities != proc.hasClientActivities) {
            proc.hasClientActivities = anyClientActivities;
            if (updateLru) {
                this.mAm.updateLruProcessLocked(proc, anyClientActivities, null);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int bindServiceLocked(IApplicationThread caller, IBinder token, Intent service, String resolvedType, final IServiceConnection connection, int flags, String callingPackage, final int userId) throws TransactionTooLargeException {
        boolean isCallerSystem;
        ProcessRecord callerApp = this.mAm.getRecordForAppLocked(caller);
        if (callerApp == null) {
            throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when binding service " + service);
        }
        ActivityRecord activity = null;
        if (token != null && (activity = ActivityRecord.isInStackLocked(token)) == null) {
            Slog.w("ActivityManager", "Binding with unknown activity: " + token);
            return 0;
        }
        int clientLabel = 0;
        PendingIntent clientIntent = null;
        boolean bl = isCallerSystem = callerApp.info.uid == 1000;
        if (isCallerSystem) {
            service.setDefusable(true);
            clientIntent = (PendingIntent)service.getParcelableExtra("android.intent.extra.client_intent");
            if (clientIntent != null && (clientLabel = service.getIntExtra("android.intent.extra.client_label", 0)) != 0) {
                service = service.cloneFilter();
            }
        }
        if ((flags & 0x8000000) != 0) {
            this.mAm.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "BIND_TREAT_LIKE_ACTIVITY");
        }
        if ((flags & 0x1000000) != 0 && !isCallerSystem) {
            throw new SecurityException("Non-system caller " + caller + " (pid=" + Binder.getCallingPid() + ") set BIND_ALLOW_WHITELIST_MANAGEMENT when binding service " + service);
        }
        final boolean callerFg = callerApp.setSchedGroup != 0;
        boolean isBindExternal = (flags & Integer.MIN_VALUE) != 0;
        ServiceLookupResult res = this.retrieveServiceLocked(service, resolvedType, callingPackage, Binder.getCallingPid(), Binder.getCallingUid(), userId, true, callerFg, isBindExternal);
        if (res == null) {
            return 0;
        }
        if (res.record == null) {
            return -1;
        }
        ServiceRecord s = res.record;
        boolean permissionsReviewRequired = false;
        if (Build.PERMISSIONS_REVIEW_REQUIRED && this.mAm.getPackageManagerInternalLocked().isPermissionsReviewRequired(s.packageName, s.userId)) {
            permissionsReviewRequired = true;
            if (!callerFg) {
                Slog.w("ActivityManager", "u" + s.userId + " Binding to a service in package" + s.packageName + " requires a permissions review");
                return 0;
            }
            final ServiceRecord serviceRecord = s;
            final Intent serviceIntent = service;
            RemoteCallback callback = new RemoteCallback(new RemoteCallback.OnResultListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResult(Bundle result) {
                    ActivityManagerService activityManagerService = ActiveServices.this.mAm;
                    synchronized (activityManagerService) {
                        long identity = Binder.clearCallingIdentity();
                        try {
                            if (!ActiveServices.this.mPendingServices.contains(serviceRecord)) {
                                return;
                            }
                            if (!ActiveServices.this.mAm.getPackageManagerInternalLocked().isPermissionsReviewRequired(serviceRecord.packageName, serviceRecord.userId)) {
                                try {
                                    ActiveServices.this.bringUpServiceLocked(serviceRecord, serviceIntent.getFlags(), callerFg, false, false);
                                }
                                catch (RemoteException remoteException) {}
                            } else {
                                ActiveServices.this.unbindServiceLocked(connection);
                            }
                        }
                        finally {
                            Binder.restoreCallingIdentity(identity);
                        }
                    }
                }
            });
            final Intent intent = new Intent("android.intent.action.REVIEW_PERMISSIONS");
            intent.addFlags(0x10800000);
            intent.putExtra("android.intent.extra.PACKAGE_NAME", s.packageName);
            intent.putExtra("android.intent.extra.REMOTE_CALLBACK", callback);
            this.mAm.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ActiveServices.this.mAm.mContext.startActivityAsUser(intent, new UserHandle(userId));
                }
            });
        }
        long origId = Binder.clearCallingIdentity();
        try {
            if (this.unscheduleServiceRestartLocked(s, callerApp.info.uid, false)) {
                // empty if block
            }
            if ((flags & 1) != 0) {
                ServiceState stracker;
                s.lastActivity = SystemClock.uptimeMillis();
                if (!s.hasAutoCreateConnections() && (stracker = s.getTracker()) != null) {
                    stracker.setBound(true, this.mAm.mProcessStats.getMemFactorLocked(), s.lastActivity);
                }
            }
            this.mAm.startAssociationLocked(callerApp.uid, callerApp.processName, callerApp.curProcState, s.appInfo.uid, s.name, s.processName);
            AppBindRecord b = s.retrieveAppBindingLocked(service, callerApp);
            ConnectionRecord c = new ConnectionRecord(b, activity, connection, flags, clientLabel, clientIntent);
            IBinder binder = connection.asBinder();
            ArrayList<ConnectionRecord> clist = s.connections.get(binder);
            if (clist == null) {
                clist = new ArrayList();
                s.connections.put(binder, clist);
            }
            clist.add(c);
            b.connections.add(c);
            if (activity != null) {
                if (activity.connections == null) {
                    activity.connections = new HashSet();
                }
                activity.connections.add(c);
            }
            b.client.connections.add(c);
            if ((c.flags & 8) != 0) {
                b.client.hasAboveClient = true;
            }
            if ((c.flags & 0x1000000) != 0) {
                s.whitelistManager = true;
            }
            if (s.app != null) {
                this.updateServiceClientActivitiesLocked(s.app, c, true);
            }
            if ((clist = this.mServiceConnections.get(binder)) == null) {
                clist = new ArrayList();
                this.mServiceConnections.put(binder, clist);
            }
            clist.add(c);
            if ((flags & 1) != 0) {
                s.lastActivity = SystemClock.uptimeMillis();
                if (this.bringUpServiceLocked(s, service.getFlags(), callerFg, false, permissionsReviewRequired) != null) {
                    int n = 0;
                    return n;
                }
            }
            if (s.app != null) {
                if ((flags & 0x8000000) != 0) {
                    s.app.treatLikeActivity = true;
                }
                if (s.whitelistManager) {
                    s.app.whitelistManager = true;
                }
                this.mAm.updateLruProcessLocked(s.app, s.app.hasClientActivities || s.app.treatLikeActivity, b.client);
                this.mAm.updateOomAdjLocked(s.app);
            }
            if (s.app != null && b.intent.received) {
                try {
                    c.conn.connected(s.name, b.intent.binder);
                }
                catch (Exception e) {
                    Slog.w("ActivityManager", "Failure sending service " + s.shortName + " to connection " + c.conn.asBinder() + " (in " + c.binding.client.processName + ")", e);
                }
                if (b.intent.apps.size() == 1 && b.intent.doRebind) {
                    this.requestServiceBindingLocked(s, b.intent, callerFg, true);
                }
            } else if (!b.intent.requested) {
                this.requestServiceBindingLocked(s, b.intent, callerFg, false);
            }
            this.getServiceMap(s.userId).ensureNotStartingBackground(s);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        return 1;
    }

    private void foo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishServiceLocked(ServiceRecord r, Intent intent, IBinder service) {
        long origId = Binder.clearCallingIdentity();
        try {
            if (r != null) {
                Intent.FilterComparison filter = new Intent.FilterComparison(intent);
                IntentBindRecord b = r.bindings.get(filter);
                if (b != null && !b.received) {
                    b.binder = service;
                    b.requested = true;
                    b.received = true;
                    for (int conni = r.connections.size() - 1; conni >= 0; --conni) {
                        ArrayList<ConnectionRecord> clist = r.connections.valueAt(conni);
                        for (int i = 0; i < clist.size(); ++i) {
                            ConnectionRecord c = clist.get(i);
                            if (!filter.equals(c.binding.intent.intent)) continue;
                            try {
                                c.conn.connected(r.name, service);
                                continue;
                            }
                            catch (Exception e) {
                                Slog.w("ActivityManager", "Failure sending service " + r.name + " to connection " + c.conn.asBinder() + " (in " + c.binding.client.processName + ")", e);
                            }
                        }
                    }
                }
                this.serviceDoneExecutingLocked(r, this.mDestroyingServices.contains(r), false);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unbindServiceLocked(IServiceConnection connection) {
        IBinder binder = connection.asBinder();
        ArrayList<ConnectionRecord> clist = this.mServiceConnections.get(binder);
        if (clist == null) {
            Slog.w("ActivityManager", "Unbind failed: could not find connection for " + connection.asBinder());
            return false;
        }
        long origId = Binder.clearCallingIdentity();
        try {
            while (clist.size() > 0) {
                ConnectionRecord r = clist.get(0);
                this.removeConnectionLocked(r, null, null);
                if (clist.size() > 0 && clist.get(0) == r) {
                    Slog.wtf("ActivityManager", "Connection " + r + " not removed for binder " + binder);
                    clist.remove(0);
                }
                if (r.binding.service.app == null) continue;
                if (r.binding.service.app.whitelistManager) {
                    this.updateWhitelistManagerLocked(r.binding.service.app);
                }
                if ((r.flags & 0x8000000) != 0) {
                    r.binding.service.app.treatLikeActivity = true;
                    this.mAm.updateLruProcessLocked(r.binding.service.app, r.binding.service.app.hasClientActivities || r.binding.service.app.treatLikeActivity, null);
                }
                this.mAm.updateOomAdjLocked(r.binding.service.app);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindFinishedLocked(ServiceRecord r, Intent intent, boolean doRebind) {
        long origId = Binder.clearCallingIdentity();
        try {
            if (r != null) {
                Intent.FilterComparison filter = new Intent.FilterComparison(intent);
                IntentBindRecord b = r.bindings.get(filter);
                boolean inDestroying = this.mDestroyingServices.contains(r);
                if (b != null) {
                    if (b.apps.size() > 0 && !inDestroying) {
                        boolean inFg = false;
                        for (int i = b.apps.size() - 1; i >= 0; --i) {
                            ProcessRecord client = b.apps.valueAt((int)i).client;
                            if (client == null || client.setSchedGroup == 0) continue;
                            inFg = true;
                            break;
                        }
                        try {
                            this.requestServiceBindingLocked(r, b, inFg, true);
                        }
                        catch (TransactionTooLargeException transactionTooLargeException) {}
                    } else {
                        b.doRebind = true;
                    }
                }
                this.serviceDoneExecutingLocked(r, inDestroying, false);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    private final ServiceRecord findServiceLocked(ComponentName name, IBinder token, int userId) {
        ServiceRecord r = this.getServiceByName(name, userId);
        return r == token ? r : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ServiceLookupResult retrieveServiceLocked(Intent service, String resolvedType, String callingPackage, int callingPid, int callingUid, int userId, boolean createIfNeeded, boolean callingFromFg, boolean isBindExternal) {
        int opCode;
        ServiceRecord r;
        block22: {
            r = null;
            userId = this.mAm.mUserController.handleIncomingUser(callingPid, callingUid, userId, false, 1, "service", null);
            ServiceMap smap = this.getServiceMap(userId);
            ComponentName comp = service.getComponent();
            if (comp != null) {
                r = smap.mServicesByName.get(comp);
            }
            if (r == null && !isBindExternal) {
                Intent.FilterComparison filter = new Intent.FilterComparison(service);
                r = smap.mServicesByIntent.get(filter);
            }
            if (r != null && (r.serviceInfo.flags & 4) != 0 && !callingPackage.equals(r.packageName)) {
                r = null;
            }
            if (r == null) {
                try {
                    BatteryStatsImpl stats;
                    ServiceInfo sInfo;
                    ResolveInfo rInfo = AppGlobals.getPackageManager().resolveService(service, resolvedType, 0x10000400, userId);
                    ServiceInfo serviceInfo = sInfo = rInfo != null ? rInfo.serviceInfo : null;
                    if (sInfo == null) {
                        Slog.w("ActivityManager", "Unable to start service " + service + " U=" + userId + ": not found");
                        return null;
                    }
                    ComponentName name = new ComponentName(sInfo.applicationInfo.packageName, sInfo.name);
                    if ((sInfo.flags & 4) != 0) {
                        if (!isBindExternal) throw new SecurityException("BIND_EXTERNAL_SERVICE required for " + name);
                        if (!sInfo.exported) {
                            throw new SecurityException("BIND_EXTERNAL_SERVICE failed, " + name + " is not exported");
                        }
                        if ((sInfo.flags & 2) == 0) {
                            throw new SecurityException("BIND_EXTERNAL_SERVICE failed, " + name + " is not an isolatedProcess");
                        }
                        ApplicationInfo aInfo = AppGlobals.getPackageManager().getApplicationInfo(callingPackage, 1024, userId);
                        if (aInfo == null) {
                            throw new SecurityException("BIND_EXTERNAL_SERVICE failed, could not resolve client package " + callingPackage);
                        }
                        sInfo = new ServiceInfo(sInfo);
                        sInfo.applicationInfo = new ApplicationInfo(sInfo.applicationInfo);
                        sInfo.applicationInfo.packageName = aInfo.packageName;
                        sInfo.applicationInfo.uid = aInfo.uid;
                        name = new ComponentName(aInfo.packageName, name.getClassName());
                        service.setComponent(name);
                    } else if (isBindExternal) {
                        throw new SecurityException("BIND_EXTERNAL_SERVICE failed, " + name + " is not an externalService");
                    }
                    if (userId > 0) {
                        if (this.mAm.isSingleton(sInfo.processName, sInfo.applicationInfo, sInfo.name, sInfo.flags) && this.mAm.isValidSingletonCall(callingUid, sInfo.applicationInfo.uid)) {
                            userId = 0;
                            smap = this.getServiceMap(0);
                        }
                        sInfo = new ServiceInfo(sInfo);
                        sInfo.applicationInfo = this.mAm.getAppInfoForUser(sInfo.applicationInfo, userId);
                    }
                    if ((r = smap.mServicesByName.get(name)) != null || !createIfNeeded) break block22;
                    Intent.FilterComparison filter = new Intent.FilterComparison(service.cloneFilter());
                    ServiceRestarter res = new ServiceRestarter();
                    BatteryStatsImpl.Uid.Pkg.Serv ss = null;
                    BatteryStatsImpl batteryStatsImpl = stats = this.mAm.mBatteryStatsService.getActiveStatistics();
                    synchronized (batteryStatsImpl) {
                        ss = stats.getServiceStatsLocked(sInfo.applicationInfo.uid, sInfo.packageName, sInfo.name);
                    }
                    r = new ServiceRecord(this.mAm, ss, name, filter, sInfo, callingFromFg, res);
                    res.setService(r);
                    smap.mServicesByName.put(name, r);
                    smap.mServicesByIntent.put(filter, r);
                    for (int i = this.mPendingServices.size() - 1; i >= 0; --i) {
                        ServiceRecord pr = this.mPendingServices.get(i);
                        if (pr.serviceInfo.applicationInfo.uid != sInfo.applicationInfo.uid || !pr.name.equals(name)) continue;
                        this.mPendingServices.remove(i);
                    }
                }
                catch (RemoteException rInfo) {
                    // empty catch block
                }
            }
        }
        if (r == null) return null;
        if (this.mAm.checkComponentPermission(r.permission, callingPid, callingUid, r.appInfo.uid, r.exported) != 0) {
            if (!r.exported) {
                Slog.w("ActivityManager", "Permission Denial: Accessing service " + r.name + " from pid=" + callingPid + ", uid=" + callingUid + " that is not exported from uid " + r.appInfo.uid);
                return new ServiceLookupResult(null, "not exported from uid " + r.appInfo.uid);
            }
            Slog.w("ActivityManager", "Permission Denial: Accessing service " + r.name + " from pid=" + callingPid + ", uid=" + callingUid + " requires " + r.permission);
            return new ServiceLookupResult(null, r.permission);
        }
        if (r.permission != null && callingPackage != null && (opCode = AppOpsManager.permissionToOpCode(r.permission)) != -1 && this.mAm.mAppOpsService.noteOperation(opCode, callingUid, callingPackage) != 0) {
            Slog.w("ActivityManager", "Appop Denial: Accessing service " + r.name + " from pid=" + callingPid + ", uid=" + callingUid + " requires appop " + AppOpsManager.opToName(opCode));
            return null;
        }
        if (this.mAm.mIntentFirewall.checkService(r.name, service, callingUid, callingPid, resolvedType, r.appInfo)) return new ServiceLookupResult(r, null);
        return null;
    }

    private final void bumpServiceExecutingLocked(ServiceRecord r, boolean fg, String why) {
        long now = SystemClock.uptimeMillis();
        if (r.executeNesting == 0) {
            r.executeFg = fg;
            ServiceState stracker = r.getTracker();
            if (stracker != null) {
                stracker.setExecuting(true, this.mAm.mProcessStats.getMemFactorLocked(), now);
            }
            if (r.app != null) {
                r.app.executingServices.add(r);
                r.app.execServicesFg |= fg;
                if (r.app.executingServices.size() == 1) {
                    this.scheduleServiceTimeoutLocked(r.app);
                }
            }
        } else if (r.app != null && fg && !r.app.execServicesFg) {
            r.app.execServicesFg = true;
            this.scheduleServiceTimeoutLocked(r.app);
        }
        r.executeFg |= fg;
        ++r.executeNesting;
        r.executingStart = now;
    }

    private final boolean requestServiceBindingLocked(ServiceRecord r, IntentBindRecord i, boolean execInFg, boolean rebind) throws TransactionTooLargeException {
        if (r.app == null || r.app.thread == null) {
            return false;
        }
        if ((!i.requested || rebind) && i.apps.size() > 0) {
            try {
                this.bumpServiceExecutingLocked(r, execInFg, "bind");
                r.app.forceProcessStateUpTo(10);
                r.app.thread.scheduleBindService(r, i.intent.getIntent(), rebind, r.app.repProcState);
                if (!rebind) {
                    i.requested = true;
                }
                i.hasBound = true;
                i.doRebind = false;
            }
            catch (TransactionTooLargeException e) {
                boolean inDestroying = this.mDestroyingServices.contains(r);
                this.serviceDoneExecutingLocked(r, inDestroying, inDestroying);
                throw e;
            }
            catch (RemoteException e) {
                boolean inDestroying = this.mDestroyingServices.contains(r);
                this.serviceDoneExecutingLocked(r, inDestroying, inDestroying);
                return false;
            }
        }
        return true;
    }

    private final boolean scheduleServiceRestartLocked(ServiceRecord r, boolean allowCancel) {
        boolean canceled = false;
        if (this.mAm.isShuttingDownLocked()) {
            Slog.w("ActivityManager", "Not scheduling restart of crashed service " + r.shortName + " - system is shutting down");
            return false;
        }
        ServiceMap smap = this.getServiceMap(r.userId);
        if (smap.mServicesByName.get(r.name) != r) {
            ServiceRecord cur = smap.mServicesByName.get(r.name);
            Slog.wtf("ActivityManager", "Attempting to schedule restart of " + r + " when found in map: " + cur);
            return false;
        }
        long now = SystemClock.uptimeMillis();
        if ((r.serviceInfo.applicationInfo.flags & 8) == 0) {
            boolean repeat;
            long minDuration = 1000L;
            long resetTime = 60000L;
            int N = r.deliveredStarts.size();
            if (N > 0) {
                for (int i = N - 1; i >= 0; --i) {
                    ServiceRecord.StartItem si = r.deliveredStarts.get(i);
                    si.removeUriPermissionsLocked();
                    if (si.intent == null) continue;
                    if (!allowCancel || si.deliveryCount < 3 && si.doneExecutingCount < 6) {
                        r.pendingStarts.add(0, si);
                        long dur = SystemClock.uptimeMillis() - si.deliveredTime;
                        if (minDuration < (dur *= 2L)) {
                            minDuration = dur;
                        }
                        if (resetTime >= dur) continue;
                        resetTime = dur;
                        continue;
                    }
                    Slog.w("ActivityManager", "Canceling start item " + si.intent + " in service " + r.name);
                    canceled = true;
                }
                r.deliveredStarts.clear();
            }
            ++r.totalRestartCount;
            if (r.restartDelay == 0L) {
                ++r.restartCount;
                r.restartDelay = minDuration;
            } else if (now > r.restartTime + resetTime) {
                r.restartCount = 1;
                r.restartDelay = minDuration;
            } else {
                r.restartDelay *= 4L;
                if (r.restartDelay < minDuration) {
                    r.restartDelay = minDuration;
                }
            }
            r.nextRestartTime = now + r.restartDelay;
            block1: do {
                repeat = false;
                for (int i = this.mRestartingServices.size() - 1; i >= 0; --i) {
                    ServiceRecord r2 = this.mRestartingServices.get(i);
                    if (r2 == r || r.nextRestartTime < r2.nextRestartTime - 10000L || r.nextRestartTime >= r2.nextRestartTime + 10000L) continue;
                    r.nextRestartTime = r2.nextRestartTime + 10000L;
                    r.restartDelay = r.nextRestartTime - now;
                    repeat = true;
                    continue block1;
                }
            } while (repeat);
        } else {
            ++r.totalRestartCount;
            r.restartCount = 0;
            r.restartDelay = 0L;
            r.nextRestartTime = now;
        }
        if (!this.mRestartingServices.contains(r)) {
            r.createdFromFg = false;
            this.mRestartingServices.add(r);
            r.makeRestarting(this.mAm.mProcessStats.getMemFactorLocked(), now);
        }
        r.cancelNotification();
        this.mAm.mHandler.removeCallbacks(r.restarter);
        this.mAm.mHandler.postAtTime(r.restarter, r.nextRestartTime);
        r.nextRestartTime = SystemClock.uptimeMillis() + r.restartDelay;
        Slog.w("ActivityManager", "Scheduling restart of crashed service " + r.shortName + " in " + r.restartDelay + "ms");
        EventLog.writeEvent(30035, r.userId, r.shortName, r.restartDelay);
        return canceled;
    }

    final void performServiceRestartLocked(ServiceRecord r) {
        if (!this.mRestartingServices.contains(r)) {
            return;
        }
        if (!this.isServiceNeeded(r, false, false)) {
            Slog.wtf("ActivityManager", "Restarting service that is not needed: " + r);
            return;
        }
        try {
            this.bringUpServiceLocked(r, r.intent.getIntent().getFlags(), r.createdFromFg, true, false);
        }
        catch (TransactionTooLargeException transactionTooLargeException) {
            // empty catch block
        }
    }

    private final boolean unscheduleServiceRestartLocked(ServiceRecord r, int callingUid, boolean force) {
        if (!force && r.restartDelay == 0L) {
            return false;
        }
        boolean removed = this.mRestartingServices.remove(r);
        if (removed || callingUid != r.appInfo.uid) {
            r.resetRestartCounter();
        }
        if (removed) {
            this.clearRestartingIfNeededLocked(r);
        }
        this.mAm.mHandler.removeCallbacks(r.restarter);
        return true;
    }

    private void clearRestartingIfNeededLocked(ServiceRecord r) {
        if (r.restartTracker != null) {
            boolean stillTracking = false;
            for (int i = this.mRestartingServices.size() - 1; i >= 0; --i) {
                if (this.mRestartingServices.get((int)i).restartTracker != r.restartTracker) continue;
                stillTracking = true;
                break;
            }
            if (!stillTracking) {
                r.restartTracker.setRestarting(false, this.mAm.mProcessStats.getMemFactorLocked(), SystemClock.uptimeMillis());
                r.restartTracker = null;
            }
        }
    }

    private String bringUpServiceLocked(ServiceRecord r, int intentFlags, boolean execInFg, boolean whileRestarting, boolean permissionsReviewRequired) throws TransactionTooLargeException {
        ProcessRecord app;
        if (r.app != null && r.app.thread != null) {
            this.sendServiceArgsLocked(r, execInFg, false);
            return null;
        }
        if (!whileRestarting && r.restartDelay > 0L) {
            return null;
        }
        if (this.mRestartingServices.remove(r)) {
            r.resetRestartCounter();
            this.clearRestartingIfNeededLocked(r);
        }
        if (r.delayed) {
            this.getServiceMap((int)r.userId).mDelayedStartList.remove(r);
            r.delayed = false;
        }
        if (!this.mAm.mUserController.hasStartedUserState(r.userId)) {
            String msg = "Unable to launch app " + r.appInfo.packageName + "/" + r.appInfo.uid + " for service " + r.intent.getIntent() + ": user " + r.userId + " is stopped";
            Slog.w("ActivityManager", msg);
            this.bringDownServiceLocked(r);
            return msg;
        }
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(r.packageName, false, r.userId);
        }
        catch (RemoteException msg) {
        }
        catch (IllegalArgumentException e) {
            Slog.w("ActivityManager", "Failed trying to unstop package " + r.packageName + ": " + e);
        }
        boolean isolated = (r.serviceInfo.flags & 2) != 0;
        String procName = r.processName;
        if (!isolated) {
            app = this.mAm.getProcessRecordLocked(procName, r.appInfo.uid, false);
            if (app != null && app.thread != null) {
                try {
                    app.addPackage(r.appInfo.packageName, r.appInfo.versionCode, this.mAm.mProcessStats);
                    this.realStartServiceLocked(r, app, execInFg);
                    return null;
                }
                catch (TransactionTooLargeException e) {
                    throw e;
                }
                catch (RemoteException e) {
                    Slog.w("ActivityManager", "Exception when starting service " + r.shortName, e);
                }
            }
        } else {
            app = r.isolatedProc;
        }
        if (app == null && !permissionsReviewRequired) {
            app = this.mAm.startProcessLocked(procName, r.appInfo, true, intentFlags, "service", r.name, false, isolated, false);
            if (app == null) {
                String msg = "Unable to launch app " + r.appInfo.packageName + "/" + r.appInfo.uid + " for service " + r.intent.getIntent() + ": process is bad";
                Slog.w("ActivityManager", msg);
                this.bringDownServiceLocked(r);
                return msg;
            }
            if (isolated) {
                r.isolatedProc = app;
            }
        }
        if (!this.mPendingServices.contains(r)) {
            this.mPendingServices.add(r);
        }
        if (r.delayedStop) {
            r.delayedStop = false;
            if (r.startRequested) {
                this.stopServiceLocked(r);
            }
        }
        return null;
    }

    private final void requestServiceBindingsLocked(ServiceRecord r, boolean execInFg) throws TransactionTooLargeException {
        IntentBindRecord ibr;
        for (int i = r.bindings.size() - 1; i >= 0 && this.requestServiceBindingLocked(r, ibr = r.bindings.valueAt(i), execInFg, false); --i) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void realStartServiceLocked(ServiceRecord r, ProcessRecord app, boolean execInFg) throws RemoteException {
        if (app.thread == null) {
            throw new RemoteException();
        }
        r.app = app;
        r.restartTime = r.lastActivity = SystemClock.uptimeMillis();
        boolean newService = app.services.add(r);
        this.bumpServiceExecutingLocked(r, execInFg, "create");
        this.mAm.updateLruProcessLocked(app, false, null);
        this.mAm.updateOomAdjLocked();
        boolean created = false;
        try {
            BatteryStatsImpl batteryStatsImpl = r.stats.getBatteryStats();
            synchronized (batteryStatsImpl) {
                r.stats.startLaunchedLocked();
            }
            this.mAm.notifyPackageUse(r.serviceInfo.packageName, 1);
            app.forceProcessStateUpTo(10);
            app.thread.scheduleCreateService(r, r.serviceInfo, this.mAm.compatibilityInfoForPackageLocked(r.serviceInfo.applicationInfo), app.repProcState);
            r.postNotification();
            created = true;
        }
        catch (DeadObjectException e) {
            Slog.w("ActivityManager", "Application dead when creating service " + r);
            this.mAm.appDiedLocked(app);
            throw e;
        }
        finally {
            if (!created) {
                boolean inDestroying = this.mDestroyingServices.contains(r);
                this.serviceDoneExecutingLocked(r, inDestroying, inDestroying);
                if (newService) {
                    app.services.remove(r);
                    r.app = null;
                }
                if (!inDestroying) {
                    this.scheduleServiceRestartLocked(r, false);
                }
            }
        }
        if (r.whitelistManager) {
            app.whitelistManager = true;
        }
        this.requestServiceBindingsLocked(r, execInFg);
        this.updateServiceClientActivitiesLocked(app, null, true);
        if (r.startRequested && r.callStart && r.pendingStarts.size() == 0) {
            r.pendingStarts.add(new ServiceRecord.StartItem(r, false, r.makeNextStartId(), null, null));
        }
        this.sendServiceArgsLocked(r, execInFg, true);
        if (r.delayed) {
            this.getServiceMap((int)r.userId).mDelayedStartList.remove(r);
            r.delayed = false;
        }
        if (r.delayedStop) {
            r.delayedStop = false;
            if (r.startRequested) {
                this.stopServiceLocked(r);
            }
        }
    }

    private final void sendServiceArgsLocked(ServiceRecord r, boolean execInFg, boolean oomAdjusted) throws TransactionTooLargeException {
        int N = r.pendingStarts.size();
        if (N == 0) {
            return;
        }
        while (r.pendingStarts.size() > 0) {
            Exception caughtException = null;
            ServiceRecord.StartItem si = null;
            try {
                si = r.pendingStarts.remove(0);
                if (si.intent == null && N > 1) continue;
                si.deliveredTime = SystemClock.uptimeMillis();
                r.deliveredStarts.add(si);
                ++si.deliveryCount;
                if (si.neededGrants != null) {
                    this.mAm.grantUriPermissionUncheckedFromIntentLocked(si.neededGrants, si.getUriPermissionsLocked());
                }
                this.bumpServiceExecutingLocked(r, execInFg, "start");
                if (!oomAdjusted) {
                    oomAdjusted = true;
                    this.mAm.updateOomAdjLocked(r.app);
                }
                int flags = 0;
                if (si.deliveryCount > 1) {
                    flags |= 2;
                }
                if (si.doneExecutingCount > 0) {
                    flags |= 1;
                }
                r.app.thread.scheduleServiceArgs(r, si.taskRemoved, si.id, flags, si.intent);
            }
            catch (TransactionTooLargeException e) {
                caughtException = e;
            }
            catch (RemoteException e) {
                caughtException = e;
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Unexpected exception", e);
                caughtException = e;
            }
            if (caughtException == null) continue;
            boolean inDestroying = this.mDestroyingServices.contains(r);
            this.serviceDoneExecutingLocked(r, inDestroying, inDestroying);
            if (!(caughtException instanceof TransactionTooLargeException)) break;
            throw caughtException;
        }
    }

    private final boolean isServiceNeeded(ServiceRecord r, boolean knowConn, boolean hasConn) {
        if (r.startRequested) {
            return true;
        }
        if (!knowConn) {
            hasConn = r.hasAutoCreateConnections();
        }
        return hasConn;
    }

    private final void bringDownServiceIfNeededLocked(ServiceRecord r, boolean knowConn, boolean hasConn) {
        if (this.isServiceNeeded(r, knowConn, hasConn)) {
            return;
        }
        if (this.mPendingServices.contains(r)) {
            return;
        }
        this.bringDownServiceLocked(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void bringDownServiceLocked(ServiceRecord r) {
        for (int conni = r.connections.size() - 1; conni >= 0; --conni) {
            ArrayList<ConnectionRecord> c = r.connections.valueAt(conni);
            for (int i = 0; i < c.size(); ++i) {
                ConnectionRecord cr = c.get(i);
                cr.serviceDead = true;
                try {
                    cr.conn.connected(r.name, null);
                    continue;
                }
                catch (Exception e) {
                    Slog.w("ActivityManager", "Failure disconnecting service " + r.name + " to connection " + c.get((int)i).conn.asBinder() + " (in " + c.get((int)i).binding.client.processName + ")", e);
                }
            }
        }
        if (r.app != null && r.app.thread != null) {
            for (int i = r.bindings.size() - 1; i >= 0; --i) {
                IntentBindRecord ibr = r.bindings.valueAt(i);
                if (!ibr.hasBound) continue;
                try {
                    this.bumpServiceExecutingLocked(r, false, "bring down unbind");
                    this.mAm.updateOomAdjLocked(r.app);
                    ibr.hasBound = false;
                    r.app.thread.scheduleUnbindService(r, ibr.intent.getIntent());
                    continue;
                }
                catch (Exception e) {
                    Slog.w("ActivityManager", "Exception when unbinding service " + r.shortName, e);
                    this.serviceProcessGoneLocked(r);
                }
            }
        }
        r.destroyTime = SystemClock.uptimeMillis();
        ServiceMap smap = this.getServiceMap(r.userId);
        smap.mServicesByName.remove(r.name);
        smap.mServicesByIntent.remove(r.intent);
        r.totalRestartCount = 0;
        this.unscheduleServiceRestartLocked(r, 0, true);
        for (int i = this.mPendingServices.size() - 1; i >= 0; --i) {
            if (this.mPendingServices.get(i) != r) continue;
            this.mPendingServices.remove(i);
        }
        r.cancelNotification();
        r.isForeground = false;
        r.foregroundId = 0;
        r.foregroundNoti = null;
        r.clearDeliveredStartsLocked();
        r.pendingStarts.clear();
        if (r.app != null) {
            BatteryStatsImpl i = r.stats.getBatteryStats();
            synchronized (i) {
                r.stats.stopLaunchedLocked();
            }
            r.app.services.remove(r);
            if (r.whitelistManager) {
                this.updateWhitelistManagerLocked(r.app);
            }
            if (r.app.thread != null) {
                this.updateServiceForegroundLocked(r.app, false);
                try {
                    this.bumpServiceExecutingLocked(r, false, "destroy");
                    this.mDestroyingServices.add(r);
                    r.destroying = true;
                    this.mAm.updateOomAdjLocked(r.app);
                    r.app.thread.scheduleStopService(r);
                }
                catch (Exception e) {
                    Slog.w("ActivityManager", "Exception when destroying service " + r.shortName, e);
                    this.serviceProcessGoneLocked(r);
                }
            }
        }
        if (r.bindings.size() > 0) {
            r.bindings.clear();
        }
        if (r.restarter instanceof ServiceRestarter) {
            ((ServiceRestarter)r.restarter).setService(null);
        }
        int memFactor = this.mAm.mProcessStats.getMemFactorLocked();
        long now = SystemClock.uptimeMillis();
        if (r.tracker != null) {
            r.tracker.setStarted(false, memFactor, now);
            r.tracker.setBound(false, memFactor, now);
            if (r.executeNesting == 0) {
                r.tracker.clearCurrentOwner(r, false);
                r.tracker = null;
            }
        }
        smap.ensureNotStartingBackground(r);
    }

    void removeConnectionLocked(ConnectionRecord c, ProcessRecord skipApp, ActivityRecord skipAct) {
        IBinder binder = c.conn.asBinder();
        AppBindRecord b = c.binding;
        ServiceRecord s = b.service;
        ArrayList<ConnectionRecord> clist = s.connections.get(binder);
        if (clist != null) {
            clist.remove(c);
            if (clist.size() == 0) {
                s.connections.remove(binder);
            }
        }
        b.connections.remove(c);
        if (c.activity != null && c.activity != skipAct && c.activity.connections != null) {
            c.activity.connections.remove(c);
        }
        if (b.client != skipApp) {
            b.client.connections.remove(c);
            if ((c.flags & 8) != 0) {
                b.client.updateHasAboveClientLocked();
            }
            if ((c.flags & 0x1000000) != 0) {
                s.updateWhitelistManager();
                if (!s.whitelistManager && s.app != null) {
                    this.updateWhitelistManagerLocked(s.app);
                }
            }
            if (s.app != null) {
                this.updateServiceClientActivitiesLocked(s.app, c, true);
            }
        }
        if ((clist = this.mServiceConnections.get(binder)) != null) {
            clist.remove(c);
            if (clist.size() == 0) {
                this.mServiceConnections.remove(binder);
            }
        }
        this.mAm.stopAssociationLocked(b.client.uid, b.client.processName, s.appInfo.uid, s.name);
        if (b.connections.size() == 0) {
            b.intent.apps.remove(b.client);
        }
        if (!c.serviceDead) {
            if (s.app != null && s.app.thread != null && b.intent.apps.size() == 0 && b.intent.hasBound) {
                try {
                    this.bumpServiceExecutingLocked(s, false, "unbind");
                    if (b.client != s.app && (c.flags & 0x20) == 0 && s.app.setProcState <= 11) {
                        this.mAm.updateLruProcessLocked(s.app, false, null);
                    }
                    this.mAm.updateOomAdjLocked(s.app);
                    b.intent.hasBound = false;
                    b.intent.doRebind = false;
                    s.app.thread.scheduleUnbindService(s, b.intent.intent.getIntent());
                }
                catch (Exception e) {
                    Slog.w("ActivityManager", "Exception when unbinding service " + s.shortName, e);
                    this.serviceProcessGoneLocked(s);
                }
            }
            this.mPendingServices.remove(s);
            if ((c.flags & 1) != 0) {
                boolean hasAutoCreate = s.hasAutoCreateConnections();
                if (!hasAutoCreate && s.tracker != null) {
                    s.tracker.setBound(false, this.mAm.mProcessStats.getMemFactorLocked(), SystemClock.uptimeMillis());
                }
                this.bringDownServiceIfNeededLocked(s, true, hasAutoCreate);
            }
        }
    }

    void serviceDoneExecutingLocked(ServiceRecord r, int type, int startId, int res) {
        boolean inDestroying = this.mDestroyingServices.contains(r);
        if (r != null) {
            if (type == 1) {
                r.callStart = true;
                switch (res) {
                    case 0: 
                    case 1: {
                        r.findDeliveredStart(startId, true);
                        r.stopIfKilled = false;
                        break;
                    }
                    case 2: {
                        r.findDeliveredStart(startId, true);
                        if (r.getLastStartId() != startId) break;
                        r.stopIfKilled = true;
                        break;
                    }
                    case 3: {
                        ServiceRecord.StartItem si = r.findDeliveredStart(startId, false);
                        if (si == null) break;
                        si.deliveryCount = 0;
                        ++si.doneExecutingCount;
                        r.stopIfKilled = true;
                        break;
                    }
                    case 1000: {
                        r.findDeliveredStart(startId, true);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown service start result: " + res);
                    }
                }
                if (res == 0) {
                    r.callStart = false;
                }
            } else if (type == 2) {
                if (!inDestroying) {
                    if (r.app != null) {
                        Slog.w("ActivityManager", "Service done with onDestroy, but not inDestroying: " + r + ", app=" + r.app);
                    }
                } else if (r.executeNesting != 1) {
                    Slog.w("ActivityManager", "Service done with onDestroy, but executeNesting=" + r.executeNesting + ": " + r);
                    r.executeNesting = 1;
                }
            }
            long origId = Binder.clearCallingIdentity();
            this.serviceDoneExecutingLocked(r, inDestroying, inDestroying);
            Binder.restoreCallingIdentity(origId);
        } else {
            Slog.w("ActivityManager", "Done executing unknown service from pid " + Binder.getCallingPid());
        }
    }

    private void serviceProcessGoneLocked(ServiceRecord r) {
        if (r.tracker != null) {
            int memFactor = this.mAm.mProcessStats.getMemFactorLocked();
            long now = SystemClock.uptimeMillis();
            r.tracker.setExecuting(false, memFactor, now);
            r.tracker.setBound(false, memFactor, now);
            r.tracker.setStarted(false, memFactor, now);
        }
        this.serviceDoneExecutingLocked(r, true, true);
    }

    private void serviceDoneExecutingLocked(ServiceRecord r, boolean inDestroying, boolean finishing) {
        --r.executeNesting;
        if (r.executeNesting <= 0) {
            if (r.app != null) {
                r.app.execServicesFg = false;
                r.app.executingServices.remove(r);
                if (r.app.executingServices.size() == 0) {
                    this.mAm.mHandler.removeMessages(12, r.app);
                } else if (r.executeFg) {
                    for (int i = r.app.executingServices.size() - 1; i >= 0; --i) {
                        if (!r.app.executingServices.valueAt((int)i).executeFg) continue;
                        r.app.execServicesFg = true;
                        break;
                    }
                }
                if (inDestroying) {
                    this.mDestroyingServices.remove(r);
                    r.bindings.clear();
                }
                this.mAm.updateOomAdjLocked(r.app);
            }
            r.executeFg = false;
            if (r.tracker != null) {
                r.tracker.setExecuting(false, this.mAm.mProcessStats.getMemFactorLocked(), SystemClock.uptimeMillis());
                if (finishing) {
                    r.tracker.clearCurrentOwner(r, false);
                    r.tracker = null;
                }
            }
            if (finishing) {
                if (r.app != null && !r.app.persistent) {
                    r.app.services.remove(r);
                    if (r.whitelistManager) {
                        this.updateWhitelistManagerLocked(r.app);
                    }
                }
                r.app = null;
            }
        }
    }

    boolean attachApplicationLocked(ProcessRecord proc, String processName) throws RemoteException {
        int i;
        ServiceRecord sr;
        boolean didSomething = false;
        if (this.mPendingServices.size() > 0) {
            sr = null;
            try {
                for (i = 0; i < this.mPendingServices.size(); ++i) {
                    sr = this.mPendingServices.get(i);
                    if (proc != sr.isolatedProc && (proc.uid != sr.appInfo.uid || !processName.equals(sr.processName))) continue;
                    this.mPendingServices.remove(i);
                    --i;
                    proc.addPackage(sr.appInfo.packageName, sr.appInfo.versionCode, this.mAm.mProcessStats);
                    this.realStartServiceLocked(sr, proc, sr.createdFromFg);
                    didSomething = true;
                    if (this.isServiceNeeded(sr, false, false)) continue;
                    this.bringDownServiceLocked(sr);
                }
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Exception in new application when starting service " + sr.shortName, e);
                throw e;
            }
        }
        if (this.mRestartingServices.size() > 0) {
            for (i = 0; i < this.mRestartingServices.size(); ++i) {
                sr = this.mRestartingServices.get(i);
                if (proc != sr.isolatedProc && (proc.uid != sr.appInfo.uid || !processName.equals(sr.processName))) continue;
                this.mAm.mHandler.removeCallbacks(sr.restarter);
                this.mAm.mHandler.post(sr.restarter);
            }
        }
        return didSomething;
    }

    void processStartTimedOutLocked(ProcessRecord proc) {
        for (int i = 0; i < this.mPendingServices.size(); ++i) {
            ServiceRecord sr = this.mPendingServices.get(i);
            if ((proc.uid != sr.appInfo.uid || !proc.processName.equals(sr.processName)) && sr.isolatedProc != proc) continue;
            Slog.w("ActivityManager", "Forcing bringing down service: " + sr);
            sr.isolatedProc = null;
            this.mPendingServices.remove(i);
            --i;
            this.bringDownServiceLocked(sr);
        }
    }

    private boolean collectPackageServicesLocked(String packageName, Set<String> filterByClasses, boolean evenPersistent, boolean doit, boolean killProcess, ArrayMap<ComponentName, ServiceRecord> services) {
        boolean didSomething = false;
        for (int i = services.size() - 1; i >= 0; --i) {
            boolean sameComponent;
            ServiceRecord service = services.valueAt(i);
            boolean bl = sameComponent = packageName == null || service.packageName.equals(packageName) && (filterByClasses == null || filterByClasses.contains(service.name.getClassName()));
            if (!sameComponent || service.app != null && !evenPersistent && service.app.persistent) continue;
            if (!doit) {
                return true;
            }
            didSomething = true;
            Slog.i("ActivityManager", "  Force stopping service " + service);
            if (service.app != null) {
                service.app.removed = killProcess;
                if (!service.app.persistent) {
                    service.app.services.remove(service);
                    if (service.whitelistManager) {
                        this.updateWhitelistManagerLocked(service.app);
                    }
                }
            }
            service.app = null;
            service.isolatedProc = null;
            if (this.mTmpCollectionResults == null) {
                this.mTmpCollectionResults = new ArrayList();
            }
            this.mTmpCollectionResults.add(service);
        }
        return didSomething;
    }

    boolean bringDownDisabledPackageServicesLocked(String packageName, Set<String> filterByClasses, int userId, boolean evenPersistent, boolean killProcess, boolean doit) {
        int i;
        boolean didSomething = false;
        if (this.mTmpCollectionResults != null) {
            this.mTmpCollectionResults.clear();
        }
        if (userId == -1) {
            for (i = this.mServiceMap.size() - 1; i >= 0; --i) {
                if (doit || !(didSomething |= this.collectPackageServicesLocked(packageName, filterByClasses, evenPersistent, doit, killProcess, this.mServiceMap.valueAt((int)i).mServicesByName))) continue;
                return true;
            }
        } else {
            ServiceMap smap = this.mServiceMap.get(userId);
            if (smap != null) {
                ArrayMap<ComponentName, ServiceRecord> items = smap.mServicesByName;
                didSomething = this.collectPackageServicesLocked(packageName, filterByClasses, evenPersistent, doit, killProcess, items);
            }
        }
        if (this.mTmpCollectionResults != null) {
            for (i = this.mTmpCollectionResults.size() - 1; i >= 0; --i) {
                this.bringDownServiceLocked(this.mTmpCollectionResults.get(i));
            }
            this.mTmpCollectionResults.clear();
        }
        return didSomething;
    }

    void cleanUpRemovedTaskLocked(TaskRecord tr, ComponentName component, Intent baseIntent) {
        ServiceRecord sr;
        int i;
        ArrayList<ServiceRecord> services = new ArrayList<ServiceRecord>();
        ArrayMap<ComponentName, ServiceRecord> alls = this.getServices(tr.userId);
        for (i = alls.size() - 1; i >= 0; --i) {
            sr = alls.valueAt(i);
            if (!sr.packageName.equals(component.getPackageName())) continue;
            services.add(sr);
        }
        for (i = services.size() - 1; i >= 0; --i) {
            sr = (ServiceRecord)services.get(i);
            if (!sr.startRequested) continue;
            if ((sr.serviceInfo.flags & 1) != 0) {
                Slog.i("ActivityManager", "Stopping service " + sr.shortName + ": remove task");
                this.stopServiceLocked(sr);
                continue;
            }
            sr.pendingStarts.add(new ServiceRecord.StartItem(sr, true, sr.makeNextStartId(), baseIntent, null));
            if (sr.app == null || sr.app.thread == null) continue;
            try {
                this.sendServiceArgsLocked(sr, true, false);
                continue;
            }
            catch (TransactionTooLargeException transactionTooLargeException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void killServicesLocked(ProcessRecord app, boolean allowRestart) {
        int i;
        int i2;
        for (i2 = app.connections.size() - 1; i2 >= 0; --i2) {
            ConnectionRecord r = app.connections.valueAt(i2);
            this.removeConnectionLocked(r, app, null);
        }
        this.updateServiceConnectionActivitiesLocked(app);
        app.connections.clear();
        app.whitelistManager = false;
        for (i2 = app.services.size() - 1; i2 >= 0; --i2) {
            ServiceRecord sr = app.services.valueAt(i2);
            BatteryStatsImpl batteryStatsImpl = sr.stats.getBatteryStats();
            synchronized (batteryStatsImpl) {
                sr.stats.stopLaunchedLocked();
            }
            if (sr.app != app && sr.app != null && !sr.app.persistent) {
                sr.app.services.remove(sr);
            }
            sr.app = null;
            sr.isolatedProc = null;
            sr.executeNesting = 0;
            sr.forceClearTracker();
            if (this.mDestroyingServices.remove(sr)) {
                // empty if block
            }
            int numClients = sr.bindings.size();
            for (int bindingi = numClients - 1; bindingi >= 0; --bindingi) {
                IntentBindRecord b = sr.bindings.valueAt(bindingi);
                b.binder = null;
                b.hasBound = false;
                b.received = false;
                b.requested = false;
                for (int appi = b.apps.size() - 1; appi >= 0; --appi) {
                    ProcessRecord proc = b.apps.keyAt(appi);
                    if (proc.killedByAm || proc.thread == null) continue;
                    AppBindRecord abind = b.apps.valueAt(appi);
                    boolean hasCreate = false;
                    for (int conni = abind.connections.size() - 1; conni >= 0; --conni) {
                        ConnectionRecord conn = abind.connections.valueAt(conni);
                        if ((conn.flags & 0x31) != 1) continue;
                        hasCreate = true;
                        break;
                    }
                    if (hasCreate) continue;
                }
            }
        }
        ServiceMap smap = this.getServiceMap(app.userId);
        for (i = app.services.size() - 1; i >= 0; --i) {
            ServiceRecord curRec;
            ServiceRecord sr = app.services.valueAt(i);
            if (!app.persistent) {
                app.services.removeAt(i);
            }
            if ((curRec = smap.mServicesByName.get(sr.name)) != sr) {
                if (curRec == null) continue;
                Slog.wtf("ActivityManager", "Service " + sr + " in process " + app + " not same as in map: " + curRec);
                continue;
            }
            if (allowRestart && sr.crashCount >= 2 && (sr.serviceInfo.applicationInfo.flags & 8) == 0) {
                Slog.w("ActivityManager", "Service crashed " + sr.crashCount + " times, stopping: " + sr);
                EventLog.writeEvent(30034, sr.userId, sr.crashCount, sr.shortName, app.pid);
                this.bringDownServiceLocked(sr);
                continue;
            }
            if (!allowRestart || !this.mAm.mUserController.isUserRunningLocked(sr.userId, 0)) {
                this.bringDownServiceLocked(sr);
                continue;
            }
            boolean canceled = this.scheduleServiceRestartLocked(sr, true);
            if (!sr.startRequested || !sr.stopIfKilled && !canceled || sr.pendingStarts.size() != 0) continue;
            sr.startRequested = false;
            if (sr.tracker != null) {
                sr.tracker.setStarted(false, this.mAm.mProcessStats.getMemFactorLocked(), SystemClock.uptimeMillis());
            }
            if (sr.hasAutoCreateConnections()) continue;
            this.bringDownServiceLocked(sr);
        }
        if (!allowRestart) {
            app.services.clear();
            for (i = this.mRestartingServices.size() - 1; i >= 0; --i) {
                ServiceRecord r = this.mRestartingServices.get(i);
                if (!r.processName.equals(app.processName) || r.serviceInfo.applicationInfo.uid != app.info.uid) continue;
                this.mRestartingServices.remove(i);
                this.clearRestartingIfNeededLocked(r);
            }
            for (i = this.mPendingServices.size() - 1; i >= 0; --i) {
                ServiceRecord r = this.mPendingServices.get(i);
                if (!r.processName.equals(app.processName) || r.serviceInfo.applicationInfo.uid != app.info.uid) continue;
                this.mPendingServices.remove(i);
            }
        }
        i = this.mDestroyingServices.size();
        while (i > 0) {
            ServiceRecord sr = this.mDestroyingServices.get(--i);
            if (sr.app != app) continue;
            sr.forceClearTracker();
            this.mDestroyingServices.remove(i);
        }
        app.executingServices.clear();
    }

    ActivityManager.RunningServiceInfo makeRunningServiceInfoLocked(ServiceRecord r) {
        ActivityManager.RunningServiceInfo info = new ActivityManager.RunningServiceInfo();
        info.service = r.name;
        if (r.app != null) {
            info.pid = r.app.pid;
        }
        info.uid = r.appInfo.uid;
        info.process = r.processName;
        info.foreground = r.isForeground;
        info.activeSince = r.createTime;
        info.started = r.startRequested;
        info.clientCount = r.connections.size();
        info.crashCount = r.crashCount;
        info.lastActivityTime = r.lastActivity;
        if (r.isForeground) {
            info.flags |= 2;
        }
        if (r.startRequested) {
            info.flags |= 1;
        }
        if (r.app != null && r.app.pid == ActivityManagerService.MY_PID) {
            info.flags |= 4;
        }
        if (r.app != null && r.app.persistent) {
            info.flags |= 8;
        }
        for (int conni = r.connections.size() - 1; conni >= 0; --conni) {
            ArrayList<ConnectionRecord> connl = r.connections.valueAt(conni);
            for (int i = 0; i < connl.size(); ++i) {
                ConnectionRecord conn = connl.get(i);
                if (conn.clientLabel == 0) continue;
                info.clientPackage = conn.binding.client.info.packageName;
                info.clientLabel = conn.clientLabel;
                return info;
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ActivityManager.RunningServiceInfo> getRunningServiceInfoLocked(int maxNum, int flags) {
        ArrayList<ActivityManager.RunningServiceInfo> res = new ArrayList<ActivityManager.RunningServiceInfo>();
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        try {
            if (ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", uid) == 0) {
                int[] users = this.mAm.mUserController.getUsers();
                for (int ui = 0; ui < users.length && res.size() < maxNum; ++ui) {
                    ArrayMap<ComponentName, ServiceRecord> alls = this.getServices(users[ui]);
                    for (int i = 0; i < alls.size() && res.size() < maxNum; ++i) {
                        ServiceRecord sr = alls.valueAt(i);
                        res.add(this.makeRunningServiceInfoLocked(sr));
                    }
                }
                for (int i = 0; i < this.mRestartingServices.size() && res.size() < maxNum; ++i) {
                    ServiceRecord r = this.mRestartingServices.get(i);
                    ActivityManager.RunningServiceInfo info = this.makeRunningServiceInfoLocked(r);
                    info.restarting = r.nextRestartTime;
                    res.add(info);
                }
            } else {
                int i;
                int userId = UserHandle.getUserId(uid);
                ArrayMap<ComponentName, ServiceRecord> alls = this.getServices(userId);
                for (i = 0; i < alls.size() && res.size() < maxNum; ++i) {
                    ServiceRecord sr = alls.valueAt(i);
                    res.add(this.makeRunningServiceInfoLocked(sr));
                }
                for (i = 0; i < this.mRestartingServices.size() && res.size() < maxNum; ++i) {
                    ServiceRecord r = this.mRestartingServices.get(i);
                    if (r.userId != userId) continue;
                    ActivityManager.RunningServiceInfo info = this.makeRunningServiceInfoLocked(r);
                    info.restarting = r.nextRestartTime;
                    res.add(info);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return res;
    }

    public PendingIntent getRunningServiceControlPanelLocked(ComponentName name) {
        int userId = UserHandle.getUserId(Binder.getCallingUid());
        ServiceRecord r = this.getServiceByName(name, userId);
        if (r != null) {
            for (int conni = r.connections.size() - 1; conni >= 0; --conni) {
                ArrayList<ConnectionRecord> conn = r.connections.valueAt(conni);
                for (int i = 0; i < conn.size(); ++i) {
                    if (conn.get((int)i).clientIntent == null) continue;
                    return conn.get((int)i).clientIntent;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serviceTimeout(ProcessRecord proc) {
        String anrMessage = null;
        ActivityManagerService activityManagerService = this.mAm;
        synchronized (activityManagerService) {
            if (proc.executingServices.size() == 0 || proc.thread == null) {
                return;
            }
            long now = SystemClock.uptimeMillis();
            long maxTime = now - (long)(proc.execServicesFg ? 20000 : 200000);
            ServiceRecord timeout = null;
            long nextTime = 0L;
            for (int i = proc.executingServices.size() - 1; i >= 0; --i) {
                ServiceRecord sr = proc.executingServices.valueAt(i);
                if (sr.executingStart < maxTime) {
                    timeout = sr;
                    break;
                }
                if (sr.executingStart <= nextTime) continue;
                nextTime = sr.executingStart;
            }
            if (timeout != null && this.mAm.mLruProcesses.contains(proc)) {
                Slog.w("ActivityManager", "Timeout executing service: " + timeout);
                StringWriter sw = new StringWriter();
                FastPrintWriter pw = new FastPrintWriter(sw, false, 1024);
                pw.println(timeout);
                timeout.dump(pw, "    ");
                ((PrintWriter)pw).close();
                this.mLastAnrDump = sw.toString();
                this.mAm.mHandler.removeCallbacks(this.mLastAnrDumpClearer);
                this.mAm.mHandler.postDelayed(this.mLastAnrDumpClearer, 0x6DDD00L);
                anrMessage = "executing service " + timeout.shortName;
            } else {
                Message msg = this.mAm.mHandler.obtainMessage(12);
                msg.obj = proc;
                this.mAm.mHandler.sendMessageAtTime(msg, proc.execServicesFg ? nextTime + 20000L : nextTime + 200000L);
            }
        }
        if (anrMessage != null) {
            this.mAm.mAppErrors.appNotResponding(proc, null, null, false, anrMessage);
        }
    }

    void scheduleServiceTimeoutLocked(ProcessRecord proc) {
        if (proc.executingServices.size() == 0 || proc.thread == null) {
            return;
        }
        long now = SystemClock.uptimeMillis();
        Message msg = this.mAm.mHandler.obtainMessage(12);
        msg.obj = proc;
        this.mAm.mHandler.sendMessageAtTime(msg, proc.execServicesFg ? now + 20000L : now + 200000L);
    }

    List<ServiceRecord> collectServicesToDumpLocked(ActivityManagerService.ItemMatcher matcher, String dumpPackage) {
        int[] users;
        ArrayList<ServiceRecord> services = new ArrayList<ServiceRecord>();
        for (int user : users = this.mAm.mUserController.getUsers()) {
            ServiceMap smap = this.getServiceMap(user);
            if (smap.mServicesByName.size() <= 0) continue;
            for (int si = 0; si < smap.mServicesByName.size(); ++si) {
                ServiceRecord r = smap.mServicesByName.valueAt(si);
                if (!matcher.match(r, r.name) || dumpPackage != null && !dumpPackage.equals(r.appInfo.packageName)) continue;
                services.add(r);
            }
        }
        return services;
    }

    ServiceDumper newServiceDumperLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        return new ServiceDumper(fd, pw, args, opti, dumpAll, dumpPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dumpService(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        ArrayList<ServiceRecord> services = new ArrayList<ServiceRecord>();
        ActivityManagerService activityManagerService = this.mAm;
        synchronized (activityManagerService) {
            int[] users = this.mAm.mUserController.getUsers();
            if ("all".equals(name)) {
                for (int user : users) {
                    ServiceMap smap = this.mServiceMap.get(user);
                    if (smap == null) continue;
                    ArrayMap<ComponentName, ServiceRecord> alls = smap.mServicesByName;
                    for (int i = 0; i < alls.size(); ++i) {
                        ServiceRecord r1 = alls.valueAt(i);
                        services.add(r1);
                    }
                }
            } else {
                ComponentName componentName = name != null ? ComponentName.unflattenFromString(name) : null;
                int objectId = 0;
                if (componentName == null) {
                    try {
                        objectId = Integer.parseInt(name, 16);
                        name = null;
                        componentName = null;
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                for (int user : users) {
                    ServiceMap smap = this.mServiceMap.get(user);
                    if (smap == null) continue;
                    ArrayMap<ComponentName, ServiceRecord> alls = smap.mServicesByName;
                    for (int i = 0; i < alls.size(); ++i) {
                        ServiceRecord r1 = alls.valueAt(i);
                        if (componentName != null) {
                            if (!r1.name.equals(componentName)) continue;
                            services.add(r1);
                            continue;
                        }
                        if (name != null) {
                            if (!r1.name.flattenToString().contains(name)) continue;
                            services.add(r1);
                            continue;
                        }
                        if (System.identityHashCode(r1) != objectId) continue;
                        services.add(r1);
                    }
                }
            }
        }
        if (services.size() <= 0) {
            return false;
        }
        boolean needSep = false;
        for (int i = 0; i < services.size(); ++i) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            this.dumpService("", fd, pw, (ServiceRecord)services.get(i), args, dumpAll);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpService(String prefix, FileDescriptor fd, PrintWriter pw, ServiceRecord r, String[] args, boolean dumpAll) {
        String innerPrefix = prefix + "  ";
        ActivityManagerService activityManagerService = this.mAm;
        synchronized (activityManagerService) {
            pw.print(prefix);
            pw.print("SERVICE ");
            pw.print(r.shortName);
            pw.print(" ");
            pw.print(Integer.toHexString(System.identityHashCode(r)));
            pw.print(" pid=");
            if (r.app != null) {
                pw.println(r.app.pid);
            } else {
                pw.println("(not running)");
            }
            if (dumpAll) {
                r.dump(pw, innerPrefix);
            }
        }
        if (r.app != null && r.app.thread != null) {
            pw.print(prefix);
            pw.println("  Client:");
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.thread.dumpService(tp.getWriteFd().getFileDescriptor(), r, args);
                    tp.setBufferPrefix(prefix + "    ");
                    tp.go(fd);
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println(prefix + "    Failure while dumping the service: " + e);
            }
            catch (RemoteException e) {
                pw.println(prefix + "    Got a RemoteException while dumping the service");
            }
        }
    }

    final class ServiceDumper {
        private final FileDescriptor fd;
        private final PrintWriter pw;
        private final String[] args;
        private final int opti;
        private final boolean dumpAll;
        private final String dumpPackage;
        private final ActivityManagerService.ItemMatcher matcher;
        private final ArrayList<ServiceRecord> services = new ArrayList();
        private final long nowReal = SystemClock.elapsedRealtime();
        private boolean needSep = false;
        private boolean printedAnything = false;
        private boolean printed = false;

        ServiceDumper(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
            int[] users;
            this.fd = fd;
            this.pw = pw;
            this.args = args;
            this.opti = opti;
            this.dumpAll = dumpAll;
            this.dumpPackage = dumpPackage;
            this.matcher = new ActivityManagerService.ItemMatcher();
            this.matcher.build(args, opti);
            for (int user : users = ActiveServices.this.mAm.mUserController.getUsers()) {
                ServiceMap smap = ActiveServices.this.getServiceMap(user);
                if (smap.mServicesByName.size() <= 0) continue;
                for (int si = 0; si < smap.mServicesByName.size(); ++si) {
                    ServiceRecord r = smap.mServicesByName.valueAt(si);
                    if (!this.matcher.match(r, r.name) || dumpPackage != null && !dumpPackage.equals(r.appInfo.packageName)) continue;
                    this.services.add(r);
                }
            }
        }

        private void dumpHeaderLocked() {
            this.pw.println("ACTIVITY MANAGER SERVICES (dumpsys activity services)");
            if (ActiveServices.this.mLastAnrDump != null) {
                this.pw.println("  Last ANR service:");
                this.pw.print(ActiveServices.this.mLastAnrDump);
                this.pw.println();
            }
        }

        void dumpLocked() {
            this.dumpHeaderLocked();
            try {
                int[] users;
                for (int user : users = ActiveServices.this.mAm.mUserController.getUsers()) {
                    int serviceIdx;
                    for (serviceIdx = 0; serviceIdx < this.services.size() && this.services.get((int)serviceIdx).userId != user; ++serviceIdx) {
                    }
                    this.printed = false;
                    if (serviceIdx < this.services.size()) {
                        this.needSep = false;
                        while (serviceIdx < this.services.size()) {
                            ServiceRecord r = this.services.get(serviceIdx);
                            ++serviceIdx;
                            if (r.userId != user) break;
                            this.dumpServiceLocalLocked(r);
                        }
                        this.needSep |= this.printed;
                    }
                    this.dumpUserRemainsLocked(user);
                }
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception in dumpServicesLocked", e);
            }
            this.dumpRemainsLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dumpWithClient() {
            ActivityManagerService activityManagerService = ActiveServices.this.mAm;
            synchronized (activityManagerService) {
                this.dumpHeaderLocked();
            }
            try {
                int[] users;
                for (int user : users = ActiveServices.this.mAm.mUserController.getUsers()) {
                    int serviceIdx;
                    for (serviceIdx = 0; serviceIdx < this.services.size() && this.services.get((int)serviceIdx).userId != user; ++serviceIdx) {
                    }
                    this.printed = false;
                    if (serviceIdx < this.services.size()) {
                        this.needSep = false;
                        while (serviceIdx < this.services.size()) {
                            ServiceRecord r = this.services.get(serviceIdx);
                            ++serviceIdx;
                            if (r.userId != user) break;
                            ActivityManagerService activityManagerService2 = ActiveServices.this.mAm;
                            synchronized (activityManagerService2) {
                                this.dumpServiceLocalLocked(r);
                            }
                            this.dumpServiceClient(r);
                        }
                        this.needSep |= this.printed;
                    }
                    ActivityManagerService activityManagerService3 = ActiveServices.this.mAm;
                    synchronized (activityManagerService3) {
                        this.dumpUserRemainsLocked(user);
                    }
                }
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception in dumpServicesLocked", e);
            }
            activityManagerService = ActiveServices.this.mAm;
            synchronized (activityManagerService) {
                this.dumpRemainsLocked();
            }
        }

        private void dumpUserHeaderLocked(int user) {
            if (!this.printed) {
                if (this.printedAnything) {
                    this.pw.println();
                }
                this.pw.println("  User " + user + " active services:");
                this.printed = true;
            }
            this.printedAnything = true;
            if (this.needSep) {
                this.pw.println();
            }
        }

        private void dumpServiceLocalLocked(ServiceRecord r) {
            this.dumpUserHeaderLocked(r.userId);
            this.pw.print("  * ");
            this.pw.println(r);
            if (this.dumpAll) {
                r.dump(this.pw, "    ");
                this.needSep = true;
            } else {
                this.pw.print("    app=");
                this.pw.println(r.app);
                this.pw.print("    created=");
                TimeUtils.formatDuration(r.createTime, this.nowReal, this.pw);
                this.pw.print(" started=");
                this.pw.print(r.startRequested);
                this.pw.print(" connections=");
                this.pw.println(r.connections.size());
                if (r.connections.size() > 0) {
                    this.pw.println("    Connections:");
                    for (int conni = 0; conni < r.connections.size(); ++conni) {
                        ArrayList<ConnectionRecord> clist = r.connections.valueAt(conni);
                        for (int i = 0; i < clist.size(); ++i) {
                            ConnectionRecord conn = clist.get(i);
                            this.pw.print("      ");
                            this.pw.print(conn.binding.intent.intent.getIntent().toShortString(false, false, false, false));
                            this.pw.print(" -> ");
                            ProcessRecord proc = conn.binding.client;
                            this.pw.println(proc != null ? proc.toShortString() : "null");
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dumpServiceClient(ServiceRecord r) {
            ProcessRecord proc = r.app;
            if (proc == null) {
                return;
            }
            IApplicationThread thread = proc.thread;
            if (thread == null) {
                return;
            }
            this.pw.println("    Client:");
            this.pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    thread.dumpService(tp.getWriteFd().getFileDescriptor(), r, this.args);
                    tp.setBufferPrefix("      ");
                    tp.go(this.fd, 2000L);
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                this.pw.println("      Failure while dumping the service: " + e);
            }
            catch (RemoteException e) {
                this.pw.println("      Got a RemoteException while dumping the service");
            }
            this.needSep = true;
        }

        private void dumpUserRemainsLocked(int user) {
            ServiceRecord r;
            int si;
            ServiceMap smap = ActiveServices.this.getServiceMap(user);
            this.printed = false;
            int SN = smap.mDelayedStartList.size();
            for (si = 0; si < SN; ++si) {
                r = smap.mDelayedStartList.get(si);
                if (!this.matcher.match(r, r.name) || this.dumpPackage != null && !this.dumpPackage.equals(r.appInfo.packageName)) continue;
                if (!this.printed) {
                    if (this.printedAnything) {
                        this.pw.println();
                    }
                    this.pw.println("  User " + user + " delayed start services:");
                    this.printed = true;
                }
                this.printedAnything = true;
                this.pw.print("  * Delayed start ");
                this.pw.println(r);
            }
            this.printed = false;
            SN = smap.mStartingBackground.size();
            for (si = 0; si < SN; ++si) {
                r = smap.mStartingBackground.get(si);
                if (!this.matcher.match(r, r.name) || this.dumpPackage != null && !this.dumpPackage.equals(r.appInfo.packageName)) continue;
                if (!this.printed) {
                    if (this.printedAnything) {
                        this.pw.println();
                    }
                    this.pw.println("  User " + user + " starting in background:");
                    this.printed = true;
                }
                this.printedAnything = true;
                this.pw.print("  * Starting bg ");
                this.pw.println(r);
            }
        }

        private void dumpRemainsLocked() {
            Object r;
            int i;
            if (ActiveServices.this.mPendingServices.size() > 0) {
                this.printed = false;
                for (i = 0; i < ActiveServices.this.mPendingServices.size(); ++i) {
                    r = ActiveServices.this.mPendingServices.get(i);
                    if (!this.matcher.match(r, ((ServiceRecord)r).name) || this.dumpPackage != null && !this.dumpPackage.equals(((ServiceRecord)r).appInfo.packageName)) continue;
                    this.printedAnything = true;
                    if (!this.printed) {
                        if (this.needSep) {
                            this.pw.println();
                        }
                        this.needSep = true;
                        this.pw.println("  Pending services:");
                        this.printed = true;
                    }
                    this.pw.print("  * Pending ");
                    this.pw.println(r);
                    ((ServiceRecord)r).dump(this.pw, "    ");
                }
                this.needSep = true;
            }
            if (ActiveServices.this.mRestartingServices.size() > 0) {
                this.printed = false;
                for (i = 0; i < ActiveServices.this.mRestartingServices.size(); ++i) {
                    r = ActiveServices.this.mRestartingServices.get(i);
                    if (!this.matcher.match(r, ((ServiceRecord)r).name) || this.dumpPackage != null && !this.dumpPackage.equals(((ServiceRecord)r).appInfo.packageName)) continue;
                    this.printedAnything = true;
                    if (!this.printed) {
                        if (this.needSep) {
                            this.pw.println();
                        }
                        this.needSep = true;
                        this.pw.println("  Restarting services:");
                        this.printed = true;
                    }
                    this.pw.print("  * Restarting ");
                    this.pw.println(r);
                    ((ServiceRecord)r).dump(this.pw, "    ");
                }
                this.needSep = true;
            }
            if (ActiveServices.this.mDestroyingServices.size() > 0) {
                this.printed = false;
                for (i = 0; i < ActiveServices.this.mDestroyingServices.size(); ++i) {
                    r = ActiveServices.this.mDestroyingServices.get(i);
                    if (!this.matcher.match(r, ((ServiceRecord)r).name) || this.dumpPackage != null && !this.dumpPackage.equals(((ServiceRecord)r).appInfo.packageName)) continue;
                    this.printedAnything = true;
                    if (!this.printed) {
                        if (this.needSep) {
                            this.pw.println();
                        }
                        this.needSep = true;
                        this.pw.println("  Destroying services:");
                        this.printed = true;
                    }
                    this.pw.print("  * Destroy ");
                    this.pw.println(r);
                    ((ServiceRecord)r).dump(this.pw, "    ");
                }
                this.needSep = true;
            }
            if (this.dumpAll) {
                this.printed = false;
                for (int ic = 0; ic < ActiveServices.this.mServiceConnections.size(); ++ic) {
                    r = ActiveServices.this.mServiceConnections.valueAt(ic);
                    for (int i2 = 0; i2 < ((ArrayList)r).size(); ++i2) {
                        ConnectionRecord cr = (ConnectionRecord)((ArrayList)r).get(i2);
                        if (!this.matcher.match(cr.binding.service, cr.binding.service.name) || this.dumpPackage != null && (cr.binding.client == null || !this.dumpPackage.equals(cr.binding.client.info.packageName))) continue;
                        this.printedAnything = true;
                        if (!this.printed) {
                            if (this.needSep) {
                                this.pw.println();
                            }
                            this.needSep = true;
                            this.pw.println("  Connection bindings to services:");
                            this.printed = true;
                        }
                        this.pw.print("  * ");
                        this.pw.println(cr);
                        cr.dump(this.pw, "    ");
                    }
                }
            }
            if (!this.printedAnything) {
                this.pw.println("  (nothing)");
            }
        }
    }

    private class ServiceRestarter
    implements Runnable {
        private ServiceRecord mService;

        private ServiceRestarter() {
        }

        void setService(ServiceRecord service) {
            this.mService = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ActivityManagerService activityManagerService = ActiveServices.this.mAm;
            synchronized (activityManagerService) {
                ActiveServices.this.performServiceRestartLocked(this.mService);
            }
        }
    }

    private final class ServiceLookupResult {
        final ServiceRecord record;
        final String permission;

        ServiceLookupResult(ServiceRecord _record, String _permission) {
            this.record = _record;
            this.permission = _permission;
        }
    }

    class ServiceMap
    extends Handler {
        final int mUserId;
        final ArrayMap<ComponentName, ServiceRecord> mServicesByName;
        final ArrayMap<Intent.FilterComparison, ServiceRecord> mServicesByIntent;
        final ArrayList<ServiceRecord> mDelayedStartList;
        final ArrayList<ServiceRecord> mStartingBackground;
        static final int MSG_BG_START_TIMEOUT = 1;

        ServiceMap(Looper looper, int userId) {
            super(looper);
            this.mServicesByName = new ArrayMap();
            this.mServicesByIntent = new ArrayMap();
            this.mDelayedStartList = new ArrayList();
            this.mStartingBackground = new ArrayList();
            this.mUserId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ActivityManagerService activityManagerService = ActiveServices.this.mAm;
                    synchronized (activityManagerService) {
                        this.rescheduleDelayedStarts();
                        break;
                    }
                }
            }
        }

        void ensureNotStartingBackground(ServiceRecord r) {
            if (this.mStartingBackground.remove(r)) {
                this.rescheduleDelayedStarts();
            }
            if (this.mDelayedStartList.remove(r)) {
                // empty if block
            }
        }

        void rescheduleDelayedStarts() {
            this.removeMessages(1);
            long now = SystemClock.uptimeMillis();
            int N2 = this.mStartingBackground.size();
            for (int i = 0; i < N2; ++i) {
                ServiceRecord r = this.mStartingBackground.get(i);
                if (r.startingBgTimeout > now) continue;
                Slog.i("ActivityManager", "Waited long enough for: " + r);
                this.mStartingBackground.remove(i);
                --N2;
                --i;
            }
            while (this.mDelayedStartList.size() > 0 && this.mStartingBackground.size() < ActiveServices.this.mMaxStartingBackground) {
                ServiceRecord r = this.mDelayedStartList.remove(0);
                if (r.pendingStarts.size() <= 0) {
                    Slog.w("ActivityManager", "**** NO PENDING STARTS! " + r + " startReq=" + r.startRequested + " delayedStop=" + r.delayedStop);
                }
                r.delayed = false;
                try {
                    ActiveServices.this.startServiceInnerLocked(this, r.pendingStarts.get((int)0).intent, r, false, true);
                }
                catch (TransactionTooLargeException N2) {}
            }
            if (this.mStartingBackground.size() > 0) {
                ServiceRecord next = this.mStartingBackground.get(0);
                long when = next.startingBgTimeout > now ? next.startingBgTimeout : now;
                Message msg = this.obtainMessage(1);
                this.sendMessageAtTime(msg, when);
            }
            if (this.mStartingBackground.size() < ActiveServices.this.mMaxStartingBackground) {
                ActiveServices.this.mAm.backgroundServicesFinishedLocked(this.mUserId);
            }
        }
    }
}

