/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.util.ProgressReporter;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.EventLogTags;
import java.util.List;

public abstract class PreBootBroadcaster
extends IIntentReceiver.Stub {
    private static final String TAG = "PreBootBroadcaster";
    private final ActivityManagerService mService;
    private final int mUserId;
    private final ProgressReporter mProgress;
    private final Intent mIntent;
    private final List<ResolveInfo> mTargets;
    private int mIndex = 0;

    public PreBootBroadcaster(ActivityManagerService service, int userId, ProgressReporter progress) {
        this.mService = service;
        this.mUserId = userId;
        this.mProgress = progress;
        this.mIntent = new Intent("android.intent.action.PRE_BOOT_COMPLETED");
        this.mIntent.addFlags(0x2000100);
        this.mTargets = this.mService.mContext.getPackageManager().queryBroadcastReceiversAsUser(this.mIntent, 0x100000, UserHandle.of(userId));
    }

    public void sendNext() {
        if (this.mIndex >= this.mTargets.size()) {
            this.onFinished();
            return;
        }
        if (!this.mService.isUserRunning(this.mUserId, 0)) {
            Slog.i(TAG, "User " + this.mUserId + " is no longer running; skipping remaining receivers");
            this.onFinished();
            return;
        }
        ResolveInfo ri = this.mTargets.get(this.mIndex++);
        ComponentName componentName = ri.activityInfo.getComponentName();
        if (this.mProgress != null) {
            CharSequence label = ri.activityInfo.loadLabel(this.mService.mContext.getPackageManager());
            this.mProgress.setProgress(this.mIndex, this.mTargets.size(), this.mService.mContext.getString(17040301, label));
        }
        Slog.i(TAG, "Pre-boot of " + componentName.toShortString() + " for user " + this.mUserId);
        EventLogTags.writeAmPreBoot(this.mUserId, componentName.getPackageName());
        this.mIntent.setComponent(componentName);
        this.mService.broadcastIntentLocked(null, null, this.mIntent, null, this, 0, null, null, null, -1, null, true, false, ActivityManagerService.MY_PID, 1000, this.mUserId);
    }

    @Override
    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
        this.sendNext();
    }

    public abstract void onFinished();
}

