/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.graphics.Rect;
import android.os.Handler;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityStackSupervisor;

class ResizeDockedStackTimeout {
    private static final long TIMEOUT_MS = 10000L;
    private final ActivityManagerService mService;
    private final ActivityStackSupervisor mSupervisor;
    private final Handler mHandler;
    private final Rect mCurrentDockedBounds = new Rect();
    private final Runnable mTimeoutRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ActivityManagerService activityManagerService = ResizeDockedStackTimeout.this.mService;
            synchronized (activityManagerService) {
                ResizeDockedStackTimeout.this.mSupervisor.resizeDockedStackLocked(ResizeDockedStackTimeout.this.mCurrentDockedBounds, null, null, null, null, true);
            }
        }
    };

    ResizeDockedStackTimeout(ActivityManagerService service, ActivityStackSupervisor supervisor, Handler handler) {
        this.mService = service;
        this.mSupervisor = supervisor;
        this.mHandler = handler;
    }

    void notifyResizing(Rect dockedBounds, boolean hasTempBounds) {
        this.mHandler.removeCallbacks(this.mTimeoutRunnable);
        if (!hasTempBounds) {
            return;
        }
        this.mCurrentDockedBounds.set(dockedBounds);
        this.mHandler.postDelayed(this.mTimeoutRunnable, 10000L);
    }
}

