/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.net.NetworkUtils;
import android.net.util.IpUtils;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.HexDump;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.connectivity.KeepalivePacketData;
import com.android.server.connectivity.NetworkAgentInfo;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;

public class KeepaliveTracker {
    private static final String TAG = "KeepaliveTracker";
    private static final boolean DBG = false;
    public static final String PERMISSION = "android.permission.PACKET_KEEPALIVE_OFFLOAD";
    private final HashMap<NetworkAgentInfo, HashMap<Integer, KeepaliveInfo>> mKeepalives = new HashMap();
    private final Handler mConnectivityServiceHandler;

    public KeepaliveTracker(Handler handler) {
        this.mConnectivityServiceHandler = handler;
    }

    void notifyMessenger(Messenger messenger, int slot, int err) {
        Message message = Message.obtain();
        message.what = 528397;
        message.arg1 = slot;
        message.arg2 = err;
        message.obj = null;
        try {
            messenger.send(message);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private int findFirstFreeSlot(NetworkAgentInfo nai) {
        int slot;
        HashMap<Integer, KeepaliveInfo> networkKeepalives = this.mKeepalives.get(nai);
        if (networkKeepalives == null) {
            networkKeepalives = new HashMap();
            this.mKeepalives.put(nai, networkKeepalives);
        }
        for (slot = 1; slot <= networkKeepalives.size(); ++slot) {
            if (networkKeepalives.get(slot) != null) continue;
            return slot;
        }
        return slot;
    }

    public void handleStartKeepalive(Message message) {
        KeepaliveInfo ki = (KeepaliveInfo)message.obj;
        NetworkAgentInfo nai = ki.getNai();
        int slot = this.findFirstFreeSlot(nai);
        this.mKeepalives.get(nai).put(slot, ki);
        ki.start(slot);
    }

    public void handleStopAllKeepalives(NetworkAgentInfo nai, int reason) {
        HashMap<Integer, KeepaliveInfo> networkKeepalives = this.mKeepalives.get(nai);
        if (networkKeepalives != null) {
            for (KeepaliveInfo ki : networkKeepalives.values()) {
                ki.stop(reason);
            }
            networkKeepalives.clear();
            this.mKeepalives.remove(nai);
        }
    }

    public void handleStopKeepalive(NetworkAgentInfo nai, int slot, int reason) {
        String networkName = nai == null ? "(null)" : nai.name();
        HashMap<Integer, KeepaliveInfo> networkKeepalives = this.mKeepalives.get(nai);
        if (networkKeepalives == null) {
            Log.e(TAG, "Attempt to stop keepalive on nonexistent network " + networkName);
            return;
        }
        KeepaliveInfo ki = networkKeepalives.get(slot);
        if (ki == null) {
            Log.e(TAG, "Attempt to stop nonexistent keepalive " + slot + " on " + networkName);
            return;
        }
        ki.stop(reason);
        networkKeepalives.remove(slot);
        if (networkKeepalives.isEmpty()) {
            this.mKeepalives.remove(nai);
        }
    }

    public void handleCheckKeepalivesStillValid(NetworkAgentInfo nai) {
        HashMap<Integer, KeepaliveInfo> networkKeepalives = this.mKeepalives.get(nai);
        if (networkKeepalives != null) {
            ArrayList<Pair<Integer, Integer>> invalidKeepalives = new ArrayList<Pair<Integer, Integer>>();
            for (int n : networkKeepalives.keySet()) {
                int error = networkKeepalives.get(n).isValid();
                if (error == 0) continue;
                invalidKeepalives.add(Pair.create(n, error));
            }
            for (Pair pair : invalidKeepalives) {
                this.handleStopKeepalive(nai, (Integer)pair.first, (Integer)pair.second);
            }
        }
    }

    public void handleEventPacketKeepalive(NetworkAgentInfo nai, Message message) {
        int slot = message.arg1;
        int reason = message.arg2;
        KeepaliveInfo ki = null;
        try {
            ki = this.mKeepalives.get(nai).get(slot);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (ki == null) {
            Log.e(TAG, "Event for unknown keepalive " + slot + " on " + nai.name());
            return;
        }
        if (reason == 0 && !ki.isStarted) {
            ki.isStarted = true;
            ki.notifyMessenger(slot, reason);
        } else {
            ki.isStarted = false;
            if (reason == 0) {
                // empty if block
            }
            this.handleStopKeepalive(nai, slot, reason);
        }
    }

    public void startNattKeepalive(NetworkAgentInfo nai, int intervalSeconds, Messenger messenger, IBinder binder, String srcAddrString, int srcPort, String dstAddrString, int dstPort) {
        KeepalivePacketData packet;
        InetAddress dstAddress;
        InetAddress srcAddress;
        if (nai == null) {
            this.notifyMessenger(messenger, -1, -20);
            return;
        }
        try {
            srcAddress = NetworkUtils.numericToInetAddress(srcAddrString);
            dstAddress = NetworkUtils.numericToInetAddress(dstAddrString);
        }
        catch (IllegalArgumentException e) {
            this.notifyMessenger(messenger, -1, -21);
            return;
        }
        try {
            packet = KeepalivePacketData.nattKeepalivePacket(srcAddress, srcPort, dstAddress, 4500);
        }
        catch (KeepalivePacketData.InvalidPacketException e) {
            this.notifyMessenger(messenger, -1, e.error);
            return;
        }
        KeepaliveInfo ki = new KeepaliveInfo(messenger, binder, nai, packet, intervalSeconds);
        Log.d(TAG, "Created keepalive: " + ki.toString());
        this.mConnectivityServiceHandler.obtainMessage(528395, ki).sendToTarget();
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("Packet keepalives:");
        pw.increaseIndent();
        for (NetworkAgentInfo nai : this.mKeepalives.keySet()) {
            pw.println(nai.name());
            pw.increaseIndent();
            for (int slot : this.mKeepalives.get(nai).keySet()) {
                KeepaliveInfo ki = this.mKeepalives.get(nai).get(slot);
                pw.println(slot + ": " + ki.toString());
            }
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
    }

    class KeepaliveInfo
    implements IBinder.DeathRecipient {
        private final Messenger mMessenger;
        private final IBinder mBinder;
        private final int mUid;
        private final int mPid;
        private final NetworkAgentInfo mNai;
        private int mSlot = -1;
        private final KeepalivePacketData mPacket;
        private final int mInterval;
        public boolean isStarted;

        public KeepaliveInfo(Messenger messenger, IBinder binder, NetworkAgentInfo nai, KeepalivePacketData packet, int interval) {
            this.mMessenger = messenger;
            this.mBinder = binder;
            this.mPid = Binder.getCallingPid();
            this.mUid = Binder.getCallingUid();
            this.mNai = nai;
            this.mPacket = packet;
            this.mInterval = interval;
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        public NetworkAgentInfo getNai() {
            return this.mNai;
        }

        public String toString() {
            return new StringBuffer("KeepaliveInfo [").append(" network=").append(this.mNai.network).append(" isStarted=").append(this.isStarted).append(" ").append(IpUtils.addressAndPortToString(this.mPacket.srcAddress, this.mPacket.srcPort)).append("->").append(IpUtils.addressAndPortToString(this.mPacket.dstAddress, this.mPacket.dstPort)).append(" interval=" + this.mInterval).append(" data=" + HexDump.toHexString(this.mPacket.data)).append(" uid=").append(this.mUid).append(" pid=").append(this.mPid).append(" ]").toString();
        }

        void notifyMessenger(int slot, int err) {
            KeepaliveTracker.this.notifyMessenger(this.mMessenger, slot, err);
        }

        @Override
        public void binderDied() {
            KeepaliveTracker.this.mConnectivityServiceHandler.obtainMessage(528396, this.mSlot, -10, this.mNai.network).sendToTarget();
        }

        void unlinkDeathRecipient() {
            if (this.mBinder != null) {
                this.mBinder.unlinkToDeath(this, 0);
            }
        }

        private int checkNetworkConnected() {
            if (!this.mNai.networkInfo.isConnectedOrConnecting()) {
                return -20;
            }
            return 0;
        }

        private int checkSourceAddress() {
            for (InetAddress address : this.mNai.linkProperties.getAddresses()) {
                if (!address.equals(this.mPacket.srcAddress)) continue;
                return 0;
            }
            return -21;
        }

        private int checkInterval() {
            return this.mInterval >= 20 ? 0 : -24;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int isValid() {
            NetworkAgentInfo networkAgentInfo = this.mNai;
            synchronized (networkAgentInfo) {
                int error = this.checkInterval();
                if (error == 0) {
                    error = this.checkNetworkConnected();
                }
                if (error == 0) {
                    error = this.checkSourceAddress();
                }
                return error;
            }
        }

        void start(int slot) {
            int error = this.isValid();
            if (error != 0) {
                this.notifyMessenger(-1, error);
                return;
            }
            this.mSlot = slot;
            Log.d(KeepaliveTracker.TAG, "Starting keepalive " + this.mSlot + " on " + this.mNai.name());
            this.mNai.asyncChannel.sendMessage(528395, slot, this.mInterval, this.mPacket);
        }

        void stop(int reason) {
            int uid = Binder.getCallingUid();
            if (uid == this.mUid || uid != 1000) {
                // empty if block
            }
            if (this.isStarted) {
                Log.d(KeepaliveTracker.TAG, "Stopping keepalive " + this.mSlot + " on " + this.mNai.name());
                this.mNai.asyncChannel.sendMessage(528396, this.mSlot);
            }
            this.notifyMessenger(this.mSlot, reason);
            this.unlinkDeathRecipient();
        }
    }
}

