/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.display.DisplayManagerInternal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.util.MathUtils;
import android.util.Slog;
import android.util.Spline;
import android.util.TimeUtils;
import android.view.WindowManagerPolicy;
import com.android.internal.app.IBatteryStats;
import com.android.server.LocalServices;
import com.android.server.am.BatteryStatsService;
import com.android.server.display.AutomaticBrightnessController;
import com.android.server.display.ColorFade;
import com.android.server.display.DisplayBlanker;
import com.android.server.display.DisplayPowerState;
import com.android.server.display.RampAnimator;
import java.io.PrintWriter;

final class DisplayPowerController
implements AutomaticBrightnessController.Callbacks {
    private static final String TAG = "DisplayPowerController";
    private static final String SCREEN_ON_BLOCKED_TRACE_NAME = "Screen on blocked";
    private static boolean DEBUG = false;
    private static final boolean DEBUG_PRETEND_PROXIMITY_SENSOR_ABSENT = false;
    private static final boolean USE_COLOR_FADE_ON_ANIMATION = false;
    private static final int SCREEN_DIM_MINIMUM_REDUCTION = 10;
    private static final int COLOR_FADE_ON_ANIMATION_DURATION_MILLIS = 250;
    private static final int COLOR_FADE_OFF_ANIMATION_DURATION_MILLIS = 400;
    private static final int MSG_UPDATE_POWER_STATE = 1;
    private static final int MSG_PROXIMITY_SENSOR_DEBOUNCED = 2;
    private static final int MSG_SCREEN_ON_UNBLOCKED = 3;
    private static final int PROXIMITY_UNKNOWN = -1;
    private static final int PROXIMITY_NEGATIVE = 0;
    private static final int PROXIMITY_POSITIVE = 1;
    private static final int PROXIMITY_SENSOR_POSITIVE_DEBOUNCE_DELAY = 0;
    private static final int PROXIMITY_SENSOR_NEGATIVE_DEBOUNCE_DELAY = 250;
    private static final float TYPICAL_PROXIMITY_THRESHOLD = 5.0f;
    private static final int BRIGHTNESS_RAMP_RATE_SLOW = 40;
    private static final int REPORTED_TO_POLICY_SCREEN_OFF = 0;
    private static final int REPORTED_TO_POLICY_SCREEN_TURNING_ON = 1;
    private static final int REPORTED_TO_POLICY_SCREEN_ON = 2;
    private final Object mLock = new Object();
    private final Context mContext;
    private final DisplayControllerHandler mHandler;
    private final DisplayManagerInternal.DisplayPowerCallbacks mCallbacks;
    private final IBatteryStats mBatteryStats;
    private final SensorManager mSensorManager;
    private final WindowManagerPolicy mWindowManagerPolicy;
    private final DisplayBlanker mBlanker;
    private Sensor mProximitySensor;
    private final int mScreenBrightnessDozeConfig;
    private final int mScreenBrightnessDimConfig;
    private final int mScreenBrightnessDarkConfig;
    private final int mScreenBrightnessRangeMinimum;
    private final int mScreenBrightnessRangeMaximum;
    private boolean mUseSoftwareAutoBrightnessConfig;
    private final boolean mAllowAutoBrightnessWhileDozingConfig;
    private boolean mColorFadeFadesConfig;
    private DisplayManagerInternal.DisplayPowerRequest mPendingRequestLocked;
    private boolean mPendingWaitForNegativeProximityLocked;
    private boolean mPendingRequestChangedLocked;
    private boolean mDisplayReadyLocked;
    private boolean mPendingUpdatePowerStateLocked;
    private DisplayManagerInternal.DisplayPowerRequest mPowerRequest;
    private DisplayPowerState mPowerState;
    private boolean mWaitingForNegativeProximity;
    private float mProximityThreshold;
    private boolean mProximitySensorEnabled;
    private int mProximity = -1;
    private int mPendingProximity = -1;
    private long mPendingProximityDebounceTime = -1L;
    private boolean mScreenOffBecauseOfProximity;
    private ScreenOnUnblocker mPendingScreenOnUnblocker;
    private boolean mPendingScreenOff;
    private boolean mUnfinishedBusiness;
    private long mScreenOnBlockStartRealTime;
    private int mReportedScreenStateToPolicy;
    private boolean mAppliedAutoBrightness;
    private boolean mAppliedDimming;
    private boolean mAppliedLowPower;
    private final int mBrightnessRampRateFast;
    private AutomaticBrightnessController mAutomaticBrightnessController;
    private ObjectAnimator mColorFadeOnAnimator;
    private ObjectAnimator mColorFadeOffAnimator;
    private RampAnimator<DisplayPowerState> mScreenBrightnessRampAnimator;
    private final Animator.AnimatorListener mAnimatorListener = new Animator.AnimatorListener(){

        @Override
        public void onAnimationStart(Animator animation) {
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            DisplayPowerController.this.sendUpdatePowerState();
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
        }

        @Override
        public void onAnimationCancel(Animator animation) {
        }
    };
    private final RampAnimator.Listener mRampAnimatorListener = new RampAnimator.Listener(){

        @Override
        public void onAnimationEnd() {
            DisplayPowerController.this.sendUpdatePowerState();
        }
    };
    private final Runnable mCleanListener = new Runnable(){

        @Override
        public void run() {
            DisplayPowerController.this.sendUpdatePowerState();
        }
    };
    private final Runnable mOnStateChangedRunnable = new Runnable(){

        @Override
        public void run() {
            DisplayPowerController.this.mCallbacks.onStateChanged();
            DisplayPowerController.this.mCallbacks.releaseSuspendBlocker();
        }
    };
    private final Runnable mOnProximityPositiveRunnable = new Runnable(){

        @Override
        public void run() {
            DisplayPowerController.this.mCallbacks.onProximityPositive();
            DisplayPowerController.this.mCallbacks.releaseSuspendBlocker();
        }
    };
    private final Runnable mOnProximityNegativeRunnable = new Runnable(){

        @Override
        public void run() {
            DisplayPowerController.this.mCallbacks.onProximityNegative();
            DisplayPowerController.this.mCallbacks.releaseSuspendBlocker();
        }
    };
    private final SensorEventListener mProximitySensorListener = new SensorEventListener(){

        @Override
        public void onSensorChanged(SensorEvent event) {
            if (DisplayPowerController.this.mProximitySensorEnabled) {
                long time = SystemClock.uptimeMillis();
                float distance = event.values[0];
                boolean positive = distance >= 0.0f && distance < DisplayPowerController.this.mProximityThreshold;
                DisplayPowerController.this.handleProximitySensorEvent(time, positive);
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    public DisplayPowerController(Context context, DisplayManagerInternal.DisplayPowerCallbacks callbacks, Handler handler, SensorManager sensorManager, DisplayBlanker blanker) {
        this.mHandler = new DisplayControllerHandler(handler.getLooper());
        this.mCallbacks = callbacks;
        this.mBatteryStats = BatteryStatsService.getService();
        this.mSensorManager = sensorManager;
        this.mWindowManagerPolicy = LocalServices.getService(WindowManagerPolicy.class);
        this.mBlanker = blanker;
        this.mContext = context;
        Resources resources = context.getResources();
        int screenBrightnessSettingMinimum = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694812));
        this.mScreenBrightnessDozeConfig = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694815));
        this.mScreenBrightnessDimConfig = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694820));
        this.mScreenBrightnessDarkConfig = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694821));
        if (this.mScreenBrightnessDarkConfig > this.mScreenBrightnessDimConfig) {
            Slog.w(TAG, "Expected config_screenBrightnessDark (" + this.mScreenBrightnessDarkConfig + ") to be less than or equal to config_screenBrightnessDim (" + this.mScreenBrightnessDimConfig + ").");
        }
        if (this.mScreenBrightnessDarkConfig > this.mScreenBrightnessDimConfig) {
            Slog.w(TAG, "Expected config_screenBrightnessDark (" + this.mScreenBrightnessDarkConfig + ") to be less than or equal to config_screenBrightnessSettingMinimum (" + screenBrightnessSettingMinimum + ").");
        }
        int screenBrightnessRangeMinimum = Math.min(Math.min(screenBrightnessSettingMinimum, this.mScreenBrightnessDimConfig), this.mScreenBrightnessDarkConfig);
        this.mScreenBrightnessRangeMaximum = 255;
        this.mUseSoftwareAutoBrightnessConfig = resources.getBoolean(0x1120021);
        this.mAllowAutoBrightnessWhileDozingConfig = resources.getBoolean(17956938);
        this.mBrightnessRampRateFast = resources.getInteger(17694781);
        int lightSensorRate = resources.getInteger(17694818);
        long brighteningLightDebounce = resources.getInteger(17694816);
        long darkeningLightDebounce = resources.getInteger(17694817);
        boolean autoBrightnessResetAmbientLuxAfterWarmUp = resources.getBoolean(17956939);
        int ambientLightHorizon = resources.getInteger(17694819);
        float autoBrightnessAdjustmentMaxGamma = resources.getFraction(0x1130001, 1, 1);
        if (this.mUseSoftwareAutoBrightnessConfig) {
            int[] lux = resources.getIntArray(17236007);
            int[] screenBrightness = resources.getIntArray(17236008);
            int lightSensorWarmUpTimeConfig = resources.getInteger(17694822);
            float dozeScaleFactor = resources.getFraction(18022402, 1, 1);
            Spline screenAutoBrightnessSpline = DisplayPowerController.createAutoBrightnessSpline(lux, screenBrightness);
            if (screenAutoBrightnessSpline == null) {
                Slog.e(TAG, "Error in config.xml.  config_autoBrightnessLcdBacklightValues (size " + screenBrightness.length + ") must be monotic and have exactly one more entry than config_autoBrightnessLevels (size " + lux.length + ") which must be strictly increasing.  Auto-brightness will be disabled.");
                this.mUseSoftwareAutoBrightnessConfig = false;
            } else {
                int bottom = DisplayPowerController.clampAbsoluteBrightness(screenBrightness[0]);
                if (this.mScreenBrightnessDarkConfig > bottom) {
                    Slog.w(TAG, "config_screenBrightnessDark (" + this.mScreenBrightnessDarkConfig + ") should be less than or equal to the first value of config_autoBrightnessLcdBacklightValues (" + bottom + ").");
                }
                if (bottom < screenBrightnessRangeMinimum) {
                    screenBrightnessRangeMinimum = bottom;
                }
                this.mAutomaticBrightnessController = new AutomaticBrightnessController(this, handler.getLooper(), sensorManager, screenAutoBrightnessSpline, lightSensorWarmUpTimeConfig, screenBrightnessRangeMinimum, this.mScreenBrightnessRangeMaximum, dozeScaleFactor, lightSensorRate, brighteningLightDebounce, darkeningLightDebounce, autoBrightnessResetAmbientLuxAfterWarmUp, ambientLightHorizon, autoBrightnessAdjustmentMaxGamma);
            }
        }
        this.mScreenBrightnessRangeMinimum = screenBrightnessRangeMinimum;
        this.mColorFadeFadesConfig = resources.getBoolean(17956902);
        this.mProximitySensor = this.mSensorManager.getDefaultSensor(8);
        if (this.mProximitySensor != null) {
            this.mProximityThreshold = Math.min(this.mProximitySensor.getMaximumRange(), 5.0f);
        }
    }

    public boolean isProximitySensorAvailable() {
        return this.mProximitySensor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestPowerState(DisplayManagerInternal.DisplayPowerRequest request, boolean waitForNegativeProximity) {
        if (DEBUG) {
            Slog.d(TAG, "requestPowerState: " + request + ", waitForNegativeProximity=" + waitForNegativeProximity);
        }
        Object object = this.mLock;
        synchronized (object) {
            boolean changed = false;
            if (waitForNegativeProximity && !this.mPendingWaitForNegativeProximityLocked) {
                this.mPendingWaitForNegativeProximityLocked = true;
                changed = true;
            }
            if (this.mPendingRequestLocked == null) {
                this.mPendingRequestLocked = new DisplayManagerInternal.DisplayPowerRequest(request);
                changed = true;
            } else if (!this.mPendingRequestLocked.equals(request)) {
                this.mPendingRequestLocked.copyFrom(request);
                changed = true;
            }
            if (changed) {
                this.mDisplayReadyLocked = false;
            }
            if (changed && !this.mPendingRequestChangedLocked) {
                this.mPendingRequestChangedLocked = true;
                this.sendUpdatePowerStateLocked();
            }
            return this.mDisplayReadyLocked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUpdatePowerState() {
        Object object = this.mLock;
        synchronized (object) {
            this.sendUpdatePowerStateLocked();
        }
    }

    private void sendUpdatePowerStateLocked() {
        if (!this.mPendingUpdatePowerStateLocked) {
            this.mPendingUpdatePowerStateLocked = true;
            Message msg = this.mHandler.obtainMessage(1);
            msg.setAsynchronous(true);
            this.mHandler.sendMessage(msg);
        }
    }

    private void initialize() {
        this.mPowerState = new DisplayPowerState(this.mBlanker, new ColorFade(0));
        this.mColorFadeOnAnimator = ObjectAnimator.ofFloat(this.mPowerState, DisplayPowerState.COLOR_FADE_LEVEL, 0.0f, 1.0f);
        this.mColorFadeOnAnimator.setDuration(250L);
        this.mColorFadeOnAnimator.addListener(this.mAnimatorListener);
        this.mColorFadeOffAnimator = ObjectAnimator.ofFloat(this.mPowerState, DisplayPowerState.COLOR_FADE_LEVEL, 1.0f, 0.0f);
        this.mColorFadeOffAnimator.setDuration(400L);
        this.mColorFadeOffAnimator.addListener(this.mAnimatorListener);
        this.mScreenBrightnessRampAnimator = new RampAnimator<DisplayPowerState>(this.mPowerState, DisplayPowerState.SCREEN_BRIGHTNESS);
        this.mScreenBrightnessRampAnimator.setListener(this.mRampAnimatorListener);
        try {
            this.mBatteryStats.noteScreenState(this.mPowerState.getScreenState());
            this.mBatteryStats.noteScreenBrightness(this.mPowerState.getScreenBrightness());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePowerState() {
        boolean finished;
        int state;
        boolean mustNotify;
        boolean mustInitialize = false;
        boolean autoBrightnessAdjustmentChanged = false;
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingUpdatePowerStateLocked = false;
            if (this.mPendingRequestLocked == null) {
                return;
            }
            if (this.mPowerRequest == null) {
                this.mPowerRequest = new DisplayManagerInternal.DisplayPowerRequest(this.mPendingRequestLocked);
                this.mWaitingForNegativeProximity = this.mPendingWaitForNegativeProximityLocked;
                this.mPendingWaitForNegativeProximityLocked = false;
                this.mPendingRequestChangedLocked = false;
                mustInitialize = true;
            } else if (this.mPendingRequestChangedLocked) {
                autoBrightnessAdjustmentChanged = this.mPowerRequest.screenAutoBrightnessAdjustment != this.mPendingRequestLocked.screenAutoBrightnessAdjustment;
                this.mPowerRequest.copyFrom(this.mPendingRequestLocked);
                this.mWaitingForNegativeProximity |= this.mPendingWaitForNegativeProximityLocked;
                this.mPendingWaitForNegativeProximityLocked = false;
                this.mPendingRequestChangedLocked = false;
                this.mDisplayReadyLocked = false;
            }
            mustNotify = !this.mDisplayReadyLocked;
        }
        if (mustInitialize) {
            this.initialize();
        }
        int brightness = -1;
        boolean performScreenOffTransition = false;
        switch (this.mPowerRequest.policy) {
            case 0: {
                state = 1;
                performScreenOffTransition = true;
                break;
            }
            case 1: {
                state = this.mPowerRequest.dozeScreenState != 0 ? this.mPowerRequest.dozeScreenState : 3;
                if (this.mAllowAutoBrightnessWhileDozingConfig) break;
                brightness = this.mPowerRequest.dozeScreenBrightness;
                break;
            }
            default: {
                state = 2;
            }
        }
        assert (state != 0);
        if (this.mProximitySensor != null) {
            if (this.mPowerRequest.useProximitySensor && state != 1) {
                this.setProximitySensorEnabled(true);
                if (!this.mScreenOffBecauseOfProximity && this.mProximity == 1) {
                    this.mScreenOffBecauseOfProximity = true;
                    this.sendOnProximityPositiveWithWakelock();
                }
            } else if (this.mWaitingForNegativeProximity && this.mScreenOffBecauseOfProximity && this.mProximity == 1 && state != 1) {
                this.setProximitySensorEnabled(true);
            } else {
                this.setProximitySensorEnabled(false);
                this.mWaitingForNegativeProximity = false;
            }
            if (this.mScreenOffBecauseOfProximity && this.mProximity != 1) {
                this.mScreenOffBecauseOfProximity = false;
                this.sendOnProximityNegativeWithWakelock();
            }
        } else {
            this.mWaitingForNegativeProximity = false;
        }
        if (this.mScreenOffBecauseOfProximity) {
            state = 1;
        }
        this.animateScreenStateChange(state, performScreenOffTransition);
        state = this.mPowerState.getScreenState();
        if (state == 1) {
            brightness = 0;
        }
        boolean autoBrightnessEnabled = false;
        if (this.mAutomaticBrightnessController != null) {
            boolean autoBrightnessEnabledInDoze = this.mAllowAutoBrightnessWhileDozingConfig && (state == 3 || state == 4);
            autoBrightnessEnabled = this.mPowerRequest.useAutoBrightness && (state == 2 || autoBrightnessEnabledInDoze) && brightness < 0;
            boolean userInitiatedChange = autoBrightnessAdjustmentChanged && this.mPowerRequest.brightnessSetByUser;
            this.mAutomaticBrightnessController.configure(autoBrightnessEnabled, this.mPowerRequest.screenAutoBrightnessAdjustment, state != 2, userInitiatedChange, this.mPowerRequest.useTwilight);
        }
        if (this.mPowerRequest.boostScreenBrightness && brightness != 0) {
            brightness = 255;
        }
        boolean slowChange = false;
        if (brightness < 0) {
            if (autoBrightnessEnabled) {
                brightness = this.mAutomaticBrightnessController.getAutomaticScreenBrightness();
            }
            if (brightness >= 0) {
                brightness = this.clampScreenBrightness(brightness);
                if (this.mAppliedAutoBrightness && !autoBrightnessAdjustmentChanged) {
                    slowChange = true;
                }
                this.mAppliedAutoBrightness = true;
            } else {
                this.mAppliedAutoBrightness = false;
            }
        } else {
            this.mAppliedAutoBrightness = false;
        }
        if (brightness < 0 && (state == 3 || state == 4)) {
            brightness = this.mScreenBrightnessDozeConfig;
        }
        if (brightness < 0) {
            brightness = this.clampScreenBrightness(this.mPowerRequest.screenBrightness);
        }
        if (this.mPowerRequest.policy == 2) {
            if (brightness > this.mScreenBrightnessRangeMinimum) {
                brightness = Math.max(Math.min(brightness - 10, this.mScreenBrightnessDimConfig), this.mScreenBrightnessRangeMinimum);
            }
            if (!this.mAppliedDimming) {
                slowChange = false;
            }
            this.mAppliedDimming = true;
        } else if (this.mAppliedDimming) {
            slowChange = false;
            this.mAppliedDimming = false;
        }
        if (this.mPowerRequest.lowPowerMode) {
            if (brightness > this.mScreenBrightnessRangeMinimum) {
                brightness = Math.max(brightness / 2, this.mScreenBrightnessRangeMinimum);
            }
            if (!this.mAppliedLowPower) {
                slowChange = false;
            }
            this.mAppliedLowPower = true;
        } else if (this.mAppliedLowPower) {
            slowChange = false;
            this.mAppliedLowPower = false;
        }
        if (!this.mPendingScreenOff) {
            if (state == 2 || state == 3) {
                this.animateScreenBrightness(brightness, slowChange ? 40 : this.mBrightnessRampRateFast);
            } else {
                this.animateScreenBrightness(brightness, 0);
            }
        }
        boolean ready = this.mPendingScreenOnUnblocker == null && !this.mColorFadeOnAnimator.isStarted() && !this.mColorFadeOffAnimator.isStarted() && this.mPowerState.waitUntilClean(this.mCleanListener);
        boolean bl = finished = ready && !this.mScreenBrightnessRampAnimator.isAnimating();
        if (ready && state != 1 && this.mReportedScreenStateToPolicy == 1) {
            this.mReportedScreenStateToPolicy = 2;
            this.mWindowManagerPolicy.screenTurnedOn();
        }
        if (!finished && !this.mUnfinishedBusiness) {
            if (DEBUG) {
                Slog.d(TAG, "Unfinished business...");
            }
            this.mCallbacks.acquireSuspendBlocker();
            this.mUnfinishedBusiness = true;
        }
        if (ready && mustNotify) {
            Object object2 = this.mLock;
            synchronized (object2) {
                if (!this.mPendingRequestChangedLocked) {
                    this.mDisplayReadyLocked = true;
                    if (DEBUG) {
                        Slog.d(TAG, "Display ready!");
                    }
                }
            }
            this.sendOnStateChangedWithWakelock();
        }
        if (finished && this.mUnfinishedBusiness) {
            if (DEBUG) {
                Slog.d(TAG, "Finished business...");
            }
            this.mUnfinishedBusiness = false;
            this.mCallbacks.releaseSuspendBlocker();
        }
    }

    @Override
    public void updateBrightness() {
        this.sendUpdatePowerState();
    }

    private void blockScreenOn() {
        if (this.mPendingScreenOnUnblocker == null) {
            Trace.asyncTraceBegin(131072L, SCREEN_ON_BLOCKED_TRACE_NAME, 0);
            this.mPendingScreenOnUnblocker = new ScreenOnUnblocker();
            this.mScreenOnBlockStartRealTime = SystemClock.elapsedRealtime();
            Slog.i(TAG, "Blocking screen on until initial contents have been drawn.");
        }
    }

    private void unblockScreenOn() {
        if (this.mPendingScreenOnUnblocker != null) {
            this.mPendingScreenOnUnblocker = null;
            long delay = SystemClock.elapsedRealtime() - this.mScreenOnBlockStartRealTime;
            Slog.i(TAG, "Unblocked screen on after " + delay + " ms");
            Trace.asyncTraceEnd(131072L, SCREEN_ON_BLOCKED_TRACE_NAME, 0);
        }
    }

    private boolean setScreenState(int state) {
        boolean isOff;
        if (this.mPowerState.getScreenState() != state) {
            boolean wasOn = this.mPowerState.getScreenState() != 1;
            this.mPowerState.setScreenState(state);
            try {
                this.mBatteryStats.noteScreenState(state);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        boolean bl = isOff = state == 1;
        if (isOff && this.mReportedScreenStateToPolicy != 0 && !this.mScreenOffBecauseOfProximity) {
            this.mReportedScreenStateToPolicy = 0;
            this.unblockScreenOn();
            this.mWindowManagerPolicy.screenTurnedOff();
        } else if (!isOff && this.mReportedScreenStateToPolicy == 0) {
            this.mReportedScreenStateToPolicy = 1;
            if (this.mPowerState.getColorFadeLevel() == 0.0f) {
                this.blockScreenOn();
            } else {
                this.unblockScreenOn();
            }
            this.mWindowManagerPolicy.screenTurningOn(this.mPendingScreenOnUnblocker);
        }
        return this.mPendingScreenOnUnblocker == null;
    }

    private int clampScreenBrightness(int value) {
        return MathUtils.constrain(value, this.mScreenBrightnessRangeMinimum, this.mScreenBrightnessRangeMaximum);
    }

    private void animateScreenBrightness(int target, int rate) {
        if (DEBUG) {
            Slog.d(TAG, "Animating brightness: target=" + target + ", rate=" + rate);
        }
        if (this.mScreenBrightnessRampAnimator.animateTo(target, rate)) {
            try {
                this.mBatteryStats.noteScreenBrightness(target);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void animateScreenStateChange(int target, boolean performScreenOffTransition) {
        if (this.mColorFadeOnAnimator.isStarted() || this.mColorFadeOffAnimator.isStarted()) {
            if (target != 2) {
                return;
            }
            this.mPendingScreenOff = false;
        }
        if (this.mPendingScreenOff && target != 1) {
            this.setScreenState(1);
            this.mPendingScreenOff = false;
            this.mPowerState.dismissColorFadeResources();
        }
        if (target == 2) {
            if (!this.setScreenState(2)) {
                return;
            }
            this.mPowerState.setColorFadeLevel(1.0f);
            this.mPowerState.dismissColorFade();
        } else if (target == 3) {
            if (this.mScreenBrightnessRampAnimator.isAnimating() && this.mPowerState.getScreenState() == 2) {
                return;
            }
            if (!this.setScreenState(3)) {
                return;
            }
            this.mPowerState.setColorFadeLevel(1.0f);
            this.mPowerState.dismissColorFade();
        } else if (target == 4) {
            if (this.mScreenBrightnessRampAnimator.isAnimating() && this.mPowerState.getScreenState() != 4) {
                return;
            }
            if (this.mPowerState.getScreenState() != 4) {
                if (!this.setScreenState(3)) {
                    return;
                }
                this.setScreenState(4);
            }
            this.mPowerState.setColorFadeLevel(1.0f);
            this.mPowerState.dismissColorFade();
        } else {
            this.mPendingScreenOff = true;
            if (this.mPowerState.getColorFadeLevel() == 0.0f) {
                this.setScreenState(1);
                this.mPendingScreenOff = false;
                this.mPowerState.dismissColorFadeResources();
            } else if (performScreenOffTransition && this.mPowerState.prepareColorFade(this.mContext, this.mColorFadeFadesConfig ? 2 : 1) && this.mPowerState.getScreenState() != 1) {
                this.mColorFadeOffAnimator.start();
            } else {
                this.mColorFadeOffAnimator.end();
            }
        }
    }

    private void setProximitySensorEnabled(boolean enable) {
        if (enable) {
            if (!this.mProximitySensorEnabled) {
                this.mProximitySensorEnabled = true;
                this.mSensorManager.registerListener(this.mProximitySensorListener, this.mProximitySensor, 3, this.mHandler);
            }
        } else if (this.mProximitySensorEnabled) {
            this.mProximitySensorEnabled = false;
            this.mProximity = -1;
            this.mPendingProximity = -1;
            this.mHandler.removeMessages(2);
            this.mSensorManager.unregisterListener(this.mProximitySensorListener);
            this.clearPendingProximityDebounceTime();
        }
    }

    private void handleProximitySensorEvent(long time, boolean positive) {
        if (this.mProximitySensorEnabled) {
            if (this.mPendingProximity == 0 && !positive) {
                return;
            }
            if (this.mPendingProximity == 1 && positive) {
                return;
            }
            this.mHandler.removeMessages(2);
            if (positive) {
                this.mPendingProximity = 1;
                this.setPendingProximityDebounceTime(time + 0L);
            } else {
                this.mPendingProximity = 0;
                this.setPendingProximityDebounceTime(time + 250L);
            }
            this.debounceProximitySensor();
        }
    }

    private void debounceProximitySensor() {
        if (this.mProximitySensorEnabled && this.mPendingProximity != -1 && this.mPendingProximityDebounceTime >= 0L) {
            long now = SystemClock.uptimeMillis();
            if (this.mPendingProximityDebounceTime <= now) {
                this.mProximity = this.mPendingProximity;
                this.updatePowerState();
                this.clearPendingProximityDebounceTime();
            } else {
                Message msg = this.mHandler.obtainMessage(2);
                msg.setAsynchronous(true);
                this.mHandler.sendMessageAtTime(msg, this.mPendingProximityDebounceTime);
            }
        }
    }

    private void clearPendingProximityDebounceTime() {
        if (this.mPendingProximityDebounceTime >= 0L) {
            this.mPendingProximityDebounceTime = -1L;
            this.mCallbacks.releaseSuspendBlocker();
        }
    }

    private void setPendingProximityDebounceTime(long debounceTime) {
        if (this.mPendingProximityDebounceTime < 0L) {
            this.mCallbacks.acquireSuspendBlocker();
        }
        this.mPendingProximityDebounceTime = debounceTime;
    }

    private void sendOnStateChangedWithWakelock() {
        this.mCallbacks.acquireSuspendBlocker();
        this.mHandler.post(this.mOnStateChangedRunnable);
    }

    private void sendOnProximityPositiveWithWakelock() {
        this.mCallbacks.acquireSuspendBlocker();
        this.mHandler.post(this.mOnProximityPositiveRunnable);
    }

    private void sendOnProximityNegativeWithWakelock() {
        this.mCallbacks.acquireSuspendBlocker();
        this.mHandler.post(this.mOnProximityNegativeRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(final PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println();
            pw.println("Display Power Controller Locked State:");
            pw.println("  mDisplayReadyLocked=" + this.mDisplayReadyLocked);
            pw.println("  mPendingRequestLocked=" + this.mPendingRequestLocked);
            pw.println("  mPendingRequestChangedLocked=" + this.mPendingRequestChangedLocked);
            pw.println("  mPendingWaitForNegativeProximityLocked=" + this.mPendingWaitForNegativeProximityLocked);
            pw.println("  mPendingUpdatePowerStateLocked=" + this.mPendingUpdatePowerStateLocked);
        }
        pw.println();
        pw.println("Display Power Controller Configuration:");
        pw.println("  mScreenBrightnessDozeConfig=" + this.mScreenBrightnessDozeConfig);
        pw.println("  mScreenBrightnessDimConfig=" + this.mScreenBrightnessDimConfig);
        pw.println("  mScreenBrightnessDarkConfig=" + this.mScreenBrightnessDarkConfig);
        pw.println("  mScreenBrightnessRangeMinimum=" + this.mScreenBrightnessRangeMinimum);
        pw.println("  mScreenBrightnessRangeMaximum=" + this.mScreenBrightnessRangeMaximum);
        pw.println("  mUseSoftwareAutoBrightnessConfig=" + this.mUseSoftwareAutoBrightnessConfig);
        pw.println("  mAllowAutoBrightnessWhileDozingConfig=" + this.mAllowAutoBrightnessWhileDozingConfig);
        pw.println("  mColorFadeFadesConfig=" + this.mColorFadeFadesConfig);
        this.mHandler.runWithScissors(new Runnable(){

            @Override
            public void run() {
                DisplayPowerController.this.dumpLocal(pw);
            }
        }, 1000L);
    }

    private void dumpLocal(PrintWriter pw) {
        pw.println();
        pw.println("Display Power Controller Thread State:");
        pw.println("  mPowerRequest=" + this.mPowerRequest);
        pw.println("  mWaitingForNegativeProximity=" + this.mWaitingForNegativeProximity);
        pw.println("  mProximitySensor=" + this.mProximitySensor);
        pw.println("  mProximitySensorEnabled=" + this.mProximitySensorEnabled);
        pw.println("  mProximityThreshold=" + this.mProximityThreshold);
        pw.println("  mProximity=" + DisplayPowerController.proximityToString(this.mProximity));
        pw.println("  mPendingProximity=" + DisplayPowerController.proximityToString(this.mPendingProximity));
        pw.println("  mPendingProximityDebounceTime=" + TimeUtils.formatUptime(this.mPendingProximityDebounceTime));
        pw.println("  mScreenOffBecauseOfProximity=" + this.mScreenOffBecauseOfProximity);
        pw.println("  mAppliedAutoBrightness=" + this.mAppliedAutoBrightness);
        pw.println("  mAppliedDimming=" + this.mAppliedDimming);
        pw.println("  mAppliedLowPower=" + this.mAppliedLowPower);
        pw.println("  mPendingScreenOnUnblocker=" + this.mPendingScreenOnUnblocker);
        pw.println("  mPendingScreenOff=" + this.mPendingScreenOff);
        pw.println("  mReportedToPolicy=" + DisplayPowerController.reportedToPolicyToString(this.mReportedScreenStateToPolicy));
        pw.println("  mScreenBrightnessRampAnimator.isAnimating()=" + this.mScreenBrightnessRampAnimator.isAnimating());
        if (this.mColorFadeOnAnimator != null) {
            pw.println("  mColorFadeOnAnimator.isStarted()=" + this.mColorFadeOnAnimator.isStarted());
        }
        if (this.mColorFadeOffAnimator != null) {
            pw.println("  mColorFadeOffAnimator.isStarted()=" + this.mColorFadeOffAnimator.isStarted());
        }
        if (this.mPowerState != null) {
            this.mPowerState.dump(pw);
        }
        if (this.mAutomaticBrightnessController != null) {
            this.mAutomaticBrightnessController.dump(pw);
        }
    }

    private static String proximityToString(int state) {
        switch (state) {
            case -1: {
                return "Unknown";
            }
            case 0: {
                return "Negative";
            }
            case 1: {
                return "Positive";
            }
        }
        return Integer.toString(state);
    }

    private static String reportedToPolicyToString(int state) {
        switch (state) {
            case 0: {
                return "REPORTED_TO_POLICY_SCREEN_OFF";
            }
            case 1: {
                return "REPORTED_TO_POLICY_SCREEN_TURNING_ON";
            }
            case 2: {
                return "REPORTED_TO_POLICY_SCREEN_ON";
            }
        }
        return Integer.toString(state);
    }

    private static Spline createAutoBrightnessSpline(int[] lux, int[] brightness) {
        try {
            int n = brightness.length;
            float[] x = new float[n];
            float[] y = new float[n];
            y[0] = DisplayPowerController.normalizeAbsoluteBrightness(brightness[0]);
            for (int i = 1; i < n; ++i) {
                x[i] = lux[i - 1];
                y[i] = DisplayPowerController.normalizeAbsoluteBrightness(brightness[i]);
            }
            Spline spline = Spline.createSpline(x, y);
            if (DEBUG) {
                Slog.d(TAG, "Auto-brightness spline: " + spline);
                for (float v = 1.0f; v < (float)lux[lux.length - 1] * 1.25f; v *= 1.25f) {
                    Slog.d(TAG, String.format("  %7.1f: %7.1f", Float.valueOf(v), Float.valueOf(spline.interpolate(v))));
                }
            }
            return spline;
        }
        catch (IllegalArgumentException ex) {
            Slog.e(TAG, "Could not create auto-brightness spline.", ex);
            return null;
        }
    }

    private static float normalizeAbsoluteBrightness(int value) {
        return (float)DisplayPowerController.clampAbsoluteBrightness(value) / 255.0f;
    }

    private static int clampAbsoluteBrightness(int value) {
        return MathUtils.constrain(value, 0, 255);
    }

    private final class ScreenOnUnblocker
    implements WindowManagerPolicy.ScreenOnListener {
        private ScreenOnUnblocker() {
        }

        @Override
        public void onScreenOn() {
            Message msg = DisplayPowerController.this.mHandler.obtainMessage(3, this);
            msg.setAsynchronous(true);
            DisplayPowerController.this.mHandler.sendMessage(msg);
        }
    }

    private final class DisplayControllerHandler
    extends Handler {
        public DisplayControllerHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DisplayPowerController.this.updatePowerState();
                    break;
                }
                case 2: {
                    DisplayPowerController.this.debounceProximitySensor();
                    break;
                }
                case 3: {
                    if (DisplayPowerController.this.mPendingScreenOnUnblocker != msg.obj) break;
                    DisplayPowerController.this.unblockScreenOn();
                    DisplayPowerController.this.updatePowerState();
                }
            }
        }
    }
}

