/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.content.Context;
import android.hardware.fingerprint.IFingerprintDaemon;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.fingerprint.ClientMonitor;

public abstract class EnumerateClient
extends ClientMonitor {
    public EnumerateClient(Context context, long halDeviceId, IBinder token, IFingerprintServiceReceiver receiver, int userId, int groupId, boolean restricted, String owner) {
        super(context, halDeviceId, token, receiver, userId, groupId, restricted, owner);
    }

    @Override
    public int start() {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        try {
            int result = daemon.enumerate();
            if (result != 0) {
                Slog.w("FingerprintService", "start enumerate for user " + this.getTargetUserId() + " failed, result=" + result);
                this.onError(1);
                return result;
            }
        }
        catch (RemoteException e) {
            Slog.e("FingerprintService", "startRemove failed", e);
        }
        return 0;
    }

    @Override
    public int stop(boolean initiatedByClient) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w("FingerprintService", "stopAuthentication: no fingeprintd!");
            return 3;
        }
        try {
            int result = daemon.cancelEnumeration();
            if (result != 0) {
                Slog.w("FingerprintService", "stop enumeration failed, result=" + result);
                return result;
            }
        }
        catch (RemoteException e) {
            Slog.e("FingerprintService", "stop enumeration failed", e);
            return 3;
        }
        if (initiatedByClient) {
            this.onError(5);
        }
        return 0;
    }

    @Override
    public boolean onEnumerationResult(int fingerId, int groupId) {
        IFingerprintServiceReceiver receiver = this.getReceiver();
        if (receiver == null) {
            return true;
        }
        try {
            receiver.onRemoved(this.getHalDeviceId(), fingerId, groupId);
        }
        catch (RemoteException e) {
            Slog.w("FingerprintService", "Failed to notify enumerated:", e);
        }
        return fingerId == 0;
    }
}

