/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Pair;
import android.util.Slog;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecLocalDevicePlayback;
import com.android.server.hdmi.HdmiCecLocalDeviceTv;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageCache;
import com.android.server.hdmi.HdmiControlService;
import java.util.ArrayList;
import java.util.List;

abstract class HdmiCecFeatureAction {
    private static final String TAG = "HdmiCecFeatureAction";
    protected static final int MSG_TIMEOUT = 100;
    protected static final int STATE_NONE = 0;
    protected int mState = 0;
    private final HdmiControlService mService;
    private final HdmiCecLocalDevice mSource;
    protected ActionTimer mActionTimer;
    private ArrayList<Pair<HdmiCecFeatureAction, Runnable>> mOnFinishedCallbacks;

    HdmiCecFeatureAction(HdmiCecLocalDevice source) {
        this.mSource = source;
        this.mService = this.mSource.getService();
        this.mActionTimer = this.createActionTimer(this.mService.getServiceLooper());
    }

    void setActionTimer(ActionTimer actionTimer) {
        this.mActionTimer = actionTimer;
    }

    abstract boolean start();

    abstract boolean processCommand(HdmiCecMessage var1);

    abstract void handleTimerEvent(int var1);

    private ActionTimer createActionTimer(Looper looper) {
        return new ActionTimerHandler(looper);
    }

    protected void addTimer(int state, int delayMillis) {
        this.mActionTimer.sendTimerMessage(state, delayMillis);
    }

    boolean started() {
        return this.mState != 0;
    }

    protected final void sendCommand(HdmiCecMessage cmd) {
        this.mService.sendCecCommand(cmd);
    }

    protected final void sendCommand(HdmiCecMessage cmd, HdmiControlService.SendMessageCallback callback) {
        this.mService.sendCecCommand(cmd, callback);
    }

    protected final void addAndStartAction(HdmiCecFeatureAction action) {
        this.mSource.addAndStartAction(action);
    }

    protected final <T extends HdmiCecFeatureAction> List<T> getActions(Class<T> clazz) {
        return this.mSource.getActions(clazz);
    }

    protected final HdmiCecMessageCache getCecMessageCache() {
        return this.mSource.getCecMessageCache();
    }

    protected final void removeAction(HdmiCecFeatureAction action) {
        this.mSource.removeAction(action);
    }

    protected final <T extends HdmiCecFeatureAction> void removeAction(Class<T> clazz) {
        this.mSource.removeActionExcept(clazz, null);
    }

    protected final <T extends HdmiCecFeatureAction> void removeActionExcept(Class<T> clazz, HdmiCecFeatureAction exception) {
        this.mSource.removeActionExcept(clazz, exception);
    }

    protected final void pollDevices(HdmiControlService.DevicePollingCallback callback, int pickStrategy, int retryCount) {
        this.mService.pollDevices(callback, this.getSourceAddress(), pickStrategy, retryCount);
    }

    void clear() {
        this.mState = 0;
        this.mActionTimer.clearTimerMessage();
    }

    protected void finish() {
        this.finish(true);
    }

    void finish(boolean removeSelf) {
        this.clear();
        if (removeSelf) {
            this.removeAction(this);
        }
        if (this.mOnFinishedCallbacks != null) {
            for (Pair<HdmiCecFeatureAction, Runnable> actionCallbackPair : this.mOnFinishedCallbacks) {
                if (((HdmiCecFeatureAction)actionCallbackPair.first).mState == 0) continue;
                ((Runnable)actionCallbackPair.second).run();
            }
            this.mOnFinishedCallbacks = null;
        }
    }

    protected final HdmiCecLocalDevice localDevice() {
        return this.mSource;
    }

    protected final HdmiCecLocalDevicePlayback playback() {
        return (HdmiCecLocalDevicePlayback)this.mSource;
    }

    protected final HdmiCecLocalDeviceTv tv() {
        return (HdmiCecLocalDeviceTv)this.mSource;
    }

    protected final int getSourceAddress() {
        return this.mSource.getDeviceInfo().getLogicalAddress();
    }

    protected final int getSourcePath() {
        return this.mSource.getDeviceInfo().getPhysicalAddress();
    }

    protected final void sendUserControlPressedAndReleased(int targetAddress, int uiCommand) {
        this.mSource.sendUserControlPressedAndReleased(targetAddress, uiCommand);
    }

    protected final void addOnFinishedCallback(HdmiCecFeatureAction action, Runnable runnable) {
        if (this.mOnFinishedCallbacks == null) {
            this.mOnFinishedCallbacks = new ArrayList();
        }
        this.mOnFinishedCallbacks.add(Pair.create(action, runnable));
    }

    private class ActionTimerHandler
    extends Handler
    implements ActionTimer {
        public ActionTimerHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void sendTimerMessage(int state, long delayMillis) {
            this.sendMessageDelayed(this.obtainMessage(100, state, 0), delayMillis);
        }

        @Override
        public void clearTimerMessage() {
            this.removeMessages(100);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    HdmiCecFeatureAction.this.handleTimerEvent(msg.arg1);
                    break;
                }
                default: {
                    Slog.w(HdmiCecFeatureAction.TAG, "Unsupported message:" + msg.what);
                }
            }
        }
    }

    static interface ActionTimer {
        public void sendTimerMessage(int var1, long var2);

        public void clearTimerMessage();
    }
}

