/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job;

import android.app.job.JobInfo;
import android.content.ComponentName;
import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.os.PersistableBundle;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.format.DateUtils;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.IoThread;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class JobStore {
    private static final String TAG = "JobStore";
    private static final boolean DEBUG = false;
    private static final int MAX_OPS_BEFORE_WRITE = 1;
    final Object mLock;
    final JobSet mJobSet;
    final Context mContext;
    private int mDirtyOperations;
    private static final Object sSingletonLock = new Object();
    private final AtomicFile mJobsFile;
    private final Handler mIoHandler = IoThread.getHandler();
    private static JobStore sSingleton;
    private static final int JOBS_FILE_VERSION = 0;
    private static final String XML_TAG_PARAMS_CONSTRAINTS = "constraints";
    private static final String XML_TAG_PERIODIC = "periodic";
    private static final String XML_TAG_ONEOFF = "one-off";
    private static final String XML_TAG_EXTRAS = "extras";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JobStore initAndGet(JobSchedulerService jobManagerService) {
        Object object = sSingletonLock;
        synchronized (object) {
            if (sSingleton == null) {
                sSingleton = new JobStore(jobManagerService.getContext(), jobManagerService.getLock(), Environment.getDataDirectory());
            }
            return sSingleton;
        }
    }

    public static JobStore initAndGetForTesting(Context context, File dataDir) {
        JobStore jobStoreUnderTest = new JobStore(context, new Object(), dataDir);
        jobStoreUnderTest.clear();
        return jobStoreUnderTest;
    }

    private JobStore(Context context, Object lock, File dataDir) {
        this.mLock = lock;
        this.mContext = context;
        this.mDirtyOperations = 0;
        File systemDir = new File(dataDir, "system");
        File jobDir = new File(systemDir, "job");
        jobDir.mkdirs();
        this.mJobsFile = new AtomicFile(new File(jobDir, "jobs.xml"));
        this.mJobSet = new JobSet();
        this.readJobMapFromDisk(this.mJobSet);
    }

    public boolean add(JobStatus jobStatus) {
        boolean replaced = this.mJobSet.remove(jobStatus);
        this.mJobSet.add(jobStatus);
        if (jobStatus.isPersisted()) {
            this.maybeWriteStatusToDiskAsync();
        }
        return replaced;
    }

    boolean containsJob(JobStatus jobStatus) {
        return this.mJobSet.contains(jobStatus);
    }

    public int size() {
        return this.mJobSet.size();
    }

    public int countJobsForUid(int uid) {
        return this.mJobSet.countJobsForUid(uid);
    }

    public boolean remove(JobStatus jobStatus, boolean writeBack) {
        boolean removed = this.mJobSet.remove(jobStatus);
        if (!removed) {
            return false;
        }
        if (writeBack && jobStatus.isPersisted()) {
            this.maybeWriteStatusToDiskAsync();
        }
        return removed;
    }

    public void clear() {
        this.mJobSet.clear();
        this.maybeWriteStatusToDiskAsync();
    }

    public List<JobStatus> getJobsByUser(int userHandle) {
        return this.mJobSet.getJobsByUser(userHandle);
    }

    public List<JobStatus> getJobsByUid(int uid) {
        return this.mJobSet.getJobsByUid(uid);
    }

    public JobStatus getJobByUidAndJobId(int uid, int jobId) {
        return this.mJobSet.get(uid, jobId);
    }

    public void forEachJob(JobStatusFunctor functor) {
        this.mJobSet.forEachJob(functor);
    }

    public void forEachJob(int uid, JobStatusFunctor functor) {
        this.mJobSet.forEachJob(uid, functor);
    }

    private void maybeWriteStatusToDiskAsync() {
        ++this.mDirtyOperations;
        if (this.mDirtyOperations >= 1) {
            this.mIoHandler.post(new WriteJobsMapToDiskRunnable());
        }
    }

    public void readJobMapFromDisk(JobSet jobSet) {
        new ReadJobMapFromDiskRunnable(jobSet).run();
    }

    static class JobSet {
        private SparseArray<ArraySet<JobStatus>> mJobs = new SparseArray();

        public List<JobStatus> getJobsByUid(int uid) {
            ArrayList<JobStatus> matchingJobs = new ArrayList<JobStatus>();
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            if (jobs != null) {
                matchingJobs.addAll(jobs);
            }
            return matchingJobs;
        }

        public List<JobStatus> getJobsByUser(int userId) {
            ArrayList<JobStatus> result = new ArrayList<JobStatus>();
            for (int i = this.mJobs.size() - 1; i >= 0; --i) {
                ArraySet<JobStatus> jobs;
                if (UserHandle.getUserId(this.mJobs.keyAt(i)) != userId || (jobs = this.mJobs.get(i)) == null) continue;
                result.addAll(jobs);
            }
            return result;
        }

        public boolean add(JobStatus job) {
            int uid = job.getUid();
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            if (jobs == null) {
                jobs = new ArraySet();
                this.mJobs.put(uid, jobs);
            }
            return jobs.add(job);
        }

        public boolean remove(JobStatus job) {
            boolean didRemove;
            int uid = job.getUid();
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            boolean bl = didRemove = jobs != null ? jobs.remove(job) : false;
            if (didRemove && jobs.size() == 0) {
                this.mJobs.remove(uid);
            }
            return didRemove;
        }

        public boolean contains(JobStatus job) {
            int uid = job.getUid();
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            return jobs != null && jobs.contains(job);
        }

        public JobStatus get(int uid, int jobId) {
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            if (jobs != null) {
                for (int i = jobs.size() - 1; i >= 0; --i) {
                    JobStatus job = jobs.valueAt(i);
                    if (job.getJobId() != jobId) continue;
                    return job;
                }
            }
            return null;
        }

        public List<JobStatus> getAllJobs() {
            ArrayList<JobStatus> allJobs = new ArrayList<JobStatus>(this.size());
            for (int i = this.mJobs.size() - 1; i >= 0; --i) {
                ArraySet<JobStatus> jobs = this.mJobs.valueAt(i);
                if (jobs == null) continue;
                for (int j = jobs.size() - 1; j >= 0; --j) {
                    allJobs.add(jobs.valueAt(j));
                }
            }
            return allJobs;
        }

        public void clear() {
            this.mJobs.clear();
        }

        public int size() {
            int total = 0;
            for (int i = this.mJobs.size() - 1; i >= 0; --i) {
                total += this.mJobs.valueAt(i).size();
            }
            return total;
        }

        public int countJobsForUid(int uid) {
            int total = 0;
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            if (jobs != null) {
                for (int i = jobs.size() - 1; i >= 0; --i) {
                    JobStatus job = jobs.valueAt(i);
                    if (job.getUid() != job.getSourceUid()) continue;
                    ++total;
                }
            }
            return total;
        }

        public void forEachJob(JobStatusFunctor functor) {
            for (int uidIndex = this.mJobs.size() - 1; uidIndex >= 0; --uidIndex) {
                ArraySet<JobStatus> jobs = this.mJobs.valueAt(uidIndex);
                for (int i = jobs.size() - 1; i >= 0; --i) {
                    functor.process(jobs.valueAt(i));
                }
            }
        }

        public void forEachJob(int uid, JobStatusFunctor functor) {
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            if (jobs != null) {
                for (int i = jobs.size() - 1; i >= 0; --i) {
                    functor.process(jobs.valueAt(i));
                }
            }
        }
    }

    private class ReadJobMapFromDiskRunnable
    implements Runnable {
        private final JobSet jobSet;

        ReadJobMapFromDiskRunnable(JobSet jobSet) {
            this.jobSet = jobSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                FileInputStream fis = JobStore.this.mJobsFile.openRead();
                Object object = JobStore.this.mLock;
                synchronized (object) {
                    List<JobStatus> jobs = this.readJobMapImpl(fis);
                    if (jobs != null) {
                        for (int i = 0; i < jobs.size(); ++i) {
                            this.jobSet.add(jobs.get(i));
                        }
                    }
                }
                fis.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (XmlPullParserException xmlPullParserException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private List<JobStatus> readJobMapImpl(FileInputStream fis) throws XmlPullParserException, IOException {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, StandardCharsets.UTF_8.name());
            int eventType = parser.getEventType();
            while (eventType != 2 && eventType != 1) {
                eventType = parser.next();
                Slog.d(JobStore.TAG, "Start tag: " + parser.getName());
            }
            if (eventType == 1) {
                return null;
            }
            String tagName = parser.getName();
            if ("job-info".equals(tagName)) {
                ArrayList<JobStatus> jobs = new ArrayList<JobStatus>();
                try {
                    int version = Integer.parseInt(parser.getAttributeValue(null, "version"));
                    if (version != 0) {
                        Slog.d(JobStore.TAG, "Invalid version number, aborting jobs file read.");
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    Slog.e(JobStore.TAG, "Invalid version number, aborting jobs file read.");
                    return null;
                }
                eventType = parser.next();
                do {
                    if (eventType != 2 || !"job".equals(tagName = parser.getName())) continue;
                    JobStatus persistedJob = this.restoreJobFromXml(parser);
                    if (persistedJob != null) {
                        jobs.add(persistedJob);
                        continue;
                    }
                    Slog.d(JobStore.TAG, "Error reading job from file.");
                } while ((eventType = parser.next()) != 1);
                return jobs;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        private JobStatus restoreJobFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
            try {
                jobBuilder = this.buildBuilderFromXml(parser);
                jobBuilder.setPersisted(true);
                uid = Integer.parseInt(parser.getAttributeValue(null, "uid"));
                val = parser.getAttributeValue(null, "priority");
                if (val != null) {
                    jobBuilder.setPriority(Integer.parseInt(val));
                }
                if ((val = parser.getAttributeValue(null, "flags")) != null) {
                    jobBuilder.setFlags(Integer.parseInt(val));
                }
                sourceUserId = (val = parser.getAttributeValue(null, "sourceUserId")) == null ? -1 : Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                Slog.e("JobStore", "Error parsing job's required fields, skipping");
                return null;
            }
            sourcePackageName = parser.getAttributeValue(null, "sourcePackageName");
            sourceTag = parser.getAttributeValue(null, "sourceTag");
            while ((eventType = parser.next()) == 4) {
            }
            if (eventType != 2 || !"constraints".equals(parser.getName())) {
                return null;
            }
            try {
                this.buildConstraintsFromXml(jobBuilder, parser);
            }
            catch (NumberFormatException e) {
                Slog.d("JobStore", "Error reading constraints, skipping.");
                return null;
            }
            parser.next();
            while ((eventType = parser.next()) == 4) {
            }
            if (eventType != 2) {
                return null;
            }
            try {
                elapsedRuntimes = this.buildExecutionTimesFromXml(parser);
            }
            catch (NumberFormatException e) {
                return null;
            }
            elapsedNow = SystemClock.elapsedRealtime();
            if ("periodic".equals(parser.getName())) {
                try {
                    val = parser.getAttributeValue(null, "period");
                    periodMillis = Long.valueOf(val);
                    val = parser.getAttributeValue(null, "flex");
                    flexMillis = val != null ? Long.valueOf(val) : periodMillis;
                    jobBuilder.setPeriodic(periodMillis, flexMillis);
                    if ((Long)elapsedRuntimes.second <= elapsedNow + periodMillis + flexMillis) ** GOTO lbl77
                    clampedLateRuntimeElapsed = elapsedNow + flexMillis + periodMillis;
                    clampedEarlyRuntimeElapsed = clampedLateRuntimeElapsed - flexMillis;
                    Slog.w("JobStore", String.format("Periodic job for uid='%d' persisted run-time is too big [%s, %s]. Clamping to [%s,%s]", new Object[]{uid, DateUtils.formatElapsedTime((Long)elapsedRuntimes.first / 1000L), DateUtils.formatElapsedTime((Long)elapsedRuntimes.second / 1000L), DateUtils.formatElapsedTime(clampedEarlyRuntimeElapsed / 1000L), DateUtils.formatElapsedTime(clampedLateRuntimeElapsed / 1000L)}));
                    elapsedRuntimes = Pair.create(clampedEarlyRuntimeElapsed, clampedLateRuntimeElapsed);
                }
                catch (NumberFormatException e) {
                    Slog.d("JobStore", "Error reading periodic execution criteria, skipping.");
                    return null;
                }
            } else if ("one-off".equals(parser.getName())) {
                try {
                    if ((Long)elapsedRuntimes.first != 0L) {
                        jobBuilder.setMinimumLatency((Long)elapsedRuntimes.first - elapsedNow);
                    }
                    if ((Long)elapsedRuntimes.second == 0x7FFFFFFFFFFFFFFFL) ** GOTO lbl77
                    jobBuilder.setOverrideDeadline((Long)elapsedRuntimes.second - elapsedNow);
                }
                catch (NumberFormatException e) {
                    Slog.d("JobStore", "Error reading job execution criteria, skipping.");
                    return null;
                }
            } else {
                return null;
            }
lbl77:
            // 4 sources

            this.maybeBuildBackoffPolicyFromXml(jobBuilder, parser);
            parser.nextTag();
            while ((eventType = parser.next()) == 4) {
            }
            if (eventType != 2 || !"extras".equals(parser.getName())) {
                return null;
            }
            extras = PersistableBundle.restoreFromXml(parser);
            jobBuilder.setExtras(extras);
            parser.nextTag();
            if ("android".equals(sourcePackageName) && extras != null && extras.getBoolean("SyncManagerJob", false)) {
                sourcePackageName = extras.getString("owningPackage", sourcePackageName);
            }
            js = new JobStatus(jobBuilder.build(), uid, sourcePackageName, sourceUserId, sourceTag, (Long)elapsedRuntimes.first, (Long)elapsedRuntimes.second);
            return js;
        }

        private JobInfo.Builder buildBuilderFromXml(XmlPullParser parser) throws NumberFormatException {
            int jobId = Integer.parseInt(parser.getAttributeValue(null, "jobid"));
            String packageName = parser.getAttributeValue(null, "package");
            String className = parser.getAttributeValue(null, "class");
            ComponentName cname = new ComponentName(packageName, className);
            return new JobInfo.Builder(jobId, cname);
        }

        private void buildConstraintsFromXml(JobInfo.Builder jobBuilder, XmlPullParser parser) {
            String val = parser.getAttributeValue(null, "connectivity");
            if (val != null) {
                jobBuilder.setRequiredNetworkType(1);
            }
            if ((val = parser.getAttributeValue(null, "unmetered")) != null) {
                jobBuilder.setRequiredNetworkType(2);
            }
            if ((val = parser.getAttributeValue(null, "not-roaming")) != null) {
                jobBuilder.setRequiredNetworkType(3);
            }
            if ((val = parser.getAttributeValue(null, "idle")) != null) {
                jobBuilder.setRequiresDeviceIdle(true);
            }
            if ((val = parser.getAttributeValue(null, "charging")) != null) {
                jobBuilder.setRequiresCharging(true);
            }
        }

        private void maybeBuildBackoffPolicyFromXml(JobInfo.Builder jobBuilder, XmlPullParser parser) {
            String val = parser.getAttributeValue(null, "initial-backoff");
            if (val != null) {
                long initialBackoff = Long.valueOf(val);
                val = parser.getAttributeValue(null, "backoff-policy");
                int backoffPolicy = Integer.parseInt(val);
                jobBuilder.setBackoffCriteria(initialBackoff, backoffPolicy);
            }
        }

        private Pair<Long, Long> buildExecutionTimesFromXml(XmlPullParser parser) throws NumberFormatException {
            long nowWallclock = System.currentTimeMillis();
            long nowElapsed = SystemClock.elapsedRealtime();
            long earliestRunTimeElapsed = 0L;
            long latestRunTimeElapsed = Long.MAX_VALUE;
            String val = parser.getAttributeValue(null, "deadline");
            if (val != null) {
                long latestRuntimeWallclock = Long.valueOf(val);
                long maxDelayElapsed = Math.max(latestRuntimeWallclock - nowWallclock, 0L);
                latestRunTimeElapsed = nowElapsed + maxDelayElapsed;
            }
            if ((val = parser.getAttributeValue(null, "delay")) != null) {
                long earliestRuntimeWallclock = Long.valueOf(val);
                long minDelayElapsed = Math.max(earliestRuntimeWallclock - nowWallclock, 0L);
                earliestRunTimeElapsed = nowElapsed + minDelayElapsed;
            }
            return Pair.create(earliestRunTimeElapsed, latestRunTimeElapsed);
        }
    }

    private class WriteJobsMapToDiskRunnable
    implements Runnable {
        private WriteJobsMapToDiskRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startElapsed = SystemClock.elapsedRealtime();
            final ArrayList<JobStatus> storeCopy = new ArrayList<JobStatus>();
            Object object = JobStore.this.mLock;
            synchronized (object) {
                JobStore.this.mJobSet.forEachJob(new JobStatusFunctor(){

                    @Override
                    public void process(JobStatus job) {
                        if (job.isPersisted()) {
                            storeCopy.add(new JobStatus(job));
                        }
                    }
                });
            }
            this.writeJobsMapImpl(storeCopy);
        }

        private void writeJobsMapImpl(List<JobStatus> jobList) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(baos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "job-info");
                out.attribute(null, "version", Integer.toString(0));
                for (int i = 0; i < jobList.size(); ++i) {
                    JobStatus jobStatus = jobList.get(i);
                    out.startTag(null, "job");
                    this.addAttributesToJobTag(out, jobStatus);
                    this.writeConstraintsToXml(out, jobStatus);
                    this.writeExecutionCriteriaToXml(out, jobStatus);
                    this.writeBundleToXml(jobStatus.getExtras(), out);
                    out.endTag(null, "job");
                }
                out.endTag(null, "job-info");
                out.endDocument();
                FileOutputStream fos = JobStore.this.mJobsFile.startWrite();
                fos.write(baos.toByteArray());
                JobStore.this.mJobsFile.finishWrite(fos);
                JobStore.this.mDirtyOperations = 0;
            }
            catch (IOException iOException) {
            }
            catch (XmlPullParserException xmlPullParserException) {
                // empty catch block
            }
        }

        private void addAttributesToJobTag(XmlSerializer out, JobStatus jobStatus) throws IOException {
            out.attribute(null, "jobid", Integer.toString(jobStatus.getJobId()));
            out.attribute(null, "package", jobStatus.getServiceComponent().getPackageName());
            out.attribute(null, "class", jobStatus.getServiceComponent().getClassName());
            if (jobStatus.getSourcePackageName() != null) {
                out.attribute(null, "sourcePackageName", jobStatus.getSourcePackageName());
            }
            if (jobStatus.getSourceTag() != null) {
                out.attribute(null, "sourceTag", jobStatus.getSourceTag());
            }
            out.attribute(null, "sourceUserId", String.valueOf(jobStatus.getSourceUserId()));
            out.attribute(null, "uid", Integer.toString(jobStatus.getUid()));
            out.attribute(null, "priority", String.valueOf(jobStatus.getPriority()));
            out.attribute(null, "flags", String.valueOf(jobStatus.getFlags()));
        }

        private void writeBundleToXml(PersistableBundle extras, XmlSerializer out) throws IOException, XmlPullParserException {
            out.startTag(null, JobStore.XML_TAG_EXTRAS);
            PersistableBundle extrasCopy = this.deepCopyBundle(extras, 10);
            extrasCopy.saveToXml(out);
            out.endTag(null, JobStore.XML_TAG_EXTRAS);
        }

        private PersistableBundle deepCopyBundle(PersistableBundle bundle, int maxDepth) {
            if (maxDepth <= 0) {
                return null;
            }
            PersistableBundle copy = (PersistableBundle)bundle.clone();
            Set<String> keySet = bundle.keySet();
            for (String key : keySet) {
                Object o = copy.get(key);
                if (!(o instanceof PersistableBundle)) continue;
                PersistableBundle bCopy = this.deepCopyBundle((PersistableBundle)o, maxDepth - 1);
                copy.putPersistableBundle(key, bCopy);
            }
            return copy;
        }

        private void writeConstraintsToXml(XmlSerializer out, JobStatus jobStatus) throws IOException {
            out.startTag(null, JobStore.XML_TAG_PARAMS_CONSTRAINTS);
            if (jobStatus.hasConnectivityConstraint()) {
                out.attribute(null, "connectivity", Boolean.toString(true));
            }
            if (jobStatus.hasUnmeteredConstraint()) {
                out.attribute(null, "unmetered", Boolean.toString(true));
            }
            if (jobStatus.hasNotRoamingConstraint()) {
                out.attribute(null, "not-roaming", Boolean.toString(true));
            }
            if (jobStatus.hasIdleConstraint()) {
                out.attribute(null, "idle", Boolean.toString(true));
            }
            if (jobStatus.hasChargingConstraint()) {
                out.attribute(null, "charging", Boolean.toString(true));
            }
            out.endTag(null, JobStore.XML_TAG_PARAMS_CONSTRAINTS);
        }

        private void writeExecutionCriteriaToXml(XmlSerializer out, JobStatus jobStatus) throws IOException {
            JobInfo job = jobStatus.getJob();
            if (jobStatus.getJob().isPeriodic()) {
                out.startTag(null, JobStore.XML_TAG_PERIODIC);
                out.attribute(null, "period", Long.toString(job.getIntervalMillis()));
                out.attribute(null, "flex", Long.toString(job.getFlexMillis()));
            } else {
                out.startTag(null, JobStore.XML_TAG_ONEOFF);
            }
            if (jobStatus.hasDeadlineConstraint()) {
                long deadlineWallclock = System.currentTimeMillis() + (jobStatus.getLatestRunTimeElapsed() - SystemClock.elapsedRealtime());
                out.attribute(null, "deadline", Long.toString(deadlineWallclock));
            }
            if (jobStatus.hasTimingDelayConstraint()) {
                long delayWallclock = System.currentTimeMillis() + (jobStatus.getEarliestRunTime() - SystemClock.elapsedRealtime());
                out.attribute(null, "delay", Long.toString(delayWallclock));
            }
            if (jobStatus.getJob().getInitialBackoffMillis() != 30000L || jobStatus.getJob().getBackoffPolicy() != 1) {
                out.attribute(null, "backoff-policy", Integer.toString(job.getBackoffPolicy()));
                out.attribute(null, "initial-backoff", Long.toString(job.getInitialBackoffMillis()));
            }
            if (job.isPeriodic()) {
                out.endTag(null, JobStore.XML_TAG_PERIODIC);
            } else {
                out.endTag(null, JobStore.XML_TAG_ONEOFF);
            }
        }
    }

    public static interface JobStatusFunctor {
        public void process(JobStatus var1);
    }
}

