/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.midi;

import android.bluetooth.BluetoothDevice;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.XmlResourceParser;
import android.media.midi.IBluetoothMidiService;
import android.media.midi.IMidiDeviceListener;
import android.media.midi.IMidiDeviceOpenCallback;
import android.media.midi.IMidiDeviceServer;
import android.media.midi.IMidiManager;
import android.media.midi.MidiDeviceInfo;
import android.media.midi.MidiDeviceStatus;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.SystemService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MidiService
extends IMidiManager.Stub {
    private static final String TAG = "MidiService";
    private final Context mContext;
    private final HashMap<IBinder, Client> mClients = new HashMap();
    private final HashMap<MidiDeviceInfo, Device> mDevicesByInfo = new HashMap();
    private final HashMap<BluetoothDevice, Device> mBluetoothDevices = new HashMap();
    private final HashMap<IBinder, Device> mDevicesByServer = new HashMap();
    private int mNextDeviceId = 1;
    private final PackageManager mPackageManager;
    private int mBluetoothServiceUid;
    private final PackageMonitor mPackageMonitor = new PackageMonitor(){

        @Override
        public void onPackageAdded(String packageName, int uid) {
            MidiService.this.addPackageDeviceServers(packageName);
        }

        @Override
        public void onPackageModified(String packageName) {
            MidiService.this.removePackageDeviceServers(packageName);
            MidiService.this.addPackageDeviceServers(packageName);
        }

        @Override
        public void onPackageRemoved(String packageName, int uid) {
            MidiService.this.removePackageDeviceServers(packageName);
        }
    };
    private static final MidiDeviceInfo[] EMPTY_DEVICE_INFO_ARRAY = new MidiDeviceInfo[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client getClient(IBinder token) {
        HashMap<IBinder, Client> hashMap = this.mClients;
        synchronized (hashMap) {
            Client client = this.mClients.get(token);
            if (client == null) {
                client = new Client(token);
                try {
                    token.linkToDeath(client, 0);
                }
                catch (RemoteException e) {
                    return null;
                }
                this.mClients.put(token, client);
            }
            return client;
        }
    }

    public MidiService(Context context) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mBluetoothServiceUid = -1;
    }

    private void onUnlockUser() {
        PackageInfo info;
        this.mPackageMonitor.register(this.mContext, null, true);
        Intent intent = new Intent("android.media.midi.MidiDeviceService");
        List<ResolveInfo> resolveInfos = this.mPackageManager.queryIntentServices(intent, 128);
        if (resolveInfos != null) {
            int count = resolveInfos.size();
            for (int i = 0; i < count; ++i) {
                ServiceInfo serviceInfo = resolveInfos.get((int)i).serviceInfo;
                if (serviceInfo == null) continue;
                this.addPackageDeviceServer(serviceInfo);
            }
        }
        try {
            info = this.mPackageManager.getPackageInfo("com.android.bluetoothmidiservice", 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            info = null;
        }
        this.mBluetoothServiceUid = info != null && info.applicationInfo != null ? info.applicationInfo.uid : -1;
    }

    @Override
    public void registerListener(IBinder token, IMidiDeviceListener listener) {
        Client client = this.getClient(token);
        if (client == null) {
            return;
        }
        client.addListener(listener);
        this.updateStickyDeviceStatus(client.mUid, listener);
    }

    @Override
    public void unregisterListener(IBinder token, IMidiDeviceListener listener) {
        Client client = this.getClient(token);
        if (client == null) {
            return;
        }
        client.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStickyDeviceStatus(int uid, IMidiDeviceListener listener) {
        HashMap<MidiDeviceInfo, Device> hashMap = this.mDevicesByInfo;
        synchronized (hashMap) {
            for (Device device : this.mDevicesByInfo.values()) {
                if (!device.isUidAllowed(uid)) continue;
                try {
                    MidiDeviceStatus status = device.getDeviceStatus();
                    if (status == null) continue;
                    listener.onDeviceStatusChanged(status);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "remote exception", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MidiDeviceInfo[] getDevices() {
        ArrayList<MidiDeviceInfo> deviceInfos = new ArrayList<MidiDeviceInfo>();
        int uid = Binder.getCallingUid();
        HashMap<MidiDeviceInfo, Device> hashMap = this.mDevicesByInfo;
        synchronized (hashMap) {
            for (Device device : this.mDevicesByInfo.values()) {
                if (!device.isUidAllowed(uid)) continue;
                deviceInfos.add(device.getDeviceInfo());
            }
        }
        return deviceInfos.toArray(EMPTY_DEVICE_INFO_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openDevice(IBinder token, MidiDeviceInfo deviceInfo, IMidiDeviceOpenCallback callback) {
        Device device;
        Client client = this.getClient(token);
        if (client == null) {
            return;
        }
        HashMap<MidiDeviceInfo, Device> hashMap = this.mDevicesByInfo;
        synchronized (hashMap) {
            device = this.mDevicesByInfo.get(deviceInfo);
            if (device == null) {
                throw new IllegalArgumentException("device does not exist: " + deviceInfo);
            }
            if (!device.isUidAllowed(Binder.getCallingUid())) {
                throw new SecurityException("Attempt to open private device with wrong UID");
            }
        }
        long identity = Binder.clearCallingIdentity();
        try {
            client.addDeviceConnection(device, callback);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openBluetoothDevice(IBinder token, BluetoothDevice bluetoothDevice, IMidiDeviceOpenCallback callback) {
        Device device;
        Client client = this.getClient(token);
        if (client == null) {
            return;
        }
        HashMap<MidiDeviceInfo, Device> hashMap = this.mDevicesByInfo;
        synchronized (hashMap) {
            device = this.mBluetoothDevices.get(bluetoothDevice);
            if (device == null) {
                device = new Device(bluetoothDevice);
                this.mBluetoothDevices.put(bluetoothDevice, device);
            }
        }
        long identity = Binder.clearCallingIdentity();
        try {
            client.addDeviceConnection(device, callback);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @Override
    public void closeDevice(IBinder clientToken, IBinder deviceToken) {
        Client client = this.getClient(clientToken);
        if (client == null) {
            return;
        }
        client.removeDeviceConnection(deviceToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MidiDeviceInfo registerDeviceServer(IMidiDeviceServer server, int numInputPorts, int numOutputPorts, String[] inputPortNames, String[] outputPortNames, Bundle properties, int type) {
        int uid = Binder.getCallingUid();
        if (type == 1 && uid != 1000) {
            throw new SecurityException("only system can create USB devices");
        }
        if (type == 3 && uid != this.mBluetoothServiceUid) {
            throw new SecurityException("only MidiBluetoothService can create Bluetooth devices");
        }
        HashMap<MidiDeviceInfo, Device> hashMap = this.mDevicesByInfo;
        synchronized (hashMap) {
            return this.addDeviceLocked(type, numInputPorts, numOutputPorts, inputPortNames, outputPortNames, properties, server, null, false, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDeviceServer(IMidiDeviceServer server) {
        HashMap<MidiDeviceInfo, Device> hashMap = this.mDevicesByInfo;
        synchronized (hashMap) {
            Device device = this.mDevicesByServer.get(server.asBinder());
            if (device != null) {
                device.closeLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MidiDeviceInfo getServiceDeviceInfo(String packageName, String className) {
        HashMap<MidiDeviceInfo, Device> hashMap = this.mDevicesByInfo;
        synchronized (hashMap) {
            for (Device device : this.mDevicesByInfo.values()) {
                ServiceInfo serviceInfo = device.getServiceInfo();
                if (serviceInfo == null || !packageName.equals(serviceInfo.packageName) || !className.equals(serviceInfo.name)) continue;
                return device.getDeviceInfo();
            }
            return null;
        }
    }

    @Override
    public MidiDeviceStatus getDeviceStatus(MidiDeviceInfo deviceInfo) {
        Device device = this.mDevicesByInfo.get(deviceInfo);
        if (device == null) {
            throw new IllegalArgumentException("no such device for " + deviceInfo);
        }
        return device.getDeviceStatus();
    }

    @Override
    public void setDeviceStatus(IMidiDeviceServer server, MidiDeviceStatus status) {
        Device device = this.mDevicesByServer.get(server.asBinder());
        if (device != null) {
            if (Binder.getCallingUid() != device.getUid()) {
                throw new SecurityException("setDeviceStatus() caller UID " + Binder.getCallingUid() + " does not match device's UID " + device.getUid());
            }
            device.setDeviceStatus(status);
            this.notifyDeviceStatusChanged(device, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDeviceStatusChanged(Device device, MidiDeviceStatus status) {
        HashMap<IBinder, Client> hashMap = this.mClients;
        synchronized (hashMap) {
            for (Client c : this.mClients.values()) {
                c.deviceStatusChanged(device, status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MidiDeviceInfo addDeviceLocked(int type, int numInputPorts, int numOutputPorts, String[] inputPortNames, String[] outputPortNames, Bundle properties, IMidiDeviceServer server, ServiceInfo serviceInfo, boolean isPrivate, int uid) {
        int id2 = this.mNextDeviceId++;
        MidiDeviceInfo deviceInfo = new MidiDeviceInfo(type, id2, numInputPorts, numOutputPorts, inputPortNames, outputPortNames, properties, isPrivate);
        if (server != null) {
            try {
                server.setDeviceInfo(deviceInfo);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in setDeviceInfo()");
                return null;
            }
        }
        Device device = null;
        BluetoothDevice bluetoothDevice = null;
        if (type == 3 && (device = this.mBluetoothDevices.get(bluetoothDevice = (BluetoothDevice)properties.getParcelable("bluetooth_device"))) != null) {
            device.setDeviceInfo(deviceInfo);
        }
        if (device == null) {
            device = new Device(server, deviceInfo, serviceInfo, uid);
        }
        this.mDevicesByInfo.put(deviceInfo, device);
        if (bluetoothDevice != null) {
            this.mBluetoothDevices.put(bluetoothDevice, device);
        }
        HashMap<IBinder, Client> hashMap = this.mClients;
        synchronized (hashMap) {
            for (Client c : this.mClients.values()) {
                c.deviceAdded(device);
            }
        }
        return deviceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeviceLocked(Device device) {
        IMidiDeviceServer server = device.getDeviceServer();
        if (server != null) {
            this.mDevicesByServer.remove(server.asBinder());
        }
        this.mDevicesByInfo.remove(device.getDeviceInfo());
        HashMap<IBinder, Client> hashMap = this.mClients;
        synchronized (hashMap) {
            for (Client c : this.mClients.values()) {
                c.deviceRemoved(device);
            }
        }
    }

    private void addPackageDeviceServers(String packageName) {
        PackageInfo info;
        try {
            info = this.mPackageManager.getPackageInfo(packageName, 132);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "handlePackageUpdate could not find package " + packageName, e);
            return;
        }
        ServiceInfo[] services = info.services;
        if (services == null) {
            return;
        }
        for (int i = 0; i < services.length; ++i) {
            this.addPackageDeviceServer(services[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackageDeviceServer(ServiceInfo serviceInfo) {
        try (XmlResourceParser parser = null;){
            int eventType;
            parser = serviceInfo.loadXmlMetaData(this.mPackageManager, "android.media.midi.MidiDeviceService");
            if (parser == null) {
                return;
            }
            if (!"android.permission.BIND_MIDI_DEVICE_SERVICE".equals(serviceInfo.permission)) {
                Log.w(TAG, "Skipping MIDI device service " + serviceInfo.packageName + ": it does not require the permission " + "android.permission.BIND_MIDI_DEVICE_SERVICE");
                return;
            }
            Bundle properties = null;
            int numInputPorts = 0;
            int numOutputPorts = 0;
            boolean isPrivate = false;
            ArrayList<String> inputPortNames = new ArrayList<String>();
            ArrayList<String> outputPortNames = new ArrayList<String>();
            block12: while ((eventType = parser.next()) != 1) {
                int uid;
                String tagName;
                if (eventType == 2) {
                    String value;
                    String name;
                    int i;
                    tagName = parser.getName();
                    if ("device".equals(tagName)) {
                        if (properties != null) {
                            Log.w(TAG, "nested <device> elements in metadata for " + serviceInfo.packageName);
                            continue;
                        }
                        properties = new Bundle();
                        properties.putParcelable("service_info", serviceInfo);
                        numInputPorts = 0;
                        numOutputPorts = 0;
                        isPrivate = false;
                        int count = parser.getAttributeCount();
                        int i2 = 0;
                        while (true) {
                            if (i2 >= count) continue block12;
                            String name2 = parser.getAttributeName(i2);
                            String value2 = parser.getAttributeValue(i2);
                            if ("private".equals(name2)) {
                                isPrivate = "true".equals(value2);
                            } else {
                                properties.putString(name2, value2);
                            }
                            ++i2;
                        }
                    }
                    if ("input-port".equals(tagName)) {
                        if (properties == null) {
                            Log.w(TAG, "<input-port> outside of <device> in metadata for " + serviceInfo.packageName);
                            continue;
                        }
                        ++numInputPorts;
                        String portName = null;
                        int count = parser.getAttributeCount();
                        for (i = 0; i < count; ++i) {
                            name = parser.getAttributeName(i);
                            value = parser.getAttributeValue(i);
                            if (!"name".equals(name)) continue;
                            portName = value;
                            break;
                        }
                        inputPortNames.add(portName);
                        continue;
                    }
                    if (!"output-port".equals(tagName)) continue;
                    if (properties == null) {
                        Log.w(TAG, "<output-port> outside of <device> in metadata for " + serviceInfo.packageName);
                        continue;
                    }
                    ++numOutputPorts;
                    String portName = null;
                    int count = parser.getAttributeCount();
                    for (i = 0; i < count; ++i) {
                        name = parser.getAttributeName(i);
                        value = parser.getAttributeValue(i);
                        if (!"name".equals(name)) continue;
                        portName = value;
                        break;
                    }
                    outputPortNames.add(portName);
                    continue;
                }
                if (eventType != 3 || !"device".equals(tagName = parser.getName()) || properties == null) continue;
                if (numInputPorts == 0 && numOutputPorts == 0) {
                    Log.w(TAG, "<device> with no ports in metadata for " + serviceInfo.packageName);
                    continue;
                }
                try {
                    ApplicationInfo appInfo = this.mPackageManager.getApplicationInfo(serviceInfo.packageName, 0);
                    uid = appInfo.uid;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(TAG, "could not fetch ApplicationInfo for " + serviceInfo.packageName);
                    continue;
                }
                HashMap<MidiDeviceInfo, Device> hashMap = this.mDevicesByInfo;
                synchronized (hashMap) {
                    this.addDeviceLocked(2, numInputPorts, numOutputPorts, inputPortNames.toArray(EMPTY_STRING_ARRAY), outputPortNames.toArray(EMPTY_STRING_ARRAY), properties, null, serviceInfo, isPrivate, uid);
                }
                properties = null;
                inputPortNames.clear();
                outputPortNames.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePackageDeviceServers(String packageName) {
        HashMap<MidiDeviceInfo, Device> hashMap = this.mDevicesByInfo;
        synchronized (hashMap) {
            Iterator<Device> iterator = this.mDevicesByInfo.values().iterator();
            while (iterator.hasNext()) {
                Device device = iterator.next();
                if (!packageName.equals(device.getPackageName())) continue;
                iterator.remove();
                this.removeDeviceLocked(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println("MIDI Manager State:");
        pw.increaseIndent();
        pw.println("Devices:");
        pw.increaseIndent();
        HashMap<Object, IBinder.DeathRecipient> hashMap = this.mDevicesByInfo;
        synchronized (hashMap) {
            for (Device device : this.mDevicesByInfo.values()) {
                pw.println(device.toString());
            }
        }
        pw.decreaseIndent();
        pw.println("Clients:");
        pw.increaseIndent();
        hashMap = this.mClients;
        synchronized (hashMap) {
            for (Client client : this.mClients.values()) {
                pw.println(client.toString());
            }
        }
        pw.decreaseIndent();
    }

    private final class DeviceConnection {
        private final IBinder mToken = new Binder();
        private final Device mDevice;
        private final Client mClient;
        private IMidiDeviceOpenCallback mCallback;

        public DeviceConnection(Device device, Client client, IMidiDeviceOpenCallback callback) {
            this.mDevice = device;
            this.mClient = client;
            this.mCallback = callback;
        }

        public Device getDevice() {
            return this.mDevice;
        }

        public Client getClient() {
            return this.mClient;
        }

        public IBinder getToken() {
            return this.mToken;
        }

        public void notifyClient(IMidiDeviceServer deviceServer) {
            if (this.mCallback != null) {
                try {
                    this.mCallback.onDeviceOpened(deviceServer, deviceServer == null ? null : this.mToken);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mCallback = null;
            }
        }

        public String toString() {
            return "DeviceConnection Device ID: " + this.mDevice.getDeviceInfo().getId();
        }
    }

    private final class Device
    implements IBinder.DeathRecipient {
        private IMidiDeviceServer mServer;
        private MidiDeviceInfo mDeviceInfo;
        private final BluetoothDevice mBluetoothDevice;
        private MidiDeviceStatus mDeviceStatus;
        private final ServiceInfo mServiceInfo;
        private final int mUid;
        private ServiceConnection mServiceConnection;
        private final ArrayList<DeviceConnection> mDeviceConnections = new ArrayList();

        public Device(IMidiDeviceServer server, MidiDeviceInfo deviceInfo, ServiceInfo serviceInfo, int uid) {
            this.mDeviceInfo = deviceInfo;
            this.mServiceInfo = serviceInfo;
            this.mUid = uid;
            this.mBluetoothDevice = (BluetoothDevice)deviceInfo.getProperties().getParcelable("bluetooth_device");
            this.setDeviceServer(server);
        }

        public Device(BluetoothDevice bluetoothDevice) {
            this.mBluetoothDevice = bluetoothDevice;
            this.mServiceInfo = null;
            this.mUid = MidiService.this.mBluetoothServiceUid;
        }

        private void setDeviceServer(IMidiDeviceServer server) {
            IBinder binder;
            if (server != null) {
                if (this.mServer != null) {
                    Log.e(MidiService.TAG, "mServer already set in setDeviceServer");
                    return;
                }
                binder = server.asBinder();
                try {
                    if (this.mDeviceInfo == null) {
                        this.mDeviceInfo = server.getDeviceInfo();
                    }
                    binder.linkToDeath(this, 0);
                    this.mServer = server;
                }
                catch (RemoteException e) {
                    this.mServer = null;
                    return;
                }
                MidiService.this.mDevicesByServer.put(binder, this);
            } else if (this.mServer != null) {
                server = this.mServer;
                this.mServer = null;
                binder = server.asBinder();
                MidiService.this.mDevicesByServer.remove(binder);
                try {
                    server.closeDevice();
                    binder.unlinkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            if (this.mDeviceConnections != null) {
                for (DeviceConnection connection : this.mDeviceConnections) {
                    connection.notifyClient(server);
                }
            }
        }

        public MidiDeviceInfo getDeviceInfo() {
            return this.mDeviceInfo;
        }

        public void setDeviceInfo(MidiDeviceInfo deviceInfo) {
            this.mDeviceInfo = deviceInfo;
        }

        public MidiDeviceStatus getDeviceStatus() {
            return this.mDeviceStatus;
        }

        public void setDeviceStatus(MidiDeviceStatus status) {
            this.mDeviceStatus = status;
        }

        public IMidiDeviceServer getDeviceServer() {
            return this.mServer;
        }

        public ServiceInfo getServiceInfo() {
            return this.mServiceInfo;
        }

        public String getPackageName() {
            return this.mServiceInfo == null ? null : this.mServiceInfo.packageName;
        }

        public int getUid() {
            return this.mUid;
        }

        public boolean isUidAllowed(int uid) {
            return !this.mDeviceInfo.isPrivate() || this.mUid == uid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDeviceConnection(DeviceConnection connection) {
            ArrayList<DeviceConnection> arrayList = this.mDeviceConnections;
            synchronized (arrayList) {
                if (this.mServer != null) {
                    this.mDeviceConnections.add(connection);
                    connection.notifyClient(this.mServer);
                } else if (this.mServiceConnection == null && (this.mServiceInfo != null || this.mBluetoothDevice != null)) {
                    Intent intent;
                    this.mDeviceConnections.add(connection);
                    this.mServiceConnection = new ServiceConnection(){

                        @Override
                        public void onServiceConnected(ComponentName name, IBinder service) {
                            IMidiDeviceServer server = null;
                            if (Device.this.mBluetoothDevice != null) {
                                IBluetoothMidiService mBluetoothMidiService = IBluetoothMidiService.Stub.asInterface(service);
                                try {
                                    IBinder deviceBinder = mBluetoothMidiService.addBluetoothDevice(Device.this.mBluetoothDevice);
                                    server = IMidiDeviceServer.Stub.asInterface(deviceBinder);
                                }
                                catch (RemoteException e) {
                                    Log.e(MidiService.TAG, "Could not call addBluetoothDevice()", e);
                                }
                            } else {
                                server = IMidiDeviceServer.Stub.asInterface(service);
                            }
                            Device.this.setDeviceServer(server);
                        }

                        @Override
                        public void onServiceDisconnected(ComponentName name) {
                            Device.this.setDeviceServer(null);
                            Device.this.mServiceConnection = null;
                        }
                    };
                    if (this.mBluetoothDevice != null) {
                        intent = new Intent("android.media.midi.BluetoothMidiService");
                        intent.setComponent(new ComponentName("com.android.bluetoothmidiservice", "com.android.bluetoothmidiservice.BluetoothMidiService"));
                    } else {
                        intent = new Intent("android.media.midi.MidiDeviceService");
                        intent.setComponent(new ComponentName(this.mServiceInfo.packageName, this.mServiceInfo.name));
                    }
                    if (!MidiService.this.mContext.bindService(intent, this.mServiceConnection, 1)) {
                        Log.e(MidiService.TAG, "Unable to bind service: " + intent);
                        this.setDeviceServer(null);
                        this.mServiceConnection = null;
                    }
                } else {
                    Log.e(MidiService.TAG, "No way to connect to device in addDeviceConnection");
                    connection.notifyClient(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDeviceConnection(DeviceConnection connection) {
            ArrayList<DeviceConnection> arrayList = this.mDeviceConnections;
            synchronized (arrayList) {
                this.mDeviceConnections.remove(connection);
                if (this.mDeviceConnections.size() == 0 && this.mServiceConnection != null) {
                    MidiService.this.mContext.unbindService(this.mServiceConnection);
                    this.mServiceConnection = null;
                    if (this.mBluetoothDevice != null) {
                        HashMap hashMap = MidiService.this.mDevicesByInfo;
                        synchronized (hashMap) {
                            this.closeLocked();
                        }
                    } else {
                        this.setDeviceServer(null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeLocked() {
            ArrayList<DeviceConnection> arrayList = this.mDeviceConnections;
            synchronized (arrayList) {
                for (DeviceConnection connection : this.mDeviceConnections) {
                    connection.getClient().removeDeviceConnection(connection);
                }
                this.mDeviceConnections.clear();
            }
            this.setDeviceServer(null);
            if (this.mServiceInfo == null) {
                MidiService.this.removeDeviceLocked(this);
            } else {
                this.mDeviceStatus = new MidiDeviceStatus(this.mDeviceInfo);
            }
            if (this.mBluetoothDevice != null) {
                MidiService.this.mBluetoothDevices.remove(this.mBluetoothDevice);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Log.d(MidiService.TAG, "Device died: " + this);
            HashMap hashMap = MidiService.this.mDevicesByInfo;
            synchronized (hashMap) {
                this.closeLocked();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Device Info: ");
            sb.append(this.mDeviceInfo);
            sb.append(" Status: ");
            sb.append(this.mDeviceStatus);
            sb.append(" UID: ");
            sb.append(this.mUid);
            sb.append(" DeviceConnection count: ");
            sb.append(this.mDeviceConnections.size());
            sb.append(" mServiceConnection: ");
            sb.append(this.mServiceConnection);
            return sb.toString();
        }
    }

    private final class Client
    implements IBinder.DeathRecipient {
        private final IBinder mToken;
        private final int mUid;
        private final int mPid;
        private final HashMap<IBinder, IMidiDeviceListener> mListeners = new HashMap();
        private final HashMap<IBinder, DeviceConnection> mDeviceConnections = new HashMap();

        public Client(IBinder token) {
            this.mToken = token;
            this.mUid = Binder.getCallingUid();
            this.mPid = Binder.getCallingPid();
        }

        public int getUid() {
            return this.mUid;
        }

        public void addListener(IMidiDeviceListener listener) {
            this.mListeners.put(listener.asBinder(), listener);
        }

        public void removeListener(IMidiDeviceListener listener) {
            this.mListeners.remove(listener.asBinder());
            if (this.mListeners.size() == 0 && this.mDeviceConnections.size() == 0) {
                this.close();
            }
        }

        public void addDeviceConnection(Device device, IMidiDeviceOpenCallback callback) {
            DeviceConnection connection = new DeviceConnection(device, this, callback);
            this.mDeviceConnections.put(connection.getToken(), connection);
            device.addDeviceConnection(connection);
        }

        public void removeDeviceConnection(IBinder token) {
            DeviceConnection connection = this.mDeviceConnections.remove(token);
            if (connection != null) {
                connection.getDevice().removeDeviceConnection(connection);
            }
            if (this.mListeners.size() == 0 && this.mDeviceConnections.size() == 0) {
                this.close();
            }
        }

        public void removeDeviceConnection(DeviceConnection connection) {
            this.mDeviceConnections.remove(connection.getToken());
            if (this.mListeners.size() == 0 && this.mDeviceConnections.size() == 0) {
                this.close();
            }
        }

        public void deviceAdded(Device device) {
            if (!device.isUidAllowed(this.mUid)) {
                return;
            }
            MidiDeviceInfo deviceInfo = device.getDeviceInfo();
            try {
                for (IMidiDeviceListener listener : this.mListeners.values()) {
                    listener.onDeviceAdded(deviceInfo);
                }
            }
            catch (RemoteException e) {
                Log.e(MidiService.TAG, "remote exception", e);
            }
        }

        public void deviceRemoved(Device device) {
            if (!device.isUidAllowed(this.mUid)) {
                return;
            }
            MidiDeviceInfo deviceInfo = device.getDeviceInfo();
            try {
                for (IMidiDeviceListener listener : this.mListeners.values()) {
                    listener.onDeviceRemoved(deviceInfo);
                }
            }
            catch (RemoteException e) {
                Log.e(MidiService.TAG, "remote exception", e);
            }
        }

        public void deviceStatusChanged(Device device, MidiDeviceStatus status) {
            if (!device.isUidAllowed(this.mUid)) {
                return;
            }
            try {
                for (IMidiDeviceListener listener : this.mListeners.values()) {
                    listener.onDeviceStatusChanged(status);
                }
            }
            catch (RemoteException e) {
                Log.e(MidiService.TAG, "remote exception", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            HashMap hashMap = MidiService.this.mClients;
            synchronized (hashMap) {
                MidiService.this.mClients.remove(this.mToken);
                this.mToken.unlinkToDeath(this, 0);
            }
            for (DeviceConnection connection : this.mDeviceConnections.values()) {
                connection.getDevice().removeDeviceConnection(connection);
            }
        }

        @Override
        public void binderDied() {
            Log.d(MidiService.TAG, "Client died: " + this);
            this.close();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Client: UID: ");
            sb.append(this.mUid);
            sb.append(" PID: ");
            sb.append(this.mPid);
            sb.append(" listener count: ");
            sb.append(this.mListeners.size());
            sb.append(" Device Connections:");
            for (DeviceConnection connection : this.mDeviceConnections.values()) {
                sb.append(" <device ");
                sb.append(connection.getDevice().getDeviceInfo().getId());
                sb.append(">");
            }
            return sb.toString();
        }
    }

    public static class Lifecycle
    extends SystemService {
        private MidiService mMidiService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mMidiService = new MidiService(this.getContext());
            this.publishBinderService("midi", this.mMidiService);
        }

        @Override
        public void onUnlockUser(int userHandle) {
            if (userHandle == 0) {
                this.mMidiService.onUnlockUser();
            }
        }
    }
}

