/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.os.INetworkManagementService;
import android.os.RemoteException;
import android.security.KeyStore;
import android.system.Os;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnProfile;
import com.android.internal.util.Preconditions;
import com.android.server.ConnectivityService;
import com.android.server.EventLogTags;
import com.android.server.connectivity.Vpn;
import java.util.List;

public class LockdownVpnTracker {
    private static final String TAG = "LockdownVpnTracker";
    private static final int MAX_ERROR_COUNT = 4;
    private static final String ACTION_LOCKDOWN_RESET = "com.android.server.action.LOCKDOWN_RESET";
    private static final int ROOT_UID = 0;
    private final Context mContext;
    private final INetworkManagementService mNetService;
    private final ConnectivityService mConnService;
    private final Vpn mVpn;
    private final VpnProfile mProfile;
    private final Object mStateLock = new Object();
    private final PendingIntent mConfigIntent;
    private final PendingIntent mResetIntent;
    private String mAcceptedEgressIface;
    private String mAcceptedIface;
    private List<LinkAddress> mAcceptedSourceAddr;
    private int mErrorCount;
    private BroadcastReceiver mResetReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            LockdownVpnTracker.this.reset();
        }
    };

    public static boolean isEnabled() {
        return KeyStore.getInstance().contains("LOCKDOWN_VPN");
    }

    public LockdownVpnTracker(Context context, INetworkManagementService netService, ConnectivityService connService, Vpn vpn, VpnProfile profile) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mNetService = Preconditions.checkNotNull(netService);
        this.mConnService = Preconditions.checkNotNull(connService);
        this.mVpn = Preconditions.checkNotNull(vpn);
        this.mProfile = Preconditions.checkNotNull(profile);
        Intent configIntent = new Intent("android.settings.VPN_SETTINGS");
        this.mConfigIntent = PendingIntent.getActivity(this.mContext, 0, configIntent, 0);
        Intent resetIntent = new Intent(ACTION_LOCKDOWN_RESET);
        resetIntent.addFlags(0x40000000);
        this.mResetIntent = PendingIntent.getBroadcast(this.mContext, 0, resetIntent, 0);
    }

    private void handleStateChangedLocked() {
        NetworkInfo egressInfo = this.mConnService.getActiveNetworkInfoUnfiltered();
        LinkProperties egressProp = this.mConnService.getActiveLinkProperties();
        NetworkInfo vpnInfo = this.mVpn.getNetworkInfo();
        VpnConfig vpnConfig = this.mVpn.getLegacyVpnConfig();
        boolean egressDisconnected = egressInfo == null || NetworkInfo.State.DISCONNECTED.equals((Object)egressInfo.getState());
        boolean egressChanged = egressProp == null || !TextUtils.equals(this.mAcceptedEgressIface, egressProp.getInterfaceName());
        String egressTypeName = egressInfo == null ? null : ConnectivityManager.getNetworkTypeName(egressInfo.getType());
        String egressIface = egressProp == null ? null : egressProp.getInterfaceName();
        Slog.d(TAG, "handleStateChanged: egress=" + egressTypeName + " " + this.mAcceptedEgressIface + "->" + egressIface);
        if (egressDisconnected || egressChanged) {
            this.clearSourceRulesLocked();
            this.mAcceptedEgressIface = null;
            this.mVpn.stopLegacyVpnPrivileged();
        }
        if (egressDisconnected) {
            this.hideNotification();
            return;
        }
        int egressType = egressInfo.getType();
        if (vpnInfo.getDetailedState() == NetworkInfo.DetailedState.FAILED) {
            EventLogTags.writeLockdownVpnError(egressType);
        }
        if (this.mErrorCount > 4) {
            this.showNotification(17040498, 17303478);
        } else if (egressInfo.isConnected() && !vpnInfo.isConnectedOrConnecting()) {
            if (this.mProfile.isValidLockdownProfile()) {
                Slog.d(TAG, "Active network connected; starting VPN");
                EventLogTags.writeLockdownVpnConnecting(egressType);
                this.showNotification(17040496, 17303478);
                this.mAcceptedEgressIface = egressProp.getInterfaceName();
                try {
                    this.mVpn.startLegacyVpnPrivileged(this.mProfile, KeyStore.getInstance(), egressProp);
                }
                catch (IllegalStateException e) {
                    this.mAcceptedEgressIface = null;
                    Slog.e(TAG, "Failed to start VPN", e);
                    this.showNotification(17040498, 17303478);
                }
            } else {
                Slog.e(TAG, "Invalid VPN profile; requires IP-based server and DNS");
                this.showNotification(17040498, 17303478);
            }
        } else if (vpnInfo.isConnected() && vpnConfig != null) {
            String iface = vpnConfig.interfaze;
            List<LinkAddress> sourceAddrs = vpnConfig.addresses;
            if (TextUtils.equals(iface, this.mAcceptedIface) && sourceAddrs.equals(this.mAcceptedSourceAddr)) {
                return;
            }
            Slog.d(TAG, "VPN connected using iface=" + iface + ", sourceAddr=" + sourceAddrs.toString());
            EventLogTags.writeLockdownVpnConnected(egressType);
            this.showNotification(17040497, 17303477);
            try {
                this.clearSourceRulesLocked();
                this.mNetService.setFirewallInterfaceRule(iface, true);
                for (LinkAddress addr : sourceAddrs) {
                    this.setFirewallEgressSourceRule(addr, true);
                }
                this.mNetService.setFirewallUidRule(0, 0, 1);
                this.mNetService.setFirewallUidRule(0, Os.getuid(), 1);
                this.mErrorCount = 0;
                this.mAcceptedIface = iface;
                this.mAcceptedSourceAddr = sourceAddrs;
            }
            catch (RemoteException e) {
                throw new RuntimeException("Problem setting firewall rules", e);
            }
            NetworkInfo clone = new NetworkInfo(egressInfo);
            this.augmentNetworkInfo(clone);
            this.mConnService.sendConnectedBroadcast(clone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.initLocked();
        }
    }

    private void initLocked() {
        Slog.d(TAG, "initLocked()");
        this.mVpn.setEnableTeardown(false);
        IntentFilter resetFilter = new IntentFilter(ACTION_LOCKDOWN_RESET);
        this.mContext.registerReceiver(this.mResetReceiver, resetFilter, "android.permission.CONNECTIVITY_INTERNAL", null);
        try {
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 500, true);
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 4500, true);
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 1701, true);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Problem setting firewall rules", e);
        }
        this.handleStateChangedLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.shutdownLocked();
        }
    }

    private void shutdownLocked() {
        Slog.d(TAG, "shutdownLocked()");
        this.mAcceptedEgressIface = null;
        this.mErrorCount = 0;
        this.mVpn.stopLegacyVpnPrivileged();
        try {
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 500, false);
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 4500, false);
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 1701, false);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Problem setting firewall rules", e);
        }
        this.clearSourceRulesLocked();
        this.hideNotification();
        this.mContext.unregisterReceiver(this.mResetReceiver);
        this.mVpn.setEnableTeardown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Slog.d(TAG, "reset()");
        Object object = this.mStateLock;
        synchronized (object) {
            this.shutdownLocked();
            this.initLocked();
            this.handleStateChangedLocked();
        }
    }

    private void clearSourceRulesLocked() {
        try {
            if (this.mAcceptedIface != null) {
                this.mNetService.setFirewallInterfaceRule(this.mAcceptedIface, false);
                this.mAcceptedIface = null;
            }
            if (this.mAcceptedSourceAddr != null) {
                for (LinkAddress addr : this.mAcceptedSourceAddr) {
                    this.setFirewallEgressSourceRule(addr, false);
                }
                this.mNetService.setFirewallUidRule(0, 0, 0);
                this.mNetService.setFirewallUidRule(0, Os.getuid(), 0);
                this.mAcceptedSourceAddr = null;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Problem setting firewall rules", e);
        }
    }

    private void setFirewallEgressSourceRule(LinkAddress address, boolean allow) throws RemoteException {
        String addrString = address.getAddress().getHostAddress();
        this.mNetService.setFirewallEgressSourceRule(addrString, allow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNetworkInfoChanged() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.handleStateChangedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVpnStateChanged(NetworkInfo info) {
        if (info.getDetailedState() == NetworkInfo.DetailedState.FAILED) {
            ++this.mErrorCount;
        }
        Object object = this.mStateLock;
        synchronized (object) {
            this.handleStateChangedLocked();
        }
    }

    public void augmentNetworkInfo(NetworkInfo info) {
        if (info.isConnected()) {
            NetworkInfo vpnInfo = this.mVpn.getNetworkInfo();
            info.setDetailedState(vpnInfo.getDetailedState(), vpnInfo.getReason(), null);
        }
    }

    private void showNotification(int titleRes, int iconRes) {
        Notification.Builder builder = new Notification.Builder(this.mContext).setWhen(0L).setSmallIcon(iconRes).setContentTitle(this.mContext.getString(titleRes)).setContentText(this.mContext.getString(17040499)).setContentIntent(this.mConfigIntent).setPriority(-1).setOngoing(true).addAction(17302497, this.mContext.getString(17040502), this.mResetIntent).setColor(this.mContext.getColor(17170521));
        NotificationManager.from(this.mContext).notify(TAG, 0, builder.build());
    }

    private void hideNotification() {
        NotificationManager.from(this.mContext).cancel(TAG, 0);
    }
}

