/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.Notification;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.UserHandle;
import android.service.notification.NotificationListenerService;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.server.notification.GlobalSortKeyComparator;
import com.android.server.notification.NotificationComparator;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationSignalExtractor;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingHandler;
import com.android.server.notification.RankingReconsideration;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class RankingHelper
implements RankingConfig {
    private static final String TAG = "RankingHelper";
    private static final int XML_VERSION = 1;
    private static final String TAG_RANKING = "ranking";
    private static final String TAG_PACKAGE = "package";
    private static final String ATT_VERSION = "version";
    private static final String ATT_NAME = "name";
    private static final String ATT_UID = "uid";
    private static final String ATT_PRIORITY = "priority";
    private static final String ATT_VISIBILITY = "visibility";
    private static final String ATT_IMPORTANCE = "importance";
    private static final String ATT_TOPIC_ID = "id";
    private static final String ATT_TOPIC_LABEL = "label";
    private static final int DEFAULT_PRIORITY = 0;
    private static final int DEFAULT_VISIBILITY = -1000;
    private static final int DEFAULT_IMPORTANCE = -1000;
    private final NotificationSignalExtractor[] mSignalExtractors;
    private final NotificationComparator mPreliminaryComparator = new NotificationComparator();
    private final GlobalSortKeyComparator mFinalComparator = new GlobalSortKeyComparator();
    private final ArrayMap<String, Record> mRecords = new ArrayMap();
    private final ArrayMap<String, NotificationRecord> mProxyByGroupTmp = new ArrayMap();
    private final ArrayMap<String, Record> mRestoredWithoutUids = new ArrayMap();
    private final Context mContext;
    private final RankingHandler mRankingHandler;

    public RankingHelper(Context context, RankingHandler rankingHandler, NotificationUsageStats usageStats, String[] extractorNames) {
        this.mContext = context;
        this.mRankingHandler = rankingHandler;
        int N = extractorNames.length;
        this.mSignalExtractors = new NotificationSignalExtractor[N];
        for (int i = 0; i < N; ++i) {
            try {
                Class<?> extractorClass = this.mContext.getClassLoader().loadClass(extractorNames[i]);
                NotificationSignalExtractor extractor = (NotificationSignalExtractor)extractorClass.newInstance();
                extractor.initialize(this.mContext, usageStats);
                extractor.setConfig(this);
                this.mSignalExtractors[i] = extractor;
                continue;
            }
            catch (ClassNotFoundException e) {
                Slog.w(TAG, "Couldn't find extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (InstantiationException e) {
                Slog.w(TAG, "Couldn't instantiate extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (IllegalAccessException e) {
                Slog.w(TAG, "Problem accessing extractor " + extractorNames[i] + ".", e);
            }
        }
    }

    public <T extends NotificationSignalExtractor> T findExtractor(Class<T> extractorClass) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            if (!extractorClass.equals(extractor.getClass())) continue;
            return (T)extractor;
        }
        return null;
    }

    public void extractSignals(NotificationRecord r) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            try {
                RankingReconsideration recon = extractor.process(r);
                if (recon == null) continue;
                this.mRankingHandler.requestReconsideration(recon);
            }
            catch (Throwable t) {
                Slog.w(TAG, "NotificationSignalExtractor failed.", t);
            }
        }
    }

    public void readXml(XmlPullParser parser, boolean forRestore) throws XmlPullParserException, IOException {
        PackageManager pm = this.mContext.getPackageManager();
        int type = parser.getEventType();
        if (type != 2) {
            return;
        }
        String tag = parser.getName();
        if (!TAG_RANKING.equals(tag)) {
            return;
        }
        this.mRecords.clear();
        this.mRestoredWithoutUids.clear();
        while ((type = parser.next()) != 1) {
            tag = parser.getName();
            if (type == 3 && TAG_RANKING.equals(tag)) {
                return;
            }
            if (type != 2 || !TAG_PACKAGE.equals(tag)) continue;
            int uid = RankingHelper.safeInt(parser, ATT_UID, Record.UNKNOWN_UID);
            String name = parser.getAttributeValue(null, ATT_NAME);
            if (TextUtils.isEmpty(name)) continue;
            if (forRestore) {
                try {
                    uid = pm.getPackageUidAsUser(name, 0);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            Record r = null;
            if (uid == Record.UNKNOWN_UID) {
                r = this.mRestoredWithoutUids.get(name);
                if (r == null) {
                    r = new Record();
                    this.mRestoredWithoutUids.put(name, r);
                }
            } else {
                r = this.getOrCreateRecord(name, uid);
            }
            r.importance = RankingHelper.safeInt(parser, ATT_IMPORTANCE, -1000);
            r.priority = RankingHelper.safeInt(parser, ATT_PRIORITY, 0);
            r.visibility = RankingHelper.safeInt(parser, ATT_VISIBILITY, -1000);
        }
        throw new IllegalStateException("Failed to reach END_DOCUMENT");
    }

    private static String recordKey(String pkg, int uid) {
        return pkg + "|" + uid;
    }

    private Record getOrCreateRecord(String pkg, int uid) {
        String key = RankingHelper.recordKey(pkg, uid);
        Record r = this.mRecords.get(key);
        if (r == null) {
            r = new Record();
            r.pkg = pkg;
            r.uid = uid;
            this.mRecords.put(key, r);
        }
        return r;
    }

    public void writeXml(XmlSerializer out, boolean forBackup) throws IOException {
        out.startTag(null, TAG_RANKING);
        out.attribute(null, ATT_VERSION, Integer.toString(1));
        int N = this.mRecords.size();
        for (int i = 0; i < N; ++i) {
            boolean hasNonDefaultSettings;
            Record r = this.mRecords.valueAt(i);
            if (forBackup && UserHandle.getUserId(r.uid) != 0) continue;
            boolean bl = hasNonDefaultSettings = r.importance != -1000 || r.priority != 0 || r.visibility != -1000;
            if (!hasNonDefaultSettings) continue;
            out.startTag(null, TAG_PACKAGE);
            out.attribute(null, ATT_NAME, r.pkg);
            if (r.importance != -1000) {
                out.attribute(null, ATT_IMPORTANCE, Integer.toString(r.importance));
            }
            if (r.priority != 0) {
                out.attribute(null, ATT_PRIORITY, Integer.toString(r.priority));
            }
            if (r.visibility != -1000) {
                out.attribute(null, ATT_VISIBILITY, Integer.toString(r.visibility));
            }
            if (!forBackup) {
                out.attribute(null, ATT_UID, Integer.toString(r.uid));
            }
            out.endTag(null, TAG_PACKAGE);
        }
        out.endTag(null, TAG_RANKING);
    }

    private void updateConfig() {
        int N = this.mSignalExtractors.length;
        for (int i = 0; i < N; ++i) {
            this.mSignalExtractors[i].setConfig(this);
        }
        this.mRankingHandler.requestSort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(ArrayList<NotificationRecord> notificationList) {
        int N = notificationList.size();
        for (int i = N - 1; i >= 0; --i) {
            notificationList.get(i).setGlobalSortKey(null);
        }
        Collections.sort(notificationList, this.mPreliminaryComparator);
        ArrayMap<String, NotificationRecord> arrayMap = this.mProxyByGroupTmp;
        synchronized (arrayMap) {
            NotificationRecord record;
            int i;
            for (i = N - 1; i >= 0; --i) {
                record = notificationList.get(i);
                record.setAuthoritativeRank(i);
                String groupKey = record.getGroupKey();
                boolean isGroupSummary = record.getNotification().isGroupSummary();
                if (!isGroupSummary && this.mProxyByGroupTmp.containsKey(groupKey)) continue;
                this.mProxyByGroupTmp.put(groupKey, record);
            }
            for (i = 0; i < N; ++i) {
                record = notificationList.get(i);
                NotificationRecord groupProxy = this.mProxyByGroupTmp.get(record.getGroupKey());
                String groupSortKey = record.getNotification().getSortKey();
                String groupSortKeyPortion = groupSortKey == null ? "nsk" : (groupSortKey.equals("") ? "esk" : "gsk=" + groupSortKey);
                boolean isGroupSummary = record.getNotification().isGroupSummary();
                record.setGlobalSortKey(String.format("intrsv=%c:grnk=0x%04x:gsmry=%c:%s:rnk=0x%04x", Character.valueOf(record.isRecentlyIntrusive() ? (char)'0' : '1'), groupProxy.getAuthoritativeRank(), Character.valueOf(isGroupSummary ? (char)'0' : '1'), groupSortKeyPortion, record.getAuthoritativeRank()));
            }
            this.mProxyByGroupTmp.clear();
        }
        Collections.sort(notificationList, this.mFinalComparator);
    }

    public int indexOf(ArrayList<NotificationRecord> notificationList, NotificationRecord target) {
        return Collections.binarySearch(notificationList, target, this.mFinalComparator);
    }

    private static int safeInt(XmlPullParser parser, String att, int defValue) {
        String val = parser.getAttributeValue(null, att);
        return RankingHelper.tryParseInt(val, defValue);
    }

    private static int tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static boolean tryParseBool(String value, boolean defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public int getPriority(String packageName, int uid) {
        return this.getOrCreateRecord((String)packageName, (int)uid).priority;
    }

    @Override
    public void setPriority(String packageName, int uid, int priority) {
        this.getOrCreateRecord((String)packageName, (int)uid).priority = priority;
        this.updateConfig();
    }

    @Override
    public int getVisibilityOverride(String packageName, int uid) {
        return this.getOrCreateRecord((String)packageName, (int)uid).visibility;
    }

    @Override
    public void setVisibilityOverride(String pkgName, int uid, int visibility) {
        this.getOrCreateRecord((String)pkgName, (int)uid).visibility = visibility;
        this.updateConfig();
    }

    @Override
    public int getImportance(String packageName, int uid) {
        return this.getOrCreateRecord((String)packageName, (int)uid).importance;
    }

    @Override
    public void setImportance(String pkgName, int uid, int importance) {
        this.getOrCreateRecord((String)pkgName, (int)uid).importance = importance;
        this.updateConfig();
    }

    public void setEnabled(String packageName, int uid, boolean enabled) {
        boolean wasEnabled;
        boolean bl = wasEnabled = this.getImportance(packageName, uid) != 0;
        if (wasEnabled == enabled) {
            return;
        }
        this.setImportance(packageName, uid, enabled ? -1000 : 0);
    }

    public void dump(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter) {
        if (filter == null) {
            int N = this.mSignalExtractors.length;
            pw.print(prefix);
            pw.print("mSignalExtractors.length = ");
            pw.println(N);
            for (int i = 0; i < N; ++i) {
                pw.print(prefix);
                pw.print("  ");
                pw.println(this.mSignalExtractors[i]);
            }
        }
        if (filter == null) {
            pw.print(prefix);
            pw.println("per-package config:");
        }
        pw.println("Records:");
        RankingHelper.dumpRecords(pw, prefix, filter, this.mRecords);
        pw.println("Restored without uid:");
        RankingHelper.dumpRecords(pw, prefix, filter, this.mRestoredWithoutUids);
    }

    private static void dumpRecords(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter, ArrayMap<String, Record> records) {
        int N = records.size();
        for (int i = 0; i < N; ++i) {
            Record r = records.valueAt(i);
            if (filter != null && !filter.matches(r.pkg)) continue;
            pw.print(prefix);
            pw.print("  ");
            pw.print(r.pkg);
            pw.print(" (");
            pw.print(r.uid == Record.UNKNOWN_UID ? "UNKNOWN_UID" : Integer.toString(r.uid));
            pw.print(')');
            if (r.importance != -1000) {
                pw.print(" importance=");
                pw.print(NotificationListenerService.Ranking.importanceToString(r.importance));
            }
            if (r.priority != 0) {
                pw.print(" priority=");
                pw.print(Notification.priorityToString(r.priority));
            }
            if (r.visibility != -1000) {
                pw.print(" visibility=");
                pw.print(Notification.visibilityToString(r.visibility));
            }
            pw.println();
        }
    }

    public JSONObject dumpJson(NotificationManagerService.DumpFilter filter) {
        JSONObject ranking = new JSONObject();
        JSONArray records = new JSONArray();
        try {
            ranking.put("noUid", this.mRestoredWithoutUids.size());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        int N = this.mRecords.size();
        for (int i = 0; i < N; ++i) {
            Record r = this.mRecords.valueAt(i);
            if (filter != null && !filter.matches(r.pkg)) continue;
            JSONObject record = new JSONObject();
            try {
                record.put("userId", UserHandle.getUserId(r.uid));
                record.put("packageName", r.pkg);
                if (r.importance != -1000) {
                    record.put(ATT_IMPORTANCE, NotificationListenerService.Ranking.importanceToString(r.importance));
                }
                if (r.priority != 0) {
                    record.put(ATT_PRIORITY, Notification.priorityToString(r.priority));
                }
                if (r.visibility != -1000) {
                    record.put(ATT_VISIBILITY, Notification.visibilityToString(r.visibility));
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            records.put(record);
        }
        try {
            ranking.put("records", records);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return ranking;
    }

    public JSONArray dumpBansJson(NotificationManagerService.DumpFilter filter) {
        JSONArray bans = new JSONArray();
        Map<Integer, String> packageBans = this.getPackageBans();
        for (Map.Entry<Integer, String> ban : packageBans.entrySet()) {
            int userId = UserHandle.getUserId(ban.getKey());
            String packageName = ban.getValue();
            if (filter != null && !filter.matches(packageName)) continue;
            JSONObject banJson = new JSONObject();
            try {
                banJson.put("userId", userId);
                banJson.put("packageName", packageName);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            bans.put(banJson);
        }
        return bans;
    }

    public Map<Integer, String> getPackageBans() {
        int N = this.mRecords.size();
        ArrayMap<Integer, String> packageBans = new ArrayMap<Integer, String>(N);
        for (int i = 0; i < N; ++i) {
            Record r = this.mRecords.valueAt(i);
            if (r.importance != 0) continue;
            packageBans.put(r.uid, r.pkg);
        }
        return packageBans;
    }

    public void onPackagesChanged(boolean queryReplace, String[] pkgList) {
        if (queryReplace || pkgList == null || pkgList.length == 0 || this.mRestoredWithoutUids.isEmpty()) {
            return;
        }
        PackageManager pm = this.mContext.getPackageManager();
        boolean updated = false;
        for (String pkg : pkgList) {
            Record r = this.mRestoredWithoutUids.get(pkg);
            if (r == null) continue;
            try {
                r.uid = pm.getPackageUidAsUser(r.pkg, 0);
                this.mRestoredWithoutUids.remove(pkg);
                this.mRecords.put(RankingHelper.recordKey(r.pkg, r.uid), r);
                updated = true;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (updated) {
            this.updateConfig();
        }
    }

    private static class Record {
        static int UNKNOWN_UID = -10000;
        String pkg;
        int uid = UNKNOWN_UID;
        int importance = -1000;
        int priority = 0;
        int visibility = -1000;

        private Record() {
        }
    }
}

