/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.ServiceManager;
import android.util.ArraySet;
import com.android.server.pm.PackageManagerService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class BackgroundDexOptService
extends JobService {
    static final String TAG = "BackgroundDexOptService";
    static final long RETRY_LATENCY = 14400000L;
    static final int JOB_IDLE_OPTIMIZE = 800;
    static final int JOB_POST_BOOT_UPDATE = 801;
    private static ComponentName sDexoptServiceName = new ComponentName("android", BackgroundDexOptService.class.getName());
    static final ArraySet<String> sFailedPackageNames = new ArraySet();
    final AtomicBoolean mAbortPostBootUpdate = new AtomicBoolean(false);
    final AtomicBoolean mAbortIdleOptimization = new AtomicBoolean(false);
    final AtomicBoolean mExitPostBootUpdate = new AtomicBoolean(false);

    public static void schedule(Context context) {
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        js.schedule(new JobInfo.Builder(801, sDexoptServiceName).setMinimumLatency(TimeUnit.MINUTES.toMillis(1L)).setOverrideDeadline(TimeUnit.MINUTES.toMillis(1L)).build());
        js.schedule(new JobInfo.Builder(800, sDexoptServiceName).setRequiresDeviceIdle(true).setRequiresCharging(true).setPeriodic(TimeUnit.DAYS.toMillis(1L)).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyPackageChanged(String packageName) {
        ArraySet<String> arraySet = sFailedPackageNames;
        synchronized (arraySet) {
            sFailedPackageNames.remove(packageName);
        }
    }

    private int getBatteryLevel() {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = this.registerReceiver(null, filter);
        int level = intent.getIntExtra("level", -1);
        int scale = intent.getIntExtra("scale", -1);
        if (level < 0 || scale <= 0) {
            return 0;
        }
        return 100 * level / scale;
    }

    private boolean runPostBootUpdate(final JobParameters jobParams, final PackageManagerService pm, final ArraySet<String> pkgs) {
        if (this.mExitPostBootUpdate.get()) {
            return false;
        }
        final int lowBatteryThreshold = this.getResources().getInteger(17694800);
        this.mAbortPostBootUpdate.set(false);
        new Thread("BackgroundDexOptService_PostBootUpdate"){

            @Override
            public void run() {
                for (String pkg : pkgs) {
                    if (BackgroundDexOptService.this.mAbortPostBootUpdate.get()) {
                        return;
                    }
                    if (BackgroundDexOptService.this.mExitPostBootUpdate.get() || BackgroundDexOptService.this.getBatteryLevel() < lowBatteryThreshold) break;
                    pm.performDexOpt(pkg, false, 1, false);
                }
                BackgroundDexOptService.this.jobFinished(jobParams, false);
            }
        }.start();
        return true;
    }

    private boolean runIdleOptimization(final JobParameters jobParams, final PackageManagerService pm, final ArraySet<String> pkgs) {
        this.mExitPostBootUpdate.set(true);
        this.mAbortIdleOptimization.set(false);
        new Thread("BackgroundDexOptService_IdleOptimization"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (String pkg : pkgs) {
                    if (BackgroundDexOptService.this.mAbortIdleOptimization.get()) {
                        return;
                    }
                    if (sFailedPackageNames.contains(pkg)) continue;
                    ArraySet<String> arraySet = sFailedPackageNames;
                    synchronized (arraySet) {
                        sFailedPackageNames.add(pkg);
                    }
                    if (!pm.performDexOpt(pkg, true, 3, false)) continue;
                    arraySet = sFailedPackageNames;
                    synchronized (arraySet) {
                        sFailedPackageNames.remove(pkg);
                    }
                }
                BackgroundDexOptService.this.jobFinished(jobParams, false);
            }
        }.start();
        return true;
    }

    @Override
    public boolean onStartJob(JobParameters params) {
        PackageManagerService pm = (PackageManagerService)ServiceManager.getService("package");
        if (pm.isStorageLow()) {
            return false;
        }
        ArraySet<String> pkgs = pm.getOptimizablePackages();
        if (pkgs == null || pkgs.isEmpty()) {
            return false;
        }
        if (params.getJobId() == 801) {
            return this.runPostBootUpdate(params, pm, pkgs);
        }
        return this.runIdleOptimization(params, pm, pkgs);
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        if (params.getJobId() == 801) {
            this.mAbortPostBootUpdate.set(true);
        } else {
            this.mAbortIdleOptimization.set(true);
        }
        return false;
    }
}

