/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.EphemeralApplicationInfo;
import android.content.pm.PackageParser;
import android.content.pm.PackageUserState;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Binder;
import android.os.Environment;
import android.provider.Settings;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageSetting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class EphemeralApplicationRegistry {
    private static final boolean DEBUG = false;
    private static final boolean ENABLED = false;
    private static final String LOG_TAG = "EphemeralAppRegistry";
    private static final long DEFAULT_UNINSTALLED_EPHEMERAL_APP_CACHE_DURATION_MILLIS = 2592000000L;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final String EPHEMERAL_APPS_FOLDER = "ephemeral";
    private static final String EPHEMERAL_APP_ICON_FILE = "icon.png";
    private static final String EPHEMERAL_APP_COOKIE_FILE_PREFIX = "cookie_";
    private static final String EPHEMERAL_APP_COOKIE_FILE_SIFFIX = ".dat";
    private static final String EPHEMERAL_APP_METADATA_FILE = "metadata.xml";
    private static final String TAG_PACKAGE = "package";
    private static final String TAG_PERMS = "perms";
    private static final String TAG_PERM = "perm";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_GRANTED = "granted";
    private final PackageManagerService mService;
    @GuardedBy(value="mService.mPackages")
    private SparseArray<List<UninstalledEphemeralAppState>> mUninstalledEphemeralApps;

    public EphemeralApplicationRegistry(PackageManagerService service) {
        this.mService = service;
    }

    public byte[] getEphemeralApplicationCookieLPw(String packageName, int userId) {
        return EmptyArray.BYTE;
    }

    public boolean setEphemeralApplicationCookieLPw(String packageName, byte[] cookie, int userId) {
        return false;
    }

    public Bitmap getEphemeralApplicationIconLPw(String packageName, int userId) {
        return null;
    }

    public List<EphemeralApplicationInfo> getEphemeralApplicationsLPw(int userId) {
        return Collections.emptyList();
    }

    public void onPackageInstalledLPw(PackageParser.Package pkg) {
    }

    public void onPackageUninstalledLPw(PackageParser.Package pkg) {
    }

    public void onUserRemovedLPw(int userId) {
    }

    private void addUninstalledEphemeralAppLPw(PackageParser.Package pkg, int userId) {
        List<UninstalledEphemeralAppState> uninstalledAppStates;
        EphemeralApplicationInfo uninstalledApp = this.createEphemeralAppInfoForPackage(pkg, userId);
        if (uninstalledApp == null) {
            return;
        }
        if (this.mUninstalledEphemeralApps == null) {
            this.mUninstalledEphemeralApps = new SparseArray();
        }
        if ((uninstalledAppStates = this.mUninstalledEphemeralApps.get(userId)) == null) {
            uninstalledAppStates = new ArrayList<UninstalledEphemeralAppState>();
            this.mUninstalledEphemeralApps.put(userId, uninstalledAppStates);
        }
        UninstalledEphemeralAppState uninstalledAppState = new UninstalledEphemeralAppState(uninstalledApp, System.currentTimeMillis());
        uninstalledAppStates.add(uninstalledAppState);
        this.writeUninstalledEphemeralAppMetadata(uninstalledApp, userId);
        this.writeEphemeralApplicationIconLPw(pkg, userId);
    }

    private void writeEphemeralApplicationIconLPw(PackageParser.Package pkg, int userId) {
        Bitmap bitmap;
        File appDir = EphemeralApplicationRegistry.getEphemeralApplicationDir(pkg.packageName, userId);
        if (!appDir.exists()) {
            return;
        }
        Drawable icon = pkg.applicationInfo.loadIcon(this.mService.mContext.getPackageManager());
        if (icon instanceof BitmapDrawable) {
            bitmap = ((BitmapDrawable)icon).getBitmap();
        } else {
            bitmap = Bitmap.createBitmap(icon.getIntrinsicWidth(), icon.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            icon.draw(canvas);
        }
        File iconFile = new File(EphemeralApplicationRegistry.getEphemeralApplicationDir(pkg.packageName, userId), EPHEMERAL_APP_ICON_FILE);
        try (FileOutputStream out = new FileOutputStream(iconFile);){
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, out);
        }
        catch (Exception e) {
            Slog.e(LOG_TAG, "Error writing ephemeral app icon", e);
        }
    }

    private void pruneUninstalledEphemeralAppsLPw(int userId) {
        File ephemeralAppsDir;
        List<UninstalledEphemeralAppState> uninstalledAppStates;
        long maxCacheDurationMillis = Settings.Global.getLong(this.mService.mContext.getContentResolver(), "uninstalled_ephemeral_app_cache_duration_millis", 2592000000L);
        if (this.mUninstalledEphemeralApps != null && (uninstalledAppStates = this.mUninstalledEphemeralApps.get(userId)) != null) {
            int appCount = uninstalledAppStates.size();
            for (int j = appCount - 1; j >= 0; --j) {
                UninstalledEphemeralAppState uninstalledAppState = uninstalledAppStates.get(j);
                long elapsedCachingMillis = System.currentTimeMillis() - uninstalledAppState.mTimestamp;
                if (elapsedCachingMillis <= maxCacheDurationMillis) continue;
                uninstalledAppStates.remove(j);
            }
            if (uninstalledAppStates.isEmpty()) {
                this.mUninstalledEphemeralApps.remove(userId);
            }
        }
        if (!(ephemeralAppsDir = EphemeralApplicationRegistry.getEphemeralApplicationsDir(userId)).exists()) {
            return;
        }
        File[] files = ephemeralAppsDir.listFiles();
        if (files == null) {
            return;
        }
        for (File ephemeralDir : files) {
            long elapsedCachingMillis;
            File metadataFile;
            if (!ephemeralDir.isDirectory() || !(metadataFile = new File(ephemeralDir, EPHEMERAL_APP_METADATA_FILE)).exists() || (elapsedCachingMillis = System.currentTimeMillis() - metadataFile.lastModified()) <= maxCacheDurationMillis) continue;
            EphemeralApplicationRegistry.deleteDir(ephemeralDir);
        }
    }

    private List<EphemeralApplicationInfo> getInstalledEphemeralApplicationsLPr(int userId) {
        ArrayList<EphemeralApplicationInfo> result = null;
        int packageCount = this.mService.mPackages.size();
        for (int i = 0; i < packageCount; ++i) {
            EphemeralApplicationInfo info;
            PackageParser.Package pkg = this.mService.mPackages.valueAt(i);
            if (!pkg.applicationInfo.isEphemeralApp() || (info = this.createEphemeralAppInfoForPackage(pkg, userId)) == null) continue;
            if (result == null) {
                result = new ArrayList<EphemeralApplicationInfo>();
            }
            result.add(info);
        }
        return result;
    }

    private EphemeralApplicationInfo createEphemeralAppInfoForPackage(PackageParser.Package pkg, int userId) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return null;
        }
        PackageUserState userState = ps.readUserState(userId);
        if (userState == null || !userState.installed || userState.hidden) {
            return null;
        }
        String[] requestedPermissions = new String[pkg.requestedPermissions.size()];
        pkg.requestedPermissions.toArray(requestedPermissions);
        Set<String> permissions = ps.getPermissionsState().getPermissions(userId);
        String[] grantedPermissions = new String[permissions.size()];
        permissions.toArray(grantedPermissions);
        return new EphemeralApplicationInfo(pkg.applicationInfo, requestedPermissions, grantedPermissions);
    }

    private List<EphemeralApplicationInfo> getUninstalledEphemeralApplicationsLPr(int userId) {
        List<UninstalledEphemeralAppState> uninstalledAppStates = this.getUninstalledEphemeralAppStatesLPr(userId);
        if (uninstalledAppStates == null || uninstalledAppStates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EphemeralApplicationInfo> uninstalledApps = new ArrayList<EphemeralApplicationInfo>();
        int stateCount = uninstalledAppStates.size();
        for (int i = 0; i < stateCount; ++i) {
            UninstalledEphemeralAppState uninstalledAppState = uninstalledAppStates.get(i);
            uninstalledApps.add(uninstalledAppState.mEphemeralApplicationInfo);
        }
        return uninstalledApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateEphemeralAppPermissionsIfNeeded(PackageParser.Package pkg, int userId) {
        EphemeralApplicationInfo appInfo = this.getOrParseUninstalledEphemeralAppInfo(pkg.packageName, userId);
        if (appInfo == null) {
            return;
        }
        if (ArrayUtils.isEmpty(appInfo.getGrantedPermissions())) {
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            for (String grantedPermission : appInfo.getGrantedPermissions()) {
                this.mService.grantRuntimePermission(pkg.packageName, grantedPermission, userId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private EphemeralApplicationInfo getOrParseUninstalledEphemeralAppInfo(String packageName, int userId) {
        File metadataFile;
        UninstalledEphemeralAppState uninstalledAppState;
        List<UninstalledEphemeralAppState> uninstalledAppStates;
        if (this.mUninstalledEphemeralApps != null && (uninstalledAppStates = this.mUninstalledEphemeralApps.get(userId)) != null) {
            int appCount = uninstalledAppStates.size();
            for (int i = 0; i < appCount; ++i) {
                UninstalledEphemeralAppState uninstalledAppState2 = uninstalledAppStates.get(i);
                if (!uninstalledAppState2.mEphemeralApplicationInfo.getPackageName().equals(packageName)) continue;
                return uninstalledAppState2.mEphemeralApplicationInfo;
            }
        }
        if ((uninstalledAppState = EphemeralApplicationRegistry.parseMetadataFile(metadataFile = new File(EphemeralApplicationRegistry.getEphemeralApplicationDir(packageName, userId), EPHEMERAL_APP_METADATA_FILE))) == null) {
            return null;
        }
        return uninstalledAppState.mEphemeralApplicationInfo;
    }

    private List<UninstalledEphemeralAppState> getUninstalledEphemeralAppStatesLPr(int userId) {
        File[] files;
        List<UninstalledEphemeralAppState> uninstalledAppStates = null;
        if (this.mUninstalledEphemeralApps != null && (uninstalledAppStates = this.mUninstalledEphemeralApps.get(userId)) != null) {
            return uninstalledAppStates;
        }
        File ephemeralAppsDir = EphemeralApplicationRegistry.getEphemeralApplicationsDir(userId);
        if (ephemeralAppsDir.exists() && (files = ephemeralAppsDir.listFiles()) != null) {
            for (File ephemeralDir : files) {
                File metadataFile;
                UninstalledEphemeralAppState uninstalledAppState;
                if (!ephemeralDir.isDirectory() || (uninstalledAppState = EphemeralApplicationRegistry.parseMetadataFile(metadataFile = new File(ephemeralDir, EPHEMERAL_APP_METADATA_FILE))) == null) continue;
                if (uninstalledAppStates == null) {
                    uninstalledAppStates = new ArrayList<UninstalledEphemeralAppState>();
                }
                uninstalledAppStates.add(uninstalledAppState);
            }
        }
        if (uninstalledAppStates != null) {
            if (this.mUninstalledEphemeralApps == null) {
                this.mUninstalledEphemeralApps = new SparseArray();
            }
            this.mUninstalledEphemeralApps.put(userId, uninstalledAppStates);
        }
        return uninstalledAppStates;
    }

    private static boolean isValidCookie(Context context, byte[] cookie) {
        if (ArrayUtils.isEmpty(cookie)) {
            return true;
        }
        return cookie.length <= context.getPackageManager().getEphemeralCookieMaxSizeBytes();
    }

    private static UninstalledEphemeralAppState parseMetadataFile(File metadataFile) {
        FileInputStream in;
        if (!metadataFile.exists()) {
            return null;
        }
        try {
            in = new AtomicFile(metadataFile).openRead();
        }
        catch (FileNotFoundException fnfe) {
            Slog.i(LOG_TAG, "No ephemeral metadata file");
            return null;
        }
        File ephemeralDir = metadataFile.getParentFile();
        long timestamp = metadataFile.lastModified();
        String packageName = ephemeralDir.getName();
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(in, StandardCharsets.UTF_8.name());
            UninstalledEphemeralAppState uninstalledEphemeralAppState = new UninstalledEphemeralAppState(EphemeralApplicationRegistry.parseMetadata(parser, packageName), timestamp);
            return uninstalledEphemeralAppState;
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalStateException("Failed parsing ephemeral metadata file: " + metadataFile, e);
        }
        finally {
            IoUtils.closeQuietly(in);
        }
    }

    private static File computeEphemeralCookieFile(PackageParser.Package pkg, int userId) {
        File appDir = EphemeralApplicationRegistry.getEphemeralApplicationDir(pkg.packageName, userId);
        String cookieFile = EPHEMERAL_APP_COOKIE_FILE_PREFIX + EphemeralApplicationRegistry.computePackageCertDigest(pkg) + EPHEMERAL_APP_COOKIE_FILE_SIFFIX;
        return new File(appDir, cookieFile);
    }

    private static File peekEphemeralCookieFile(String packageName, int userId) {
        File appDir = EphemeralApplicationRegistry.getEphemeralApplicationDir(packageName, userId);
        if (!appDir.exists()) {
            return null;
        }
        for (File file : appDir.listFiles()) {
            if (file.isDirectory() || !file.getName().startsWith(EPHEMERAL_APP_COOKIE_FILE_PREFIX) || !file.getName().endsWith(EPHEMERAL_APP_COOKIE_FILE_SIFFIX)) continue;
            return file;
        }
        return null;
    }

    private static EphemeralApplicationInfo parseMetadata(XmlPullParser parser, String packageName) throws IOException, XmlPullParserException {
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!TAG_PACKAGE.equals(parser.getName())) continue;
            return EphemeralApplicationRegistry.parsePackage(parser, packageName);
        }
        return null;
    }

    private static EphemeralApplicationInfo parsePackage(XmlPullParser parser, String packageName) throws IOException, XmlPullParserException {
        String label = parser.getAttributeValue(null, ATTR_LABEL);
        ArrayList<String> outRequestedPermissions = new ArrayList<String>();
        ArrayList<String> outGrantedPermissions = new ArrayList<String>();
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!TAG_PERMS.equals(parser.getName())) continue;
            EphemeralApplicationRegistry.parsePermissions(parser, outRequestedPermissions, outGrantedPermissions);
        }
        String[] requestedPermissions = new String[outRequestedPermissions.size()];
        outRequestedPermissions.toArray(requestedPermissions);
        String[] grantedPermissions = new String[outGrantedPermissions.size()];
        outGrantedPermissions.toArray(grantedPermissions);
        return new EphemeralApplicationInfo(packageName, label, requestedPermissions, grantedPermissions);
    }

    private static void parsePermissions(XmlPullParser parser, List<String> outRequestedPermissions, List<String> outGrantedPermissions) throws IOException, XmlPullParserException {
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!TAG_PERM.equals(parser.getName())) continue;
            String permission2 = XmlUtils.readStringAttribute(parser, ATTR_NAME);
            outRequestedPermissions.add(permission2);
            if (!XmlUtils.readBooleanAttribute(parser, ATTR_GRANTED)) continue;
            outGrantedPermissions.add(permission2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUninstalledEphemeralAppMetadata(EphemeralApplicationInfo ephemeralApp, int userId) {
        File appDir = EphemeralApplicationRegistry.getEphemeralApplicationDir(ephemeralApp.getPackageName(), userId);
        if (!appDir.exists() && !appDir.mkdirs()) {
            return;
        }
        File metadataFile = new File(appDir, EPHEMERAL_APP_METADATA_FILE);
        AtomicFile destination = new AtomicFile(metadataFile);
        FileOutputStream out = null;
        try {
            out = destination.startWrite();
            XmlSerializer serializer = Xml.newSerializer();
            serializer.setOutput(out, StandardCharsets.UTF_8.name());
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_PACKAGE);
            serializer.attribute(null, ATTR_LABEL, ephemeralApp.loadLabel(this.mService.mContext.getPackageManager()).toString());
            serializer.startTag(null, TAG_PERMS);
            for (String permission2 : ephemeralApp.getRequestedPermissions()) {
                serializer.startTag(null, TAG_PERM);
                serializer.attribute(null, ATTR_NAME, permission2);
                if (ArrayUtils.contains(ephemeralApp.getGrantedPermissions(), permission2)) {
                    serializer.attribute(null, ATTR_GRANTED, String.valueOf(true));
                }
                serializer.endTag(null, TAG_PERM);
            }
            serializer.endTag(null, TAG_PERMS);
            serializer.endTag(null, TAG_PACKAGE);
            serializer.endDocument();
            destination.finishWrite(out);
        }
        catch (Throwable t) {
            Slog.wtf(LOG_TAG, "Failed to write ephemeral state, restoring backup", t);
            destination.failWrite(out);
        }
        finally {
            IoUtils.closeQuietly(out);
        }
    }

    private static String computePackageCertDigest(PackageParser.Package pkg) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        messageDigest.update(pkg.mSignatures[0].toByteArray());
        byte[] digest = messageDigest.digest();
        int digestLength = digest.length;
        int charCount = 2 * digestLength;
        char[] chars = new char[charCount];
        for (int i = 0; i < digestLength; ++i) {
            int byteHex = digest[i] & 0xFF;
            chars[i * 2] = HEX_ARRAY[byteHex >>> 4];
            chars[i * 2 + 1] = HEX_ARRAY[byteHex & 0xF];
        }
        return new String(chars);
    }

    private static File getEphemeralApplicationsDir(int userId) {
        return new File(Environment.getUserSystemDirectory(userId), EPHEMERAL_APPS_FOLDER);
    }

    private static File getEphemeralApplicationDir(String packageName, int userId) {
        return new File(EphemeralApplicationRegistry.getEphemeralApplicationsDir(userId), packageName);
    }

    private static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : dir.listFiles()) {
                EphemeralApplicationRegistry.deleteDir(file);
            }
        }
        dir.delete();
    }

    private static final class UninstalledEphemeralAppState {
        final EphemeralApplicationInfo mEphemeralApplicationInfo;
        final long mTimestamp;

        public UninstalledEphemeralAppState(EphemeralApplicationInfo ephemeralApp, long timestamp) {
            this.mEphemeralApplicationInfo = ephemeralApp;
            this.mTimestamp = timestamp;
        }
    }
}

