/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.util.ArraySet;
import android.util.Slog;
import java.util.ArrayList;

public class IntentFilterVerificationState {
    static final String TAG = IntentFilterVerificationState.class.getName();
    public static final int STATE_UNDEFINED = 0;
    public static final int STATE_VERIFICATION_PENDING = 1;
    public static final int STATE_VERIFICATION_SUCCESS = 2;
    public static final int STATE_VERIFICATION_FAILURE = 3;
    private int mRequiredVerifierUid = 0;
    private int mState;
    private ArrayList<PackageParser.ActivityIntentInfo> mFilters = new ArrayList();
    private ArraySet<String> mHosts = new ArraySet();
    private int mUserId;
    private String mPackageName;
    private boolean mVerificationComplete;

    public IntentFilterVerificationState(int verifierUid, int userId, String packageName) {
        this.mRequiredVerifierUid = verifierUid;
        this.mUserId = userId;
        this.mPackageName = packageName;
        this.mState = 0;
        this.mVerificationComplete = false;
    }

    public void setState(int state) {
        this.mState = state > 3 || state < 0 ? 0 : state;
    }

    public int getState() {
        return this.mState;
    }

    public void setPendingState() {
        this.setState(1);
    }

    public ArrayList<PackageParser.ActivityIntentInfo> getFilters() {
        return this.mFilters;
    }

    public boolean isVerificationComplete() {
        return this.mVerificationComplete;
    }

    public boolean isVerified() {
        if (this.mVerificationComplete) {
            return this.mState == 2;
        }
        return false;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getHostsString() {
        StringBuilder sb = new StringBuilder();
        int count = this.mHosts.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.mHosts.valueAt(i));
        }
        return sb.toString();
    }

    public boolean setVerifierResponse(int callerUid, int code) {
        if (this.mRequiredVerifierUid == callerUid) {
            int state = 0;
            if (code == 1) {
                state = 2;
            } else if (code == -1) {
                state = 3;
            }
            this.mVerificationComplete = true;
            this.setState(state);
            return true;
        }
        Slog.d(TAG, "Cannot set verifier response with callerUid:" + callerUid + " and code:" + code + " as required verifierUid is:" + this.mRequiredVerifierUid);
        return false;
    }

    public void addFilter(PackageParser.ActivityIntentInfo filter) {
        this.mFilters.add(filter);
        this.mHosts.addAll(filter.getHostsList());
    }
}

