/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.IOtaDexopt;
import android.content.pm.PackageParser;
import android.os.Environment;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.storage.StorageManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import com.android.internal.os.InstallerConnection;
import com.android.server.pm.Installer;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.OtaDexoptShellCommand;
import com.android.server.pm.PackageDexOptimizer;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageManagerServiceCompilerMapping;
import com.android.server.pm.PackageManagerServiceUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.util.Collection;
import java.util.List;

public class OtaDexoptService
extends IOtaDexopt.Stub {
    private static final String TAG = "OTADexopt";
    private static final boolean DEBUG_DEXOPT = true;
    private final Context mContext;
    private final PackageDexOptimizer mPackageDexOptimizer;
    private final PackageManagerService mPackageManagerService;
    private List<PackageParser.Package> mDexoptPackages;

    public OtaDexoptService(Context context, PackageManagerService packageManagerService) {
        this.mContext = context;
        this.mPackageManagerService = packageManagerService;
        this.mPackageDexOptimizer = new OTADexoptPackageDexOptimizer(packageManagerService.mInstaller, packageManagerService.mInstallLock, context);
        this.moveAbArtifacts(packageManagerService.mInstaller);
    }

    public static OtaDexoptService main(Context context, PackageManagerService packageManagerService) {
        OtaDexoptService ota = new OtaDexoptService(context, packageManagerService);
        ServiceManager.addService("otadexopt", ota);
        return ota;
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ResultReceiver resultReceiver) throws RemoteException {
        new OtaDexoptShellCommand(this).exec(this, in, out, err, args, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void prepare() throws RemoteException {
        if (this.mDexoptPackages != null) {
            throw new IllegalStateException("already called prepare()");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackageManagerService.mPackages;
        synchronized (arrayMap) {
            this.mDexoptPackages = PackageManagerServiceUtils.getPackagesForDexopt(this.mPackageManagerService.mPackages.values(), this.mPackageManagerService);
        }
    }

    @Override
    public synchronized void cleanup() throws RemoteException {
        Log.i(TAG, "Cleaning up OTA Dexopt state.");
        this.mDexoptPackages = null;
    }

    @Override
    public synchronized boolean isDone() throws RemoteException {
        if (this.mDexoptPackages == null) {
            throw new IllegalStateException("done() called before prepare()");
        }
        return this.mDexoptPackages.isEmpty();
    }

    @Override
    public synchronized void dexoptNextPackage() throws RemoteException {
        if (this.mDexoptPackages == null) {
            throw new IllegalStateException("dexoptNextPackage() called before prepare()");
        }
        if (this.mDexoptPackages.isEmpty()) {
            return;
        }
        PackageParser.Package nextPackage = this.mDexoptPackages.remove(0);
        Log.i(TAG, "Processing " + nextPackage.packageName + " for OTA dexopt.");
        File dataDir = Environment.getDataDirectory();
        long lowThreshold = StorageManager.from(this.mContext).getStorageLowBytes(dataDir);
        if (lowThreshold == 0L) {
            throw new IllegalStateException("Invalid low memory threshold");
        }
        long usableSpace = dataDir.getUsableSpace();
        if (usableSpace < lowThreshold) {
            Log.w(TAG, "Not running dexopt on " + nextPackage.packageName + " due to low memory: " + usableSpace);
            return;
        }
        this.mPackageDexOptimizer.performDexOpt(nextPackage, nextPackage.usesLibraryFiles, null, false, PackageManagerServiceCompilerMapping.getCompilerFilterForReason(4));
    }

    private void moveAbArtifacts(Installer installer) {
        if (this.mDexoptPackages != null) {
            throw new IllegalStateException("Should not be ota-dexopting when trying to move.");
        }
        Collection<PackageParser.Package> pkgs = this.mPackageManagerService.getPackages();
        for (PackageParser.Package pkg : pkgs) {
            String[] dexCodeInstructionSets;
            if (pkg == null || !PackageDexOptimizer.canOptimizePackage(pkg)) continue;
            if (pkg.codePath == null) {
                Slog.w(TAG, "Package " + pkg + " can be optimized but has null codePath");
                continue;
            }
            if (pkg.codePath.startsWith("/system") || pkg.codePath.startsWith("/vendor")) continue;
            String[] instructionSets = InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
            List<String> paths = pkg.getAllCodePathsExcludingResourceOnly();
            for (String dexCodeInstructionSet : dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets)) {
                for (String path : paths) {
                    String oatDir = PackageDexOptimizer.getOatDir(new File(pkg.codePath)).getAbsolutePath();
                    try {
                        installer.moveAb(path, dexCodeInstructionSet, oatDir);
                    }
                    catch (InstallerConnection.InstallerException installerException) {}
                }
            }
        }
    }

    private static class OTADexoptPackageDexOptimizer
    extends PackageDexOptimizer.ForcedUpdatePackageDexOptimizer {
        public OTADexoptPackageDexOptimizer(Installer installer, Object installLock, Context context) {
            super(installer, installLock, context, "*otadexopt*");
        }

        @Override
        protected int adjustDexoptFlags(int dexoptFlags) {
            return dexoptFlags | 0x40;
        }
    }
}

