/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ShortcutInfo;
import android.os.PersistableBundle;
import android.text.format.Formatter;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.util.XmlUtils;
import com.android.server.pm.ShortcutPackageInfo;
import com.android.server.pm.ShortcutPackageItem;
import com.android.server.pm.ShortcutService;
import com.android.server.pm.ShortcutUser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class ShortcutPackage
extends ShortcutPackageItem {
    private static final String TAG = "ShortcutService";
    static final String TAG_ROOT = "package";
    private static final String TAG_INTENT_EXTRAS = "intent-extras";
    private static final String TAG_EXTRAS = "extras";
    private static final String TAG_SHORTCUT = "shortcut";
    private static final String TAG_CATEGORIES = "categories";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DYNAMIC_COUNT = "dynamic-count";
    private static final String ATTR_CALL_COUNT = "call-count";
    private static final String ATTR_LAST_RESET = "last-reset";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ACTIVITY = "activity";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TEXT = "text";
    private static final String ATTR_INTENT = "intent";
    private static final String ATTR_WEIGHT = "weight";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_FLAGS = "flags";
    private static final String ATTR_ICON_RES = "icon-res";
    private static final String ATTR_BITMAP_PATH = "bitmap-path";
    private static final String NAME_CATEGORIES = "categories";
    private static final String TAG_STRING_ARRAY_XMLUTILS = "string-array";
    private static final String ATTR_NAME_XMLUTILS = "name";
    private final ArrayMap<String, ShortcutInfo> mShortcuts = new ArrayMap();
    private int mDynamicShortcutCount = 0;
    private int mApiCallCount;
    private long mLastResetTime;
    private final int mPackageUid;
    private long mLastKnownForegroundElapsedTime;

    private ShortcutPackage(ShortcutService s, ShortcutUser shortcutUser, int packageUserId, String packageName, ShortcutPackageInfo spi) {
        super(shortcutUser, packageUserId, packageName, spi != null ? spi : ShortcutPackageInfo.newEmpty());
        this.mPackageUid = s.injectGetPackageUid(packageName, packageUserId);
    }

    public ShortcutPackage(ShortcutService s, ShortcutUser shortcutUser, int packageUserId, String packageName) {
        this(s, shortcutUser, packageUserId, packageName, null);
    }

    @Override
    public int getOwnerUserId() {
        return this.getPackageUserId();
    }

    public int getPackageUid() {
        return this.mPackageUid;
    }

    private void onShortcutPublish(ShortcutService s) {
        int versionCode;
        if (this.getPackageInfo().getVersionCode() < 0 && (versionCode = s.getApplicationVersionCode(this.getPackageName(), this.getOwnerUserId())) >= 0) {
            this.getPackageInfo().setVersionCode(versionCode);
            s.scheduleSaveUser(this.getOwnerUserId());
        }
    }

    @Override
    protected void onRestoreBlocked(ShortcutService s) {
        this.mShortcuts.clear();
    }

    @Override
    protected void onRestored(ShortcutService s) {
        this.refreshPinnedFlags(s);
    }

    public ShortcutInfo findShortcutById(String id2) {
        return this.mShortcuts.get(id2);
    }

    private ShortcutInfo deleteShortcut(ShortcutService s, String id2) {
        ShortcutInfo shortcut = this.mShortcuts.remove(id2);
        if (shortcut != null) {
            s.removeIcon(this.getPackageUserId(), shortcut);
            shortcut.clearFlags(3);
        }
        return shortcut;
    }

    void addShortcut(ShortcutService s, ShortcutInfo newShortcut) {
        this.deleteShortcut(s, newShortcut.getId());
        s.saveIconAndFixUpShortcut(this.getPackageUserId(), newShortcut);
        this.mShortcuts.put(newShortcut.getId(), newShortcut);
    }

    public void addDynamicShortcut(ShortcutService s, ShortcutInfo newShortcut) {
        int newDynamicCount;
        boolean wasPinned;
        this.onShortcutPublish(s);
        newShortcut.addFlags(1);
        ShortcutInfo oldShortcut = this.mShortcuts.get(newShortcut.getId());
        if (oldShortcut == null) {
            wasPinned = false;
            newDynamicCount = this.mDynamicShortcutCount + 1;
        } else {
            wasPinned = oldShortcut.isPinned();
            newDynamicCount = oldShortcut.isDynamic() ? this.mDynamicShortcutCount : this.mDynamicShortcutCount + 1;
        }
        s.enforceMaxDynamicShortcuts(newDynamicCount);
        if (wasPinned) {
            newShortcut.addFlags(2);
        }
        this.addShortcut(s, newShortcut);
        this.mDynamicShortcutCount = newDynamicCount;
    }

    private void removeOrphans(ShortcutService s) {
        int i;
        ArrayList<String> removeList = null;
        for (i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            if (si.isPinned() || si.isDynamic()) continue;
            if (removeList == null) {
                removeList = new ArrayList<String>();
            }
            removeList.add(si.getId());
        }
        if (removeList != null) {
            for (i = removeList.size() - 1; i >= 0; --i) {
                this.deleteShortcut(s, (String)removeList.get(i));
            }
        }
    }

    public void deleteAllDynamicShortcuts(ShortcutService s) {
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            this.mShortcuts.valueAt(i).clearFlags(1);
        }
        this.removeOrphans(s);
        this.mDynamicShortcutCount = 0;
    }

    public void deleteDynamicWithId(ShortcutService s, String shortcutId) {
        ShortcutInfo oldShortcut = this.mShortcuts.get(shortcutId);
        if (oldShortcut == null) {
            return;
        }
        if (oldShortcut.isDynamic()) {
            --this.mDynamicShortcutCount;
        }
        if (oldShortcut.isPinned()) {
            oldShortcut.clearFlags(1);
        } else {
            this.deleteShortcut(s, shortcutId);
        }
    }

    public void refreshPinnedFlags(ShortcutService s) {
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            this.mShortcuts.valueAt(i).clearFlags(2);
        }
        s.getUserShortcutsLocked(this.getPackageUserId()).forAllLaunchers(launcherShortcuts -> {
            ArraySet<String> pinned = launcherShortcuts.getPinnedShortcutIds(this.getPackageName(), this.getPackageUserId());
            if (pinned == null || pinned.size() == 0) {
                return;
            }
            for (int i = pinned.size() - 1; i >= 0; --i) {
                String id2 = pinned.valueAt(i);
                ShortcutInfo si = this.mShortcuts.get(id2);
                if (si == null) continue;
                si.addFlags(2);
            }
        });
        this.removeOrphans(s);
    }

    public int getApiCallCount(ShortcutService s) {
        this.mShortcutUser.resetThrottlingIfNeeded(s);
        if (s.isUidForegroundLocked(this.mPackageUid) || this.mLastKnownForegroundElapsedTime < s.getUidLastForegroundElapsedTimeLocked(this.mPackageUid)) {
            this.mLastKnownForegroundElapsedTime = s.injectElapsedRealtime();
            this.resetRateLimiting(s);
        }
        long last = s.getLastResetTimeLocked();
        long now = s.injectCurrentTimeMillis();
        if (ShortcutService.isClockValid(now) && this.mLastResetTime > now) {
            Slog.w(TAG, "Clock rewound");
            this.mLastResetTime = now;
            this.mApiCallCount = 0;
            return this.mApiCallCount;
        }
        if (this.mLastResetTime < last) {
            this.mApiCallCount = 0;
            this.mLastResetTime = last;
        }
        return this.mApiCallCount;
    }

    public boolean tryApiCall(ShortcutService s) {
        if (this.getApiCallCount(s) >= s.mMaxUpdatesPerInterval) {
            return false;
        }
        ++this.mApiCallCount;
        s.scheduleSaveUser(this.getOwnerUserId());
        return true;
    }

    public void resetRateLimiting(ShortcutService s) {
        if (this.mApiCallCount > 0) {
            this.mApiCallCount = 0;
            s.scheduleSaveUser(this.getOwnerUserId());
        }
    }

    public void resetRateLimitingForCommandLineNoSaving() {
        this.mApiCallCount = 0;
        this.mLastResetTime = 0L;
    }

    public void findAll(ShortcutService s, List<ShortcutInfo> result, Predicate<ShortcutInfo> query, int cloneFlag) {
        this.findAll(s, result, query, cloneFlag, null, 0);
    }

    public void findAll(ShortcutService s, List<ShortcutInfo> result, Predicate<ShortcutInfo> query, int cloneFlag, String callingLauncher, int launcherUserId) {
        if (this.getPackageInfo().isShadow()) {
            return;
        }
        ArraySet<String> pinnedByCallerSet = callingLauncher == null ? null : s.getLauncherShortcutsLocked(callingLauncher, this.getPackageUserId(), launcherUserId).getPinnedShortcutIds(this.getPackageName(), this.getPackageUserId());
        for (int i = 0; i < this.mShortcuts.size(); ++i) {
            boolean isPinnedByCaller;
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            boolean bl = isPinnedByCaller = callingLauncher == null || pinnedByCallerSet != null && pinnedByCallerSet.contains(si.getId());
            if (!si.isDynamic()) {
                if (!si.isPinned()) {
                    s.wtf("Shortcut not pinned: package " + this.getPackageName() + ", user=" + this.getPackageUserId() + ", id=" + si.getId());
                    continue;
                }
                if (!isPinnedByCaller) continue;
            }
            ShortcutInfo clone = si.clone(cloneFlag);
            if (!isPinnedByCaller) {
                clone.clearFlags(2);
            }
            if (query != null && !query.test(clone)) continue;
            result.add(clone);
        }
    }

    public void resetThrottling() {
        this.mApiCallCount = 0;
    }

    public void handlePackageUpdated(ShortcutService s, int newVersionCode) {
        if (this.getPackageInfo().getVersionCode() >= newVersionCode) {
            return;
        }
        this.getPackageInfo().setVersionCode(newVersionCode);
        boolean changed = false;
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            if (!si.hasIconResource()) continue;
            changed = true;
            si.setTimestamp(s.injectCurrentTimeMillis());
        }
        if (changed) {
            s.packageShortcutsChanged(this.getPackageName(), this.getPackageUserId());
        } else {
            s.scheduleSaveUser(this.getPackageUserId());
        }
    }

    public void dump(ShortcutService s, PrintWriter pw, String prefix) {
        pw.println();
        pw.print(prefix);
        pw.print("Package: ");
        pw.print(this.getPackageName());
        pw.print("  UID: ");
        pw.print(this.mPackageUid);
        pw.println();
        pw.print(prefix);
        pw.print("  ");
        pw.print("Calls: ");
        pw.print(this.getApiCallCount(s));
        pw.println();
        pw.print(prefix);
        pw.print("  ");
        pw.print("Last known FG: ");
        pw.print(this.mLastKnownForegroundElapsedTime);
        pw.println();
        pw.print(prefix);
        pw.print("  ");
        pw.print("Last reset: [");
        pw.print(this.mLastResetTime);
        pw.print("] ");
        pw.print(ShortcutService.formatTime(this.mLastResetTime));
        pw.println();
        this.getPackageInfo().dump(s, pw, prefix + "  ");
        pw.println();
        pw.print(prefix);
        pw.println("  Shortcuts:");
        long totalBitmapSize = 0L;
        ArrayMap<String, ShortcutInfo> shortcuts = this.mShortcuts;
        int size = shortcuts.size();
        for (int i = 0; i < size; ++i) {
            ShortcutInfo si = shortcuts.valueAt(i);
            pw.print(prefix);
            pw.print("    ");
            pw.println(si.toInsecureString());
            if (si.getBitmapPath() == null) continue;
            long len = new File(si.getBitmapPath()).length();
            pw.print(prefix);
            pw.print("      ");
            pw.print("bitmap size=");
            pw.println(len);
            totalBitmapSize += len;
        }
        pw.print(prefix);
        pw.print("  ");
        pw.print("Total bitmap size: ");
        pw.print(totalBitmapSize);
        pw.print(" (");
        pw.print(Formatter.formatFileSize(s.mContext, totalBitmapSize));
        pw.println(")");
    }

    @Override
    public void saveToXml(XmlSerializer out, boolean forBackup) throws IOException, XmlPullParserException {
        int size = this.mShortcuts.size();
        if (size == 0 && this.mApiCallCount == 0) {
            return;
        }
        out.startTag(null, TAG_ROOT);
        ShortcutService.writeAttr(out, "name", this.getPackageName());
        ShortcutService.writeAttr(out, ATTR_DYNAMIC_COUNT, this.mDynamicShortcutCount);
        ShortcutService.writeAttr(out, ATTR_CALL_COUNT, this.mApiCallCount);
        ShortcutService.writeAttr(out, ATTR_LAST_RESET, this.mLastResetTime);
        this.getPackageInfo().saveToXml(out);
        for (int j = 0; j < size; ++j) {
            ShortcutPackage.saveShortcut(out, this.mShortcuts.valueAt(j), forBackup);
        }
        out.endTag(null, TAG_ROOT);
    }

    private static void saveShortcut(XmlSerializer out, ShortcutInfo si, boolean forBackup) throws IOException, XmlPullParserException {
        if (forBackup && !si.isPinned()) {
            return;
        }
        out.startTag(null, TAG_SHORTCUT);
        ShortcutService.writeAttr(out, ATTR_ID, si.getId());
        ShortcutService.writeAttr(out, ATTR_ACTIVITY, si.getActivityComponent());
        ShortcutService.writeAttr(out, ATTR_TITLE, si.getTitle());
        ShortcutService.writeAttr(out, ATTR_TEXT, si.getText());
        ShortcutService.writeAttr(out, ATTR_INTENT, si.getIntentNoExtras());
        ShortcutService.writeAttr(out, ATTR_WEIGHT, si.getWeight());
        ShortcutService.writeAttr(out, ATTR_TIMESTAMP, si.getLastChangedTimestamp());
        if (forBackup) {
            ShortcutService.writeAttr(out, ATTR_FLAGS, si.getFlags() & 0xFFFFFFF2);
        } else {
            ShortcutService.writeAttr(out, ATTR_FLAGS, si.getFlags());
            ShortcutService.writeAttr(out, ATTR_ICON_RES, si.getIconResourceId());
            ShortcutService.writeAttr(out, ATTR_BITMAP_PATH, si.getBitmapPath());
        }
        Set<String> cat = si.getCategories();
        if (cat != null && cat.size() > 0) {
            out.startTag(null, "categories");
            XmlUtils.writeStringArrayXml(cat.toArray(new String[cat.size()]), "categories", out);
            out.endTag(null, "categories");
        }
        ShortcutService.writeTagExtra(out, TAG_INTENT_EXTRAS, si.getIntentPersistableExtras());
        ShortcutService.writeTagExtra(out, TAG_EXTRAS, si.getExtras());
        out.endTag(null, TAG_SHORTCUT);
    }

    public static ShortcutPackage loadFromXml(ShortcutService s, ShortcutUser shortcutUser, XmlPullParser parser, boolean fromBackup) throws IOException, XmlPullParserException {
        int type;
        String packageName = ShortcutService.parseStringAttribute(parser, "name");
        ShortcutPackage ret = new ShortcutPackage(s, shortcutUser, shortcutUser.getUserId(), packageName);
        ret.mDynamicShortcutCount = ShortcutService.parseIntAttribute(parser, ATTR_DYNAMIC_COUNT);
        ret.mApiCallCount = ShortcutService.parseIntAttribute(parser, ATTR_CALL_COUNT);
        ret.mLastResetTime = ShortcutService.parseLongAttribute(parser, ATTR_LAST_RESET);
        int outerDepth = parser.getDepth();
        block8: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2) continue;
            int depth = parser.getDepth();
            String tag = parser.getName();
            if (depth == outerDepth + 1) {
                switch (tag) {
                    case "package-info": {
                        ret.getPackageInfo().loadFromXml(parser, fromBackup);
                        continue block8;
                    }
                    case "shortcut": {
                        ShortcutInfo si = ShortcutPackage.parseShortcut(parser, packageName, shortcutUser.getUserId());
                        ret.mShortcuts.put(si.getId(), si);
                        continue block8;
                    }
                }
            }
            ShortcutService.warnForInvalidTag(depth, tag);
        }
        return ret;
    }

    private static ShortcutInfo parseShortcut(XmlPullParser parser, String packageName, int userId) throws IOException, XmlPullParserException {
        int type;
        PersistableBundle intentPersistableExtras = null;
        PersistableBundle extras = null;
        ArraySet<String> categories = null;
        String id2 = ShortcutService.parseStringAttribute(parser, ATTR_ID);
        ComponentName activityComponent = ShortcutService.parseComponentNameAttribute(parser, ATTR_ACTIVITY);
        String title = ShortcutService.parseStringAttribute(parser, ATTR_TITLE);
        String text = ShortcutService.parseStringAttribute(parser, ATTR_TEXT);
        Intent intent = ShortcutService.parseIntentAttribute(parser, ATTR_INTENT);
        int weight = (int)ShortcutService.parseLongAttribute(parser, ATTR_WEIGHT);
        long lastChangedTimestamp = ShortcutService.parseLongAttribute(parser, ATTR_TIMESTAMP);
        int flags = (int)ShortcutService.parseLongAttribute(parser, ATTR_FLAGS);
        int iconRes = (int)ShortcutService.parseLongAttribute(parser, ATTR_ICON_RES);
        String bitmapPath = ShortcutService.parseStringAttribute(parser, ATTR_BITMAP_PATH);
        int outerDepth = parser.getDepth();
        block12: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tag;
            if (type != 2) continue;
            int depth = parser.getDepth();
            switch (tag = parser.getName()) {
                case "intent-extras": {
                    intentPersistableExtras = PersistableBundle.restoreFromXml(parser);
                    continue block12;
                }
                case "extras": {
                    extras = PersistableBundle.restoreFromXml(parser);
                    continue block12;
                }
                case "categories": {
                    continue block12;
                }
                case "string-array": {
                    if (!"categories".equals(ShortcutService.parseStringAttribute(parser, "name"))) continue block12;
                    String[] ar = XmlUtils.readThisStringArrayXml(parser, TAG_STRING_ARRAY_XMLUTILS, null);
                    categories = new ArraySet<String>(ar.length);
                    for (int i = 0; i < ar.length; ++i) {
                        categories.add(ar[i]);
                    }
                    continue block12;
                }
            }
            throw ShortcutService.throwForInvalidTag(depth, tag);
        }
        return new ShortcutInfo(userId, id2, packageName, activityComponent, null, title, text, categories, intent, intentPersistableExtras, weight, extras, lastChangedTimestamp, flags, iconRes, bitmapPath);
    }

    List<ShortcutInfo> getAllShortcutsForTest() {
        return new ArrayList<ShortcutInfo>(this.mShortcuts.values());
    }
}

