/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.ComponentName;
import android.text.format.Formatter;
import android.util.ArrayMap;
import android.util.SparseArray;
import com.android.internal.util.Preconditions;
import com.android.server.pm.ShortcutLauncher;
import com.android.server.pm.ShortcutPackage;
import com.android.server.pm.ShortcutPackageItem;
import com.android.server.pm.ShortcutService;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.function.Consumer;
import libcore.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class ShortcutUser {
    private static final String TAG = "ShortcutService";
    static final String TAG_ROOT = "user";
    private static final String TAG_LAUNCHER = "launcher";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_KNOWN_LOCALE_CHANGE_SEQUENCE_NUMBER = "locale-seq-no";
    private final int mUserId;
    private final ArrayMap<String, ShortcutPackage> mPackages = new ArrayMap();
    private final SparseArray<ShortcutPackage> mPackagesFromUid = new SparseArray();
    private final ArrayMap<PackageWithUser, ShortcutLauncher> mLaunchers = new ArrayMap();
    private ComponentName mLauncherComponent;
    private long mKnownLocaleChangeSequenceNumber;

    public ShortcutUser(int userId) {
        this.mUserId = userId;
    }

    public int getUserId() {
        return this.mUserId;
    }

    ArrayMap<String, ShortcutPackage> getAllPackagesForTest() {
        return this.mPackages;
    }

    public ShortcutPackage removePackage(ShortcutService s, String packageName) {
        ShortcutPackage removed = this.mPackages.remove(packageName);
        s.cleanupBitmapsForPackage(this.mUserId, packageName);
        return removed;
    }

    ArrayMap<PackageWithUser, ShortcutLauncher> getAllLaunchersForTest() {
        return this.mLaunchers;
    }

    public void addLauncher(ShortcutLauncher launcher) {
        this.mLaunchers.put(PackageWithUser.of(launcher.getPackageUserId(), launcher.getPackageName()), launcher);
    }

    public ShortcutLauncher removeLauncher(int packageUserId, String packageName) {
        return this.mLaunchers.remove(PackageWithUser.of(packageUserId, packageName));
    }

    public ShortcutPackage getPackageShortcuts(ShortcutService s, String packageName) {
        ShortcutPackage ret = this.mPackages.get(packageName);
        if (ret == null) {
            ret = new ShortcutPackage(s, this, this.mUserId, packageName);
            this.mPackages.put(packageName, ret);
        } else {
            ret.attemptToRestoreIfNeededAndSave(s);
        }
        return ret;
    }

    public ShortcutLauncher getLauncherShortcuts(ShortcutService s, String packageName, int launcherUserId) {
        PackageWithUser key = PackageWithUser.of(launcherUserId, packageName);
        ShortcutLauncher ret = this.mLaunchers.get(key);
        if (ret == null) {
            ret = new ShortcutLauncher(this, this.mUserId, packageName, launcherUserId);
            this.mLaunchers.put(key, ret);
        } else {
            ret.attemptToRestoreIfNeededAndSave(s);
        }
        return ret;
    }

    public void forAllPackages(Consumer<? super ShortcutPackage> callback) {
        int size = this.mPackages.size();
        for (int i = 0; i < size; ++i) {
            callback.accept(this.mPackages.valueAt(i));
        }
    }

    public void forAllLaunchers(Consumer<? super ShortcutLauncher> callback) {
        int size = this.mLaunchers.size();
        for (int i = 0; i < size; ++i) {
            callback.accept(this.mLaunchers.valueAt(i));
        }
    }

    public void forAllPackageItems(Consumer<? super ShortcutPackageItem> callback) {
        this.forAllLaunchers(callback);
        this.forAllPackages(callback);
    }

    public void forPackageItem(String packageName, int packageUserId, Consumer<ShortcutPackageItem> callback) {
        this.forAllPackageItems(spi -> {
            if (spi.getPackageUserId() == packageUserId && spi.getPackageName().equals(packageName)) {
                callback.accept((ShortcutPackageItem)spi);
            }
        });
    }

    public void resetThrottlingIfNeeded(ShortcutService s) {
        long currentNo = s.getLocaleChangeSequenceNumber();
        if (this.mKnownLocaleChangeSequenceNumber < currentNo) {
            this.mKnownLocaleChangeSequenceNumber = currentNo;
            this.forAllPackages(p -> p.resetRateLimiting(s));
            s.scheduleSaveUser(this.mUserId);
        }
    }

    public void handlePackageUpdated(ShortcutService s, String packageName, int newVersionCode) {
        if (!this.mPackages.containsKey(packageName)) {
            return;
        }
        this.getPackageShortcuts(s, packageName).handlePackageUpdated(s, newVersionCode);
    }

    public void attemptToRestoreIfNeededAndSave(ShortcutService s, String packageName, int packageUserId) {
        this.forPackageItem(packageName, packageUserId, spi -> spi.attemptToRestoreIfNeededAndSave(s));
    }

    public void saveToXml(ShortcutService s, XmlSerializer out, boolean forBackup) throws IOException, XmlPullParserException {
        int i;
        out.startTag(null, TAG_ROOT);
        ShortcutService.writeAttr(out, ATTR_KNOWN_LOCALE_CHANGE_SEQUENCE_NUMBER, this.mKnownLocaleChangeSequenceNumber);
        ShortcutService.writeTagValue(out, TAG_LAUNCHER, this.mLauncherComponent);
        int size = this.mLaunchers.size();
        for (i = 0; i < size; ++i) {
            this.saveShortcutPackageItem(s, out, this.mLaunchers.valueAt(i), forBackup);
        }
        size = this.mPackages.size();
        for (i = 0; i < size; ++i) {
            this.saveShortcutPackageItem(s, out, this.mPackages.valueAt(i), forBackup);
        }
        out.endTag(null, TAG_ROOT);
    }

    private void saveShortcutPackageItem(ShortcutService s, XmlSerializer out, ShortcutPackageItem spi, boolean forBackup) throws IOException, XmlPullParserException {
        if (forBackup) {
            if (!s.shouldBackupApp(spi.getPackageName(), spi.getPackageUserId())) {
                return;
            }
            if (spi.getPackageUserId() != spi.getOwnerUserId()) {
                return;
            }
        }
        spi.saveToXml(out, forBackup);
    }

    public static ShortcutUser loadFromXml(ShortcutService s, XmlPullParser parser, int userId, boolean fromBackup) throws IOException, XmlPullParserException {
        int type;
        ShortcutUser ret = new ShortcutUser(userId);
        ret.mKnownLocaleChangeSequenceNumber = ShortcutService.parseLongAttribute(parser, ATTR_KNOWN_LOCALE_CHANGE_SEQUENCE_NUMBER);
        int outerDepth = parser.getDepth();
        block10: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2) continue;
            int depth = parser.getDepth();
            String tag = parser.getName();
            if (depth == outerDepth + 1) {
                switch (tag) {
                    case "launcher": {
                        ret.mLauncherComponent = ShortcutService.parseComponentNameAttribute(parser, ATTR_VALUE);
                        continue block10;
                    }
                    case "package": {
                        ShortcutPackage shortcuts = ShortcutPackage.loadFromXml(s, ret, parser, fromBackup);
                        ret.mPackages.put(shortcuts.getPackageName(), shortcuts);
                        continue block10;
                    }
                    case "launcher-pins": {
                        ret.addLauncher(ShortcutLauncher.loadFromXml(parser, ret, userId, fromBackup));
                        continue block10;
                    }
                }
            }
            ShortcutService.warnForInvalidTag(depth, tag);
        }
        return ret;
    }

    public ComponentName getLauncherComponent() {
        return this.mLauncherComponent;
    }

    public void setLauncherComponent(ShortcutService s, ComponentName launcherComponent) {
        if (Objects.equal(this.mLauncherComponent, launcherComponent)) {
            return;
        }
        this.mLauncherComponent = launcherComponent;
        s.scheduleSaveUser(this.mUserId);
    }

    public void resetThrottling() {
        for (int i = this.mPackages.size() - 1; i >= 0; --i) {
            this.mPackages.valueAt(i).resetThrottling();
        }
    }

    public void dump(ShortcutService s, PrintWriter pw, String prefix) {
        int i;
        pw.print(prefix);
        pw.print("User: ");
        pw.print(this.mUserId);
        pw.print("  Known locale seq#: ");
        pw.print(this.mKnownLocaleChangeSequenceNumber);
        pw.println();
        prefix = prefix + prefix + "  ";
        pw.print(prefix);
        pw.print("Default launcher: ");
        pw.print(this.mLauncherComponent);
        pw.println();
        for (i = 0; i < this.mLaunchers.size(); ++i) {
            this.mLaunchers.valueAt(i).dump(s, pw, prefix);
        }
        for (i = 0; i < this.mPackages.size(); ++i) {
            this.mPackages.valueAt(i).dump(s, pw, prefix);
        }
        pw.println();
        pw.print(prefix);
        pw.println("Bitmap directories: ");
        this.dumpDirectorySize(s, pw, prefix + "  ", s.getUserBitmapFilePath(this.mUserId));
    }

    private void dumpDirectorySize(ShortcutService s, PrintWriter pw, String prefix, File path) {
        int numFiles = 0;
        long size = 0L;
        File[] children = path.listFiles();
        if (children != null) {
            for (File child : path.listFiles()) {
                if (child.isFile()) {
                    ++numFiles;
                    size += child.length();
                    continue;
                }
                if (!child.isDirectory()) continue;
                this.dumpDirectorySize(s, pw, prefix + "  ", child);
            }
        }
        pw.print(prefix);
        pw.print("Path: ");
        pw.print(path.getName());
        pw.print("/ has ");
        pw.print(numFiles);
        pw.print(" files, size=");
        pw.print(size);
        pw.print(" (");
        pw.print(Formatter.formatFileSize(s.mContext, size));
        pw.println(")");
    }

    static final class PackageWithUser {
        final int userId;
        final String packageName;

        private PackageWithUser(int userId, String packageName) {
            this.userId = userId;
            this.packageName = Preconditions.checkNotNull(packageName);
        }

        public static PackageWithUser of(int userId, String packageName) {
            return new PackageWithUser(userId, packageName);
        }

        public static PackageWithUser of(ShortcutPackageItem spi) {
            return new PackageWithUser(spi.getPackageUserId(), spi.getPackageName());
        }

        public int hashCode() {
            return this.packageName.hashCode() ^ this.userId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PackageWithUser)) {
                return false;
            }
            PackageWithUser that = (PackageWithUser)obj;
            return this.userId == that.userId && this.packageName.equals(that.packageName);
        }

        public String toString() {
            return String.format("{Package: %d, %s}", this.userId, this.packageName);
        }
    }
}

