/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.hardware.TriggerEvent;
import android.hardware.TriggerEventListener;
import android.os.Handler;
import java.io.PrintWriter;

public abstract class WakeGestureListener {
    private static final String TAG = "WakeGestureListener";
    private final SensorManager mSensorManager;
    private final Handler mHandler;
    private final Object mLock = new Object();
    private boolean mTriggerRequested;
    private Sensor mSensor;
    private final TriggerEventListener mListener = new TriggerEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTrigger(TriggerEvent event) {
            Object object = WakeGestureListener.this.mLock;
            synchronized (object) {
                WakeGestureListener.this.mTriggerRequested = false;
                WakeGestureListener.this.mHandler.post(WakeGestureListener.this.mWakeUpRunnable);
            }
        }
    };
    private final Runnable mWakeUpRunnable = new Runnable(){

        @Override
        public void run() {
            WakeGestureListener.this.onWakeUp();
        }
    };

    public WakeGestureListener(Context context, Handler handler) {
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mHandler = handler;
        this.mSensor = this.mSensorManager.getDefaultSensor(23);
    }

    public abstract void onWakeUp();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupported() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSensor != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestWakeUpTrigger() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSensor != null && !this.mTriggerRequested) {
                this.mTriggerRequested = true;
                this.mSensorManager.requestTriggerSensor(this.mListener, this.mSensor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelWakeUpTrigger() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSensor != null && this.mTriggerRequested) {
                this.mTriggerRequested = false;
                this.mSensorManager.cancelTriggerSensor(this.mListener, this.mSensor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println(prefix + TAG);
            prefix = prefix + "  ";
            pw.println(prefix + "mTriggerRequested=" + this.mTriggerRequested);
            pw.println(prefix + "mSensor=" + this.mSensor);
        }
    }
}

