/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy.keyguard;

import android.app.ActivityManager;
import android.content.Context;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.policy.IKeyguardService;
import com.android.internal.policy.IKeyguardStateCallback;
import com.android.internal.widget.LockPatternUtils;
import java.io.PrintWriter;

public class KeyguardStateMonitor
extends IKeyguardStateCallback.Stub {
    private static final String TAG = "KeyguardStateMonitor";
    private volatile boolean mIsShowing = true;
    private volatile boolean mSimSecure = true;
    private volatile boolean mInputRestricted = true;
    private int mCurrentUserId;
    private final LockPatternUtils mLockPatternUtils;

    public KeyguardStateMonitor(Context context, IKeyguardService service) {
        this.mLockPatternUtils = new LockPatternUtils(context);
        this.mCurrentUserId = ActivityManager.getCurrentUser();
        try {
            service.addStateMonitorCallback(this);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Remote Exception", e);
        }
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public boolean isSecure(int userId) {
        return this.mLockPatternUtils.isSecure(userId) || this.mSimSecure;
    }

    public boolean isInputRestricted() {
        return this.mInputRestricted;
    }

    @Override
    public void onShowingStateChanged(boolean showing) {
        this.mIsShowing = showing;
    }

    @Override
    public void onSimSecureStateChanged(boolean simSecure) {
        this.mSimSecure = simSecure;
    }

    public synchronized void setCurrentUser(int userId) {
        this.mCurrentUserId = userId;
    }

    private synchronized int getCurrentUser() {
        return this.mCurrentUserId;
    }

    @Override
    public void onInputRestrictedStateChanged(boolean inputRestricted) {
        this.mInputRestricted = inputRestricted;
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + TAG);
        prefix = prefix + "  ";
        pw.println(prefix + "mIsShowing=" + this.mIsShowing);
        pw.println(prefix + "mSimSecure=" + this.mSimSecure);
        pw.println(prefix + "mInputRestricted=" + this.mInputRestricted);
        pw.println(prefix + "mCurrentUserId=" + this.mCurrentUserId);
    }
}

