/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.tv;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.HdmiHotplugEvent;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiDeviceEventListener;
import android.hardware.hdmi.IHdmiHotplugEventListener;
import android.hardware.hdmi.IHdmiSystemAudioModeChangeListener;
import android.media.AudioDevicePort;
import android.media.AudioFormat;
import android.media.AudioGain;
import android.media.AudioGainConfig;
import android.media.AudioManager;
import android.media.AudioPatch;
import android.media.AudioPort;
import android.media.AudioPortConfig;
import android.media.tv.ITvInputHardware;
import android.media.tv.ITvInputHardwareCallback;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvStreamConfig;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.Surface;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.tv.TvInputHal;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class TvInputHardwareManager
implements TvInputHal.Callback {
    private static final String TAG = TvInputHardwareManager.class.getSimpleName();
    private final Context mContext;
    private final Listener mListener;
    private final TvInputHal mHal = new TvInputHal(this);
    private final SparseArray<Connection> mConnections = new SparseArray();
    private final List<TvInputHardwareInfo> mHardwareList = new ArrayList<TvInputHardwareInfo>();
    private final List<HdmiDeviceInfo> mHdmiDeviceList = new LinkedList<HdmiDeviceInfo>();
    private final SparseArray<String> mHardwareInputIdMap = new SparseArray();
    private final SparseArray<String> mHdmiInputIdMap = new SparseArray();
    private final Map<String, TvInputInfo> mInputMap = new ArrayMap<String, TvInputInfo>();
    private final AudioManager mAudioManager;
    private final IHdmiHotplugEventListener mHdmiHotplugEventListener = new HdmiHotplugEventListener();
    private final IHdmiDeviceEventListener mHdmiDeviceEventListener = new HdmiDeviceEventListener();
    private final IHdmiSystemAudioModeChangeListener mHdmiSystemAudioModeChangeListener = new HdmiSystemAudioModeChangeListener();
    private final BroadcastReceiver mVolumeReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            TvInputHardwareManager.this.handleVolumeChange(context, intent);
        }
    };
    private int mCurrentIndex = 0;
    private int mCurrentMaxIndex = 0;
    private final SparseBooleanArray mHdmiStateMap = new SparseBooleanArray();
    private final List<Message> mPendingHdmiDeviceEvents = new LinkedList<Message>();
    private final Handler mHandler = new ListenerHandler();
    private final Object mLock = new Object();

    public TvInputHardwareManager(Context context, Listener listener) {
        this.mContext = context;
        this.mListener = listener;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mHal.init();
    }

    public void onBootPhase(int phase) {
        if (phase == 500) {
            IHdmiControlService hdmiControlService = IHdmiControlService.Stub.asInterface(ServiceManager.getService("hdmi_control"));
            if (hdmiControlService != null) {
                try {
                    hdmiControlService.addHotplugEventListener(this.mHdmiHotplugEventListener);
                    hdmiControlService.addDeviceEventListener(this.mHdmiDeviceEventListener);
                    hdmiControlService.addSystemAudioModeChangeListener(this.mHdmiSystemAudioModeChangeListener);
                    this.mHdmiDeviceList.addAll(hdmiControlService.getInputDevices());
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Error registering listeners to HdmiControlService:", e);
                }
            } else {
                Slog.w(TAG, "HdmiControlService is not available");
            }
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.media.VOLUME_CHANGED_ACTION");
            filter.addAction("android.media.STREAM_MUTE_CHANGED_ACTION");
            this.mContext.registerReceiver(this.mVolumeReceiver, filter);
            this.updateVolume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeviceAvailable(TvInputHardwareInfo info, TvStreamConfig[] configs) {
        Object object = this.mLock;
        synchronized (object) {
            Connection connection = new Connection(info);
            connection.updateConfigsLocked(configs);
            this.mConnections.put(info.getDeviceId(), connection);
            this.buildHardwareListLocked();
            this.mHandler.obtainMessage(2, 0, 0, info).sendToTarget();
            if (info.getType() == 9) {
                this.processPendingHdmiDeviceEventsLocked();
            }
        }
    }

    private void buildHardwareListLocked() {
        this.mHardwareList.clear();
        for (int i = 0; i < this.mConnections.size(); ++i) {
            this.mHardwareList.add(this.mConnections.valueAt(i).getHardwareInfoLocked());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeviceUnavailable(int deviceId) {
        Object object = this.mLock;
        synchronized (object) {
            Connection connection = this.mConnections.get(deviceId);
            if (connection == null) {
                Slog.e(TAG, "onDeviceUnavailable: Cannot find a connection with " + deviceId);
                return;
            }
            connection.resetLocked(null, null, null, null, null);
            this.mConnections.remove(deviceId);
            this.buildHardwareListLocked();
            TvInputHardwareInfo info = connection.getHardwareInfoLocked();
            if (info.getType() == 9) {
                Iterator<HdmiDeviceInfo> it = this.mHdmiDeviceList.iterator();
                while (it.hasNext()) {
                    HdmiDeviceInfo deviceInfo = it.next();
                    if (deviceInfo.getPortId() != info.getHdmiPortId()) continue;
                    this.mHandler.obtainMessage(5, 0, 0, deviceInfo).sendToTarget();
                    it.remove();
                }
            }
            this.mHandler.obtainMessage(3, 0, 0, info).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStreamConfigurationChanged(int deviceId, TvStreamConfig[] configs) {
        Object object = this.mLock;
        synchronized (object) {
            ITvInputHardwareCallback callback;
            Connection connection = this.mConnections.get(deviceId);
            if (connection == null) {
                Slog.e(TAG, "StreamConfigurationChanged: Cannot find a connection with " + deviceId);
                return;
            }
            connection.updateConfigsLocked(configs);
            String inputId = this.mHardwareInputIdMap.get(deviceId);
            if (inputId != null) {
                this.mHandler.obtainMessage(1, this.convertConnectedToState(configs.length > 0), 0, inputId).sendToTarget();
            }
            if ((callback = connection.getCallbackLocked()) != null) {
                try {
                    callback.onStreamConfigChanged(configs);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "error in onStreamConfigurationChanged", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFirstFrameCaptured(int deviceId, int streamId) {
        Object object = this.mLock;
        synchronized (object) {
            Connection connection = this.mConnections.get(deviceId);
            if (connection == null) {
                Slog.e(TAG, "FirstFrameCaptured: Cannot find a connection with " + deviceId);
                return;
            }
            Runnable runnable = connection.getOnFirstFrameCapturedLocked();
            if (runnable != null) {
                runnable.run();
                connection.setOnFirstFrameCapturedLocked(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TvInputHardwareInfo> getHardwareList() {
        Object object = this.mLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.mHardwareList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HdmiDeviceInfo> getHdmiDeviceList() {
        Object object = this.mLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.mHdmiDeviceList);
        }
    }

    private boolean checkUidChangedLocked(Connection connection, int callingUid, int resolvedUserId) {
        Integer connectionCallingUid = connection.getCallingUidLocked();
        Integer connectionResolvedUserId = connection.getResolvedUserIdLocked();
        return connectionCallingUid == null || connectionResolvedUserId == null || connectionCallingUid != callingUid || connectionResolvedUserId != resolvedUserId;
    }

    private int convertConnectedToState(boolean connected) {
        if (connected) {
            return 0;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHardwareInput(int deviceId, TvInputInfo info) {
        Object object = this.mLock;
        synchronized (object) {
            String oldInputId = this.mHardwareInputIdMap.get(deviceId);
            if (oldInputId != null) {
                Slog.w(TAG, "Trying to override previous registration: old = " + this.mInputMap.get(oldInputId) + ":" + deviceId + ", new = " + info + ":" + deviceId);
            }
            this.mHardwareInputIdMap.put(deviceId, info.getId());
            this.mInputMap.put(info.getId(), info);
            for (int i = 0; i < this.mHdmiStateMap.size(); ++i) {
                String inputId;
                TvInputHardwareInfo hardwareInfo = this.findHardwareInfoForHdmiPortLocked(this.mHdmiStateMap.keyAt(i));
                if (hardwareInfo == null || (inputId = this.mHardwareInputIdMap.get(hardwareInfo.getDeviceId())) == null || !inputId.equals(info.getId())) continue;
                this.mHandler.obtainMessage(1, this.convertConnectedToState(this.mHdmiStateMap.valueAt(i)), 0, inputId).sendToTarget();
                return;
            }
            Connection connection = this.mConnections.get(deviceId);
            if (connection != null) {
                this.mHandler.obtainMessage(1, this.convertConnectedToState(connection.getConfigsLocked().length > 0), 0, info.getId()).sendToTarget();
            }
        }
    }

    private static <T> int indexOfEqualValue(SparseArray<T> map, T value) {
        for (int i = 0; i < map.size(); ++i) {
            if (!map.valueAt(i).equals(value)) continue;
            return i;
        }
        return -1;
    }

    private static boolean intArrayContains(int[] array2, int value) {
        for (int element : array2) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHdmiInput(int id2, TvInputInfo info) {
        if (info.getType() != 1007) {
            throw new IllegalArgumentException("info (" + info + ") has non-HDMI type.");
        }
        Object object = this.mLock;
        synchronized (object) {
            String parentId = info.getParentId();
            int parentIndex = TvInputHardwareManager.indexOfEqualValue(this.mHardwareInputIdMap, parentId);
            if (parentIndex < 0) {
                throw new IllegalArgumentException("info (" + info + ") has invalid parentId.");
            }
            String oldInputId = this.mHdmiInputIdMap.get(id2);
            if (oldInputId != null) {
                Slog.w(TAG, "Trying to override previous registration: old = " + this.mInputMap.get(oldInputId) + ":" + id2 + ", new = " + info + ":" + id2);
            }
            this.mHdmiInputIdMap.put(id2, info.getId());
            this.mInputMap.put(info.getId(), info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHardwareInput(String inputId) {
        Object object = this.mLock;
        synchronized (object) {
            int deviceIndex;
            this.mInputMap.remove(inputId);
            int hardwareIndex = TvInputHardwareManager.indexOfEqualValue(this.mHardwareInputIdMap, inputId);
            if (hardwareIndex >= 0) {
                this.mHardwareInputIdMap.removeAt(hardwareIndex);
            }
            if ((deviceIndex = TvInputHardwareManager.indexOfEqualValue(this.mHdmiInputIdMap, inputId)) >= 0) {
                this.mHdmiInputIdMap.removeAt(deviceIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITvInputHardware acquireHardware(int deviceId, ITvInputHardwareCallback callback, TvInputInfo info, int callingUid, int resolvedUserId) {
        if (callback == null) {
            throw new NullPointerException();
        }
        Object object = this.mLock;
        synchronized (object) {
            Connection connection = this.mConnections.get(deviceId);
            if (connection == null) {
                Slog.e(TAG, "Invalid deviceId : " + deviceId);
                return null;
            }
            if (this.checkUidChangedLocked(connection, callingUid, resolvedUserId)) {
                TvInputHardwareImpl hardware = new TvInputHardwareImpl(connection.getHardwareInfoLocked());
                try {
                    callback.asBinder().linkToDeath(connection, 0);
                }
                catch (RemoteException e) {
                    hardware.release();
                    return null;
                }
                connection.resetLocked(hardware, callback, info, callingUid, resolvedUserId);
            }
            return connection.getHardwareLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseHardware(int deviceId, ITvInputHardware hardware, int callingUid, int resolvedUserId) {
        Object object = this.mLock;
        synchronized (object) {
            Connection connection = this.mConnections.get(deviceId);
            if (connection == null) {
                Slog.e(TAG, "Invalid deviceId : " + deviceId);
                return;
            }
            if (connection.getHardwareLocked() != hardware || this.checkUidChangedLocked(connection, callingUid, resolvedUserId)) {
                return;
            }
            connection.resetLocked(null, null, null, null, null);
        }
    }

    private TvInputHardwareInfo findHardwareInfoForHdmiPortLocked(int port) {
        for (TvInputHardwareInfo hardwareInfo : this.mHardwareList) {
            if (hardwareInfo.getType() != 9 || hardwareInfo.getHdmiPortId() != port) continue;
            return hardwareInfo;
        }
        return null;
    }

    private int findDeviceIdForInputIdLocked(String inputId) {
        for (int i = 0; i < this.mConnections.size(); ++i) {
            Connection connection = this.mConnections.get(i);
            if (!connection.getInfoLocked().getId().equals(inputId)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TvStreamConfig> getAvailableTvStreamConfigList(String inputId, int callingUid, int resolvedUserId) {
        ArrayList<TvStreamConfig> configsList = new ArrayList<TvStreamConfig>();
        Object object = this.mLock;
        synchronized (object) {
            int deviceId = this.findDeviceIdForInputIdLocked(inputId);
            if (deviceId < 0) {
                Slog.e(TAG, "Invalid inputId : " + inputId);
                return configsList;
            }
            Connection connection = this.mConnections.get(deviceId);
            for (TvStreamConfig config : connection.getConfigsLocked()) {
                if (config.getType() != 2) continue;
                configsList.add(config);
            }
        }
        return configsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean captureFrame(String inputId, Surface surface, final TvStreamConfig config, int callingUid, int resolvedUserId) {
        Object object = this.mLock;
        synchronized (object) {
            int deviceId = this.findDeviceIdForInputIdLocked(inputId);
            if (deviceId < 0) {
                Slog.e(TAG, "Invalid inputId : " + inputId);
                return false;
            }
            Connection connection = this.mConnections.get(deviceId);
            final TvInputHardwareImpl hardwareImpl = connection.getHardwareImplLocked();
            if (hardwareImpl != null) {
                boolean result;
                Runnable runnable = connection.getOnFirstFrameCapturedLocked();
                if (runnable != null) {
                    runnable.run();
                    connection.setOnFirstFrameCapturedLocked(null);
                }
                if (result = hardwareImpl.startCapture(surface, config)) {
                    connection.setOnFirstFrameCapturedLocked(new Runnable(){

                        @Override
                        public void run() {
                            hardwareImpl.stopCapture(config);
                        }
                    });
                }
                return result;
            }
        }
        return false;
    }

    private void processPendingHdmiDeviceEventsLocked() {
        Iterator<Message> it = this.mPendingHdmiDeviceEvents.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            HdmiDeviceInfo deviceInfo = (HdmiDeviceInfo)msg.obj;
            TvInputHardwareInfo hardwareInfo = this.findHardwareInfoForHdmiPortLocked(deviceInfo.getPortId());
            if (hardwareInfo == null) continue;
            msg.sendToTarget();
            it.remove();
        }
    }

    private void updateVolume() {
        this.mCurrentMaxIndex = this.mAudioManager.getStreamMaxVolume(3);
        this.mCurrentIndex = this.mAudioManager.getStreamVolume(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleVolumeChange(Context context, Intent intent) {
        String action = intent.getAction();
        switch (action) {
            case "android.media.VOLUME_CHANGED_ACTION": {
                int streamType = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1);
                if (streamType != 3) {
                    return;
                }
                int index = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", 0);
                if (index == this.mCurrentIndex) {
                    return;
                }
                this.mCurrentIndex = index;
                break;
            }
            case "android.media.STREAM_MUTE_CHANGED_ACTION": {
                int streamType = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1);
                if (streamType == 3) break;
                return;
            }
            default: {
                Slog.w(TAG, "Unrecognized intent: " + intent);
                return;
            }
        }
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mConnections.size(); ++i) {
                TvInputHardwareImpl hardwareImpl = this.mConnections.valueAt(i).getHardwareImplLocked();
                if (hardwareImpl == null) continue;
                hardwareImpl.onMediaStreamVolumeChanged();
            }
        }
    }

    private float getMediaStreamVolume() {
        return (float)this.mCurrentIndex / (float)this.mCurrentMaxIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump TvInputHardwareManager from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            String inputId;
            int i;
            pw.println("TvInputHardwareManager Info:");
            pw.increaseIndent();
            pw.println("mConnections: deviceId -> Connection");
            pw.increaseIndent();
            for (int i2 = 0; i2 < this.mConnections.size(); ++i2) {
                int deviceId = this.mConnections.keyAt(i2);
                Connection mConnection = this.mConnections.valueAt(i2);
                pw.println(deviceId + ": " + mConnection);
            }
            pw.decreaseIndent();
            pw.println("mHardwareList:");
            pw.increaseIndent();
            for (TvInputHardwareInfo tvInputHardwareInfo : this.mHardwareList) {
                pw.println(tvInputHardwareInfo);
            }
            pw.decreaseIndent();
            pw.println("mHdmiDeviceList:");
            pw.increaseIndent();
            for (HdmiDeviceInfo hdmiDeviceInfo : this.mHdmiDeviceList) {
                pw.println(hdmiDeviceInfo);
            }
            pw.decreaseIndent();
            pw.println("mHardwareInputIdMap: deviceId -> inputId");
            pw.increaseIndent();
            for (i = 0; i < this.mHardwareInputIdMap.size(); ++i) {
                int deviceId = this.mHardwareInputIdMap.keyAt(i);
                inputId = this.mHardwareInputIdMap.valueAt(i);
                pw.println(deviceId + ": " + inputId);
            }
            pw.decreaseIndent();
            pw.println("mHdmiInputIdMap: id -> inputId");
            pw.increaseIndent();
            for (i = 0; i < this.mHdmiInputIdMap.size(); ++i) {
                int id2 = this.mHdmiInputIdMap.keyAt(i);
                inputId = this.mHdmiInputIdMap.valueAt(i);
                pw.println(id2 + ": " + inputId);
            }
            pw.decreaseIndent();
            pw.println("mInputMap: inputId -> inputInfo");
            pw.increaseIndent();
            for (Map.Entry<String, TvInputInfo> entry : this.mInputMap.entrySet()) {
                pw.println(entry.getKey() + ": " + entry.getValue());
            }
            pw.decreaseIndent();
            pw.decreaseIndent();
        }
    }

    private final class HdmiSystemAudioModeChangeListener
    extends IHdmiSystemAudioModeChangeListener.Stub {
        private HdmiSystemAudioModeChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChanged(boolean enabled) throws RemoteException {
            Object object = TvInputHardwareManager.this.mLock;
            synchronized (object) {
                for (int i = 0; i < TvInputHardwareManager.this.mConnections.size(); ++i) {
                    TvInputHardwareImpl impl = ((Connection)TvInputHardwareManager.this.mConnections.valueAt(i)).getHardwareImplLocked();
                    if (impl == null) continue;
                    impl.handleAudioSinkUpdated();
                }
            }
        }
    }

    private final class HdmiDeviceEventListener
    extends IHdmiDeviceEventListener.Stub {
        private HdmiDeviceEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChanged(HdmiDeviceInfo deviceInfo, int status) {
            if (!deviceInfo.isSourceType()) {
                return;
            }
            Object object = TvInputHardwareManager.this.mLock;
            synchronized (object) {
                int messageType = 0;
                HdmiDeviceInfo obj = null;
                switch (status) {
                    case 1: {
                        if (this.findHdmiDeviceInfo(deviceInfo.getId()) != null) {
                            Slog.w(TAG, "The list already contains " + deviceInfo + "; ignoring.");
                            return;
                        }
                        TvInputHardwareManager.this.mHdmiDeviceList.add(deviceInfo);
                        messageType = 4;
                        obj = deviceInfo;
                        break;
                    }
                    case 2: {
                        HdmiDeviceInfo originalDeviceInfo = this.findHdmiDeviceInfo(deviceInfo.getId());
                        if (!TvInputHardwareManager.this.mHdmiDeviceList.remove(originalDeviceInfo)) {
                            Slog.w(TAG, "The list doesn't contain " + deviceInfo + "; ignoring.");
                            return;
                        }
                        messageType = 5;
                        obj = deviceInfo;
                        break;
                    }
                    case 3: {
                        HdmiDeviceInfo originalDeviceInfo = this.findHdmiDeviceInfo(deviceInfo.getId());
                        if (!TvInputHardwareManager.this.mHdmiDeviceList.remove(originalDeviceInfo)) {
                            Slog.w(TAG, "The list doesn't contain " + deviceInfo + "; ignoring.");
                            return;
                        }
                        TvInputHardwareManager.this.mHdmiDeviceList.add(deviceInfo);
                        messageType = 6;
                        obj = deviceInfo;
                        break;
                    }
                }
                Message msg = TvInputHardwareManager.this.mHandler.obtainMessage(messageType, 0, 0, obj);
                if (TvInputHardwareManager.this.findHardwareInfoForHdmiPortLocked(deviceInfo.getPortId()) != null) {
                    msg.sendToTarget();
                } else {
                    TvInputHardwareManager.this.mPendingHdmiDeviceEvents.add(msg);
                }
            }
        }

        private HdmiDeviceInfo findHdmiDeviceInfo(int id2) {
            for (HdmiDeviceInfo info : TvInputHardwareManager.this.mHdmiDeviceList) {
                if (info.getId() != id2) continue;
                return info;
            }
            return null;
        }
    }

    private final class HdmiHotplugEventListener
    extends IHdmiHotplugEventListener.Stub {
        private HdmiHotplugEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceived(HdmiHotplugEvent event) {
            Object object = TvInputHardwareManager.this.mLock;
            synchronized (object) {
                TvInputHardwareManager.this.mHdmiStateMap.put(event.getPort(), event.isConnected());
                TvInputHardwareInfo hardwareInfo = TvInputHardwareManager.this.findHardwareInfoForHdmiPortLocked(event.getPort());
                if (hardwareInfo == null) {
                    return;
                }
                String inputId = (String)TvInputHardwareManager.this.mHardwareInputIdMap.get(hardwareInfo.getDeviceId());
                if (inputId == null) {
                    return;
                }
                TvInputHardwareManager.this.mHandler.obtainMessage(1, TvInputHardwareManager.this.convertConnectedToState(event.isConnected()), 0, inputId).sendToTarget();
            }
        }
    }

    private class ListenerHandler
    extends Handler {
        private static final int STATE_CHANGED = 1;
        private static final int HARDWARE_DEVICE_ADDED = 2;
        private static final int HARDWARE_DEVICE_REMOVED = 3;
        private static final int HDMI_DEVICE_ADDED = 4;
        private static final int HDMI_DEVICE_REMOVED = 5;
        private static final int HDMI_DEVICE_UPDATED = 6;

        private ListenerHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    String inputId = (String)msg.obj;
                    int state = msg.arg1;
                    TvInputHardwareManager.this.mListener.onStateChanged(inputId, state);
                    break;
                }
                case 2: {
                    TvInputHardwareInfo info = (TvInputHardwareInfo)msg.obj;
                    TvInputHardwareManager.this.mListener.onHardwareDeviceAdded(info);
                    break;
                }
                case 3: {
                    TvInputHardwareInfo info = (TvInputHardwareInfo)msg.obj;
                    TvInputHardwareManager.this.mListener.onHardwareDeviceRemoved(info);
                    break;
                }
                case 4: {
                    HdmiDeviceInfo info = (HdmiDeviceInfo)msg.obj;
                    TvInputHardwareManager.this.mListener.onHdmiDeviceAdded(info);
                    break;
                }
                case 5: {
                    HdmiDeviceInfo info = (HdmiDeviceInfo)msg.obj;
                    TvInputHardwareManager.this.mListener.onHdmiDeviceRemoved(info);
                    break;
                }
                case 6: {
                    String inputId;
                    HdmiDeviceInfo info = (HdmiDeviceInfo)msg.obj;
                    Object object = TvInputHardwareManager.this.mLock;
                    synchronized (object) {
                        inputId = (String)TvInputHardwareManager.this.mHdmiInputIdMap.get(info.getId());
                    }
                    if (inputId != null) {
                        TvInputHardwareManager.this.mListener.onHdmiDeviceUpdated(inputId, info);
                        break;
                    }
                    Slog.w(TAG, "Could not resolve input ID matching the device info; ignoring.");
                    break;
                }
                default: {
                    Slog.w(TAG, "Unhandled message: " + msg);
                }
            }
        }
    }

    static interface Listener {
        public void onStateChanged(String var1, int var2);

        public void onHardwareDeviceAdded(TvInputHardwareInfo var1);

        public void onHardwareDeviceRemoved(TvInputHardwareInfo var1);

        public void onHdmiDeviceAdded(HdmiDeviceInfo var1);

        public void onHdmiDeviceRemoved(HdmiDeviceInfo var1);

        public void onHdmiDeviceUpdated(String var1, HdmiDeviceInfo var2);
    }

    private class TvInputHardwareImpl
    extends ITvInputHardware.Stub {
        private final TvInputHardwareInfo mInfo;
        private boolean mReleased = false;
        private final Object mImplLock = new Object();
        private final AudioManager.OnAudioPortUpdateListener mAudioListener = new AudioManager.OnAudioPortUpdateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioPortListUpdate(AudioPort[] portList) {
                Object object = TvInputHardwareImpl.this.mImplLock;
                synchronized (object) {
                    TvInputHardwareImpl.this.updateAudioConfigLocked();
                }
            }

            @Override
            public void onAudioPatchListUpdate(AudioPatch[] patchList) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceDied() {
                Object object = TvInputHardwareImpl.this.mImplLock;
                synchronized (object) {
                    TvInputHardwareImpl.this.mAudioSource = null;
                    TvInputHardwareImpl.this.mAudioSink.clear();
                    if (TvInputHardwareImpl.this.mAudioPatch != null) {
                        TvInputHardwareManager.this.mAudioManager;
                        AudioManager.releaseAudioPatch(TvInputHardwareImpl.this.mAudioPatch);
                        TvInputHardwareImpl.this.mAudioPatch = null;
                    }
                }
            }
        };
        private int mOverrideAudioType = 0;
        private String mOverrideAudioAddress = "";
        private AudioDevicePort mAudioSource;
        private List<AudioDevicePort> mAudioSink = new ArrayList<AudioDevicePort>();
        private AudioPatch mAudioPatch = null;
        private float mCommittedVolume = -1.0f;
        private float mSourceVolume = 0.0f;
        private TvStreamConfig mActiveConfig = null;
        private int mDesiredSamplingRate = 0;
        private int mDesiredChannelMask = 1;
        private int mDesiredFormat = 1;

        public TvInputHardwareImpl(TvInputHardwareInfo info) {
            this.mInfo = info;
            TvInputHardwareManager.this.mAudioManager.registerAudioPortUpdateListener(this.mAudioListener);
            if (this.mInfo.getAudioType() != 0) {
                this.mAudioSource = this.findAudioDevicePort(this.mInfo.getAudioType(), this.mInfo.getAudioAddress());
                this.findAudioSinkFromAudioPolicy(this.mAudioSink);
            }
        }

        private void findAudioSinkFromAudioPolicy(List<AudioDevicePort> sinks) {
            sinks.clear();
            ArrayList<AudioDevicePort> devicePorts = new ArrayList<AudioDevicePort>();
            TvInputHardwareManager.this.mAudioManager;
            if (AudioManager.listAudioDevicePorts(devicePorts) != 0) {
                return;
            }
            int sinkDevice = TvInputHardwareManager.this.mAudioManager.getDevicesForStream(3);
            for (AudioDevicePort port : devicePorts) {
                if ((port.type() & sinkDevice) == 0 || (port.type() & Integer.MIN_VALUE) != 0) continue;
                sinks.add(port);
            }
        }

        private AudioDevicePort findAudioDevicePort(int type, String address) {
            if (type == 0) {
                return null;
            }
            ArrayList<AudioDevicePort> devicePorts = new ArrayList<AudioDevicePort>();
            TvInputHardwareManager.this.mAudioManager;
            if (AudioManager.listAudioDevicePorts(devicePorts) != 0) {
                return null;
            }
            for (AudioDevicePort port : devicePorts) {
                if (port.type() != type || !port.address().equals(address)) continue;
                return port;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Object object = this.mImplLock;
            synchronized (object) {
                TvInputHardwareManager.this.mAudioManager.unregisterAudioPortUpdateListener(this.mAudioListener);
                if (this.mAudioPatch != null) {
                    TvInputHardwareManager.this.mAudioManager;
                    AudioManager.releaseAudioPatch(this.mAudioPatch);
                    this.mAudioPatch = null;
                }
                this.mReleased = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean setSurface(Surface surface, TvStreamConfig config) throws RemoteException {
            Object object = this.mImplLock;
            synchronized (object) {
                if (this.mReleased) {
                    throw new IllegalStateException("Device already released.");
                }
                int result = 0;
                if (surface == null) {
                    if (this.mActiveConfig == null) return true;
                    result = TvInputHardwareManager.this.mHal.removeStream(this.mInfo.getDeviceId(), this.mActiveConfig);
                    this.mActiveConfig = null;
                } else {
                    if (config == null) {
                        return false;
                    }
                    if (this.mActiveConfig != null && !config.equals(this.mActiveConfig) && (result = TvInputHardwareManager.this.mHal.removeStream(this.mInfo.getDeviceId(), this.mActiveConfig)) != 0) {
                        this.mActiveConfig = null;
                    }
                    if (result == 0 && (result = TvInputHardwareManager.this.mHal.addOrUpdateStream(this.mInfo.getDeviceId(), surface, config)) == 0) {
                        this.mActiveConfig = config;
                    }
                }
                this.updateAudioConfigLocked();
                if (result != 0) return false;
                return true;
            }
        }

        private void updateAudioConfigLocked() {
            boolean sinkUpdated = this.updateAudioSinkLocked();
            boolean sourceUpdated = this.updateAudioSourceLocked();
            if (this.mAudioSource == null || this.mAudioSink.isEmpty() || this.mActiveConfig == null) {
                if (this.mAudioPatch != null) {
                    TvInputHardwareManager.this.mAudioManager;
                    AudioManager.releaseAudioPatch(this.mAudioPatch);
                    this.mAudioPatch = null;
                }
                return;
            }
            TvInputHardwareManager.this.updateVolume();
            float volume = this.mSourceVolume * TvInputHardwareManager.this.getMediaStreamVolume();
            AudioGainConfig sourceGainConfig = null;
            if (this.mAudioSource.gains().length > 0 && volume != this.mCommittedVolume) {
                Object sourceGain = null;
                for (AudioGain gain : this.mAudioSource.gains()) {
                    if ((gain.mode() & 1) == 0) continue;
                    sourceGain = gain;
                    break;
                }
                if (sourceGain != null) {
                    int steps = (((AudioGain)sourceGain).maxValue() - ((AudioGain)sourceGain).minValue()) / ((AudioGain)sourceGain).stepValue();
                    int gainValue = ((AudioGain)sourceGain).minValue();
                    gainValue = volume < 1.0f ? (gainValue += ((AudioGain)sourceGain).stepValue() * (int)((double)(volume * (float)steps) + 0.5)) : ((AudioGain)sourceGain).maxValue();
                    int[] gainValues = new int[]{gainValue};
                    sourceGainConfig = ((AudioGain)sourceGain).buildConfig(1, ((AudioGain)sourceGain).channelMask(), gainValues, 0);
                } else {
                    Slog.w(TAG, "No audio source gain with MODE_JOINT support exists.");
                }
            }
            AudioPortConfig sourceConfig = this.mAudioSource.activeConfig();
            ArrayList<AudioPortConfig> sinkConfigs = new ArrayList<AudioPortConfig>();
            AudioPatch[] audioPatchArray = new AudioPatch[]{this.mAudioPatch};
            boolean shouldRecreateAudioPatch = sourceUpdated || sinkUpdated;
            for (AudioDevicePort audioSink : this.mAudioSink) {
                AudioPortConfig sinkConfig = audioSink.activeConfig();
                int sinkSamplingRate = this.mDesiredSamplingRate;
                int sinkChannelMask = this.mDesiredChannelMask;
                int sinkFormat = this.mDesiredFormat;
                if (sinkConfig != null) {
                    if (sinkSamplingRate == 0) {
                        sinkSamplingRate = sinkConfig.samplingRate();
                    }
                    if (sinkChannelMask == 1) {
                        sinkChannelMask = sinkConfig.channelMask();
                    }
                    if (sinkFormat == 1) {
                        sinkChannelMask = sinkConfig.format();
                    }
                }
                if (sinkConfig == null || sinkConfig.samplingRate() != sinkSamplingRate || sinkConfig.channelMask() != sinkChannelMask || sinkConfig.format() != sinkFormat) {
                    if (!TvInputHardwareManager.intArrayContains(audioSink.samplingRates(), sinkSamplingRate) && audioSink.samplingRates().length > 0) {
                        sinkSamplingRate = audioSink.samplingRates()[0];
                    }
                    if (!TvInputHardwareManager.intArrayContains(audioSink.channelMasks(), sinkChannelMask)) {
                        sinkChannelMask = 1;
                    }
                    if (!TvInputHardwareManager.intArrayContains(audioSink.formats(), sinkFormat)) {
                        sinkFormat = 1;
                    }
                    sinkConfig = audioSink.buildConfig(sinkSamplingRate, sinkChannelMask, sinkFormat, null);
                    shouldRecreateAudioPatch = true;
                }
                sinkConfigs.add(sinkConfig);
            }
            AudioPortConfig sinkConfig = (AudioPortConfig)sinkConfigs.get(0);
            if (sourceConfig == null || sourceGainConfig != null) {
                int sourceSamplingRate = 0;
                if (TvInputHardwareManager.intArrayContains(this.mAudioSource.samplingRates(), sinkConfig.samplingRate())) {
                    sourceSamplingRate = sinkConfig.samplingRate();
                } else if (this.mAudioSource.samplingRates().length > 0) {
                    sourceSamplingRate = this.mAudioSource.samplingRates()[0];
                }
                int sourceChannelMask = 1;
                for (int inChannelMask : this.mAudioSource.channelMasks()) {
                    if (AudioFormat.channelCountFromOutChannelMask(sinkConfig.channelMask()) != AudioFormat.channelCountFromInChannelMask(inChannelMask)) continue;
                    sourceChannelMask = inChannelMask;
                    break;
                }
                int sourceFormat = 1;
                if (TvInputHardwareManager.intArrayContains(this.mAudioSource.formats(), sinkConfig.format())) {
                    sourceFormat = sinkConfig.format();
                }
                sourceConfig = this.mAudioSource.buildConfig(sourceSamplingRate, sourceChannelMask, sourceFormat, sourceGainConfig);
                shouldRecreateAudioPatch = true;
            }
            if (shouldRecreateAudioPatch) {
                this.mCommittedVolume = volume;
                if (this.mAudioPatch != null) {
                    TvInputHardwareManager.this.mAudioManager;
                    AudioManager.releaseAudioPatch(this.mAudioPatch);
                }
                TvInputHardwareManager.this.mAudioManager;
                AudioManager.createAudioPatch(audioPatchArray, new AudioPortConfig[]{sourceConfig}, sinkConfigs.toArray(new AudioPortConfig[sinkConfigs.size()]));
                this.mAudioPatch = audioPatchArray[0];
                if (sourceGainConfig != null) {
                    TvInputHardwareManager.this.mAudioManager;
                    AudioManager.setAudioPortGain(this.mAudioSource, sourceGainConfig);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStreamVolume(float volume) throws RemoteException {
            Object object = this.mImplLock;
            synchronized (object) {
                if (this.mReleased) {
                    throw new IllegalStateException("Device already released.");
                }
                this.mSourceVolume = volume;
                this.updateAudioConfigLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean dispatchKeyEventToHdmi(KeyEvent event) throws RemoteException {
            Object object = this.mImplLock;
            synchronized (object) {
                if (this.mReleased) {
                    throw new IllegalStateException("Device already released.");
                }
            }
            if (this.mInfo.getType() != 9) {
                return false;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean startCapture(Surface surface, TvStreamConfig config) {
            Object object = this.mImplLock;
            synchronized (object) {
                if (this.mReleased) {
                    return false;
                }
                if (surface == null || config == null) {
                    return false;
                }
                if (config.getType() != 2) {
                    return false;
                }
                int result = TvInputHardwareManager.this.mHal.addOrUpdateStream(this.mInfo.getDeviceId(), surface, config);
                boolean bl = result == 0;
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean stopCapture(TvStreamConfig config) {
            Object object = this.mImplLock;
            synchronized (object) {
                if (this.mReleased) {
                    return false;
                }
                if (config == null) {
                    return false;
                }
                int result = TvInputHardwareManager.this.mHal.removeStream(this.mInfo.getDeviceId(), config);
                boolean bl = result == 0;
                return bl;
            }
        }

        private boolean updateAudioSourceLocked() {
            if (this.mInfo.getAudioType() == 0) {
                return false;
            }
            AudioDevicePort previousSource = this.mAudioSource;
            this.mAudioSource = this.findAudioDevicePort(this.mInfo.getAudioType(), this.mInfo.getAudioAddress());
            return this.mAudioSource == null ? previousSource != null : !this.mAudioSource.equals(previousSource);
        }

        private boolean updateAudioSinkLocked() {
            if (this.mInfo.getAudioType() == 0) {
                return false;
            }
            List<AudioDevicePort> previousSink = this.mAudioSink;
            this.mAudioSink = new ArrayList<AudioDevicePort>();
            if (this.mOverrideAudioType == 0) {
                this.findAudioSinkFromAudioPolicy(this.mAudioSink);
            } else {
                AudioDevicePort audioSink = this.findAudioDevicePort(this.mOverrideAudioType, this.mOverrideAudioAddress);
                if (audioSink != null) {
                    this.mAudioSink.add(audioSink);
                }
            }
            if (this.mAudioSink.size() != previousSink.size()) {
                return true;
            }
            previousSink.removeAll(this.mAudioSink);
            return !previousSink.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleAudioSinkUpdated() {
            Object object = this.mImplLock;
            synchronized (object) {
                this.updateAudioConfigLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void overrideAudioSink(int audioType, String audioAddress, int samplingRate, int channelMask, int format) {
            Object object = this.mImplLock;
            synchronized (object) {
                this.mOverrideAudioType = audioType;
                this.mOverrideAudioAddress = audioAddress;
                this.mDesiredSamplingRate = samplingRate;
                this.mDesiredChannelMask = channelMask;
                this.mDesiredFormat = format;
                this.updateAudioConfigLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMediaStreamVolumeChanged() {
            Object object = this.mImplLock;
            synchronized (object) {
                this.updateAudioConfigLocked();
            }
        }
    }

    private class Connection
    implements IBinder.DeathRecipient {
        private final TvInputHardwareInfo mHardwareInfo;
        private TvInputInfo mInfo;
        private TvInputHardwareImpl mHardware = null;
        private ITvInputHardwareCallback mCallback;
        private TvStreamConfig[] mConfigs = null;
        private Integer mCallingUid = null;
        private Integer mResolvedUserId = null;
        private Runnable mOnFirstFrameCaptured;

        public Connection(TvInputHardwareInfo hardwareInfo) {
            this.mHardwareInfo = hardwareInfo;
        }

        public void resetLocked(TvInputHardwareImpl hardware, ITvInputHardwareCallback callback, TvInputInfo info, Integer callingUid, Integer resolvedUserId) {
            if (this.mHardware != null) {
                try {
                    this.mCallback.onReleased();
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "error in Connection::resetLocked", e);
                }
                this.mHardware.release();
            }
            this.mHardware = hardware;
            this.mCallback = callback;
            this.mInfo = info;
            this.mCallingUid = callingUid;
            this.mResolvedUserId = resolvedUserId;
            this.mOnFirstFrameCaptured = null;
            if (this.mHardware != null && this.mCallback != null) {
                try {
                    this.mCallback.onStreamConfigChanged(this.getConfigsLocked());
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "error in Connection::resetLocked", e);
                }
            }
        }

        public void updateConfigsLocked(TvStreamConfig[] configs) {
            this.mConfigs = configs;
        }

        public TvInputHardwareInfo getHardwareInfoLocked() {
            return this.mHardwareInfo;
        }

        public TvInputInfo getInfoLocked() {
            return this.mInfo;
        }

        public ITvInputHardware getHardwareLocked() {
            return this.mHardware;
        }

        public TvInputHardwareImpl getHardwareImplLocked() {
            return this.mHardware;
        }

        public ITvInputHardwareCallback getCallbackLocked() {
            return this.mCallback;
        }

        public TvStreamConfig[] getConfigsLocked() {
            return this.mConfigs;
        }

        public Integer getCallingUidLocked() {
            return this.mCallingUid;
        }

        public Integer getResolvedUserIdLocked() {
            return this.mResolvedUserId;
        }

        public void setOnFirstFrameCapturedLocked(Runnable runnable) {
            this.mOnFirstFrameCaptured = runnable;
        }

        public Runnable getOnFirstFrameCapturedLocked() {
            return this.mOnFirstFrameCaptured;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = TvInputHardwareManager.this.mLock;
            synchronized (object) {
                this.resetLocked(null, null, null, null, null);
            }
        }

        public String toString() {
            return "Connection{ mHardwareInfo: " + this.mHardwareInfo + ", mInfo: " + this.mInfo + ", mCallback: " + this.mCallback + ", mConfigs: " + Arrays.toString(this.mConfigs) + ", mCallingUid: " + this.mCallingUid + ", mResolvedUserId: " + this.mResolvedUserId + " }";
        }
    }
}

