/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.twilight;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.format.Time;
import com.android.server.SystemService;
import com.android.server.TwilightCalculator;
import com.android.server.twilight.TwilightListener;
import com.android.server.twilight.TwilightManager;
import com.android.server.twilight.TwilightState;
import java.util.ArrayList;
import java.util.Iterator;
import libcore.util.Objects;

public final class TwilightService
extends SystemService {
    static final String TAG = "TwilightService";
    static final boolean DEBUG = false;
    static final String ACTION_UPDATE_TWILIGHT_STATE = "com.android.server.action.UPDATE_TWILIGHT_STATE";
    private static final long TWILIGHT_ADJUSTMENT_TIME = 0x6DDD00L;
    public static final String ACTION_TWILIGHT_CHANGED = "android.intent.action.TWILIGHT_CHANGED";
    public static final String EXTRA_IS_NIGHT = "isNight";
    public static final String EXTRA_AMOUNT = "amount";
    private static final long RESET_TIME = 0x6DDD00L;
    private static final String EXTRA_RESET_USER = "user";
    private static final String ACTION_RESET_TWILIGHT_AUTO = "com.android.server.action.RESET_TWILIGHT_AUTO";
    final Object mLock = new Object();
    AlarmManager mAlarmManager;
    LocationManager mLocationManager;
    LocationHandler mLocationHandler;
    final ArrayList<TwilightListenerRecord> mListeners = new ArrayList();
    TwilightState mTwilightState;
    private int mCurrentUser;
    private boolean mLocked;
    private boolean mBootCompleted;
    private final TwilightManager mService = new TwilightManager(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TwilightState getCurrentState() {
            Object object = TwilightService.this.mLock;
            synchronized (object) {
                return TwilightService.this.mTwilightState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerListener(TwilightListener listener, Handler handler) {
            Object object = TwilightService.this.mLock;
            synchronized (object) {
                TwilightService.this.mListeners.add(new TwilightListenerRecord(listener, handler));
                if (TwilightService.this.mListeners.size() == 1) {
                    TwilightService.this.mLocationHandler.enableLocationUpdates();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterListener(TwilightListener listener) {
            Object object = TwilightService.this.mLock;
            synchronized (object) {
                for (int i = 0; i < TwilightService.this.mListeners.size(); ++i) {
                    if (TwilightService.this.mListeners.get(i).mListener != listener) continue;
                    TwilightService.this.mListeners.remove(i);
                }
                if (TwilightService.this.mListeners.size() == 0) {
                    TwilightService.this.mLocationHandler.disableLocationUpdates();
                }
            }
        }
    };
    private final ContentObserver mContentObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            int value = Settings.Secure.getIntForUser(TwilightService.this.getContext().getContentResolver(), "twilight_mode", 0, TwilightService.this.mCurrentUser);
            if (value == 0) {
                TwilightService.this.setLockedState(new TwilightState(false, 0.0f));
            } else if (value == 1) {
                TwilightService.this.setLockedState(new TwilightState(true, 1.0f));
            } else if (value == 3) {
                TwilightService.this.setLockedState(new TwilightState(false, 0.0f));
                TwilightService.this.scheduleReset();
            } else if (value == 4) {
                TwilightService.this.setLockedState(new TwilightState(true, 1.0f));
                TwilightService.this.scheduleReset();
            } else {
                TwilightService.this.mLocked = false;
                TwilightService.this.mLocationHandler.requestTwilightUpdate();
            }
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_SWITCHED".equals(intent.getAction())) {
                TwilightService.this.mCurrentUser = ActivityManager.getCurrentUser();
                TwilightService.this.reregisterSettingObserver();
                return;
            }
            if ("android.intent.action.AIRPLANE_MODE".equals(intent.getAction()) && !intent.getBooleanExtra("state", false)) {
                TwilightService.this.mLocationHandler.requestLocationUpdate();
                return;
            }
            if (TwilightService.ACTION_RESET_TWILIGHT_AUTO.equals(intent.getAction())) {
                int user = intent.getIntExtra(TwilightService.EXTRA_RESET_USER, 0);
                Settings.Secure.putIntForUser(TwilightService.this.getContext().getContentResolver(), "twilight_mode", 2, user);
                return;
            }
            TwilightService.this.mLocationHandler.requestTwilightUpdate();
        }
    };
    private final LocationListener mEmptyLocationListener = new LocationListener(){

        @Override
        public void onLocationChanged(Location location) {
        }

        @Override
        public void onProviderDisabled(String provider) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }
    };
    private final LocationListener mLocationListener = new LocationListener(){

        @Override
        public void onLocationChanged(Location location) {
            TwilightService.this.mLocationHandler.processNewLocation(location);
        }

        @Override
        public void onProviderDisabled(String provider) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }
    };

    public TwilightService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
        this.mAlarmManager = (AlarmManager)this.getContext().getSystemService("alarm");
        this.mLocationManager = (LocationManager)this.getContext().getSystemService("location");
        this.mLocationHandler = new LocationHandler();
        this.mCurrentUser = ActivityManager.getCurrentUser();
        IntentFilter filter = new IntentFilter("android.intent.action.AIRPLANE_MODE");
        filter.addAction("android.intent.action.TIME_SET");
        filter.addAction("android.intent.action.TIMEZONE_CHANGED");
        filter.addAction("android.intent.action.USER_SWITCHED");
        filter.addAction(ACTION_UPDATE_TWILIGHT_STATE);
        this.getContext().registerReceiver(this.mReceiver, filter);
        this.publishLocalService(TwilightManager.class, this.mService);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 1000) {
            this.getContext().getContentResolver().registerContentObserver(Settings.Secure.getUriFor("twilight_mode"), false, this.mContentObserver, this.mCurrentUser);
            this.mContentObserver.onChange(true);
            this.mBootCompleted = true;
            this.sendBroadcast();
        }
    }

    private void reregisterSettingObserver() {
        ContentResolver contentResolver = this.getContext().getContentResolver();
        contentResolver.unregisterContentObserver(this.mContentObserver);
        contentResolver.registerContentObserver(Settings.Secure.getUriFor("twilight_mode"), false, this.mContentObserver, this.mCurrentUser);
        this.mContentObserver.onChange(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLockedState(TwilightState state) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLocked = false;
            this.setTwilightState(state);
            this.mLocked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTwilightState(TwilightState state) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLocked) {
                return;
            }
            if (!Objects.equal(this.mTwilightState, state)) {
                this.mTwilightState = state;
                int listenerLen = this.mListeners.size();
                for (int i = 0; i < listenerLen; ++i) {
                    this.mListeners.get(i).postUpdate();
                }
            }
        }
        this.sendBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBroadcast() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTwilightState == null) {
                return;
            }
            if (this.mBootCompleted) {
                Intent intent = new Intent(ACTION_TWILIGHT_CHANGED);
                intent.putExtra(EXTRA_IS_NIGHT, this.mTwilightState.isNight());
                intent.putExtra(EXTRA_AMOUNT, this.mTwilightState.getAmount());
                intent.addFlags(0x40000000);
                this.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            }
        }
    }

    private void scheduleReset() {
        long resetTime = System.currentTimeMillis() + 0x6DDD00L;
        Intent resetIntent = new Intent(ACTION_RESET_TWILIGHT_AUTO);
        resetIntent.putExtra(EXTRA_RESET_USER, this.mCurrentUser);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(this.getContext(), 0, resetIntent, 0);
        this.mAlarmManager.cancel(pendingIntent);
        this.mAlarmManager.setExact(1, resetTime, pendingIntent);
    }

    private static boolean hasMoved(Location from, Location to) {
        float totalAccuracy;
        if (to == null) {
            return false;
        }
        if (from == null) {
            return true;
        }
        if (to.getElapsedRealtimeNanos() < from.getElapsedRealtimeNanos()) {
            return false;
        }
        float distance = from.distanceTo(to);
        return distance >= (totalAccuracy = from.getAccuracy() + to.getAccuracy());
    }

    private final class LocationHandler
    extends Handler {
        private static final int MSG_ENABLE_LOCATION_UPDATES = 1;
        private static final int MSG_GET_NEW_LOCATION_UPDATE = 2;
        private static final int MSG_PROCESS_NEW_LOCATION = 3;
        private static final int MSG_DO_TWILIGHT_UPDATE = 4;
        private static final int MSG_DISABLE_LOCATION_UPDATES = 5;
        private static final long LOCATION_UPDATE_MS = 86400000L;
        private static final long MIN_LOCATION_UPDATE_MS = 1800000L;
        private static final float LOCATION_UPDATE_DISTANCE_METER = 20000.0f;
        private static final long LOCATION_UPDATE_ENABLE_INTERVAL_MIN = 5000L;
        private static final long LOCATION_UPDATE_ENABLE_INTERVAL_MAX = 900000L;
        private static final double FACTOR_GMT_OFFSET_LONGITUDE = 0.004166666666666667;
        private boolean mPassiveListenerEnabled;
        private boolean mNetworkListenerEnabled;
        private boolean mDidFirstInit;
        private long mLastNetworkRegisterTime = -1800000L;
        private long mLastUpdateInterval;
        private Location mLocation;
        private final TwilightCalculator mTwilightCalculator = new TwilightCalculator();

        private LocationHandler() {
        }

        public void processNewLocation(Location location) {
            Message msg = this.obtainMessage(3, location);
            this.sendMessage(msg);
        }

        public void enableLocationUpdates() {
            this.sendEmptyMessage(1);
        }

        public void disableLocationUpdates() {
            this.sendEmptyMessage(5);
        }

        public void requestLocationUpdate() {
            this.sendEmptyMessage(2);
        }

        public void requestTwilightUpdate() {
            this.sendEmptyMessage(4);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    boolean hasBetterAccuracy;
                    Location location = (Location)msg.obj;
                    boolean hasMoved = TwilightService.hasMoved(this.mLocation, location);
                    boolean bl = hasBetterAccuracy = this.mLocation == null || location.getAccuracy() < this.mLocation.getAccuracy();
                    if (!hasMoved && !hasBetterAccuracy) break;
                    this.setLocation(location);
                    break;
                }
                case 2: {
                    if (!this.mNetworkListenerEnabled) {
                        return;
                    }
                    if (this.mLastNetworkRegisterTime + 1800000L >= SystemClock.elapsedRealtime()) {
                        return;
                    }
                    this.mNetworkListenerEnabled = false;
                    TwilightService.this.mLocationManager.removeUpdates(TwilightService.this.mEmptyLocationListener);
                }
                case 1: {
                    boolean passiveLocationEnabled;
                    boolean networkLocationEnabled;
                    try {
                        networkLocationEnabled = TwilightService.this.mLocationManager.isProviderEnabled("network");
                    }
                    catch (Exception e) {
                        networkLocationEnabled = false;
                    }
                    if (!this.mNetworkListenerEnabled && networkLocationEnabled) {
                        this.mNetworkListenerEnabled = true;
                        this.mLastNetworkRegisterTime = SystemClock.elapsedRealtime();
                        TwilightService.this.mLocationManager.requestLocationUpdates("network", 86400000L, 0.0f, TwilightService.this.mEmptyLocationListener);
                        if (!this.mDidFirstInit) {
                            this.mDidFirstInit = true;
                            if (this.mLocation == null) {
                                this.retrieveLocation();
                            }
                        }
                    }
                    try {
                        passiveLocationEnabled = TwilightService.this.mLocationManager.isProviderEnabled("passive");
                    }
                    catch (Exception e) {
                        passiveLocationEnabled = false;
                    }
                    if (!this.mPassiveListenerEnabled && passiveLocationEnabled) {
                        this.mPassiveListenerEnabled = true;
                        TwilightService.this.mLocationManager.requestLocationUpdates("passive", 0L, 20000.0f, TwilightService.this.mLocationListener);
                    }
                    if (this.mNetworkListenerEnabled && this.mPassiveListenerEnabled) break;
                    this.mLastUpdateInterval = (long)((double)this.mLastUpdateInterval * 1.5);
                    if (this.mLastUpdateInterval == 0L) {
                        this.mLastUpdateInterval = 5000L;
                    } else if (this.mLastUpdateInterval > 900000L) {
                        this.mLastUpdateInterval = 900000L;
                    }
                    this.sendEmptyMessageDelayed(1, this.mLastUpdateInterval);
                    break;
                }
                case 5: {
                    TwilightService.this.mLocationManager.removeUpdates(TwilightService.this.mLocationListener);
                    this.removeMessages(1);
                    break;
                }
                case 4: {
                    this.updateTwilightState();
                }
            }
        }

        private void retrieveLocation() {
            Location location = null;
            Iterator<String> providers = TwilightService.this.mLocationManager.getProviders(new Criteria(), true).iterator();
            while (providers.hasNext()) {
                Location lastKnownLocation = TwilightService.this.mLocationManager.getLastKnownLocation(providers.next());
                if (location != null && (lastKnownLocation == null || location.getElapsedRealtimeNanos() >= lastKnownLocation.getElapsedRealtimeNanos())) continue;
                location = lastKnownLocation;
            }
            if (location == null) {
                Time currentTime = new Time();
                currentTime.set(System.currentTimeMillis());
                double lngOffset = 0.004166666666666667 * (double)(currentTime.gmtoff - (long)(currentTime.isDst > 0 ? 3600 : 0));
                location = new Location("fake");
                location.setLongitude(lngOffset);
                location.setLatitude(0.0);
                location.setAccuracy(417000.0f);
                location.setTime(System.currentTimeMillis());
                location.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
            }
            this.setLocation(location);
        }

        private void setLocation(Location location) {
            this.mLocation = location;
            this.updateTwilightState();
        }

        private void updateTwilightState() {
            if (this.mLocation == null) {
                TwilightService.this.setTwilightState(null);
                return;
            }
            long now = System.currentTimeMillis();
            this.mTwilightCalculator.calculateTwilight(now, this.mLocation.getLatitude(), this.mLocation.getLongitude());
            boolean isNight = this.mTwilightCalculator.mState == 1;
            long todaySunrise = this.mTwilightCalculator.mSunrise;
            long todaySunset = this.mTwilightCalculator.mSunset;
            this.mTwilightCalculator.calculateTwilight(now + 86400000L, this.mLocation.getLatitude(), this.mLocation.getLongitude());
            long tomorrowSunrise = this.mTwilightCalculator.mSunrise;
            float amount = 0.0f;
            if (isNight) {
                amount = todaySunrise == -1L || todaySunset == -1L ? 1.0f : (now > todaySunset ? Math.min(1.0f, (float)(now - todaySunset) / 7200000.0f) : Math.max(0.0f, 1.0f - (float)(todaySunrise - now) / 7200000.0f));
            }
            TwilightState state = new TwilightState(isNight, amount);
            TwilightService.this.setTwilightState(state);
            long nextUpdate = 0L;
            if (todaySunrise == -1L || todaySunset == -1L) {
                nextUpdate = now + 43200000L;
            } else {
                nextUpdate += 60000L;
                nextUpdate = amount == 1.0f || amount == 0.0f ? (now > todaySunset ? (nextUpdate += tomorrowSunrise) : (now > todaySunrise ? (nextUpdate += todaySunset) : (nextUpdate += todaySunrise))) : (nextUpdate += 540000L);
            }
            Intent updateIntent = new Intent(TwilightService.ACTION_UPDATE_TWILIGHT_STATE);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(TwilightService.this.getContext(), 0, updateIntent, 0);
            TwilightService.this.mAlarmManager.cancel(pendingIntent);
            TwilightService.this.mAlarmManager.setExact(1, nextUpdate, pendingIntent);
        }
    }

    private static class TwilightListenerRecord
    implements Runnable {
        private final TwilightListener mListener;
        private final Handler mHandler;

        public TwilightListenerRecord(TwilightListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        public void postUpdate() {
            this.mHandler.post(this);
        }

        @Override
        public void run() {
            this.mListener.onTwilightStateChanged();
        }
    }
}

