/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.updates;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.util.HexDump;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import libcore.io.IoUtils;
import libcore.io.Streams;

public class ConfigUpdateInstallReceiver
extends BroadcastReceiver {
    private static final String TAG = "ConfigUpdateInstallReceiver";
    private static final String EXTRA_REQUIRED_HASH = "REQUIRED_HASH";
    private static final String EXTRA_VERSION_NUMBER = "VERSION";
    protected final File updateDir;
    protected final File updateContent;
    protected final File updateVersion;

    public ConfigUpdateInstallReceiver(String updateDir, String updateContentPath, String updateMetadataPath, String updateVersionPath) {
        this.updateDir = new File(updateDir);
        this.updateContent = new File(updateDir, updateContentPath);
        File updateMetadataDir = new File(updateDir, updateMetadataPath);
        this.updateVersion = new File(updateMetadataDir, updateVersionPath);
    }

    @Override
    public void onReceive(final Context context, final Intent intent) {
        new Thread(){

            @Override
            public void run() {
                try {
                    byte[] altContent = ConfigUpdateInstallReceiver.this.getAltContent(context, intent);
                    int altVersion = ConfigUpdateInstallReceiver.this.getVersionFromIntent(intent);
                    String altRequiredHash = ConfigUpdateInstallReceiver.this.getRequiredHashFromIntent(intent);
                    int currentVersion = ConfigUpdateInstallReceiver.this.getCurrentVersion();
                    String currentHash = ConfigUpdateInstallReceiver.getCurrentHash(ConfigUpdateInstallReceiver.this.getCurrentContent());
                    if (!ConfigUpdateInstallReceiver.this.verifyVersion(currentVersion, altVersion)) {
                        Slog.i(ConfigUpdateInstallReceiver.TAG, "Not installing, new version is <= current version");
                    } else if (!ConfigUpdateInstallReceiver.this.verifyPreviousHash(currentHash, altRequiredHash)) {
                        EventLog.writeEvent(51300, "Current hash did not match required value");
                    } else {
                        Slog.i(ConfigUpdateInstallReceiver.TAG, "Found new update, installing...");
                        ConfigUpdateInstallReceiver.this.install(altContent, altVersion);
                        Slog.i(ConfigUpdateInstallReceiver.TAG, "Installation successful");
                        ConfigUpdateInstallReceiver.this.postInstall(context, intent);
                    }
                }
                catch (Exception e) {
                    Slog.e(ConfigUpdateInstallReceiver.TAG, "Could not update content!", e);
                    String errMsg = e.toString();
                    if (errMsg.length() > 100) {
                        errMsg = errMsg.substring(0, 99);
                    }
                    EventLog.writeEvent(51300, errMsg);
                }
            }
        }.start();
    }

    private Uri getContentFromIntent(Intent i) {
        Uri data = i.getData();
        if (data == null) {
            throw new IllegalStateException("Missing required content path, ignoring.");
        }
        return data;
    }

    private int getVersionFromIntent(Intent i) throws NumberFormatException {
        String extraValue = i.getStringExtra(EXTRA_VERSION_NUMBER);
        if (extraValue == null) {
            throw new IllegalStateException("Missing required version number, ignoring.");
        }
        return Integer.parseInt(extraValue.trim());
    }

    private String getRequiredHashFromIntent(Intent i) {
        String extraValue = i.getStringExtra(EXTRA_REQUIRED_HASH);
        if (extraValue == null) {
            throw new IllegalStateException("Missing required previous hash, ignoring.");
        }
        return extraValue.trim();
    }

    private int getCurrentVersion() throws NumberFormatException {
        try {
            String strVersion = IoUtils.readFileAsString(this.updateVersion.getCanonicalPath()).trim();
            return Integer.parseInt(strVersion);
        }
        catch (IOException e) {
            Slog.i(TAG, "Couldn't find current metadata, assuming first update");
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getAltContent(Context c, Intent i) throws IOException {
        Uri content = this.getContentFromIntent(i);
        try (InputStream is = c.getContentResolver().openInputStream(content);){
            byte[] byArray = Streams.readFullyNoClose(is);
            return byArray;
        }
    }

    private byte[] getCurrentContent() {
        try {
            return IoUtils.readFileAsByteArray(this.updateContent.getCanonicalPath());
        }
        catch (IOException e) {
            Slog.i(TAG, "Failed to read current content, assuming first update!");
            return null;
        }
    }

    private static String getCurrentHash(byte[] content) {
        if (content == null) {
            return "0";
        }
        try {
            MessageDigest dgst = MessageDigest.getInstance("SHA512");
            byte[] fingerprint = dgst.digest(content);
            return HexDump.toHexString(fingerprint, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private boolean verifyVersion(int current, int alternative) {
        return current < alternative;
    }

    private boolean verifyPreviousHash(String current, String required) {
        if (required.equals("NONE")) {
            return true;
        }
        return current.equals(required);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeUpdate(File dir, File file, byte[] content) throws IOException {
        FileOutputStream out;
        block5: {
            out = null;
            File tmp = null;
            try {
                File parent = file.getParentFile();
                parent.mkdirs();
                if (!parent.exists()) {
                    throw new IOException("Failed to create directory " + parent.getCanonicalPath());
                }
                tmp = File.createTempFile("journal", "", dir);
                tmp.setReadable(true, false);
                out = new FileOutputStream(tmp);
                out.write(content);
                out.getFD().sync();
                if (!tmp.renameTo(file)) {
                    throw new IOException("Failed to atomically rename " + file.getCanonicalPath());
                }
                if (tmp == null) break block5;
                tmp.delete();
            }
            catch (Throwable throwable) {
                if (tmp != null) {
                    tmp.delete();
                }
                IoUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(out);
    }

    protected void install(byte[] content, int version) throws IOException {
        this.writeUpdate(this.updateDir, this.updateContent, content);
        this.writeUpdate(this.updateDir, this.updateVersion, Long.toString(version).getBytes());
    }

    protected void postInstall(Context context, Intent intent) {
    }
}

