/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UEventObserver;
import android.os.UserHandle;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.FgThread;
import java.io.File;
import java.io.IOException;
import libcore.io.IoUtils;

public class UsbPortManager {
    private static final String TAG = "UsbPortManager";
    private static final int MSG_UPDATE_PORTS = 1;
    private static final String UEVENT_FILTER = "SUBSYSTEM=dual_role_usb";
    private static final String SYSFS_CLASS = "/sys/class/dual_role_usb";
    private static final String SYSFS_PORT_SUPPORTED_MODES = "supported_modes";
    private static final String SYSFS_PORT_MODE = "mode";
    private static final String SYSFS_PORT_POWER_ROLE = "power_role";
    private static final String SYSFS_PORT_DATA_ROLE = "data_role";
    private static final String PORT_MODE_DFP = "dfp";
    private static final String PORT_MODE_UFP = "ufp";
    private static final String PORT_POWER_ROLE_SOURCE = "source";
    private static final String PORT_POWER_ROLE_SINK = "sink";
    private static final String PORT_DATA_ROLE_HOST = "host";
    private static final String PORT_DATA_ROLE_DEVICE = "device";
    private static final String USB_TYPEC_PROP_PREFIX = "sys.usb.typec.";
    private static final String USB_TYPEC_STATE = "sys.usb.typec.state";
    private static final int COMBO_SOURCE_HOST = UsbPort.combineRolesAsBit(1, 1);
    private static final int COMBO_SOURCE_DEVICE = UsbPort.combineRolesAsBit(1, 2);
    private static final int COMBO_SINK_HOST = UsbPort.combineRolesAsBit(2, 1);
    private static final int COMBO_SINK_DEVICE = UsbPort.combineRolesAsBit(2, 2);
    private final Context mContext;
    private final boolean mHaveKernelSupport;
    private final Object mLock = new Object();
    private final ArrayMap<String, PortInfo> mPorts = new ArrayMap();
    private final ArrayMap<String, SimulatedPortInfo> mSimulatedPorts = new ArrayMap();
    private final Handler mHandler = new Handler(FgThread.get().getLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Object object = UsbPortManager.this.mLock;
                    synchronized (object) {
                        UsbPortManager.this.updatePortsLocked(null);
                        break;
                    }
                }
            }
        }
    };
    private final UEventObserver mUEventObserver = new UEventObserver(){

        @Override
        public void onUEvent(UEventObserver.UEvent event) {
            UsbPortManager.this.scheduleUpdatePorts();
        }
    };

    public UsbPortManager(Context context) {
        this.mContext = context;
        this.mHaveKernelSupport = new File(SYSFS_CLASS).exists();
    }

    public void systemReady() {
        this.mUEventObserver.startObserving(UEVENT_FILTER);
        this.scheduleUpdatePorts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbPort[] getPorts() {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mPorts.size();
            UsbPort[] result = new UsbPort[count];
            for (int i = 0; i < count; ++i) {
                result[i] = this.mPorts.valueAt((int)i).mUsbPort;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbPortStatus getPortStatus(String portId) {
        Object object = this.mLock;
        synchronized (object) {
            PortInfo portInfo = this.mPorts.get(portId);
            return portInfo != null ? portInfo.mUsbPortStatus : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPortRoles(String portId, int newPowerRole, int newDataRole, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            int newMode;
            int currentMode;
            int currentPowerRole;
            int currentDataRole;
            block18: {
                block19: {
                    PortInfo portInfo = this.mPorts.get(portId);
                    if (portInfo == null) {
                        if (pw == null) return;
                        pw.println("No such USB port: " + portId);
                        return;
                    }
                    if (!portInfo.mUsbPortStatus.isRoleCombinationSupported(newPowerRole, newDataRole)) {
                        UsbPortManager.logAndPrint(6, pw, "Attempted to set USB port into unsupported role combination: portId=" + portId + ", newPowerRole=" + UsbPort.powerRoleToString(newPowerRole) + ", newDataRole=" + UsbPort.dataRoleToString(newDataRole));
                        return;
                    }
                    currentDataRole = portInfo.mUsbPortStatus.getCurrentDataRole();
                    currentPowerRole = portInfo.mUsbPortStatus.getCurrentPowerRole();
                    if (currentDataRole == newDataRole && currentPowerRole == newPowerRole) {
                        if (pw == null) return;
                        pw.println("No change.");
                        return;
                    }
                    boolean canChangeMode = portInfo.mCanChangeMode;
                    boolean canChangePowerRole = portInfo.mCanChangePowerRole;
                    boolean canChangeDataRole = portInfo.mCanChangeDataRole;
                    currentMode = portInfo.mUsbPortStatus.getCurrentMode();
                    if ((canChangePowerRole || currentPowerRole == newPowerRole) && (canChangeDataRole || currentDataRole == newDataRole)) break block19;
                    if (canChangeMode && newPowerRole == 1 && newDataRole == 1) {
                        newMode = 1;
                        break block18;
                    } else if (canChangeMode && newPowerRole == 2 && newDataRole == 2) {
                        newMode = 2;
                        break block18;
                    } else {
                        UsbPortManager.logAndPrint(6, pw, "Found mismatch in supported USB role combinations while attempting to change role: " + portInfo + ", newPowerRole=" + UsbPort.powerRoleToString(newPowerRole) + ", newDataRole=" + UsbPort.dataRoleToString(newDataRole));
                        return;
                    }
                }
                newMode = currentMode;
            }
            UsbPortManager.logAndPrint(4, pw, "Setting USB port mode and role: portId=" + portId + ", currentMode=" + UsbPort.modeToString(currentMode) + ", currentPowerRole=" + UsbPort.powerRoleToString(currentPowerRole) + ", currentDataRole=" + UsbPort.dataRoleToString(currentDataRole) + ", newMode=" + UsbPort.modeToString(newMode) + ", newPowerRole=" + UsbPort.powerRoleToString(newPowerRole) + ", newDataRole=" + UsbPort.dataRoleToString(newDataRole));
            SimulatedPortInfo sim = this.mSimulatedPorts.get(portId);
            if (sim != null) {
                sim.mCurrentMode = newMode;
                sim.mCurrentPowerRole = newPowerRole;
                sim.mCurrentDataRole = newDataRole;
            } else if (this.mHaveKernelSupport) {
                File portDir = new File(SYSFS_CLASS, portId);
                if (!portDir.exists()) {
                    UsbPortManager.logAndPrint(6, pw, "USB port not found: portId=" + portId);
                    return;
                }
                if (currentMode != newMode) {
                    if (!UsbPortManager.writeFile(portDir, SYSFS_PORT_MODE, newMode == 1 ? PORT_MODE_DFP : PORT_MODE_UFP)) {
                        UsbPortManager.logAndPrint(6, pw, "Failed to set the USB port mode: portId=" + portId + ", newMode=" + UsbPort.modeToString(newMode));
                        return;
                    }
                } else {
                    if (currentPowerRole != newPowerRole && !UsbPortManager.writeFile(portDir, SYSFS_PORT_POWER_ROLE, newPowerRole == 1 ? PORT_POWER_ROLE_SOURCE : PORT_POWER_ROLE_SINK)) {
                        UsbPortManager.logAndPrint(6, pw, "Failed to set the USB port power role: portId=" + portId + ", newPowerRole=" + UsbPort.powerRoleToString(newPowerRole));
                        return;
                    }
                    if (currentDataRole != newDataRole && !UsbPortManager.writeFile(portDir, SYSFS_PORT_DATA_ROLE, newDataRole == 1 ? PORT_DATA_ROLE_HOST : PORT_DATA_ROLE_DEVICE)) {
                        UsbPortManager.logAndPrint(6, pw, "Failed to set the USB port data role: portId=" + portId + ", newDataRole=" + UsbPort.dataRoleToString(newDataRole));
                        return;
                    }
                }
            }
            this.updatePortsLocked(pw);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSimulatedPort(String portId, int supportedModes, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSimulatedPorts.containsKey(portId)) {
                pw.println("Port with same name already exists.  Please remove it first.");
                return;
            }
            pw.println("Adding simulated port: portId=" + portId + ", supportedModes=" + UsbPort.modeToString(supportedModes));
            this.mSimulatedPorts.put(portId, new SimulatedPortInfo(portId, supportedModes));
            this.updatePortsLocked(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectSimulatedPort(String portId, int mode, boolean canChangeMode, int powerRole, boolean canChangePowerRole, int dataRole, boolean canChangeDataRole, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            SimulatedPortInfo portInfo = this.mSimulatedPorts.get(portId);
            if (portInfo == null) {
                pw.println("Cannot connect simulated port which does not exist.");
                return;
            }
            if (mode == 0 || powerRole == 0 || dataRole == 0) {
                pw.println("Cannot connect simulated port in null mode, power role, or data role.");
                return;
            }
            if ((portInfo.mSupportedModes & mode) == 0) {
                pw.println("Simulated port does not support mode: " + UsbPort.modeToString(mode));
                return;
            }
            pw.println("Connecting simulated port: portId=" + portId + ", mode=" + UsbPort.modeToString(mode) + ", canChangeMode=" + canChangeMode + ", powerRole=" + UsbPort.powerRoleToString(powerRole) + ", canChangePowerRole=" + canChangePowerRole + ", dataRole=" + UsbPort.dataRoleToString(dataRole) + ", canChangeDataRole=" + canChangeDataRole);
            portInfo.mCurrentMode = mode;
            portInfo.mCanChangeMode = canChangeMode;
            portInfo.mCurrentPowerRole = powerRole;
            portInfo.mCanChangePowerRole = canChangePowerRole;
            portInfo.mCurrentDataRole = dataRole;
            portInfo.mCanChangeDataRole = canChangeDataRole;
            this.updatePortsLocked(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectSimulatedPort(String portId, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            SimulatedPortInfo portInfo = this.mSimulatedPorts.get(portId);
            if (portInfo == null) {
                pw.println("Cannot disconnect simulated port which does not exist.");
                return;
            }
            pw.println("Disconnecting simulated port: portId=" + portId);
            portInfo.mCurrentMode = 0;
            portInfo.mCanChangeMode = false;
            portInfo.mCurrentPowerRole = 0;
            portInfo.mCanChangePowerRole = false;
            portInfo.mCurrentDataRole = 0;
            portInfo.mCanChangeDataRole = false;
            this.updatePortsLocked(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSimulatedPort(String portId, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mSimulatedPorts.indexOfKey(portId);
            if (index < 0) {
                pw.println("Cannot remove simulated port which does not exist.");
                return;
            }
            pw.println("Disconnecting simulated port: portId=" + portId);
            this.mSimulatedPorts.removeAt(index);
            this.updatePortsLocked(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSimulation(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Removing all simulated ports and ending simulation.");
            if (!this.mSimulatedPorts.isEmpty()) {
                this.mSimulatedPorts.clear();
                this.updatePortsLocked(pw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print("USB Port State:");
            if (!this.mSimulatedPorts.isEmpty()) {
                pw.print(" (simulation active; end with 'dumpsys usb reset')");
            }
            pw.println();
            if (this.mPorts.isEmpty()) {
                pw.println("  <no ports>");
            } else {
                for (PortInfo portInfo : this.mPorts.values()) {
                    pw.println("  " + portInfo.mUsbPort.getId() + ": " + portInfo);
                }
            }
        }
    }

    private void updatePortsLocked(IndentingPrintWriter pw) {
        File[] portDirs;
        int i = this.mPorts.size();
        while (i-- > 0) {
            this.mPorts.valueAt((int)i).mDisposition = 3;
        }
        if (!this.mSimulatedPorts.isEmpty()) {
            int count = this.mSimulatedPorts.size();
            for (int i2 = 0; i2 < count; ++i2) {
                SimulatedPortInfo portInfo = this.mSimulatedPorts.valueAt(i2);
                this.addOrUpdatePortLocked(portInfo.mPortId, portInfo.mSupportedModes, portInfo.mCurrentMode, portInfo.mCanChangeMode, portInfo.mCurrentPowerRole, portInfo.mCanChangePowerRole, portInfo.mCurrentDataRole, portInfo.mCanChangeDataRole, pw);
            }
        } else if (this.mHaveKernelSupport && (portDirs = new File(SYSFS_CLASS).listFiles()) != null) {
            for (File portDir : portDirs) {
                if (!portDir.isDirectory()) continue;
                String portId = portDir.getName();
                int supportedModes = UsbPortManager.readSupportedModes(portDir);
                int currentMode = UsbPortManager.readCurrentMode(portDir);
                boolean canChangeMode = UsbPortManager.canChangeMode(portDir);
                int currentPowerRole = UsbPortManager.readCurrentPowerRole(portDir);
                boolean canChangePowerRole = UsbPortManager.canChangePowerRole(portDir);
                int currentDataRole = UsbPortManager.readCurrentDataRole(portDir);
                boolean canChangeDataRole = UsbPortManager.canChangeDataRole(portDir);
                this.addOrUpdatePortLocked(portId, supportedModes, currentMode, canChangeMode, currentPowerRole, canChangePowerRole, currentDataRole, canChangeDataRole, pw);
            }
        }
        i = this.mPorts.size();
        while (i-- > 0) {
            PortInfo portInfo = this.mPorts.valueAt(i);
            switch (portInfo.mDisposition) {
                case 0: {
                    this.handlePortAddedLocked(portInfo, pw);
                    portInfo.mDisposition = 2;
                    break;
                }
                case 1: {
                    this.handlePortChangedLocked(portInfo, pw);
                    portInfo.mDisposition = 2;
                    break;
                }
                case 3: {
                    this.mPorts.removeAt(i);
                    portInfo.mUsbPortStatus = null;
                    this.handlePortRemovedLocked(portInfo, pw);
                }
            }
        }
    }

    private void addOrUpdatePortLocked(String portId, int supportedModes, int currentMode, boolean canChangeMode, int currentPowerRole, boolean canChangePowerRole, int currentDataRole, boolean canChangeDataRole, IndentingPrintWriter pw) {
        PortInfo portInfo;
        if (supportedModes != 3) {
            canChangeMode = false;
            if (currentMode != 0 && currentMode != supportedModes) {
                UsbPortManager.logAndPrint(5, pw, "Ignoring inconsistent current mode from USB port driver: supportedModes=" + UsbPort.modeToString(supportedModes) + ", currentMode=" + UsbPort.modeToString(currentMode));
                currentMode = 0;
            }
        }
        int supportedRoleCombinations = UsbPort.combineRolesAsBit(currentPowerRole, currentDataRole);
        if (currentMode != 0 && currentPowerRole != 0 && currentDataRole != 0) {
            if (canChangePowerRole && canChangeDataRole) {
                supportedRoleCombinations |= COMBO_SOURCE_HOST | COMBO_SOURCE_DEVICE | COMBO_SINK_HOST | COMBO_SINK_DEVICE;
            } else if (canChangePowerRole) {
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(1, currentDataRole);
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(2, currentDataRole);
            } else if (canChangeDataRole) {
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(currentPowerRole, 1);
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(currentPowerRole, 2);
            } else if (canChangeMode) {
                supportedRoleCombinations |= COMBO_SOURCE_HOST | COMBO_SINK_DEVICE;
            }
        }
        if ((portInfo = this.mPorts.get(portId)) == null) {
            portInfo = new PortInfo(portId, supportedModes);
            portInfo.setStatus(currentMode, canChangeMode, currentPowerRole, canChangePowerRole, currentDataRole, canChangeDataRole, supportedRoleCombinations);
            this.mPorts.put(portId, portInfo);
        } else {
            if (supportedModes != portInfo.mUsbPort.getSupportedModes()) {
                UsbPortManager.logAndPrint(5, pw, "Ignoring inconsistent list of supported modes from USB port driver (should be immutable): previous=" + UsbPort.modeToString(portInfo.mUsbPort.getSupportedModes()) + ", current=" + UsbPort.modeToString(supportedModes));
            }
            portInfo.mDisposition = portInfo.setStatus(currentMode, canChangeMode, currentPowerRole, canChangePowerRole, currentDataRole, canChangeDataRole, supportedRoleCombinations) ? 1 : 2;
        }
    }

    private void handlePortAddedLocked(PortInfo portInfo, IndentingPrintWriter pw) {
        UsbPortManager.logAndPrint(4, pw, "USB port added: " + portInfo);
        this.sendPortChangedBroadcastLocked(portInfo);
    }

    private void handlePortChangedLocked(PortInfo portInfo, IndentingPrintWriter pw) {
        UsbPortManager.logAndPrint(4, pw, "USB port changed: " + portInfo);
        this.sendPortChangedBroadcastLocked(portInfo);
    }

    private void handlePortRemovedLocked(PortInfo portInfo, IndentingPrintWriter pw) {
        UsbPortManager.logAndPrint(4, pw, "USB port removed: " + portInfo);
        this.sendPortChangedBroadcastLocked(portInfo);
    }

    private void sendPortChangedBroadcastLocked(PortInfo portInfo) {
        final Intent intent = new Intent("android.hardware.usb.action.USB_PORT_CHANGED");
        intent.addFlags(0x10000000);
        intent.putExtra("port", portInfo.mUsbPort);
        intent.putExtra("portStatus", portInfo.mUsbPortStatus);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                UsbPortManager.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            }
        });
    }

    private void scheduleUpdatePorts() {
        if (!this.mHandler.hasMessages(1)) {
            this.mHandler.sendEmptyMessage(1);
        }
    }

    private static int readSupportedModes(File portDir) {
        int modes = 0;
        String contents = UsbPortManager.readFile(portDir, SYSFS_PORT_SUPPORTED_MODES);
        if (contents != null) {
            if (contents.contains(PORT_MODE_DFP)) {
                modes |= 1;
            }
            if (contents.contains(PORT_MODE_UFP)) {
                modes |= 2;
            }
        }
        return modes;
    }

    private static int readCurrentMode(File portDir) {
        String contents = UsbPortManager.readFile(portDir, SYSFS_PORT_MODE);
        if (contents != null) {
            if (contents.equals(PORT_MODE_DFP)) {
                return 1;
            }
            if (contents.equals(PORT_MODE_UFP)) {
                return 2;
            }
        }
        return 0;
    }

    private static int readCurrentPowerRole(File portDir) {
        String contents = UsbPortManager.readFile(portDir, SYSFS_PORT_POWER_ROLE);
        if (contents != null) {
            if (contents.equals(PORT_POWER_ROLE_SOURCE)) {
                return 1;
            }
            if (contents.equals(PORT_POWER_ROLE_SINK)) {
                return 2;
            }
        }
        return 0;
    }

    private static int readCurrentDataRole(File portDir) {
        String contents = UsbPortManager.readFile(portDir, SYSFS_PORT_DATA_ROLE);
        if (contents != null) {
            if (contents.equals(PORT_DATA_ROLE_HOST)) {
                return 1;
            }
            if (contents.equals(PORT_DATA_ROLE_DEVICE)) {
                return 2;
            }
        }
        return 0;
    }

    private static boolean fileIsRootWritable(String path) {
        try {
            return (Os.stat((String)path).st_mode & OsConstants.S_IWUSR) != 0;
        }
        catch (ErrnoException e) {
            return false;
        }
    }

    private static boolean canChangeMode(File portDir) {
        return UsbPortManager.fileIsRootWritable(new File(portDir, SYSFS_PORT_MODE).getPath());
    }

    private static boolean canChangePowerRole(File portDir) {
        return UsbPortManager.fileIsRootWritable(new File(portDir, SYSFS_PORT_POWER_ROLE).getPath());
    }

    private static boolean canChangeDataRole(File portDir) {
        return UsbPortManager.fileIsRootWritable(new File(portDir, SYSFS_PORT_DATA_ROLE).getPath());
    }

    private static String readFile(File dir, String filename) {
        File file = new File(dir, filename);
        try {
            return IoUtils.readFileAsString(file.getAbsolutePath()).trim();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static boolean waitForState(String property, String state) {
        String value = null;
        for (int i = 0; i < 100; ++i) {
            value = SystemProperties.get(property);
            if (state.equals(value)) {
                return true;
            }
            SystemClock.sleep(50L);
        }
        Slog.e(TAG, "waitForState(" + state + ") for " + property + " FAILED: got " + value);
        return false;
    }

    private static String propertyFromFilename(String filename) {
        return USB_TYPEC_PROP_PREFIX + filename;
    }

    private static boolean writeFile(File dir, String filename, String contents) {
        SystemProperties.set(UsbPortManager.propertyFromFilename(filename), contents);
        return UsbPortManager.waitForState(USB_TYPEC_STATE, contents);
    }

    private static void logAndPrint(int priority, IndentingPrintWriter pw, String msg) {
        Slog.println(priority, TAG, msg);
        if (pw != null) {
            pw.println(msg);
        }
    }

    private static final class SimulatedPortInfo {
        public final String mPortId;
        public final int mSupportedModes;
        public int mCurrentMode;
        public boolean mCanChangeMode;
        public int mCurrentPowerRole;
        public boolean mCanChangePowerRole;
        public int mCurrentDataRole;
        public boolean mCanChangeDataRole;

        public SimulatedPortInfo(String portId, int supportedModes) {
            this.mPortId = portId;
            this.mSupportedModes = supportedModes;
        }
    }

    private static final class PortInfo {
        public static final int DISPOSITION_ADDED = 0;
        public static final int DISPOSITION_CHANGED = 1;
        public static final int DISPOSITION_READY = 2;
        public static final int DISPOSITION_REMOVED = 3;
        public final UsbPort mUsbPort;
        public UsbPortStatus mUsbPortStatus;
        public boolean mCanChangeMode;
        public boolean mCanChangePowerRole;
        public boolean mCanChangeDataRole;
        public int mDisposition;

        public PortInfo(String portId, int supportedModes) {
            this.mUsbPort = new UsbPort(portId, supportedModes);
        }

        public boolean setStatus(int currentMode, boolean canChangeMode, int currentPowerRole, boolean canChangePowerRole, int currentDataRole, boolean canChangeDataRole, int supportedRoleCombinations) {
            this.mCanChangeMode = canChangeMode;
            this.mCanChangePowerRole = canChangePowerRole;
            this.mCanChangeDataRole = canChangeDataRole;
            if (this.mUsbPortStatus == null || this.mUsbPortStatus.getCurrentMode() != currentMode || this.mUsbPortStatus.getCurrentPowerRole() != currentPowerRole || this.mUsbPortStatus.getCurrentDataRole() != currentDataRole || this.mUsbPortStatus.getSupportedRoleCombinations() != supportedRoleCombinations) {
                this.mUsbPortStatus = new UsbPortStatus(currentMode, currentPowerRole, currentDataRole, supportedRoleCombinations);
                return true;
            }
            return false;
        }

        public String toString() {
            return "port=" + this.mUsbPort + ", status=" + this.mUsbPortStatus + ", canChangeMode=" + this.mCanChangeMode + ", canChangePowerRole=" + this.mCanChangePowerRole + ", canChangeDataRole=" + this.mCanChangeDataRole;
        }
    }
}

