/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.vr;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.content.PackageMonitor;
import com.android.server.vr.SettingsObserver;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class EnabledComponentsObserver
implements SettingsObserver.SettingChangeListener {
    private static final String TAG = EnabledComponentsObserver.class.getSimpleName();
    private static final String ENABLED_SERVICES_SEPARATOR = ":";
    public static final int NO_ERROR = 0;
    public static final int DISABLED = -1;
    public static final int NOT_INSTALLED = -2;
    private final Object mLock;
    private final Context mContext;
    private final String mSettingName;
    private final String mServiceName;
    private final String mServicePermission;
    private final SparseArray<ArraySet<ComponentName>> mInstalledSet = new SparseArray();
    private final SparseArray<ArraySet<ComponentName>> mEnabledSet = new SparseArray();
    private final Set<EnabledComponentChangeListener> mEnabledComponentListeners = new ArraySet<EnabledComponentChangeListener>();

    private EnabledComponentsObserver(Context context, String settingName, String servicePermission, String serviceName, Object lock, Collection<EnabledComponentChangeListener> listeners) {
        this.mLock = lock;
        this.mContext = context;
        this.mSettingName = settingName;
        this.mServiceName = serviceName;
        this.mServicePermission = servicePermission;
        this.mEnabledComponentListeners.addAll(listeners);
    }

    public static EnabledComponentsObserver build(Context context, Handler handler, String settingName, Looper looper, String servicePermission, String serviceName, Object lock, Collection<EnabledComponentChangeListener> listeners) {
        SettingsObserver s = SettingsObserver.build(context, handler, settingName);
        final EnabledComponentsObserver o = new EnabledComponentsObserver(context, settingName, servicePermission, serviceName, lock, listeners);
        PackageMonitor packageMonitor = new PackageMonitor(){

            @Override
            public void onSomePackagesChanged() {
                o.onPackagesChanged();
            }

            @Override
            public void onPackageDisappeared(String packageName, int reason) {
                o.onPackagesChanged();
            }

            @Override
            public void onPackageModified(String packageName) {
                o.onPackagesChanged();
            }

            @Override
            public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
                o.onPackagesChanged();
                return super.onHandleForceStop(intent, packages, uid, doit);
            }
        };
        packageMonitor.register(context, looper, UserHandle.ALL, true);
        s.addListener(o);
        return o;
    }

    public void onPackagesChanged() {
        this.rebuildAll();
    }

    @Override
    public void onSettingChanged() {
        this.rebuildAll();
    }

    @Override
    public void onSettingRestored(String prevValue, String newValue, int userId) {
        this.rebuildAll();
    }

    public void onUsersChanged() {
        this.rebuildAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildAll() {
        Object object = this.mLock;
        synchronized (object) {
            int[] userIds;
            this.mInstalledSet.clear();
            this.mEnabledSet.clear();
            for (int i : userIds = this.getCurrentProfileIds()) {
                ArraySet<ComponentName> implementingPackages = this.loadComponentNamesForUser(i);
                ArraySet<ComponentName> packagesFromSettings = this.loadComponentNamesFromSetting(this.mSettingName, i);
                packagesFromSettings.retainAll(implementingPackages);
                this.mInstalledSet.put(i, implementingPackages);
                this.mEnabledSet.put(i, packagesFromSettings);
            }
        }
        this.sendSettingChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int isValid(ComponentName component, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ArraySet<ComponentName> installedComponents = this.mInstalledSet.get(userId);
            if (installedComponents == null || !installedComponents.contains(component)) {
                return -2;
            }
            ArraySet<ComponentName> validComponents = this.mEnabledSet.get(userId);
            if (validComponents == null || !validComponents.contains(component)) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArraySet<ComponentName> getInstalled(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInstalledSet.get(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArraySet<ComponentName> getEnabled(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEnabledSet.get(userId);
        }
    }

    private int[] getCurrentProfileIds() {
        UserManager userManager = (UserManager)this.mContext.getSystemService("user");
        if (userManager == null) {
            return null;
        }
        return userManager.getEnabledProfileIds(ActivityManager.getCurrentUser());
    }

    public static ArraySet<ComponentName> loadComponentNames(PackageManager pm, int userId, String serviceName, String permissionName) {
        ArraySet<ComponentName> installed = new ArraySet<ComponentName>();
        Intent queryIntent = new Intent(serviceName);
        List<ResolveInfo> installedServices = pm.queryIntentServicesAsUser(queryIntent, 132, userId);
        if (installedServices != null) {
            int count = installedServices.size();
            for (int i = 0; i < count; ++i) {
                ResolveInfo resolveInfo = installedServices.get(i);
                ServiceInfo info = resolveInfo.serviceInfo;
                ComponentName component = new ComponentName(info.packageName, info.name);
                if (!permissionName.equals(info.permission)) {
                    Slog.w(TAG, "Skipping service " + info.packageName + "/" + info.name + ": it does not require the permission " + permissionName);
                    continue;
                }
                installed.add(component);
            }
        }
        return installed;
    }

    private ArraySet<ComponentName> loadComponentNamesForUser(int userId) {
        return EnabledComponentsObserver.loadComponentNames(this.mContext.getPackageManager(), userId, this.mServiceName, this.mServicePermission);
    }

    private ArraySet<ComponentName> loadComponentNamesFromSetting(String settingName, int userId) {
        ContentResolver cr = this.mContext.getContentResolver();
        String settingValue = Settings.Secure.getStringForUser(cr, settingName, userId);
        if (TextUtils.isEmpty(settingValue)) {
            return new ArraySet<ComponentName>();
        }
        String[] restored = settingValue.split(ENABLED_SERVICES_SEPARATOR);
        ArraySet<ComponentName> result = new ArraySet<ComponentName>(restored.length);
        for (int i = 0; i < restored.length; ++i) {
            ComponentName value = ComponentName.unflattenFromString(restored[i]);
            if (null == value) continue;
            result.add(value);
        }
        return result;
    }

    private void sendSettingChanged() {
        for (EnabledComponentChangeListener l : this.mEnabledComponentListeners) {
            l.onEnabledComponentChanged();
        }
    }

    public static interface EnabledComponentChangeListener {
        public void onEnabledComponentChanged();
    }
}

