/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManagerNative;
import android.content.ClipData;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import com.android.internal.view.IDragAndDropPermissions;
import java.util.ArrayList;

class DragAndDropPermissionsHandler
extends IDragAndDropPermissions.Stub
implements IBinder.DeathRecipient {
    private final int mSourceUid;
    private final String mTargetPackage;
    private final int mMode;
    private final int mSourceUserId;
    private final int mTargetUserId;
    private final ArrayList<Uri> mUris = new ArrayList();
    private IBinder mActivityToken = null;
    private IBinder mPermissionOwnerToken = null;

    DragAndDropPermissionsHandler(ClipData clipData, int sourceUid, String targetPackage, int mode, int sourceUserId, int targetUserId) {
        this.mSourceUid = sourceUid;
        this.mTargetPackage = targetPackage;
        this.mMode = mode;
        this.mSourceUserId = sourceUserId;
        this.mTargetUserId = targetUserId;
        clipData.collectUris(this.mUris);
    }

    @Override
    public void take(IBinder activityToken) throws RemoteException {
        if (this.mActivityToken != null || this.mPermissionOwnerToken != null) {
            return;
        }
        this.mActivityToken = activityToken;
        IBinder permissionOwner = ActivityManagerNative.getDefault().getUriPermissionOwnerForActivity(this.mActivityToken);
        this.doTake(permissionOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTake(IBinder permissionOwner) throws RemoteException {
        long origId = Binder.clearCallingIdentity();
        try {
            for (int i = 0; i < this.mUris.size(); ++i) {
                ActivityManagerNative.getDefault().grantUriPermissionFromOwner(permissionOwner, this.mSourceUid, this.mTargetPackage, this.mUris.get(i), this.mMode, this.mSourceUserId, this.mTargetUserId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    @Override
    public void takeTransient(IBinder permissionOwnerToken) throws RemoteException {
        if (this.mActivityToken != null || this.mPermissionOwnerToken != null) {
            return;
        }
        this.mPermissionOwnerToken = permissionOwnerToken;
        this.mPermissionOwnerToken.linkToDeath(this, 0);
        this.doTake(this.mPermissionOwnerToken);
    }

    @Override
    public void release() throws RemoteException {
        if (this.mActivityToken == null && this.mPermissionOwnerToken == null) {
            return;
        }
        IBinder permissionOwner = null;
        if (this.mActivityToken != null) {
            try {
                permissionOwner = ActivityManagerNative.getDefault().getUriPermissionOwnerForActivity(this.mActivityToken);
            }
            catch (Exception e) {
                return;
            }
            finally {
                this.mActivityToken = null;
            }
        } else {
            permissionOwner = this.mPermissionOwnerToken;
            this.mPermissionOwnerToken.unlinkToDeath(this, 0);
            this.mPermissionOwnerToken = null;
        }
        for (int i = 0; i < this.mUris.size(); ++i) {
            ActivityManagerNative.getDefault().revokeUriPermissionFromOwner(permissionOwner, this.mUris.get(i), this.mMode, this.mSourceUserId);
        }
    }

    @Override
    public void binderDied() {
        try {
            this.release();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

