/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.ClipData;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.Slog;
import android.view.Display;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.InputChannel;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.WindowManager;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.HashMap;

final class Session
extends IWindowSession.Stub
implements IBinder.DeathRecipient {
    final WindowManagerService mService;
    final IWindowSessionCallback mCallback;
    final IInputMethodClient mClient;
    final IInputContext mInputContext;
    final int mUid;
    final int mPid;
    final String mStringName;
    SurfaceSession mSurfaceSession;
    int mNumWindow = 0;
    boolean mClientDead = false;
    float mLastReportedAnimatorScale;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session(WindowManagerService service, IWindowSessionCallback callback, IInputMethodClient client, IInputContext inputContext) {
        this.mService = service;
        this.mCallback = callback;
        this.mClient = client;
        this.mInputContext = inputContext;
        this.mUid = Binder.getCallingUid();
        this.mPid = Binder.getCallingPid();
        this.mLastReportedAnimatorScale = service.getCurrentAnimatorScale();
        StringBuilder sb = new StringBuilder();
        sb.append("Session{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" ");
        sb.append(this.mPid);
        if (this.mUid < 10000) {
            sb.append(":");
            sb.append(this.mUid);
        } else {
            sb.append(":u");
            sb.append(UserHandle.getUserId(this.mUid));
            sb.append('a');
            sb.append(UserHandle.getAppId(this.mUid));
        }
        sb.append("}");
        this.mStringName = sb.toString();
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            if (this.mService.mInputMethodManager == null && this.mService.mHaveInputMethods) {
                IBinder b = ServiceManager.getService("input_method");
                this.mService.mInputMethodManager = IInputMethodManager.Stub.asInterface(b);
            }
        }
        long ident = Binder.clearCallingIdentity();
        try {
            if (this.mService.mInputMethodManager != null) {
                this.mService.mInputMethodManager.addClient(client, inputContext, this.mUid, this.mPid);
            } else {
                client.setUsingInputMethod(false);
            }
            client.asBinder().linkToDeath(this, 0);
        }
        catch (RemoteException e) {
            try {
                if (this.mService.mInputMethodManager != null) {
                    this.mService.mInputMethodManager.removeClient(client);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf("WindowManager", "Window Session Crash", e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binderDied() {
        try {
            if (this.mService.mInputMethodManager != null) {
                this.mService.mInputMethodManager.removeClient(this.mClient);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            this.mClient.asBinder().unlinkToDeath(this, 0);
            this.mClientDead = true;
            this.killSessionLocked();
        }
    }

    @Override
    public int add(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, Rect outContentInsets, Rect outStableInsets, InputChannel outInputChannel) {
        return this.addToDisplay(window, seq, attrs, viewVisibility, 0, outContentInsets, outStableInsets, null, outInputChannel);
    }

    @Override
    public int addToDisplay(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, Rect outContentInsets, Rect outStableInsets, Rect outOutsets, InputChannel outInputChannel) {
        return this.mService.addWindow(this, window, seq, attrs, viewVisibility, displayId, outContentInsets, outStableInsets, outOutsets, outInputChannel);
    }

    @Override
    public int addWithoutInputChannel(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, Rect outContentInsets, Rect outStableInsets) {
        return this.addToDisplayWithoutInputChannel(window, seq, attrs, viewVisibility, 0, outContentInsets, outStableInsets);
    }

    @Override
    public int addToDisplayWithoutInputChannel(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, Rect outContentInsets, Rect outStableInsets) {
        return this.mService.addWindow(this, window, seq, attrs, viewVisibility, displayId, outContentInsets, outStableInsets, null, null);
    }

    @Override
    public void remove(IWindow window) {
        this.mService.removeWindow(this, window);
    }

    @Override
    public void repositionChild(IWindow window, int left, int top, int right, int bottom, long deferTransactionUntilFrame, Rect outFrame) {
        this.mService.repositionChild(this, window, left, top, right, bottom, deferTransactionUntilFrame, outFrame);
    }

    @Override
    public void prepareToReplaceWindows(IBinder appToken, boolean childrenOnly) {
        this.mService.setReplacingWindows(appToken, childrenOnly);
    }

    @Override
    public int relayout(IWindow window, int seq, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewFlags, int flags, Rect outFrame, Rect outOverscanInsets, Rect outContentInsets, Rect outVisibleInsets, Rect outStableInsets, Rect outsets, Rect outBackdropFrame, Configuration outConfig, Surface outSurface) {
        int res = this.mService.relayoutWindow(this, window, seq, attrs, requestedWidth, requestedHeight, viewFlags, flags, outFrame, outOverscanInsets, outContentInsets, outVisibleInsets, outStableInsets, outsets, outBackdropFrame, outConfig, outSurface);
        return res;
    }

    @Override
    public void performDeferredDestroy(IWindow window) {
        this.mService.performDeferredDestroyWindow(this, window);
    }

    @Override
    public boolean outOfMemory(IWindow window) {
        return this.mService.outOfMemoryWindow(this, window);
    }

    @Override
    public void setTransparentRegion(IWindow window, Region region) {
        this.mService.setTransparentRegionWindow(this, window, region);
    }

    @Override
    public void setInsets(IWindow window, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableArea) {
        this.mService.setInsetsWindow(this, window, touchableInsets, contentInsets, visibleInsets, touchableArea);
    }

    @Override
    public void getDisplayFrame(IWindow window, Rect outDisplayFrame) {
        this.mService.getWindowDisplayFrame(this, window, outDisplayFrame);
    }

    @Override
    public void finishDrawing(IWindow window) {
        this.mService.finishDrawingWindow(this, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInTouchMode(boolean mode) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            this.mService.mInTouchMode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getInTouchMode() {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            return this.mService.mInTouchMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performHapticFeedback(IWindow window, int effectId, boolean always) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            boolean bl;
            long ident = Binder.clearCallingIdentity();
            try {
                bl = this.mService.mPolicy.performHapticFeedbackLw(this.mService.windowForClientLocked(this, window, true), effectId, always);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
    }

    @Override
    public IBinder prepareDrag(IWindow window, int flags, int width, int height, Surface outSurface) {
        return this.mService.prepareDragSurface(window, this.mSurfaceSession, flags, width, height, outSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performDrag(IWindow window, IBinder dragToken, int touchSource, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            if (this.mService.mDragState == null) {
                Slog.w("WindowManager", "No drag prepared");
                throw new IllegalStateException("performDrag() without prepareDrag()");
            }
            if (dragToken != this.mService.mDragState.mToken) {
                Slog.w("WindowManager", "Performing mismatched drag");
                throw new IllegalStateException("performDrag() does not match prepareDrag()");
            }
            WindowState callingWin = this.mService.windowForClientLocked(null, window, false);
            if (callingWin == null) {
                Slog.w("WindowManager", "Bad requesting window " + window);
                return false;
            }
            this.mService.mH.removeMessages(20, window.asBinder());
            DisplayContent displayContent = callingWin.getDisplayContent();
            if (displayContent == null) {
                return false;
            }
            Display display = displayContent.getDisplay();
            this.mService.mDragState.register(display);
            this.mService.mInputMonitor.updateInputWindowsLw(true);
            if (!this.mService.mInputManager.transferTouchFocus(callingWin.mInputChannel, this.mService.mDragState.mServerChannel)) {
                Slog.e("WindowManager", "Unable to transfer touch focus");
                this.mService.mDragState.unregister();
                this.mService.mDragState = null;
                this.mService.mInputMonitor.updateInputWindowsLw(true);
                return false;
            }
            this.mService.mDragState.mData = data;
            this.mService.mDragState.broadcastDragStartedLw(touchX, touchY);
            this.mService.mDragState.overridePointerIconLw(touchSource);
            this.mService.mDragState.mThumbOffsetX = thumbCenterX;
            this.mService.mDragState.mThumbOffsetY = thumbCenterY;
            SurfaceControl surfaceControl = this.mService.mDragState.mSurfaceControl;
            SurfaceControl.openTransaction();
            try {
                surfaceControl.setPosition(touchX - thumbCenterX, touchY - thumbCenterY);
                surfaceControl.setLayer(this.mService.mDragState.getDragLayerLw());
                surfaceControl.setLayerStack(display.getLayerStack());
                surfaceControl.show();
            }
            finally {
                SurfaceControl.closeTransaction();
            }
            this.mService.mDragState.notifyLocationLw(touchX, touchY);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startMovingTask(IWindow window, float startX, float startY) {
        long ident = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mService.startMovingTask(window, startX, startY);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reportDropResult(IWindow window, boolean consumed) {
        IBinder token = window.asBinder();
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            long ident = Binder.clearCallingIdentity();
            try {
                if (this.mService.mDragState == null) {
                    Slog.w("WindowManager", "Drop result given but no drag in progress");
                    return;
                }
                if (this.mService.mDragState.mToken != token) {
                    Slog.w("WindowManager", "Invalid drop-result claim by " + window);
                    throw new IllegalStateException("reportDropResult() by non-recipient");
                }
                this.mService.mH.removeMessages(21, window.asBinder());
                WindowState callingWin = this.mService.windowForClientLocked(null, window, false);
                if (callingWin == null) {
                    Slog.w("WindowManager", "Bad result-reporting window " + window);
                    return;
                }
                this.mService.mDragState.mDragResult = consumed;
                this.mService.mDragState.endDragLw();
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelDragAndDrop(IBinder dragToken) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            long ident = Binder.clearCallingIdentity();
            try {
                if (this.mService.mDragState == null) {
                    Slog.w("WindowManager", "cancelDragAndDrop() without prepareDrag()");
                    throw new IllegalStateException("cancelDragAndDrop() without prepareDrag()");
                }
                if (this.mService.mDragState.mToken != dragToken) {
                    Slog.w("WindowManager", "cancelDragAndDrop() does not match prepareDrag()");
                    throw new IllegalStateException("cancelDragAndDrop() does not match prepareDrag()");
                }
                this.mService.mDragState.mDragResult = false;
                this.mService.mDragState.cancelDragLw();
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    @Override
    public void dragRecipientEntered(IWindow window) {
    }

    @Override
    public void dragRecipientExited(IWindow window) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWallpaperPosition(IBinder window, float x, float y, float xStep, float yStep) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mService.mWallpaperControllerLocked.setWindowWallpaperPosition(this.mService.windowForClientLocked(this, window, true), x, y, xStep, yStep);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wallpaperOffsetsComplete(IBinder window) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            this.mService.mWallpaperControllerLocked.wallpaperOffsetsComplete(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWallpaperDisplayOffset(IBinder window, int x, int y) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mService.mWallpaperControllerLocked.setWindowWallpaperDisplayOffset(this.mService.windowForClientLocked(this, window, true), x, y);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle sendWallpaperCommand(IBinder window, String action, int x, int y, int z, Bundle extras, boolean sync) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            Bundle bundle;
            long ident = Binder.clearCallingIdentity();
            try {
                bundle = this.mService.mWallpaperControllerLocked.sendWindowWallpaperCommand(this.mService.windowForClientLocked(this, window, true), action, x, y, z, extras, sync);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return bundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wallpaperCommandComplete(IBinder window, Bundle result) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            this.mService.mWallpaperControllerLocked.wallpaperCommandComplete(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRectangleOnScreenRequested(IBinder token, Rect rectangle) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mService.onRectangleOnScreenRequested(token, rectangle);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    @Override
    public IWindowId getWindowId(IBinder window) {
        return this.mService.getWindowId(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pokeDrawLock(IBinder window) {
        long identity = Binder.clearCallingIdentity();
        try {
            this.mService.pokeDrawLock(this, window);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePointerIcon(IWindow window) {
        long identity = Binder.clearCallingIdentity();
        try {
            this.mService.updatePointerIcon(window);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    void windowAddedLocked() {
        if (this.mSurfaceSession == null) {
            this.mSurfaceSession = new SurfaceSession();
            this.mService.mSessions.add(this);
            if (this.mLastReportedAnimatorScale != this.mService.getCurrentAnimatorScale()) {
                this.mService.dispatchNewAnimatorScaleLocked(this);
            }
        }
        ++this.mNumWindow;
    }

    void windowRemovedLocked() {
        --this.mNumWindow;
        this.killSessionLocked();
    }

    void killSessionLocked() {
        if (this.mNumWindow <= 0 && this.mClientDead) {
            this.mService.mSessions.remove(this);
            if (this.mSurfaceSession != null) {
                try {
                    this.mSurfaceSession.kill();
                }
                catch (Exception e) {
                    Slog.w("WindowManager", "Exception thrown when killing surface session " + this.mSurfaceSession + " in session " + this + ": " + e.toString());
                }
                this.mSurfaceSession = null;
            }
        }
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mNumWindow=");
        pw.print(this.mNumWindow);
        pw.print(" mClientDead=");
        pw.print(this.mClientDead);
        pw.print(" mSurfaceSession=");
        pw.println(this.mSurfaceSession);
    }

    public String toString() {
        return this.mStringName;
    }
}

