/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Debug;
import android.os.IBinder;
import android.util.Slog;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.WindowContentFrameStats;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.WindowStateAnimator;
import java.io.PrintWriter;
import java.util.ArrayList;

class WindowSurfaceController {
    static final String TAG = "WindowManager";
    final WindowStateAnimator mAnimator;
    private SurfaceControl mSurfaceControl;
    private boolean mSurfaceShown = false;
    private float mSurfaceX = 0.0f;
    private float mSurfaceY = 0.0f;
    private float mSurfaceW = 0.0f;
    private float mSurfaceH = 0.0f;
    private float mSurfaceAlpha = 0.0f;
    private int mSurfaceLayer = 0;
    private boolean mHiddenForCrop = false;
    private boolean mHiddenForOtherReasons = true;
    private final String title;

    public WindowSurfaceController(SurfaceSession s, String name, int w, int h, int format, int flags, WindowStateAnimator animator2) {
        this.mAnimator = animator2;
        this.mSurfaceW = w;
        this.mSurfaceH = h;
        this.title = name;
        this.mSurfaceControl = animator2.mWin.isChildWindow() && animator2.mWin.mSubLayer < 0 && animator2.mWin.mAppToken != null ? new SurfaceControlWithBackground(s, name, w, h, format, flags, animator2.mWin.mAppToken) : new SurfaceControl(s, name, w, h, format, flags);
    }

    void logSurface(String msg, RuntimeException where) {
        String str = "  SURFACE " + msg + ": " + this.title;
        if (where != null) {
            Slog.i(TAG, str, where);
        } else {
            Slog.i(TAG, str);
        }
    }

    void hideInTransaction(String reason) {
        this.mHiddenForOtherReasons = true;
        this.mAnimator.destroyPreservedSurfaceLocked();
        this.updateVisibility();
    }

    private void hideSurface() {
        if (this.mSurfaceControl != null) {
            this.mSurfaceShown = false;
            try {
                this.mSurfaceControl.hide();
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Exception hiding surface in " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPositionAndLayer(float left, float top, int layerStack, int layer) {
        SurfaceControl.openTransaction();
        try {
            this.mSurfaceX = left;
            this.mSurfaceY = top;
            try {
                this.mSurfaceControl.setPosition(left, top);
                this.mSurfaceControl.setLayerStack(layerStack);
                this.mSurfaceControl.setLayer(layer);
                this.mSurfaceControl.setAlpha(0.0f);
                this.mSurfaceShown = false;
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Error creating surface in " + this, e);
                this.mAnimator.reclaimSomeSurfaceMemory("create-init", true);
            }
        }
        finally {
            SurfaceControl.closeTransaction();
        }
    }

    void destroyInTransaction() {
        Slog.i(TAG, "Destroying surface " + this + " called by " + Debug.getCallers(8));
        try {
            if (this.mSurfaceControl != null) {
                this.mSurfaceControl.destroy();
            }
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error destroying surface in: " + this, e);
        }
        finally {
            this.mSurfaceShown = false;
            this.mSurfaceControl = null;
        }
    }

    void disconnectInTransaction() {
        try {
            if (this.mSurfaceControl != null) {
                this.mSurfaceControl.disconnect();
            }
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error disconnecting surface in: " + this, e);
        }
    }

    void setCropInTransaction(Rect clipRect, boolean recoveringMemory) {
        block4: {
            try {
                if (clipRect.width() > 0 && clipRect.height() > 0) {
                    this.mSurfaceControl.setWindowCrop(clipRect);
                    this.mHiddenForCrop = false;
                    this.updateVisibility();
                } else {
                    this.mHiddenForCrop = true;
                    this.mAnimator.destroyPreservedSurfaceLocked();
                    this.updateVisibility();
                }
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Error setting crop surface of " + this + " crop=" + clipRect.toShortString(), e);
                if (recoveringMemory) break block4;
                this.mAnimator.reclaimSomeSurfaceMemory("crop", true);
            }
        }
    }

    void clearCropInTransaction(boolean recoveringMemory) {
        block2: {
            try {
                Rect clipRect = new Rect(0, 0, -1, -1);
                this.mSurfaceControl.setWindowCrop(clipRect);
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Error setting clearing crop of " + this, e);
                if (recoveringMemory) break block2;
                this.mAnimator.reclaimSomeSurfaceMemory("crop", true);
            }
        }
    }

    void setFinalCropInTransaction(Rect clipRect) {
        try {
            this.mSurfaceControl.setFinalCrop(clipRect);
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error disconnecting surface in: " + this, e);
        }
    }

    void setLayer(int layer) {
        if (this.mSurfaceControl != null) {
            SurfaceControl.openTransaction();
            try {
                this.mSurfaceControl.setLayer(layer);
            }
            finally {
                SurfaceControl.closeTransaction();
            }
        }
    }

    void setPositionInTransaction(float left, float top, boolean recoveringMemory) {
        block3: {
            boolean surfaceMoved;
            boolean bl = surfaceMoved = this.mSurfaceX != left || this.mSurfaceY != top;
            if (surfaceMoved) {
                this.mSurfaceX = left;
                this.mSurfaceY = top;
                try {
                    this.mSurfaceControl.setPosition(left, top);
                }
                catch (RuntimeException e) {
                    Slog.w(TAG, "Error positioning surface of " + this + " pos=(" + left + "," + top + ")", e);
                    if (recoveringMemory) break block3;
                    this.mAnimator.reclaimSomeSurfaceMemory("position", true);
                }
            }
        }
    }

    void setPositionAppliesWithResizeInTransaction(boolean recoveringMemory) {
        this.mSurfaceControl.setPositionAppliesWithResize();
    }

    void setMatrixInTransaction(float dsdx, float dtdx, float dsdy, float dtdy, boolean recoveringMemory) {
        block2: {
            try {
                this.mSurfaceControl.setMatrix(dsdx, dtdx, dsdy, dtdy);
            }
            catch (RuntimeException e) {
                Slog.e(TAG, "Error setting matrix on surface surface" + this.title + " MATRIX [" + dsdx + "," + dtdx + "," + dsdy + "," + dtdy + "]", null);
                if (recoveringMemory) break block2;
                this.mAnimator.reclaimSomeSurfaceMemory("matrix", true);
            }
        }
    }

    boolean setSizeInTransaction(int width, int height, boolean recoveringMemory) {
        boolean surfaceResized;
        boolean bl = surfaceResized = this.mSurfaceW != (float)width || this.mSurfaceH != (float)height;
        if (surfaceResized) {
            this.mSurfaceW = width;
            this.mSurfaceH = height;
            try {
                this.mSurfaceControl.setSize(width, height);
            }
            catch (RuntimeException e) {
                Slog.e(TAG, "Error resizing surface of " + this.title + " size=(" + width + "x" + height + ")", e);
                if (!recoveringMemory) {
                    this.mAnimator.reclaimSomeSurfaceMemory("size", true);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    boolean prepareToShowInTransaction(float alpha, int layer, float dsdx, float dtdx, float dsdy, float dtdy, boolean recoveringMemory) {
        if (this.mSurfaceControl != null) {
            try {
                this.mSurfaceAlpha = alpha;
                this.mSurfaceControl.setAlpha(alpha);
                this.mSurfaceLayer = layer;
                this.mSurfaceControl.setLayer(layer);
                this.mSurfaceControl.setMatrix(dsdx, dtdx, dsdy, dtdy);
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Error updating surface in " + this.title, e);
                if (!recoveringMemory) {
                    this.mAnimator.reclaimSomeSurfaceMemory("update", true);
                }
                return false;
            }
        }
        return true;
    }

    void setTransparentRegionHint(Region region) {
        if (this.mSurfaceControl == null) {
            Slog.w(TAG, "setTransparentRegionHint: null mSurface after mHasSurface true");
            return;
        }
        SurfaceControl.openTransaction();
        try {
            this.mSurfaceControl.setTransparentRegionHint(region);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
    }

    void setOpaque(boolean isOpaque) {
        if (this.mSurfaceControl == null) {
            return;
        }
        SurfaceControl.openTransaction();
        try {
            this.mSurfaceControl.setOpaque(isOpaque);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
    }

    void setSecure(boolean isSecure) {
        if (this.mSurfaceControl == null) {
            return;
        }
        SurfaceControl.openTransaction();
        try {
            this.mSurfaceControl.setSecure(isSecure);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
    }

    boolean showRobustlyInTransaction() {
        this.mHiddenForOtherReasons = false;
        return this.updateVisibility();
    }

    private boolean updateVisibility() {
        if (this.mHiddenForCrop || this.mHiddenForOtherReasons) {
            if (this.mSurfaceShown) {
                this.hideSurface();
            }
            return false;
        }
        if (!this.mSurfaceShown) {
            return this.showSurface();
        }
        return true;
    }

    private boolean showSurface() {
        try {
            this.mSurfaceShown = true;
            this.mSurfaceControl.show();
            return true;
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Failure showing surface " + this.mSurfaceControl + " in " + this, e);
            this.mAnimator.reclaimSomeSurfaceMemory("show", true);
            return false;
        }
    }

    void deferTransactionUntil(IBinder handle, long frame) {
        this.mSurfaceControl.deferTransactionUntil(handle, frame);
    }

    void forceScaleableInTransaction(boolean force) {
        int scalingMode = force ? 1 : -1;
        this.mSurfaceControl.setOverrideScalingMode(scalingMode);
    }

    boolean clearWindowContentFrameStats() {
        if (this.mSurfaceControl == null) {
            return false;
        }
        return this.mSurfaceControl.clearContentFrameStats();
    }

    boolean getWindowContentFrameStats(WindowContentFrameStats outStats) {
        if (this.mSurfaceControl == null) {
            return false;
        }
        return this.mSurfaceControl.getContentFrameStats(outStats);
    }

    boolean hasSurface() {
        return this.mSurfaceControl != null;
    }

    IBinder getHandle() {
        if (this.mSurfaceControl == null) {
            return null;
        }
        return this.mSurfaceControl.getHandle();
    }

    void getSurface(Surface outSurface) {
        outSurface.copyFrom(this.mSurfaceControl);
    }

    int getLayer() {
        return this.mSurfaceLayer;
    }

    boolean getShown() {
        return this.mSurfaceShown;
    }

    void setShown(boolean surfaceShown) {
        this.mSurfaceShown = surfaceShown;
    }

    float getX() {
        return this.mSurfaceX;
    }

    float getY() {
        return this.mSurfaceY;
    }

    float getWidth() {
        return this.mSurfaceW;
    }

    float getHeight() {
        return this.mSurfaceH;
    }

    public void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mSurface=");
            pw.println(this.mSurfaceControl);
        }
        pw.print(prefix);
        pw.print("Surface: shown=");
        pw.print(this.mSurfaceShown);
        pw.print(" layer=");
        pw.print(this.mSurfaceLayer);
        pw.print(" alpha=");
        pw.print(this.mSurfaceAlpha);
        pw.print(" rect=(");
        pw.print(this.mSurfaceX);
        pw.print(",");
        pw.print(this.mSurfaceY);
        pw.print(") ");
        pw.print(this.mSurfaceW);
        pw.print(" x ");
        pw.println(this.mSurfaceH);
    }

    public String toString() {
        return this.mSurfaceControl.toString();
    }

    class SurfaceControlWithBackground
    extends SurfaceControl {
        private SurfaceControl mBackgroundControl;
        private boolean mOpaque;
        private boolean mAppForcedInvisible;
        private AppWindowToken mAppToken;
        public boolean mVisible;
        public int mLayer;

        public SurfaceControlWithBackground(SurfaceSession s, String name, int w, int h, int format, int flags, AppWindowToken token) throws Surface.OutOfResourcesException {
            super(s, name, w, h, format, flags);
            this.mOpaque = true;
            this.mAppForcedInvisible = false;
            this.mVisible = false;
            this.mLayer = -1;
            this.mBackgroundControl = new SurfaceControl(s, name, w, h, -1, flags | 0x20000);
            this.mOpaque = (flags & 0x400) != 0;
            this.mAppToken = token;
            this.mAppToken.addSurfaceViewBackground(this);
        }

        @Override
        public void setAlpha(float alpha) {
            super.setAlpha(alpha);
            this.mBackgroundControl.setAlpha(alpha);
        }

        @Override
        public void setLayer(int zorder) {
            super.setLayer(zorder);
            this.mBackgroundControl.setLayer(zorder - 1);
            if (this.mLayer != zorder) {
                this.mLayer = zorder;
                this.mAppToken.updateSurfaceViewBackgroundVisibilities();
            }
        }

        @Override
        public void setPosition(float x, float y) {
            super.setPosition(x, y);
            this.mBackgroundControl.setPosition(x, y);
        }

        @Override
        public void setSize(int w, int h) {
            super.setSize(w, h);
            this.mBackgroundControl.setSize(w, h);
        }

        @Override
        public void setWindowCrop(Rect crop) {
            super.setWindowCrop(crop);
            this.mBackgroundControl.setWindowCrop(crop);
        }

        @Override
        public void setFinalCrop(Rect crop) {
            super.setFinalCrop(crop);
            this.mBackgroundControl.setFinalCrop(crop);
        }

        @Override
        public void setLayerStack(int layerStack) {
            super.setLayerStack(layerStack);
            this.mBackgroundControl.setLayerStack(layerStack);
        }

        @Override
        public void setOpaque(boolean isOpaque) {
            super.setOpaque(isOpaque);
            this.mOpaque = isOpaque;
            this.updateBackgroundVisibility(this.mAppForcedInvisible);
        }

        @Override
        public void setSecure(boolean isSecure) {
            super.setSecure(isSecure);
        }

        @Override
        public void setMatrix(float dsdx, float dtdx, float dsdy, float dtdy) {
            super.setMatrix(dsdx, dtdx, dsdy, dtdy);
            this.mBackgroundControl.setMatrix(dsdx, dtdx, dsdy, dtdy);
        }

        @Override
        public void hide() {
            super.hide();
            if (this.mVisible) {
                this.mVisible = false;
                this.mAppToken.updateSurfaceViewBackgroundVisibilities();
            }
        }

        @Override
        public void show() {
            super.show();
            if (!this.mVisible) {
                this.mVisible = true;
                this.mAppToken.updateSurfaceViewBackgroundVisibilities();
            }
        }

        @Override
        public void destroy() {
            super.destroy();
            this.mBackgroundControl.destroy();
            this.mAppToken.removeSurfaceViewBackground(this);
        }

        @Override
        public void release() {
            super.release();
            this.mBackgroundControl.release();
        }

        @Override
        public void setTransparentRegionHint(Region region) {
            super.setTransparentRegionHint(region);
            this.mBackgroundControl.setTransparentRegionHint(region);
        }

        @Override
        public void deferTransactionUntil(IBinder handle, long frame) {
            super.deferTransactionUntil(handle, frame);
            this.mBackgroundControl.deferTransactionUntil(handle, frame);
        }

        void updateBackgroundVisibility(boolean forcedInvisible) {
            this.mAppForcedInvisible = forcedInvisible;
            if (this.mOpaque && this.mVisible && !this.mAppForcedInvisible) {
                this.mBackgroundControl.show();
            } else {
                this.mBackgroundControl.hide();
            }
        }
    }

    static class SurfaceTrace
    extends SurfaceControl {
        private static final String SURFACE_TAG = "WindowManager";
        private static final boolean LOG_SURFACE_TRACE = false;
        static final ArrayList<SurfaceTrace> sSurfaces = new ArrayList();
        private float mSurfaceTraceAlpha = 0.0f;
        private int mLayer;
        private final PointF mPosition = new PointF();
        private final Point mSize = new Point();
        private final Rect mWindowCrop = new Rect();
        private final Rect mFinalCrop = new Rect();
        private boolean mShown = false;
        private int mLayerStack;
        private boolean mIsOpaque;
        private float mDsdx;
        private float mDtdx;
        private float mDsdy;
        private float mDtdy;
        private final String mName;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SurfaceTrace(SurfaceSession s, String name, int w, int h, int format, int flags) throws Surface.OutOfResourcesException {
            super(s, name, w, h, format, flags);
            this.mName = name != null ? name : "Not named";
            this.mSize.set(w, h);
            ArrayList<SurfaceTrace> arrayList = sSurfaces;
            synchronized (arrayList) {
                sSurfaces.add(0, this);
            }
        }

        @Override
        public void setAlpha(float alpha) {
            if (this.mSurfaceTraceAlpha != alpha) {
                this.mSurfaceTraceAlpha = alpha;
            }
            super.setAlpha(alpha);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLayer(int zorder) {
            if (zorder != this.mLayer) {
                this.mLayer = zorder;
            }
            super.setLayer(zorder);
            ArrayList<SurfaceTrace> arrayList = sSurfaces;
            synchronized (arrayList) {
                int i;
                sSurfaces.remove(this);
                for (i = sSurfaces.size() - 1; i >= 0; --i) {
                    SurfaceTrace s = sSurfaces.get(i);
                    if (s.mLayer < zorder) break;
                }
                sSurfaces.add(i + 1, this);
            }
        }

        @Override
        public void setPosition(float x, float y) {
            if (x != this.mPosition.x || y != this.mPosition.y) {
                this.mPosition.set(x, y);
            }
            super.setPosition(x, y);
        }

        @Override
        public void setPositionAppliesWithResize() {
            super.setPositionAppliesWithResize();
        }

        @Override
        public void setSize(int w, int h) {
            if (w != this.mSize.x || h != this.mSize.y) {
                this.mSize.set(w, h);
            }
            super.setSize(w, h);
        }

        @Override
        public void setWindowCrop(Rect crop) {
            if (crop != null && !crop.equals(this.mWindowCrop)) {
                this.mWindowCrop.set(crop);
            }
            super.setWindowCrop(crop);
        }

        @Override
        public void setFinalCrop(Rect crop) {
            if (crop != null && !crop.equals(this.mFinalCrop)) {
                this.mFinalCrop.set(crop);
            }
            super.setFinalCrop(crop);
        }

        @Override
        public void setLayerStack(int layerStack) {
            if (layerStack != this.mLayerStack) {
                this.mLayerStack = layerStack;
            }
            super.setLayerStack(layerStack);
        }

        @Override
        public void setOpaque(boolean isOpaque) {
            if (isOpaque != this.mIsOpaque) {
                this.mIsOpaque = isOpaque;
            }
            super.setOpaque(isOpaque);
        }

        @Override
        public void setSecure(boolean isSecure) {
            super.setSecure(isSecure);
        }

        @Override
        public void setMatrix(float dsdx, float dtdx, float dsdy, float dtdy) {
            if (dsdx != this.mDsdx || dtdx != this.mDtdx || dsdy != this.mDsdy || dtdy != this.mDtdy) {
                this.mDsdx = dsdx;
                this.mDtdx = dtdx;
                this.mDsdy = dsdy;
                this.mDtdy = dtdy;
            }
            super.setMatrix(dsdx, dtdx, dsdy, dtdy);
        }

        @Override
        public void hide() {
            if (this.mShown) {
                this.mShown = false;
            }
            super.hide();
        }

        @Override
        public void show() {
            if (!this.mShown) {
                this.mShown = true;
            }
            super.show();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            super.destroy();
            ArrayList<SurfaceTrace> arrayList = sSurfaces;
            synchronized (arrayList) {
                sSurfaces.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            super.release();
            ArrayList<SurfaceTrace> arrayList = sSurfaces;
            synchronized (arrayList) {
                sSurfaces.remove(this);
            }
        }

        @Override
        public void setTransparentRegionHint(Region region) {
            super.setTransparentRegionHint(region);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void dumpAllSurfaces(PrintWriter pw, String header) {
            ArrayList<SurfaceTrace> arrayList = sSurfaces;
            synchronized (arrayList) {
                int N = sSurfaces.size();
                if (N <= 0) {
                    return;
                }
                if (header != null) {
                    pw.println(header);
                }
                pw.println("WINDOW MANAGER SURFACES (dumpsys window surfaces)");
                for (int i = 0; i < N; ++i) {
                    SurfaceTrace s = sSurfaces.get(i);
                    pw.print("  Surface #");
                    pw.print(i);
                    pw.print(": #");
                    pw.print(Integer.toHexString(System.identityHashCode(s)));
                    pw.print(" ");
                    pw.println(s.mName);
                    pw.print("    mLayerStack=");
                    pw.print(s.mLayerStack);
                    pw.print(" mLayer=");
                    pw.println(s.mLayer);
                    pw.print("    mShown=");
                    pw.print(s.mShown);
                    pw.print(" mAlpha=");
                    pw.print(s.mSurfaceTraceAlpha);
                    pw.print(" mIsOpaque=");
                    pw.println(s.mIsOpaque);
                    pw.print("    mPosition=");
                    pw.print(s.mPosition.x);
                    pw.print(",");
                    pw.print(s.mPosition.y);
                    pw.print(" mSize=");
                    pw.print(s.mSize.x);
                    pw.print("x");
                    pw.println(s.mSize.y);
                    pw.print("    mCrop=");
                    s.mWindowCrop.printShortString(pw);
                    pw.println();
                    pw.print("    mFinalCrop=");
                    s.mFinalCrop.printShortString(pw);
                    pw.println();
                    pw.print("    Transform: (");
                    pw.print(s.mDsdx);
                    pw.print(", ");
                    pw.print(s.mDtdx);
                    pw.print(", ");
                    pw.print(s.mDsdy);
                    pw.print(", ");
                    pw.print(s.mDtdy);
                    pw.println(")");
                }
            }
        }

        @Override
        public String toString() {
            return "Surface " + Integer.toHexString(System.identityHashCode(this)) + " " + this.mName + " (" + this.mLayerStack + "): shown=" + this.mShown + " layer=" + this.mLayer + " alpha=" + this.mSurfaceTraceAlpha + " " + this.mPosition.x + "," + this.mPosition.y + " " + this.mSize.x + "x" + this.mSize.y + " crop=" + this.mWindowCrop.toShortString() + " opaque=" + this.mIsOpaque + " (" + this.mDsdx + "," + this.mDtdx + "," + this.mDsdy + "," + this.mDtdy + ")";
        }
    }
}

