/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Debug;
import android.os.PowerManagerInternal;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.view.animation.Animation;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayContentList;
import com.android.server.wm.Session;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;

class WindowSurfacePlacer {
    private static final String TAG = "WindowManager";
    private final WindowManagerService mService;
    private final WallpaperController mWallpaperControllerLocked;
    private boolean mInLayout = false;
    private int mLayoutRepeatCount;
    static final int SET_UPDATE_ROTATION = 1;
    static final int SET_WALLPAPER_MAY_CHANGE = 2;
    static final int SET_FORCE_HIDING_CHANGED = 4;
    static final int SET_ORIENTATION_CHANGE_COMPLETE = 8;
    static final int SET_TURN_ON_SCREEN = 16;
    static final int SET_WALLPAPER_ACTION_PENDING = 32;
    boolean mWallpaperMayChange = false;
    boolean mOrientationChangeComplete = true;
    boolean mWallpaperActionPending = false;
    private boolean mWallpaperForceHidingChanged = false;
    private Object mLastWindowFreezeSource = null;
    private Session mHoldScreen = null;
    private boolean mObscured = false;
    private boolean mSyswin = false;
    private float mScreenBrightness = -1.0f;
    private float mButtonBrightness = -1.0f;
    private long mUserActivityTimeout = -1L;
    private boolean mUpdateRotation = false;
    private final Rect mTmpStartRect = new Rect();
    private final Rect mTmpContentRect = new Rect();
    private boolean mDisplayHasContent = false;
    private boolean mObscureApplicationContentOnSecondaryDisplays = false;
    private float mPreferredRefreshRate = 0.0f;
    private int mPreferredModeId = 0;
    private boolean mTraversalScheduled;
    private int mDeferDepth = 0;
    private boolean mSustainedPerformanceModeEnabled = false;
    private boolean mSustainedPerformanceModeCurrent = false;
    WindowState mHoldScreenWindow = null;
    WindowState mObsuringWindow = null;
    private final LayerAndToken mTmpLayerAndToken = new LayerAndToken();
    private final ArrayList<SurfaceControl> mPendingDestroyingSurfaces = new ArrayList();

    public WindowSurfacePlacer(WindowManagerService service) {
        this.mService = service;
        this.mWallpaperControllerLocked = this.mService.mWallpaperControllerLocked;
    }

    void deferLayout() {
        ++this.mDeferDepth;
    }

    void continueLayout() {
        --this.mDeferDepth;
        if (this.mDeferDepth <= 0) {
            this.performSurfacePlacement();
        }
    }

    final void performSurfacePlacement() {
        if (this.mDeferDepth > 0) {
            return;
        }
        int loopCount = 6;
        do {
            this.mTraversalScheduled = false;
            this.performSurfacePlacementLoop();
            this.mService.mH.removeMessages(4);
        } while (this.mTraversalScheduled && --loopCount > 0);
        this.mWallpaperActionPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSurfacePlacementLoop() {
        if (this.mInLayout) {
            Slog.w(TAG, "performLayoutAndPlaceSurfacesLocked called while in layout. Callers=" + Debug.getCallers(3));
            return;
        }
        if (this.mService.mWaitingForConfig) {
            return;
        }
        if (!this.mService.mDisplayReady) {
            return;
        }
        Trace.traceBegin(32L, "wmLayout");
        this.mInLayout = true;
        boolean recoveringMemory = false;
        if (!this.mService.mForceRemoves.isEmpty()) {
            Object tmp;
            recoveringMemory = true;
            while (!this.mService.mForceRemoves.isEmpty()) {
                WindowState ws = this.mService.mForceRemoves.remove(0);
                Slog.i(TAG, "Force removing: " + ws);
                this.mService.removeWindowInnerLocked(ws);
            }
            Slog.w(TAG, "Due to memory failure, waiting a bit for next layout");
            Object object = tmp = new Object();
            synchronized (object) {
                try {
                    tmp.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.performSurfacePlacementInner(recoveringMemory);
            this.mInLayout = false;
            if (this.mService.needsLayout()) {
                if (++this.mLayoutRepeatCount < 6) {
                    this.requestTraversal();
                } else {
                    Slog.e(TAG, "Performed 6 layouts in a row. Skipping");
                    this.mLayoutRepeatCount = 0;
                }
            } else {
                this.mLayoutRepeatCount = 0;
            }
            if (this.mService.mWindowsChanged && !this.mService.mWindowChangeListeners.isEmpty()) {
                this.mService.mH.removeMessages(19);
                this.mService.mH.sendEmptyMessage(19);
            }
        }
        catch (RuntimeException e) {
            this.mInLayout = false;
            Slog.wtf(TAG, "Unhandled exception while laying out windows", e);
        }
        Trace.traceEnd(32L);
    }

    void debugLayoutRepeats(String msg, int pendingLayoutChanges) {
        if (this.mLayoutRepeatCount >= 4) {
            Slog.v(TAG, "Layouts looping: " + msg + ", mPendingLayoutChanges = 0x" + Integer.toHexString(pendingLayoutChanges));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSurfacePlacementInner(boolean recoveringMemory) {
        int N;
        DisplayContent displayContent;
        int displayNdx;
        int i;
        boolean updateInputWindowsNeeded = false;
        if (this.mService.mFocusMayChange) {
            this.mService.mFocusMayChange = false;
            updateInputWindowsNeeded = this.mService.updateFocusedWindowLocked(3, false);
        }
        int numDisplays = this.mService.mDisplayContents.size();
        for (int displayNdx2 = 0; displayNdx2 < numDisplays; ++displayNdx2) {
            DisplayContent displayContent2 = this.mService.mDisplayContents.valueAt(displayNdx2);
            for (i = displayContent2.mExitingTokens.size() - 1; i >= 0; --i) {
                displayContent2.mExitingTokens.get((int)i).hasVisible = false;
            }
        }
        for (int stackNdx = this.mService.mStackIdToStack.size() - 1; stackNdx >= 0; --stackNdx) {
            AppTokenList exitingAppTokens = this.mService.mStackIdToStack.valueAt((int)stackNdx).mExitingAppTokens;
            for (int tokenNdx = exitingAppTokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                ((AppWindowToken)exitingAppTokens.get((int)tokenNdx)).hasVisible = false;
            }
        }
        this.mHoldScreen = null;
        this.mHoldScreenWindow = null;
        this.mObsuringWindow = null;
        this.mScreenBrightness = -1.0f;
        this.mButtonBrightness = -1.0f;
        this.mUserActivityTimeout = -1L;
        this.mObscureApplicationContentOnSecondaryDisplays = false;
        this.mSustainedPerformanceModeCurrent = false;
        ++this.mService.mTransactionSequence;
        DisplayContent defaultDisplay = this.mService.getDefaultDisplayContentLocked();
        DisplayInfo defaultInfo = defaultDisplay.getDisplayInfo();
        int defaultDw = defaultInfo.logicalWidth;
        int defaultDh = defaultInfo.logicalHeight;
        SurfaceControl.openTransaction();
        try {
            this.applySurfaceChangesTransaction(recoveringMemory, numDisplays, defaultDw, defaultDh);
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unhandled exception in Window Manager", e);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
        WindowList defaultWindows = defaultDisplay.getWindowList();
        if (this.mService.mAppTransition.isReady()) {
            defaultDisplay.pendingLayoutChanges |= this.handleAppTransitionReadyLocked(defaultWindows);
        }
        if (!this.mService.mAnimator.mAppWindowAnimating && this.mService.mAppTransition.isRunning()) {
            defaultDisplay.pendingLayoutChanges |= this.mService.handleAnimatingStoppedAndTransitionLocked();
        }
        if (this.mWallpaperForceHidingChanged && defaultDisplay.pendingLayoutChanges == 0 && !this.mService.mAppTransition.isReady()) {
            defaultDisplay.pendingLayoutChanges |= 1;
        }
        this.mWallpaperForceHidingChanged = false;
        if (this.mWallpaperMayChange) {
            defaultDisplay.pendingLayoutChanges |= 4;
        }
        if (this.mService.mFocusMayChange) {
            this.mService.mFocusMayChange = false;
            if (this.mService.updateFocusedWindowLocked(2, false)) {
                updateInputWindowsNeeded = true;
                defaultDisplay.pendingLayoutChanges |= 8;
            }
        }
        if (this.mService.needsLayout()) {
            defaultDisplay.pendingLayoutChanges |= 1;
        }
        for (i = this.mService.mResizingWindows.size() - 1; i >= 0; --i) {
            WindowState win = this.mService.mResizingWindows.get(i);
            if (win.mAppFreezing) continue;
            if (win.mAppToken != null) {
                win.mAppToken.destroySavedSurfaces();
            }
            win.reportResized();
            this.mService.mResizingWindows.remove(i);
        }
        if (this.mOrientationChangeComplete) {
            if (this.mService.mWindowsFreezingScreen != 0) {
                this.mService.mWindowsFreezingScreen = 0;
                this.mService.mLastFinishedFreezeSource = this.mLastWindowFreezeSource;
                this.mService.mH.removeMessages(11);
            }
            this.mService.stopFreezingDisplayLocked();
        }
        boolean wallpaperDestroyed = false;
        i = this.mService.mDestroySurface.size();
        if (i > 0) {
            do {
                WindowState win = this.mService.mDestroySurface.get(--i);
                win.mDestroying = false;
                if (this.mService.mInputMethodWindow == win) {
                    this.mService.mInputMethodWindow = null;
                }
                if (this.mWallpaperControllerLocked.isWallpaperTarget(win)) {
                    wallpaperDestroyed = true;
                }
                win.destroyOrSaveSurface();
            } while (i > 0);
            this.mService.mDestroySurface.clear();
        }
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            displayContent = this.mService.mDisplayContents.valueAt(displayNdx);
            ArrayList<WindowToken> exitingTokens = displayContent.mExitingTokens;
            for (i = exitingTokens.size() - 1; i >= 0; --i) {
                WindowToken token = exitingTokens.get(i);
                if (token.hasVisible) continue;
                exitingTokens.remove(i);
                if (token.windowType != 2013) continue;
                this.mWallpaperControllerLocked.removeWallpaperToken(token);
            }
        }
        for (int stackNdx = this.mService.mStackIdToStack.size() - 1; stackNdx >= 0; --stackNdx) {
            AppTokenList exitingAppTokens = this.mService.mStackIdToStack.valueAt((int)stackNdx).mExitingAppTokens;
            for (i = exitingAppTokens.size() - 1; i >= 0; --i) {
                AppWindowToken token = (AppWindowToken)exitingAppTokens.get(i);
                if (token.hasVisible || this.mService.mClosingApps.contains(token) || token.mIsExiting && !token.allAppWindows.isEmpty()) continue;
                token.mAppAnimator.clearAnimation();
                token.mAppAnimator.animating = false;
                token.removeAppFromTaskLocked();
            }
        }
        if (wallpaperDestroyed) {
            defaultDisplay.pendingLayoutChanges |= 4;
            defaultDisplay.layoutNeeded = true;
        }
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            displayContent = this.mService.mDisplayContents.valueAt(displayNdx);
            if (displayContent.pendingLayoutChanges == 0) continue;
            displayContent.layoutNeeded = true;
        }
        this.mService.mInputMonitor.updateInputWindowsLw(true);
        this.mService.setHoldScreenLocked(this.mHoldScreen);
        if (!this.mService.mDisplayFrozen) {
            if (this.mScreenBrightness < 0.0f || this.mScreenBrightness > 1.0f) {
                this.mService.mPowerManagerInternal.setScreenBrightnessOverrideFromWindowManager(-1);
            } else {
                this.mService.mPowerManagerInternal.setScreenBrightnessOverrideFromWindowManager(WindowSurfacePlacer.toBrightnessOverride(this.mScreenBrightness));
            }
            if (this.mButtonBrightness < 0.0f || this.mButtonBrightness > 1.0f) {
                this.mService.mPowerManagerInternal.setButtonBrightnessOverrideFromWindowManager(-1);
            } else {
                this.mService.mPowerManagerInternal.setButtonBrightnessOverrideFromWindowManager(WindowSurfacePlacer.toBrightnessOverride(this.mButtonBrightness));
            }
            this.mService.mPowerManagerInternal.setUserActivityTimeoutOverrideFromWindowManager(this.mUserActivityTimeout);
        }
        if (this.mSustainedPerformanceModeCurrent != this.mSustainedPerformanceModeEnabled) {
            this.mSustainedPerformanceModeEnabled = this.mSustainedPerformanceModeCurrent;
            PowerManagerInternal cfr_ignored_0 = this.mService.mPowerManagerInternal;
            this.mService.mPowerManagerInternal.powerHint(6, this.mSustainedPerformanceModeEnabled ? 1 : 0);
        }
        if (this.mService.mTurnOnScreen) {
            if (this.mService.mAllowTheaterModeWakeFromLayout || Settings.Global.getInt(this.mService.mContext.getContentResolver(), "theater_mode_on", 0) == 0) {
                this.mService.mPowerManager.wakeUp(SystemClock.uptimeMillis(), "android.server.wm:TURN_ON");
            }
            this.mService.mTurnOnScreen = false;
        }
        if (this.mUpdateRotation) {
            if (this.mService.updateRotationUncheckedLocked(false)) {
                this.mService.mH.sendEmptyMessage(18);
            } else {
                this.mUpdateRotation = false;
            }
        }
        if (this.mService.mWaitingForDrawnCallback != null || this.mOrientationChangeComplete && !defaultDisplay.layoutNeeded && !this.mUpdateRotation) {
            this.mService.checkDrawnWindowsLocked();
        }
        if ((N = this.mService.mPendingRemove.size()) > 0) {
            if (this.mService.mPendingRemoveTmp.length < N) {
                this.mService.mPendingRemoveTmp = new WindowState[N + 10];
            }
            this.mService.mPendingRemove.toArray(this.mService.mPendingRemoveTmp);
            this.mService.mPendingRemove.clear();
            DisplayContentList displayList = new DisplayContentList();
            for (i = 0; i < N; ++i) {
                WindowState w = this.mService.mPendingRemoveTmp[i];
                this.mService.removeWindowInnerLocked(w);
                DisplayContent displayContent3 = w.getDisplayContent();
                if (displayContent3 == null || displayList.contains(displayContent3)) continue;
                displayList.add(displayContent3);
            }
            for (DisplayContent displayContent3 : displayList) {
                this.mService.mLayersController.assignLayersLocked(displayContent3.getWindowList());
                displayContent3.layoutNeeded = true;
            }
        }
        for (int displayNdx3 = this.mService.mDisplayContents.size() - 1; displayNdx3 >= 0; --displayNdx3) {
            this.mService.mDisplayContents.valueAt(displayNdx3).checkForDeferredActions();
        }
        if (updateInputWindowsNeeded) {
            this.mService.mInputMonitor.updateInputWindowsLw(false);
        }
        this.mService.setFocusTaskRegionLocked();
        this.mService.enableScreenIfNeededLocked();
        this.mService.scheduleAnimationLocked();
        this.mService.mWindowPlacerLocked.destroyPendingSurfaces();
    }

    private void applySurfaceChangesTransaction(boolean recoveringMemory, int numDisplays, int defaultDw, int defaultDh) {
        if (this.mService.mWatermark != null) {
            this.mService.mWatermark.positionSurface(defaultDw, defaultDh);
        }
        if (this.mService.mStrictModeFlash != null) {
            this.mService.mStrictModeFlash.positionSurface(defaultDw, defaultDh);
        }
        if (this.mService.mCircularDisplayMask != null) {
            this.mService.mCircularDisplayMask.positionSurface(defaultDw, defaultDh, this.mService.mRotation);
        }
        if (this.mService.mEmulatorDisplayOverlay != null) {
            this.mService.mEmulatorDisplayOverlay.positionSurface(defaultDw, defaultDh, this.mService.mRotation);
        }
        boolean focusDisplayed = false;
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mService.mDisplayContents.valueAt(displayNdx);
            boolean updateAllDrawn = false;
            WindowList windows = displayContent.getWindowList();
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            int displayId = displayContent.getDisplayId();
            int dw = displayInfo.logicalWidth;
            int dh = displayInfo.logicalHeight;
            int innerDw = displayInfo.appWidth;
            int innerDh = displayInfo.appHeight;
            boolean isDefaultDisplay = displayId == 0;
            this.mDisplayHasContent = false;
            this.mPreferredRefreshRate = 0.0f;
            this.mPreferredModeId = 0;
            int repeats = 0;
            do {
                if (++repeats > 6) {
                    Slog.w(TAG, "Animation repeat aborted after too many iterations");
                    displayContent.layoutNeeded = false;
                    break;
                }
                if ((displayContent.pendingLayoutChanges & 4) != 0 && this.mWallpaperControllerLocked.adjustWallpaperWindows()) {
                    this.mService.mLayersController.assignLayersLocked(windows);
                    displayContent.layoutNeeded = true;
                }
                if (isDefaultDisplay && (displayContent.pendingLayoutChanges & 2) != 0 && this.mService.updateOrientationFromAppTokensLocked(true)) {
                    displayContent.layoutNeeded = true;
                    this.mService.mH.sendEmptyMessage(18);
                }
                if ((displayContent.pendingLayoutChanges & 1) != 0) {
                    displayContent.layoutNeeded = true;
                }
                if (repeats < 4) {
                    this.performLayoutLockedInner(displayContent, repeats == 1, false);
                } else {
                    Slog.w(TAG, "Layout repeat skipped after too many iterations");
                }
                displayContent.pendingLayoutChanges = 0;
                if (!isDefaultDisplay) continue;
                this.mService.mPolicy.beginPostLayoutPolicyLw(dw, dh);
                for (int i = windows.size() - 1; i >= 0; --i) {
                    WindowState w = (WindowState)windows.get(i);
                    if (!w.mHasSurface) continue;
                    this.mService.mPolicy.applyPostLayoutPolicyLw(w, w.mAttrs, w.mAttachedWindow);
                }
                displayContent.pendingLayoutChanges |= this.mService.mPolicy.finishPostLayoutPolicyLw();
            } while (displayContent.pendingLayoutChanges != 0);
            this.mObscured = false;
            this.mSyswin = false;
            displayContent.resetDimming();
            boolean someoneLosingFocus = !this.mService.mLosingFocus.isEmpty();
            for (int i = windows.size() - 1; i >= 0; --i) {
                AppWindowToken atoken;
                WindowState w = (WindowState)windows.get(i);
                Task task = w.getTask();
                boolean obscuredChanged = w.mObscured != this.mObscured;
                w.mObscured = this.mObscured;
                if (!this.mObscured) {
                    this.handleNotObscuredLocked(w, displayInfo);
                }
                w.applyDimLayerIfNeeded();
                if (isDefaultDisplay && obscuredChanged && this.mWallpaperControllerLocked.isWallpaperTarget(w) && w.isVisibleLw()) {
                    this.mWallpaperControllerLocked.updateWallpaperVisibility();
                }
                WindowStateAnimator winAnimator = w.mWinAnimator;
                if (w.hasMoved()) {
                    boolean adjustedForMinimizedDockOrIme;
                    int left = w.mFrame.left;
                    int top = w.mFrame.top;
                    boolean bl = adjustedForMinimizedDockOrIme = task != null && (task.mStack.isAdjustedForMinimizedDockedStack() || task.mStack.isAdjustedForIme());
                    if (!((w.mAttrs.privateFlags & 0x40) != 0 || w.isDragResizing() || adjustedForMinimizedDockOrIme || task != null && !w.getTask().mStack.hasMovementAnimations() || w.mWinAnimator.mLastHidden)) {
                        winAnimator.setMoveAnimation(left, top);
                    }
                    if (this.mService.mAccessibilityController != null && displayId == 0) {
                        this.mService.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
                    }
                    try {
                        w.mClient.moved(left, top);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    w.mMovedByResize = false;
                }
                w.mContentChanged = false;
                if (w.mHasSurface) {
                    winAnimator.deferToPendingTransaction();
                    boolean committed = winAnimator.commitFinishDrawingLocked();
                    if (isDefaultDisplay && committed) {
                        if (w.mAttrs.type == 2023) {
                            displayContent.pendingLayoutChanges |= 1;
                        }
                        if ((w.mAttrs.flags & 0x100000) != 0) {
                            this.mWallpaperMayChange = true;
                            displayContent.pendingLayoutChanges |= 4;
                        }
                    }
                    if (!winAnimator.isAnimationStarting() && !winAnimator.isWaitingForOpening()) {
                        winAnimator.computeShownFrameLocked();
                    }
                    winAnimator.setSurfaceBoundariesLocked(recoveringMemory);
                }
                if (!((atoken = w.mAppToken) == null || atoken.allDrawn && atoken.allDrawnExcludingSaved && !atoken.mAppAnimator.freezingScreen)) {
                    if (atoken.lastTransactionSequence != (long)this.mService.mTransactionSequence) {
                        atoken.lastTransactionSequence = this.mService.mTransactionSequence;
                        atoken.numDrawnWindows = 0;
                        atoken.numInterestingWindows = 0;
                        atoken.numInterestingWindowsExcludingSaved = 0;
                        atoken.numDrawnWindowsExclusingSaved = 0;
                        atoken.startingDisplayed = false;
                    }
                    if (!atoken.allDrawn && w.mightAffectAllDrawn(false)) {
                        if (w != atoken.startingWindow) {
                            if (w.isInteresting()) {
                                ++atoken.numInterestingWindows;
                                if (w.isDrawnLw()) {
                                    ++atoken.numDrawnWindows;
                                    updateAllDrawn = true;
                                }
                            }
                        } else if (w.isDrawnLw()) {
                            this.mService.mH.sendEmptyMessage(50);
                            atoken.startingDisplayed = true;
                        }
                    }
                    if (!atoken.allDrawnExcludingSaved && w.mightAffectAllDrawn(true) && w != atoken.startingWindow && w.isInteresting()) {
                        ++atoken.numInterestingWindowsExcludingSaved;
                        if (w.isDrawnLw() && !w.isAnimatingWithSavedSurface()) {
                            ++atoken.numDrawnWindowsExclusingSaved;
                            updateAllDrawn = true;
                        }
                    }
                }
                if (isDefaultDisplay && someoneLosingFocus && w == this.mService.mCurrentFocus && w.isDisplayedLw()) {
                    focusDisplayed = true;
                }
                this.mService.updateResizingWindows(w);
            }
            this.mService.mDisplayManagerInternal.setDisplayProperties(displayId, this.mDisplayHasContent, this.mPreferredRefreshRate, this.mPreferredModeId, true);
            this.mService.getDisplayContentLocked(displayId).stopDimmingIfNeeded();
            if (!updateAllDrawn) continue;
            this.updateAllDrawnLocked(displayContent);
        }
        if (focusDisplayed) {
            this.mService.mH.sendEmptyMessage(3);
        }
        this.mService.mDisplayManagerInternal.performTraversalInTransactionFromWindowManager();
    }

    boolean isInLayout() {
        return this.mInLayout;
    }

    final void performLayoutLockedInner(DisplayContent displayContent, boolean initial, boolean updateInputWindows) {
        int i;
        if (!displayContent.layoutNeeded) {
            return;
        }
        displayContent.layoutNeeded = false;
        WindowList windows = displayContent.getWindowList();
        boolean isDefaultDisplay = displayContent.isDefaultDisplay;
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        if (this.mService.mInputConsumer != null) {
            this.mService.mInputConsumer.layout(dw, dh);
        }
        if (this.mService.mWallpaperInputConsumer != null) {
            this.mService.mWallpaperInputConsumer.layout(dw, dh);
        }
        int N = windows.size();
        this.mService.mPolicy.beginLayoutLw(isDefaultDisplay, dw, dh, this.mService.mRotation, this.mService.mCurConfiguration.uiMode);
        if (isDefaultDisplay) {
            this.mService.mSystemDecorLayer = this.mService.mPolicy.getSystemDecorLayerLw();
            this.mService.mScreenRect.set(0, 0, dw, dh);
        }
        this.mService.mPolicy.getContentRectLw(this.mTmpContentRect);
        displayContent.resize(this.mTmpContentRect);
        int seq = this.mService.mLayoutSeq + 1;
        if (seq < 0) {
            seq = 0;
        }
        this.mService.mLayoutSeq = seq;
        boolean behindDream = false;
        int topAttached = -1;
        for (i = N - 1; i >= 0; --i) {
            boolean gone;
            WindowState win = (WindowState)windows.get(i);
            boolean bl = gone = behindDream && this.mService.mPolicy.canBeForceHidden(win, win.mAttrs) || win.isGoneForLayoutLw();
            if (gone && win.mHaveFrame && !win.mLayoutNeeded && (!win.isConfigChanged() && !win.setInsetsChanged() || win.isGoneForLayoutLw() || (win.mAttrs.privateFlags & 0x400) == 0 && (!win.mHasSurface || win.mAppToken == null || !win.mAppToken.layoutConfigChanges))) continue;
            if (!win.mLayoutAttached) {
                if (initial) {
                    win.mContentChanged = false;
                }
                if (win.mAttrs.type == 2023) {
                    behindDream = true;
                }
                win.mLayoutNeeded = false;
                win.prelayout();
                this.mService.mPolicy.layoutWindowLw(win, null);
                win.mLayoutSeq = seq;
                Task task = win.getTask();
                if (task == null) continue;
                displayContent.mDimLayerController.updateDimLayer(task);
                continue;
            }
            if (topAttached >= 0) continue;
            topAttached = i;
        }
        boolean attachedBehindDream = false;
        for (i = topAttached; i >= 0; --i) {
            WindowState win = (WindowState)windows.get(i);
            if (win.mLayoutAttached) {
                if (attachedBehindDream && this.mService.mPolicy.canBeForceHidden(win, win.mAttrs) || (win.mViewVisibility == 8 || !win.mRelayoutCalled) && win.mHaveFrame && !win.mLayoutNeeded) continue;
                if (initial) {
                    win.mContentChanged = false;
                }
                win.mLayoutNeeded = false;
                win.prelayout();
                this.mService.mPolicy.layoutWindowLw(win, win.mAttachedWindow);
                win.mLayoutSeq = seq;
                continue;
            }
            if (win.mAttrs.type != 2023) continue;
            attachedBehindDream = behindDream;
        }
        this.mService.mInputMonitor.setUpdateInputWindowsNeededLw();
        if (updateInputWindows) {
            this.mService.mInputMonitor.updateInputWindowsLw(false);
        }
        this.mService.mPolicy.finishLayoutLw();
        this.mService.mH.sendEmptyMessage(41);
    }

    private int handleAppTransitionReadyLocked(WindowList windows) {
        AppWindowToken lowerWallpaperAppToken;
        AppWindowToken upperWallpaperAppToken;
        int appsCount = this.mService.mOpeningApps.size();
        if (!this.transitionGoodToGo(appsCount)) {
            return 0;
        }
        int transit = this.mService.mAppTransition.getAppTransition();
        if (this.mService.mSkipAppTransitionAnimation) {
            transit = -1;
        }
        this.mService.mSkipAppTransitionAnimation = false;
        this.mService.mNoAnimationNotifyOnTransitionFinished.clear();
        this.mService.mH.removeMessages(13);
        this.mService.rebuildAppWindowListLocked();
        this.mWallpaperMayChange = false;
        WindowManager.LayoutParams animLp = null;
        int bestAnimLayer = -1;
        boolean fullscreenAnim = false;
        boolean voiceInteraction = false;
        WindowState lowerWallpaperTarget = this.mWallpaperControllerLocked.getLowerWallpaperTarget();
        WindowState upperWallpaperTarget = this.mWallpaperControllerLocked.getUpperWallpaperTarget();
        boolean openingAppHasWallpaper = false;
        boolean closingAppHasWallpaper = false;
        if (lowerWallpaperTarget == null) {
            upperWallpaperAppToken = null;
            lowerWallpaperAppToken = null;
        } else {
            lowerWallpaperAppToken = lowerWallpaperTarget.mAppToken;
            upperWallpaperAppToken = upperWallpaperTarget.mAppToken;
        }
        int closingAppsCount = this.mService.mClosingApps.size();
        appsCount = closingAppsCount + this.mService.mOpeningApps.size();
        for (int i = 0; i < appsCount; ++i) {
            WindowState ws;
            AppWindowToken wtoken;
            if (i < closingAppsCount) {
                wtoken = this.mService.mClosingApps.valueAt(i);
                if (wtoken == lowerWallpaperAppToken || wtoken == upperWallpaperAppToken) {
                    closingAppHasWallpaper = true;
                }
            } else {
                wtoken = this.mService.mOpeningApps.valueAt(i - closingAppsCount);
                if (wtoken == lowerWallpaperAppToken || wtoken == upperWallpaperAppToken) {
                    openingAppHasWallpaper = true;
                }
            }
            voiceInteraction |= wtoken.voiceInteraction;
            if (wtoken.appFullscreen) {
                ws = wtoken.findMainWindow();
                if (ws == null) continue;
                animLp = ws.mAttrs;
                bestAnimLayer = ws.mLayer;
                fullscreenAnim = true;
                continue;
            }
            if (fullscreenAnim || (ws = wtoken.findMainWindow()) == null || ws.mLayer <= bestAnimLayer) continue;
            animLp = ws.mAttrs;
            bestAnimLayer = ws.mLayer;
        }
        transit = this.maybeUpdateTransitToWallpaper(transit, openingAppHasWallpaper, closingAppHasWallpaper, lowerWallpaperTarget, upperWallpaperTarget);
        if (!this.mService.mPolicy.allowAppAnimationsLw()) {
            animLp = null;
        }
        this.processApplicationsAnimatingInPlace(transit);
        this.mTmpLayerAndToken.token = null;
        this.handleClosingApps(transit, animLp, voiceInteraction, this.mTmpLayerAndToken);
        AppWindowToken topClosingApp = this.mTmpLayerAndToken.token;
        int topClosingLayer = this.mTmpLayerAndToken.layer;
        AppWindowToken topOpeningApp = this.handleOpeningApps(transit, animLp, voiceInteraction, topClosingLayer);
        AppWindowAnimator openingAppAnimator = topOpeningApp == null ? null : topOpeningApp.mAppAnimator;
        AppWindowAnimator closingAppAnimator = topClosingApp == null ? null : topClosingApp.mAppAnimator;
        this.mService.mAppTransition.goodToGo(openingAppAnimator, closingAppAnimator, this.mService.mOpeningApps, this.mService.mClosingApps);
        this.mService.mAppTransition.postAnimationCallback();
        this.mService.mAppTransition.clear();
        this.mService.mOpeningApps.clear();
        this.mService.mClosingApps.clear();
        this.mService.getDefaultDisplayContentLocked().layoutNeeded = true;
        if (windows == this.mService.getDefaultWindowListLocked() && !this.mService.moveInputMethodWindowsIfNeededLocked(true)) {
            this.mService.mLayersController.assignLayersLocked(windows);
        }
        this.mService.updateFocusedWindowLocked(2, true);
        this.mService.mFocusMayChange = false;
        this.mService.notifyActivityDrawnForKeyguard();
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppWindowToken handleOpeningApps(int transit, WindowManager.LayoutParams animLp, boolean voiceInteraction, int topClosingLayer) {
        AppWindowToken topOpeningApp = null;
        int appsCount = this.mService.mOpeningApps.size();
        for (int i = 0; i < appsCount; ++i) {
            AppWindowToken wtoken = this.mService.mOpeningApps.valueAt(i);
            AppWindowAnimator appAnimator = wtoken.mAppAnimator;
            if (!appAnimator.usingTransferredAnimation) {
                appAnimator.clearThumbnail();
                appAnimator.setNullAnimation();
            }
            wtoken.inPendingTransaction = false;
            if (!this.mService.setTokenVisibilityLocked(wtoken, animLp, true, transit, false, voiceInteraction)) {
                this.mService.mNoAnimationNotifyOnTransitionFinished.add(wtoken.token);
            }
            wtoken.updateReportedVisibilityLocked();
            wtoken.waitingToShow = false;
            appAnimator.mAllAppWinAnimators.clear();
            int windowsCount = wtoken.allAppWindows.size();
            for (int j = 0; j < windowsCount; ++j) {
                appAnimator.mAllAppWinAnimators.add(((WindowState)wtoken.allAppWindows.get((int)j)).mWinAnimator);
            }
            SurfaceControl.openTransaction();
            try {
                this.mService.mAnimator.orAnimating(appAnimator.showAllWindowsLocked());
            }
            finally {
                SurfaceControl.closeTransaction();
            }
            this.mService.mAnimator.mAppWindowAnimating |= appAnimator.isAnimating();
            int topOpeningLayer = 0;
            if (animLp != null) {
                int layer = -1;
                for (int j = 0; j < wtoken.allAppWindows.size(); ++j) {
                    WindowState win = (WindowState)wtoken.allAppWindows.get(j);
                    if (!win.mWillReplaceWindow && !win.mRemoveOnExit) {
                        win.mAnimatingExit = false;
                        win.mWinAnimator.mAnimating = false;
                    }
                    if (win.mWinAnimator.mAnimLayer <= layer) continue;
                    layer = win.mWinAnimator.mAnimLayer;
                }
                if (topOpeningApp == null || layer > topOpeningLayer) {
                    topOpeningApp = wtoken;
                    topOpeningLayer = layer;
                }
            }
            if (!this.mService.mAppTransition.isNextAppTransitionThumbnailUp()) continue;
            this.createThumbnailAppAnimator(transit, wtoken, topOpeningLayer, topClosingLayer);
        }
        return topOpeningApp;
    }

    private void handleClosingApps(int transit, WindowManager.LayoutParams animLp, boolean voiceInteraction, LayerAndToken layerAndToken) {
        int appsCount = this.mService.mClosingApps.size();
        for (int i = 0; i < appsCount; ++i) {
            AppWindowToken wtoken = this.mService.mClosingApps.valueAt(i);
            wtoken.markSavedSurfaceExiting();
            AppWindowAnimator appAnimator = wtoken.mAppAnimator;
            appAnimator.clearThumbnail();
            appAnimator.setNullAnimation();
            wtoken.inPendingTransaction = false;
            this.mService.setTokenVisibilityLocked(wtoken, animLp, false, transit, false, voiceInteraction);
            wtoken.updateReportedVisibilityLocked();
            wtoken.allDrawn = true;
            wtoken.deferClearAllDrawn = false;
            if (wtoken.startingWindow != null && !wtoken.startingWindow.mAnimatingExit) {
                this.mService.scheduleRemoveStartingWindowLocked(wtoken);
            }
            this.mService.mAnimator.mAppWindowAnimating |= appAnimator.isAnimating();
            if (animLp != null) {
                int layer = -1;
                for (int j = 0; j < wtoken.windows.size(); ++j) {
                    WindowState win = (WindowState)wtoken.windows.get(j);
                    if (win.mWinAnimator.mAnimLayer <= layer) continue;
                    layer = win.mWinAnimator.mAnimLayer;
                }
                if (layerAndToken.token == null || layer > layerAndToken.layer) {
                    layerAndToken.token = wtoken;
                    layerAndToken.layer = layer;
                }
            }
            if (!this.mService.mAppTransition.isNextAppTransitionThumbnailDown()) continue;
            this.createThumbnailAppAnimator(transit, wtoken, 0, layerAndToken.layer);
        }
    }

    private boolean transitionGoodToGo(int appsCount) {
        int reason = 3;
        if (!this.mService.mAppTransition.isTimeout()) {
            boolean wallpaperReady;
            for (int i = 0; i < appsCount; ++i) {
                AppWindowToken wtoken = this.mService.mOpeningApps.valueAt(i);
                if (wtoken.isRelaunching()) {
                    return false;
                }
                boolean drawnBeforeRestoring = wtoken.allDrawn;
                wtoken.restoreSavedSurfaces();
                if (!(wtoken.allDrawn || wtoken.startingDisplayed || wtoken.startingMoved)) {
                    return false;
                }
                reason = wtoken.allDrawn ? (drawnBeforeRestoring ? 2 : 0) : 1;
            }
            if (this.mService.mAppTransition.isFetchingAppTransitionsSpecs()) {
                return false;
            }
            boolean bl = wallpaperReady = !this.mWallpaperControllerLocked.isWallpaperVisible() || this.mWallpaperControllerLocked.wallpaperTransitionReady();
            if (wallpaperReady) {
                this.mService.mH.obtainMessage(47, reason, 0).sendToTarget();
                return true;
            }
            return false;
        }
        this.mService.mH.obtainMessage(47, reason, 0).sendToTarget();
        return true;
    }

    private int maybeUpdateTransitToWallpaper(int transit, boolean openingAppHasWallpaper, boolean closingAppHasWallpaper, WindowState lowerWallpaperTarget, WindowState upperWallpaperTarget) {
        WindowState wallpaperTarget = this.mWallpaperControllerLocked.getWallpaperTarget();
        WindowState oldWallpaper = this.mWallpaperControllerLocked.isWallpaperTargetAnimating() ? null : wallpaperTarget;
        ArraySet<AppWindowToken> openingApps = this.mService.mOpeningApps;
        ArraySet<AppWindowToken> closingApps = this.mService.mClosingApps;
        this.mService.mAnimateWallpaperWithTarget = false;
        if (closingAppHasWallpaper && openingAppHasWallpaper) {
            switch (transit) {
                case 6: 
                case 8: 
                case 10: {
                    transit = 14;
                    break;
                }
                case 7: 
                case 9: 
                case 11: {
                    transit = 15;
                }
            }
        } else if (oldWallpaper != null && !this.mService.mOpeningApps.isEmpty() && !openingApps.contains(oldWallpaper.mAppToken) && closingApps.contains(oldWallpaper.mAppToken)) {
            transit = 12;
        } else if (wallpaperTarget != null && wallpaperTarget.isVisibleLw() && openingApps.contains(wallpaperTarget.mAppToken)) {
            transit = 13;
        } else {
            this.mService.mAnimateWallpaperWithTarget = true;
        }
        return transit;
    }

    private void handleNotObscuredLocked(WindowState w, DisplayInfo dispInfo) {
        WindowManager.LayoutParams attrs = w.mAttrs;
        int attrFlags = attrs.flags;
        boolean canBeSeen = w.isDisplayedLw();
        int privateflags = attrs.privateFlags;
        if (canBeSeen && w.isObscuringFullscreen(dispInfo)) {
            if (!this.mObscured) {
                this.mObsuringWindow = w;
            }
            this.mObscured = true;
        }
        if (w.mHasSurface) {
            if ((attrFlags & 0x80) != 0) {
                this.mHoldScreen = w.mSession;
                this.mHoldScreenWindow = w;
            }
            if (!this.mSyswin && w.mAttrs.screenBrightness >= 0.0f && this.mScreenBrightness < 0.0f) {
                this.mScreenBrightness = w.mAttrs.screenBrightness;
            }
            if (!this.mSyswin && w.mAttrs.buttonBrightness >= 0.0f && this.mButtonBrightness < 0.0f) {
                this.mButtonBrightness = w.mAttrs.buttonBrightness;
            }
            if (!this.mSyswin && w.mAttrs.userActivityTimeout >= 0L && this.mUserActivityTimeout < 0L) {
                this.mUserActivityTimeout = w.mAttrs.userActivityTimeout;
            }
            int type = attrs.type;
            if (canBeSeen && (type == 2008 || type == 2010 || (attrs.privateFlags & 0x400) != 0)) {
                this.mSyswin = true;
            }
            if (canBeSeen) {
                DisplayContent displayContent = w.getDisplayContent();
                if (displayContent != null && displayContent.isDefaultDisplay) {
                    if (type == 2023 || (attrs.privateFlags & 0x400) != 0) {
                        this.mObscureApplicationContentOnSecondaryDisplays = true;
                    }
                    this.mDisplayHasContent = true;
                } else if (displayContent != null && (!this.mObscureApplicationContentOnSecondaryDisplays || this.mObscured && type == 2009)) {
                    this.mDisplayHasContent = true;
                }
                if (this.mPreferredRefreshRate == 0.0f && w.mAttrs.preferredRefreshRate != 0.0f) {
                    this.mPreferredRefreshRate = w.mAttrs.preferredRefreshRate;
                }
                if (this.mPreferredModeId == 0 && w.mAttrs.preferredDisplayModeId != 0) {
                    this.mPreferredModeId = w.mAttrs.preferredDisplayModeId;
                }
                if ((privateflags & 0x40000) != 0) {
                    this.mSustainedPerformanceModeCurrent = true;
                }
            }
        }
    }

    private void updateAllDrawnLocked(DisplayContent displayContent) {
        ArrayList<TaskStack> stacks = displayContent.getStacks();
        for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ArrayList<Task> tasks = stacks.get(stackNdx).getTasks();
            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                    int numInteresting;
                    AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                    if (!wtoken.allDrawn && (numInteresting = wtoken.numInterestingWindows) > 0 && wtoken.numDrawnWindows >= numInteresting) {
                        wtoken.allDrawn = true;
                        displayContent.layoutNeeded = true;
                        this.mService.mH.obtainMessage(32, wtoken.token).sendToTarget();
                    }
                    if (wtoken.allDrawnExcludingSaved || (numInteresting = wtoken.numInterestingWindowsExcludingSaved) <= 0 || wtoken.numDrawnWindowsExclusingSaved < numInteresting) continue;
                    wtoken.allDrawnExcludingSaved = true;
                    displayContent.layoutNeeded = true;
                    if (!wtoken.isAnimatingInvisibleWithSavedSurface() || this.mService.mFinishedEarlyAnim.contains(wtoken)) continue;
                    this.mService.mFinishedEarlyAnim.add(wtoken);
                }
            }
        }
    }

    private static int toBrightnessOverride(float value) {
        return (int)(value * 255.0f);
    }

    private void processApplicationsAnimatingInPlace(int transit) {
        WindowState win;
        if (transit == 17 && (win = this.mService.findFocusedWindowLocked(this.mService.getDefaultDisplayContentLocked())) != null) {
            AppWindowToken wtoken = win.mAppToken;
            AppWindowAnimator appAnimator = wtoken.mAppAnimator;
            appAnimator.clearThumbnail();
            appAnimator.setNullAnimation();
            this.mService.updateTokenInPlaceLocked(wtoken, transit);
            wtoken.updateReportedVisibilityLocked();
            appAnimator.mAllAppWinAnimators.clear();
            int N = wtoken.allAppWindows.size();
            for (int j = 0; j < N; ++j) {
                appAnimator.mAllAppWinAnimators.add(((WindowState)wtoken.allAppWindows.get((int)j)).mWinAnimator);
            }
            this.mService.mAnimator.mAppWindowAnimating |= appAnimator.isAnimating();
            this.mService.mAnimator.orAnimating(appAnimator.showAllWindowsLocked());
        }
    }

    private void createThumbnailAppAnimator(int transit, AppWindowToken appToken, int openingLayer, int closingLayer) {
        AppWindowAnimator openingAppAnimator;
        AppWindowAnimator appWindowAnimator = openingAppAnimator = appToken == null ? null : appToken.mAppAnimator;
        if (openingAppAnimator == null || openingAppAnimator.animation == null) {
            return;
        }
        int taskId = appToken.mTask.mTaskId;
        Bitmap thumbnailHeader = this.mService.mAppTransition.getAppTransitionThumbnailHeader(taskId);
        if (thumbnailHeader == null || thumbnailHeader.getConfig() == Bitmap.Config.ALPHA_8) {
            return;
        }
        Rect dirty = new Rect(0, 0, thumbnailHeader.getWidth(), thumbnailHeader.getHeight());
        try {
            Animation anim2;
            DisplayContent displayContent = this.mService.getDefaultDisplayContentLocked();
            Display display = displayContent.getDisplay();
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            SurfaceControl surfaceControl = new SurfaceControl(this.mService.mFxSession, "thumbnail anim", dirty.width(), dirty.height(), -3, 4);
            surfaceControl.setLayerStack(display.getLayerStack());
            Surface drawSurface = new Surface();
            drawSurface.copyFrom(surfaceControl);
            Canvas c = drawSurface.lockCanvas(dirty);
            c.drawBitmap(thumbnailHeader, 0.0f, 0.0f, null);
            drawSurface.unlockCanvasAndPost(c);
            drawSurface.release();
            if (this.mService.mAppTransition.isNextThumbnailTransitionAspectScaled()) {
                WindowState win = appToken.findMainWindow();
                Rect appRect = win != null ? win.getContentFrameLw() : new Rect(0, 0, displayInfo.appWidth, displayInfo.appHeight);
                Rect insets = win != null ? win.mContentInsets : null;
                anim2 = this.mService.mAppTransition.createThumbnailAspectScaleAnimationLocked(appRect, insets, thumbnailHeader, taskId, this.mService.mCurConfiguration.uiMode, this.mService.mCurConfiguration.orientation);
                openingAppAnimator.thumbnailForceAboveLayer = Math.max(openingLayer, closingLayer);
                openingAppAnimator.deferThumbnailDestruction = !this.mService.mAppTransition.isNextThumbnailTransitionScaleUp();
            } else {
                anim2 = this.mService.mAppTransition.createThumbnailScaleAnimationLocked(displayInfo.appWidth, displayInfo.appHeight, transit, thumbnailHeader);
            }
            anim2.restrictDuration(10000L);
            anim2.scaleCurrentDuration(this.mService.getTransitionAnimationScaleLocked());
            openingAppAnimator.thumbnail = surfaceControl;
            openingAppAnimator.thumbnailLayer = openingLayer;
            openingAppAnimator.thumbnailAnimation = anim2;
            this.mService.mAppTransition.getNextAppTransitionStartRect(taskId, this.mTmpStartRect);
        }
        catch (Surface.OutOfResourcesException e) {
            Slog.e(TAG, "Can't allocate thumbnail/Canvas surface w=" + dirty.width() + " h=" + dirty.height(), e);
            openingAppAnimator.clearThumbnail();
        }
    }

    boolean copyAnimToLayoutParamsLocked() {
        boolean doRequest = false;
        int bulkUpdateParams = this.mService.mAnimator.mBulkUpdateParams;
        if ((bulkUpdateParams & 1) != 0) {
            this.mUpdateRotation = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 2) != 0) {
            this.mWallpaperMayChange = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 4) != 0) {
            this.mWallpaperForceHidingChanged = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 8) == 0) {
            this.mOrientationChangeComplete = false;
        } else {
            this.mOrientationChangeComplete = true;
            this.mLastWindowFreezeSource = this.mService.mAnimator.mLastWindowFreezeSource;
            if (this.mService.mWindowsFreezingScreen != 0) {
                doRequest = true;
            }
        }
        if ((bulkUpdateParams & 0x10) != 0) {
            this.mService.mTurnOnScreen = true;
        }
        if ((bulkUpdateParams & 0x20) != 0) {
            this.mWallpaperActionPending = true;
        }
        return doRequest;
    }

    void requestTraversal() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.mService.mH.sendEmptyMessage(4);
        }
    }

    void destroyAfterTransaction(SurfaceControl surface) {
        this.mPendingDestroyingSurfaces.add(surface);
    }

    void destroyPendingSurfaces() {
        for (int i = this.mPendingDestroyingSurfaces.size() - 1; i >= 0; --i) {
            this.mPendingDestroyingSurfaces.get(i).destroy();
        }
        this.mPendingDestroyingSurfaces.clear();
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mTraversalScheduled=");
        pw.println(this.mTraversalScheduled);
        pw.print(prefix);
        pw.print("mHoldScreenWindow=");
        pw.println(this.mHoldScreenWindow);
        pw.print(prefix);
        pw.print("mObsuringWindow=");
        pw.println(this.mObsuringWindow);
    }

    private static final class LayerAndToken {
        public int layer;
        public AppWindowToken token;

        private LayerAndToken() {
        }
    }
}

