/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructStat;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import libcore.io.ClassPathURLStreamHandler;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class DexPathList
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String DEX_SUFFIX = ".dex";
    private static String zipSeparator = "!/";
    private ClassLoader definingContext;
    private Element[] dexElements;
    private Element[] nativeLibraryPathElements;
    private List<File> nativeLibraryDirectories;
    private List<File> systemNativeLibraryDirectories;
    private IOException[] dexElementsSuppressedExceptions;

    private void $$robo$$dalvik_system_DexPathList$__constructor__(ClassLoader definingContext, String dexPath, String librarySearchPath, File optimizedDirectory) {
        if (definingContext == null) {
            throw new NullPointerException("definingContext == null");
        }
        if (dexPath == null) {
            throw new NullPointerException("dexPath == null");
        }
        if (optimizedDirectory != null) {
            if (!optimizedDirectory.exists()) {
                throw new IllegalArgumentException("optimizedDirectory doesn't exist: " + optimizedDirectory);
            }
            if (!optimizedDirectory.canRead() || !optimizedDirectory.canWrite()) {
                throw new IllegalArgumentException("optimizedDirectory not readable/writable: " + optimizedDirectory);
            }
        }
        this.definingContext = definingContext;
        ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
        this.dexElements = DexPathList.makeDexElements(DexPathList.splitDexPath(dexPath), optimizedDirectory, suppressedExceptions, definingContext);
        this.nativeLibraryDirectories = DexPathList.splitPaths(librarySearchPath, false);
        this.systemNativeLibraryDirectories = DexPathList.splitPaths(System.getProperty("java.library.path"), true);
        ArrayList<File> allNativeLibraryDirectories = new ArrayList<File>(this.nativeLibraryDirectories);
        allNativeLibraryDirectories.addAll(this.systemNativeLibraryDirectories);
        this.nativeLibraryPathElements = DexPathList.makePathElements(allNativeLibraryDirectories, suppressedExceptions, definingContext);
        this.dexElementsSuppressedExceptions = suppressedExceptions.size() > 0 ? suppressedExceptions.toArray(new IOException[suppressedExceptions.size()]) : null;
    }

    private final String $$robo$$dalvik_system_DexPathList$toString() {
        ArrayList<File> allNativeLibraryDirectories = new ArrayList<File>(this.nativeLibraryDirectories);
        allNativeLibraryDirectories.addAll(this.systemNativeLibraryDirectories);
        Object[] nativeLibraryDirectoriesArray = allNativeLibraryDirectories.toArray(new File[allNativeLibraryDirectories.size()]);
        return "DexPathList[" + Arrays.toString(this.dexElements) + ",nativeLibraryDirectories=" + Arrays.toString(nativeLibraryDirectoriesArray) + "]";
    }

    private final List<File> $$robo$$dalvik_system_DexPathList$getNativeLibraryDirectories() {
        return this.nativeLibraryDirectories;
    }

    private final void $$robo$$dalvik_system_DexPathList$addDexPath(String dexPath, File optimizedDirectory) {
        ArrayList<IOException> suppressedExceptionList = new ArrayList<IOException>();
        Element[] newElements = DexPathList.makeDexElements(DexPathList.splitDexPath(dexPath), optimizedDirectory, suppressedExceptionList, this.definingContext);
        if (newElements != null && newElements.length > 0) {
            Element[] oldElements = this.dexElements;
            this.dexElements = new Element[oldElements.length + newElements.length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldElements, (int)0, (Object)this.dexElements, (int)0, (int)oldElements.length);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)newElements, (int)0, (Object)this.dexElements, (int)oldElements.length, (int)newElements.length);
        }
        if (suppressedExceptionList.size() > 0) {
            IOException[] newSuppressedExceptions = suppressedExceptionList.toArray(new IOException[suppressedExceptionList.size()]);
            if (this.dexElementsSuppressedExceptions != null) {
                IOException[] oldSuppressedExceptions = this.dexElementsSuppressedExceptions;
                int suppressedExceptionsLength = oldSuppressedExceptions.length + newSuppressedExceptions.length;
                this.dexElementsSuppressedExceptions = new IOException[suppressedExceptionsLength];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldSuppressedExceptions, (int)0, (Object)this.dexElementsSuppressedExceptions, (int)0, (int)oldSuppressedExceptions.length);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)newSuppressedExceptions, (int)0, (Object)this.dexElementsSuppressedExceptions, (int)oldSuppressedExceptions.length, (int)newSuppressedExceptions.length);
            } else {
                this.dexElementsSuppressedExceptions = newSuppressedExceptions;
            }
        }
    }

    private static final List<File> $$robo$$dalvik_system_DexPathList$splitDexPath(String path) {
        return DexPathList.splitPaths(path, false);
    }

    private static final List<File> $$robo$$dalvik_system_DexPathList$splitPaths(String searchPath, boolean directoriesOnly) {
        ArrayList<File> result = new ArrayList<File>();
        if (searchPath != null) {
            for (String path : searchPath.split(File.pathSeparator)) {
                if (directoriesOnly) {
                    try {
                        StructStat sb = Libcore.os.stat(path);
                        if (!OsConstants.S_ISDIR(sb.st_mode)) {
                        }
                    }
                    catch (ErrnoException ignored) {}
                    continue;
                }
                result.add(new File(path));
            }
        }
        return result;
    }

    private static final Element[] $$robo$$dalvik_system_DexPathList$makeDexElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions, ClassLoader loader) {
        return DexPathList.makeElements(files, optimizedDirectory, suppressedExceptions, false, loader);
    }

    private static final Element[] $$robo$$dalvik_system_DexPathList$makePathElements(List<File> files, List<IOException> suppressedExceptions, ClassLoader loader) {
        return DexPathList.makeElements(files, null, suppressedExceptions, true, loader);
    }

    private static final Element[] $$robo$$dalvik_system_DexPathList$makePathElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions) {
        return DexPathList.makeElements(files, optimizedDirectory, suppressedExceptions, false, null);
    }

    private static final Element[] $$robo$$dalvik_system_DexPathList$makeElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions, boolean ignoreDexFiles, ClassLoader loader) {
        Element[] elements = new Element[files.size()];
        int elementsPos = 0;
        for (File file : files) {
            File zip = null;
            File dir = new File("");
            DexFile dex = null;
            String path = file.getPath();
            String name = file.getName();
            if (path.contains("!/")) {
                String[] split = path.split("!/", 2);
                zip = new File(split[0]);
                dir = new File(split[1]);
            } else if (file.isDirectory()) {
                elements[elementsPos++] = new Element(file, true, null, null);
            } else if (file.isFile()) {
                if (!ignoreDexFiles && name.endsWith(".dex")) {
                    try {
                        dex = DexPathList.loadDexFile(file, optimizedDirectory, loader, elements);
                    }
                    catch (IOException suppressed) {
                        InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("Unable to load dex file: " + file), (Throwable)suppressed);
                        suppressedExceptions.add(suppressed);
                    }
                } else {
                    zip = file;
                    if (!ignoreDexFiles) {
                        try {
                            dex = DexPathList.loadDexFile(file, optimizedDirectory, loader, elements);
                        }
                        catch (IOException suppressed) {
                            suppressedExceptions.add(suppressed);
                        }
                    }
                }
            } else {
                InvokeDynamicSupport.bootstrapIntrinsic("logW", "java.lang.System", (String)("ClassLoader referenced unknown path: " + file));
            }
            if (zip == null && dex == null) continue;
            elements[elementsPos++] = new Element(dir, false, zip, dex);
        }
        if (elementsPos != elements.length) {
            elements = Arrays.copyOf(elements, elementsPos);
        }
        return elements;
    }

    private static final DexFile $$robo$$dalvik_system_DexPathList$loadDexFile(File file, File optimizedDirectory, ClassLoader loader, Element[] elements) throws IOException {
        if (optimizedDirectory == null) {
            return new DexFile(file, loader, elements);
        }
        String optimizedPath = DexPathList.optimizedPathFor(file, optimizedDirectory);
        return DexFile.loadDex(file.getPath(), optimizedPath, 0, loader, elements);
    }

    private static final String $$robo$$dalvik_system_DexPathList$optimizedPathFor(File path, File optimizedDirectory) {
        String fileName = path.getName();
        if (!fileName.endsWith(".dex")) {
            int lastDot = fileName.lastIndexOf(".");
            if (lastDot < 0) {
                fileName = fileName + ".dex";
            } else {
                StringBuilder sb = new StringBuilder(lastDot + 4);
                sb.append(fileName, 0, lastDot);
                sb.append(".dex");
                fileName = sb.toString();
            }
        }
        File result = new File(optimizedDirectory, fileName);
        return result.getPath();
    }

    private final Class $$robo$$dalvik_system_DexPathList$findClass(String name, List<Throwable> suppressed) {
        for (Element element : this.dexElements) {
            Class clazz;
            DexFile dex = element.dexFile;
            if (dex == null || (clazz = dex.loadClassBinaryName(name, this.definingContext, suppressed)) == null) continue;
            return clazz;
        }
        if (this.dexElementsSuppressedExceptions != null) {
            suppressed.addAll(Arrays.asList(this.dexElementsSuppressedExceptions));
        }
        return null;
    }

    private final URL $$robo$$dalvik_system_DexPathList$findResource(String name) {
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private final Enumeration<URL> $$robo$$dalvik_system_DexPathList$findResources(String name) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            result.add(url);
        }
        return Collections.enumeration(result);
    }

    private final String $$robo$$dalvik_system_DexPathList$findLibrary(String libraryName) {
        String fileName = System.mapLibraryName(libraryName);
        for (Element element : this.nativeLibraryPathElements) {
            String path = element.findNativeLibrary(fileName);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    private void __constructor__(ClassLoader classLoader, String string2, String string3, File file) {
        this.$$robo$$dalvik_system_DexPathList$__constructor__(classLoader, string2, string3, file);
    }

    public DexPathList(ClassLoader classLoader, String string2, String string3, File file) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList$__constructor__(java.lang.ClassLoader java.lang.String java.lang.String java.io.File ), 0, this, classLoader, string2, string3, file);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$dalvik_system_DexPathList$toString(), 0, this);
    }

    public List<File> getNativeLibraryDirectories() {
        return InvokeDynamicSupport.bootstrap("getNativeLibraryDirectories", $$robo$$dalvik_system_DexPathList$getNativeLibraryDirectories(), 0, this);
    }

    public void addDexPath(String string2, File file) {
        InvokeDynamicSupport.bootstrap("addDexPath", $$robo$$dalvik_system_DexPathList$addDexPath(java.lang.String java.io.File ), 0, this, string2, file);
    }

    private static List<File> splitDexPath(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("splitDexPath", $$robo$$dalvik_system_DexPathList$splitDexPath(java.lang.String ), 0, (String)string2);
    }

    private static List<File> splitPaths(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("splitPaths", $$robo$$dalvik_system_DexPathList$splitPaths(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    private static Element[] makeDexElements(List<File> list, File file, List<IOException> list2, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrapStatic("makeDexElements", $$robo$$dalvik_system_DexPathList$makeDexElements(java.util.List<java.io.File> java.io.File java.util.List<java.io.IOException> java.lang.ClassLoader ), 0, list, (File)file, list2, (ClassLoader)classLoader);
    }

    private static Element[] makePathElements(List<File> list, List<IOException> list2, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrapStatic("makePathElements", $$robo$$dalvik_system_DexPathList$makePathElements(java.util.List<java.io.File> java.util.List<java.io.IOException> java.lang.ClassLoader ), 0, list, list2, (ClassLoader)classLoader);
    }

    private static Element[] makePathElements(List<File> list, File file, List<IOException> list2) {
        return InvokeDynamicSupport.bootstrapStatic("makePathElements", $$robo$$dalvik_system_DexPathList$makePathElements(java.util.List<java.io.File> java.io.File java.util.List<java.io.IOException> ), 0, list, (File)file, list2);
    }

    private static Element[] makeElements(List<File> list, File file, List<IOException> list2, boolean bl, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrapStatic("makeElements", $$robo$$dalvik_system_DexPathList$makeElements(java.util.List<java.io.File> java.io.File java.util.List<java.io.IOException> boolean java.lang.ClassLoader ), 0, list, (File)file, list2, (boolean)bl, (ClassLoader)classLoader);
    }

    private static DexFile loadDexFile(File file, File file2, ClassLoader classLoader, Element[] elementArray) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("loadDexFile", $$robo$$dalvik_system_DexPathList$loadDexFile(java.io.File java.io.File java.lang.ClassLoader dalvik.system.DexPathList$Element[] ), 0, (File)file, (File)file2, (ClassLoader)classLoader, (Element[])elementArray);
    }

    private static String optimizedPathFor(File file, File file2) {
        return InvokeDynamicSupport.bootstrapStatic("optimizedPathFor", $$robo$$dalvik_system_DexPathList$optimizedPathFor(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    public Class findClass(String string2, List<Throwable> list) {
        return InvokeDynamicSupport.bootstrap("findClass", $$robo$$dalvik_system_DexPathList$findClass(java.lang.String java.util.List<java.lang.Throwable> ), 0, this, string2, list);
    }

    public URL findResource(String string2) {
        return InvokeDynamicSupport.bootstrap("findResource", $$robo$$dalvik_system_DexPathList$findResource(java.lang.String ), 0, this, string2);
    }

    public Enumeration<URL> findResources(String string2) {
        return InvokeDynamicSupport.bootstrap("findResources", $$robo$$dalvik_system_DexPathList$findResources(java.lang.String ), 0, this, string2);
    }

    public String findLibrary(String string2) {
        return InvokeDynamicSupport.bootstrap("findLibrary", $$robo$$dalvik_system_DexPathList$findLibrary(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ DexPathList() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DexPathList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Element
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private File dir;
        private boolean isDirectory;
        private File zip;
        private DexFile dexFile;
        private ClassPathURLStreamHandler urlHandler;
        private boolean initialized;

        private void $$robo$$dalvik_system_DexPathList_Element$__constructor__(File dir, boolean isDirectory, File zip, DexFile dexFile) {
            this.dir = dir;
            this.isDirectory = isDirectory;
            this.zip = zip;
            this.dexFile = dexFile;
        }

        private final String $$robo$$dalvik_system_DexPathList_Element$toString() {
            if (this.isDirectory) {
                return "directory \"" + this.dir + "\"";
            }
            if (this.zip != null) {
                return "zip file \"" + this.zip + "\"" + (this.dir != null && !this.dir.getPath().isEmpty() ? ", dir \"" + this.dir + "\"" : "");
            }
            return "dex file \"" + this.dexFile + "\"";
        }

        private final synchronized void $$robo$$dalvik_system_DexPathList_Element$maybeInit() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            if (this.isDirectory || this.zip == null) {
                return;
            }
            try {
                this.urlHandler = new ClassPathURLStreamHandler(this.zip.getPath());
            }
            catch (IOException ioe) {
                InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("Unable to open zip file: " + this.zip), (Throwable)ioe);
                this.urlHandler = null;
            }
        }

        private final String $$robo$$dalvik_system_DexPathList_Element$findNativeLibrary(String name) {
            String entryName;
            this.maybeInit();
            if (this.isDirectory) {
                String path = new File(this.dir, name).getPath();
                if (IoUtils.canOpenReadOnly(path)) {
                    return path;
                }
            } else if (this.urlHandler != null && this.urlHandler.isEntryStored(entryName = new File(this.dir, name).getPath())) {
                return this.zip.getPath() + "!/" + entryName;
            }
            return null;
        }

        private final URL $$robo$$dalvik_system_DexPathList_Element$findResource(String name) {
            File resourceFile;
            this.maybeInit();
            if (this.isDirectory && (resourceFile = new File(this.dir, name)).exists()) {
                try {
                    return resourceFile.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (this.urlHandler == null) {
                return null;
            }
            return this.urlHandler.getEntryUrlOrNull(name);
        }

        private void __constructor__(File file, boolean bl, File file2, DexFile dexFile) {
            this.$$robo$$dalvik_system_DexPathList_Element$__constructor__(file, bl, file2, dexFile);
        }

        public Element(File file, boolean bl, File file2, DexFile dexFile) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_DexPathList_Element$__constructor__(java.io.File boolean java.io.File dalvik.system.DexFile ), 0, this, file, bl, file2, dexFile);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$dalvik_system_DexPathList_Element$toString(), 0, this);
        }

        public synchronized void maybeInit() {
            InvokeDynamicSupport.bootstrap("maybeInit", $$robo$$dalvik_system_DexPathList_Element$maybeInit(), 0, this);
        }

        public String findNativeLibrary(String string2) {
            return InvokeDynamicSupport.bootstrap("findNativeLibrary", $$robo$$dalvik_system_DexPathList_Element$findNativeLibrary(java.lang.String ), 0, this, string2);
        }

        public URL findResource(String string2) {
            return InvokeDynamicSupport.bootstrap("findResource", $$robo$$dalvik_system_DexPathList_Element$findResource(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ Element() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Element)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

