/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system.profiler;

import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.profiler.HprofData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AsciiHprofWriter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private HprofData data;
    private PrintWriter out;
    private static Comparator<HprofData.Sample> SAMPLE_COMPARATOR;

    private static final void $$robo$$dalvik_system_profiler_AsciiHprofWriter$write(HprofData data, OutputStream outputStream) throws IOException {
        new AsciiHprofWriter(data, outputStream).write();
    }

    private void $$robo$$dalvik_system_profiler_AsciiHprofWriter$__constructor__(HprofData data, OutputStream outputStream) {
        this.data = data;
        this.out = new PrintWriter(outputStream);
    }

    private final void $$robo$$dalvik_system_profiler_AsciiHprofWriter$write() throws IOException {
        for (HprofData.ThreadEvent e : this.data.getThreadHistory()) {
            this.out.println(e);
        }
        ArrayList<HprofData.Sample> samples = new ArrayList<HprofData.Sample>(this.data.getSamples());
        Collections.sort(samples, SAMPLE_COMPARATOR);
        int total = 0;
        for (HprofData.Sample sample : samples) {
            HprofData.StackTrace stackTrace = sample.stackTrace;
            int count = sample.count;
            total += count;
            this.out.printf("TRACE %d: (thread=%d)\n", stackTrace.stackTraceId, stackTrace.threadId);
            for (StackTraceElement e : stackTrace.stackFrames) {
                this.out.printf("\t%s\n", e);
            }
        }
        Date now = new Date(this.data.getStartMillis());
        this.out.printf("CPU SAMPLES BEGIN (total = %d) %ta %tb %td %tT %tY\n", total, now, now, now, now, now);
        this.out.printf("rank   self  accum   count trace method\n", new Object[0]);
        int rank = 0;
        double accum = 0.0;
        for (HprofData.Sample sample : samples) {
            HprofData.StackTrace stackTrace = sample.stackTrace;
            int count = sample.count;
            double self = (double)count / (double)total;
            this.out.printf("% 4d% 6.2f%%% 6.2f%% % 7d % 5d %s.%s\n", ++rank, self * 100.0, (accum += self) * 100.0, count, stackTrace.stackTraceId, stackTrace.stackFrames[0].getClassName(), stackTrace.stackFrames[0].getMethodName());
        }
        this.out.printf("CPU SAMPLES END\n", new Object[0]);
        this.out.flush();
    }

    static void __staticInitializer__() {
        SAMPLE_COMPARATOR = new Comparator<HprofData.Sample>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$dalvik_system_profiler_AsciiHprofWriter_1$__constructor__() {
            }

            private final int $$robo$$dalvik_system_profiler_AsciiHprofWriter_1$compare(HprofData.Sample s1, HprofData.Sample s2) {
                return s2.count - s1.count;
            }

            private void __constructor__() {
                this.$$robo$$dalvik_system_profiler_AsciiHprofWriter_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_AsciiHprofWriter_1$__constructor__(), 0, this);
            }

            @Override
            public int compare(HprofData.Sample sample, HprofData.Sample sample2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$dalvik_system_profiler_AsciiHprofWriter_1$compare(dalvik.system.profiler.HprofData$Sample dalvik.system.profiler.HprofData$Sample ), 0, this, sample, sample2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static void write(HprofData hprofData, OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("write", $$robo$$dalvik_system_profiler_AsciiHprofWriter$write(dalvik.system.profiler.HprofData java.io.OutputStream ), 0, (HprofData)hprofData, (OutputStream)outputStream);
    }

    private void __constructor__(HprofData hprofData, OutputStream outputStream) {
        this.$$robo$$dalvik_system_profiler_AsciiHprofWriter$__constructor__(hprofData, outputStream);
    }

    private AsciiHprofWriter(HprofData hprofData, OutputStream outputStream) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_AsciiHprofWriter$__constructor__(dalvik.system.profiler.HprofData java.io.OutputStream ), 0, this, hprofData, outputStream);
    }

    private void write() throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$dalvik_system_profiler_AsciiHprofWriter$write(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AsciiHprofWriter.class);
    }

    public /* synthetic */ AsciiHprofWriter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AsciiHprofWriter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

