/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;

public final class NIOAccess {
    public static long getBasePointer(Buffer b) {
        long address = b.address;
        if (address == 0L) {
            return 0L;
        }
        return address + (long)(b.position << b._elementSizeShift);
    }

    static Object getBaseArray(Buffer b) {
        return b.hasArray() ? b.array() : null;
    }

    static int getBaseArrayOffset(Buffer b) {
        return b.hasArray() ? b.arrayOffset() + b.position << b._elementSizeShift : 0;
    }
}

