/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import android.icu.text.DisplayContext;
import android.icu.text.RelativeDateTimeFormatter;
import android.icu.util.Calendar;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Locale;
import java.util.TimeZone;
import libcore.icu.DateTimeFormat;
import libcore.icu.DateUtilsBridge;
import libcore.util.BasicLruCache;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class RelativeDateTimeFormatter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static long SECOND_IN_MILLIS = 1000L;
    public static long MINUTE_IN_MILLIS = 60000L;
    public static long HOUR_IN_MILLIS = 3600000L;
    public static long DAY_IN_MILLIS = 86400000L;
    public static long WEEK_IN_MILLIS = 604800000L;
    public static long YEAR_IN_MILLIS = 31449600000L;
    private static int DAY_IN_MS = 86400000;
    private static int EPOCH_JULIAN_DAY = 2440588;
    private static FormatterCache CACHED_FORMATTERS;

    private void $$robo$$libcore_icu_RelativeDateTimeFormatter$__constructor__() {
    }

    private static final String $$robo$$libcore_icu_RelativeDateTimeFormatter$getRelativeTimeSpanString(Locale locale, TimeZone tz, long time, long now, long minResolution, int flags) {
        DisplayContext displayContext = DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE;
        return RelativeDateTimeFormatter.getRelativeTimeSpanString(locale, tz, time, now, minResolution, flags, displayContext);
    }

    private static final String $$robo$$libcore_icu_RelativeDateTimeFormatter$getRelativeTimeSpanString(Locale locale, TimeZone tz, long time, long now, long minResolution, int flags, DisplayContext displayContext) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        if (tz == null) {
            throw new NullPointerException("tz == null");
        }
        ULocale icuLocale = ULocale.forLocale(locale);
        android.icu.util.TimeZone icuTimeZone = DateUtilsBridge.icuTimeZone(tz);
        return RelativeDateTimeFormatter.getRelativeTimeSpanString(icuLocale, icuTimeZone, time, now, minResolution, flags, displayContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$libcore_icu_RelativeDateTimeFormatter$getRelativeTimeSpanString(ULocale icuLocale, android.icu.util.TimeZone icuTimeZone, long time, long now, long minResolution, int flags, DisplayContext displayContext) {
        RelativeDateTimeFormatter.RelativeUnit unit;
        int count;
        long duration = Math.abs(now - time);
        boolean past = now >= time;
        RelativeDateTimeFormatter.Style style2 = (flags & 0xC0000) != 0 ? RelativeDateTimeFormatter.Style.SHORT : RelativeDateTimeFormatter.Style.LONG;
        RelativeDateTimeFormatter.Direction direction = past ? RelativeDateTimeFormatter.Direction.LAST : RelativeDateTimeFormatter.Direction.NEXT;
        boolean relative = true;
        RelativeDateTimeFormatter.AbsoluteUnit aunit = null;
        if (duration < 60000L && minResolution < 60000L) {
            count = (int)(duration / 1000L);
            unit = RelativeDateTimeFormatter.RelativeUnit.SECONDS;
        } else if (duration < 3600000L && minResolution < 3600000L) {
            count = (int)(duration / 60000L);
            unit = RelativeDateTimeFormatter.RelativeUnit.MINUTES;
        } else if (duration < 86400000L && minResolution < 86400000L) {
            count = (int)(duration / 3600000L);
            unit = RelativeDateTimeFormatter.RelativeUnit.HOURS;
        } else if (duration < 604800000L && minResolution < 604800000L) {
            count = Math.abs(RelativeDateTimeFormatter.dayDistance(icuTimeZone, time, now));
            unit = RelativeDateTimeFormatter.RelativeUnit.DAYS;
            if (count == 2) {
                String str;
                FormatterCache formatterCache;
                if (past) {
                    formatterCache = CACHED_FORMATTERS;
                    synchronized (formatterCache) {
                        str = RelativeDateTimeFormatter.getFormatter(icuLocale, style2, displayContext).format(RelativeDateTimeFormatter.Direction.LAST_2, RelativeDateTimeFormatter.AbsoluteUnit.DAY);
                    }
                }
                formatterCache = CACHED_FORMATTERS;
                synchronized (formatterCache) {
                    str = RelativeDateTimeFormatter.getFormatter(icuLocale, style2, displayContext).format(RelativeDateTimeFormatter.Direction.NEXT_2, RelativeDateTimeFormatter.AbsoluteUnit.DAY);
                }
                if (str != null && !str.isEmpty()) {
                    return str;
                }
            } else if (count == 1) {
                aunit = RelativeDateTimeFormatter.AbsoluteUnit.DAY;
                relative = false;
            } else if (count == 0) {
                aunit = RelativeDateTimeFormatter.AbsoluteUnit.DAY;
                direction = RelativeDateTimeFormatter.Direction.THIS;
                relative = false;
            }
        } else if (minResolution == 604800000L) {
            count = (int)(duration / 604800000L);
            unit = RelativeDateTimeFormatter.RelativeUnit.WEEKS;
        } else {
            Calendar timeCalendar = DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, time);
            if ((flags & 0xC) == 0) {
                Calendar nowCalendar = DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, now);
                flags = timeCalendar.get(1) != nowCalendar.get(1) ? (flags |= 4) : (flags |= 8);
            }
            return DateTimeFormat.format(icuLocale, timeCalendar, flags, displayContext);
        }
        FormatterCache formatterCache = CACHED_FORMATTERS;
        synchronized (formatterCache) {
            android.icu.text.RelativeDateTimeFormatter formatter = RelativeDateTimeFormatter.getFormatter(icuLocale, style2, displayContext);
            if (relative) {
                return formatter.format(count, direction, unit);
            }
            return formatter.format(direction, aunit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$libcore_icu_RelativeDateTimeFormatter$getRelativeDateTimeString(Locale locale, TimeZone tz, long time, long now, long minResolution, long transitionResolution, int flags) {
        String dateClause;
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        if (tz == null) {
            throw new NullPointerException("tz == null");
        }
        ULocale icuLocale = ULocale.forLocale(locale);
        android.icu.util.TimeZone icuTimeZone = DateUtilsBridge.icuTimeZone(tz);
        long duration = Math.abs(now - time);
        if (transitionResolution > 604800000L) {
            transitionResolution = 604800000L;
        }
        RelativeDateTimeFormatter.Style style2 = (flags & 0xC0000) != 0 ? RelativeDateTimeFormatter.Style.SHORT : RelativeDateTimeFormatter.Style.LONG;
        Calendar timeCalendar = DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, time);
        Calendar nowCalendar = DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, now);
        int days = Math.abs(DateUtilsBridge.dayDistance(timeCalendar, nowCalendar));
        if (duration < transitionResolution) {
            if (days > 0 && minResolution < 86400000L) {
                minResolution = 86400000L;
            }
            dateClause = RelativeDateTimeFormatter.getRelativeTimeSpanString(icuLocale, icuTimeZone, time, now, minResolution, flags, DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE);
        } else {
            flags = timeCalendar.get(1) != nowCalendar.get(1) ? 131092 : 65560;
            dateClause = DateTimeFormat.format(icuLocale, timeCalendar, flags, DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE);
        }
        String timeClause = DateTimeFormat.format(icuLocale, timeCalendar, 1, DisplayContext.CAPITALIZATION_NONE);
        DisplayContext capitalizationContext = DisplayContext.CAPITALIZATION_NONE;
        FormatterCache formatterCache = CACHED_FORMATTERS;
        synchronized (formatterCache) {
            return RelativeDateTimeFormatter.getFormatter(icuLocale, style2, capitalizationContext).combineDateAndTime(dateClause, timeClause);
        }
    }

    private static final android.icu.text.RelativeDateTimeFormatter $$robo$$libcore_icu_RelativeDateTimeFormatter$getFormatter(ULocale locale, RelativeDateTimeFormatter.Style style2, DisplayContext displayContext) {
        String key = locale + "\t" + (Object)((Object)style2) + "\t" + (Object)((Object)displayContext);
        android.icu.text.RelativeDateTimeFormatter formatter = (android.icu.text.RelativeDateTimeFormatter)CACHED_FORMATTERS.get(key);
        if (formatter == null) {
            formatter = android.icu.text.RelativeDateTimeFormatter.getInstance(locale, null, style2, displayContext);
            CACHED_FORMATTERS.put(key, formatter);
        }
        return formatter;
    }

    private static final int $$robo$$libcore_icu_RelativeDateTimeFormatter$dayDistance(android.icu.util.TimeZone icuTimeZone, long startTime, long endTime) {
        return RelativeDateTimeFormatter.julianDay(icuTimeZone, endTime) - RelativeDateTimeFormatter.julianDay(icuTimeZone, startTime);
    }

    private static final int $$robo$$libcore_icu_RelativeDateTimeFormatter$julianDay(android.icu.util.TimeZone icuTimeZone, long time) {
        long utcMs = time + (long)icuTimeZone.getOffset(time);
        return (int)(utcMs / 86400000L) + 2440588;
    }

    static void __staticInitializer__() {
        CACHED_FORMATTERS = new FormatterCache();
    }

    private void __constructor__() {
        this.$$robo$$libcore_icu_RelativeDateTimeFormatter$__constructor__();
    }

    private RelativeDateTimeFormatter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_RelativeDateTimeFormatter$__constructor__(), 0, this);
    }

    public static String getRelativeTimeSpanString(Locale locale, TimeZone timeZone, long l, long l2, long l3, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getRelativeTimeSpanString", $$robo$$libcore_icu_RelativeDateTimeFormatter$getRelativeTimeSpanString(java.util.Locale java.util.TimeZone long long long int ), 0, (Locale)locale, (TimeZone)timeZone, (long)l, (long)l2, (long)l3, (int)n);
    }

    public static String getRelativeTimeSpanString(Locale locale, TimeZone timeZone, long l, long l2, long l3, int n, DisplayContext displayContext) {
        return InvokeDynamicSupport.bootstrapStatic("getRelativeTimeSpanString", $$robo$$libcore_icu_RelativeDateTimeFormatter$getRelativeTimeSpanString(java.util.Locale java.util.TimeZone long long long int android.icu.text.DisplayContext ), 0, (Locale)locale, (TimeZone)timeZone, (long)l, (long)l2, (long)l3, (int)n, (DisplayContext)displayContext);
    }

    private static String getRelativeTimeSpanString(ULocale uLocale, android.icu.util.TimeZone timeZone, long l, long l2, long l3, int n, DisplayContext displayContext) {
        return InvokeDynamicSupport.bootstrapStatic("getRelativeTimeSpanString", $$robo$$libcore_icu_RelativeDateTimeFormatter$getRelativeTimeSpanString(android.icu.util.ULocale android.icu.util.TimeZone long long long int android.icu.text.DisplayContext ), 0, (ULocale)uLocale, (android.icu.util.TimeZone)timeZone, (long)l, (long)l2, (long)l3, (int)n, (DisplayContext)displayContext);
    }

    public static String getRelativeDateTimeString(Locale locale, TimeZone timeZone, long l, long l2, long l3, long l4, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getRelativeDateTimeString", $$robo$$libcore_icu_RelativeDateTimeFormatter$getRelativeDateTimeString(java.util.Locale java.util.TimeZone long long long long int ), 0, (Locale)locale, (TimeZone)timeZone, (long)l, (long)l2, (long)l3, (long)l4, (int)n);
    }

    private static android.icu.text.RelativeDateTimeFormatter getFormatter(ULocale uLocale, RelativeDateTimeFormatter.Style style2, DisplayContext displayContext) {
        return InvokeDynamicSupport.bootstrapStatic("getFormatter", $$robo$$libcore_icu_RelativeDateTimeFormatter$getFormatter(android.icu.util.ULocale android.icu.text.RelativeDateTimeFormatter$Style android.icu.text.DisplayContext ), 0, (ULocale)uLocale, (RelativeDateTimeFormatter.Style)style2, (DisplayContext)displayContext);
    }

    private static int dayDistance(android.icu.util.TimeZone timeZone, long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("dayDistance", $$robo$$libcore_icu_RelativeDateTimeFormatter$dayDistance(android.icu.util.TimeZone long long ), 0, (android.icu.util.TimeZone)timeZone, (long)l, (long)l2);
    }

    private static int julianDay(android.icu.util.TimeZone timeZone, long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("julianDay", $$robo$$libcore_icu_RelativeDateTimeFormatter$julianDay(android.icu.util.TimeZone long ), 0, (android.icu.util.TimeZone)timeZone, (long)l);
    }

    static {
        RobolectricInternals.classInitializing(RelativeDateTimeFormatter.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelativeDateTimeFormatter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FormatterCache
    extends BasicLruCache<String, android.icu.text.RelativeDateTimeFormatter> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$libcore_icu_RelativeDateTimeFormatter_FormatterCache$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$libcore_icu_RelativeDateTimeFormatter_FormatterCache$__constructor__();
        }

        FormatterCache() {
            super(8);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_RelativeDateTimeFormatter_FormatterCache$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FormatterCache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

