/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.update;

import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.IOException;
import libcore.tzdata.update.ConfigBundle;
import libcore.tzdata.update.FileUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class TzDataBundleInstaller
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String CURRENT_TZ_DATA_DIR_NAME = "current";
    static String WORKING_DIR_NAME = "working";
    static String OLD_TZ_DATA_DIR_NAME = "old";
    private String logTag;
    private File installDir;

    private void $$robo$$libcore_tzdata_update_TzDataBundleInstaller$__constructor__(String logTag, File installDir) {
        this.logTag = logTag;
        this.installDir = installDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$libcore_tzdata_update_TzDataBundleInstaller$install(byte[] content) throws IOException {
        File oldTzDataDir = new File(this.installDir, "old");
        if (oldTzDataDir.exists()) {
            FileUtils.deleteRecursive(oldTzDataDir);
        }
        File currentTzDataDir = new File(this.installDir, "current");
        File workingDir = new File(this.installDir, "working");
        Slog.i(this.logTag, "Applying time zone update");
        File unpackedContentDir = this.unpackBundle(content, workingDir);
        try {
            if (!this.checkBundleFilesExist(unpackedContentDir)) {
                Slog.i(this.logTag, "Update not applied: Bundle is missing files");
                boolean bl = false;
                return bl;
            }
            if (this.verifySystemChecksums(unpackedContentDir)) {
                FileUtils.makeDirectoryWorldAccessible(unpackedContentDir);
                if (currentTzDataDir.exists()) {
                    Slog.i(this.logTag, "Moving " + currentTzDataDir + " to " + oldTzDataDir);
                    FileUtils.rename(currentTzDataDir, oldTzDataDir);
                }
                Slog.i(this.logTag, "Moving " + unpackedContentDir + " to " + currentTzDataDir);
                FileUtils.rename(unpackedContentDir, currentTzDataDir);
                Slog.i(this.logTag, "Update applied: " + currentTzDataDir + " successfully created");
                boolean bl = true;
                return bl;
            }
            Slog.i(this.logTag, "Update not applied: System checksum did not match");
            boolean bl = false;
            return bl;
        }
        finally {
            this.deleteBestEffort(oldTzDataDir);
            this.deleteBestEffort(unpackedContentDir);
        }
    }

    private final void $$robo$$libcore_tzdata_update_TzDataBundleInstaller$deleteBestEffort(File dir) {
        if (dir.exists()) {
            try {
                FileUtils.deleteRecursive(dir);
            }
            catch (IOException e) {
                Slog.w(this.logTag, "Unable to delete " + dir, e);
            }
        }
    }

    private final File $$robo$$libcore_tzdata_update_TzDataBundleInstaller$unpackBundle(byte[] content, File targetDir) throws IOException {
        Slog.i(this.logTag, "Unpacking update content to: " + targetDir);
        ConfigBundle bundle = new ConfigBundle(content);
        bundle.extractTo(targetDir);
        return targetDir;
    }

    private final boolean $$robo$$libcore_tzdata_update_TzDataBundleInstaller$checkBundleFilesExist(File unpackedContentDir) throws IOException {
        Slog.i(this.logTag, "Verifying bundle contents");
        return FileUtils.filesExist(unpackedContentDir, "tzdata_version", "checksums", "tzdata", "icu/icu_tzdata.dat");
    }

    private final boolean $$robo$$libcore_tzdata_update_TzDataBundleInstaller$verifySystemChecksums(File unpackedContentDir) throws IOException {
        Slog.i(this.logTag, "Verifying system file checksums");
        File checksumsFile = new File(unpackedContentDir, "checksums");
        for (String line : FileUtils.readLines(checksumsFile)) {
            long expectedChecksum;
            int delimiterPos = line.indexOf(44);
            if (delimiterPos <= 0 || delimiterPos == line.length() - 1) {
                throw new IOException("Bad checksum entry: " + line);
            }
            try {
                expectedChecksum = Long.parseLong(line.substring(0, delimiterPos));
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid checksum value: " + line);
            }
            String filePath = line.substring(delimiterPos + 1);
            File file = new File(filePath);
            if (!file.exists()) {
                Slog.i(this.logTag, "Failed checksum test for file: " + file + ": file not found");
                return false;
            }
            long actualChecksum = FileUtils.calculateChecksum(file);
            if (actualChecksum == expectedChecksum) continue;
            Slog.i(this.logTag, "Failed checksum test for file: " + file + ": required=" + expectedChecksum + ", actual=" + actualChecksum);
            return false;
        }
        return true;
    }

    private void __constructor__(String string2, File file) {
        this.$$robo$$libcore_tzdata_update_TzDataBundleInstaller$__constructor__(string2, file);
    }

    public TzDataBundleInstaller(String string2, File file) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_tzdata_update_TzDataBundleInstaller$__constructor__(java.lang.String java.io.File ), 0, this, string2, file);
    }

    public boolean install(byte[] byArray) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("install", $$robo$$libcore_tzdata_update_TzDataBundleInstaller$install(byte[] ), 0, this, byArray);
    }

    private void deleteBestEffort(File file) {
        InvokeDynamicSupport.bootstrap("deleteBestEffort", $$robo$$libcore_tzdata_update_TzDataBundleInstaller$deleteBestEffort(java.io.File ), 0, this, file);
    }

    private File unpackBundle(byte[] byArray, File file) throws IOException {
        return InvokeDynamicSupport.bootstrap("unpackBundle", $$robo$$libcore_tzdata_update_TzDataBundleInstaller$unpackBundle(byte[] java.io.File ), 0, this, byArray, file);
    }

    private boolean checkBundleFilesExist(File file) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("checkBundleFilesExist", $$robo$$libcore_tzdata_update_TzDataBundleInstaller$checkBundleFilesExist(java.io.File ), 0, this, file);
    }

    private boolean verifySystemChecksums(File file) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("verifySystemChecksums", $$robo$$libcore_tzdata_update_TzDataBundleInstaller$verifySystemChecksums(java.io.File ), 0, this, file);
    }

    public /* synthetic */ TzDataBundleInstaller() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TzDataBundleInstaller)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

