/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.TypedValue;
import android.util.Xml;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class AccessibilityServiceInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG_ACCESSIBILITY_SERVICE = "accessibility-service";
    public static int CAPABILITY_CAN_RETRIEVE_WINDOW_CONTENT = 1;
    public static int CAPABILITY_CAN_REQUEST_TOUCH_EXPLORATION = 2;
    public static int CAPABILITY_CAN_REQUEST_ENHANCED_WEB_ACCESSIBILITY = 4;
    public static int CAPABILITY_CAN_REQUEST_FILTER_KEY_EVENTS = 8;
    public static int CAPABILITY_CAN_CONTROL_MAGNIFICATION = 16;
    public static int CAPABILITY_CAN_PERFORM_GESTURES = 32;
    public static int CAPABILITY_CAN_REQUEST_FINGERPRINT_GESTURES = 64;
    private static SparseArray<CapabilityInfo> sAvailableCapabilityInfos;
    public static int FEEDBACK_SPOKEN = 1;
    public static int FEEDBACK_HAPTIC = 2;
    public static int FEEDBACK_AUDIBLE = 4;
    public static int FEEDBACK_VISUAL = 8;
    public static int FEEDBACK_GENERIC = 16;
    public static int FEEDBACK_BRAILLE = 32;
    public static int FEEDBACK_ALL_MASK = -1;
    public static int DEFAULT = 1;
    public static int FLAG_INCLUDE_NOT_IMPORTANT_VIEWS = 2;
    public static int FLAG_REQUEST_TOUCH_EXPLORATION_MODE = 4;
    public static int FLAG_REQUEST_ENHANCED_WEB_ACCESSIBILITY = 8;
    public static int FLAG_REPORT_VIEW_IDS = 16;
    public static int FLAG_REQUEST_FILTER_KEY_EVENTS = 32;
    public static int FLAG_RETRIEVE_INTERACTIVE_WINDOWS = 64;
    public static int FLAG_ENABLE_ACCESSIBILITY_VOLUME = 128;
    public static int FLAG_REQUEST_ACCESSIBILITY_BUTTON = 256;
    public static int FLAG_REQUEST_FINGERPRINT_GESTURES = 512;
    public static int FLAG_FORCE_DIRECT_BOOT_AWARE = 65536;
    public int eventTypes;
    public String[] packageNames;
    public int feedbackType;
    public long notificationTimeout;
    public int flags;
    private ComponentName mComponentName;
    private ResolveInfo mResolveInfo;
    private String mSettingsActivityName;
    private int mCapabilities;
    private int mSummaryResId;
    private String mNonLocalizedSummary;
    private int mDescriptionResId;
    private String mNonLocalizedDescription;
    public static Parcelable.Creator<AccessibilityServiceInfo> CREATOR;

    private void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$__constructor__() {
    }

    private void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$__constructor__(ResolveInfo resolveInfo, Context context) throws XmlPullParserException, IOException {
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        this.mComponentName = new ComponentName(serviceInfo.packageName, serviceInfo.name);
        this.mResolveInfo = resolveInfo;
        try (XmlResourceParser parser = null;){
            TypedValue peekedValue;
            PackageManager packageManager = context.getPackageManager();
            parser = serviceInfo.loadXmlMetaData(packageManager, "android.accessibilityservice");
            if (parser == null) {
                return;
            }
            int type = 0;
            while (type != 1 && type != 2) {
                type = parser.next();
            }
            String nodeName = parser.getName();
            if (!"accessibility-service".equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start withaccessibility-service tag");
            }
            AttributeSet allAttributes = Xml.asAttributeSet(parser);
            Resources resources = packageManager.getResourcesForApplication(serviceInfo.applicationInfo);
            TypedArray asAttributes = resources.obtainAttributes(allAttributes, R.styleable.AccessibilityService);
            this.eventTypes = asAttributes.getInt(3, 0);
            String packageNamez = asAttributes.getString(4);
            if (packageNamez != null) {
                this.packageNames = packageNamez.split("(\\s)*,(\\s)*");
            }
            this.feedbackType = asAttributes.getInt(5, 0);
            this.notificationTimeout = asAttributes.getInt(6, 0);
            this.flags = asAttributes.getInt(7, 0);
            this.mSettingsActivityName = asAttributes.getString(2);
            if (asAttributes.getBoolean(8, false)) {
                this.mCapabilities |= 1;
            }
            if (asAttributes.getBoolean(9, false)) {
                this.mCapabilities |= 2;
            }
            if (asAttributes.getBoolean(11, false)) {
                this.mCapabilities |= 8;
            }
            if (asAttributes.getBoolean(12, false)) {
                this.mCapabilities |= 0x10;
            }
            if (asAttributes.getBoolean(13, false)) {
                this.mCapabilities |= 0x20;
            }
            if (asAttributes.getBoolean(14, false)) {
                this.mCapabilities |= 0x40;
            }
            if ((peekedValue = asAttributes.peekValue(0)) != null) {
                this.mDescriptionResId = peekedValue.resourceId;
                CharSequence nonLocalizedDescription = peekedValue.coerceToString();
                if (nonLocalizedDescription != null) {
                    this.mNonLocalizedDescription = nonLocalizedDescription.toString().trim();
                }
            }
            if ((peekedValue = asAttributes.peekValue(1)) != null) {
                this.mSummaryResId = peekedValue.resourceId;
                CharSequence nonLocalizedSummary = peekedValue.coerceToString();
                if (nonLocalizedSummary != null) {
                    this.mNonLocalizedSummary = nonLocalizedSummary.toString().trim();
                }
            }
            asAttributes.recycle();
        }
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$updateDynamicallyConfigurableProperties(AccessibilityServiceInfo other) {
        this.eventTypes = other.eventTypes;
        this.packageNames = other.packageNames;
        this.feedbackType = other.feedbackType;
        this.notificationTimeout = other.notificationTimeout;
        this.flags = other.flags;
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$setComponentName(ComponentName component) {
        this.mComponentName = component;
    }

    private final ComponentName $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getComponentName() {
        return this.mComponentName;
    }

    private final String $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getId() {
        return this.mComponentName.flattenToShortString();
    }

    private final ResolveInfo $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getResolveInfo() {
        return this.mResolveInfo;
    }

    private final String $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getSettingsActivityName() {
        return this.mSettingsActivityName;
    }

    private final boolean $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getCanRetrieveWindowContent() {
        return (this.mCapabilities & 1) != 0;
    }

    private final int $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getCapabilities() {
        return this.mCapabilities;
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$setCapabilities(int capabilities) {
        this.mCapabilities = capabilities;
    }

    private final CharSequence $$robo$$android_accessibilityservice_AccessibilityServiceInfo$loadSummary(PackageManager packageManager) {
        if (this.mSummaryResId == 0) {
            return this.mNonLocalizedSummary;
        }
        ServiceInfo serviceInfo = this.mResolveInfo.serviceInfo;
        CharSequence summary = packageManager.getText(serviceInfo.packageName, this.mSummaryResId, serviceInfo.applicationInfo);
        if (summary != null) {
            return summary.toString().trim();
        }
        return null;
    }

    private final String $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getDescription() {
        return this.mNonLocalizedDescription;
    }

    private final String $$robo$$android_accessibilityservice_AccessibilityServiceInfo$loadDescription(PackageManager packageManager) {
        if (this.mDescriptionResId == 0) {
            return this.mNonLocalizedDescription;
        }
        ServiceInfo serviceInfo = this.mResolveInfo.serviceInfo;
        CharSequence description = packageManager.getText(serviceInfo.packageName, this.mDescriptionResId, serviceInfo.applicationInfo);
        if (description != null) {
            return description.toString().trim();
        }
        return null;
    }

    private final boolean $$robo$$android_accessibilityservice_AccessibilityServiceInfo$isDirectBootAware() {
        return (this.flags & 0x10000) != 0 || this.mResolveInfo.serviceInfo.directBootAware;
    }

    private final int $$robo$$android_accessibilityservice_AccessibilityServiceInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$writeToParcel(Parcel parcel, int flagz) {
        parcel.writeInt(this.eventTypes);
        parcel.writeStringArray(this.packageNames);
        parcel.writeInt(this.feedbackType);
        parcel.writeLong(this.notificationTimeout);
        parcel.writeInt(this.flags);
        parcel.writeParcelable(this.mComponentName, flagz);
        parcel.writeParcelable(this.mResolveInfo, 0);
        parcel.writeString(this.mSettingsActivityName);
        parcel.writeInt(this.mCapabilities);
        parcel.writeInt(this.mSummaryResId);
        parcel.writeString(this.mNonLocalizedSummary);
        parcel.writeInt(this.mDescriptionResId);
        parcel.writeString(this.mNonLocalizedDescription);
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$initFromParcel(Parcel parcel) {
        this.eventTypes = parcel.readInt();
        this.packageNames = parcel.readStringArray();
        this.feedbackType = parcel.readInt();
        this.notificationTimeout = parcel.readLong();
        this.flags = parcel.readInt();
        this.mComponentName = (ComponentName)parcel.readParcelable(this.getClass().getClassLoader());
        this.mResolveInfo = (ResolveInfo)parcel.readParcelable(null);
        this.mSettingsActivityName = parcel.readString();
        this.mCapabilities = parcel.readInt();
        this.mSummaryResId = parcel.readInt();
        this.mNonLocalizedSummary = parcel.readString();
        this.mDescriptionResId = parcel.readInt();
        this.mNonLocalizedDescription = parcel.readString();
    }

    private final int $$robo$$android_accessibilityservice_AccessibilityServiceInfo$hashCode() {
        return 31 + (this.mComponentName == null ? 0 : this.mComponentName.hashCode());
    }

    private final boolean $$robo$$android_accessibilityservice_AccessibilityServiceInfo$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessibilityServiceInfo other = (AccessibilityServiceInfo)obj;
        return !(this.mComponentName == null ? other.mComponentName != null : !this.mComponentName.equals(other.mComponentName));
    }

    private final String $$robo$$android_accessibilityservice_AccessibilityServiceInfo$toString() {
        StringBuilder stringBuilder = new StringBuilder();
        AccessibilityServiceInfo.appendEventTypes(stringBuilder, this.eventTypes);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendPackageNames(stringBuilder, this.packageNames);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendFeedbackTypes(stringBuilder, this.feedbackType);
        stringBuilder.append(", ");
        stringBuilder.append("notificationTimeout: ").append(this.notificationTimeout);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendFlags(stringBuilder, this.flags);
        stringBuilder.append(", ");
        stringBuilder.append("id: ").append(this.getId());
        stringBuilder.append(", ");
        stringBuilder.append("resolveInfo: ").append(this.mResolveInfo);
        stringBuilder.append(", ");
        stringBuilder.append("settingsActivityName: ").append(this.mSettingsActivityName);
        stringBuilder.append(", ");
        stringBuilder.append("summary: ").append(this.mNonLocalizedSummary);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendCapabilities(stringBuilder, this.mCapabilities);
        return stringBuilder.toString();
    }

    private static final void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$appendFeedbackTypes(StringBuilder stringBuilder, int feedbackTypes) {
        stringBuilder.append("feedbackTypes:");
        stringBuilder.append("[");
        while (feedbackTypes != 0) {
            int feedbackTypeBit = 1 << Integer.numberOfTrailingZeros(feedbackTypes);
            stringBuilder.append(AccessibilityServiceInfo.feedbackTypeToString(feedbackTypeBit));
            if ((feedbackTypes &= ~feedbackTypeBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static final void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$appendPackageNames(StringBuilder stringBuilder, String[] packageNames) {
        stringBuilder.append("packageNames:");
        stringBuilder.append("[");
        if (packageNames != null) {
            int packageNameCount = packageNames.length;
            for (int i = 0; i < packageNameCount; ++i) {
                stringBuilder.append(packageNames[i]);
                if (i >= packageNameCount - 1) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append("]");
    }

    private static final void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$appendEventTypes(StringBuilder stringBuilder, int eventTypes) {
        stringBuilder.append("eventTypes:");
        stringBuilder.append("[");
        while (eventTypes != 0) {
            int eventTypeBit = 1 << Integer.numberOfTrailingZeros(eventTypes);
            stringBuilder.append(AccessibilityEvent.eventTypeToString(eventTypeBit));
            if ((eventTypes &= ~eventTypeBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static final void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$appendFlags(StringBuilder stringBuilder, int flags) {
        stringBuilder.append("flags:");
        stringBuilder.append("[");
        while (flags != 0) {
            int flagBit = 1 << Integer.numberOfTrailingZeros(flags);
            stringBuilder.append(AccessibilityServiceInfo.flagToString(flagBit));
            if ((flags &= ~flagBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static final void $$robo$$android_accessibilityservice_AccessibilityServiceInfo$appendCapabilities(StringBuilder stringBuilder, int capabilities) {
        stringBuilder.append("capabilities:");
        stringBuilder.append("[");
        while (capabilities != 0) {
            int capabilityBit = 1 << Integer.numberOfTrailingZeros(capabilities);
            stringBuilder.append(AccessibilityServiceInfo.capabilityToString(capabilityBit));
            if ((capabilities &= ~capabilityBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static final String $$robo$$android_accessibilityservice_AccessibilityServiceInfo$feedbackTypeToString(int feedbackType) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        while (feedbackType != 0) {
            int feedbackTypeFlag = 1 << Integer.numberOfTrailingZeros(feedbackType);
            feedbackType &= ~feedbackTypeFlag;
            switch (feedbackTypeFlag) {
                case 4: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_AUDIBLE");
                    break;
                }
                case 2: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_HAPTIC");
                    break;
                }
                case 16: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_GENERIC");
                    break;
                }
                case 1: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_SPOKEN");
                    break;
                }
                case 8: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_VISUAL");
                    break;
                }
                case 32: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_BRAILLE");
                }
            }
        }
        builder.append("]");
        return builder.toString();
    }

    private static final String $$robo$$android_accessibilityservice_AccessibilityServiceInfo$flagToString(int flag) {
        switch (flag) {
            case 1: {
                return "DEFAULT";
            }
            case 2: {
                return "FLAG_INCLUDE_NOT_IMPORTANT_VIEWS";
            }
            case 4: {
                return "FLAG_REQUEST_TOUCH_EXPLORATION_MODE";
            }
            case 8: {
                return "FLAG_REQUEST_ENHANCED_WEB_ACCESSIBILITY";
            }
            case 16: {
                return "FLAG_REPORT_VIEW_IDS";
            }
            case 32: {
                return "FLAG_REQUEST_FILTER_KEY_EVENTS";
            }
            case 64: {
                return "FLAG_RETRIEVE_INTERACTIVE_WINDOWS";
            }
            case 128: {
                return "FLAG_ENABLE_ACCESSIBILITY_VOLUME";
            }
            case 256: {
                return "FLAG_REQUEST_ACCESSIBILITY_BUTTON";
            }
            case 512: {
                return "FLAG_REQUEST_FINGERPRINT_GESTURES";
            }
        }
        return null;
    }

    private static final String $$robo$$android_accessibilityservice_AccessibilityServiceInfo$capabilityToString(int capability) {
        switch (capability) {
            case 1: {
                return "CAPABILITY_CAN_RETRIEVE_WINDOW_CONTENT";
            }
            case 2: {
                return "CAPABILITY_CAN_REQUEST_TOUCH_EXPLORATION";
            }
            case 4: {
                return "CAPABILITY_CAN_REQUEST_ENHANCED_WEB_ACCESSIBILITY";
            }
            case 8: {
                return "CAPABILITY_CAN_REQUEST_FILTER_KEY_EVENTS";
            }
            case 16: {
                return "CAPABILITY_CAN_CONTROL_MAGNIFICATION";
            }
            case 32: {
                return "CAPABILITY_CAN_PERFORM_GESTURES";
            }
            case 64: {
                return "CAPABILITY_CAN_REQUEST_FINGERPRINT_GESTURES";
            }
        }
        return "UNKNOWN";
    }

    private final List<CapabilityInfo> $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getCapabilityInfos() {
        return this.getCapabilityInfos(null);
    }

    private final List<CapabilityInfo> $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getCapabilityInfos(Context context) {
        int capabilityBit;
        if (this.mCapabilities == 0) {
            return Collections.emptyList();
        }
        ArrayList<CapabilityInfo> capabilityInfos = new ArrayList<CapabilityInfo>();
        SparseArray<CapabilityInfo> capabilityInfoSparseArray = AccessibilityServiceInfo.getCapabilityInfoSparseArray(context);
        for (int capabilities = this.mCapabilities; capabilities != 0; capabilities &= ~capabilityBit) {
            capabilityBit = 1 << Integer.numberOfTrailingZeros(capabilities);
            CapabilityInfo capabilityInfo = capabilityInfoSparseArray.get(capabilityBit);
            if (capabilityInfo == null) continue;
            capabilityInfos.add(capabilityInfo);
        }
        return capabilityInfos;
    }

    private static final SparseArray<CapabilityInfo> $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getCapabilityInfoSparseArray(Context context) {
        if (sAvailableCapabilityInfos == null) {
            sAvailableCapabilityInfos = new SparseArray();
            sAvailableCapabilityInfos.put(1, new CapabilityInfo(1, 17039592, 17039586));
            sAvailableCapabilityInfos.put(2, new CapabilityInfo(2, 17039591, 17039585));
            sAvailableCapabilityInfos.put(8, new CapabilityInfo(8, 17039590, 17039584));
            sAvailableCapabilityInfos.put(16, new CapabilityInfo(16, 17039588, 17039582));
            sAvailableCapabilityInfos.put(32, new CapabilityInfo(32, 17039589, 17039583));
            if (context == null || AccessibilityServiceInfo.fingerprintAvailable(context)) {
                sAvailableCapabilityInfos.put(64, new CapabilityInfo(64, 17039587, 17039581));
            }
        }
        return sAvailableCapabilityInfos;
    }

    private static final boolean $$robo$$android_accessibilityservice_AccessibilityServiceInfo$fingerprintAvailable(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.fingerprint") && context.getSystemService(FingerprintManager.class).isHardwareDetected();
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<AccessibilityServiceInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_accessibilityservice_AccessibilityServiceInfo_1$__constructor__() {
            }

            private final AccessibilityServiceInfo $$robo$$android_accessibilityservice_AccessibilityServiceInfo_1$createFromParcel(Parcel parcel) {
                AccessibilityServiceInfo info = new AccessibilityServiceInfo();
                info.initFromParcel(parcel);
                return info;
            }

            private final AccessibilityServiceInfo[] $$robo$$android_accessibilityservice_AccessibilityServiceInfo_1$newArray(int size) {
                return new AccessibilityServiceInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_accessibilityservice_AccessibilityServiceInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityServiceInfo_1$__constructor__(), this);
            }

            @Override
            public AccessibilityServiceInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_accessibilityservice_AccessibilityServiceInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public AccessibilityServiceInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_accessibilityservice_AccessibilityServiceInfo_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_accessibilityservice_AccessibilityServiceInfo$__constructor__();
    }

    public AccessibilityServiceInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$__constructor__(), this);
    }

    private void __constructor__(ResolveInfo resolveInfo, Context context) throws XmlPullParserException, IOException {
        this.$$robo$$android_accessibilityservice_AccessibilityServiceInfo$__constructor__(resolveInfo, context);
    }

    public AccessibilityServiceInfo(ResolveInfo resolveInfo, Context context) throws XmlPullParserException, IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$__constructor__(android.content.pm.ResolveInfo android.content.Context ), this, resolveInfo, context);
    }

    public void updateDynamicallyConfigurableProperties(AccessibilityServiceInfo accessibilityServiceInfo) {
        InvokeDynamicSupport.bootstrap("updateDynamicallyConfigurableProperties", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$updateDynamicallyConfigurableProperties(android.accessibilityservice.AccessibilityServiceInfo ), this, accessibilityServiceInfo);
    }

    public void setComponentName(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("setComponentName", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$setComponentName(android.content.ComponentName ), this, componentName);
    }

    public ComponentName getComponentName() {
        return InvokeDynamicSupport.bootstrap("getComponentName", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getComponentName(), this);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getId(), this);
    }

    public ResolveInfo getResolveInfo() {
        return InvokeDynamicSupport.bootstrap("getResolveInfo", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getResolveInfo(), this);
    }

    public String getSettingsActivityName() {
        return InvokeDynamicSupport.bootstrap("getSettingsActivityName", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getSettingsActivityName(), this);
    }

    public boolean getCanRetrieveWindowContent() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCanRetrieveWindowContent", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getCanRetrieveWindowContent(), this);
    }

    public int getCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getCapabilities", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getCapabilities(), this);
    }

    public void setCapabilities(int n) {
        InvokeDynamicSupport.bootstrap("setCapabilities", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$setCapabilities(int ), this, n);
    }

    public CharSequence loadSummary(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadSummary", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$loadSummary(android.content.pm.PackageManager ), this, packageManager);
    }

    public String getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getDescription(), this);
    }

    public String loadDescription(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadDescription", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$loadDescription(android.content.pm.PackageManager ), this, packageManager);
    }

    public boolean isDirectBootAware() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDirectBootAware", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$isDirectBootAware(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void initFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("initFromParcel", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$initFromParcel(android.os.Parcel ), this, parcel);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$equals(java.lang.Object ), this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$toString(), this);
    }

    private static void appendFeedbackTypes(StringBuilder stringBuilder, int n) {
        InvokeDynamicSupport.bootstrapStatic("appendFeedbackTypes", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$appendFeedbackTypes(java.lang.StringBuilder int ), (StringBuilder)stringBuilder, (int)n);
    }

    private static void appendPackageNames(StringBuilder stringBuilder, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("appendPackageNames", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$appendPackageNames(java.lang.StringBuilder java.lang.String[] ), (StringBuilder)stringBuilder, (String[])stringArray);
    }

    private static void appendEventTypes(StringBuilder stringBuilder, int n) {
        InvokeDynamicSupport.bootstrapStatic("appendEventTypes", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$appendEventTypes(java.lang.StringBuilder int ), (StringBuilder)stringBuilder, (int)n);
    }

    private static void appendFlags(StringBuilder stringBuilder, int n) {
        InvokeDynamicSupport.bootstrapStatic("appendFlags", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$appendFlags(java.lang.StringBuilder int ), (StringBuilder)stringBuilder, (int)n);
    }

    private static void appendCapabilities(StringBuilder stringBuilder, int n) {
        InvokeDynamicSupport.bootstrapStatic("appendCapabilities", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$appendCapabilities(java.lang.StringBuilder int ), (StringBuilder)stringBuilder, (int)n);
    }

    public static String feedbackTypeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("feedbackTypeToString", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$feedbackTypeToString(int ), (int)n);
    }

    public static String flagToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("flagToString", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$flagToString(int ), (int)n);
    }

    public static String capabilityToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("capabilityToString", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$capabilityToString(int ), (int)n);
    }

    public List<CapabilityInfo> getCapabilityInfos() {
        return InvokeDynamicSupport.bootstrap("getCapabilityInfos", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getCapabilityInfos(), this);
    }

    public List<CapabilityInfo> getCapabilityInfos(Context context) {
        return InvokeDynamicSupport.bootstrap("getCapabilityInfos", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getCapabilityInfos(android.content.Context ), this, context);
    }

    private static SparseArray<CapabilityInfo> getCapabilityInfoSparseArray(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getCapabilityInfoSparseArray", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$getCapabilityInfoSparseArray(android.content.Context ), (Context)context);
    }

    private static boolean fingerprintAvailable(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fingerprintAvailable", $$robo$$android_accessibilityservice_AccessibilityServiceInfo$fingerprintAvailable(android.content.Context ), (Context)context);
    }

    static {
        RobolectricInternals.classInitializing(AccessibilityServiceInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityServiceInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CapabilityInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int capability;
        public int titleResId;
        public int descResId;

        private void $$robo$$android_accessibilityservice_AccessibilityServiceInfo_CapabilityInfo$__constructor__(int capability, int titleResId, int descResId) {
            this.capability = capability;
            this.titleResId = titleResId;
            this.descResId = descResId;
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_accessibilityservice_AccessibilityServiceInfo_CapabilityInfo$__constructor__(n, n2, n3);
        }

        public CapabilityInfo(int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityServiceInfo_CapabilityInfo$__constructor__(int int int ), this, n, n2, n3);
        }

        public /* synthetic */ CapabilityInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CapabilityInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

