/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerResponse;
import android.accounts.AuthenticatorDescription;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ChooseAccountActivity
extends Activity
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "AccountManager";
    private Parcelable[] mAccounts;
    private AccountManagerResponse mAccountManagerResponse;
    private Bundle mResult;
    private HashMap<String, AuthenticatorDescription> mTypeToAuthDescription;

    private void $$robo$$android_accounts_ChooseAccountActivity$__constructor__() {
        this.mAccounts = null;
        this.mAccountManagerResponse = null;
        this.mTypeToAuthDescription = new HashMap();
    }

    private final void $$robo$$android_accounts_ChooseAccountActivity$onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAccounts = this.getIntent().getParcelableArrayExtra("accounts");
        this.mAccountManagerResponse = (AccountManagerResponse)this.getIntent().getParcelableExtra("accountManagerResponse");
        if (this.mAccounts == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        this.getAuthDescriptions();
        AccountInfo[] mAccountInfos = new AccountInfo[this.mAccounts.length];
        for (int i = 0; i < this.mAccounts.length; ++i) {
            mAccountInfos[i] = new AccountInfo(((Account)this.mAccounts[i]).name, this.getDrawableForType(((Account)this.mAccounts[i]).type));
        }
        this.setContentView(17367107);
        ListView list = (ListView)this.findViewById(16908298);
        list.setAdapter(new AccountArrayAdapter((Context)this, 17367043, mAccountInfos));
        list.setChoiceMode(1);
        list.setTextFilterEnabled(true);
        list.setOnItemClickListener(new AdapterView.OnItemClickListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ChooseAccountActivity this$0;

            private void $$robo$$android_accounts_ChooseAccountActivity_1$__constructor__(ChooseAccountActivity this$0) {
            }

            private final void $$robo$$android_accounts_ChooseAccountActivity_1$onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                this.this$0.onListItemClick((ListView)parent, v, position, id2);
            }

            private void __constructor__(ChooseAccountActivity chooseAccountActivity) {
                this.$$robo$$android_accounts_ChooseAccountActivity_1$__constructor__(chooseAccountActivity);
            }
            {
                this.this$0 = chooseAccountActivity;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseAccountActivity_1$__constructor__(android.accounts.ChooseAccountActivity ), this, chooseAccountActivity);
            }

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$android_accounts_ChooseAccountActivity_1$onItemClick(android.widget.AdapterView<?> android.view.View int long ), this, adapterView, view, n, l);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_accounts_ChooseAccountActivity$getAuthDescriptions() {
        for (AuthenticatorDescription desc : AccountManager.get(this).getAuthenticatorTypes()) {
            this.mTypeToAuthDescription.put(desc.type, desc);
        }
    }

    private final Drawable $$robo$$android_accounts_ChooseAccountActivity$getDrawableForType(String accountType) {
        Drawable icon;
        block5: {
            icon = null;
            if (this.mTypeToAuthDescription.containsKey(accountType)) {
                try {
                    AuthenticatorDescription desc = this.mTypeToAuthDescription.get(accountType);
                    Context authContext = this.createPackageContext(desc.packageName, 0);
                    icon = authContext.getDrawable(desc.iconId);
                }
                catch (PackageManager.NameNotFoundException e) {
                    if (Log.isLoggable("AccountManager", 5)) {
                        Log.w("AccountManager", "No icon name for account type " + accountType);
                    }
                }
                catch (Resources.NotFoundException e) {
                    if (!Log.isLoggable("AccountManager", 5)) break block5;
                    Log.w("AccountManager", "No icon resource for account type " + accountType);
                }
            }
        }
        return icon;
    }

    private final void $$robo$$android_accounts_ChooseAccountActivity$onListItemClick(ListView l, View v, int position, long id2) {
        Account account = (Account)this.mAccounts[position];
        Log.d("AccountManager", "selected account " + account);
        Bundle bundle = new Bundle();
        bundle.putString("authAccount", account.name);
        bundle.putString("accountType", account.type);
        this.mResult = bundle;
        this.finish();
    }

    private final void $$robo$$android_accounts_ChooseAccountActivity$finish() {
        if (this.mAccountManagerResponse != null) {
            if (this.mResult != null) {
                this.mAccountManagerResponse.onResult(this.mResult);
            } else {
                this.mAccountManagerResponse.onError(4, "canceled");
            }
        }
        super.finish();
    }

    private void __constructor__() {
        this.$$robo$$android_accounts_ChooseAccountActivity$__constructor__();
    }

    public ChooseAccountActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseAccountActivity$__constructor__(), this);
    }

    @Override
    public void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_accounts_ChooseAccountActivity$onCreate(android.os.Bundle ), this, bundle);
    }

    private void getAuthDescriptions() {
        InvokeDynamicSupport.bootstrap("getAuthDescriptions", $$robo$$android_accounts_ChooseAccountActivity$getAuthDescriptions(), this);
    }

    private Drawable getDrawableForType(String string2) {
        return InvokeDynamicSupport.bootstrap("getDrawableForType", $$robo$$android_accounts_ChooseAccountActivity$getDrawableForType(java.lang.String ), this, string2);
    }

    protected void onListItemClick(ListView listView, View view, int n, long l) {
        InvokeDynamicSupport.bootstrap("onListItemClick", $$robo$$android_accounts_ChooseAccountActivity$onListItemClick(android.widget.ListView android.view.View int long ), this, listView, view, n, l);
    }

    @Override
    public void finish() {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$android_accounts_ChooseAccountActivity$finish(), this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChooseAccountActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class AccountArrayAdapter
    extends ArrayAdapter<AccountInfo> {
        public /* synthetic */ Object __robo_data__;
        private LayoutInflater mLayoutInflater;
        private AccountInfo[] mInfos;

        private void $$robo$$android_accounts_ChooseAccountActivity_AccountArrayAdapter$__constructor__(Context context, int textViewResourceId, AccountInfo[] infos) {
            this.mInfos = infos;
            this.mLayoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        private final View $$robo$$android_accounts_ChooseAccountActivity_AccountArrayAdapter$getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = this.mLayoutInflater.inflate(17367108, null);
                holder = new ViewHolder(null);
                holder.text = (TextView)convertView.findViewById(16908655);
                holder.icon = (ImageView)convertView.findViewById(16908654);
                convertView.setTag(holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.text.setText(this.mInfos[position].name);
            holder.icon.setImageDrawable(this.mInfos[position].drawable);
            return convertView;
        }

        private void __constructor__(Context context, int n, AccountInfo[] accountInfoArray) {
            this.$$robo$$android_accounts_ChooseAccountActivity_AccountArrayAdapter$__constructor__(context, n, accountInfoArray);
        }

        public AccountArrayAdapter(Context context, int n, AccountInfo[] accountInfoArray) {
            super(context, n, accountInfoArray);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseAccountActivity_AccountArrayAdapter$__constructor__(android.content.Context int android.accounts.ChooseAccountActivity$AccountInfo[] ), this, context, n, accountInfoArray);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_accounts_ChooseAccountActivity_AccountArrayAdapter$getView(int android.view.View android.view.ViewGroup ), this, n, view, viewGroup);
        }

        public /* synthetic */ AccountArrayAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccountArrayAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ViewHolder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        ImageView icon;
        TextView text;

        private void $$robo$$android_accounts_ChooseAccountActivity_ViewHolder$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_accounts_ChooseAccountActivity_ViewHolder$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_accounts_ChooseAccountActivity_ViewHolder$__constructor__();
        }

        public ViewHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseAccountActivity_ViewHolder$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_accounts_ChooseAccountActivity_ViewHolder$__constructor__(var1_1);
        }

        public /* synthetic */ ViewHolder(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseAccountActivity_ViewHolder$__constructor__(android.accounts.ChooseAccountActivity$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AccountInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        String name;
        Drawable drawable;

        private void $$robo$$android_accounts_ChooseAccountActivity_AccountInfo$__constructor__(String name, Drawable drawable2) {
            this.name = name;
            this.drawable = drawable2;
        }

        private void __constructor__(String string2, Drawable drawable2) {
            this.$$robo$$android_accounts_ChooseAccountActivity_AccountInfo$__constructor__(string2, drawable2);
        }

        public AccountInfo(String string2, Drawable drawable2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseAccountActivity_AccountInfo$__constructor__(java.lang.String android.graphics.drawable.Drawable ), this, string2, drawable2);
        }

        public /* synthetic */ AccountInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccountInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

