/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.view.Choreographer;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AnimationHandler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private ArrayMap<AnimationFrameCallback, Long> mDelayedCallbackStartTime;
    private ArrayList<AnimationFrameCallback> mAnimationCallbacks;
    private ArrayList<AnimationFrameCallback> mCommitCallbacks;
    private AnimationFrameCallbackProvider mProvider;
    private Choreographer.FrameCallback mFrameCallback;
    public static ThreadLocal<AnimationHandler> sAnimatorHandler;
    private boolean mListDirty;

    private void $$robo$$android_animation_AnimationHandler$__constructor__() {
        this.mDelayedCallbackStartTime = new ArrayMap();
        this.mAnimationCallbacks = new ArrayList();
        this.mCommitCallbacks = new ArrayList();
        this.mFrameCallback = new Choreographer.FrameCallback(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AnimationHandler this$0;

            private void $$robo$$android_animation_AnimationHandler_1$__constructor__(AnimationHandler this$0) {
            }

            private final void $$robo$$android_animation_AnimationHandler_1$doFrame(long frameTimeNanos) {
                this.this$0.doAnimationFrame(this.this$0.getProvider().getFrameTime());
                if (this.this$0.mAnimationCallbacks.size() > 0) {
                    this.this$0.getProvider().postFrameCallback(this);
                }
            }

            private void __constructor__(AnimationHandler animationHandler) {
                this.$$robo$$android_animation_AnimationHandler_1$__constructor__(animationHandler);
            }
            {
                this.this$0 = animationHandler;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimationHandler_1$__constructor__(android.animation.AnimationHandler ), this, animationHandler);
            }

            @Override
            public void doFrame(long l) {
                InvokeDynamicSupport.bootstrap("doFrame", $$robo$$android_animation_AnimationHandler_1$doFrame(long ), this, l);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mListDirty = false;
    }

    private static final AnimationHandler $$robo$$android_animation_AnimationHandler$getInstance() {
        if (sAnimatorHandler.get() == null) {
            sAnimatorHandler.set(new AnimationHandler());
        }
        return sAnimatorHandler.get();
    }

    private final void $$robo$$android_animation_AnimationHandler$setProvider(AnimationFrameCallbackProvider provider) {
        this.mProvider = provider == null ? new MyFrameCallbackProvider(this, null) : provider;
    }

    private final AnimationFrameCallbackProvider $$robo$$android_animation_AnimationHandler$getProvider() {
        if (this.mProvider == null) {
            this.mProvider = new MyFrameCallbackProvider(this, null);
        }
        return this.mProvider;
    }

    private final void $$robo$$android_animation_AnimationHandler$addAnimationFrameCallback(AnimationFrameCallback callback, long delay) {
        if (this.mAnimationCallbacks.size() == 0) {
            this.getProvider().postFrameCallback(this.mFrameCallback);
        }
        if (!this.mAnimationCallbacks.contains(callback)) {
            this.mAnimationCallbacks.add(callback);
        }
        if (delay > 0L) {
            this.mDelayedCallbackStartTime.put(callback, SystemClock.uptimeMillis() + delay);
        }
    }

    private final void $$robo$$android_animation_AnimationHandler$addOneShotCommitCallback(AnimationFrameCallback callback) {
        if (!this.mCommitCallbacks.contains(callback)) {
            this.mCommitCallbacks.add(callback);
        }
    }

    private final void $$robo$$android_animation_AnimationHandler$removeCallback(AnimationFrameCallback callback) {
        this.mCommitCallbacks.remove(callback);
        this.mDelayedCallbackStartTime.remove(callback);
        int id2 = this.mAnimationCallbacks.indexOf(callback);
        if (id2 >= 0) {
            this.mAnimationCallbacks.set(id2, null);
            this.mListDirty = true;
        }
    }

    private final void $$robo$$android_animation_AnimationHandler$doAnimationFrame(long frameTime) {
        long currentTime = SystemClock.uptimeMillis();
        int size = this.mAnimationCallbacks.size();
        for (int i = 0; i < size; ++i) {
            AnimationFrameCallback callback = this.mAnimationCallbacks.get(i);
            if (callback == null || !this.isCallbackDue(callback, currentTime)) continue;
            callback.doAnimationFrame(frameTime);
            if (!this.mCommitCallbacks.contains(callback)) continue;
            this.getProvider().postCommitCallback(new Runnable(this, callback){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ AnimationFrameCallback val$callback;
                /* synthetic */ AnimationHandler this$0;

                private void $$robo$$android_animation_AnimationHandler_2$__constructor__(AnimationHandler this$0, AnimationFrameCallback animationFrameCallback) {
                    this.val$callback = animationFrameCallback;
                }

                private final void $$robo$$android_animation_AnimationHandler_2$run() {
                    this.this$0.commitAnimationFrame(this.val$callback, this.this$0.getProvider().getFrameTime());
                }

                private void __constructor__(AnimationHandler animationHandler, AnimationFrameCallback animationFrameCallback) {
                    this.$$robo$$android_animation_AnimationHandler_2$__constructor__(animationHandler, animationFrameCallback);
                }
                {
                    this.this$0 = animationHandler;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimationHandler_2$__constructor__(android.animation.AnimationHandler android.animation.AnimationHandler$AnimationFrameCallback ), this, animationHandler, animationFrameCallback);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_animation_AnimationHandler_2$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        this.cleanUpList();
    }

    private final void $$robo$$android_animation_AnimationHandler$commitAnimationFrame(AnimationFrameCallback callback, long frameTime) {
        if (!this.mDelayedCallbackStartTime.containsKey(callback) && this.mCommitCallbacks.contains(callback)) {
            callback.commitAnimationFrame(frameTime);
            this.mCommitCallbacks.remove(callback);
        }
    }

    private final boolean $$robo$$android_animation_AnimationHandler$isCallbackDue(AnimationFrameCallback callback, long currentTime) {
        Long startTime = this.mDelayedCallbackStartTime.get(callback);
        if (startTime == null) {
            return true;
        }
        if (startTime < currentTime) {
            this.mDelayedCallbackStartTime.remove(callback);
            return true;
        }
        return false;
    }

    private static final int $$robo$$android_animation_AnimationHandler$getAnimationCount() {
        AnimationHandler handler = sAnimatorHandler.get();
        if (handler == null) {
            return 0;
        }
        return handler.getCallbackSize();
    }

    private static final void $$robo$$android_animation_AnimationHandler$setFrameDelay(long delay) {
        AnimationHandler.getInstance().getProvider().setFrameDelay(delay);
    }

    private static final long $$robo$$android_animation_AnimationHandler$getFrameDelay() {
        return AnimationHandler.getInstance().getProvider().getFrameDelay();
    }

    private final void $$robo$$android_animation_AnimationHandler$autoCancelBasedOn(ObjectAnimator objectAnimator) {
        for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
            AnimationFrameCallback cb = this.mAnimationCallbacks.get(i);
            if (cb == null || !objectAnimator.shouldAutoCancel(cb)) continue;
            ((Animator)((Object)this.mAnimationCallbacks.get(i))).cancel();
        }
    }

    private final void $$robo$$android_animation_AnimationHandler$cleanUpList() {
        if (this.mListDirty) {
            for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
                if (this.mAnimationCallbacks.get(i) != null) continue;
                this.mAnimationCallbacks.remove(i);
            }
            this.mListDirty = false;
        }
    }

    private final int $$robo$$android_animation_AnimationHandler$getCallbackSize() {
        int count = 0;
        int size = this.mAnimationCallbacks.size();
        for (int i = size - 1; i >= 0; --i) {
            if (this.mAnimationCallbacks.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    static void __staticInitializer__() {
        sAnimatorHandler = new ThreadLocal();
    }

    private void __constructor__() {
        this.$$robo$$android_animation_AnimationHandler$__constructor__();
    }

    public AnimationHandler() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimationHandler$__constructor__(), this);
    }

    public static AnimationHandler getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_animation_AnimationHandler$getInstance());
    }

    public void setProvider(AnimationFrameCallbackProvider animationFrameCallbackProvider) {
        InvokeDynamicSupport.bootstrap("setProvider", $$robo$$android_animation_AnimationHandler$setProvider(android.animation.AnimationHandler$AnimationFrameCallbackProvider ), this, animationFrameCallbackProvider);
    }

    private AnimationFrameCallbackProvider getProvider() {
        return InvokeDynamicSupport.bootstrap("getProvider", $$robo$$android_animation_AnimationHandler$getProvider(), this);
    }

    public void addAnimationFrameCallback(AnimationFrameCallback animationFrameCallback, long l) {
        InvokeDynamicSupport.bootstrap("addAnimationFrameCallback", $$robo$$android_animation_AnimationHandler$addAnimationFrameCallback(android.animation.AnimationHandler$AnimationFrameCallback long ), this, animationFrameCallback, l);
    }

    public void addOneShotCommitCallback(AnimationFrameCallback animationFrameCallback) {
        InvokeDynamicSupport.bootstrap("addOneShotCommitCallback", $$robo$$android_animation_AnimationHandler$addOneShotCommitCallback(android.animation.AnimationHandler$AnimationFrameCallback ), this, animationFrameCallback);
    }

    public void removeCallback(AnimationFrameCallback animationFrameCallback) {
        InvokeDynamicSupport.bootstrap("removeCallback", $$robo$$android_animation_AnimationHandler$removeCallback(android.animation.AnimationHandler$AnimationFrameCallback ), this, animationFrameCallback);
    }

    private void doAnimationFrame(long l) {
        InvokeDynamicSupport.bootstrap("doAnimationFrame", $$robo$$android_animation_AnimationHandler$doAnimationFrame(long ), this, l);
    }

    private void commitAnimationFrame(AnimationFrameCallback animationFrameCallback, long l) {
        InvokeDynamicSupport.bootstrap("commitAnimationFrame", $$robo$$android_animation_AnimationHandler$commitAnimationFrame(android.animation.AnimationHandler$AnimationFrameCallback long ), this, animationFrameCallback, l);
    }

    private boolean isCallbackDue(AnimationFrameCallback animationFrameCallback, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCallbackDue", $$robo$$android_animation_AnimationHandler$isCallbackDue(android.animation.AnimationHandler$AnimationFrameCallback long ), this, animationFrameCallback, l);
    }

    public static int getAnimationCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAnimationCount", $$robo$$android_animation_AnimationHandler$getAnimationCount());
    }

    public static void setFrameDelay(long l) {
        InvokeDynamicSupport.bootstrapStatic("setFrameDelay", $$robo$$android_animation_AnimationHandler$setFrameDelay(long ), (long)l);
    }

    public static long getFrameDelay() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getFrameDelay", $$robo$$android_animation_AnimationHandler$getFrameDelay());
    }

    void autoCancelBasedOn(ObjectAnimator objectAnimator) {
        InvokeDynamicSupport.bootstrap("autoCancelBasedOn", $$robo$$android_animation_AnimationHandler$autoCancelBasedOn(android.animation.ObjectAnimator ), this, objectAnimator);
    }

    private void cleanUpList() {
        InvokeDynamicSupport.bootstrap("cleanUpList", $$robo$$android_animation_AnimationHandler$cleanUpList(), this);
    }

    private int getCallbackSize() {
        return (int)InvokeDynamicSupport.bootstrap("getCallbackSize", $$robo$$android_animation_AnimationHandler$getCallbackSize(), this);
    }

    static {
        RobolectricInternals.classInitializing(AnimationHandler.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationHandler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface AnimationFrameCallbackProvider
    extends InstrumentedInterface {
        public void postFrameCallback(Choreographer.FrameCallback var1);

        public void postCommitCallback(Runnable var1);

        public long getFrameTime();

        public long getFrameDelay();

        public void setFrameDelay(long var1);
    }

    static interface AnimationFrameCallback
    extends InstrumentedInterface {
        public boolean doAnimationFrame(long var1);

        public void commitAnimationFrame(long var1);
    }

    private class MyFrameCallbackProvider
    implements AnimationFrameCallbackProvider,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Choreographer mChoreographer;
        /* synthetic */ AnimationHandler this$0;

        private void $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$__constructor__(AnimationHandler animationHandler) {
            this.mChoreographer = Choreographer.getInstance();
        }

        private final void $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$postFrameCallback(Choreographer.FrameCallback callback) {
            this.mChoreographer.postFrameCallback(callback);
        }

        private final void $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$postCommitCallback(Runnable runnable) {
            this.mChoreographer.postCallback(3, runnable, null);
        }

        private final long $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$getFrameTime() {
            return this.mChoreographer.getFrameTime();
        }

        private final long $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$getFrameDelay() {
            return Choreographer.getFrameDelay();
        }

        private final void $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$setFrameDelay(long delay) {
            Choreographer.setFrameDelay(delay);
        }

        private /* synthetic */ void $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$__constructor__(AnimationHandler x0, 1 x1) {
        }

        private void __constructor__(AnimationHandler animationHandler) {
            this.$$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$__constructor__(animationHandler);
        }

        public MyFrameCallbackProvider(AnimationHandler animationHandler) {
            this.this$0 = animationHandler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$__constructor__(android.animation.AnimationHandler ), this, animationHandler);
        }

        @Override
        public void postFrameCallback(Choreographer.FrameCallback frameCallback) {
            InvokeDynamicSupport.bootstrap("postFrameCallback", $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$postFrameCallback(android.view.Choreographer$FrameCallback ), this, frameCallback);
        }

        @Override
        public void postCommitCallback(Runnable runnable) {
            InvokeDynamicSupport.bootstrap("postCommitCallback", $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$postCommitCallback(java.lang.Runnable ), this, runnable);
        }

        @Override
        public long getFrameTime() {
            return (long)InvokeDynamicSupport.bootstrap("getFrameTime", $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$getFrameTime(), this);
        }

        @Override
        public long getFrameDelay() {
            return (long)InvokeDynamicSupport.bootstrap("getFrameDelay", $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$getFrameDelay(), this);
        }

        @Override
        public void setFrameDelay(long l) {
            InvokeDynamicSupport.bootstrap("setFrameDelay", $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$setFrameDelay(long ), this, l);
        }

        private /* synthetic */ void __constructor__(AnimationHandler animationHandler, 1 var2_2) {
            this.$$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$__constructor__(animationHandler, var2_2);
        }

        public /* synthetic */ MyFrameCallbackProvider(AnimationHandler animationHandler, 1 var2_2) {
            this(animationHandler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_AnimationHandler_MyFrameCallbackProvider$__constructor__(android.animation.AnimationHandler android.animation.AnimationHandler$1 ), this, animationHandler, var2_2);
        }

        public /* synthetic */ MyFrameCallbackProvider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyFrameCallbackProvider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

