/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.DebugUtils;
import android.util.Log;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.app.IVoiceInteractorCallback;
import com.android.internal.app.IVoiceInteractorRequest;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class VoiceInteractor
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "VoiceInteractor";
    static boolean DEBUG = false;
    static Request[] NO_REQUESTS;
    IVoiceInteractor mInteractor;
    Context mContext;
    Activity mActivity;
    boolean mRetaining;
    HandlerCaller mHandlerCaller;
    HandlerCaller.Callback mHandlerCallerCallback;
    IVoiceInteractorCallback.Stub mCallback;
    ArrayMap<IBinder, Request> mActiveRequests;
    static int MSG_CONFIRMATION_RESULT = 1;
    static int MSG_PICK_OPTION_RESULT = 2;
    static int MSG_COMPLETE_VOICE_RESULT = 3;
    static int MSG_ABORT_VOICE_RESULT = 4;
    static int MSG_COMMAND_RESULT = 5;
    static int MSG_CANCEL_RESULT = 6;

    private void $$robo$$android_app_VoiceInteractor$__constructor__(IVoiceInteractor interactor, Context context, Activity activity, Looper looper) {
        this.mHandlerCallerCallback = new HandlerCaller.Callback(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ VoiceInteractor this$0;

            private void $$robo$$android_app_VoiceInteractor_1$__constructor__(VoiceInteractor this$0) {
            }

            private final void $$robo$$android_app_VoiceInteractor_1$executeMessage(Message msg) {
                SomeArgs args = (SomeArgs)msg.obj;
                switch (msg.what) {
                    case 1: {
                        Request request = this.this$0.pullRequest((IVoiceInteractorRequest)args.arg1, true);
                        if (request == null) break;
                        ((ConfirmationRequest)request).onConfirmationResult(msg.arg1 != 0, (Bundle)args.arg2);
                        request.clear();
                        break;
                    }
                    case 2: {
                        boolean complete = msg.arg1 != 0;
                        Request request = this.this$0.pullRequest((IVoiceInteractorRequest)args.arg1, complete);
                        if (request == null) break;
                        ((PickOptionRequest)request).onPickOptionResult(complete, (PickOptionRequest.Option[])args.arg2, (Bundle)args.arg3);
                        if (!complete) break;
                        request.clear();
                        break;
                    }
                    case 3: {
                        Request request = this.this$0.pullRequest((IVoiceInteractorRequest)args.arg1, true);
                        if (request == null) break;
                        ((CompleteVoiceRequest)request).onCompleteResult((Bundle)args.arg2);
                        request.clear();
                        break;
                    }
                    case 4: {
                        Request request = this.this$0.pullRequest((IVoiceInteractorRequest)args.arg1, true);
                        if (request == null) break;
                        ((AbortVoiceRequest)request).onAbortResult((Bundle)args.arg2);
                        request.clear();
                        break;
                    }
                    case 5: {
                        boolean complete = msg.arg1 != 0;
                        Request request = this.this$0.pullRequest((IVoiceInteractorRequest)args.arg1, complete);
                        if (request == null) break;
                        ((CommandRequest)request).onCommandResult(msg.arg1 != 0, (Bundle)args.arg2);
                        if (!complete) break;
                        request.clear();
                        break;
                    }
                    case 6: {
                        Request request = this.this$0.pullRequest((IVoiceInteractorRequest)args.arg1, true);
                        if (request == null) break;
                        request.onCancel();
                        request.clear();
                    }
                }
            }

            private void __constructor__(VoiceInteractor voiceInteractor) {
                this.$$robo$$android_app_VoiceInteractor_1$__constructor__(voiceInteractor);
            }
            {
                this.this$0 = voiceInteractor;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_1$__constructor__(android.app.VoiceInteractor ), this, voiceInteractor);
            }

            @Override
            public void executeMessage(Message message) {
                InvokeDynamicSupport.bootstrap("executeMessage", $$robo$$android_app_VoiceInteractor_1$executeMessage(android.os.Message ), this, message);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ VoiceInteractor this$0;

            private void $$robo$$android_app_VoiceInteractor_2$__constructor__(VoiceInteractor this$0) {
            }

            private final void $$robo$$android_app_VoiceInteractor_2$deliverConfirmationResult(IVoiceInteractorRequest request, boolean finished, Bundle result) {
                this.this$0.mHandlerCaller.sendMessage(this.this$0.mHandlerCaller.obtainMessageIOO(1, finished ? 1 : 0, request, result));
            }

            private final void $$robo$$android_app_VoiceInteractor_2$deliverPickOptionResult(IVoiceInteractorRequest request, boolean finished, PickOptionRequest.Option[] options, Bundle result) {
                this.this$0.mHandlerCaller.sendMessage(this.this$0.mHandlerCaller.obtainMessageIOOO(2, finished ? 1 : 0, request, options, result));
            }

            private final void $$robo$$android_app_VoiceInteractor_2$deliverCompleteVoiceResult(IVoiceInteractorRequest request, Bundle result) {
                this.this$0.mHandlerCaller.sendMessage(this.this$0.mHandlerCaller.obtainMessageOO(3, request, result));
            }

            private final void $$robo$$android_app_VoiceInteractor_2$deliverAbortVoiceResult(IVoiceInteractorRequest request, Bundle result) {
                this.this$0.mHandlerCaller.sendMessage(this.this$0.mHandlerCaller.obtainMessageOO(4, request, result));
            }

            private final void $$robo$$android_app_VoiceInteractor_2$deliverCommandResult(IVoiceInteractorRequest request, boolean complete, Bundle result) {
                this.this$0.mHandlerCaller.sendMessage(this.this$0.mHandlerCaller.obtainMessageIOO(5, complete ? 1 : 0, request, result));
            }

            private final void $$robo$$android_app_VoiceInteractor_2$deliverCancel(IVoiceInteractorRequest request) throws RemoteException {
                this.this$0.mHandlerCaller.sendMessage(this.this$0.mHandlerCaller.obtainMessageOO(6, request, null));
            }

            private void __constructor__(VoiceInteractor voiceInteractor) {
                this.$$robo$$android_app_VoiceInteractor_2$__constructor__(voiceInteractor);
            }
            {
                this.this$0 = voiceInteractor;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_2$__constructor__(android.app.VoiceInteractor ), this, voiceInteractor);
            }

            @Override
            public void deliverConfirmationResult(IVoiceInteractorRequest iVoiceInteractorRequest, boolean bl, Bundle bundle) {
                InvokeDynamicSupport.bootstrap("deliverConfirmationResult", $$robo$$android_app_VoiceInteractor_2$deliverConfirmationResult(com.android.internal.app.IVoiceInteractorRequest boolean android.os.Bundle ), this, iVoiceInteractorRequest, bl, bundle);
            }

            @Override
            public void deliverPickOptionResult(IVoiceInteractorRequest iVoiceInteractorRequest, boolean bl, PickOptionRequest.Option[] optionArray, Bundle bundle) {
                InvokeDynamicSupport.bootstrap("deliverPickOptionResult", $$robo$$android_app_VoiceInteractor_2$deliverPickOptionResult(com.android.internal.app.IVoiceInteractorRequest boolean android.app.VoiceInteractor$PickOptionRequest$Option[] android.os.Bundle ), this, iVoiceInteractorRequest, bl, optionArray, bundle);
            }

            @Override
            public void deliverCompleteVoiceResult(IVoiceInteractorRequest iVoiceInteractorRequest, Bundle bundle) {
                InvokeDynamicSupport.bootstrap("deliverCompleteVoiceResult", $$robo$$android_app_VoiceInteractor_2$deliverCompleteVoiceResult(com.android.internal.app.IVoiceInteractorRequest android.os.Bundle ), this, iVoiceInteractorRequest, bundle);
            }

            @Override
            public void deliverAbortVoiceResult(IVoiceInteractorRequest iVoiceInteractorRequest, Bundle bundle) {
                InvokeDynamicSupport.bootstrap("deliverAbortVoiceResult", $$robo$$android_app_VoiceInteractor_2$deliverAbortVoiceResult(com.android.internal.app.IVoiceInteractorRequest android.os.Bundle ), this, iVoiceInteractorRequest, bundle);
            }

            @Override
            public void deliverCommandResult(IVoiceInteractorRequest iVoiceInteractorRequest, boolean bl, Bundle bundle) {
                InvokeDynamicSupport.bootstrap("deliverCommandResult", $$robo$$android_app_VoiceInteractor_2$deliverCommandResult(com.android.internal.app.IVoiceInteractorRequest boolean android.os.Bundle ), this, iVoiceInteractorRequest, bl, bundle);
            }

            @Override
            public void deliverCancel(IVoiceInteractorRequest iVoiceInteractorRequest) throws RemoteException {
                InvokeDynamicSupport.bootstrap("deliverCancel", $$robo$$android_app_VoiceInteractor_2$deliverCancel(com.android.internal.app.IVoiceInteractorRequest ), this, iVoiceInteractorRequest);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mActiveRequests = new ArrayMap();
        this.mInteractor = interactor;
        this.mContext = context;
        this.mActivity = activity;
        this.mHandlerCaller = new HandlerCaller(context, looper, this.mHandlerCallerCallback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Request $$robo$$android_app_VoiceInteractor$pullRequest(IVoiceInteractorRequest request, boolean complete) {
        ArrayMap<IBinder, Request> arrayMap = this.mActiveRequests;
        synchronized (arrayMap) {
            Request req = this.mActiveRequests.get(request.asBinder());
            if (req != null && complete) {
                this.mActiveRequests.remove(request.asBinder());
            }
            return req;
        }
    }

    private final ArrayList<Request> $$robo$$android_app_VoiceInteractor$makeRequestList() {
        int N = this.mActiveRequests.size();
        if (N < 1) {
            return null;
        }
        ArrayList<Request> list = new ArrayList<Request>(N);
        for (int i = 0; i < N; ++i) {
            list.add(this.mActiveRequests.valueAt(i));
        }
        return list;
    }

    private final void $$robo$$android_app_VoiceInteractor$attachActivity(Activity activity) {
        this.mRetaining = false;
        if (this.mActivity == activity) {
            return;
        }
        this.mContext = activity;
        this.mActivity = activity;
        ArrayList<Request> reqs = this.makeRequestList();
        if (reqs != null) {
            for (int i = 0; i < reqs.size(); ++i) {
                Request req = reqs.get(i);
                req.mContext = activity;
                req.mActivity = activity;
                req.onAttached(activity);
            }
        }
    }

    private final void $$robo$$android_app_VoiceInteractor$retainInstance() {
        this.mRetaining = true;
    }

    private final void $$robo$$android_app_VoiceInteractor$detachActivity() {
        Request req;
        int i;
        ArrayList<Request> reqs = this.makeRequestList();
        if (reqs != null) {
            for (i = 0; i < reqs.size(); ++i) {
                req = reqs.get(i);
                req.onDetached();
                req.mActivity = null;
                req.mContext = null;
            }
        }
        if (!this.mRetaining) {
            reqs = this.makeRequestList();
            if (reqs != null) {
                for (i = 0; i < reqs.size(); ++i) {
                    req = reqs.get(i);
                    req.cancel();
                }
            }
            this.mActiveRequests.clear();
        }
        this.mContext = null;
        this.mActivity = null;
    }

    private final boolean $$robo$$android_app_VoiceInteractor$submitRequest(Request request) {
        return this.submitRequest(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_VoiceInteractor$submitRequest(Request request, String name) {
        try {
            IVoiceInteractorRequest ireq;
            if (request.mRequestInterface != null) {
                throw new IllegalStateException("Given " + request + " is already active");
            }
            request.mRequestInterface = ireq = request.submit(this.mInteractor, this.mContext.getOpPackageName(), this.mCallback);
            request.mContext = this.mContext;
            request.mActivity = this.mActivity;
            request.mName = name;
            ArrayMap<IBinder, Request> arrayMap = this.mActiveRequests;
            synchronized (arrayMap) {
                this.mActiveRequests.put(ireq.asBinder(), request);
            }
            return true;
        }
        catch (RemoteException e) {
            Log.w("VoiceInteractor", "Remove voice interactor service died", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Request[] $$robo$$android_app_VoiceInteractor$getActiveRequests() {
        ArrayMap<IBinder, Request> arrayMap = this.mActiveRequests;
        synchronized (arrayMap) {
            int N = this.mActiveRequests.size();
            if (N <= 0) {
                return NO_REQUESTS;
            }
            Request[] requests = new Request[N];
            for (int i = 0; i < N; ++i) {
                requests[i] = this.mActiveRequests.valueAt(i);
            }
            return requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Request $$robo$$android_app_VoiceInteractor$getActiveRequest(String name) {
        ArrayMap<IBinder, Request> arrayMap = this.mActiveRequests;
        synchronized (arrayMap) {
            int N = this.mActiveRequests.size();
            for (int i = 0; i < N; ++i) {
                Request req = this.mActiveRequests.valueAt(i);
                if (name != req.getName() && (name == null || !name.equals(req.getName()))) continue;
                return req;
            }
        }
        return null;
    }

    private final boolean[] $$robo$$android_app_VoiceInteractor$supportsCommands(String[] commands) {
        try {
            boolean[] res = this.mInteractor.supportsCommands(this.mContext.getOpPackageName(), commands);
            return res;
        }
        catch (RemoteException e) {
            throw new RuntimeException("Voice interactor has died", e);
        }
    }

    private final void $$robo$$android_app_VoiceInteractor$dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        String innerPrefix = prefix + "    ";
        if (this.mActiveRequests.size() > 0) {
            writer.print(prefix);
            writer.println("Active voice requests:");
            for (int i = 0; i < this.mActiveRequests.size(); ++i) {
                Request req = this.mActiveRequests.valueAt(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(req);
                req.dump(innerPrefix, fd, writer, args);
            }
        }
        writer.print(prefix);
        writer.println("VoiceInteractor misc state:");
        writer.print(prefix);
        writer.print("  mInteractor=");
        writer.println(this.mInteractor.asBinder());
        writer.print(prefix);
        writer.print("  mActivity=");
        writer.println(this.mActivity);
    }

    static void __staticInitializer__() {
        NO_REQUESTS = new Request[0];
    }

    private void __constructor__(IVoiceInteractor iVoiceInteractor, Context context, Activity activity, Looper looper) {
        this.$$robo$$android_app_VoiceInteractor$__constructor__(iVoiceInteractor, context, activity, looper);
    }

    public VoiceInteractor(IVoiceInteractor iVoiceInteractor, Context context, Activity activity, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor$__constructor__(com.android.internal.app.IVoiceInteractor android.content.Context android.app.Activity android.os.Looper ), this, iVoiceInteractor, context, activity, looper);
    }

    Request pullRequest(IVoiceInteractorRequest iVoiceInteractorRequest, boolean bl) {
        return InvokeDynamicSupport.bootstrap("pullRequest", $$robo$$android_app_VoiceInteractor$pullRequest(com.android.internal.app.IVoiceInteractorRequest boolean ), this, iVoiceInteractorRequest, bl);
    }

    private ArrayList<Request> makeRequestList() {
        return InvokeDynamicSupport.bootstrap("makeRequestList", $$robo$$android_app_VoiceInteractor$makeRequestList(), this);
    }

    void attachActivity(Activity activity) {
        InvokeDynamicSupport.bootstrap("attachActivity", $$robo$$android_app_VoiceInteractor$attachActivity(android.app.Activity ), this, activity);
    }

    void retainInstance() {
        InvokeDynamicSupport.bootstrap("retainInstance", $$robo$$android_app_VoiceInteractor$retainInstance(), this);
    }

    void detachActivity() {
        InvokeDynamicSupport.bootstrap("detachActivity", $$robo$$android_app_VoiceInteractor$detachActivity(), this);
    }

    public boolean submitRequest(Request request) {
        return (boolean)InvokeDynamicSupport.bootstrap("submitRequest", $$robo$$android_app_VoiceInteractor$submitRequest(android.app.VoiceInteractor$Request ), this, request);
    }

    public boolean submitRequest(Request request, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("submitRequest", $$robo$$android_app_VoiceInteractor$submitRequest(android.app.VoiceInteractor$Request java.lang.String ), this, request, string2);
    }

    public Request[] getActiveRequests() {
        return InvokeDynamicSupport.bootstrap("getActiveRequests", $$robo$$android_app_VoiceInteractor$getActiveRequests(), this);
    }

    public Request getActiveRequest(String string2) {
        return InvokeDynamicSupport.bootstrap("getActiveRequest", $$robo$$android_app_VoiceInteractor$getActiveRequest(java.lang.String ), this, string2);
    }

    public boolean[] supportsCommands(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("supportsCommands", $$robo$$android_app_VoiceInteractor$supportsCommands(java.lang.String[] ), this, stringArray);
    }

    void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_VoiceInteractor$dump(java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, string2, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(VoiceInteractor.class);
    }

    public /* synthetic */ VoiceInteractor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VoiceInteractor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Prompt
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private CharSequence[] mVoicePrompts;
        private CharSequence mVisualPrompt;
        public static Parcelable.Creator<Prompt> CREATOR;

        private void $$robo$$android_app_VoiceInteractor_Prompt$__constructor__(CharSequence[] voicePrompts, CharSequence visualPrompt) {
            if (voicePrompts == null) {
                throw new NullPointerException("voicePrompts must not be null");
            }
            if (voicePrompts.length == 0) {
                throw new IllegalArgumentException("voicePrompts must not be empty");
            }
            if (visualPrompt == null) {
                throw new NullPointerException("visualPrompt must not be null");
            }
            this.mVoicePrompts = voicePrompts;
            this.mVisualPrompt = visualPrompt;
        }

        private void $$robo$$android_app_VoiceInteractor_Prompt$__constructor__(CharSequence prompt) {
            this.mVoicePrompts = new CharSequence[]{prompt};
            this.mVisualPrompt = prompt;
        }

        private final CharSequence $$robo$$android_app_VoiceInteractor_Prompt$getVoicePromptAt(int index) {
            return this.mVoicePrompts[index];
        }

        private final int $$robo$$android_app_VoiceInteractor_Prompt$countVoicePrompts() {
            return this.mVoicePrompts.length;
        }

        private final CharSequence $$robo$$android_app_VoiceInteractor_Prompt$getVisualPrompt() {
            return this.mVisualPrompt;
        }

        private final String $$robo$$android_app_VoiceInteractor_Prompt$toString() {
            StringBuilder sb = new StringBuilder(128);
            DebugUtils.buildShortClassTag(this, sb);
            if (this.mVisualPrompt != null && this.mVoicePrompts != null && this.mVoicePrompts.length == 1 && this.mVisualPrompt.equals(this.mVoicePrompts[0])) {
                sb.append(" ");
                sb.append(this.mVisualPrompt);
            } else {
                if (this.mVisualPrompt != null) {
                    sb.append(" visual=");
                    sb.append(this.mVisualPrompt);
                }
                if (this.mVoicePrompts != null) {
                    sb.append(", voice=");
                    for (int i = 0; i < this.mVoicePrompts.length; ++i) {
                        if (i > 0) {
                            sb.append(" | ");
                        }
                        sb.append(this.mVoicePrompts[i]);
                    }
                }
            }
            sb.append('}');
            return sb.toString();
        }

        private void $$robo$$android_app_VoiceInteractor_Prompt$__constructor__(Parcel in) {
            this.mVoicePrompts = in.readCharSequenceArray();
            this.mVisualPrompt = in.readCharSequence();
        }

        private final int $$robo$$android_app_VoiceInteractor_Prompt$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_VoiceInteractor_Prompt$writeToParcel(Parcel dest, int flags) {
            dest.writeCharSequenceArray(this.mVoicePrompts);
            dest.writeCharSequence(this.mVisualPrompt);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Prompt>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_VoiceInteractor_Prompt_1$__constructor__() {
                }

                private final Prompt $$robo$$android_app_VoiceInteractor_Prompt_1$createFromParcel(Parcel in) {
                    return new Prompt(in);
                }

                private final Prompt[] $$robo$$android_app_VoiceInteractor_Prompt_1$newArray(int size) {
                    return new Prompt[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_VoiceInteractor_Prompt_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_Prompt_1$__constructor__(), this);
                }

                @Override
                public Prompt createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_VoiceInteractor_Prompt_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public Prompt[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_VoiceInteractor_Prompt_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(CharSequence[] charSequenceArray, CharSequence charSequence) {
            this.$$robo$$android_app_VoiceInteractor_Prompt$__constructor__(charSequenceArray, charSequence);
        }

        public Prompt(CharSequence[] charSequenceArray, CharSequence charSequence) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_Prompt$__constructor__(java.lang.CharSequence[] java.lang.CharSequence ), this, charSequenceArray, charSequence);
        }

        private void __constructor__(CharSequence charSequence) {
            this.$$robo$$android_app_VoiceInteractor_Prompt$__constructor__(charSequence);
        }

        public Prompt(CharSequence charSequence) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_Prompt$__constructor__(java.lang.CharSequence ), this, charSequence);
        }

        public CharSequence getVoicePromptAt(int n) {
            return InvokeDynamicSupport.bootstrap("getVoicePromptAt", $$robo$$android_app_VoiceInteractor_Prompt$getVoicePromptAt(int ), this, n);
        }

        public int countVoicePrompts() {
            return (int)InvokeDynamicSupport.bootstrap("countVoicePrompts", $$robo$$android_app_VoiceInteractor_Prompt$countVoicePrompts(), this);
        }

        public CharSequence getVisualPrompt() {
            return InvokeDynamicSupport.bootstrap("getVisualPrompt", $$robo$$android_app_VoiceInteractor_Prompt$getVisualPrompt(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_VoiceInteractor_Prompt$toString(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_VoiceInteractor_Prompt$__constructor__(parcel);
        }

        public Prompt(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_Prompt$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_VoiceInteractor_Prompt$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_VoiceInteractor_Prompt$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(Prompt.class);
        }

        public /* synthetic */ Prompt() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Prompt)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CommandRequest
    extends Request
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        String mCommand;
        Bundle mArgs;

        private void $$robo$$android_app_VoiceInteractor_CommandRequest$__constructor__(String command, Bundle args) {
            this.mCommand = command;
            this.mArgs = args;
        }

        private final void $$robo$$android_app_VoiceInteractor_CommandRequest$onCommandResult(boolean isCompleted, Bundle result) {
        }

        private final void $$robo$$android_app_VoiceInteractor_CommandRequest$dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mCommand=");
            writer.println(this.mCommand);
            if (this.mArgs != null) {
                writer.print(prefix);
                writer.print("mArgs=");
                writer.println(this.mArgs);
            }
        }

        private final String $$robo$$android_app_VoiceInteractor_CommandRequest$getRequestTypeName() {
            return "Command";
        }

        private final IVoiceInteractorRequest $$robo$$android_app_VoiceInteractor_CommandRequest$submit(IVoiceInteractor interactor, String packageName, IVoiceInteractorCallback callback) throws RemoteException {
            return interactor.startCommand(packageName, callback, this.mCommand, this.mArgs);
        }

        private void __constructor__(String string2, Bundle bundle) {
            this.$$robo$$android_app_VoiceInteractor_CommandRequest$__constructor__(string2, bundle);
        }

        public CommandRequest(String string2, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_CommandRequest$__constructor__(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        public void onCommandResult(boolean bl, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onCommandResult", $$robo$$android_app_VoiceInteractor_CommandRequest$onCommandResult(boolean android.os.Bundle ), this, bl, bundle);
        }

        @Override
        void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_VoiceInteractor_CommandRequest$dump(java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, string2, fileDescriptor, printWriter, stringArray);
        }

        @Override
        String getRequestTypeName() {
            return InvokeDynamicSupport.bootstrap("getRequestTypeName", $$robo$$android_app_VoiceInteractor_CommandRequest$getRequestTypeName(), this);
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor iVoiceInteractor, String string2, IVoiceInteractorCallback iVoiceInteractorCallback) throws RemoteException {
            return InvokeDynamicSupport.bootstrap("submit", $$robo$$android_app_VoiceInteractor_CommandRequest$submit(com.android.internal.app.IVoiceInteractor java.lang.String com.android.internal.app.IVoiceInteractorCallback ), this, iVoiceInteractor, string2, iVoiceInteractorCallback);
        }

        public /* synthetic */ CommandRequest() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CommandRequest)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AbortVoiceRequest
    extends Request
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Prompt mPrompt;
        Bundle mExtras;

        private void $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$__constructor__(Prompt prompt, Bundle extras) {
            this.mPrompt = prompt;
            this.mExtras = extras;
        }

        private void $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$__constructor__(CharSequence message, Bundle extras) {
            this.mPrompt = message != null ? new Prompt(message) : null;
            this.mExtras = extras;
        }

        private final void $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$onAbortResult(Bundle result) {
        }

        private final void $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
            if (this.mExtras != null) {
                writer.print(prefix);
                writer.print("mExtras=");
                writer.println(this.mExtras);
            }
        }

        private final String $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$getRequestTypeName() {
            return "AbortVoice";
        }

        private final IVoiceInteractorRequest $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$submit(IVoiceInteractor interactor, String packageName, IVoiceInteractorCallback callback) throws RemoteException {
            return interactor.startAbortVoice(packageName, callback, this.mPrompt, this.mExtras);
        }

        private void __constructor__(Prompt prompt, Bundle bundle) {
            this.$$robo$$android_app_VoiceInteractor_AbortVoiceRequest$__constructor__(prompt, bundle);
        }

        public AbortVoiceRequest(Prompt prompt, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$__constructor__(android.app.VoiceInteractor$Prompt android.os.Bundle ), this, prompt, bundle);
        }

        private void __constructor__(CharSequence charSequence, Bundle bundle) {
            this.$$robo$$android_app_VoiceInteractor_AbortVoiceRequest$__constructor__(charSequence, bundle);
        }

        public AbortVoiceRequest(CharSequence charSequence, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$__constructor__(java.lang.CharSequence android.os.Bundle ), this, charSequence, bundle);
        }

        public void onAbortResult(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onAbortResult", $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$onAbortResult(android.os.Bundle ), this, bundle);
        }

        @Override
        void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$dump(java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, string2, fileDescriptor, printWriter, stringArray);
        }

        @Override
        String getRequestTypeName() {
            return InvokeDynamicSupport.bootstrap("getRequestTypeName", $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$getRequestTypeName(), this);
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor iVoiceInteractor, String string2, IVoiceInteractorCallback iVoiceInteractorCallback) throws RemoteException {
            return InvokeDynamicSupport.bootstrap("submit", $$robo$$android_app_VoiceInteractor_AbortVoiceRequest$submit(com.android.internal.app.IVoiceInteractor java.lang.String com.android.internal.app.IVoiceInteractorCallback ), this, iVoiceInteractor, string2, iVoiceInteractorCallback);
        }

        public /* synthetic */ AbortVoiceRequest() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbortVoiceRequest)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CompleteVoiceRequest
    extends Request
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Prompt mPrompt;
        Bundle mExtras;

        private void $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$__constructor__(Prompt prompt, Bundle extras) {
            this.mPrompt = prompt;
            this.mExtras = extras;
        }

        private void $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$__constructor__(CharSequence message, Bundle extras) {
            this.mPrompt = message != null ? new Prompt(message) : null;
            this.mExtras = extras;
        }

        private final void $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$onCompleteResult(Bundle result) {
        }

        private final void $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
            if (this.mExtras != null) {
                writer.print(prefix);
                writer.print("mExtras=");
                writer.println(this.mExtras);
            }
        }

        private final String $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$getRequestTypeName() {
            return "CompleteVoice";
        }

        private final IVoiceInteractorRequest $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$submit(IVoiceInteractor interactor, String packageName, IVoiceInteractorCallback callback) throws RemoteException {
            return interactor.startCompleteVoice(packageName, callback, this.mPrompt, this.mExtras);
        }

        private void __constructor__(Prompt prompt, Bundle bundle) {
            this.$$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$__constructor__(prompt, bundle);
        }

        public CompleteVoiceRequest(Prompt prompt, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$__constructor__(android.app.VoiceInteractor$Prompt android.os.Bundle ), this, prompt, bundle);
        }

        private void __constructor__(CharSequence charSequence, Bundle bundle) {
            this.$$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$__constructor__(charSequence, bundle);
        }

        public CompleteVoiceRequest(CharSequence charSequence, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$__constructor__(java.lang.CharSequence android.os.Bundle ), this, charSequence, bundle);
        }

        public void onCompleteResult(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onCompleteResult", $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$onCompleteResult(android.os.Bundle ), this, bundle);
        }

        @Override
        void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$dump(java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, string2, fileDescriptor, printWriter, stringArray);
        }

        @Override
        String getRequestTypeName() {
            return InvokeDynamicSupport.bootstrap("getRequestTypeName", $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$getRequestTypeName(), this);
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor iVoiceInteractor, String string2, IVoiceInteractorCallback iVoiceInteractorCallback) throws RemoteException {
            return InvokeDynamicSupport.bootstrap("submit", $$robo$$android_app_VoiceInteractor_CompleteVoiceRequest$submit(com.android.internal.app.IVoiceInteractor java.lang.String com.android.internal.app.IVoiceInteractorCallback ), this, iVoiceInteractor, string2, iVoiceInteractorCallback);
        }

        public /* synthetic */ CompleteVoiceRequest() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompleteVoiceRequest)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PickOptionRequest
    extends Request
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Prompt mPrompt;
        Option[] mOptions;
        Bundle mExtras;

        private void $$robo$$android_app_VoiceInteractor_PickOptionRequest$__constructor__(Prompt prompt, Option[] options, Bundle extras) {
            this.mPrompt = prompt;
            this.mOptions = options;
            this.mExtras = extras;
        }

        private void $$robo$$android_app_VoiceInteractor_PickOptionRequest$__constructor__(CharSequence prompt, Option[] options, Bundle extras) {
            this.mPrompt = prompt != null ? new Prompt(prompt) : null;
            this.mOptions = options;
            this.mExtras = extras;
        }

        private final void $$robo$$android_app_VoiceInteractor_PickOptionRequest$onPickOptionResult(boolean finished, Option[] selections, Bundle result) {
        }

        private final void $$robo$$android_app_VoiceInteractor_PickOptionRequest$dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
            if (this.mOptions != null) {
                writer.print(prefix);
                writer.println("Options:");
                for (int i = 0; i < this.mOptions.length; ++i) {
                    Option op = this.mOptions[i];
                    writer.print(prefix);
                    writer.print("  #");
                    writer.print(i);
                    writer.println(":");
                    writer.print(prefix);
                    writer.print("    mLabel=");
                    writer.println(op.mLabel);
                    writer.print(prefix);
                    writer.print("    mIndex=");
                    writer.println(op.mIndex);
                    if (op.mSynonyms != null && op.mSynonyms.size() > 0) {
                        writer.print(prefix);
                        writer.println("    Synonyms:");
                        for (int j = 0; j < op.mSynonyms.size(); ++j) {
                            writer.print(prefix);
                            writer.print("      #");
                            writer.print(j);
                            writer.print(": ");
                            writer.println(op.mSynonyms.get(j));
                        }
                    }
                    if (op.mExtras == null) continue;
                    writer.print(prefix);
                    writer.print("    mExtras=");
                    writer.println(op.mExtras);
                }
            }
            if (this.mExtras != null) {
                writer.print(prefix);
                writer.print("mExtras=");
                writer.println(this.mExtras);
            }
        }

        private final String $$robo$$android_app_VoiceInteractor_PickOptionRequest$getRequestTypeName() {
            return "PickOption";
        }

        private final IVoiceInteractorRequest $$robo$$android_app_VoiceInteractor_PickOptionRequest$submit(IVoiceInteractor interactor, String packageName, IVoiceInteractorCallback callback) throws RemoteException {
            return interactor.startPickOption(packageName, callback, this.mPrompt, this.mOptions, this.mExtras);
        }

        private void __constructor__(Prompt prompt, Option[] optionArray, Bundle bundle) {
            this.$$robo$$android_app_VoiceInteractor_PickOptionRequest$__constructor__(prompt, optionArray, bundle);
        }

        public PickOptionRequest(Prompt prompt, Option[] optionArray, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_PickOptionRequest$__constructor__(android.app.VoiceInteractor$Prompt android.app.VoiceInteractor$PickOptionRequest$Option[] android.os.Bundle ), this, prompt, optionArray, bundle);
        }

        private void __constructor__(CharSequence charSequence, Option[] optionArray, Bundle bundle) {
            this.$$robo$$android_app_VoiceInteractor_PickOptionRequest$__constructor__(charSequence, optionArray, bundle);
        }

        public PickOptionRequest(CharSequence charSequence, Option[] optionArray, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_PickOptionRequest$__constructor__(java.lang.CharSequence android.app.VoiceInteractor$PickOptionRequest$Option[] android.os.Bundle ), this, charSequence, optionArray, bundle);
        }

        public void onPickOptionResult(boolean bl, Option[] optionArray, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPickOptionResult", $$robo$$android_app_VoiceInteractor_PickOptionRequest$onPickOptionResult(boolean android.app.VoiceInteractor$PickOptionRequest$Option[] android.os.Bundle ), this, bl, optionArray, bundle);
        }

        @Override
        void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_VoiceInteractor_PickOptionRequest$dump(java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, string2, fileDescriptor, printWriter, stringArray);
        }

        @Override
        String getRequestTypeName() {
            return InvokeDynamicSupport.bootstrap("getRequestTypeName", $$robo$$android_app_VoiceInteractor_PickOptionRequest$getRequestTypeName(), this);
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor iVoiceInteractor, String string2, IVoiceInteractorCallback iVoiceInteractorCallback) throws RemoteException {
            return InvokeDynamicSupport.bootstrap("submit", $$robo$$android_app_VoiceInteractor_PickOptionRequest$submit(com.android.internal.app.IVoiceInteractor java.lang.String com.android.internal.app.IVoiceInteractorCallback ), this, iVoiceInteractor, string2, iVoiceInteractorCallback);
        }

        public /* synthetic */ PickOptionRequest() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PickOptionRequest)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Option
        implements Parcelable,
        ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            CharSequence mLabel;
            int mIndex;
            ArrayList<CharSequence> mSynonyms;
            Bundle mExtras;
            public static Parcelable.Creator<Option> CREATOR;

            private void $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$__constructor__(CharSequence label) {
                this.mLabel = label;
                this.mIndex = -1;
            }

            private void $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$__constructor__(CharSequence label, int index) {
                this.mLabel = label;
                this.mIndex = index;
            }

            private final Option $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$addSynonym(CharSequence synonym) {
                if (this.mSynonyms == null) {
                    this.mSynonyms = new ArrayList();
                }
                this.mSynonyms.add(synonym);
                return this;
            }

            private final CharSequence $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$getLabel() {
                return this.mLabel;
            }

            private final int $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$getIndex() {
                return this.mIndex;
            }

            private final int $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$countSynonyms() {
                return this.mSynonyms != null ? this.mSynonyms.size() : 0;
            }

            private final CharSequence $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$getSynonymAt(int index) {
                return this.mSynonyms != null ? this.mSynonyms.get(index) : null;
            }

            private final void $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$setExtras(Bundle extras) {
                this.mExtras = extras;
            }

            private final Bundle $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$getExtras() {
                return this.mExtras;
            }

            private void $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$__constructor__(Parcel in) {
                this.mLabel = in.readCharSequence();
                this.mIndex = in.readInt();
                this.mSynonyms = in.readCharSequenceList();
                this.mExtras = in.readBundle();
            }

            private final int $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$describeContents() {
                return 0;
            }

            private final void $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$writeToParcel(Parcel dest, int flags) {
                dest.writeCharSequence(this.mLabel);
                dest.writeInt(this.mIndex);
                dest.writeCharSequenceList(this.mSynonyms);
                dest.writeBundle(this.mExtras);
            }

            static void __staticInitializer__() {
                CREATOR = new Parcelable.Creator<Option>(){
                    public /* synthetic */ Object __robo_data__;

                    private void $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option_1$__constructor__() {
                    }

                    private final Option $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option_1$createFromParcel(Parcel in) {
                        return new Option(in);
                    }

                    private final Option[] $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option_1$newArray(int size) {
                        return new Option[size];
                    }

                    private void __constructor__() {
                        this.$$robo$$android_app_VoiceInteractor_PickOptionRequest_Option_1$__constructor__();
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option_1$__constructor__(), this);
                    }

                    @Override
                    public Option createFromParcel(Parcel parcel) {
                        return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option_1$createFromParcel(android.os.Parcel ), this, parcel);
                    }

                    public Option[] newArray(int n) {
                        return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option_1$newArray(int ), this, n);
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }

            private void __constructor__(CharSequence charSequence) {
                this.$$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$__constructor__(charSequence);
            }

            public Option(CharSequence charSequence) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$__constructor__(java.lang.CharSequence ), this, charSequence);
            }

            private void __constructor__(CharSequence charSequence, int n) {
                this.$$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$__constructor__(charSequence, n);
            }

            public Option(CharSequence charSequence, int n) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$__constructor__(java.lang.CharSequence int ), this, charSequence, n);
            }

            public Option addSynonym(CharSequence charSequence) {
                return InvokeDynamicSupport.bootstrap("addSynonym", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$addSynonym(java.lang.CharSequence ), this, charSequence);
            }

            public CharSequence getLabel() {
                return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$getLabel(), this);
            }

            public int getIndex() {
                return (int)InvokeDynamicSupport.bootstrap("getIndex", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$getIndex(), this);
            }

            public int countSynonyms() {
                return (int)InvokeDynamicSupport.bootstrap("countSynonyms", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$countSynonyms(), this);
            }

            public CharSequence getSynonymAt(int n) {
                return InvokeDynamicSupport.bootstrap("getSynonymAt", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$getSynonymAt(int ), this, n);
            }

            public void setExtras(Bundle bundle) {
                InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$setExtras(android.os.Bundle ), this, bundle);
            }

            public Bundle getExtras() {
                return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$getExtras(), this);
            }

            private void __constructor__(Parcel parcel) {
                this.$$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$__constructor__(parcel);
            }

            public Option(Parcel parcel) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$__constructor__(android.os.Parcel ), this, parcel);
            }

            @Override
            public int describeContents() {
                return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$describeContents(), this);
            }

            @Override
            public void writeToParcel(Parcel parcel, int n) {
                InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_VoiceInteractor_PickOptionRequest_Option$writeToParcel(android.os.Parcel int ), this, parcel, n);
            }

            static {
                RobolectricInternals.classInitializing(Option.class);
            }

            public /* synthetic */ Option() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Option)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class ConfirmationRequest
    extends Request
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Prompt mPrompt;
        Bundle mExtras;

        private void $$robo$$android_app_VoiceInteractor_ConfirmationRequest$__constructor__(Prompt prompt, Bundle extras) {
            this.mPrompt = prompt;
            this.mExtras = extras;
        }

        private void $$robo$$android_app_VoiceInteractor_ConfirmationRequest$__constructor__(CharSequence prompt, Bundle extras) {
            this.mPrompt = prompt != null ? new Prompt(prompt) : null;
            this.mExtras = extras;
        }

        private final void $$robo$$android_app_VoiceInteractor_ConfirmationRequest$onConfirmationResult(boolean confirmed, Bundle result) {
        }

        private final void $$robo$$android_app_VoiceInteractor_ConfirmationRequest$dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
            if (this.mExtras != null) {
                writer.print(prefix);
                writer.print("mExtras=");
                writer.println(this.mExtras);
            }
        }

        private final String $$robo$$android_app_VoiceInteractor_ConfirmationRequest$getRequestTypeName() {
            return "Confirmation";
        }

        private final IVoiceInteractorRequest $$robo$$android_app_VoiceInteractor_ConfirmationRequest$submit(IVoiceInteractor interactor, String packageName, IVoiceInteractorCallback callback) throws RemoteException {
            return interactor.startConfirmation(packageName, callback, this.mPrompt, this.mExtras);
        }

        private void __constructor__(Prompt prompt, Bundle bundle) {
            this.$$robo$$android_app_VoiceInteractor_ConfirmationRequest$__constructor__(prompt, bundle);
        }

        public ConfirmationRequest(Prompt prompt, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_ConfirmationRequest$__constructor__(android.app.VoiceInteractor$Prompt android.os.Bundle ), this, prompt, bundle);
        }

        private void __constructor__(CharSequence charSequence, Bundle bundle) {
            this.$$robo$$android_app_VoiceInteractor_ConfirmationRequest$__constructor__(charSequence, bundle);
        }

        public ConfirmationRequest(CharSequence charSequence, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_ConfirmationRequest$__constructor__(java.lang.CharSequence android.os.Bundle ), this, charSequence, bundle);
        }

        public void onConfirmationResult(boolean bl, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onConfirmationResult", $$robo$$android_app_VoiceInteractor_ConfirmationRequest$onConfirmationResult(boolean android.os.Bundle ), this, bl, bundle);
        }

        @Override
        void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_VoiceInteractor_ConfirmationRequest$dump(java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, string2, fileDescriptor, printWriter, stringArray);
        }

        @Override
        String getRequestTypeName() {
            return InvokeDynamicSupport.bootstrap("getRequestTypeName", $$robo$$android_app_VoiceInteractor_ConfirmationRequest$getRequestTypeName(), this);
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor iVoiceInteractor, String string2, IVoiceInteractorCallback iVoiceInteractorCallback) throws RemoteException {
            return InvokeDynamicSupport.bootstrap("submit", $$robo$$android_app_VoiceInteractor_ConfirmationRequest$submit(com.android.internal.app.IVoiceInteractor java.lang.String com.android.internal.app.IVoiceInteractorCallback ), this, iVoiceInteractor, string2, iVoiceInteractorCallback);
        }

        public /* synthetic */ ConfirmationRequest() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfirmationRequest)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Request
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        IVoiceInteractorRequest mRequestInterface;
        Context mContext;
        Activity mActivity;
        String mName;

        private void $$robo$$android_app_VoiceInteractor_Request$__constructor__() {
        }

        private final String $$robo$$android_app_VoiceInteractor_Request$getName() {
            return this.mName;
        }

        private final void $$robo$$android_app_VoiceInteractor_Request$cancel() {
            if (this.mRequestInterface == null) {
                throw new IllegalStateException("Request " + this + " is no longer active");
            }
            try {
                this.mRequestInterface.cancel();
            }
            catch (RemoteException e) {
                Log.w("VoiceInteractor", "Voice interactor has died", e);
            }
        }

        private final Context $$robo$$android_app_VoiceInteractor_Request$getContext() {
            return this.mContext;
        }

        private final Activity $$robo$$android_app_VoiceInteractor_Request$getActivity() {
            return this.mActivity;
        }

        private final void $$robo$$android_app_VoiceInteractor_Request$onCancel() {
        }

        private final void $$robo$$android_app_VoiceInteractor_Request$onAttached(Activity activity) {
        }

        private final void $$robo$$android_app_VoiceInteractor_Request$onDetached() {
        }

        private final String $$robo$$android_app_VoiceInteractor_Request$toString() {
            StringBuilder sb = new StringBuilder(128);
            DebugUtils.buildShortClassTag(this, sb);
            sb.append(" ");
            sb.append(this.getRequestTypeName());
            sb.append(" name=");
            sb.append(this.mName);
            sb.append('}');
            return sb.toString();
        }

        private final void $$robo$$android_app_VoiceInteractor_Request$dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.print(prefix);
            writer.print("mRequestInterface=");
            writer.println(this.mRequestInterface.asBinder());
            writer.print(prefix);
            writer.print("mActivity=");
            writer.println(this.mActivity);
            writer.print(prefix);
            writer.print("mName=");
            writer.println(this.mName);
        }

        private final String $$robo$$android_app_VoiceInteractor_Request$getRequestTypeName() {
            return "Request";
        }

        private final void $$robo$$android_app_VoiceInteractor_Request$clear() {
            this.mRequestInterface = null;
            this.mContext = null;
            this.mActivity = null;
            this.mName = null;
        }

        abstract IVoiceInteractorRequest submit(IVoiceInteractor var1, String var2, IVoiceInteractorCallback var3) throws RemoteException;

        private void __constructor__() {
            this.$$robo$$android_app_VoiceInteractor_Request$__constructor__();
        }

        public Request() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_VoiceInteractor_Request$__constructor__(), this);
        }

        public String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_app_VoiceInteractor_Request$getName(), this);
        }

        public void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_app_VoiceInteractor_Request$cancel(), this);
        }

        public Context getContext() {
            return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_app_VoiceInteractor_Request$getContext(), this);
        }

        public Activity getActivity() {
            return InvokeDynamicSupport.bootstrap("getActivity", $$robo$$android_app_VoiceInteractor_Request$getActivity(), this);
        }

        public void onCancel() {
            InvokeDynamicSupport.bootstrap("onCancel", $$robo$$android_app_VoiceInteractor_Request$onCancel(), this);
        }

        public void onAttached(Activity activity) {
            InvokeDynamicSupport.bootstrap("onAttached", $$robo$$android_app_VoiceInteractor_Request$onAttached(android.app.Activity ), this, activity);
        }

        public void onDetached() {
            InvokeDynamicSupport.bootstrap("onDetached", $$robo$$android_app_VoiceInteractor_Request$onDetached(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_VoiceInteractor_Request$toString(), this);
        }

        void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_VoiceInteractor_Request$dump(java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, string2, fileDescriptor, printWriter, stringArray);
        }

        String getRequestTypeName() {
            return InvokeDynamicSupport.bootstrap("getRequestTypeName", $$robo$$android_app_VoiceInteractor_Request$getRequestTypeName(), this);
        }

        void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_app_VoiceInteractor_Request$clear(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Request)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

