/*
 * Decompiled with CFR 0.152.
 */
package android.app.trust;

import android.app.trust.ITrustListener;
import android.app.trust.ITrustManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.ArrayMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TrustManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MSG_TRUST_CHANGED = 1;
    private static int MSG_TRUST_MANAGED_CHANGED = 2;
    private static String TAG = "TrustManager";
    private static String DATA_FLAGS = "initiatedByUser";
    private ITrustManager mService;
    private ArrayMap<TrustListener, ITrustListener> mTrustListeners;
    private Handler mHandler;

    private void $$robo$$android_app_trust_TrustManager$__constructor__(IBinder b) {
        this.mHandler = new ShadowedObject(this, Looper.getMainLooper()){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TrustManager this$0;

            private void $$robo$$android_app_trust_TrustManager_2$__constructor__(TrustManager this$0, Looper looper) {
            }

            private final void $$robo$$android_app_trust_TrustManager_2$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        int flags = msg.peekData() != null ? msg.peekData().getInt("initiatedByUser") : 0;
                        ((TrustListener)msg.obj).onTrustChanged(msg.arg1 != 0, msg.arg2, flags);
                        break;
                    }
                    case 2: {
                        ((TrustListener)msg.obj).onTrustManagedChanged(msg.arg1 != 0, msg.arg2);
                    }
                }
            }

            private void __constructor__(TrustManager trustManager, Looper looper) {
                this.$$robo$$android_app_trust_TrustManager_2$__constructor__(trustManager, looper);
            }
            {
                this.this$0 = trustManager;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_trust_TrustManager_2$__constructor__(android.app.trust.TrustManager android.os.Looper ), this, trustManager, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_trust_TrustManager_2$handleMessage(android.os.Message ), this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mService = ITrustManager.Stub.asInterface(b);
        this.mTrustListeners = new ArrayMap();
    }

    private final void $$robo$$android_app_trust_TrustManager$setDeviceLockedForUser(int userId, boolean locked) {
        try {
            this.mService.setDeviceLockedForUser(userId, locked);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_trust_TrustManager$reportUnlockAttempt(boolean successful, int userId) {
        try {
            this.mService.reportUnlockAttempt(successful, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_trust_TrustManager$reportUnlockLockout(int timeoutMs, int userId) {
        try {
            this.mService.reportUnlockLockout(timeoutMs, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_trust_TrustManager$reportEnabledTrustAgentsChanged(int userId) {
        try {
            this.mService.reportEnabledTrustAgentsChanged(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_trust_TrustManager$reportKeyguardShowingChanged() {
        try {
            this.mService.reportKeyguardShowingChanged();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_trust_TrustManager$registerTrustListener(TrustListener trustListener) {
        try {
            ShadowedObject iTrustListener = new ShadowedObject(this, trustListener){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ TrustListener val$trustListener;
                /* synthetic */ TrustManager this$0;

                private void $$robo$$android_app_trust_TrustManager_1$__constructor__(TrustManager this$0, TrustListener trustListener) {
                    this.val$trustListener = trustListener;
                }

                private final void $$robo$$android_app_trust_TrustManager_1$onTrustChanged(boolean enabled, int userId, int flags) {
                    Message m = this.this$0.mHandler.obtainMessage(1, enabled ? 1 : 0, userId, this.val$trustListener);
                    if (flags != 0) {
                        m.getData().putInt("initiatedByUser", flags);
                    }
                    m.sendToTarget();
                }

                private final void $$robo$$android_app_trust_TrustManager_1$onTrustManagedChanged(boolean managed, int userId) {
                    this.this$0.mHandler.obtainMessage(2, managed ? 1 : 0, userId, this.val$trustListener).sendToTarget();
                }

                private void __constructor__(TrustManager trustManager, TrustListener trustListener) {
                    this.$$robo$$android_app_trust_TrustManager_1$__constructor__(trustManager, trustListener);
                }
                {
                    this.this$0 = trustManager;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_trust_TrustManager_1$__constructor__(android.app.trust.TrustManager android.app.trust.TrustManager$TrustListener ), this, trustManager, trustListener);
                }

                @Override
                public void onTrustChanged(boolean bl, int n, int n2) {
                    InvokeDynamicSupport.bootstrap("onTrustChanged", $$robo$$android_app_trust_TrustManager_1$onTrustChanged(boolean int int ), this, bl, n, n2);
                }

                @Override
                public void onTrustManagedChanged(boolean bl, int n) {
                    InvokeDynamicSupport.bootstrap("onTrustManagedChanged", $$robo$$android_app_trust_TrustManager_1$onTrustManagedChanged(boolean int ), this, bl, n);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mService.registerTrustListener((ITrustListener)iTrustListener);
            this.mTrustListeners.put(trustListener, (ITrustListener)iTrustListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_trust_TrustManager$unregisterTrustListener(TrustListener trustListener) {
        ITrustListener iTrustListener = this.mTrustListeners.remove(trustListener);
        if (iTrustListener != null) {
            try {
                this.mService.unregisterTrustListener(iTrustListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_trust_TrustManager$isTrustUsuallyManaged(int userId) {
        try {
            return this.mService.isTrustUsuallyManaged(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void __constructor__(IBinder iBinder) {
        this.$$robo$$android_app_trust_TrustManager$__constructor__(iBinder);
    }

    public TrustManager(IBinder iBinder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_trust_TrustManager$__constructor__(android.os.IBinder ), this, iBinder);
    }

    public void setDeviceLockedForUser(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setDeviceLockedForUser", $$robo$$android_app_trust_TrustManager$setDeviceLockedForUser(int boolean ), this, n, bl);
    }

    public void reportUnlockAttempt(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("reportUnlockAttempt", $$robo$$android_app_trust_TrustManager$reportUnlockAttempt(boolean int ), this, bl, n);
    }

    public void reportUnlockLockout(int n, int n2) {
        InvokeDynamicSupport.bootstrap("reportUnlockLockout", $$robo$$android_app_trust_TrustManager$reportUnlockLockout(int int ), this, n, n2);
    }

    public void reportEnabledTrustAgentsChanged(int n) {
        InvokeDynamicSupport.bootstrap("reportEnabledTrustAgentsChanged", $$robo$$android_app_trust_TrustManager$reportEnabledTrustAgentsChanged(int ), this, n);
    }

    public void reportKeyguardShowingChanged() {
        InvokeDynamicSupport.bootstrap("reportKeyguardShowingChanged", $$robo$$android_app_trust_TrustManager$reportKeyguardShowingChanged(), this);
    }

    public void registerTrustListener(TrustListener trustListener) {
        InvokeDynamicSupport.bootstrap("registerTrustListener", $$robo$$android_app_trust_TrustManager$registerTrustListener(android.app.trust.TrustManager$TrustListener ), this, trustListener);
    }

    public void unregisterTrustListener(TrustListener trustListener) {
        InvokeDynamicSupport.bootstrap("unregisterTrustListener", $$robo$$android_app_trust_TrustManager$unregisterTrustListener(android.app.trust.TrustManager$TrustListener ), this, trustListener);
    }

    public boolean isTrustUsuallyManaged(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTrustUsuallyManaged", $$robo$$android_app_trust_TrustManager$isTrustUsuallyManaged(int ), this, n);
    }

    public /* synthetic */ TrustManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TrustManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface TrustListener
    extends InstrumentedInterface {
        public void onTrustChanged(boolean var1, int var2, int var3);

        public void onTrustManagedChanged(boolean var1, int var2);
    }
}

