/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.app.usage.ConfigurationStats;
import android.app.usage.IUsageStatsManager;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UsageStatsManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int INTERVAL_DAILY = 0;
    public static int INTERVAL_WEEKLY = 1;
    public static int INTERVAL_MONTHLY = 2;
    public static int INTERVAL_YEARLY = 3;
    public static int INTERVAL_BEST = 4;
    public static int INTERVAL_COUNT = 4;
    private static UsageEvents sEmptyResults;
    private Context mContext;
    private IUsageStatsManager mService;

    private void $$robo$$android_app_usage_UsageStatsManager$__constructor__(Context context, IUsageStatsManager service) {
        this.mContext = context;
        this.mService = service;
    }

    private final List<UsageStats> $$robo$$android_app_usage_UsageStatsManager$queryUsageStats(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryUsageStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private final List<ConfigurationStats> $$robo$$android_app_usage_UsageStatsManager$queryConfigurations(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryConfigurationStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private final UsageEvents $$robo$$android_app_usage_UsageStatsManager$queryEvents(long beginTime, long endTime) {
        try {
            UsageEvents iter = this.mService.queryEvents(beginTime, endTime, this.mContext.getOpPackageName());
            if (iter != null) {
                return iter;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sEmptyResults;
    }

    private final Map<String, UsageStats> $$robo$$android_app_usage_UsageStatsManager$queryAndAggregateUsageStats(long beginTime, long endTime) {
        List<UsageStats> stats = this.queryUsageStats(4, beginTime, endTime);
        if (stats.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayMap<String, UsageStats> aggregatedStats = new ArrayMap<String, UsageStats>();
        int statCount = stats.size();
        for (int i = 0; i < statCount; ++i) {
            UsageStats newStat = stats.get(i);
            UsageStats existingStat = aggregatedStats.get(newStat.getPackageName());
            if (existingStat == null) {
                aggregatedStats.put(newStat.mPackageName, newStat);
                continue;
            }
            existingStat.add(newStat);
        }
        return aggregatedStats;
    }

    private final boolean $$robo$$android_app_usage_UsageStatsManager$isAppInactive(String packageName) {
        try {
            return this.mService.isAppInactive(packageName, UserHandle.myUserId());
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final void $$robo$$android_app_usage_UsageStatsManager$setAppInactive(String packageName, boolean inactive) {
        try {
            this.mService.setAppInactive(packageName, inactive, UserHandle.myUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_app_usage_UsageStatsManager$whitelistAppTemporarily(String packageName, long duration, UserHandle user) {
        try {
            this.mService.whitelistAppTemporarily(packageName, duration, user.getIdentifier());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_app_usage_UsageStatsManager$onCarrierPrivilegedAppsChanged() {
        try {
            this.mService.onCarrierPrivilegedAppsChanged();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_app_usage_UsageStatsManager$reportChooserSelection(String packageName, int userId, String contentType, String[] annotations, String action) {
        try {
            this.mService.reportChooserSelection(packageName, userId, contentType, annotations, action);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static void __staticInitializer__() {
        sEmptyResults = new UsageEvents();
    }

    private void __constructor__(Context context, IUsageStatsManager iUsageStatsManager) {
        this.$$robo$$android_app_usage_UsageStatsManager$__constructor__(context, iUsageStatsManager);
    }

    public UsageStatsManager(Context context, IUsageStatsManager iUsageStatsManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_UsageStatsManager$__constructor__(android.content.Context android.app.usage.IUsageStatsManager ), this, context, iUsageStatsManager);
    }

    public List<UsageStats> queryUsageStats(int n, long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryUsageStats", $$robo$$android_app_usage_UsageStatsManager$queryUsageStats(int long long ), this, n, l, l2);
    }

    public List<ConfigurationStats> queryConfigurations(int n, long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryConfigurations", $$robo$$android_app_usage_UsageStatsManager$queryConfigurations(int long long ), this, n, l, l2);
    }

    public UsageEvents queryEvents(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryEvents", $$robo$$android_app_usage_UsageStatsManager$queryEvents(long long ), this, l, l2);
    }

    public Map<String, UsageStats> queryAndAggregateUsageStats(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryAndAggregateUsageStats", $$robo$$android_app_usage_UsageStatsManager$queryAndAggregateUsageStats(long long ), this, l, l2);
    }

    public boolean isAppInactive(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAppInactive", $$robo$$android_app_usage_UsageStatsManager$isAppInactive(java.lang.String ), this, string2);
    }

    public void setAppInactive(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setAppInactive", $$robo$$android_app_usage_UsageStatsManager$setAppInactive(java.lang.String boolean ), this, string2, bl);
    }

    public void whitelistAppTemporarily(String string2, long l, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("whitelistAppTemporarily", $$robo$$android_app_usage_UsageStatsManager$whitelistAppTemporarily(java.lang.String long android.os.UserHandle ), this, string2, l, userHandle);
    }

    public void onCarrierPrivilegedAppsChanged() {
        InvokeDynamicSupport.bootstrap("onCarrierPrivilegedAppsChanged", $$robo$$android_app_usage_UsageStatsManager$onCarrierPrivilegedAppsChanged(), this);
    }

    public void reportChooserSelection(String string2, int n, String string3, String[] stringArray, String string4) {
        InvokeDynamicSupport.bootstrap("reportChooserSelection", $$robo$$android_app_usage_UsageStatsManager$reportChooserSelection(java.lang.String int java.lang.String java.lang.String[] java.lang.String ), this, string2, n, string3, stringArray, string4);
    }

    static {
        RobolectricInternals.classInitializing(UsageStatsManager.class);
    }

    public /* synthetic */ UsageStatsManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsageStatsManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

