/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothCodecConfig;
import android.bluetooth.BluetoothCodecStatus;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothA2dp;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothA2dp
implements BluetoothProfile,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothA2dp";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED";
    public static String ACTION_PLAYING_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED";
    public static String ACTION_AVRCP_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.AVRCP_CONNECTION_STATE_CHANGED";
    public static String ACTION_CODEC_CONFIG_CHANGED = "android.bluetooth.a2dp.profile.action.CODEC_CONFIG_CHANGED";
    public static int STATE_PLAYING = 10;
    public static int STATE_NOT_PLAYING = 11;
    public static int OPTIONAL_CODECS_SUPPORT_UNKNOWN = -1;
    public static int OPTIONAL_CODECS_NOT_SUPPORTED = 0;
    public static int OPTIONAL_CODECS_SUPPORTED = 1;
    public static int OPTIONAL_CODECS_PREF_UNKNOWN = -1;
    public static int OPTIONAL_CODECS_PREF_DISABLED = 0;
    public static int OPTIONAL_CODECS_PREF_ENABLED = 1;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private ReentrantReadWriteLock mServiceLock;
    @GuardedBy(value="mServiceLock")
    private IBluetoothA2dp mService;
    private BluetoothAdapter mAdapter;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothA2dp$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mServiceLock = new ReentrantReadWriteLock();
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothA2dp this$0;

            private void $$robo$$android_bluetooth_BluetoothA2dp_1$__constructor__(BluetoothA2dp this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothA2dp_1$onBluetoothStateChange(boolean up) {
                Log.d("BluetoothA2dp", "onBluetoothStateChange: up=" + up);
                if (!up) {
                    try {
                        this.this$0.mServiceLock.writeLock().lock();
                        this.this$0.mService = null;
                        this.this$0.mContext.unbindService(this.this$0.mConnection);
                    }
                    catch (Exception re) {
                        Log.e("BluetoothA2dp", "", re);
                    }
                    finally {
                        this.this$0.mServiceLock.writeLock().unlock();
                    }
                } else {
                    try {
                        this.this$0.mServiceLock.readLock().lock();
                        if (this.this$0.mService == null) {
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothA2dp", "", re);
                    }
                    finally {
                        this.this$0.mServiceLock.readLock().unlock();
                    }
                }
            }

            private void __constructor__(BluetoothA2dp bluetoothA2dp) {
                this.$$robo$$android_bluetooth_BluetoothA2dp_1$__constructor__(bluetoothA2dp);
            }
            {
                this.this$0 = bluetoothA2dp;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothA2dp_1$__constructor__(android.bluetooth.BluetoothA2dp ), this, bluetoothA2dp);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothA2dp_1$onBluetoothStateChange(boolean ), this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothA2dp this$0;

            private void $$robo$$android_bluetooth_BluetoothA2dp_2$__constructor__(BluetoothA2dp this$0) {
            }

            private final void $$robo$$android_bluetooth_BluetoothA2dp_2$onServiceConnected(ComponentName className, IBinder service) {
                Log.d("BluetoothA2dp", "Proxy object connected");
                try {
                    this.this$0.mServiceLock.writeLock().lock();
                    this.this$0.mService = IBluetoothA2dp.Stub.asInterface(Binder.allowBlocking(service));
                }
                finally {
                    this.this$0.mServiceLock.writeLock().unlock();
                }
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(2, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothA2dp_2$onServiceDisconnected(ComponentName className) {
                Log.d("BluetoothA2dp", "Proxy object disconnected");
                try {
                    this.this$0.mServiceLock.writeLock().lock();
                    this.this$0.mService = null;
                }
                finally {
                    this.this$0.mServiceLock.writeLock().unlock();
                }
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(2);
                }
            }

            private void __constructor__(BluetoothA2dp bluetoothA2dp) {
                this.$$robo$$android_bluetooth_BluetoothA2dp_2$__constructor__(bluetoothA2dp);
            }
            {
                this.this$0 = bluetoothA2dp;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothA2dp_2$__constructor__(android.bluetooth.BluetoothA2dp ), this, bluetoothA2dp);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothA2dp_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothA2dp_2$onServiceDisconnected(android.content.ComponentName ), this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothA2dp", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dp$doBind() {
        Intent intent = new Intent(IBluetoothA2dp.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e("BluetoothA2dp", "Could not bind to Bluetooth A2DP Service with " + intent);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothA2dp$close() {
        this.mServiceListener = null;
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothA2dp", "", e);
            }
        }
        try {
            this.mServiceLock.writeLock().lock();
            if (this.mService != null) {
                this.mService = null;
                this.mContext.unbindService(this.mConnection);
            }
        }
        catch (Exception re) {
            Log.e("BluetoothA2dp", "", re);
        }
        finally {
            this.mServiceLock.writeLock().unlock();
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothA2dp$finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothA2dp$connect(BluetoothDevice device) {
        BluetoothA2dp.log("connect(" + device + ")");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                boolean bl = this.mService.connect(device);
                return bl;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothA2dp$disconnect(BluetoothDevice device) {
        BluetoothA2dp.log("disconnect(" + device + ")");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                boolean bl = this.mService.disconnect(device);
                return bl;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothA2dp$getConnectedDevices() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                List<BluetoothDevice> list = this.mService.getConnectedDevices();
                return list;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Stack:" + Log.getStackTraceString(new Throwable()));
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothA2dp$getDevicesMatchingConnectionStates(int[] states) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                List<BluetoothDevice> list = this.mService.getDevicesMatchingConnectionStates(states);
                return list;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Stack:" + Log.getStackTraceString(new Throwable()));
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothA2dp$getConnectionState(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getConnectionState(device);
                return n;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothA2dp$setPriority(BluetoothDevice device, int priority) {
        BluetoothA2dp.log("setPriority(" + device + ", " + priority + ")");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                if (priority != 0 && priority != 100) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.mService.setPriority(device, priority);
                return bl;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothA2dp$getPriority(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getPriority(device);
                return n;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dp$isAvrcpAbsoluteVolumeSupported() {
        Log.d("BluetoothA2dp", "isAvrcpAbsoluteVolumeSupported");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                boolean bl = this.mService.isAvrcpAbsoluteVolumeSupported();
                return bl;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Error talking to BT service in isAvrcpAbsoluteVolumeSupported()", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothA2dp$adjustAvrcpAbsoluteVolume(int direction) {
        Log.d("BluetoothA2dp", "adjustAvrcpAbsoluteVolume");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                this.mService.adjustAvrcpAbsoluteVolume(direction);
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Error talking to BT service in adjustAvrcpAbsoluteVolume()", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothA2dp$setAvrcpAbsoluteVolume(int volume) {
        Log.d("BluetoothA2dp", "setAvrcpAbsoluteVolume");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                this.mService.setAvrcpAbsoluteVolume(volume);
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Error talking to BT service in setAvrcpAbsoluteVolume()", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothA2dp$isA2dpPlaying(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                boolean bl = this.mService.isA2dpPlaying(device);
                return bl;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dp$shouldSendVolumeKeys(BluetoothDevice device) {
        if (this.isEnabled() && this.isValidDevice(device)) {
            ParcelUuid[] uuids = device.getUuids();
            if (uuids == null) {
                return false;
            }
            for (ParcelUuid uuid : uuids) {
                if (!BluetoothUuid.isAvrcpTarget(uuid)) continue;
                return true;
            }
        }
        return false;
    }

    private final BluetoothCodecStatus $$robo$$android_bluetooth_BluetoothA2dp$getCodecStatus() {
        Log.d("BluetoothA2dp", "getCodecStatus");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                BluetoothCodecStatus bluetoothCodecStatus = this.mService.getCodecStatus();
                return bluetoothCodecStatus;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            BluetoothCodecStatus bluetoothCodecStatus = null;
            return bluetoothCodecStatus;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Error talking to BT service in getCodecStatus()", e);
            BluetoothCodecStatus bluetoothCodecStatus = null;
            return bluetoothCodecStatus;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothA2dp$setCodecConfigPreference(BluetoothCodecConfig codecConfig) {
        Log.d("BluetoothA2dp", "setCodecConfigPreference");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                this.mService.setCodecConfigPreference(codecConfig);
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            return;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Error talking to BT service in setCodecConfigPreference()", e);
            return;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothA2dp$enableOptionalCodecs() {
        Log.d("BluetoothA2dp", "enableOptionalCodecs");
        this.enableDisableOptionalCodecs(true);
    }

    private final void $$robo$$android_bluetooth_BluetoothA2dp$disableOptionalCodecs() {
        Log.d("BluetoothA2dp", "disableOptionalCodecs");
        this.enableDisableOptionalCodecs(false);
    }

    private final void $$robo$$android_bluetooth_BluetoothA2dp$enableDisableOptionalCodecs(boolean enable) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                if (enable) {
                    this.mService.enableOptionalCodecs();
                } else {
                    this.mService.disableOptionalCodecs();
                }
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            return;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Error talking to BT service in enableDisableOptionalCodecs()", e);
            return;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothA2dp$supportsOptionalCodecs(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.supportsOptionalCodecs(device);
                return n;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            int n = -1;
            return n;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Error talking to BT service in getSupportsOptionalCodecs()", e);
            int n = -1;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothA2dp$getOptionalCodecsEnabled(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getOptionalCodecsEnabled(device);
                return n;
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            int n = -1;
            return n;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Error talking to BT service in getSupportsOptionalCodecs()", e);
            int n = -1;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothA2dp$setOptionalCodecsEnabled(BluetoothDevice device, int value) {
        try {
            if (value != -1 && value != 0 && value != 1) {
                Log.e("BluetoothA2dp", "Invalid value passed to setOptionalCodecsEnabled: " + value);
                return;
            }
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                this.mService.setOptionalCodecsEnabled(device, value);
            }
            if (this.mService == null) {
                Log.w("BluetoothA2dp", "Proxy not attached to service");
            }
            return;
        }
        catch (RemoteException e) {
            Log.e("BluetoothA2dp", "Stack:" + Log.getStackTraceString(new Throwable()));
            return;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private static final String $$robo$$android_bluetooth_BluetoothA2dp$stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
            case 10: {
                return "playing";
            }
            case 11: {
                return "not playing";
            }
        }
        return "<unknown state " + state + ">";
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dp$isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothA2dp$isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static final void $$robo$$android_bluetooth_BluetoothA2dp$log(String msg) {
        Log.d("BluetoothA2dp", msg);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothA2dp$__constructor__(context, serviceListener);
    }

    public BluetoothA2dp(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothA2dp$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothA2dp$doBind(), this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothA2dp$close(), this);
    }

    public void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothA2dp$finalize(), this);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothA2dp$connect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothA2dp$disconnect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothA2dp$getConnectedDevices(), this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothA2dp$getDevicesMatchingConnectionStates(int[] ), this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothA2dp$getConnectionState(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_bluetooth_BluetoothA2dp$setPriority(android.bluetooth.BluetoothDevice int ), this, bluetoothDevice, n);
    }

    public int getPriority(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_bluetooth_BluetoothA2dp$getPriority(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean isAvrcpAbsoluteVolumeSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAvrcpAbsoluteVolumeSupported", $$robo$$android_bluetooth_BluetoothA2dp$isAvrcpAbsoluteVolumeSupported(), this);
    }

    public void adjustAvrcpAbsoluteVolume(int n) {
        InvokeDynamicSupport.bootstrap("adjustAvrcpAbsoluteVolume", $$robo$$android_bluetooth_BluetoothA2dp$adjustAvrcpAbsoluteVolume(int ), this, n);
    }

    public void setAvrcpAbsoluteVolume(int n) {
        InvokeDynamicSupport.bootstrap("setAvrcpAbsoluteVolume", $$robo$$android_bluetooth_BluetoothA2dp$setAvrcpAbsoluteVolume(int ), this, n);
    }

    public boolean isA2dpPlaying(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isA2dpPlaying", $$robo$$android_bluetooth_BluetoothA2dp$isA2dpPlaying(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean shouldSendVolumeKeys(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldSendVolumeKeys", $$robo$$android_bluetooth_BluetoothA2dp$shouldSendVolumeKeys(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public BluetoothCodecStatus getCodecStatus() {
        return InvokeDynamicSupport.bootstrap("getCodecStatus", $$robo$$android_bluetooth_BluetoothA2dp$getCodecStatus(), this);
    }

    public void setCodecConfigPreference(BluetoothCodecConfig bluetoothCodecConfig) {
        InvokeDynamicSupport.bootstrap("setCodecConfigPreference", $$robo$$android_bluetooth_BluetoothA2dp$setCodecConfigPreference(android.bluetooth.BluetoothCodecConfig ), this, bluetoothCodecConfig);
    }

    public void enableOptionalCodecs() {
        InvokeDynamicSupport.bootstrap("enableOptionalCodecs", $$robo$$android_bluetooth_BluetoothA2dp$enableOptionalCodecs(), this);
    }

    public void disableOptionalCodecs() {
        InvokeDynamicSupport.bootstrap("disableOptionalCodecs", $$robo$$android_bluetooth_BluetoothA2dp$disableOptionalCodecs(), this);
    }

    private void enableDisableOptionalCodecs(boolean bl) {
        InvokeDynamicSupport.bootstrap("enableDisableOptionalCodecs", $$robo$$android_bluetooth_BluetoothA2dp$enableDisableOptionalCodecs(boolean ), this, bl);
    }

    public int supportsOptionalCodecs(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("supportsOptionalCodecs", $$robo$$android_bluetooth_BluetoothA2dp$supportsOptionalCodecs(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public int getOptionalCodecsEnabled(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getOptionalCodecsEnabled", $$robo$$android_bluetooth_BluetoothA2dp$getOptionalCodecsEnabled(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public void setOptionalCodecsEnabled(BluetoothDevice bluetoothDevice, int n) {
        InvokeDynamicSupport.bootstrap("setOptionalCodecsEnabled", $$robo$$android_bluetooth_BluetoothA2dp$setOptionalCodecsEnabled(android.bluetooth.BluetoothDevice int ), this, bluetoothDevice, n);
    }

    public static String stateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("stateToString", $$robo$$android_bluetooth_BluetoothA2dp$stateToString(int ), (int)n);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothA2dp$isEnabled(), this);
    }

    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidDevice", $$robo$$android_bluetooth_BluetoothA2dp$isValidDevice(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothA2dp$log(java.lang.String ), (String)string2);
    }

    public /* synthetic */ BluetoothA2dp() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothA2dp)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

