/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.IntDef;
import android.app.ActivityThread;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothA2dpSink;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAvrcpController;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHeadsetClient;
import android.bluetooth.BluetoothHealth;
import android.bluetooth.BluetoothInputDevice;
import android.bluetooth.BluetoothInputHost;
import android.bluetooth.BluetoothMap;
import android.bluetooth.BluetoothMapClient;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothPbapClient;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothSap;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.PeriodicAdvertisingManager;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.SynchronousResultReceiver;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Pair;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothAdapter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothAdapter";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String DEFAULT_MAC_ADDRESS = "02:00:00:00:00:00";
    public static int ERROR = Integer.MIN_VALUE;
    public static String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    public static String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static int STATE_OFF = 10;
    public static int STATE_TURNING_ON = 11;
    public static int STATE_ON = 12;
    public static int STATE_TURNING_OFF = 13;
    public static int STATE_BLE_TURNING_ON = 14;
    public static int STATE_BLE_ON = 15;
    public static int STATE_BLE_TURNING_OFF = 16;
    public static String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";
    public static String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";
    public static String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";
    public static String ACTION_REQUEST_DISABLE = "android.bluetooth.adapter.action.REQUEST_DISABLE";
    public static String ACTION_REQUEST_BLE_SCAN_ALWAYS_AVAILABLE = "android.bluetooth.adapter.action.REQUEST_BLE_SCAN_ALWAYS_AVAILABLE";
    public static String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";
    public static String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";
    public static String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";
    public static int SCAN_MODE_NONE = 20;
    public static int SCAN_MODE_CONNECTABLE = 21;
    public static int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23;
    public static String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";
    public static String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";
    public static String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED";
    public static String EXTRA_CONNECTION_STATE = "android.bluetooth.adapter.extra.CONNECTION_STATE";
    public static String EXTRA_PREVIOUS_CONNECTION_STATE = "android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE";
    public static String ACTION_BLE_STATE_CHANGED = "android.bluetooth.adapter.action.BLE_STATE_CHANGED";
    public static String ACTION_BLUETOOTH_ADDRESS_CHANGED = "android.bluetooth.adapter.action.BLUETOOTH_ADDRESS_CHANGED";
    public static String EXTRA_BLUETOOTH_ADDRESS = "android.bluetooth.adapter.extra.BLUETOOTH_ADDRESS";
    public static String ACTION_BLE_ACL_CONNECTED = "android.bluetooth.adapter.action.BLE_ACL_CONNECTED";
    public static String ACTION_BLE_ACL_DISCONNECTED = "android.bluetooth.adapter.action.BLE_ACL_DISCONNECTED";
    public static int STATE_DISCONNECTED = 0;
    public static int STATE_CONNECTING = 1;
    public static int STATE_CONNECTED = 2;
    public static int STATE_DISCONNECTING = 3;
    public static String BLUETOOTH_MANAGER_SERVICE = "bluetooth_manager";
    private IBinder mToken;
    public static int SOCKET_CHANNEL_AUTO_STATIC_NO_SDP = -2;
    private static int ADDRESS_LENGTH = 17;
    private static BluetoothAdapter sAdapter;
    private static BluetoothLeScanner sBluetoothLeScanner;
    private static BluetoothLeAdvertiser sBluetoothLeAdvertiser;
    private static PeriodicAdvertisingManager sPeriodicAdvertisingManager;
    private IBluetoothManager mManagerService;
    private IBluetooth mService;
    private ReentrantReadWriteLock mServiceLock;
    private Object mLock;
    private Map<LeScanCallback, ScanCallback> mLeScanClients;
    private IBluetoothManagerCallback mManagerCallback;
    private ArrayList<IBluetoothManagerCallback> mProxyServiceStateCallbacks;

    private static final String $$robo$$android_bluetooth_BluetoothAdapter$nameForState(int state) {
        switch (state) {
            case 10: {
                return "OFF";
            }
            case 11: {
                return "TURNING_ON";
            }
            case 12: {
                return "ON";
            }
            case 13: {
                return "TURNING_OFF";
            }
            case 14: {
                return "BLE_TURNING_ON";
            }
            case 15: {
                return "BLE_ON";
            }
            case 16: {
                return "BLE_TURNING_OFF";
            }
        }
        return "?!?!? (" + state + ")";
    }

    private static final synchronized BluetoothAdapter $$robo$$android_bluetooth_BluetoothAdapter$getDefaultAdapter() {
        if (sAdapter == null) {
            IBinder b = ServiceManager.getService("bluetooth_manager");
            if (b != null) {
                IBluetoothManager managerService = IBluetoothManager.Stub.asInterface(b);
                sAdapter = new BluetoothAdapter(managerService);
            } else {
                Log.e("BluetoothAdapter", "Bluetooth binder is null");
            }
        }
        return sAdapter;
    }

    private void $$robo$$android_bluetooth_BluetoothAdapter$__constructor__(IBluetoothManager managerService) {
        this.mServiceLock = new ReentrantReadWriteLock();
        this.mLock = new Object();
        this.mManagerCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothAdapter this$0;

            private void $$robo$$android_bluetooth_BluetoothAdapter_1$__constructor__(BluetoothAdapter this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothAdapter_1$onBluetoothServiceUp(IBluetooth bluetoothService) {
                Log.d("BluetoothAdapter", "onBluetoothServiceUp: " + bluetoothService);
                this.this$0.mServiceLock.writeLock().lock();
                this.this$0.mService = bluetoothService;
                this.this$0.mServiceLock.writeLock().unlock();
                ArrayList arrayList = this.this$0.mProxyServiceStateCallbacks;
                synchronized (arrayList) {
                    for (IBluetoothManagerCallback cb : this.this$0.mProxyServiceStateCallbacks) {
                        try {
                            if (cb != null) {
                                cb.onBluetoothServiceUp(bluetoothService);
                                continue;
                            }
                            Log.d("BluetoothAdapter", "onBluetoothServiceUp: cb is null!");
                        }
                        catch (Exception e) {
                            Log.e("BluetoothAdapter", "", e);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothAdapter_1$onBluetoothServiceDown() {
                Log.d("BluetoothAdapter", "onBluetoothServiceDown: " + this.this$0.mService);
                try {
                    this.this$0.mServiceLock.writeLock().lock();
                    this.this$0.mService = null;
                    if (this.this$0.mLeScanClients != null) {
                        this.this$0.mLeScanClients.clear();
                    }
                    if (sBluetoothLeAdvertiser != null) {
                        sBluetoothLeAdvertiser.cleanup();
                    }
                    if (sBluetoothLeScanner != null) {
                        sBluetoothLeScanner.cleanup();
                    }
                }
                finally {
                    this.this$0.mServiceLock.writeLock().unlock();
                }
                ArrayList arrayList = this.this$0.mProxyServiceStateCallbacks;
                synchronized (arrayList) {
                    for (IBluetoothManagerCallback cb : this.this$0.mProxyServiceStateCallbacks) {
                        try {
                            if (cb != null) {
                                cb.onBluetoothServiceDown();
                                continue;
                            }
                            Log.d("BluetoothAdapter", "onBluetoothServiceDown: cb is null!");
                        }
                        catch (Exception e) {
                            Log.e("BluetoothAdapter", "", e);
                        }
                    }
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothAdapter_1$onBrEdrDown() {
            }

            private void __constructor__(BluetoothAdapter bluetoothAdapter) {
                this.$$robo$$android_bluetooth_BluetoothAdapter_1$__constructor__(bluetoothAdapter);
            }
            {
                this.this$0 = bluetoothAdapter;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothAdapter_1$__constructor__(android.bluetooth.BluetoothAdapter ), this, bluetoothAdapter);
            }

            @Override
            public void onBluetoothServiceUp(IBluetooth iBluetooth) {
                InvokeDynamicSupport.bootstrap("onBluetoothServiceUp", $$robo$$android_bluetooth_BluetoothAdapter_1$onBluetoothServiceUp(android.bluetooth.IBluetooth ), this, iBluetooth);
            }

            @Override
            public void onBluetoothServiceDown() {
                InvokeDynamicSupport.bootstrap("onBluetoothServiceDown", $$robo$$android_bluetooth_BluetoothAdapter_1$onBluetoothServiceDown(), this);
            }

            @Override
            public void onBrEdrDown() {
                InvokeDynamicSupport.bootstrap("onBrEdrDown", $$robo$$android_bluetooth_BluetoothAdapter_1$onBrEdrDown(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mProxyServiceStateCallbacks = new ArrayList();
        if (managerService == null) {
            throw new IllegalArgumentException("bluetooth manager service is null");
        }
        try {
            this.mServiceLock.writeLock().lock();
            this.mService = managerService.registerAdapter(this.mManagerCallback);
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.writeLock().unlock();
        }
        this.mManagerService = managerService;
        this.mLeScanClients = new HashMap<LeScanCallback, ScanCallback>();
        this.mToken = new Binder();
    }

    private final BluetoothDevice $$robo$$android_bluetooth_BluetoothAdapter$getRemoteDevice(String address) {
        return new BluetoothDevice(address);
    }

    private final BluetoothDevice $$robo$$android_bluetooth_BluetoothAdapter$getRemoteDevice(byte[] address) {
        if (address == null || address.length != 6) {
            throw new IllegalArgumentException("Bluetooth address must have 6 bytes");
        }
        return new BluetoothDevice(String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BluetoothLeAdvertiser $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothLeAdvertiser() {
        if (!this.getLeAccess()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (sBluetoothLeAdvertiser == null) {
                sBluetoothLeAdvertiser = new BluetoothLeAdvertiser(this.mManagerService);
            }
        }
        return sBluetoothLeAdvertiser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PeriodicAdvertisingManager $$robo$$android_bluetooth_BluetoothAdapter$getPeriodicAdvertisingManager() {
        if (!this.getLeAccess()) {
            return null;
        }
        if (!this.isLePeriodicAdvertisingSupported()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (sPeriodicAdvertisingManager == null) {
                sPeriodicAdvertisingManager = new PeriodicAdvertisingManager(this.mManagerService);
            }
        }
        return sPeriodicAdvertisingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BluetoothLeScanner $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothLeScanner() {
        if (!this.getLeAccess()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (sBluetoothLeScanner == null) {
                sBluetoothLeScanner = new BluetoothLeScanner(this.mManagerService);
            }
        }
        return sBluetoothLeScanner;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isEnabled() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isEnabled();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isLeEnabled() {
        int state = this.getLeState();
        Log.d("BluetoothAdapter", "isLeEnabled(): " + BluetoothAdapter.nameForState(state));
        return state == 12 || state == 15;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$disableBLE() {
        if (!this.isBleScanAlwaysAvailable()) {
            return false;
        }
        int state = this.getLeState();
        if (state == 12 || state == 15) {
            String packageName = ActivityThread.currentPackageName();
            Log.d("BluetoothAdapter", "disableBLE(): de-registering " + packageName);
            try {
                this.mManagerService.updateBleAppCount(this.mToken, false, packageName);
            }
            catch (RemoteException e) {
                Log.e("BluetoothAdapter", "", e);
            }
            return true;
        }
        Log.d("BluetoothAdapter", "disableBLE(): Already disabled");
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$enableBLE() {
        if (!this.isBleScanAlwaysAvailable()) {
            return false;
        }
        try {
            String packageName = ActivityThread.currentPackageName();
            this.mManagerService.updateBleAppCount(this.mToken, true, packageName);
            if (this.isLeEnabled()) {
                Log.d("BluetoothAdapter", "enableBLE(): Bluetooth already enabled");
                return true;
            }
            Log.d("BluetoothAdapter", "enableBLE(): Calling enable");
            return this.mManagerService.enable(packageName);
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return false;
        }
    }

    private final int $$robo$$android_bluetooth_BluetoothAdapter$getState() {
        int state = 10;
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                state = this.mService.getState();
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        if (state == 15 || state == 14 || state == 16) {
            state = 10;
        }
        return state;
    }

    private final int $$robo$$android_bluetooth_BluetoothAdapter$getLeState() {
        int state = 10;
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                state = this.mService.getState();
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return state;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$getLeAccess() {
        if (this.getLeState() == 12) {
            return true;
        }
        return this.getLeState() == 15;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$enable() {
        if (this.isEnabled()) {
            Log.d("BluetoothAdapter", "enable(): BT already enabled!");
            return true;
        }
        try {
            return this.mManagerService.enable(ActivityThread.currentPackageName());
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$disable() {
        try {
            return this.mManagerService.disable(ActivityThread.currentPackageName(), true);
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$disable(boolean persist) {
        try {
            return this.mManagerService.disable(ActivityThread.currentPackageName(), persist);
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return false;
        }
    }

    private final String $$robo$$android_bluetooth_BluetoothAdapter$getAddress() {
        try {
            return this.mManagerService.getAddress();
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return null;
        }
    }

    private final String $$robo$$android_bluetooth_BluetoothAdapter$getName() {
        try {
            return this.mManagerService.getName();
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return null;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$factoryReset() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.factoryReset();
                return bl;
            }
            SystemProperties.set("persist.bluetooth.factoryreset", "true");
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final ParcelUuid[] $$robo$$android_bluetooth_BluetoothAdapter$getUuids() {
        if (this.getState() != 12) {
            return null;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                ParcelUuid[] parcelUuidArray = this.mService.getUuids();
                return parcelUuidArray;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$setName(String name) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setName(name);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothAdapter$getScanMode() {
        if (this.getState() != 12) {
            return 20;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getScanMode();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$setScanMode(int mode, int duration) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setScanMode(mode, duration);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$setScanMode(int mode) {
        if (this.getState() != 12) {
            return false;
        }
        return this.setScanMode(mode, this.getDiscoverableTimeout());
    }

    private final int $$robo$$android_bluetooth_BluetoothAdapter$getDiscoverableTimeout() {
        if (this.getState() != 12) {
            return -1;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getDiscoverableTimeout();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1;
    }

    private final void $$robo$$android_bluetooth_BluetoothAdapter$setDiscoverableTimeout(int timeout) {
        if (this.getState() != 12) {
            return;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                this.mService.setDiscoverableTimeout(timeout);
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final long $$robo$$android_bluetooth_BluetoothAdapter$getDiscoveryEndMillis() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                long l = this.mService.getDiscoveryEndMillis();
                return l;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1L;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$startDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.startDiscovery();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$cancelDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.cancelDiscovery();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isDiscovering() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isDiscovering();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isMultipleAdvertisementSupported() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isMultiAdvertisementSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "failed to get isMultipleAdvertisementSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isBleScanAlwaysAvailable() {
        try {
            return this.mManagerService.isBleScanAlwaysAvailable();
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "remote expection when calling isBleScanAlwaysAvailable", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isOffloadedFilteringSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isOffloadedFilteringSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "failed to get isOffloadedFilteringSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isOffloadedScanBatchingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isOffloadedScanBatchingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "failed to get isOffloadedScanBatchingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isLe2MPhySupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLe2MPhySupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "failed to get isExtendedAdvertisingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isLeCodedPhySupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLeCodedPhySupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "failed to get isLeCodedPhySupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isLeExtendedAdvertisingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLeExtendedAdvertisingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "failed to get isLeExtendedAdvertisingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isLePeriodicAdvertisingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLePeriodicAdvertisingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "failed to get isLePeriodicAdvertisingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothAdapter$getLeMaximumAdvertisingDataLength() {
        if (!this.getLeAccess()) {
            return 0;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getLeMaximumAdvertisingDataLength();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "failed to get getLeMaximumAdvertisingDataLength, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$isHardwareTrackingFiltersAvailable() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
            if (iGatt == null) {
                return false;
            }
            return iGatt.numHwTrackFiltersAvailable() != 0;
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return false;
        }
    }

    @Deprecated
    private final BluetoothActivityEnergyInfo $$robo$$android_bluetooth_BluetoothAdapter$getControllerActivityEnergyInfo(int updateType) {
        SynchronousResultReceiver receiver = new SynchronousResultReceiver();
        this.requestControllerActivityEnergyInfo(receiver);
        try {
            SynchronousResultReceiver.Result result = receiver.awaitResult(1000L);
            if (result.bundle != null) {
                return (BluetoothActivityEnergyInfo)result.bundle.getParcelable("controller_activity");
            }
        }
        catch (TimeoutException e) {
            Log.e("BluetoothAdapter", "getControllerActivityEnergyInfo timed out");
        }
        return null;
    }

    private final void $$robo$$android_bluetooth_BluetoothAdapter$requestControllerActivityEnergyInfo(ResultReceiver result) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                this.mService.requestActivityInfo(result);
                result = null;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "getControllerActivityEnergyInfoCallback: " + e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
            if (result != null) {
                result.send(0, null);
            }
        }
    }

    private final Set<BluetoothDevice> $$robo$$android_bluetooth_BluetoothAdapter$getBondedDevices() {
        if (this.getState() != 12) {
            return this.toDeviceSet(new BluetoothDevice[0]);
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                Set<BluetoothDevice> set = this.toDeviceSet(this.mService.getBondedDevices());
                return set;
            }
            Set<BluetoothDevice> set = this.toDeviceSet(new BluetoothDevice[0]);
            return set;
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Integer> $$robo$$android_bluetooth_BluetoothAdapter$getSupportedProfiles() {
        ArrayList<Integer> supportedProfiles = new ArrayList<Integer>();
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    long supportedProfilesBitMask = this.mService.getSupportedProfiles();
                    for (int i = 0; i <= 19; ++i) {
                        if ((supportedProfilesBitMask & (long)(1 << i)) == 0L) continue;
                        supportedProfiles.add(i);
                    }
                }
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "getSupportedProfiles:", e);
        }
        return supportedProfiles;
    }

    private final int $$robo$$android_bluetooth_BluetoothAdapter$getConnectionState() {
        if (this.getState() != 12) {
            return 0;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getAdapterConnectionState();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "getConnectionState:", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    private final int $$robo$$android_bluetooth_BluetoothAdapter$getProfileConnectionState(int profile) {
        if (this.getState() != 12) {
            return 0;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getProfileConnectionState(profile);
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "getProfileConnectionState:", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingRfcommOn(int channel) throws IOException {
        return this.listenUsingRfcommOn(channel, false, false);
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingRfcommOn(int channel, boolean mitm, boolean min16DigitPin) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, true, true, channel, mitm, min16DigitPin);
        int errno = socket.mSocket.bindListen();
        if (channel == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, true, true);
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingInsecureRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, false);
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingEncryptedRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, true);
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$createNewRfcommSocketAndRecord(String name, UUID uuid, boolean auth, boolean encrypt) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, auth, encrypt, new ParcelUuid(uuid));
        socket.setServiceName(name);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingInsecureRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, false, port);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingEncryptedRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, true, port);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno < 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    private static final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingScoOn() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(2, false, false, -1);
        int errno = socket.mSocket.bindListen();
        if (errno < 0) {
            // empty if block
        }
        return socket;
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingL2capOn(int port, boolean mitm, boolean min16DigitPin) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(3, true, true, port, mitm, min16DigitPin);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingL2capOn(int port) throws IOException {
        return this.listenUsingL2capOn(port, false, false);
    }

    private final BluetoothServerSocket $$robo$$android_bluetooth_BluetoothAdapter$listenUsingInsecureL2capOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(3, false, false, port, false, false);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    private final Pair<byte[], byte[]> $$robo$$android_bluetooth_BluetoothAdapter$readOutOfBandData() {
        return null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$getProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        if (context == null || listener == null) {
            return false;
        }
        if (profile == 1) {
            BluetoothHeadset headset = new BluetoothHeadset(context, listener);
            return true;
        }
        if (profile == 2) {
            BluetoothA2dp a2dp = new BluetoothA2dp(context, listener);
            return true;
        }
        if (profile == 11) {
            BluetoothA2dpSink a2dpSink = new BluetoothA2dpSink(context, listener);
            return true;
        }
        if (profile == 12) {
            BluetoothAvrcpController avrcp = new BluetoothAvrcpController(context, listener);
            return true;
        }
        if (profile == 4) {
            BluetoothInputDevice iDev = new BluetoothInputDevice(context, listener);
            return true;
        }
        if (profile == 5) {
            BluetoothPan pan = new BluetoothPan(context, listener);
            return true;
        }
        if (profile == 3) {
            BluetoothHealth health = new BluetoothHealth(context, listener);
            return true;
        }
        if (profile == 9) {
            BluetoothMap map = new BluetoothMap(context, listener);
            return true;
        }
        if (profile == 16) {
            BluetoothHeadsetClient headsetClient = new BluetoothHeadsetClient(context, listener);
            return true;
        }
        if (profile == 10) {
            BluetoothSap sap = new BluetoothSap(context, listener);
            return true;
        }
        if (profile == 17) {
            BluetoothPbapClient pbapClient = new BluetoothPbapClient(context, listener);
            return true;
        }
        if (profile == 18) {
            BluetoothMapClient mapClient = new BluetoothMapClient(context, listener);
            return true;
        }
        if (profile == 19) {
            BluetoothInputHost iHost = new BluetoothInputHost(context, listener);
            return true;
        }
        return false;
    }

    private final void $$robo$$android_bluetooth_BluetoothAdapter$closeProfileProxy(int profile, BluetoothProfile proxy) {
        if (proxy == null) {
            return;
        }
        switch (profile) {
            case 1: {
                BluetoothHeadset headset = (BluetoothHeadset)proxy;
                headset.close();
                break;
            }
            case 2: {
                BluetoothA2dp a2dp = (BluetoothA2dp)proxy;
                a2dp.close();
                break;
            }
            case 11: {
                BluetoothA2dpSink a2dpSink = (BluetoothA2dpSink)proxy;
                a2dpSink.close();
                break;
            }
            case 12: {
                BluetoothAvrcpController avrcp = (BluetoothAvrcpController)proxy;
                avrcp.close();
                break;
            }
            case 4: {
                BluetoothInputDevice iDev = (BluetoothInputDevice)proxy;
                iDev.close();
                break;
            }
            case 5: {
                BluetoothPan pan = (BluetoothPan)proxy;
                pan.close();
                break;
            }
            case 3: {
                BluetoothHealth health = (BluetoothHealth)proxy;
                health.close();
                break;
            }
            case 7: {
                BluetoothGatt gatt = (BluetoothGatt)proxy;
                gatt.close();
                break;
            }
            case 8: {
                BluetoothGattServer gattServer = (BluetoothGattServer)proxy;
                gattServer.close();
                break;
            }
            case 9: {
                BluetoothMap map = (BluetoothMap)proxy;
                map.close();
                break;
            }
            case 16: {
                BluetoothHeadsetClient headsetClient = (BluetoothHeadsetClient)proxy;
                headsetClient.close();
                break;
            }
            case 10: {
                BluetoothSap sap = (BluetoothSap)proxy;
                sap.close();
                break;
            }
            case 17: {
                BluetoothPbapClient pbapClient = (BluetoothPbapClient)proxy;
                pbapClient.close();
                break;
            }
            case 18: {
                BluetoothMapClient mapClient = (BluetoothMapClient)proxy;
                mapClient.close();
                break;
            }
            case 19: {
                BluetoothInputHost iHost = (BluetoothInputHost)proxy;
                iHost.close();
            }
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$enableNoAutoConnect() {
        if (this.isEnabled()) {
            Log.d("BluetoothAdapter", "enableNoAutoConnect(): BT already enabled!");
            return true;
        }
        try {
            return this.mManagerService.enableNoAutoConnect(ActivityThread.currentPackageName());
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$changeApplicationBluetoothState(boolean on, BluetoothStateChangeCallback callback) {
        return false;
    }

    private final Set<BluetoothDevice> $$robo$$android_bluetooth_BluetoothAdapter$toDeviceSet(BluetoothDevice[] devices) {
        HashSet<BluetoothDevice> deviceSet = new HashSet<BluetoothDevice>(Arrays.asList(devices));
        return Collections.unmodifiableSet(deviceSet);
    }

    private final void $$robo$$android_bluetooth_BluetoothAdapter$finalize() throws Throwable {
        try {
            this.mManagerService.unregisterAdapter(this.mManagerCallback);
        }
        catch (RemoteException e) {
            Log.e("BluetoothAdapter", "", e);
        }
        finally {
            super.finalize();
        }
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothAdapter$checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    private final IBluetoothManager $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothManager() {
        return this.mManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IBluetooth $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothService(IBluetoothManagerCallback cb) {
        ArrayList<IBluetoothManagerCallback> arrayList = this.mProxyServiceStateCallbacks;
        synchronized (arrayList) {
            if (cb == null) {
                Log.w("BluetoothAdapter", "getBluetoothService() called with no BluetoothManagerCallback");
            } else if (!this.mProxyServiceStateCallbacks.contains(cb)) {
                this.mProxyServiceStateCallbacks.add(cb);
            }
        }
        return this.mService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothAdapter$removeServiceStateCallback(IBluetoothManagerCallback cb) {
        ArrayList<IBluetoothManagerCallback> arrayList = this.mProxyServiceStateCallbacks;
        synchronized (arrayList) {
            this.mProxyServiceStateCallbacks.remove(cb);
        }
    }

    @Deprecated
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$startLeScan(LeScanCallback callback) {
        return this.startLeScan(null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final boolean $$robo$$android_bluetooth_BluetoothAdapter$startLeScan(UUID[] serviceUuids, LeScanCallback callback) {
        Log.d("BluetoothAdapter", "startLeScan(): " + Arrays.toString(serviceUuids));
        if (callback == null) {
            Log.e("BluetoothAdapter", "startLeScan: null callback");
            return false;
        }
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            Log.e("BluetoothAdapter", "startLeScan: cannot get BluetoothLeScanner");
            return false;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            if (this.mLeScanClients.containsKey(callback)) {
                Log.e("BluetoothAdapter", "LE Scan has already started");
                return false;
            }
            try {
                IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
                if (iGatt == null) {
                    return false;
                }
                ShadowedObject scanCallback = new ShadowedObject(this, serviceUuids, callback){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ UUID[] val$serviceUuids;
                    /* synthetic */ LeScanCallback val$callback;
                    /* synthetic */ BluetoothAdapter this$0;

                    private void $$robo$$android_bluetooth_BluetoothAdapter_2$__constructor__(BluetoothAdapter this$0, UUID[] uUIDArray, LeScanCallback leScanCallback) {
                        this.val$serviceUuids = uUIDArray;
                        this.val$callback = leScanCallback;
                    }

                    private final void $$robo$$android_bluetooth_BluetoothAdapter_2$onScanResult(int callbackType, ScanResult result) {
                        if (callbackType != 1) {
                            Log.e("BluetoothAdapter", "LE Scan has already started");
                            return;
                        }
                        ScanRecord scanRecord = result.getScanRecord();
                        if (scanRecord == null) {
                            return;
                        }
                        if (this.val$serviceUuids != null) {
                            ArrayList<ParcelUuid> uuids = new ArrayList<ParcelUuid>();
                            for (UUID uuid : this.val$serviceUuids) {
                                uuids.add(new ParcelUuid(uuid));
                            }
                            List<ParcelUuid> scanServiceUuids = scanRecord.getServiceUuids();
                            if (scanServiceUuids == null || !scanServiceUuids.containsAll(uuids)) {
                                Log.d("BluetoothAdapter", "uuids does not match");
                                return;
                            }
                        }
                        this.val$callback.onLeScan(result.getDevice(), result.getRssi(), scanRecord.getBytes());
                    }

                    private void __constructor__(BluetoothAdapter bluetoothAdapter, UUID[] uUIDArray, LeScanCallback leScanCallback) {
                        this.$$robo$$android_bluetooth_BluetoothAdapter_2$__constructor__(bluetoothAdapter, uUIDArray, leScanCallback);
                    }
                    {
                        this.this$0 = bluetoothAdapter;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothAdapter_2$__constructor__(android.bluetooth.BluetoothAdapter java.util.UUID[] android.bluetooth.BluetoothAdapter$LeScanCallback ), this, bluetoothAdapter, uUIDArray, leScanCallback);
                    }

                    @Override
                    public void onScanResult(int n, ScanResult scanResult) {
                        InvokeDynamicSupport.bootstrap("onScanResult", $$robo$$android_bluetooth_BluetoothAdapter_2$onScanResult(int android.bluetooth.le.ScanResult ), this, n, scanResult);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                ScanSettings settings = new ScanSettings.Builder().setCallbackType(1).setScanMode(2).build();
                ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
                if (serviceUuids != null && serviceUuids.length > 0) {
                    ScanFilter filter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(serviceUuids[0])).build();
                    filters.add(filter);
                }
                scanner.startScan(filters, settings, (ScanCallback)scanCallback);
                this.mLeScanClients.put(callback, (ScanCallback)scanCallback);
                return true;
            }
            catch (RemoteException e) {
                Log.e("BluetoothAdapter", "", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final void $$robo$$android_bluetooth_BluetoothAdapter$stopLeScan(LeScanCallback callback) {
        Log.d("BluetoothAdapter", "stopLeScan()");
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            return;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            ScanCallback scanCallback = this.mLeScanClients.remove(callback);
            if (scanCallback == null) {
                Log.d("BluetoothAdapter", "scan not started yet");
                return;
            }
            scanner.stopScan(scanCallback);
        }
    }

    public static String nameForState(int n) {
        return InvokeDynamicSupport.bootstrapStatic("nameForState", $$robo$$android_bluetooth_BluetoothAdapter$nameForState(int ), (int)n);
    }

    public static synchronized BluetoothAdapter getDefaultAdapter() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultAdapter", $$robo$$android_bluetooth_BluetoothAdapter$getDefaultAdapter());
    }

    private void __constructor__(IBluetoothManager iBluetoothManager) {
        this.$$robo$$android_bluetooth_BluetoothAdapter$__constructor__(iBluetoothManager);
    }

    public BluetoothAdapter(IBluetoothManager iBluetoothManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothAdapter$__constructor__(android.bluetooth.IBluetoothManager ), this, iBluetoothManager);
    }

    public BluetoothDevice getRemoteDevice(String string2) {
        return InvokeDynamicSupport.bootstrap("getRemoteDevice", $$robo$$android_bluetooth_BluetoothAdapter$getRemoteDevice(java.lang.String ), this, string2);
    }

    public BluetoothDevice getRemoteDevice(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("getRemoteDevice", $$robo$$android_bluetooth_BluetoothAdapter$getRemoteDevice(byte[] ), this, byArray);
    }

    public BluetoothLeAdvertiser getBluetoothLeAdvertiser() {
        return InvokeDynamicSupport.bootstrap("getBluetoothLeAdvertiser", $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothLeAdvertiser(), this);
    }

    public PeriodicAdvertisingManager getPeriodicAdvertisingManager() {
        return InvokeDynamicSupport.bootstrap("getPeriodicAdvertisingManager", $$robo$$android_bluetooth_BluetoothAdapter$getPeriodicAdvertisingManager(), this);
    }

    public BluetoothLeScanner getBluetoothLeScanner() {
        return InvokeDynamicSupport.bootstrap("getBluetoothLeScanner", $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothLeScanner(), this);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothAdapter$isEnabled(), this);
    }

    public boolean isLeEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLeEnabled", $$robo$$android_bluetooth_BluetoothAdapter$isLeEnabled(), this);
    }

    public boolean disableBLE() {
        return (boolean)InvokeDynamicSupport.bootstrap("disableBLE", $$robo$$android_bluetooth_BluetoothAdapter$disableBLE(), this);
    }

    public boolean enableBLE() {
        return (boolean)InvokeDynamicSupport.bootstrap("enableBLE", $$robo$$android_bluetooth_BluetoothAdapter$enableBLE(), this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_bluetooth_BluetoothAdapter$getState(), this);
    }

    public int getLeState() {
        return (int)InvokeDynamicSupport.bootstrap("getLeState", $$robo$$android_bluetooth_BluetoothAdapter$getLeState(), this);
    }

    boolean getLeAccess() {
        return (boolean)InvokeDynamicSupport.bootstrap("getLeAccess", $$robo$$android_bluetooth_BluetoothAdapter$getLeAccess(), this);
    }

    public boolean enable() {
        return (boolean)InvokeDynamicSupport.bootstrap("enable", $$robo$$android_bluetooth_BluetoothAdapter$enable(), this);
    }

    public boolean disable() {
        return (boolean)InvokeDynamicSupport.bootstrap("disable", $$robo$$android_bluetooth_BluetoothAdapter$disable(), this);
    }

    public boolean disable(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("disable", $$robo$$android_bluetooth_BluetoothAdapter$disable(boolean ), this, bl);
    }

    public String getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_bluetooth_BluetoothAdapter$getAddress(), this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_bluetooth_BluetoothAdapter$getName(), this);
    }

    public boolean factoryReset() {
        return (boolean)InvokeDynamicSupport.bootstrap("factoryReset", $$robo$$android_bluetooth_BluetoothAdapter$factoryReset(), this);
    }

    public ParcelUuid[] getUuids() {
        return InvokeDynamicSupport.bootstrap("getUuids", $$robo$$android_bluetooth_BluetoothAdapter$getUuids(), this);
    }

    public boolean setName(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setName", $$robo$$android_bluetooth_BluetoothAdapter$setName(java.lang.String ), this, string2);
    }

    public int getScanMode() {
        return (int)InvokeDynamicSupport.bootstrap("getScanMode", $$robo$$android_bluetooth_BluetoothAdapter$getScanMode(), this);
    }

    public boolean setScanMode(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setScanMode", $$robo$$android_bluetooth_BluetoothAdapter$setScanMode(int int ), this, n, n2);
    }

    public boolean setScanMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setScanMode", $$robo$$android_bluetooth_BluetoothAdapter$setScanMode(int ), this, n);
    }

    public int getDiscoverableTimeout() {
        return (int)InvokeDynamicSupport.bootstrap("getDiscoverableTimeout", $$robo$$android_bluetooth_BluetoothAdapter$getDiscoverableTimeout(), this);
    }

    public void setDiscoverableTimeout(int n) {
        InvokeDynamicSupport.bootstrap("setDiscoverableTimeout", $$robo$$android_bluetooth_BluetoothAdapter$setDiscoverableTimeout(int ), this, n);
    }

    public long getDiscoveryEndMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getDiscoveryEndMillis", $$robo$$android_bluetooth_BluetoothAdapter$getDiscoveryEndMillis(), this);
    }

    public boolean startDiscovery() {
        return (boolean)InvokeDynamicSupport.bootstrap("startDiscovery", $$robo$$android_bluetooth_BluetoothAdapter$startDiscovery(), this);
    }

    public boolean cancelDiscovery() {
        return (boolean)InvokeDynamicSupport.bootstrap("cancelDiscovery", $$robo$$android_bluetooth_BluetoothAdapter$cancelDiscovery(), this);
    }

    public boolean isDiscovering() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDiscovering", $$robo$$android_bluetooth_BluetoothAdapter$isDiscovering(), this);
    }

    public boolean isMultipleAdvertisementSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultipleAdvertisementSupported", $$robo$$android_bluetooth_BluetoothAdapter$isMultipleAdvertisementSupported(), this);
    }

    public boolean isBleScanAlwaysAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBleScanAlwaysAvailable", $$robo$$android_bluetooth_BluetoothAdapter$isBleScanAlwaysAvailable(), this);
    }

    public boolean isOffloadedFilteringSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOffloadedFilteringSupported", $$robo$$android_bluetooth_BluetoothAdapter$isOffloadedFilteringSupported(), this);
    }

    public boolean isOffloadedScanBatchingSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOffloadedScanBatchingSupported", $$robo$$android_bluetooth_BluetoothAdapter$isOffloadedScanBatchingSupported(), this);
    }

    public boolean isLe2MPhySupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLe2MPhySupported", $$robo$$android_bluetooth_BluetoothAdapter$isLe2MPhySupported(), this);
    }

    public boolean isLeCodedPhySupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLeCodedPhySupported", $$robo$$android_bluetooth_BluetoothAdapter$isLeCodedPhySupported(), this);
    }

    public boolean isLeExtendedAdvertisingSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLeExtendedAdvertisingSupported", $$robo$$android_bluetooth_BluetoothAdapter$isLeExtendedAdvertisingSupported(), this);
    }

    public boolean isLePeriodicAdvertisingSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLePeriodicAdvertisingSupported", $$robo$$android_bluetooth_BluetoothAdapter$isLePeriodicAdvertisingSupported(), this);
    }

    public int getLeMaximumAdvertisingDataLength() {
        return (int)InvokeDynamicSupport.bootstrap("getLeMaximumAdvertisingDataLength", $$robo$$android_bluetooth_BluetoothAdapter$getLeMaximumAdvertisingDataLength(), this);
    }

    public boolean isHardwareTrackingFiltersAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareTrackingFiltersAvailable", $$robo$$android_bluetooth_BluetoothAdapter$isHardwareTrackingFiltersAvailable(), this);
    }

    @Deprecated
    public BluetoothActivityEnergyInfo getControllerActivityEnergyInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getControllerActivityEnergyInfo", $$robo$$android_bluetooth_BluetoothAdapter$getControllerActivityEnergyInfo(int ), this, n);
    }

    public void requestControllerActivityEnergyInfo(ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("requestControllerActivityEnergyInfo", $$robo$$android_bluetooth_BluetoothAdapter$requestControllerActivityEnergyInfo(android.os.ResultReceiver ), this, resultReceiver);
    }

    public Set<BluetoothDevice> getBondedDevices() {
        return InvokeDynamicSupport.bootstrap("getBondedDevices", $$robo$$android_bluetooth_BluetoothAdapter$getBondedDevices(), this);
    }

    public List<Integer> getSupportedProfiles() {
        return InvokeDynamicSupport.bootstrap("getSupportedProfiles", $$robo$$android_bluetooth_BluetoothAdapter$getSupportedProfiles(), this);
    }

    public int getConnectionState() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothAdapter$getConnectionState(), this);
    }

    public int getProfileConnectionState(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getProfileConnectionState", $$robo$$android_bluetooth_BluetoothAdapter$getProfileConnectionState(int ), this, n);
    }

    public BluetoothServerSocket listenUsingRfcommOn(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingRfcommOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingRfcommOn(int ), this, n);
    }

    public BluetoothServerSocket listenUsingRfcommOn(int n, boolean bl, boolean bl2) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingRfcommOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingRfcommOn(int boolean boolean ), this, n, bl, bl2);
    }

    public BluetoothServerSocket listenUsingRfcommWithServiceRecord(String string2, UUID uUID) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingRfcommWithServiceRecord", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingRfcommWithServiceRecord(java.lang.String java.util.UUID ), this, string2, uUID);
    }

    public BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String string2, UUID uUID) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingInsecureRfcommWithServiceRecord", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingInsecureRfcommWithServiceRecord(java.lang.String java.util.UUID ), this, string2, uUID);
    }

    public BluetoothServerSocket listenUsingEncryptedRfcommWithServiceRecord(String string2, UUID uUID) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingEncryptedRfcommWithServiceRecord", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingEncryptedRfcommWithServiceRecord(java.lang.String java.util.UUID ), this, string2, uUID);
    }

    private BluetoothServerSocket createNewRfcommSocketAndRecord(String string2, UUID uUID, boolean bl, boolean bl2) throws IOException {
        return InvokeDynamicSupport.bootstrap("createNewRfcommSocketAndRecord", $$robo$$android_bluetooth_BluetoothAdapter$createNewRfcommSocketAndRecord(java.lang.String java.util.UUID boolean boolean ), this, string2, uUID, bl, bl2);
    }

    public BluetoothServerSocket listenUsingInsecureRfcommOn(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingInsecureRfcommOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingInsecureRfcommOn(int ), this, n);
    }

    public BluetoothServerSocket listenUsingEncryptedRfcommOn(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingEncryptedRfcommOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingEncryptedRfcommOn(int ), this, n);
    }

    public static BluetoothServerSocket listenUsingScoOn() throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("listenUsingScoOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingScoOn());
    }

    public BluetoothServerSocket listenUsingL2capOn(int n, boolean bl, boolean bl2) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingL2capOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingL2capOn(int boolean boolean ), this, n, bl, bl2);
    }

    public BluetoothServerSocket listenUsingL2capOn(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingL2capOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingL2capOn(int ), this, n);
    }

    public BluetoothServerSocket listenUsingInsecureL2capOn(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("listenUsingInsecureL2capOn", $$robo$$android_bluetooth_BluetoothAdapter$listenUsingInsecureL2capOn(int ), this, n);
    }

    public Pair<byte[], byte[]> readOutOfBandData() {
        return InvokeDynamicSupport.bootstrap("readOutOfBandData", $$robo$$android_bluetooth_BluetoothAdapter$readOutOfBandData(), this);
    }

    public boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener serviceListener, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getProfileProxy", $$robo$$android_bluetooth_BluetoothAdapter$getProfileProxy(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener int ), this, context, serviceListener, n);
    }

    public void closeProfileProxy(int n, BluetoothProfile bluetoothProfile) {
        InvokeDynamicSupport.bootstrap("closeProfileProxy", $$robo$$android_bluetooth_BluetoothAdapter$closeProfileProxy(int android.bluetooth.BluetoothProfile ), this, n, bluetoothProfile);
    }

    public boolean enableNoAutoConnect() {
        return (boolean)InvokeDynamicSupport.bootstrap("enableNoAutoConnect", $$robo$$android_bluetooth_BluetoothAdapter$enableNoAutoConnect(), this);
    }

    public boolean changeApplicationBluetoothState(boolean bl, BluetoothStateChangeCallback bluetoothStateChangeCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("changeApplicationBluetoothState", $$robo$$android_bluetooth_BluetoothAdapter$changeApplicationBluetoothState(boolean android.bluetooth.BluetoothAdapter$BluetoothStateChangeCallback ), this, bl, bluetoothStateChangeCallback);
    }

    private Set<BluetoothDevice> toDeviceSet(BluetoothDevice[] bluetoothDeviceArray) {
        return InvokeDynamicSupport.bootstrap("toDeviceSet", $$robo$$android_bluetooth_BluetoothAdapter$toDeviceSet(android.bluetooth.BluetoothDevice[] ), this, bluetoothDeviceArray);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothAdapter$finalize(), this);
    }

    public static boolean checkBluetoothAddress(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkBluetoothAddress", $$robo$$android_bluetooth_BluetoothAdapter$checkBluetoothAddress(java.lang.String ), (String)string2);
    }

    IBluetoothManager getBluetoothManager() {
        return InvokeDynamicSupport.bootstrap("getBluetoothManager", $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothManager(), this);
    }

    IBluetooth getBluetoothService(IBluetoothManagerCallback iBluetoothManagerCallback) {
        return InvokeDynamicSupport.bootstrap("getBluetoothService", $$robo$$android_bluetooth_BluetoothAdapter$getBluetoothService(android.bluetooth.IBluetoothManagerCallback ), this, iBluetoothManagerCallback);
    }

    void removeServiceStateCallback(IBluetoothManagerCallback iBluetoothManagerCallback) {
        InvokeDynamicSupport.bootstrap("removeServiceStateCallback", $$robo$$android_bluetooth_BluetoothAdapter$removeServiceStateCallback(android.bluetooth.IBluetoothManagerCallback ), this, iBluetoothManagerCallback);
    }

    @Deprecated
    public boolean startLeScan(LeScanCallback leScanCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("startLeScan", $$robo$$android_bluetooth_BluetoothAdapter$startLeScan(android.bluetooth.BluetoothAdapter$LeScanCallback ), this, leScanCallback);
    }

    @Deprecated
    public boolean startLeScan(UUID[] uUIDArray, LeScanCallback leScanCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("startLeScan", $$robo$$android_bluetooth_BluetoothAdapter$startLeScan(java.util.UUID[] android.bluetooth.BluetoothAdapter$LeScanCallback ), this, uUIDArray, leScanCallback);
    }

    @Deprecated
    public void stopLeScan(LeScanCallback leScanCallback) {
        InvokeDynamicSupport.bootstrap("stopLeScan", $$robo$$android_bluetooth_BluetoothAdapter$stopLeScan(android.bluetooth.BluetoothAdapter$LeScanCallback ), this, leScanCallback);
    }

    public /* synthetic */ BluetoothAdapter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothAdapter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface LeScanCallback
    extends InstrumentedInterface {
        public void onLeScan(BluetoothDevice var1, int var2, byte[] var3);
    }

    public class StateChangeCallbackWrapper
    extends IBluetoothStateChangeCallback.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private BluetoothStateChangeCallback mCallback;
        /* synthetic */ BluetoothAdapter this$0;

        private void $$robo$$android_bluetooth_BluetoothAdapter_StateChangeCallbackWrapper$__constructor__(BluetoothAdapter this$0, BluetoothStateChangeCallback callback) {
            this.mCallback = callback;
        }

        private final void $$robo$$android_bluetooth_BluetoothAdapter_StateChangeCallbackWrapper$onBluetoothStateChange(boolean on) {
            this.mCallback.onBluetoothStateChange(on);
        }

        private void __constructor__(BluetoothAdapter bluetoothAdapter, BluetoothStateChangeCallback bluetoothStateChangeCallback) {
            this.$$robo$$android_bluetooth_BluetoothAdapter_StateChangeCallbackWrapper$__constructor__(bluetoothAdapter, bluetoothStateChangeCallback);
        }

        public StateChangeCallbackWrapper(BluetoothAdapter bluetoothAdapter, BluetoothStateChangeCallback bluetoothStateChangeCallback) {
            this.this$0 = bluetoothAdapter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothAdapter_StateChangeCallbackWrapper$__constructor__(android.bluetooth.BluetoothAdapter android.bluetooth.BluetoothAdapter$BluetoothStateChangeCallback ), this, bluetoothAdapter, bluetoothStateChangeCallback);
        }

        @Override
        public void onBluetoothStateChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothAdapter_StateChangeCallbackWrapper$onBluetoothStateChange(boolean ), this, bl);
        }

        public /* synthetic */ StateChangeCallbackWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateChangeCallbackWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface BluetoothStateChangeCallback
    extends InstrumentedInterface {
        public void onBluetoothStateChange(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={20L, 21L, 23L})
    public static @interface ScanMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={10L, 11L, 12L, 13L, 14L, 15L, 16L})
    public static @interface AdapterState {
    }
}

